/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantEmployee;
import com.zbkj.common.model.user.User;
import com.zbkj.common.request.merchant.manage.MerchantEmployeeRequest;
import com.zbkj.common.request.merchant.manage.MerchantEmployeeSearchRequest;
import com.zbkj.common.response.MerchantEmployeeResponse;
import com.zbkj.common.response.employee.EmployeeMerchantActiveResponse;
import com.zbkj.common.response.employee.EmployeeMerchantResponse;
import com.zbkj.common.response.employee.FrontMerchantEmployeeResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.LoginResultCode;
import com.zbkj.common.token.FrontTokenComponent;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.LoginFrontUserVo;
import com.zbkj.service.dao.MerchantEmployeeDao;
import com.zbkj.service.service.MerchantEmployeeService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.UserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantEmployeeServiceImpl
extends ServiceImpl<MerchantEmployeeDao, MerchantEmployee>
implements MerchantEmployeeService {
    @Resource
    private MerchantEmployeeDao dao;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private FrontTokenComponent tokenComponent;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private UserService userService;

    @Override
    public List<MerchantEmployeeResponse> getList(MerchantEmployeeSearchRequest request) {
        PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotEmpty((Object)request.getKeywords())) {
            lambdaQueryWrapper.nested(wr -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wr.like(MerchantEmployee::getPhone, (Object)request.getKeywords())).or()).like(MerchantEmployee::getName, (Object)request.getKeywords());
            });
        }
        if (ObjectUtil.isNotEmpty((Object)request.getStatus())) {
            lambdaQueryWrapper.eq(MerchantEmployee::getStatus, (Object)request.getStatus());
        }
        lambdaQueryWrapper.eq(MerchantEmployee::getMerId, (Object)systemAdmin.getMerId());
        lambdaQueryWrapper.orderByDesc(MerchantEmployee::getId);
        List merchantEmployees = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        ArrayList<MerchantEmployeeResponse> response = new ArrayList<MerchantEmployeeResponse>();
        for (MerchantEmployee employee : merchantEmployees) {
            MerchantEmployeeResponse response1 = new MerchantEmployeeResponse();
            BeanUtils.copyProperties((Object)employee, (Object)response1);
            User user = (User)this.userService.getById(employee.getUid());
            response1.setUserName(user.getNickname());
            response1.setUserAvatar(user.getAvatar());
            response.add(response1);
        }
        return response;
    }

    @Override
    public Boolean addMerchantEmployee(MerchantEmployeeRequest request) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        this.checkEmployeeExistCurrentMerchant(request, systemAdmin);
        MerchantEmployee merchantEmployee = new MerchantEmployee();
        BeanUtils.copyProperties((Object)request, (Object)merchantEmployee);
        merchantEmployee.setAvatar(this.systemAttachmentService.clearPrefix(merchantEmployee.getAvatar()));
        merchantEmployee.setMerId(systemAdmin.getMerId());
        return this.save(merchantEmployee);
    }

    @Override
    public Boolean editMerchantEmployee(MerchantEmployeeRequest request) {
        MerchantEmployee employee = (MerchantEmployee)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)employee)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        MerchantEmployee merchantEmployee = new MerchantEmployee();
        BeanUtils.copyProperties((Object)request, (Object)merchantEmployee);
        merchantEmployee.setAvatar(this.systemAttachmentService.clearPrefix(merchantEmployee.getAvatar()));
        merchantEmployee.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(merchantEmployee);
        if (update && employee.getStatus().equals(1) && !request.getStatus().equals(0)) {
            this.tokenComponent.cleanMerchantUserToken(employee.getUid());
        }
        return update;
    }

    @Override
    public List<MerchantEmployee> getShopMangerByUserId(Integer uid) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(MerchantEmployee::getUid, (Object)uid);
        lambdaQueryWrapper.eq(MerchantEmployee::getStatus, (Object)1);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean checkShopMangerRoleByUserId(Integer roleNo) {
        LoginFrontUserVo userForMerchantEmployee = this.tokenComponent.getUserForMerchantEmployee();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(MerchantEmployee::getUid, (Object)userForMerchantEmployee.getUserId())).eq(MerchantEmployee::getMerId, (Object)userForMerchantEmployee.getActiveMerchant())).eq(MerchantEmployee::getStatus, (Object)Boolean.TRUE)).like(MerchantEmployee::getRole, (Object)roleNo);
        List merchantEmployees = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        if (merchantEmployees.isEmpty()) {
            throw new CrmebException("\u5f53\u524d\u79fb\u52a8\u7aef\u7ba1\u7406\u5458\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        return Boolean.TRUE;
    }

    @Override
    public List<FrontMerchantEmployeeResponse> findBelongList() {
        Integer userId = this.tokenComponent.getUserId();
        if (ObjectUtil.isNull((Object)userId) || userId <= 0) {
            return new ArrayList<FrontMerchantEmployeeResponse>();
        }
        List<MerchantEmployee> merchantEmployeeList = this.getShopMangerByUserId(userId);
        ArrayList<FrontMerchantEmployeeResponse> currentMerchantList = new ArrayList<FrontMerchantEmployeeResponse>();
        merchantEmployeeList.forEach(employee -> {
            Merchant merchant = this.merchantService.getByIdException(employee.getMerId());
            FrontMerchantEmployeeResponse frEmployee = new FrontMerchantEmployeeResponse();
            BeanUtils.copyProperties((Object)employee, (Object)frEmployee);
            EmployeeMerchantResponse employeeMerchant = new EmployeeMerchantResponse();
            BeanUtils.copyProperties((Object)merchant, (Object)employeeMerchant);
            frEmployee.setCurrentMerchant(employeeMerchant);
            currentMerchantList.add(frEmployee);
        });
        return currentMerchantList;
    }

    @Override
    public EmployeeMerchantActiveResponse activeMerchant(Integer merId) {
        Integer userId = this.tokenComponent.getUserId();
        if (ObjectUtil.isNull((Object)userId) || userId <= 0) {
            throw new CrmebException((IResultEnum)LoginResultCode.LOGIN_EXPIRE);
        }
        MerchantEmployee merchantEmployee = this.getByUserIdAndMerId(userId, merId);
        if (ObjectUtil.isNull((Object)merchantEmployee) || merchantEmployee.getStatus().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5e97\u94fa\u7ba1\u7406\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        LoginFrontUserVo userForMerchantEmployee = new LoginFrontUserVo();
        userForMerchantEmployee.setUserId(userId);
        userForMerchantEmployee.setActiveMerchant(merId);
        FrontMerchantEmployeeResponse frEmployee = new FrontMerchantEmployeeResponse();
        BeanUtils.copyProperties((Object)merchantEmployee, (Object)frEmployee);
        EmployeeMerchantResponse employeeMerchant = new EmployeeMerchantResponse();
        Merchant merchant = this.merchantService.getByIdException(merchantEmployee.getMerId());
        BeanUtils.copyProperties((Object)merchant, (Object)employeeMerchant);
        frEmployee.setCurrentMerchant(employeeMerchant);
        ArrayList<FrontMerchantEmployeeResponse> currentMerchantList = new ArrayList<FrontMerchantEmployeeResponse>();
        currentMerchantList.add(frEmployee);
        userForMerchantEmployee.setMerchantEmployeeList(currentMerchantList);
        EmployeeMerchantActiveResponse response = new EmployeeMerchantActiveResponse();
        response.setToken(this.tokenComponent.createFrontMerchantToken(userForMerchantEmployee));
        response.setElectrPrintingSwitch(merchant.getElectrPrintingSwitch());
        return response;
    }

    private MerchantEmployee getByUserIdAndMerId(Integer userId, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantEmployee::getMerId, (Object)merId);
        lqw.eq(MerchantEmployee::getUid, (Object)userId);
        return (MerchantEmployee)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean deleteById(Integer id) {
        MerchantEmployee employee = (MerchantEmployee)this.getById(id);
        if (ObjectUtil.isNull((Object)employee)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        boolean remove = this.removeById(id);
        if (remove) {
            this.tokenComponent.cleanMerchantUserToken(employee.getUid());
        }
        return remove;
    }

    @Override
    public Boolean deleteByUserId(Integer userId) {
        UpdateWrapper updateWrapper = Wrappers.update();
        updateWrapper.eq((Object)"uid", (Object)userId);
        return this.dao.delete((Wrapper)updateWrapper) > 0;
    }

    @Override
    public Boolean isExist(Integer merId, Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantEmployee::getMerId, (Object)merId);
        lqw.eq(MerchantEmployee::getUid, (Object)uid);
        return this.dao.selectCount((Wrapper)lqw) > 0;
    }

    private void checkEmployeeExistCurrentMerchant(MerchantEmployeeRequest request, SystemAdmin systemAdmin) {
        LambdaQueryWrapper queryWrapperExit = Wrappers.lambdaQuery();
        queryWrapperExit.eq(MerchantEmployee::getUid, (Object)request.getUid());
        queryWrapperExit.eq(MerchantEmployee::getMerId, (Object)systemAdmin.getMerId());
        List exitEmployees = this.dao.selectList((Wrapper)queryWrapperExit);
        if (!exitEmployees.isEmpty()) {
            throw new CrmebException("\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u662f\u5f53\u524d\u5e97\u94fa\u7684\u79fb\u52a8\u7aef\u7ba1\u7406\u5458");
        }
    }
}

