/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.record.MerchantDayRecord;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.dao.MerchantDayRecordDao;
import com.zbkj.service.service.MerchantDayRecordService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantDayRecordServiceImpl
extends ServiceImpl<MerchantDayRecordDao, MerchantDayRecord>
implements MerchantDayRecordService {
    @Resource
    private MerchantDayRecordDao dao;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public Integer getVisitorsByDate(Integer merId, String date) {
        if (DateUtil.date().toString("yyyy-MM-dd").equals(date)) {
            return this.getVisitorsByToday(merId, date);
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantDayRecord::getMerId, (Object)merId);
        lqw.eq(MerchantDayRecord::getDate, (Object)date);
        lqw.last(" limit 1");
        MerchantDayRecord merchantDayRecord = (MerchantDayRecord)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchantDayRecord) ? merchantDayRecord.getVisitors() : 0;
    }

    @Override
    public Integer getVisitorsByMerIdsAndDate(List<Integer> merIds, String date) {
        if (DateUtil.date().toString("yyyy-MM-dd").equals(date)) {
            int todayVisitors = 0;
            for (Integer merId : merIds) {
                todayVisitors += this.getVisitorsByToday(merId, date).intValue();
            }
            return todayVisitors;
        }
        return this.dao.getVisitorsByMerIds(merIds, date);
    }

    private Integer getVisitorsByToday(Integer merId, String today) {
        int merchantVisitors = 0;
        Object visitorsObject = this.redisUtil.get(StrUtil.format((CharSequence)"statistics:merchant:visitors:{}:{}", (Object[])new Object[]{today, merId}));
        if (ObjectUtil.isNotNull((Object)visitorsObject)) {
            merchantVisitors = (Integer)visitorsObject;
        }
        return merchantVisitors;
    }
}

