/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.GroupConfigConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.GroupConfig;
import com.zbkj.common.model.user.User;
import com.zbkj.common.request.IntegralIntervalProductRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.IntegralIntervalResponse;
import com.zbkj.common.response.IntegralProductFrontResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.service.service.GroupConfigService;
import com.zbkj.service.service.IntegralShoppingService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegralShoppingServiceImpl
implements IntegralShoppingService {
    @Autowired
    private UserService userService;
    @Autowired
    private GroupConfigService groupConfigService;
    @Autowired
    private ProductService productService;

    @Override
    public MyRecord getUserIntegralInfo() {
        User user = this.userService.getInfo();
        MyRecord record = new MyRecord();
        record.set("integral", (Object)user.getIntegral());
        return record;
    }

    @Override
    public PageInfo<IntegralProductFrontResponse> findProductHotPage(PageParamRequest request) {
        return this.productService.findIntegralProductHotPage(request);
    }

    @Override
    public List<IntegralIntervalResponse> getIntegralIntervalList() {
        List<GroupConfig> configList = this.groupConfigService.findByTag(GroupConfigConstants.TAG_INTEGRAL_INTERVAL, "desc", Boolean.TRUE);
        if (CollUtil.isEmpty(configList)) {
            return new ArrayList<IntegralIntervalResponse>();
        }
        List<IntegralIntervalResponse> responseList = configList.stream().map(config -> {
            IntegralIntervalResponse response = new IntegralIntervalResponse();
            BeanUtils.copyProperties((Object)config, (Object)response);
            return response;
        }).collect(Collectors.toList());
        return responseList;
    }

    @Override
    public PageInfo<IntegralProductFrontResponse> findIntegralIntervalProductPage(IntegralIntervalProductRequest request) {
        int startIntegral = 0;
        int endIntegral = 0;
        if (request.getIntervalId() > 0) {
            GroupConfig groupConfig = this.groupConfigService.getByIdException(request.getIntervalId());
            if (!groupConfig.getTag().equals(GroupConfigConstants.TAG_INTEGRAL_INTERVAL)) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u79ef\u5206\u533a\u95f4\u4e0d\u5b58\u5728");
            }
            String[] split = groupConfig.getValue().split("-");
            startIntegral = Integer.parseInt(split[0]);
            endIntegral = Integer.parseInt(split[1]);
        }
        return this.productService.findIntegralIntervalProductPage(startIntegral, endIntegral, request.getPage(), request.getLimit());
    }
}

