/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.dto.RetailStorePeopleExportDto;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.system.SystemUserLevel;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBrokerageRecord;
import com.zbkj.common.model.user.UserClosing;
import com.zbkj.common.model.user.UserTag;
import com.zbkj.common.request.OrderSearchRequest;
import com.zbkj.common.request.RetailStorePeopleSearchRequest;
import com.zbkj.common.request.UserSearchRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.ExportUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.OrderExcelVo;
import com.zbkj.common.vo.UserExcelVo;
import com.zbkj.service.service.ExportService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.SystemUserLevelService;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserClosingService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTagService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportServiceImpl
implements ExportService {
    @Autowired
    private OrderService orderService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private UserBrokerageRecordService userBrokerageRecordService;
    @Autowired
    private UserClosingService userClosingService;
    @Autowired
    private UserTagService userTagService;
    @Autowired
    private SystemUserLevelService systemUserLevelService;

    @Override
    public String exportOrder(OrderSearchRequest request) {
        List<Order> orderList;
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (systemAdmin.getMerId() > 0) {
            request.setMerId(systemAdmin.getMerId());
        }
        if (CollUtil.isEmpty(orderList = this.orderService.findExportList(request))) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\uff01");
        }
        CrmebUtil.setBusinessDataForFT((int)this.orderService.getAMC(), (int)this.orderService.getAPC(), (int)this.orderService.getAOC());
        List<Integer> merIdList = orderList.stream().filter(e -> e.getMerId() > 0).map(Order::getMerId).distinct().collect(Collectors.toList());
        List<Integer> userIdList = orderList.stream().map(Order::getUid).distinct().collect(Collectors.toList());
        List<String> orderNoList = orderList.stream().map(Order::getOrderNo).distinct().collect(Collectors.toList());
        Map<Integer, Merchant> merchantMap = this.merchantService.getMapByIdList(merIdList);
        Map<Integer, User> userMap = this.userService.getUidMapList(userIdList);
        Map<String, List<OrderDetail>> orderDetailMap = this.orderDetailService.getMapByOrderNoList(orderNoList);
        Map<String, List<MerchantOrder>> merchantOrderMap = this.merchantOrderService.getMapByOrderNoList(orderNoList);
        ArrayList voList = CollUtil.newArrayList((Object[])new OrderExcelVo[0]);
        for (Order order : orderList) {
            OrderExcelVo vo = new OrderExcelVo();
            vo.setType(this.getOrderType(order.getType()));
            vo.setOrderNo(order.getOrderNo());
            vo.setMerName(order.getMerId() > 0 ? merchantMap.get(order.getMerId()).getName() : "");
            vo.setUserNickname(userMap.get(order.getUid()).getNickname() + "|" + order.getUid());
            vo.setPayPrice(order.getPayPrice().toString());
            vo.setPaidStr(order.getPaid() != false ? "\u5df2\u652f\u4ed8" : "\u672a\u652f\u4ed8");
            vo.setPayType(this.getOrderPayType(order.getPayType()));
            vo.setPayChannel(this.getOrderPayChannel(order.getPayChannel()));
            vo.setStatus(this.getOrderStatus(order.getStatus()));
            vo.setRefundStatus(this.getOrderRefundStatus(order.getRefundStatus()));
            vo.setCreateTime(CrmebDateUtil.dateToStr((Date)order.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            vo.setProductInfo(this.getOrderProductInfo(orderDetailMap.get(order.getOrderNo())));
            vo.setRealName(StrUtil.isBlank((CharSequence)merchantOrderMap.get(order.getOrderNo()).get(0).getRealName()) ? "" : merchantOrderMap.get(order.getOrderNo()).get(0).getRealName());
            vo.setUserPhone(StrUtil.isBlank((CharSequence)merchantOrderMap.get(order.getOrderNo()).get(0).getUserPhone()) ? "" : merchantOrderMap.get(order.getOrderNo()).get(0).getUserPhone());
            vo.setUserAddress(StrUtil.isBlank((CharSequence)merchantOrderMap.get(order.getOrderNo()).get(0).getUserAddress()) ? "" : merchantOrderMap.get(order.getOrderNo()).get(0).getUserAddress());
            vo.setUserRemark(StrUtil.isBlank((CharSequence)merchantOrderMap.get(order.getOrderNo()).get(0).getUserRemark()) ? "" : merchantOrderMap.get(order.getOrderNo()).get(0).getUserRemark());
            vo.setMerchantRemark(StrUtil.isBlank((CharSequence)merchantOrderMap.get(order.getOrderNo()).get(0).getMerchantRemark()) ? "" : merchantOrderMap.get(order.getOrderNo()).get(0).getMerchantRemark());
            voList.add(vo);
        }
        String serverPath = (this.crmebConfig.getImagePath() + "/").replace(" ", "").replace("//", "/");
        String fileName = "\u8ba2\u5355\u5bfc\u51fa_".concat(CrmebDateUtil.nowDateTime((String)"yyyyMMddHHmmss")).concat(CrmebUtil.randomCount((Integer)111111111, (Integer)999999999).toString()).concat(".xlsx");
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        aliasMap.put("type", "\u8ba2\u5355\u7c7b\u578b");
        aliasMap.put("orderNo", "\u8ba2\u5355\u53f7");
        aliasMap.put("merName", "\u5546\u6237\u540d\u79f0");
        aliasMap.put("userNickname", "\u7528\u6237\u6635\u79f0");
        aliasMap.put("payPrice", "\u5b9e\u9645\u652f\u4ed8\u91d1\u989d");
        aliasMap.put("paidStr", "\u652f\u4ed8\u72b6\u6001");
        aliasMap.put("payType", "\u652f\u4ed8\u65b9\u5f0f");
        aliasMap.put("payChannel", "\u652f\u4ed8\u6e20\u9053");
        aliasMap.put("status", "\u8ba2\u5355\u72b6\u6001");
        aliasMap.put("refundStatus", "\u9000\u6b3e\u72b6\u6001");
        aliasMap.put("createTime", "\u521b\u5efa\u65f6\u95f4");
        aliasMap.put("productInfo", "\u5546\u54c1\u4fe1\u606f");
        aliasMap.put("realName", "\u6536\u8d27\u4eba");
        aliasMap.put("userPhone", "\u6536\u8d27\u7535\u8bdd");
        aliasMap.put("userAddress", "\u6536\u8d27\u5730\u5740");
        aliasMap.put("userRemark", "\u7528\u6237\u5907\u6ce8");
        aliasMap.put("merchantRemark", "\u5546\u6237\u5907\u6ce8");
        return ExportUtil.exportExcel((String)fileName, (String)"\u8ba2\u5355\u5bfc\u51fa", (List)voList, aliasMap, (String)serverPath);
    }

    @Override
    public String exportUser(UserSearchRequest request) {
        List<User> userList = this.userService.findExportList(request);
        if (CollUtil.isEmpty(userList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\uff01");
        }
        ArrayList voList = CollUtil.newArrayList((Object[])new UserExcelVo[0]);
        for (User user : userList) {
            UserExcelVo vo = new UserExcelVo();
            vo.setId(user.getId());
            vo.setNickname(user.getNickname());
            vo.setBirthday(user.getBirthday());
            vo.setTags(this.getTags(user.getTagId()));
            vo.setPhone(user.getPhone());
            vo.setCountry(user.getCountry());
            vo.setProvince(user.getProvince());
            vo.setCity(user.getCity());
            vo.setSex(this.sexToStr(user.getSex()));
            vo.setIntegral(user.getIntegral());
            vo.setExperience(user.getExperience());
            vo.setNowMoney(user.getNowMoney());
            vo.setBrokeragePrice(user.getBrokeragePrice());
            SystemUserLevel systemUserLevel = this.systemUserLevelService.getByLevelId(user.getLevel());
            vo.setLevel(Integer.valueOf(ObjectUtil.isNotNull((Object)systemUserLevel) ? systemUserLevel.getGrade() : 0));
            vo.setPayCount(user.getPayCount());
            vo.setIsPromoter(this.booleanToStr(user.getIsPromoter()));
            vo.setPromoterTime(user.getPromoterTime());
            vo.setRegisterType(user.getRegisterType());
            vo.setStatus(user.getStatus() != false ? "\u6b63\u5e38" : "\u7981\u6b62");
            vo.setIsLogoff(this.booleanToStr(user.getIsLogoff()));
            vo.setLogoffTime(user.getLogoffTime());
            vo.setIsPaidMember(this.booleanToStr(user.getIsPaidMember()));
            vo.setIsPermanentPaidMember(this.booleanToStr(user.getIsPermanentPaidMember()));
            vo.setCreateTime(user.getCreateTime());
            voList.add(vo);
        }
        String serverPath = (this.crmebConfig.getImagePath() + "/").replace(" ", "").replace("//", "/");
        String fileName = "\u7528\u6237\u5bfc\u51fa_".concat(CrmebDateUtil.nowDateTime((String)"yyyyMMddHHmmss")).concat(CrmebUtil.randomCount((Integer)111111111, (Integer)999999999).toString()).concat(".xlsx");
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        aliasMap.put("id", "\u7528\u6237ID");
        aliasMap.put("nickname", "\u7528\u6237\u6635\u79f0");
        aliasMap.put("phone", "\u624b\u673a\u53f7\u7801");
        aliasMap.put("country", "\u56fd\u5bb6");
        aliasMap.put("province", "\u7701\u4efd");
        aliasMap.put("city", "\u57ce\u5e02");
        aliasMap.put("sex", "\u6027\u522b");
        aliasMap.put("birthday", "\u751f\u65e5");
        aliasMap.put("tags", "\u6807\u7b7e");
        aliasMap.put("integral", "\u7528\u6237\u79ef\u5206");
        aliasMap.put("experience", "\u7528\u6237\u7ecf\u9a8c");
        aliasMap.put("nowMoney", "\u7528\u6237\u4f59\u989d");
        aliasMap.put("brokeragePrice", "\u4f63\u91d1\u91d1\u989d");
        aliasMap.put("level", "\u7b49\u7ea7");
        aliasMap.put("payCount", "\u7528\u6237\u8d2d\u4e70\u6b21\u6570");
        aliasMap.put("isPromoter", "\u662f\u5426\u4e3a\u63a8\u5e7f\u5458");
        aliasMap.put("promoterTime", "\u6210\u4e3a\u5206\u9500\u5458\u65f6\u95f4");
        aliasMap.put("registerType", "\u6ce8\u518c\u7c7b\u578b");
        aliasMap.put("status", "\u72b6\u6001");
        aliasMap.put("isLogoff", "\u662f\u5426\u6ce8\u9500");
        aliasMap.put("logoffTime", "\u6ce8\u9500\u65f6\u95f4");
        aliasMap.put("isPaidMember", "\u662f\u5426\u4ed8\u8d39\u4f1a\u5458");
        aliasMap.put("isPermanentPaidMember", "\u662f\u5426\u6c38\u4e45\u4ed8\u8d39\u4f1a\u5458");
        aliasMap.put("createTime", "\u521b\u5efa\u65f6\u95f4");
        return ExportUtil.exportExcel((String)fileName, (String)"\u7528\u6237\u5bfc\u51fa", (List)voList, aliasMap, (String)serverPath);
    }

    private String getTags(String tagId) {
        if (StrUtil.isBlank((CharSequence)tagId)) {
            return "";
        }
        List tagIdList = CrmebUtil.stringToArray((String)tagId);
        List<UserTag> tagList = this.userTagService.findByIdList(tagIdList);
        if (CollUtil.isEmpty(tagList)) {
            return "";
        }
        return tagList.stream().map(UserTag::getName).collect(Collectors.joining(","));
    }

    private String booleanToStr(Boolean b) {
        return b != false ? "\u662f" : "\u5426";
    }

    private String sexToStr(Integer sex) {
        String sexStr = "";
        switch (sex) {
            case 0: {
                sexStr = "\u672a\u77e5";
                break;
            }
            case 1: {
                sexStr = "\u7537";
                break;
            }
            case 2: {
                sexStr = "\u5973";
                break;
            }
            case 3: {
                sexStr = "\u4fdd\u5bc6";
            }
        }
        return sexStr;
    }

    @Override
    public String exportRetailStorePeople(RetailStorePeopleSearchRequest request) {
        List<User> userList = this.userService.findRetailStorePeopleList(request);
        if (CollUtil.isEmpty(userList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\uff01");
        }
        ArrayList dtoList = CollUtil.newArrayList((Object[])new RetailStorePeopleExportDto[0]);
        userList.forEach(user -> {
            List<UserBrokerageRecord> recordList;
            RetailStorePeopleExportDto userDto = new RetailStorePeopleExportDto();
            BeanUtils.copyProperties((Object)user, (Object)userDto);
            userDto.setSpreadNickname("\u65e0");
            if (ObjectUtil.isNotNull((Object)user.getSpreadUid()) && user.getSpreadUid() > 0) {
                User spreadUser = (User)this.userService.getById(user.getSpreadUid());
                userDto.setSpreadNickname(Optional.ofNullable(spreadUser.getNickname()).orElse("--"));
            }
            if (CollUtil.isEmpty(recordList = this.userBrokerageRecordService.getSpreadListByUid(user.getId()))) {
                userDto.setSpreadOrderNum(Integer.valueOf(0));
                userDto.setSpreadOrderTotalPrice(BigDecimal.ZERO);
                userDto.setTotalBrokeragePrice(BigDecimal.ZERO);
                userDto.setExtractCountPrice(BigDecimal.ZERO);
                userDto.setExtractCountNum(Integer.valueOf(0));
                userDto.setFreezeBrokeragePrice(BigDecimal.ZERO);
            } else {
                userDto.setSpreadOrderNum(Integer.valueOf(recordList.size()));
                userDto.setTotalBrokeragePrice(recordList.stream().map(UserBrokerageRecord::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
                List<String> orderNoList = recordList.stream().map(UserBrokerageRecord::getLinkNo).collect(Collectors.toList());
                BigDecimal spreadOrderTotalPrice = this.orderService.getSpreadOrderTotalPriceByOrderList(orderNoList);
                userDto.setSpreadOrderTotalPrice(spreadOrderTotalPrice);
                UserClosing userClosing = this.userClosingService.getUserExtractByUserId(user.getId());
                userDto.setExtractCountPrice(userClosing.getClosingPrice());
                userDto.setExtractCountNum(userClosing.getId());
                userDto.setFreezeBrokeragePrice(this.userBrokerageRecordService.getFreezePrice(user.getId()));
            }
            dtoList.add(userDto);
        });
        String serverPath = (this.crmebConfig.getImagePath() + "/").replace(" ", "").replace("//", "/");
        String fileName = "\u5206\u9500\u5458\u5bfc\u51fa_".concat(CrmebDateUtil.nowDateTime((String)"yyyyMMddHHmmss")).concat(CrmebUtil.randomCount((Integer)111111111, (Integer)999999999).toString()).concat(".xlsx");
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        aliasMap.put("id", "\u7528\u6237ID");
        aliasMap.put("nickname", "\u7528\u6237\u6635\u79f0");
        aliasMap.put("phone", "\u624b\u673a\u53f7\u7801");
        aliasMap.put("brokeragePrice", "\u4f63\u91d1\u4f59\u989d");
        aliasMap.put("spreadUid", "\u63a8\u5e7f\u4ebaid");
        aliasMap.put("spreadNickname", "\u4e0a\u7ea7\u63a8\u5e7f\u5458\u540d\u79f0");
        aliasMap.put("payCount", "\u7528\u6237\u8d2d\u4e70\u6b21\u6570");
        aliasMap.put("spreadCount", "\u63a8\u5e7f\u7528\u6237\u6570");
        aliasMap.put("spreadOrderNum", "\u63a8\u5e7f\u8ba2\u5355\u6570");
        aliasMap.put("spreadOrderTotalPrice", "\u63a8\u5e7f\u8ba2\u5355\u989d");
        aliasMap.put("totalBrokeragePrice", "\u4f63\u91d1\u603b\u91d1\u989d");
        aliasMap.put("spreadPeopleCount", "\u63a8\u5e7f\u7528\u6237\u6570\u91cf");
        aliasMap.put("extractCountPrice", "\u5df2\u63d0\u73b0\u91d1\u989d");
        aliasMap.put("extractCountNum", "\u5df2\u63d0\u73b0\u6b21\u6570");
        aliasMap.put("freezeBrokeragePrice", "\u51bb\u7ed3\u4f63\u91d1");
        aliasMap.put("promoterTime", "\u6210\u4e3a\u5206\u9500\u5458\u65f6\u95f4");
        return ExportUtil.exportExcel((String)fileName, (String)"\u5206\u9500\u5458\u5bfc\u51fa", (List)dtoList, aliasMap, (String)serverPath);
    }

    private String getOrderProductInfo(List<OrderDetail> orderDetails) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < orderDetails.size(); ++i) {
            OrderDetail orderDetail = orderDetails.get(i);
            stringBuilder.append(StrUtil.format((CharSequence)"{}  {} * {}", (Object[])new Object[]{orderDetail.getProductName(), orderDetail.getPayPrice(), orderDetail.getPayNum()}));
            if (i + 1 >= orderDetails.size()) continue;
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    private String getOrderType(Integer type) {
        String typeStr = "";
        switch (type) {
            case 0: {
                typeStr = "\u666e\u901a";
                break;
            }
            case 1: {
                typeStr = "\u79d2\u6740";
                break;
            }
            case 2: {
                typeStr = "\u62fc\u56e2";
            }
        }
        return typeStr;
    }

    private String getOrderRefundStatus(Integer refundStatus) {
        String refundStatusStr = "";
        switch (refundStatus) {
            case 0: {
                refundStatusStr = "\u672a\u9000\u6b3e";
                break;
            }
            case 1: {
                refundStatusStr = "\u7533\u8bf7\u4e2d";
                break;
            }
            case 2: {
                refundStatusStr = "\u90e8\u5206\u9000\u6b3e";
                break;
            }
            case 3: {
                refundStatusStr = "\u5df2\u9000\u6b3e";
            }
        }
        return refundStatusStr;
    }

    private String getOrderStatus(Integer status) {
        String statusStr = "";
        switch (status) {
            case 0: {
                statusStr = "\u5f85\u652f\u4ed8";
                break;
            }
            case 1: {
                statusStr = "\u5f85\u53d1\u8d27";
                break;
            }
            case 2: {
                statusStr = "\u90e8\u5206\u53d1\u8d27";
                break;
            }
            case 3: {
                statusStr = "\u5f85\u4f7f\u7528";
                break;
            }
            case 4: {
                statusStr = "\u5f85\u6536\u8d27";
                break;
            }
            case 5: {
                statusStr = "\u5df2\u6536\u8d27";
                break;
            }
            case 6: {
                statusStr = "\u5df2\u5b8c\u6210";
                break;
            }
            case 9: {
                statusStr = "\u5df2\u53d6\u6d88";
            }
        }
        return statusStr;
    }

    private String getOrderPayChannel(String payChannel) {
        String payChannelStr = "";
        switch (payChannel) {
            case "public": {
                payChannelStr = "\u516c\u4f17\u53f7";
                break;
            }
            case "mini": {
                payChannelStr = "\u5c0f\u7a0b\u5e8f";
                break;
            }
            case "h5": {
                payChannelStr = "\u5fae\u4fe1\u7f51\u9875\u652f\u4ed8";
                break;
            }
            case "yue": {
                payChannelStr = "\u4f59\u989d";
                break;
            }
            case "wechatIos": {
                payChannelStr = "\u5fae\u4fe1Ios";
                break;
            }
            case "wechatAndroid": {
                payChannelStr = "\u5fae\u4fe1Android";
                break;
            }
            case "alipay": {
                payChannelStr = "\u652f\u4ed8\u5b9d";
                break;
            }
            case "alipayApp": {
                payChannelStr = "\u652f\u4ed8\u5b9dApp";
            }
        }
        return payChannelStr;
    }

    private String getOrderPayType(String payType) {
        String payTypeStr = "";
        switch (payType) {
            case "weixin": {
                payTypeStr = "\u5fae\u4fe1\u652f\u4ed8";
                break;
            }
            case "alipay": {
                payTypeStr = "\u652f\u4ed8\u5b9d\u652f\u4ed8";
                break;
            }
            case "yue": {
                payTypeStr = "\u4f59\u989d\u652f\u4ed8";
            }
        }
        return payTypeStr;
    }
}

