/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CreateBucketRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.service.service.CosService;
import com.zbkj.service.service.SystemConfigService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CosServiceImpl
implements CosService {
    private static final Logger logger = LoggerFactory.getLogger(CosServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public void uploadFile(String webPth, String localFile, File file) {
        if (!file.exists()) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6" + localFile + "\u4e0d\u5b58\u5728\uff1a");
            throw new CrmebException("\u4e0a\u4f20\u6587\u4ef6" + localFile + "\u4e0d\u5b58\u5728\uff1a");
        }
        String bucketName = this.systemConfigService.getValueByKeyException("txStorageName");
        COSClient cosClient = this.getCosClient();
        try {
            if (!cosClient.doesBucketExist(bucketName)) {
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
                createBucketRequest.setCannedAcl(CannedAccessControlList.Private);
                try {
                    cosClient.createBucket(createBucketRequest);
                }
                catch (CosClientException serverException) {
                    serverException.printStackTrace();
                }
            }
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, webPth, file);
            PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        }
        catch (Exception e) {
            logger.error("\u817e\u8baf\u4e91\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            throw new CrmebException(e.getMessage());
        }
        finally {
            cosClient.shutdown();
        }
    }

    private COSClient getCosClient() {
        this.systemConfigService.getValueByKeyException("txUploadUrl");
        String accessKey = this.systemConfigService.getValueByKeyException("txAccessKey");
        String secretKey = this.systemConfigService.getValueByKeyException("txSecretKey");
        String region = this.systemConfigService.getValueByKeyException("txStorageRegion");
        BasicCOSCredentials cred = new BasicCOSCredentials(accessKey, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        return new COSClient((COSCredentials)cred, clientConfig);
    }
}

