/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.community.CommunityNotesRelation;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.service.dao.community.CommunityNotesRelationDao;
import com.zbkj.service.service.CommunityNotesRelationService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CommunityNotesRelationServiceImpl
extends ServiceImpl<CommunityNotesRelationDao, CommunityNotesRelation>
implements CommunityNotesRelationService {
    @Resource
    private CommunityNotesRelationDao dao;

    @Override
    public Boolean isLikeByUid(Integer noteId, Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityNotesRelation::getId});
        lqw.eq(CommunityNotesRelation::getNoteId, (Object)noteId);
        lqw.eq(CommunityNotesRelation::getType, (Object)"like");
        lqw.eq(CommunityNotesRelation::getUid, (Object)userId);
        CommunityNotesRelation relation = (CommunityNotesRelation)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)relation) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Integer getCountLikeByAuthorId(Integer authorId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CommunityNotesRelation::getId});
        lqw.eq(CommunityNotesRelation::getAuthorId, (Object)authorId);
        lqw.eq(CommunityNotesRelation::getType, (Object)"like");
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public CommunityNotesRelation getOneByNoteIdAndUid(Integer noteId, Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityNotesRelation::getNoteId, (Object)noteId);
        lqw.eq(CommunityNotesRelation::getUid, (Object)userId);
        lqw.eq(CommunityNotesRelation::getType, (Object)"like");
        lqw.last(" limit 1");
        return (CommunityNotesRelation)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean deleteByNoteId(Integer noteId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(CommunityNotesRelation::getNoteId, (Object)noteId);
        return this.remove((Wrapper)wrapper);
    }

    @Override
    public PageInfo<CommunityNotesRelation> findLikePageByUid(Integer userId, PageParamRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CommunityNotesRelation::getUid, (Object)userId);
        lqw.eq(CommunityNotesRelation::getType, (Object)"like");
        lqw.orderByDesc(CommunityNotesRelation::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public Boolean deleteByAuthorId(Integer authorId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(CommunityNotesRelation::getAuthorId, (Object)authorId);
        return this.remove((Wrapper)wrapper);
    }
}

