/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.circle.Circle;
import com.zbkj.common.model.circle.CircleAdmin;
import com.zbkj.common.model.circle.CircleMerchant;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.request.circle.CircleAddRequest;
import com.zbkj.common.request.circle.CircleConjunctiveDiyRequest;
import com.zbkj.common.request.circle.CircleMerchantRequest;
import com.zbkj.common.request.circle.CircleUpdateRequest;
import com.zbkj.common.response.circle.CircleDetailResponse;
import com.zbkj.common.response.circle.CircleMerchantResponse;
import com.zbkj.common.response.circle.CircleTreeResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.vo.CircleManageTree;
import com.zbkj.service.dao.circle.CircleDao;
import com.zbkj.service.service.CircleAdminService;
import com.zbkj.service.service.CircleMerchantService;
import com.zbkj.service.service.CircleService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.PageDiyService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CircleServiceImpl
extends ServiceImpl<CircleDao, Circle>
implements CircleService {
    @Resource
    private CircleDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CircleAdminService circleAdminService;
    @Autowired
    private CircleMerchantService circleMerchantService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private PageDiyService pageDiyService;

    @Override
    public List<CircleTreeResponse> getListTree() {
        List<CircleTreeResponse> circleList = this.dao.getList();
        List<Integer> diyIdList = circleList.stream().map(CircleTreeResponse::getDiyId).distinct().filter(e -> e > 0).collect(Collectors.toList());
        Map<Integer, String> diyMap = this.pageDiyService.getNameMapByIdList(diyIdList);
        circleList.forEach(circle -> {
            if (circle.getDiyId().equals(0)) {
                circle.setDiyName("-");
            } else {
                String diyName = ObjectUtil.isNull(diyMap.get(circle.getDiyId())) ? "-" : (String)diyMap.get(circle.getDiyId());
                circle.setDiyName(diyName);
            }
        });
        return new CircleManageTree(circleList).buildTree();
    }

    @Override
    public Integer add(CircleAddRequest request) {
        this.VerifyAddData(request);
        Circle circle = new Circle();
        BeanUtils.copyProperties((Object)request, (Object)circle);
        circle.setStatus(Boolean.FALSE);
        circle.setIsShow(Boolean.FALSE);
        circle.setIsDelete(Boolean.FALSE);
        this.calculateLevel(circle);
        CircleAdmin admin = new CircleAdmin();
        admin.setAccount(request.getAccount());
        admin.setPwd(CrmebUtil.encryptPassword((String)request.getPwd(), (String)request.getAccount()));
        admin.setRealName(request.getRealName());
        admin.setPhone(request.getPhone());
        admin.setType(RoleEnum.CIRCLE_SUPER.getValue());
        admin.setRoles(request.getRole());
        admin.setStatus(Boolean.FALSE);
        return (Integer)this.transactionTemplate.execute(e -> {
            this.save(circle);
            admin.setCircleId(circle.getId());
            this.circleAdminService.save(admin);
            return circle.getId();
        });
    }

    @Override
    public Boolean removeCircleById(Integer id) {
        Circle circle = (Circle)this.getById(id);
        if (ObjectUtil.isNull((Object)circle) || circle.getIsDelete().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (circle.getStatus().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u5904\u4e8e\u542f\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Circle::getPid, (Object)id);
        queryWrapper.eq(Circle::getIsDelete, (Object)Boolean.FALSE);
        int count = this.dao.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new CrmebException("\u5b58\u5728\u4e0b\u7ea7\u5708\u5c42\uff0c\u65e0\u6cd5\u5220\u9664\u672c\u7ea7");
        }
        List<Integer> merIds = this.circleMerchantService.getMerIdsByCircleId(id);
        if (merIds.size() > 0) {
            throw new CrmebException("\u8be5\u5708\u5c42\u5b58\u5728\u5546\u5bb6\u7ed1\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(Circle::getId, (Object)id);
        wrapper.set(Circle::getIsDelete, (Object)Boolean.TRUE);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)wrapper);
            this.circleAdminService.deleteByCircleId(id);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean updateCircle(CircleUpdateRequest request) {
        Circle circle = (Circle)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)circle) || circle.getIsDelete().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (circle.getStatus().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u5904\u4e8e\u542f\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u4fee\u6539");
        }
        this.VerifyUpdateData(request);
        BeanUtils.copyProperties((Object)request, (Object)circle);
        this.calculateLevel(circle);
        circle.setUpdateTime(new Date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(circle);
            this.circleAdminService.updateCircleAdminData(request.getRealName(), request.getPhone(), request.getId(), request.getRole());
            return Boolean.TRUE;
        });
    }

    @Override
    public CircleDetailResponse getCircleId(Integer id) {
        CircleDetailResponse detailResponse = new CircleDetailResponse();
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.eq(Circle::getId, (Object)id);
        query.eq(Circle::getIsDelete, (Object)Boolean.FALSE);
        Circle circle = (Circle)this.getOne((Wrapper)query);
        if (ObjectUtil.isNull((Object)circle) || circle.getIsDelete().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        BeanUtils.copyProperties((Object)circle, (Object)detailResponse);
        CircleAdmin admin = this.circleAdminService.getByCircleId(id);
        detailResponse.setAccount(admin.getAccount());
        detailResponse.setRealName(admin.getRealName());
        detailResponse.setPhone(admin.getPhone());
        detailResponse.setRole(Integer.valueOf(admin.getRoles()));
        detailResponse.setMerchantList(this.getMerchantsByCircleId(id));
        return detailResponse;
    }

    @Override
    public Boolean resetPassword(Integer id) {
        Circle circle = (Circle)this.getById(id);
        if (ObjectUtil.isNull((Object)circle) || circle.getIsDelete().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        CircleAdmin admin = this.circleAdminService.getByCircleId(id);
        String newPwd = CrmebUtil.encryptPassword((String)"000000", (String)admin.getAccount());
        admin.setPwd(newPwd);
        admin.setUpdateTime(new Date());
        this.circleAdminService.updateById(admin);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateStatus(Integer id) {
        Circle circle = (Circle)this.getById(id);
        if (ObjectUtil.isNull((Object)circle) || circle.getIsDelete().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        CircleAdmin admin = this.circleAdminService.getByCircleId(id);
        Boolean status = circle.getStatus() == false;
        List<Integer> allCircleIds = this.getCircleChildById(id);
        if (status.booleanValue() && circle.getLevel() > 1) {
            if (circle.getLevel() == 3) {
                Circle parent = (Circle)this.getById(circle.getPid());
                allCircleIds.add(parent.getPid());
            }
            allCircleIds.add(circle.getPid());
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(Circle::getId, allCircleIds);
        wrapper.set(Circle::getStatus, (Object)status);
        if (!status.booleanValue()) {
            wrapper.set(Circle::getIsShow, (Object)Boolean.FALSE);
        }
        LambdaUpdateWrapper adminWrapper = new LambdaUpdateWrapper();
        adminWrapper.in(CircleAdmin::getCircleId, allCircleIds);
        adminWrapper.set(CircleAdmin::getStatus, (Object)status);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)wrapper);
            this.circleAdminService.update((Wrapper)adminWrapper);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean updateShow(Integer id) {
        Circle circle = (Circle)this.getById(id);
        if (ObjectUtil.isNull((Object)circle) || circle.getIsDelete().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (!circle.getStatus().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u5904\u4e8e\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u4fee\u6539\u663e\u793a\u72b6\u6001");
        }
        Boolean isShow = circle.getIsShow() == false;
        List<Integer> allCircleIds = this.getCircleChildById(id);
        if (isShow.booleanValue() && circle.getLevel() > 1) {
            if (circle.getLevel() == 3) {
                Circle parent = (Circle)this.getById(circle.getPid());
                allCircleIds.add(parent.getPid());
            }
            allCircleIds.add(circle.getPid());
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(Circle::getId, allCircleIds);
        wrapper.set(Circle::getIsShow, (Object)isShow);
        this.update((Wrapper)wrapper);
        return Boolean.TRUE;
    }

    @Override
    public List<CircleMerchantResponse> getMerchantsByCircleId(Integer id) {
        ArrayList<CircleMerchantResponse> list = new ArrayList<CircleMerchantResponse>();
        if (id > 0) {
            List<Integer> merIdList = this.circleMerchantService.getMerIdsByCircleId(id);
            if (CollectionUtil.isNotEmpty(merIdList)) {
                this.merchantService.getListByIdList(merIdList).forEach(merchant -> {
                    CircleMerchantResponse response = new CircleMerchantResponse();
                    BeanUtils.copyProperties((Object)merchant, (Object)response);
                    list.add(response);
                });
            }
            return list;
        }
        return this.merchantService.getCircleMerchantsUnBind(id);
    }

    @Override
    @Transactional
    public Boolean bindMerchant(CircleMerchantRequest request) {
        Integer circleId = request.getId();
        List newMerchantIds = request.getMerchantIds();
        Circle circle = (Circle)this.getById(circleId);
        if (ObjectUtil.isNull((Object)circle) || circle.getIsDelete().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        HashSet newMerchantSet = new HashSet(CollectionUtil.isNotEmpty((Collection)newMerchantIds) ? newMerchantIds : Collections.emptyList());
        List<Integer> existingMerchantIds = this.circleMerchantService.getMerIdsByCircleId(circleId);
        HashSet<Integer> existingSet = new HashSet<Integer>(existingMerchantIds);
        HashSet<Integer> toUnbind = new HashSet<Integer>(existingSet);
        toUnbind.removeAll(newMerchantSet);
        HashSet toBind = new HashSet(newMerchantSet);
        toBind.removeAll(existingSet);
        List<Integer> allCircleIds = this.getCircleChildById(circleId);
        ArrayList<CircleMerchant> circleMerchants = new ArrayList<CircleMerchant>();
        if (CollectionUtil.isNotEmpty(toBind)) {
            Map<Integer, Merchant> merchantMap = this.merchantService.getMapByIdList(new ArrayList<Integer>(toBind));
            if (merchantMap.size() != toBind.size()) {
                throw new CrmebException("\u90e8\u5206\u5546\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            HashMap<Integer, Set<Integer>> bindCache = new HashMap<Integer, Set<Integer>>();
            if (circle.getLevel() > 1) {
                this.loadParentBindings(circle, bindCache);
            }
            switch (circle.getLevel()) {
                case 1: {
                    for (Integer merId : toBind) {
                        circleMerchants.add(this.createRelation(circleId, merId));
                    }
                    break;
                }
                case 2: {
                    Set parentBindSet = bindCache.getOrDefault(circle.getPid(), Collections.emptySet());
                    for (Integer merId : toBind) {
                        circleMerchants.add(this.createRelation(circleId, merId));
                        if (parentBindSet.contains(merId)) continue;
                        circleMerchants.add(this.createRelation(circle.getPid(), merId));
                    }
                    break;
                }
                case 3: {
                    Circle parent = (Circle)this.getById(circle.getPid());
                    Set level1BindSet = bindCache.getOrDefault(parent.getPid(), Collections.emptySet());
                    Set level2BindSet = bindCache.getOrDefault(circle.getPid(), Collections.emptySet());
                    for (Integer merId : toBind) {
                        circleMerchants.add(this.createRelation(circleId, merId));
                        if (!level2BindSet.contains(merId)) {
                            circleMerchants.add(this.createRelation(circle.getPid(), merId));
                        }
                        if (level1BindSet.contains(merId)) continue;
                        circleMerchants.add(this.createRelation(parent.getPid(), merId));
                    }
                    break;
                }
            }
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            if (CollectionUtil.isNotEmpty((Collection)toUnbind)) {
                this.circleMerchantService.removeMer(allCircleIds, new ArrayList<Integer>(toUnbind));
            }
            if (CollectionUtil.isNotEmpty((Collection)circleMerchants)) {
                this.circleMerchantService.saveBatch(circleMerchants);
            }
            return Boolean.TRUE;
        });
    }

    private void loadParentBindings(Circle circle, Map<Integer, Set<Integer>> bindCache) {
        Circle parent;
        ArrayList<Integer> circleIdsToLoad = new ArrayList<Integer>();
        if (circle.getLevel() >= 2) {
            circleIdsToLoad.add(circle.getPid());
        }
        if (circle.getLevel() == 3 && (parent = (Circle)this.getById(circle.getPid())) != null) {
            circleIdsToLoad.add(parent.getPid());
        }
        if (!circleIdsToLoad.isEmpty()) {
            List<CircleMerchant> bindings = this.circleMerchantService.getByCircleIds(circleIdsToLoad);
            for (CircleMerchant binding : bindings) {
                bindCache.computeIfAbsent(binding.getCircleId(), k -> new HashSet()).add(binding.getMerId());
            }
        }
    }

    private CircleMerchant createRelation(Integer circleId, Integer merId) {
        CircleMerchant relation = new CircleMerchant();
        relation.setCircleId(circleId);
        relation.setMerId(merId);
        return relation;
    }

    @Override
    public Boolean removeMerchant(CircleMerchantRequest request) {
        Integer circleId = request.getId();
        List merchantIds = request.getMerchantIds();
        Circle circle = (Circle)this.getById(circleId);
        if (ObjectUtil.isNull((Object)circle) || circle.getIsDelete().booleanValue()) {
            throw new CrmebException("\u8be5\u5708\u5c42\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        List<Integer> allCircleIds = this.getCircleChildById(circleId);
        this.circleMerchantService.removeMer(allCircleIds, merchantIds);
        return Boolean.TRUE;
    }

    @Override
    public List<Integer> getCircleChildById(Integer circleId) {
        List allCircle = this.list((Wrapper)new LambdaQueryWrapper().eq(Circle::getIsDelete, (Object)Boolean.FALSE));
        Map<Integer, List<Circle>> areaMap = allCircle.stream().collect(Collectors.groupingBy(Circle::getPid));
        ArrayList<Integer> circleIds = new ArrayList<Integer>();
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.add(circleId);
        while (!queue.isEmpty()) {
            Integer currentId = (Integer)queue.poll();
            List<Circle> children = areaMap.get(currentId);
            if (!CollectionUtil.isNotEmpty(children)) continue;
            children.forEach(child -> {
                circleIds.add(child.getId());
                queue.add(child.getId());
            });
        }
        circleIds.add(circleId);
        return circleIds;
    }

    @Override
    public List<Circle> findAllDestination() {
        return this.dao.findAllDestination();
    }

    @Override
    public List<Circle> findOpenAll() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Circle::getIsDelete, (Object)0);
        lqw.eq(Circle::getStatus, (Object)1);
        lqw.eq(Circle::getIsShow, (Object)1);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean conjunctiveDiy(CircleConjunctiveDiyRequest request) {
        List idList = Arrays.stream(request.getIds().split(",")).map(Integer::parseInt).collect(Collectors.toList());
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Circle::getDiyId, (Object)request.getDiyId());
        wrapper.in(Circle::getId, idList);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Map<Integer, String> getCircleNameMapByDiyIdList(List<Integer> diyIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Circle::getId, Circle::getName, Circle::getDiyId});
        lqw.in(Circle::getDiyId, diyIdList);
        lqw.eq(Circle::getIsDelete, (Object)0);
        List circleList = this.dao.selectList((Wrapper)lqw);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        if (CollUtil.isEmpty((Collection)circleList)) {
            return map;
        }
        Map<Integer, List<Circle>> groupMap = circleList.stream().collect(Collectors.groupingBy(Circle::getDiyId));
        for (Map.Entry<Integer, List<Circle>> entry : groupMap.entrySet()) {
            Integer key = entry.getKey();
            List<Circle> valueList = entry.getValue();
            String value = valueList.stream().map(Circle::getName).collect(Collectors.joining(","));
            map.put(key, value);
        }
        return map;
    }

    private void calculateLevel(Circle circle) {
        if (circle.getPid() == 0) {
            circle.setLevel(Integer.valueOf(1));
            return;
        }
        Circle parent = (Circle)this.dao.selectById(circle.getPid());
        circle.setLevel(Integer.valueOf(parent.getLevel() + 1));
        if (circle.getLevel() > 3) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5708\u5c42\u5c42\u7ea7\u4e0d\u80fd\u8d85\u8fc7\u4e09\u7ea7");
        }
    }

    private void VerifyAddData(CircleAddRequest request) {
        if (request.getAddressSwitch().equals(1) && (StringUtils.isBlank((CharSequence)request.getAddress()) || StringUtils.isBlank((CharSequence)request.getLongitude()) || StringUtils.isBlank((CharSequence)request.getLatitude()))) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5708\u5c42\u5730\u5740\u6253\u5f00\u65f6\uff0c\u5708\u5c42\u5730\u5740\u548c\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Circle::getId});
        lqw.eq(Circle::getName, (Object)request.getName());
        lqw.eq(Circle::getIsDelete, (Object)Boolean.FALSE);
        if (this.dao.selectCount((Wrapper)lqw) > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5708\u5c42\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.circleAdminService.checkAdminAccount(request.getAccount()) > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5708\u5c42\u7ba1\u7406\u5458\u8d26\u53f7\u5df2\u5b58\u5728");
        }
    }

    private void VerifyUpdateData(CircleUpdateRequest request) {
        if (request.getAddressSwitch().equals(1) && (StringUtils.isBlank((CharSequence)request.getAddress()) || StringUtils.isBlank((CharSequence)request.getLongitude()) || StringUtils.isBlank((CharSequence)request.getLatitude()))) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5708\u5c42\u5730\u5740\u6253\u5f00\u65f6\uff0c\u5708\u5c42\u5730\u5740\u548c\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Circle::getId});
        lqw.ne(Circle::getId, (Object)request.getId());
        lqw.eq(Circle::getName, (Object)request.getName());
        lqw.eq(Circle::getIsDelete, (Object)Boolean.FALSE);
        if (this.dao.selectCount((Wrapper)lqw) > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5708\u5c42\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }
}

