/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.circle.CircleRoleMenu;
import com.zbkj.service.dao.circle.CircleRoleMenuDao;
import com.zbkj.service.service.CircleRoleMenuService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CircleRoleMenuServiceImpl
extends ServiceImpl<CircleRoleMenuDao, CircleRoleMenu>
implements CircleRoleMenuService {
    @Resource
    private CircleRoleMenuDao dao;

    @Override
    public Boolean deleteByRidAndMenuId(int rid, Integer menuId) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.eq(CircleRoleMenu::getRid, (Object)rid);
        luw.eq(CircleRoleMenu::getMenuId, (Object)menuId);
        return this.dao.delete((Wrapper)luw) > 0;
    }

    @Override
    public Boolean deleteByRidAndMenuIdList(int rid, List<Integer> menuIdList) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.eq(CircleRoleMenu::getRid, (Object)rid);
        luw.in(CircleRoleMenu::getMenuId, menuIdList);
        return this.dao.delete((Wrapper)luw) > 0;
    }

    @Override
    public Boolean deleteByRid(Integer rid) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.eq(CircleRoleMenu::getRid, (Object)rid);
        return this.dao.delete((Wrapper)luw) > 0;
    }

    @Override
    public List<Integer> getMenuListByRid(Integer rid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CircleRoleMenu::getMenuId});
        lqw.eq(CircleRoleMenu::getRid, (Object)rid);
        List roleMenuList = this.dao.selectList((Wrapper)lqw);
        return roleMenuList.stream().map(CircleRoleMenu::getMenuId).collect(Collectors.toList());
    }
}

