/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.circle.CircleAdmin;
import com.zbkj.common.model.circle.CircleMenu;
import com.zbkj.common.request.SystemMenuSearchRequest;
import com.zbkj.common.request.circle.CircleMenuRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.SystemConfigResultCode;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.common.vo.MenuCheckTree;
import com.zbkj.common.vo.MenuCheckVo;
import com.zbkj.service.dao.circle.CircleMenuDao;
import com.zbkj.service.service.CircleAdminService;
import com.zbkj.service.service.CircleMenuService;
import com.zbkj.service.service.CircleRoleMenuService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CircleMenuServiceImpl
extends ServiceImpl<CircleMenuDao, CircleMenu>
implements CircleMenuService {
    @Resource
    private CircleMenuDao dao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CircleRoleMenuService roleMenuService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CircleAdminService circleAdminService;

    @Override
    public List<CircleMenu> getCircleMenuList(SystemMenuSearchRequest request) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            String decode = URLUtil.decode((String)request.getName());
            lqw.like(CircleMenu::getName, (Object)decode);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getMenuType())) {
            lqw.eq(CircleMenu::getMenuType, (Object)request.getMenuType());
        }
        lqw.eq(CircleMenu::getIsDelte, (Object)false);
        lqw.eq(CircleMenu::getType, (Object)RoleEnum.CIRCLE_ADMIN.getValue());
        lqw.orderByDesc(CircleMenu::getSort);
        lqw.orderByAsc(CircleMenu::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean addCircleMenu(CircleMenuRequest request) {
        if (request.getMenuType().equals("C") && StrUtil.isEmpty((CharSequence)request.getComponent())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u83dc\u5355\u7c7b\u578b\u7684\u7ec4\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getMenuType().equals("A") && StrUtil.isEmpty((CharSequence)request.getPerms())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6309\u94ae\u7c7b\u578b\u7684\u6743\u9650\u8868\u793a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CircleMenu circleMenu = new CircleMenu();
        request.setId(null);
        BeanUtils.copyProperties((Object)request, (Object)circleMenu);
        circleMenu.setType(RoleEnum.CIRCLE_ADMIN.getValue());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.save(circleMenu);
            return Boolean.TRUE;
        });
        if (Boolean.TRUE.equals(execute)) {
            this.redisUtil.delete(new String[]{"circleMenuList"});
        }
        return execute;
    }

    @Override
    public Boolean deleteCircleMenu(Integer id) {
        CircleMenu circleMenu = this.getInfo(id);
        if (ObjectUtil.isNull((Object)circleMenu) || circleMenu.getIsDelte().booleanValue() || circleMenu.getType() != 6) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.MENU_NOT_EXIST);
        }
        circleMenu.setIsDelte(Boolean.valueOf(true));
        circleMenu.setUpdateTime((Date)DateUtil.date());
        String redisKey = "circleMenuList";
        if (circleMenu.getMenuType().equals("A")) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(circleMenu);
                return Boolean.TRUE;
            });
            if (Boolean.TRUE.equals(execute)) {
                this.redisUtil.delete(new String[]{redisKey});
            }
            return execute;
        }
        List<CircleMenu> childList = this.findAllChildListByPid(id, circleMenu.getMenuType());
        if (CollUtil.isEmpty(childList)) {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(circleMenu);
                return Boolean.TRUE;
            });
            if (Boolean.TRUE.equals(execute)) {
                this.redisUtil.delete(new String[]{redisKey});
            }
            return execute;
        }
        childList.forEach(e -> e.setIsDelte(Boolean.valueOf(true)).setUpdateTime((Date)DateUtil.date()));
        childList.add(circleMenu);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateBatchById(childList);
            return Boolean.TRUE;
        });
        if (Boolean.TRUE.equals(execute)) {
            this.redisUtil.delete(new String[]{redisKey});
        }
        return execute;
    }

    @Override
    public Boolean editCircleMenu(CircleMenuRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7cfb\u7edf\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getMenuType().equals("C") && StrUtil.isEmpty((CharSequence)request.getComponent())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u83dc\u5355\u7c7b\u578b\u7684\u7ec4\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getMenuType().equals("A") && StrUtil.isEmpty((CharSequence)request.getPerms())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6309\u94ae\u7c7b\u578b\u7684\u6743\u9650\u8868\u793a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CircleMenu oldMenu = this.getInfo(request.getId());
        if (ObjectUtil.isNull((Object)oldMenu) || oldMenu.getIsDelte().booleanValue() || oldMenu.getType() != 6) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.MENU_NOT_EXIST);
        }
        CircleMenu circleMenu = new CircleMenu();
        BeanUtils.copyProperties((Object)request, (Object)circleMenu);
        circleMenu.setType(RoleEnum.CIRCLE_ADMIN.getValue());
        circleMenu.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(circleMenu);
        if (update) {
            this.redisUtil.delete(new String[]{"circleMenuList"});
        }
        return update;
    }

    @Override
    public CircleMenu getInfo(Integer id) {
        CircleMenu circleMenu = (CircleMenu)this.getById(id);
        if (ObjectUtil.isNull((Object)circleMenu) || circleMenu.getIsDelte().booleanValue() || circleMenu.getType() != 6) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.MENU_NOT_EXIST);
        }
        return circleMenu;
    }

    @Override
    public Boolean updateCircleShowStatus(Integer id) {
        CircleMenu circleMenu = this.getInfo(id);
        if (ObjectUtil.isNull((Object)circleMenu) || circleMenu.getIsDelte().booleanValue() || circleMenu.getType() != 6) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.MENU_NOT_EXIST);
        }
        circleMenu.setIsShow(Boolean.valueOf(circleMenu.getIsShow() == false));
        circleMenu.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(circleMenu);
        if (update) {
            this.redisUtil.delete(new String[]{"circleMenuList"});
        }
        return update;
    }

    @Override
    public List<CircleMenu> getMenuCacheList(Integer type) {
        String redisKey = "";
        if (type.equals(RoleEnum.CIRCLE_ADMIN.getValue()) || type.equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            redisKey = "circleMenuList";
        }
        if (this.redisUtil.exists(redisKey).booleanValue()) {
            return (List)this.redisUtil.get(redisKey);
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CircleMenu::getIsDelte, (Object)false);
        lqw.eq(CircleMenu::getType, (Object)type);
        List systemMenuList = this.dao.selectList((Wrapper)lqw);
        this.redisUtil.set(redisKey, (Object)systemMenuList);
        return systemMenuList;
    }

    @Override
    public List<MenuCheckVo> getCircleMenuCacheTree() {
        List<CircleMenu> menuList = this.getCacheList(RoleEnum.CIRCLE_ADMIN.getValue());
        List voList = menuList.stream().map(e -> {
            MenuCheckVo menuCheckVo = new MenuCheckVo();
            BeanUtils.copyProperties((Object)e, (Object)menuCheckVo);
            return menuCheckVo;
        }).collect(Collectors.toList());
        MenuCheckTree menuTree = new MenuCheckTree(voList);
        return menuTree.buildTree();
    }

    @Override
    public List<CircleMenu> findPermissionByUserId(Integer uid) {
        return this.dao.findPermissionByUserId(uid);
    }

    @Override
    public List<CircleMenu> getMenusByUserId(Integer uid) {
        return this.dao.getMenusByUserId(uid);
    }

    @Override
    public List<MenuCheckVo> getCircleMenuCacheList() {
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        Integer circleId = loginUserVo.getUser().getCircleId();
        CircleAdmin circleAdmin = this.circleAdminService.getByCircleId(circleId);
        List<CircleMenu> menuList = this.dao.findPermissionByUserId(circleAdmin.getId());
        List voList = menuList.stream().map(e -> {
            MenuCheckVo menuCheckVo = new MenuCheckVo();
            BeanUtils.copyProperties((Object)e, (Object)menuCheckVo);
            return menuCheckVo;
        }).collect(Collectors.toList());
        MenuCheckTree menuTree = new MenuCheckTree(voList);
        return menuTree.buildTree();
    }

    @Override
    public List<CircleMenu> getList() {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CircleMenu::getType, (Object)RoleEnum.CIRCLE_ADMIN.getValue());
        lqw.eq(CircleMenu::getIsDelte, (Object)false);
        return this.dao.selectList((Wrapper)lqw);
    }

    private List<CircleMenu> getCacheList(Integer type) {
        String redisKey = "";
        if (type.equals(RoleEnum.CIRCLE_ADMIN.getValue())) {
            redisKey = "circleMenuList";
        }
        if (this.redisUtil.exists(redisKey).booleanValue()) {
            return (List)this.redisUtil.get(redisKey);
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CircleMenu::getIsDelte, (Object)false);
        lqw.eq(CircleMenu::getType, (Object)type);
        List systemMenuList = this.dao.selectList((Wrapper)lqw);
        this.redisUtil.set(redisKey, (Object)systemMenuList);
        return systemMenuList;
    }

    private List<CircleMenu> findAllChildListByPid(Integer pid, String menuType) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CircleMenu::getPid, (Object)pid);
        lqw.eq(CircleMenu::getIsDelte, (Object)false);
        if (menuType.equals("C")) {
            return this.dao.selectList((Wrapper)lqw);
        }
        List menuList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)menuList)) {
            return menuList;
        }
        List pidList = menuList.stream().map(CircleMenu::getId).collect(Collectors.toList());
        lqw.clear();
        lqw.in(CircleMenu::getPid, pidList);
        lqw.eq(CircleMenu::getIsDelte, (Object)false);
        List childMenuList = this.dao.selectList((Wrapper)lqw);
        menuList.addAll(childMenuList);
        return menuList;
    }
}

