/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.circle.CircleAdmin;
import com.zbkj.common.model.circle.CircleRole;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemAdminAddRequest;
import com.zbkj.common.request.SystemAdminRequest;
import com.zbkj.common.request.SystemAdminUpdatePwdRequest;
import com.zbkj.common.request.SystemAdminUpdateRequest;
import com.zbkj.common.response.SystemAdminResponse;
import com.zbkj.common.result.AdminResultCode;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.circle.CircleAdminDao;
import com.zbkj.service.service.CircleAdminService;
import com.zbkj.service.service.CircleRoleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CircleAdminServiceImpl
extends ServiceImpl<CircleAdminDao, CircleAdmin>
implements CircleAdminService {
    @Resource
    private CircleAdminDao dao;
    @Resource
    private CrmebConfig crmebConfig;
    @Autowired
    private CircleRoleService circleRoleService;

    @Override
    public Boolean deleteByCircleId(Integer circleId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(CircleAdmin::getCircleId, (Object)circleId);
        updateWrapper.set(CircleAdmin::getIsDel, (Object)Boolean.TRUE);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Integer checkAdminAccount(String account) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CircleAdmin::getAccount, (Object)account);
        lqw.eq(CircleAdmin::getIsDel, (Object)Boolean.TRUE);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean updateCircleAdminData(String realName, String phone, Integer circleId, String role) {
        LambdaUpdateWrapper luw = new LambdaUpdateWrapper();
        luw.eq(CircleAdmin::getCircleId, (Object)circleId);
        luw.eq(CircleAdmin::getType, (Object)RoleEnum.CIRCLE_SUPER.getValue());
        luw.eq(CircleAdmin::getIsDel, (Object)Boolean.FALSE);
        luw.set(CircleAdmin::getRealName, (Object)realName);
        luw.set(CircleAdmin::getPhone, (Object)phone);
        luw.set(CircleAdmin::getRoles, (Object)role);
        return this.update((Wrapper)luw);
    }

    @Override
    public CircleAdmin getByCircleId(Integer circleId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(CircleAdmin::getCircleId, (Object)circleId);
        lqw.eq(CircleAdmin::getIsDel, (Object)Boolean.FALSE);
        lqw.eq(CircleAdmin::getType, (Object)RoleEnum.CIRCLE_SUPER.getValue());
        return (CircleAdmin)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean isExistRole(Integer roleId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{CircleAdmin::getId});
        lqw.apply(StrUtil.format((CharSequence)" find_in_set('{}', roles)", (Object[])new Object[]{roleId}), new Object[0]);
        lqw.last(" limit 1");
        CircleAdmin circleAdmin = (CircleAdmin)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)circleAdmin);
    }

    @Override
    public CircleAdmin selectUserByAccountAndType(String account, Integer type) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (type.equals(RoleEnum.CIRCLE_ADMIN.getValue()) || type.equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            types.add(RoleEnum.CIRCLE_SUPER.getValue());
            types.add(RoleEnum.CIRCLE_ADMIN.getValue());
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(CircleAdmin::getAccount, (Object)account);
        lqw.in(CircleAdmin::getType, types);
        lqw.eq(CircleAdmin::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (CircleAdmin)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public PageInfo<SystemAdminResponse> getCircleAdminList(SystemAdminRequest request, PageParamRequest pageParamRequest) {
        List circleAdmins;
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(CircleAdmin::getStatus, (Object)request.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRealName())) {
            String decode = URLUtil.decode((String)request.getRealName());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(CircleAdmin::getRealName, (Object)decode)).or()).like(CircleAdmin::getAccount, (Object)decode);
            });
        }
        SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
        lqw.eq(CircleAdmin::getCircleId, (Object)currentAdmin.getCircleId());
        lqw.eq(CircleAdmin::getIsDel, (Object)Boolean.FALSE);
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.add(RoleEnum.CIRCLE_ADMIN.getValue());
        types.add(RoleEnum.CIRCLE_SUPER.getValue());
        lqw.in(CircleAdmin::getType, types);
        if (ObjectUtil.isNotNull((Object)request.getRoles()) && request.getRoles() > 0) {
            lqw.apply(" find_in_set({0}, roles)", new Object[]{request.getRoles()});
        }
        if (CollUtil.isEmpty((Collection)(circleAdmins = this.dao.selectList((Wrapper)lqw)))) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        ArrayList<SystemAdminResponse> adminResponseList = new ArrayList<SystemAdminResponse>();
        List<CircleRole> roleList = this.circleRoleService.getListByCircleId(currentAdmin.getCircleId());
        for (CircleAdmin admin : circleAdmins) {
            SystemAdminResponse sar = new SystemAdminResponse();
            BeanUtils.copyProperties((Object)admin, (Object)sar);
            sar.setLastTime(admin.getUpdateTime());
            List roleIds = CrmebUtil.stringToArrayInt((String)admin.getRoles());
            ArrayList<String> roleNames = new ArrayList<String>();
            for (Integer roleId : roleIds) {
                if (5 == roleId) {
                    roleNames.add("\u5708\u5c42\u8d85\u7ba1");
                    continue;
                }
                for (CircleRole role : roleList) {
                    if (!role.getId().equals(roleId)) continue;
                    roleNames.add(role.getRoleName());
                }
            }
            sar.setRoleNames(StringUtils.join(roleNames, (String)","));
            if (this.crmebConfig.getPhoneMaskSwitch().booleanValue() && StrUtil.isNotBlank((CharSequence)sar.getPhone())) {
                sar.setPhone(CrmebUtil.maskMobile((String)sar.getPhone()));
            }
            adminResponseList.add(sar);
        }
        return CommonPage.copyPageInfo((Page)page, adminResponseList);
    }

    @Override
    public Boolean saveCircleAdmin(SystemAdminAddRequest request) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        if (this.checkAdminAccount(request.getAccount()) > 0) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_EXIST);
        }
        CircleAdmin circleAdmin = new CircleAdmin();
        BeanUtils.copyProperties((Object)request, (Object)circleAdmin);
        String pwd = CrmebUtil.encryptPassword((String)circleAdmin.getPwd(), (String)circleAdmin.getAccount());
        circleAdmin.setPwd(pwd);
        circleAdmin.setCircleId(currentUser.getCircleId());
        circleAdmin.setType(RoleEnum.CIRCLE_ADMIN.getValue());
        return this.save(circleAdmin);
    }

    @Override
    public Boolean removeCircleAdmin(Integer id) {
        CircleAdmin perDelAdmin = this.getDetail(id);
        if (perDelAdmin.getType().equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d85\u7ea7\u7ba1\u7406\u5458\u6b64\u5904\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(CircleAdmin::getId, (Object)id);
        wrapper.set(CircleAdmin::getIsDel, (Object)true);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean updateCircleAdmin(SystemAdminUpdateRequest request) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        CircleAdmin adminDetail = this.getDetail(request.getId());
        if (adminDetail.getType().equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d85\u7ea7\u7ba1\u7406\u5458\u6b64\u5904\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        this.verifyAccount(request.getId(), request.getAccount());
        CircleAdmin circleAdmin = new CircleAdmin();
        circleAdmin.setId(request.getId());
        circleAdmin.setAccount(request.getAccount());
        circleAdmin.setRealName(request.getRealName());
        circleAdmin.setRoles(request.getRoles());
        circleAdmin.setStatus(request.getStatus());
        if (StrUtil.isNotBlank((CharSequence)request.getPhone())) {
            circleAdmin.setPhone(request.getPhone());
        }
        circleAdmin.setCircleId(currentUser.getCircleId());
        circleAdmin.setUpdateTime((Date)DateUtil.date());
        return this.updateById(circleAdmin);
    }

    private void verifyAccount(Integer id, String account) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.ne(CircleAdmin::getId, (Object)id);
        lqw.eq(CircleAdmin::getAccount, (Object)account);
        CircleAdmin circleAdmin = (CircleAdmin)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)circleAdmin)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d26\u53f7\u5df2\u5b58\u5728");
        }
    }

    @Override
    public CircleAdmin getDetail(Integer id) {
        CircleAdmin circleAdmin = (CircleAdmin)this.getById(id);
        if (ObjectUtil.isNull((Object)circleAdmin) || circleAdmin.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_NOT_EXIST);
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (!admin.getCircleId().equals(circleAdmin.getCircleId())) {
            throw new CrmebException((IResultEnum)AdminResultCode.ADMIN_NOT_EXIST);
        }
        return circleAdmin;
    }

    @Override
    public Boolean updateCircleAdminStatus(Integer id, Boolean status) {
        CircleAdmin adminDetail = this.getDetail(id);
        if (adminDetail.getType().equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d85\u7ea7\u7ba1\u7406\u5458\u6b64\u5904\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (adminDetail.getStatus().equals(status)) {
            return true;
        }
        adminDetail.setStatus(status);
        adminDetail.setUpdateTime((Date)DateUtil.date());
        return this.updateById(adminDetail);
    }

    @Override
    public Boolean updateCircleAdminPassword(SystemAdminUpdatePwdRequest request) {
        if (!request.getPassword().equals(request.getConfirmPassword())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e24\u6b21\u5bc6\u7801\u8f93\u5165\u4e0d\u4e00\u81f4");
        }
        CircleAdmin adminDetail = this.getDetail(request.getId());
        if (adminDetail.getType().equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d85\u7ea7\u7ba1\u7406\u5458\u6b64\u5904\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(CircleAdmin::getId, (Object)request.getId());
        wrapper.set(CircleAdmin::getPwd, (Object)CrmebUtil.encryptPassword((String)request.getPassword(), (String)adminDetail.getAccount()));
        return this.update((Wrapper)wrapper);
    }
}

