/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.constants.CouponConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.dto.ProductPriceCalculateDto;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.cat.Cart;
import com.zbkj.common.model.coupon.Coupon;
import com.zbkj.common.model.coupon.CouponUser;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.product.ProductCategory;
import com.zbkj.common.model.user.User;
import com.zbkj.common.request.CartNumRequest;
import com.zbkj.common.request.CartRequest;
import com.zbkj.common.request.CartResetRequest;
import com.zbkj.common.response.CartInfoResponse;
import com.zbkj.common.response.CartMerchantResponse;
import com.zbkj.common.response.CartPriceResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.dao.CartDao;
import com.zbkj.service.service.CartService;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductCategoryService;
import com.zbkj.service.service.ProductRelationService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.UserService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class CartServiceImpl
extends ServiceImpl<CartDao, Cart>
implements CartService {
    @Resource
    private CartDao dao;
    @Autowired
    private ProductService productService;
    @Autowired
    private UserService userService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private ProductRelationService productRelationService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private ProductCategoryService productCategoryService;

    @Override
    public List<CartMerchantResponse> getList(boolean isValid) {
        Integer userId = this.userService.getUserIdException();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Cart::getUid, (Object)userId);
        lqw.eq(Cart::getStatus, (Object)isValid);
        lqw.orderByDesc(Cart::getId);
        List cartList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)cartList)) {
            return CollUtil.newArrayList((Object[])new CartMerchantResponse[0]);
        }
        List<Integer> merIdList = cartList.stream().map(Cart::getMerId).distinct().collect(Collectors.toList());
        Map<Integer, Merchant> merchantMap = this.merchantService.getMerIdMapByIdList(merIdList);
        ArrayList responseList = CollUtil.newArrayList((Object[])new CartMerchantResponse[0]);
        merIdList.forEach(merId -> {
            CartMerchantResponse merchantResponse = new CartMerchantResponse();
            merchantResponse.setMerId(merId);
            merchantResponse.setMerName(((Merchant)merchantMap.get(merId)).getName());
            merchantResponse.setMerIsSelf(((Merchant)merchantMap.get(merId)).getIsSelf());
            List merCartList = cartList.stream().filter(e -> e.getMerId().equals(merId)).collect(Collectors.toList());
            List infoResponseList = merCartList.stream().map(storeCart -> {
                CartInfoResponse cartInfoResponse = new CartInfoResponse();
                BeanUtils.copyProperties((Object)storeCart, (Object)cartInfoResponse);
                Product product = this.productService.getCartByProId(storeCart.getProductId());
                cartInfoResponse.setImage(product.getImage());
                cartInfoResponse.setProName(product.getName());
                cartInfoResponse.setDeliveryMethod(product.getDeliveryMethod());
                if (!isValid) {
                    cartInfoResponse.setAttrStatus(Boolean.valueOf(false));
                    return cartInfoResponse;
                }
                ProductAttrValue attrValue = this.productAttrValueService.getByProductIdAndAttrId(storeCart.getProductId(), storeCart.getProductAttrUnique(), ProductConstants.PRODUCT_TYPE_NORMAL, ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
                if (ObjectUtil.isNull((Object)attrValue) || !attrValue.getIsShow().booleanValue()) {
                    cartInfoResponse.setAttrStatus(Boolean.valueOf(false));
                    return cartInfoResponse;
                }
                if (StrUtil.isNotBlank((CharSequence)attrValue.getImage())) {
                    cartInfoResponse.setImage(attrValue.getImage());
                }
                cartInfoResponse.setSku(attrValue.getSku());
                cartInfoResponse.setPrice(attrValue.getPrice());
                cartInfoResponse.setAttrId(attrValue.getId());
                cartInfoResponse.setAttrStatus(Boolean.valueOf(attrValue.getStock() > 0));
                cartInfoResponse.setStock(attrValue.getStock());
                if (product.getIsPaidMember().booleanValue()) {
                    cartInfoResponse.setVipPrice(attrValue.getVipPrice());
                    cartInfoResponse.setIsPaidMember(Boolean.valueOf(true));
                }
                return cartInfoResponse;
            }).collect(Collectors.toList());
            merchantResponse.setCartInfoList(infoResponseList);
            responseList.add(merchantResponse);
        });
        return responseList;
    }

    @Override
    public Map<String, Integer> getUserCount(CartNumRequest request) {
        Integer userId = this.userService.getUserIdException();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int num = request.getType().equals("total") ? this.getUserCountByStatus(userId, request.getNumType()).intValue() : this.getUserSumByStatus(userId, request.getNumType()).intValue();
        map.put("count", num);
        return map;
    }

    @Override
    public Boolean add(CartRequest request) {
        Product product = this.getAwaitAddProduct(request.getProductId());
        ProductAttrValue attrValue = this.productAttrValueService.getByProductIdAndAttrId(product.getId(), request.getProductAttrUnique(), ProductConstants.PRODUCT_TYPE_NORMAL, ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        if (ObjectUtil.isNull((Object)attrValue) || !attrValue.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_ATTR_VALUE_NOT_EXIST);
        }
        if (attrValue.getStock() < request.getCartNum()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d27\u7269\u5e93\u5b58\u4e0d\u8db3");
        }
        if (product.getSystemFormId() > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5173\u8054\u81ea\u5b9a\u4e49\u7cfb\u7edf\u8868\u5355\u7684\u5546\u54c1\uff0c\u4e0d\u652f\u6301\u52a0\u8d2d\u7269\u8f66");
        }
        User user = this.userService.getInfo();
        Cart forUpdateStoreCart = this.getByUniqueAndUid(request.getProductAttrUnique(), user.getId());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            if (ObjectUtil.isNotNull((Object)forUpdateStoreCart)) {
                forUpdateStoreCart.setCartNum(Integer.valueOf(forUpdateStoreCart.getCartNum() + request.getCartNum()));
                forUpdateStoreCart.setUpdateTime((Date)DateUtil.date());
                boolean updateResult = this.updateById(forUpdateStoreCart);
                if (!updateResult) {
                    throw new CrmebException("\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25");
                }
            } else {
                Cart storeCart = new Cart();
                BeanUtils.copyProperties((Object)request, (Object)storeCart);
                storeCart.setUid(user.getId());
                storeCart.setMerId(product.getMerId());
                if (this.dao.insert(storeCart) <= 0) {
                    throw new CrmebException("\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25");
                }
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.purchaseStatistics(request.getProductId(), request.getCartNum());
        }
        return execute;
    }

    private Product getAwaitAddProduct(Integer productId) {
        Product product = (Product)this.productService.getById(productId);
        if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue() || !product.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (product.getMarketingType() > ProductConstants.PRODUCT_MARKETING_TYPE_BASE) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8425\u9500\u5546\u54c1\u4e0d\u652f\u6301\u52a0\u5165\u8d2d\u7269\u8f66");
        }
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CLOUD)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e91\u76d8\u5546\u54c1\u4e0d\u652f\u6301\u52a0\u5165\u8d2d\u7269\u8f66");
        }
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5361\u5bc6\u5546\u54c1\u4e0d\u652f\u6301\u52a0\u5165\u8d2d\u7269\u8f66");
        }
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_COMPONENT)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u89c6\u9891\u53f7\u5546\u54c1\u4e0d\u652f\u6301\u52a0\u5165\u8d2d\u7269\u8f66");
        }
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_VIRTUALLY)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u865a\u62df\u5546\u54c1\u4e0d\u652f\u6301\u52a0\u5165\u8d2d\u7269\u8f66");
        }
        return product;
    }

    @Override
    public Boolean batchAdd(List<CartRequest> cartListRequest) {
        if (CollUtil.isEmpty(cartListRequest)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u7269\u8f66\u6dfb\u52a0\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList updateCartList = new ArrayList();
        ArrayList addCartList = new ArrayList();
        User currentUser = this.userService.getInfo();
        cartListRequest.forEach(cartRequest -> {
            Product product = this.getAwaitAddProduct(cartRequest.getProductId());
            ProductAttrValue attrValue = this.productAttrValueService.getByProductIdAndAttrId(cartRequest.getProductId(), cartRequest.getProductAttrUnique(), ProductConstants.PRODUCT_TYPE_NORMAL, ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
            if (ObjectUtil.isNull((Object)attrValue) || !attrValue.getIsShow().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_ATTR_VALUE_NOT_EXIST);
            }
            if (attrValue.getStock() < cartRequest.getCartNum()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d27\u7269\u5e93\u5b58\u4e0d\u8db3");
            }
            Cart forUpdateStoreCart = this.getByUniqueAndUid(cartRequest.getProductAttrUnique(), currentUser.getId());
            if (ObjectUtil.isNotNull((Object)forUpdateStoreCart)) {
                forUpdateStoreCart.setCartNum(Integer.valueOf(forUpdateStoreCart.getCartNum() + cartRequest.getCartNum()));
                forUpdateStoreCart.setUpdateTime((Date)DateUtil.date());
                updateCartList.add(forUpdateStoreCart);
            } else {
                Cart cart = new Cart();
                BeanUtils.copyProperties((Object)cartRequest, (Object)cart);
                cart.setUid(currentUser.getId());
                cart.setMerId(product.getMerId());
                addCartList.add(cart);
            }
        });
        Boolean execute = (Boolean)this.transactionTemplate.execute(exec -> {
            this.saveBatch(addCartList);
            this.updateBatchById(updateCartList);
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            cartListRequest.forEach(cart -> this.purchaseStatistics(cart.getProductId(), cart.getCartNum()));
        }
        return execute;
    }

    private void purchaseStatistics(Integer productId, Integer num) {
        String todayStr = DateUtil.date().toString("yyyy-MM-dd");
        this.redisUtil.incrAndCreate("statistics:product:add_cart:" + todayStr, (long)num.intValue());
        this.redisUtil.incrAndCreate(StrUtil.format((CharSequence)"statistics:product:pro_add_cart:{}:{}", (Object[])new Object[]{todayStr, productId}), (long)num.intValue());
    }

    private Cart getByUniqueAndUid(Integer productAttrUnique, Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Cart::getProductAttrUnique, (Object)productAttrUnique);
        lqw.eq(Cart::getUid, (Object)uid);
        lqw.last(" limit 1");
        return (Cart)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean deleteCartByIds(List<Integer> ids) {
        return this.dao.deleteBatchIds(ids) > 0;
    }

    @Override
    public Boolean productStatusNotEnable(Integer productId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Cart::getStatus, (Object)false);
        wrapper.eq(Cart::getProductId, (Object)productId);
        wrapper.eq(Cart::getStatus, (Object)true);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean resetCart(CartResetRequest resetRequest) {
        boolean updateResult;
        Cart cart = (Cart)this.getById(resetRequest.getId());
        if (ObjectUtil.isNull((Object)cart)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728");
        }
        Product product = this.getAwaitAddProduct(resetRequest.getProductId());
        ProductAttrValue attrValue = this.productAttrValueService.getByProductIdAndAttrId(product.getId(), resetRequest.getUnique(), ProductConstants.PRODUCT_TYPE_NORMAL, ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        if (ObjectUtil.isNull((Object)attrValue) || !attrValue.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_ATTR_VALUE_NOT_EXIST);
        }
        if (attrValue.getStock() < resetRequest.getNum()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d27\u7269\u5e93\u5b58\u4e0d\u8db3");
        }
        cart.setCartNum(resetRequest.getNum());
        cart.setProductAttrUnique(resetRequest.getUnique());
        cart.setStatus(Boolean.valueOf(true));
        cart.setMerId(product.getMerId());
        cart.setUpdateTime((Date)DateUtil.date());
        boolean bl = updateResult = this.dao.updateById(cart) > 0;
        if (!updateResult) {
            throw new CrmebException("\u91cd\u9009\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25");
        }
        this.purchaseStatistics(cart.getProductId(), resetRequest.getNum());
        return updateResult;
    }

    @Override
    public Boolean productStatusNoEnable(List<Integer> skuIdList) {
        LambdaUpdateWrapper lqw = new LambdaUpdateWrapper();
        lqw.set(Cart::getStatus, (Object)true);
        lqw.in(Cart::getProductAttrUnique, skuIdList);
        return this.update((Wrapper)lqw);
    }

    @Override
    public Boolean productDelete(Integer productId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(Cart::getProductId, (Object)productId);
        return this.dao.delete((Wrapper)wrapper) > 0;
    }

    @Override
    public Cart getByIdAndUid(Integer id, Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Cart::getId, (Object)id);
        lqw.eq(Cart::getUid, (Object)uid);
        lqw.eq(Cart::getStatus, (Object)true);
        lqw.last(" limit 1");
        return (Cart)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean updateCartNum(Integer id, Integer number) {
        if (number <= 0 || number > 999) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u52a0\u8d2d\u6570\u4e0d\u80fd\u5c0f\u4e8e1\u4e14\u5927\u4e8e999");
        }
        Cart storeCart = (Cart)this.getById(id);
        if (ObjectUtil.isNull((Object)storeCart)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524d\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728");
        }
        if (storeCart.getCartNum().equals(number)) {
            return Boolean.TRUE;
        }
        ProductAttrValue attrValue = this.productAttrValueService.getByProductIdAndAttrId(storeCart.getProductId(), storeCart.getProductAttrUnique(), ProductConstants.PRODUCT_TYPE_NORMAL, ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        if (ObjectUtil.isNull((Object)attrValue)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_ATTR_VALUE_NOT_EXIST);
        }
        if (attrValue.getStock() < number) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d27\u7269\u5e93\u5b58\u4e0d\u8db3");
        }
        storeCart.setCartNum(number);
        storeCart.setUpdateTime((Date)DateUtil.date());
        return this.updateById(storeCart);
    }

    @Override
    public Boolean toCollect(List<Integer> ids) {
        Integer userId = this.userService.getUserIdException();
        List<Cart> cartList = this.findListByIds(ids);
        if (CollUtil.isEmpty(cartList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728");
        }
        if (cartList.size() != ids.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u7269\u8f66\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009");
        }
        List proIdList = cartList.stream().map(Cart::getProductId).distinct().collect(Collectors.toList());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.deleteCartByIds(ids);
            this.productRelationService.deleteByUidAndProIdList(userId, proIdList);
            this.productRelationService.batchAdd(userId, proIdList);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean deleteByUid(Integer uid) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(Cart::getUid, (Object)uid);
        return this.remove((Wrapper)wrapper);
    }

    @Override
    public CartPriceResponse calculatePrice(List<Integer> ids) {
        BigDecimal proSubPrice;
        BigDecimal proPrice;
        List pIdList;
        List cidList;
        BigDecimal proPrice2;
        Integer userId = this.userService.getUserIdException();
        List<Cart> cartList = this.findListByIds(ids);
        User user = (User)this.userService.getById(userId);
        ArrayList<Integer> proIdList = new ArrayList<Integer>();
        HashMap<Integer, ProductAttrValue> attrValueMap = new HashMap<Integer, ProductAttrValue>();
        BigDecimal totalPrice = BigDecimal.ZERO;
        BigDecimal proTotalPrice = BigDecimal.ZERO;
        ArrayList<Product> productList = new ArrayList<Product>();
        ArrayList<ProductPriceCalculateDto> dtoList = new ArrayList<ProductPriceCalculateDto>();
        for (Cart cart : cartList) {
            if (!cart.getStatus().booleanValue()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u7269\u626f\u5546\u54c1\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1");
            }
            Product product = (Product)this.productService.getById(cart.getProductId());
            if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (!product.getIsShow().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (product.getStock().equals(0) || cart.getCartNum() > product.getStock()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u4e70\u7684\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
            }
            ProductAttrValue attrValue = this.productAttrValueService.getByIdAndProductIdAndType(cart.getProductAttrUnique(), cart.getProductId(), ProductConstants.PRODUCT_TYPE_NORMAL);
            if (ObjectUtil.isNull((Object)attrValue)) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_ATTR_VALUE_NOT_EXIST);
            }
            if (attrValue.getStock() < cart.getCartNum()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8d2d\u4e70\u7684\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
            }
            if (!proIdList.contains(product.getId())) {
                productList.add(product);
                proIdList.add(product.getId());
            }
            attrValue.setIsPaidMember(product.getIsPaidMember());
            attrValueMap.put(attrValue.getId(), attrValue);
            totalPrice = totalPrice.add(attrValue.getPrice().multiply(new BigDecimal(cart.getCartNum().toString())));
            proTotalPrice = product.getIsPaidMember() != false && user.getIsPaidMember() != false ? proTotalPrice.add(attrValue.getVipPrice().multiply(new BigDecimal(cart.getCartNum().toString()))) : proTotalPrice.add(attrValue.getPrice().multiply(new BigDecimal(cart.getCartNum().toString())));
            ProductPriceCalculateDto dto = new ProductPriceCalculateDto();
            dto.setProductId(product.getId());
            dto.setAttrValueId(attrValue.getId());
            dto.setMerchantId(product.getMerId());
            dto.setNum(cart.getCartNum());
            dto.setPrice(attrValue.getPrice());
            dto.setVipPrice(attrValue.getVipPrice());
            dto.setIsPaidMember(product.getIsPaidMember());
            dtoList.add(dto);
        }
        Map<Integer, List<Cart>> merCartMap = cartList.stream().collect(Collectors.groupingBy(Cart::getMerId));
        ArrayList<Integer> merIdList = new ArrayList<Integer>(merCartMap.keySet());
        BigDecimal merCouponPrice = BigDecimal.ZERO;
        for (Map.Entry<Integer, List<Cart>> entry : merCartMap.entrySet()) {
            List<CouponUser> merCouponUserList;
            Integer merId = entry.getKey();
            List<Cart> carts = entry.getValue();
            BigDecimal merProTotalPrice = BigDecimal.ZERO;
            for (Cart cart : carts) {
                ProductAttrValue attrValue = (ProductAttrValue)attrValueMap.get(cart.getProductAttrUnique());
                BigDecimal multiply = attrValue.getIsPaidMember() != false && user.getIsPaidMember() != false ? attrValue.getVipPrice().multiply(new BigDecimal(cart.getCartNum().toString())) : attrValue.getPrice().multiply(new BigDecimal(cart.getCartNum().toString()));
                merProTotalPrice = merProTotalPrice.add(multiply);
            }
            List<Integer> merProIdList = carts.stream().map(Cart::getProductId).distinct().collect(Collectors.toList());
            List<Coupon> merCouponList = this.couponService.findManyByMerIdAndMoney(merId, merProIdList, merProTotalPrice);
            if (CollUtil.isNotEmpty(merCouponList)) {
                int i = 0;
                while (i < merCouponList.size()) {
                    Coupon coupon = merCouponList.get(i);
                    if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_MERCHANT)) {
                        ++i;
                        continue;
                    }
                    List cpIdList = CrmebUtil.stringToArray((String)coupon.getLinkedData());
                    List merCartList = carts.stream().filter(f -> cpIdList.contains(f.getProductId())).collect(Collectors.toList());
                    proPrice2 = merCartList.stream().map(e -> {
                        ProductAttrValue productAttrValue = (ProductAttrValue)attrValueMap.get(e.getProductAttrUnique());
                        BigDecimal price = productAttrValue.getIsPaidMember() != false && user.getIsPaidMember() != false ? productAttrValue.getVipPrice().multiply(new BigDecimal(e.getCartNum().toString())) : productAttrValue.getPrice().multiply(new BigDecimal(e.getCartNum().toString()));
                        return price;
                    }).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (proPrice2.compareTo(new BigDecimal(coupon.getMinPrice().toString())) < 0) {
                        merCouponList.remove(i);
                        continue;
                    }
                    if (proPrice2.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                        merCouponList.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
            if (CollUtil.isNotEmpty(merCouponUserList = this.couponUserService.findManyByUidAndMerIdAndMoneyAndProList(userId, merId, merProIdList, merProTotalPrice))) {
                int i = 0;
                while (i < merCouponUserList.size()) {
                    CouponUser couponUser = merCouponUserList.get(i);
                    if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_MERCHANT)) {
                        ++i;
                        continue;
                    }
                    Coupon coupon = (Coupon)this.couponService.getById(couponUser.getCouponId());
                    List cpIdList = CrmebUtil.stringToArray((String)coupon.getLinkedData());
                    List merCartList = carts.stream().filter(f -> cpIdList.contains(f.getProductId())).collect(Collectors.toList());
                    BigDecimal proPrice3 = merCartList.stream().map(e -> {
                        ProductAttrValue productAttrValue = (ProductAttrValue)attrValueMap.get(e.getProductAttrUnique());
                        BigDecimal price = productAttrValue.getIsPaidMember() != false && user.getIsPaidMember() != false ? productAttrValue.getVipPrice().multiply(new BigDecimal(e.getCartNum().toString())) : productAttrValue.getPrice().multiply(new BigDecimal(e.getCartNum().toString()));
                        return price;
                    }).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (proPrice3.compareTo(new BigDecimal(couponUser.getMinPrice().toString())) < 0) {
                        merCouponUserList.remove(i);
                        continue;
                    }
                    if (proPrice3.compareTo(new BigDecimal(couponUser.getMoney().toString())) <= 0) {
                        merCouponUserList.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
            cidList = merCouponUserList.stream().map(CouponUser::getCouponId).collect(Collectors.toList());
            int i = 0;
            while (i < merCouponList.size()) {
                if (cidList.contains(merCouponList.get(i).getId())) {
                    merCouponList.remove(i);
                    continue;
                }
                if (!this.couponUserService.userIsCanReceiveCoupon(merCouponList.get(i), userId).booleanValue()) {
                    merCouponList.remove(i);
                    continue;
                }
                ++i;
            }
            if (CollUtil.isEmpty(merCouponList) && CollUtil.isEmpty(merCouponUserList)) continue;
            if (CollUtil.isEmpty(merCouponList)) {
                CouponUser couponUser = merCouponUserList.get(0);
                merCouponPrice = new BigDecimal(couponUser.getMoney().toString());
                this.setMerProCouponPrice(dtoList, merId, merCouponPrice, null, couponUser, user.getIsPaidMember());
                continue;
            }
            if (CollUtil.isEmpty(merCouponUserList)) {
                Coupon coupon = merCouponList.get(0);
                merCouponPrice = new BigDecimal(coupon.getMoney().toString());
                this.setMerProCouponPrice(dtoList, merId, merCouponPrice, coupon, null, user.getIsPaidMember());
                continue;
            }
            Coupon coupon = merCouponList.get(0);
            CouponUser couponUser = merCouponUserList.get(0);
            if (couponUser.getMoney() >= coupon.getMoney()) {
                merCouponPrice = new BigDecimal(couponUser.getMoney().toString());
                this.setMerProCouponPrice(dtoList, merId, merCouponPrice, null, couponUser, user.getIsPaidMember());
                continue;
            }
            merCouponPrice = new BigDecimal(coupon.getMoney().toString());
            this.setMerProCouponPrice(dtoList, merId, merCouponPrice, coupon, null, user.getIsPaidMember());
        }
        merCouponPrice = dtoList.stream().map(ProductPriceCalculateDto::getMerCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal remainingAmount = proTotalPrice.subtract(merCouponPrice);
        List<Integer> proCategoryIdList = productList.stream().map(Product::getCategoryId).collect(Collectors.toList());
        List<Integer> secondParentIdList = this.productCategoryService.findParentIdByChildIds(proCategoryIdList);
        List<Integer> firstParentIdList = this.productCategoryService.findParentIdByChildIds(secondParentIdList);
        proCategoryIdList.addAll(secondParentIdList);
        proCategoryIdList.addAll(firstParentIdList);
        List<Integer> brandIdList = productList.stream().map(Product::getBrandId).collect(Collectors.toList());
        List<Coupon> platCouponList = this.couponService.findManyPlatByMerIdAndMoney(proIdList, proCategoryIdList, merIdList, brandIdList, proTotalPrice);
        int i = 0;
        while (i < platCouponList.size()) {
            BigDecimal proSubPrice2;
            BigDecimal proPrice4;
            List pIdList2;
            Coupon coupon = platCouponList.get(i);
            if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_UNIVERSAL)) {
                if (proTotalPrice.compareTo(new BigDecimal(coupon.getMinPrice().toString())) < 0) {
                    platCouponList.remove(i);
                    continue;
                }
                if (remainingAmount.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                    platCouponList.remove(i);
                    continue;
                }
            }
            if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
                List cpIdList = CrmebUtil.stringToArray((String)coupon.getLinkedData());
                BigDecimal proPrice5 = dtoList.stream().filter(f -> cpIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal proSubPrice3 = dtoList.stream().filter(f -> cpIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price.subtract(e.getMerCouponPrice());
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (proPrice5.compareTo(new BigDecimal(coupon.getMinPrice().toString())) < 0) {
                    platCouponList.remove(i);
                    continue;
                }
                if (proSubPrice3.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                    platCouponList.remove(i);
                    continue;
                }
            }
            if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT_CATEGORY)) {
                cidList = new ArrayList();
                Integer categoryId = Integer.valueOf(coupon.getLinkedData());
                ProductCategory category = (ProductCategory)this.productCategoryService.getById(categoryId);
                if (category.getLevel().equals(3)) {
                    cidList.add(categoryId);
                } else {
                    List<Object> productCategoryList = this.productCategoryService.findAllChildListByPid(category.getId(), category.getLevel());
                    if (category.getLevel().equals(1)) {
                        productCategoryList = productCategoryList.stream().filter(f -> f.getLevel().equals(3)).collect(Collectors.toList());
                    }
                    cidList.addAll(productCategoryList.stream().map(ProductCategory::getId).collect(Collectors.toList()));
                }
                pIdList = productList.stream().filter(f -> cidList.contains(f.getCategoryId())).map(Product::getId).collect(Collectors.toList());
                proPrice = dtoList.stream().filter(f -> pIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                proSubPrice = dtoList.stream().filter(f -> pIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price.subtract(e.getMerCouponPrice());
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (proPrice.compareTo(new BigDecimal(coupon.getMinPrice().toString())) < 0) {
                    platCouponList.remove(i);
                    continue;
                }
                if (proSubPrice.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                    platCouponList.remove(i);
                    continue;
                }
            }
            if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_BRAND)) {
                Integer brandId = Integer.valueOf(coupon.getLinkedData());
                pIdList2 = productList.stream().filter(f -> brandId.equals(f.getBrandId())).map(Product::getId).collect(Collectors.toList());
                proPrice4 = dtoList.stream().filter(f -> pIdList2.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                proSubPrice2 = dtoList.stream().filter(f -> pIdList2.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price.subtract(e.getMerCouponPrice());
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (proPrice4.compareTo(new BigDecimal(coupon.getMinPrice().toString())) < 0) {
                    platCouponList.remove(i);
                    continue;
                }
                if (proSubPrice2.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                    platCouponList.remove(i);
                    continue;
                }
            }
            if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_JOINT_MERCHANT)) {
                List mpIdList = CrmebUtil.stringToArray((String)coupon.getLinkedData());
                pIdList2 = productList.stream().filter(f -> mpIdList.contains(f.getMerId())).map(Product::getId).collect(Collectors.toList());
                proPrice4 = dtoList.stream().filter(f -> pIdList2.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                proSubPrice2 = dtoList.stream().filter(f -> pIdList2.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price.subtract(e.getMerCouponPrice());
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (proPrice4.compareTo(new BigDecimal(coupon.getMinPrice().toString())) < 0) {
                    platCouponList.remove(i);
                    continue;
                }
                if (proSubPrice2.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                    platCouponList.remove(i);
                    continue;
                }
            }
            ++i;
        }
        List<CouponUser> platCouponUserList = this.couponUserService.findManyPlatByUidAndMerIdAndMoneyAndProList(userId, proIdList, proCategoryIdList, merIdList, brandIdList, proTotalPrice);
        int i2 = 0;
        while (i2 < platCouponUserList.size()) {
            CouponUser couponUser = platCouponUserList.get(i2);
            if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_UNIVERSAL)) {
                if (proTotalPrice.compareTo(new BigDecimal(couponUser.getMinPrice().toString())) < 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
                if (remainingAmount.compareTo(new BigDecimal(couponUser.getMoney().toString())) <= 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
            }
            Coupon coupon = (Coupon)this.couponService.getById(couponUser.getCouponId());
            if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
                List cpIdList = CrmebUtil.stringToArray((String)coupon.getLinkedData());
                proPrice2 = dtoList.stream().filter(f -> cpIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal proSubPrice4 = dtoList.stream().filter(f -> cpIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price.subtract(e.getMerCouponPrice());
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (proPrice2.compareTo(new BigDecimal(couponUser.getMinPrice().toString())) < 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
                if (proSubPrice4.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
            }
            if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT_CATEGORY)) {
                ArrayList<Integer> cidList2 = new ArrayList<Integer>();
                Integer categoryId = Integer.valueOf(coupon.getLinkedData());
                ProductCategory category = (ProductCategory)this.productCategoryService.getById(categoryId);
                if (category.getLevel().equals(3)) {
                    cidList2.add(categoryId);
                } else {
                    List<Object> productCategoryList = this.productCategoryService.findAllChildListByPid(category.getId(), category.getLevel());
                    if (category.getLevel().equals(1)) {
                        productCategoryList = productCategoryList.stream().filter(f -> f.getLevel().equals(3)).collect(Collectors.toList());
                    }
                    cidList2.addAll(productCategoryList.stream().map(ProductCategory::getId).collect(Collectors.toList()));
                }
                List pIdList3 = productList.stream().filter(f -> cidList2.contains(f.getCategoryId())).map(Product::getId).collect(Collectors.toList());
                BigDecimal proPrice6 = dtoList.stream().filter(f -> pIdList3.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal proSubPrice5 = dtoList.stream().filter(f -> pIdList3.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price.subtract(e.getMerCouponPrice());
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (proPrice6.compareTo(new BigDecimal(couponUser.getMinPrice().toString())) < 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
                if (proSubPrice5.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
            }
            if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_BRAND)) {
                Integer brandId = Integer.valueOf(coupon.getLinkedData());
                pIdList = productList.stream().filter(f -> brandId.equals(f.getBrandId())).map(Product::getId).collect(Collectors.toList());
                proPrice = dtoList.stream().filter(f -> pIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                proSubPrice = dtoList.stream().filter(f -> pIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price.subtract(e.getMerCouponPrice());
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (proPrice.compareTo(new BigDecimal(couponUser.getMinPrice().toString())) < 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
                if (proSubPrice.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
            }
            if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_JOINT_MERCHANT)) {
                List mpIdList = CrmebUtil.stringToArray((String)coupon.getLinkedData());
                pIdList = productList.stream().filter(f -> mpIdList.contains(f.getMerId())).map(Product::getId).collect(Collectors.toList());
                proPrice = dtoList.stream().filter(f -> pIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                proSubPrice = dtoList.stream().filter(f -> pIdList.contains(f.getProductId())).map(e -> {
                    BigDecimal price = e.getIsPaidMember() != false && user.getIsPaidMember() != false ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
                    return price.subtract(e.getMerCouponPrice());
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (proPrice.compareTo(new BigDecimal(couponUser.getMinPrice().toString())) < 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
                if (proSubPrice.compareTo(new BigDecimal(coupon.getMoney().toString())) <= 0) {
                    platCouponUserList.remove(i2);
                    continue;
                }
            }
            ++i2;
        }
        BigDecimal platCouponPrice = BigDecimal.ZERO;
        List platCidList = platCouponUserList.stream().map(CouponUser::getCouponId).collect(Collectors.toList());
        int i3 = 0;
        while (i3 < platCouponList.size()) {
            if (platCidList.contains(platCouponList.get(i3).getId())) {
                platCouponList.remove(i3);
                continue;
            }
            if (!this.couponUserService.userIsCanReceiveCoupon(platCouponList.get(i3), userId).booleanValue()) {
                platCouponList.remove(i3);
                continue;
            }
            ++i3;
        }
        if (CollUtil.isEmpty(platCouponList) && CollUtil.isNotEmpty(platCouponUserList)) {
            platCouponPrice = new BigDecimal(platCouponUserList.get(0).getMoney().toString());
        }
        if (CollUtil.isNotEmpty(platCouponList) && CollUtil.isEmpty(platCouponUserList)) {
            platCouponPrice = new BigDecimal(platCouponList.get(0).getMoney().toString());
        }
        if (CollUtil.isNotEmpty(platCouponList) && CollUtil.isNotEmpty(platCouponUserList)) {
            Long platCouponMoney = platCouponList.get(0).getMoney();
            Long platCouponUserMoney = platCouponUserList.get(0).getMoney();
            platCouponPrice = platCouponUserMoney >= platCouponMoney ? new BigDecimal(platCouponUserMoney.toString()) : new BigDecimal(platCouponMoney.toString());
        }
        CartPriceResponse cartPriceResponse = new CartPriceResponse();
        cartPriceResponse.setMerCouponPrice(merCouponPrice);
        cartPriceResponse.setPlatCouponPrice(platCouponPrice);
        cartPriceResponse.setProTotalPrice(totalPrice);
        cartPriceResponse.setSvipDiscountPrice(totalPrice.subtract(proTotalPrice));
        cartPriceResponse.setTotalCouponPrice(platCouponPrice.add(merCouponPrice).add(cartPriceResponse.getSvipDiscountPrice()));
        cartPriceResponse.setTotalPrice(totalPrice.subtract(cartPriceResponse.getTotalCouponPrice()));
        return cartPriceResponse;
    }

    private void setMerProCouponPrice(List<ProductPriceCalculateDto> dtoList, Integer merId, BigDecimal merCouponPrice, Coupon coupon, CouponUser couponUser, boolean userIsPaidMember) {
        if (ObjectUtil.isNull((Object)coupon)) {
            coupon = (Coupon)this.couponService.getById(couponUser.getCouponId());
        }
        List<Object> proDtoList = new ArrayList();
        if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_MERCHANT)) {
            proDtoList = dtoList.stream().filter(d -> d.getMerchantId().equals(merId)).collect(Collectors.toList());
        }
        if (coupon.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
            List proIdList = CrmebUtil.stringToArray((String)coupon.getLinkedData());
            proDtoList = dtoList.stream().filter(d -> proIdList.contains(d.getProductId())).collect(Collectors.toList());
        }
        BigDecimal proTotalPrice = proDtoList.stream().map(e -> {
            BigDecimal price = e.getIsPaidMember() != false && userIsPaidMember ? e.getVipPrice().multiply(new BigDecimal(e.getNum().toString())) : e.getPrice().multiply(new BigDecimal(e.getNum().toString()));
            return price;
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal couponPrice = merCouponPrice;
        for (int i = 0; i < proDtoList.size(); ++i) {
            ProductPriceCalculateDto d2 = (ProductPriceCalculateDto)proDtoList.get(i);
            if (proDtoList.size() == i + 1) {
                d2.setMerCouponPrice(couponPrice);
                break;
            }
            BigDecimal proPrice = d2.getIsPaidMember() != false && userIsPaidMember ? d2.getVipPrice().multiply(new BigDecimal(d2.getNum().toString())) : d2.getPrice().multiply(new BigDecimal(d2.getNum().toString()));
            BigDecimal ratio = proPrice.divide(proTotalPrice, 10, 4);
            BigDecimal detailCouponFee = couponPrice.multiply(ratio).setScale(2, 4);
            couponPrice = couponPrice.subtract(detailCouponFee);
            d2.setMerCouponPrice(detailCouponFee);
        }
    }

    private List<Cart> findListByIds(List<Integer> ids) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(Cart::getId, ids);
        return this.dao.selectList((Wrapper)lqw);
    }

    private Integer getUserCountByStatus(Integer userId, Boolean status) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Cart::getUid, (Object)userId);
        lqw.eq(Cart::getStatus, (Object)status);
        return this.dao.selectCount((Wrapper)lqw);
    }

    private Integer getUserSumByStatus(Integer userId, Boolean status) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"ifnull(sum(cart_num), 0) as cart_num"});
        queryWrapper.eq((Object)"uid", (Object)userId);
        queryWrapper.eq((Object)"status", (Object)status);
        Cart cart = (Cart)this.dao.selectOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNull((Object)cart)) {
            return 0;
        }
        return cart.getCartNum();
    }
}

