/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradeFastpayRefundQueryModel;
import com.alipay.api.domain.AlipayTradePrecreateModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.zbkj.common.constants.AlipayConfig;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.alipay.AliPayInfo;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.PayResultCode;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.service.service.AliPayInfoService;
import com.zbkj.service.service.AliPayService;
import com.zbkj.service.service.SystemConfigService;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliPayServiceImpl
implements AliPayService {
    private static final Logger logger = LoggerFactory.getLogger(AliPayServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private AliPayInfoService aliPayInfoService;

    @Override
    public Boolean refund(String outTradeNo, String refundOrderNo, String refundReasonWapExplain, BigDecimal refundPrice) {
        String out_trade_no = outTradeNo;
        String refund_amount = refundPrice.toString();
        String refund_reason = refundReasonWapExplain;
        String out_request_no = refundOrderNo;
        MyRecord aliPayRecord = this.getAliPayRecord();
        String aliPayAppid = aliPayRecord.getStr(AlipayConfig.APPID);
        String aliPayPrivateKey = aliPayRecord.getStr(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = aliPayRecord.getStr(AlipayConfig.ALIPAY_PUBLIC_KEY);
        DefaultAlipayClient client = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey, AlipayConfig.SIGNTYPE);
        AlipayTradeRefundRequest alipay_request = new AlipayTradeRefundRequest();
        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setOutTradeNo(out_trade_no);
        model.setRefundAmount(refund_amount);
        model.setRefundReason(refund_reason);
        model.setOutRequestNo(out_request_no);
        alipay_request.setBizModel((AlipayObject)model);
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        alipay_request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/alipay");
        AlipayTradeRefundResponse alipay_response = null;
        try {
            alipay_response = (AlipayTradeRefundResponse)client.execute((AlipayRequest)alipay_request);
        }
        catch (AlipayApiException e) {
            logger.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u7533\u8bf7\u5f02\u5e38\uff0calipay_response = " + alipay_response);
            logger.error(e.getMessage());
            throw new CrmebException("\u652f\u4ed8\u5b9d\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38");
        }
        if ("Y".equals(alipay_response.getFundChange())) {
            return Boolean.TRUE;
        }
        return this.queryRefund(outTradeNo, refundOrderNo);
    }

    private MyRecord getAliPayRecord() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(AlipayConfig.APPID);
        list.add(AlipayConfig.RSA_PRIVATE_KEY);
        list.add(AlipayConfig.ALIPAY_PUBLIC_KEY);
        MyRecord myRecord = this.systemConfigService.getValuesByKeyList(list);
        if (StrUtil.isBlank((CharSequence)myRecord.getStr(AlipayConfig.APPID))) {
            throw new CrmebException((IResultEnum)PayResultCode.ALI_PAY_NOT_CONFIG);
        }
        if (StrUtil.isBlank((CharSequence)myRecord.getStr(AlipayConfig.RSA_PRIVATE_KEY))) {
            throw new CrmebException((IResultEnum)PayResultCode.ALI_PAY_NOT_CONFIG);
        }
        if (StrUtil.isBlank((CharSequence)myRecord.getStr(AlipayConfig.ALIPAY_PUBLIC_KEY))) {
            throw new CrmebException((IResultEnum)PayResultCode.ALI_PAY_NOT_CONFIG);
        }
        return myRecord;
    }

    @Override
    public String pay(String orderNo, BigDecimal price, String orderType, String payChannel, String timeExpire) {
        String result;
        AlipayTradeWapPayResponse response;
        if (payChannel.equals("alipayApp")) {
            return this.appPay(orderNo, price, orderType, timeExpire);
        }
        if (payChannel.equals("alipayPc")) {
            return this.pcPay(orderNo, price, orderType, timeExpire);
        }
        String out_trade_no = orderNo;
        String total_amount = price.toString();
        String subject = this.systemConfigService.getValueByKeyException("site_name");
        String timeout_express = "30m";
        MyRecord aliPayRecord = this.getAliPayRecord();
        String aliPayAppid = aliPayRecord.getStr(AlipayConfig.APPID);
        String aliPayPrivateKey = aliPayRecord.getStr(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = aliPayRecord.getStr(AlipayConfig.ALIPAY_PUBLIC_KEY);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey, AlipayConfig.SIGNTYPE);
        String returnUrl = "";
        String quitUrl = "";
        String encode = "type=";
        switch (orderType) {
            case "order": {
                returnUrl = this.systemConfigService.getValueByKey(AlipayConfig.return_url);
                quitUrl = this.systemConfigService.getValueByKey(AlipayConfig.quit_url);
                encode = encode.concat("order");
                break;
            }
            case "recharge": {
                returnUrl = this.systemConfigService.getValueByKey(AlipayConfig.recharge_return_url);
                quitUrl = this.systemConfigService.getValueByKey(AlipayConfig.recharge_quit_url);
                encode = encode.concat("recharge");
                break;
            }
            case "svip": {
                returnUrl = this.systemConfigService.getValueByKey(AlipayConfig.svip_return_url);
                quitUrl = this.systemConfigService.getValueByKey(AlipayConfig.svip_quit_url);
                encode = encode.concat("svip");
            }
        }
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setReturnUrl(returnUrl);
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        alipayRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/alipay");
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(out_trade_no);
        model.setSubject(subject);
        model.setTotalAmount(total_amount);
        model.setTimeoutExpress(timeout_express);
        model.setProductCode("QUICK_WAP_PAY");
        model.setQuitUrl(quitUrl);
        if (StrUtil.isNotBlank((CharSequence)timeExpire)) {
            model.setTimeExpire(timeExpire);
        }
        try {
            encode = URLEncoder.encode(encode, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new CrmebException("\u652f\u4ed8\u5b9d\u53c2\u6570UrlEncode\u5f02\u5e38");
        }
        model.setPassbackParams(encode);
        alipayRequest.setBizModel((AlipayObject)model);
        try {
            response = (AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest);
            result = response.getBody();
        }
        catch (AlipayApiException e) {
            logger.error("\u652f\u4ed8\u5b9d\u8ba2\u5355\u751f\u6210\u5931\u8d25," + e.getErrMsg());
            throw new CrmebException(e.getErrMsg());
        }
        AliPayInfo aliPayInfo = new AliPayInfo();
        aliPayInfo.setAppId(aliPayAppid);
        aliPayInfo.setTimestamp(DateUtil.now());
        aliPayInfo.setBody("");
        aliPayInfo.setSubject(subject);
        aliPayInfo.setOutTradeNo(out_trade_no);
        aliPayInfo.setTimeoutExpress(timeout_express);
        aliPayInfo.setTotalAmount(total_amount);
        aliPayInfo.setPassbackParams(model.getPassbackParams());
        aliPayInfo.setNotifyUrl(alipayRequest.getNotifyUrl());
        aliPayInfo.setCode(Optional.ofNullable(response.getCode()).orElse(""));
        aliPayInfo.setMsg(Optional.ofNullable(response.getMsg()).orElse(""));
        aliPayInfo.setSubCode(Optional.ofNullable(response.getSubCode()).orElse(""));
        aliPayInfo.setSubMsg(Optional.ofNullable(response.getSubMsg()).orElse(""));
        aliPayInfo.setTradeNo(Optional.ofNullable(response.getTradeNo()).orElse(""));
        aliPayInfo.setSellerId(Optional.ofNullable(response.getSellerId()).orElse(""));
        this.aliPayInfoService.save(aliPayInfo);
        return result;
    }

    private String appPay(String orderNo, BigDecimal price, String orderType, String timeExpire) {
        String result;
        AlipayTradeAppPayResponse response;
        String out_trade_no = orderNo;
        String total_amount = price.toString();
        String subject = this.systemConfigService.getValueByKeyException("site_name");
        String timeout_express = "30m";
        MyRecord aliPayRecord = this.getAliPayRecord();
        String aliPayAppid = aliPayRecord.getStr(AlipayConfig.APPID);
        String aliPayPrivateKey = aliPayRecord.getStr(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = aliPayRecord.getStr(AlipayConfig.ALIPAY_PUBLIC_KEY);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey, AlipayConfig.SIGNTYPE);
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setSubject(subject);
        model.setOutTradeNo(out_trade_no);
        model.setTimeoutExpress(timeout_express);
        model.setTotalAmount(total_amount);
        model.setProductCode("QUICK_MSECURITY_PAY");
        String encode = "type=";
        switch (orderType) {
            case "order": {
                encode = encode.concat("order");
                break;
            }
            case "recharge": {
                encode = encode.concat("recharge");
                break;
            }
            case "svip": {
                encode = encode.concat("svip");
            }
        }
        try {
            encode = URLEncoder.encode(encode, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new CrmebException("\u652f\u4ed8\u5b9d\u53c2\u6570UrlEncode\u5f02\u5e38");
        }
        model.setPassbackParams(encode);
        if (StrUtil.isNotBlank((CharSequence)timeExpire)) {
            model.setTimeExpire(timeExpire);
        }
        request.setBizModel((AlipayObject)model);
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        request.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/alipay");
        try {
            response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
            result = response.getBody();
        }
        catch (AlipayApiException e) {
            logger.error("\u751f\u6210\u652f\u4ed8\u5b9dapp\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38," + e.getErrMsg());
            throw new CrmebException(e.getErrMsg());
        }
        AliPayInfo aliPayInfo = new AliPayInfo();
        aliPayInfo.setAppId(aliPayAppid);
        aliPayInfo.setTimestamp(DateUtil.now());
        aliPayInfo.setBody("");
        aliPayInfo.setSubject(subject);
        aliPayInfo.setOutTradeNo(out_trade_no);
        aliPayInfo.setTimeoutExpress(timeout_express);
        aliPayInfo.setTotalAmount(total_amount);
        aliPayInfo.setPassbackParams(model.getPassbackParams());
        aliPayInfo.setNotifyUrl(request.getNotifyUrl());
        aliPayInfo.setCode(Optional.ofNullable(response.getCode()).orElse(""));
        aliPayInfo.setMsg(Optional.ofNullable(response.getMsg()).orElse(""));
        aliPayInfo.setSubCode(Optional.ofNullable(response.getSubCode()).orElse(""));
        aliPayInfo.setSubMsg(Optional.ofNullable(response.getSubMsg()).orElse(""));
        aliPayInfo.setTradeNo(Optional.ofNullable(response.getTradeNo()).orElse(""));
        aliPayInfo.setSellerId(Optional.ofNullable(response.getSellerId()).orElse(""));
        this.aliPayInfoService.save(aliPayInfo);
        return result;
    }

    private String pcPay(String orderNo, BigDecimal price, String orderType, String timeExpire) {
        AlipayTradePrecreateResponse response;
        String out_trade_no = orderNo;
        String total_amount = price.toString();
        String subject = this.systemConfigService.getValueByKeyException("site_name");
        String timeout_express = "30m";
        MyRecord aliPayRecord = this.getAliPayRecord();
        String aliPayAppid = aliPayRecord.getStr(AlipayConfig.APPID);
        String aliPayPrivateKey = aliPayRecord.getStr(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = aliPayRecord.getStr(AlipayConfig.ALIPAY_PUBLIC_KEY);
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey, AlipayConfig.SIGNTYPE);
        String returnUrl = "";
        String encode = "type=";
        switch (orderType) {
            case "order": {
                returnUrl = this.systemConfigService.getValueByKey(AlipayConfig.return_url);
                encode = encode.concat("order");
                break;
            }
            case "recharge": {
                returnUrl = this.systemConfigService.getValueByKey(AlipayConfig.recharge_return_url);
                encode = encode.concat("recharge");
                break;
            }
            case "svip": {
                returnUrl = this.systemConfigService.getValueByKey(AlipayConfig.svip_return_url);
                encode = encode.concat("svip");
            }
        }
        AlipayTradePrecreateRequest payRequest = new AlipayTradePrecreateRequest();
        payRequest.setReturnUrl(returnUrl);
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        payRequest.setNotifyUrl(apiDomain + "/api/publicly/payment/callback/alipay");
        AlipayTradePrecreateModel model = new AlipayTradePrecreateModel();
        model.setSubject(subject);
        model.setOutTradeNo(out_trade_no);
        model.setTimeoutExpress(timeout_express);
        model.setTotalAmount(total_amount);
        try {
            encode = URLEncoder.encode(encode, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new CrmebException("\u652f\u4ed8\u5b9d\u53c2\u6570UrlEncode\u5f02\u5e38");
        }
        model.setPassbackParams(encode);
        payRequest.setBizModel((AlipayObject)model);
        try {
            response = (AlipayTradePrecreateResponse)alipayClient.execute((AlipayRequest)payRequest);
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u652f\u4ed8\u5b9dPC\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38," + e);
            throw new CrmebException("\u751f\u6210\u652f\u4ed8\u5b9dPC\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38");
        }
        if (!response.isSuccess()) {
            logger.error("\u751f\u6210\u652f\u4ed8\u5b9dPC\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25");
            throw new CrmebException("\u751f\u6210\u652f\u4ed8\u5b9dPC\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25");
        }
        String result = response.getQrCode();
        AliPayInfo aliPayInfo = new AliPayInfo();
        aliPayInfo.setAppId(aliPayAppid);
        aliPayInfo.setTimestamp(DateUtil.now());
        aliPayInfo.setBody("");
        aliPayInfo.setSubject(subject);
        aliPayInfo.setOutTradeNo(out_trade_no);
        aliPayInfo.setTimeoutExpress(timeout_express);
        aliPayInfo.setTotalAmount(total_amount);
        aliPayInfo.setPassbackParams(model.getPassbackParams());
        aliPayInfo.setNotifyUrl(payRequest.getNotifyUrl());
        aliPayInfo.setCode(Optional.ofNullable(response.getCode()).orElse(""));
        aliPayInfo.setMsg(Optional.ofNullable(response.getMsg()).orElse(""));
        aliPayInfo.setSubCode(Optional.ofNullable(response.getSubCode()).orElse(""));
        aliPayInfo.setSubMsg(Optional.ofNullable(response.getSubMsg()).orElse(""));
        aliPayInfo.setTradeNo("");
        aliPayInfo.setSellerId("");
        this.aliPayInfoService.save(aliPayInfo);
        return result;
    }

    @Override
    public Boolean queryRefund(String outTradeNo, String refundOrderNo) {
        String out_trade_no = outTradeNo;
        String out_request_no = refundOrderNo;
        MyRecord aliPayRecord = this.getAliPayRecord();
        String aliPayAppid = aliPayRecord.getStr(AlipayConfig.APPID);
        String aliPayPrivateKey = aliPayRecord.getStr(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = aliPayRecord.getStr(AlipayConfig.ALIPAY_PUBLIC_KEY);
        DefaultAlipayClient client = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey, AlipayConfig.SIGNTYPE);
        AlipayTradeFastpayRefundQueryRequest alipay_request = new AlipayTradeFastpayRefundQueryRequest();
        AlipayTradeFastpayRefundQueryModel model = new AlipayTradeFastpayRefundQueryModel();
        model.setOutTradeNo(out_trade_no);
        model.setOutRequestNo(out_request_no);
        alipay_request.setBizModel((AlipayObject)model);
        AlipayTradeFastpayRefundQueryResponse alipay_response = null;
        try {
            alipay_response = (AlipayTradeFastpayRefundQueryResponse)client.execute((AlipayRequest)alipay_request);
        }
        catch (AlipayApiException e) {
            logger.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u67e5\u8be2\u5f02\u5e38\uff0calipay_response = " + alipay_response);
            throw new CrmebException("\u652f\u4ed8\u5b9d\u9000\u6b3e\u67e5\u8be2\u5f02\u5e38");
        }
        if (alipay_response.getRefundStatus().equals("REFUND_SUCCESS")) {
            return Boolean.TRUE;
        }
        if (alipay_response.getRefundStatus().equals("REFUND_PROCESSING")) {
            logger.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u67e5\u8be2\uff1a\u9000\u6b3e\u5904\u7406\u4e2d, outTradeNo = {}", (Object)outTradeNo);
            return Boolean.FALSE;
        }
        if (alipay_response.getRefundStatus().equals("REFUND_FAIL")) {
            logger.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u67e5\u8be2\uff1a\u652f\u4ed8\u5b9d\u9000\u6b3e\u5931\u8d25, outTradeNo = {}", (Object)outTradeNo);
            return Boolean.FALSE;
        }
        logger.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u67e5\u8be2\uff1a\u5f02\u5e38\u9519\u8bef");
        return Boolean.FALSE;
    }
}

