/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.groupbuy.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.enums.GroupBuyRecordEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.groupbuy.GroupBuyRecord;
import com.zbkj.common.model.groupbuy.GroupBuyUser;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.groupbuy.GroupBuyRecordForCache;
import com.zbkj.common.request.groupbuy.GroupBuyUserSearchRequest;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.dao.groupby.GroupBuyUserDao;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.groupbuy.GroupBuyRecordService;
import com.zbkj.service.service.groupbuy.GroupBuyUserService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupBuyUserServiceImpl
extends ServiceImpl<GroupBuyUserDao, GroupBuyUser>
implements GroupBuyUserService {
    private final Logger logger = LoggerFactory.getLogger(GroupBuyUserServiceImpl.class);
    @Resource
    private GroupBuyUserDao dao;
    @Resource
    private GroupBuyRecordService groupBuyRecordService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private GroupBuyUserService groupBuyUserService;
    @Autowired
    private UserService userService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<GroupBuyUser> getList(GroupBuyUserSearchRequest request, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        GroupBuyUser model = new GroupBuyUser();
        BeanUtils.copyProperties((Object)request, (Object)model);
        lambdaQueryWrapper.setEntity((Object)model);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<GroupBuyUser> getLastGroupBuyUserList(Integer recordId, Integer limit) {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.eq(GroupBuyUser::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
        query.eq(GroupBuyUser::getIsLeader, (Object)1);
        if (ObjectUtil.isNotNull((Object)recordId)) {
            query.eq(GroupBuyUser::getGroupRecordId, (Object)recordId);
        }
        if (ObjectUtil.isNull((Object)limit)) {
            throw new CrmebException("\u67e5\u8be2\u53c2\u4e0e\u62fc\u56e2\u6d3b\u52a8 \u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a");
        }
        query.orderByDesc(GroupBuyUser::getId);
        query.last("limit " + limit);
        return this.dao.selectList((Wrapper)query);
    }

    @Override
    public List<GroupBuyUser> getLastGroupBuyUserList(Integer recordId, Integer merId, Integer limit) {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.eq(GroupBuyUser::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
        query.eq(GroupBuyUser::getIsLeader, (Object)1);
        query.eq(GroupBuyUser::getMerId, (Object)merId);
        if (ObjectUtil.isNotNull((Object)recordId)) {
            query.eq(GroupBuyUser::getGroupRecordId, (Object)recordId);
        }
        if (ObjectUtil.isNull((Object)limit)) {
            throw new CrmebException("\u67e5\u8be2\u53c2\u4e0e\u62fc\u56e2\u6d3b\u52a8 \u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a");
        }
        query.orderByDesc(GroupBuyUser::getId);
        query.last("limit " + limit);
        return this.dao.selectList((Wrapper)query);
    }

    @Override
    public Integer getGroupBuySalesForAfterPay(Integer activityId) {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.eq(GroupBuyUser::getGroupActivityId, (Object)activityId);
        query.eq(GroupBuyUser::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode());
        query.eq(GroupBuyUser::getRefundStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_NOT_APPLY);
        List groupBuyUsers = this.dao.selectList((Wrapper)query);
        Integer total = 0;
        if (!groupBuyUsers.isEmpty()) {
            total = groupBuyUsers.stream().map(GroupBuyUser::getPayNum).reduce(Integer::sum).get();
        }
        return total;
    }

    @Override
    public Integer getGroupBuyUserDoneTotalCount() {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(GroupBuyUser::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode());
        return this.dao.selectCount((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Integer getGroupBuyUserDoneTotalCount(Integer merId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(GroupBuyUser::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode());
        lambdaQueryWrapper.eq(GroupBuyUser::getMerId, (Object)merId);
        return this.dao.selectCount((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Integer getOrderDoneCountByProductIdAndActivityId(Integer productId, Integer activityId) {
        if (ObjectUtil.isEmpty((Object)productId)) {
            throw new CrmebException("\u56e2\u8d2d\u5546\u54c1id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(GroupBuyUser::getProductGroupId, (Object)productId);
        lambdaQueryWrapper.eq(GroupBuyUser::getGroupActivityId, (Object)activityId);
        List groupBuyRecords = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        Integer total = 0;
        if (!groupBuyRecords.isEmpty()) {
            total = groupBuyRecords.stream().map(GroupBuyUser::getPayNum).reduce(Integer::sum).get();
        }
        return total;
    }

    @Override
    public List<GroupBuyUser> getGroupBuyUserDoneForActivityId(Integer activityId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(GroupBuyUser::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
        lambdaQueryWrapper.eq(GroupBuyUser::getGroupRecordId, (Object)activityId);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<GroupBuyUser> getGroupBuyUserAfterPayForRecordId(Integer recordId, Integer limit) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(GroupBuyUser::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
        lambdaQueryWrapper.eq(GroupBuyUser::getGroupRecordId, (Object)recordId);
        if (limit > 0) {
            lambdaQueryWrapper.last("limit " + limit);
        }
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<GroupBuyUser> getGroupBuyUserAfterOderDoneForRecordId(Integer recordId, Integer limit) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(GroupBuyUser::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode());
        lambdaQueryWrapper.eq(GroupBuyUser::getGroupRecordId, (Object)recordId);
        if (limit > 0) {
            lambdaQueryWrapper.last("limit " + limit);
        }
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<GroupBuyUser> getListByGroupRecordId(Integer recordId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(GroupBuyUser::getGroupRecordId, (Object)recordId);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<GroupBuyUser> getCurrentGroupBuyActivityRecordListByUserId(Integer userId, Integer groupBuyActivityId, Integer groupRecordId, Integer recordStatus) {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)query.eq(GroupBuyUser::getGroupUid, (Object)userId)).eq(GroupBuyUser::getGroupActivityId, (Object)groupBuyActivityId);
        if (groupRecordId > 0) {
            query.eq(GroupBuyUser::getGroupRecordId, (Object)groupRecordId);
            if (ObjectUtil.isNull((Object)recordStatus)) {
                query.eq(GroupBuyUser::getRecordStatus, (Object)recordStatus);
            }
        }
        return this.dao.selectList((Wrapper)query);
    }

    @Override
    public List<GroupBuyUser> getCurrentGroupBuyActivityRecordList(Integer groupBuyActivityId, Integer userId, Integer groupRecordId) {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.eq(GroupBuyUser::getGroupActivityId, (Object)groupBuyActivityId);
        if (userId > 0) {
            query.eq(GroupBuyUser::getGroupUid, (Object)userId);
        }
        if (groupRecordId > 0) {
            query.eq(GroupBuyUser::getGroupRecordId, (Object)groupRecordId);
        }
        return this.dao.selectList((Wrapper)query);
    }

    @Override
    public GroupBuyUser getByOrderNo(String orderNo) {
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.eq(GroupBuyUser::getOrderId, (Object)orderNo);
        query.last(" limit 1");
        return (GroupBuyUser)this.dao.selectOne((Wrapper)query);
    }

    @Override
    public void beforePay(String orderNo, Integer payNum, Integer uid, String avatar, String nickName) {
        GroupBuyUser groupBuyUser = new GroupBuyUser();
        groupBuyUser.setRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
        groupBuyUser.setOrderStatus(OrderConstants.ORDER_STATUS_WAIT_PAY);
        groupBuyUser.setIsLeader(Integer.valueOf(0));
        groupBuyUser.setGroupUid(uid);
        groupBuyUser.setOrderId(orderNo);
        groupBuyUser.setGroupAvatar(avatar);
        groupBuyUser.setGroupNickname(nickName);
        groupBuyUser.setPayNum(payNum);
        this.save(groupBuyUser);
    }

    @Override
    public void afterPay(String ptOrderNo) {
        Order currentOrder = this.orderService.getMerchantOrderNoByPtOrderNoForGroupBuy(ptOrderNo);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(GroupBuyUser::getOrderId, (Object)ptOrderNo);
        GroupBuyUser groupBuyUser = (GroupBuyUser)this.dao.selectOne((Wrapper)queryWrapper);
        this.logger.info("\u62fc\u56e2\u8ba2\u5355\u7f16\u53f7\u4fee\u6539\u5bf9\u5e94\u62fc\u56e2\u8ba2\u5355\u72b6\u6001: ${}:", (Object)JSONObject.toJSONString((Object)currentOrder));
        String cacheKey = StrUtil.format((CharSequence)"pintuan_record:{}", (Object[])new Object[]{ptOrderNo});
        if (!this.redisUtil.exists(cacheKey).booleanValue()) {
            throw new CrmebException("\u62fc\u56e2\u8bb0\u5f55\u8bfb\u53d6\u7f13\u5b58\u51fa\u9519");
        }
        GroupBuyRecordForCache groupBuyRecordForCache = (GroupBuyRecordForCache)JSONObject.parseObject((String)this.redisUtil.get(cacheKey).toString(), GroupBuyRecordForCache.class);
        GroupBuyRecord groupBuyRecord = this.groupBuyRecordService.newGroupBuyRecordOrContinueBuy(currentOrder.getOrderNo(), groupBuyRecordForCache.getPayNum(), groupBuyRecordForCache.getGroupBuyActivityId(), groupBuyRecordForCache.getProductId(), groupBuyRecordForCache.getGroupBuyRecordId(), groupBuyRecordForCache.getFictiStatus(), groupBuyRecordForCache.getMerId(), groupBuyRecordForCache.getAttrValueId(), groupBuyRecordForCache.getId(), groupBuyRecordForCache.getNickname(), groupBuyRecordForCache.getAvatar());
        groupBuyUser.setOrderId(currentOrder.getOrderNo());
        groupBuyUser.setOrderStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
        groupBuyUser.setGroupActivityId(groupBuyRecordForCache.getGroupBuyActivityId());
        groupBuyUser.setGroupRecordId(groupBuyRecord.getGroupBuyingId());
        groupBuyUser.setProductGroupId(groupBuyRecordForCache.getProductId());
        groupBuyUser.setMerId(groupBuyRecordForCache.getMerId());
        if (Objects.equals(groupBuyRecordForCache.getId(), groupBuyRecord.getGroupLeaderUid())) {
            groupBuyUser.setIsLeader(Integer.valueOf(1));
        }
        this.dao.updateById(groupBuyUser);
        this.logger.info("\u62fc\u56e2\u5206\u5355\u540e - \u66ff\u6362\u8ba2\u5355\u7f16\u53f7\u5b8c\u6bd5: ${}:", (Object)currentOrder.getOrderNo());
        GroupBuyRecord currentGroupRecord = (GroupBuyRecord)this.groupBuyRecordService.getById(groupBuyUser.getGroupRecordId());
        if (ObjectUtil.isNotNull((Object)currentGroupRecord) && currentGroupRecord.getBuyingCountNum().equals(currentGroupRecord.getBuyingNum())) {
            this.logger.info("\u771f\u4eba\u62fc\u56e2\u5224\u65ad\u6210\u529f - \u6b63\u5728\u6267\u884c");
            this.logger.info("\u771f\u4eba\u62fc\u56e2\u6210\u529f ${}", (Object)JSONObject.toJSONString((Object)currentGroupRecord));
            LambdaUpdateWrapper zrUpdateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)zrUpdateWrapper.eq(GroupBuyRecord::getGroupBuyingId, (Object)currentGroupRecord.getGroupBuyingId())).set(GroupBuyRecord::getRecordStatus, (Object)GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
            this.groupBuyRecordService.update((Wrapper)zrUpdateWrapper);
            this.logger.info("\u771f\u4eba\u62fc\u56e2\u6210 \u62fc\u56e2\u8bb0\u5f55\u5199\u5165\u5b8c\u6210");
            List<GroupBuyUser> listByGroupRecordList = this.groupBuyUserService.getListByGroupRecordId(currentGroupRecord.getGroupBuyingId());
            this.logger.info("\u62fc\u56e2\u771f\u4eba\u62fc\u56e2\u5373\u65f6\u6210\u529f \u8c03\u7528\u62fc\u56e2\u6210\u529f\u4e8b\u4ef6:listByGroupRecordList:{}", (Object)JSONObject.toJSONString(listByGroupRecordList));
            this.logger.info("\u62fc\u56e2\u771f\u4eba\u62fc\u56e2\u5373\u65f6\u6210\u529f \u8c03\u7528\u62fc\u56e2\u6210\u529f\u4e8b\u4ef6:currentGroupRecord:{}", (Object)JSONObject.toJSONString((Object)currentGroupRecord));
            this.groupBuyRecordService.groupSuccess(currentGroupRecord, listByGroupRecordList);
            this.logger.info("\u771f\u4eba\u62fc\u56e2\u5224\u65ad\u6210\u529f - \u6b63\u5728\u7ed3\u675f");
        }
    }
}

