/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.groupbuy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.enums.GroupBuyGroupStatusEnum;
import com.zbkj.common.enums.GroupBuyRecordEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.groupbuy.GroupBuyActivity;
import com.zbkj.common.model.groupbuy.GroupBuyActivitySku;
import com.zbkj.common.model.groupbuy.GroupBuyRecord;
import com.zbkj.common.model.groupbuy.GroupBuyUser;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.product.ProductAttribute;
import com.zbkj.common.model.product.ProductAttributeOption;
import com.zbkj.common.model.product.ProductDescription;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.groupbuy.MerchantGroupPageRequest;
import com.zbkj.common.response.ProMerchantProductResponse;
import com.zbkj.common.response.ProductAttrValueResponse;
import com.zbkj.common.response.ProductDetailResponse;
import com.zbkj.common.response.ProductMerchantResponse;
import com.zbkj.common.response.groupbuy.GroupBuyActivityFrontOrderViewResponse;
import com.zbkj.common.response.groupbuy.GroupBuyActivityProductListForSale;
import com.zbkj.common.response.groupbuy.GroupBuyActivityRecordForFrontShareUse;
import com.zbkj.common.response.groupbuy.GroupBuyActivityRecordOnProcessItem;
import com.zbkj.common.response.groupbuy.GroupBuyActivityResponse;
import com.zbkj.common.response.groupbuy.GroupBuyUserInfo;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.groupby.GroupBuyActivitySkuDao;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductAttributeOptionService;
import com.zbkj.service.service.ProductAttributeService;
import com.zbkj.service.service.ProductDescriptionService;
import com.zbkj.service.service.ProductGuaranteeService;
import com.zbkj.service.service.ProductRelationService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.UserMerchantCollectService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.groupbuy.GroupBuyActivityService;
import com.zbkj.service.service.groupbuy.GroupBuyActivitySkuService;
import com.zbkj.service.service.groupbuy.GroupBuyRecordService;
import com.zbkj.service.service.groupbuy.GroupBuyUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupBuyActivitySkuServiceImpl
extends ServiceImpl<GroupBuyActivitySkuDao, GroupBuyActivitySku>
implements GroupBuyActivitySkuService {
    private static final Logger logger = LoggerFactory.getLogger(GroupBuyActivitySkuServiceImpl.class);
    @Resource
    private GroupBuyActivitySkuDao dao;
    @Resource
    private ProductService productService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Resource
    private GroupBuyRecordService groupBuyRecordService;
    @Resource
    private GroupBuyActivityService groupBuyActivityService;
    @Autowired
    private ProductGuaranteeService productGuaranteeService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private UserMerchantCollectService userMerchantCollectService;
    @Autowired
    private UserService userService;
    @Autowired
    private ProductRelationService productRelationService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private GroupBuyUserService groupBuyUserService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private ProductDescriptionService productDescriptionService;
    @Autowired
    private ProductAttributeService productAttributeService;
    @Autowired
    private ProductAttributeOptionService productAttributeOptionService;

    @Override
    public List<GroupBuyActivitySku> getListByGroupActivityId(Integer groupActivityId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(GroupBuyActivitySku::getGroupActivityId, (Object)groupActivityId);
        return this.dao.selectList((Wrapper)queryWrapper);
    }

    @Override
    public Boolean reviewGroupBuySkuStatus(Integer id, Boolean op) {
        Integer groupStatus = op != false ? GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_PASS.getCode() : GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_INIT.getCode();
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(GroupBuyActivitySku::getGroupActivityId, (Object)id)).set(GroupBuyActivitySku::getActivityStatus, (Object)op)).set(GroupBuyActivitySku::getGroupStatus, (Object)groupStatus);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public ProductDetailResponse getGroupBuyDetail(Integer productId, Integer groupActivityId, Integer groupRecordId) {
        List<GroupBuyActivitySku> currentSkuList = this.getGroupBuySkusListForProductIdAndGroupActivityId(productId, groupActivityId);
        if (currentSkuList.isEmpty()) {
            throw new CrmebException("\u62fc\u56e2\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        GroupBuyActivitySku currentActivitySku = currentSkuList.stream().min(Comparator.comparing(GroupBuyActivitySku::getActivePrice)).orElse(null);
        Product product = (Product)this.productService.getById(currentActivitySku.getProductId());
        if (product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) || product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) {
            throw new CrmebException("\u5f53\u524d\u5546\u54c1\u672a\u5ba1\u6838\u6216\u8005\u5ba1\u6838\u62d2\u7edd");
        }
        ProductDescription sd = this.productDescriptionService.getByProductIdAndType(product.getId(), product.getType(), product.getMarketingType());
        if (ObjectUtil.isNotNull((Object)sd)) {
            product.setContent(StrUtil.isBlank((CharSequence)sd.getDescription()) ? "" : sd.getDescription());
        }
        Integer userId = this.userService.getUserId();
        ProductDetailResponse productDetailResponse = new ProductDetailResponse();
        product.setMarketingType(ProductConstants.PRODUCT_MARKETING_TYPE_PINGTUAN);
        productDetailResponse.setProductInfo(product);
        if (StrUtil.isNotBlank((CharSequence)product.getGuaranteeIds())) {
            productDetailResponse.setGuaranteeList(this.productGuaranteeService.findByIdList(CrmebUtil.stringToArray((String)product.getGuaranteeIds())));
        }
        GroupBuyActivity groupBuyActivity = (GroupBuyActivity)this.groupBuyActivityService.getById(groupActivityId);
        GroupBuyActivityResponse groupBuyActivityResponse = new GroupBuyActivityResponse();
        if (1 == groupBuyActivity.getShowGroup()) {
            groupBuyActivityResponse.setTotalAllOrderDone(Integer.valueOf(this.groupBuyUserService.getGroupBuyUserDoneForActivityId(groupBuyActivity.getId()).size()));
            ArrayList<GroupBuyActivityRecordOnProcessItem> processItems = new ArrayList<GroupBuyActivityRecordOnProcessItem>();
            List<GroupBuyRecord> lastGroupBuyRecord = this.groupBuyRecordService.getGroupRecordListForNotExist(groupBuyActivity.getId(), userId, product.getId(), 5);
            for (GroupBuyRecord groupBuyRecord : lastGroupBuyRecord) {
                List<GroupBuyUser> lastGroupBuyUserList = this.groupBuyUserService.getLastGroupBuyUserList(groupBuyRecord.getGroupBuyingId(), 5);
                GroupBuyActivityRecordOnProcessItem item2 = new GroupBuyActivityRecordOnProcessItem();
                item2.setOrderDoneUserImages(lastGroupBuyUserList);
                item2.setRecordEndTime(groupBuyRecord.getEndTime());
                item2.setNeedSomeTogetherCount(Integer.valueOf(groupBuyRecord.getBuyingCountNum() - groupBuyRecord.getYetBuyingNum()));
                item2.setProductGroupId(groupBuyRecord.getProductGroupId());
                processItems.add(item2);
            }
            groupBuyActivityResponse.setProcessItem(processItems);
        }
        BeanUtils.copyProperties((Object)groupBuyActivity, (Object)groupBuyActivityResponse);
        groupBuyActivityResponse.setSales(this.groupBuyUserService.getGroupBuySalesForAfterPay(groupBuyActivity.getId()));
        List<GroupBuyRecord> groupBuyUserActivityDoneList = this.groupBuyRecordService.getGroupBuyUserActivityDoneList(groupActivityId, userId, productId, 10);
        ArrayList<GroupBuyUserInfo> groupBuyUserInfos = new ArrayList<GroupBuyUserInfo>();
        for (GroupBuyRecord groupBuyRecord : groupBuyUserActivityDoneList) {
            GroupBuyUserInfo groupBuyUserInfo = new GroupBuyUserInfo();
            groupBuyUserInfo.setGroupNickname(groupBuyRecord.getGroupLeaderNickname());
            groupBuyUserInfo.setGroupAvatar(((User)this.userService.getById(groupBuyRecord.getGroupLeaderUid())).getAvatar());
            groupBuyUserInfo.setId(groupBuyRecord.getGroupLeaderUid());
            groupBuyUserInfos.add(groupBuyUserInfo);
        }
        groupBuyActivityResponse.setGroupBuyUserActivityDoneList(!groupBuyUserInfos.isEmpty() ? groupBuyUserInfos : null);
        groupBuyActivityResponse.setActivePrice(currentActivitySku.getActivePrice());
        if (userId > 0) {
            List<GroupBuyUser> currentGroupBuyActivityRecords = this.groupBuyUserService.getCurrentGroupBuyActivityRecordList(currentActivitySku.getGroupActivityId(), userId, 0);
            groupBuyActivityResponse.setBuyLimitCount(groupBuyActivity.getAllQuota());
            Integer buyedNum = 0;
            if (!currentGroupBuyActivityRecords.isEmpty()) {
                buyedNum = currentGroupBuyActivityRecords.stream().map(GroupBuyUser::getPayNum).reduce(0, Integer::sum);
            }
            Integer waitePayNum = this.orderDetailService.getByGroupBuyActivityId(groupActivityId, productId, userId);
            if (groupBuyActivity.getAllQuota() == 0) {
                groupBuyActivityResponse.setBuyLimitCount(Integer.valueOf(-1));
            } else if (!currentGroupBuyActivityRecords.isEmpty()) {
                groupBuyActivityResponse.setBuyLimitCount(Integer.valueOf(groupBuyActivity.getAllQuota() - (buyedNum + waitePayNum)));
            }
            if (groupBuyActivity.getAllQuota() > 0) {
                groupBuyActivityResponse.setBuyLimitCount(Integer.valueOf(groupBuyActivity.getAllQuota() - (buyedNum + waitePayNum)));
            }
            if (groupBuyActivity.getAllQuota() > 0 && groupBuyActivityResponse.getBuyLimitCount() < 0) {
                groupBuyActivityResponse.setBuyLimitCount(Integer.valueOf(0));
            }
        }
        groupBuyActivityResponse.setLatestBuyCount(this.groupBuyUserService.getOrderDoneCountByProductIdAndActivityId(productId, groupActivityId));
        productDetailResponse.setGroupBuyActivityResponse(groupBuyActivityResponse);
        List<ProductAttribute> attributeList = this.productAttributeService.findListByProductId(product.getId());
        attributeList.forEach(attr -> {
            List<ProductAttributeOption> optionList = this.productAttributeOptionService.findListByAttrId(attr.getId());
            attr.setOptionList(optionList);
        });
        productDetailResponse.setProductAttr(attributeList);
        LinkedHashMap<String, ProductAttrValueResponse> skuMap = new LinkedHashMap<String, ProductAttrValueResponse>();
        List<ProductAttrValue> productAttrValueList = this.productAttrValueService.getListByProductIdAndType(product.getId(), product.getType(), ProductConstants.PRODUCT_MARKETING_TYPE_BASE, true);
        boolean matchResult = productAttrValueList.stream().allMatch(item -> currentSkuList.stream().anyMatch(csku -> item.getId().equals(csku.getSkuId())));
        logger.info("\u5bf9\u6bd4\u62fc\u56e2\u5bf9\u5e94\u7684\u57fa\u7840\u5546\u54c1\u662f\u5426\u88ab\u7f16\u8f91\u8fc7: ${}", (Object)productAttrValueList.size());
        if (!matchResult) {
            throw new CrmebException("\u62fc\u56e2\u5546\u54c1\u89c4\u683c\u88ab\u7f16\u8f91\u8fc7\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u62fc\u56e2\u6d3b\u52a8");
        }
        for (ProductAttrValue productAttrValue : productAttrValueList) {
            ProductAttrValueResponse atr = new ProductAttrValueResponse();
            BeanUtils.copyProperties((Object)productAttrValue, (Object)atr);
            atr.setStock(productAttrValue.getStock());
            List currentGroupBuySkuList = currentSkuList.stream().filter(item -> item.getSkuId().equals(productAttrValue.getId())).collect(Collectors.toList());
            if (!currentGroupBuySkuList.isEmpty()) {
                GroupBuyActivitySku groupBuyActivitySku = (GroupBuyActivitySku)currentGroupBuySkuList.get(0);
                atr.setGroupPrice(groupBuyActivitySku.getActivePrice());
                product.setGroupPrice(groupBuyActivitySku.getActivePrice());
                atr.setGroupStock(groupBuyActivitySku.getQuota());
            }
            skuMap.put(atr.getSku(), atr);
            if (!productAttrValue.getId().equals(currentActivitySku.getSkuId())) continue;
            productDetailResponse.getProductInfo().setPrice(productAttrValue.getPrice());
        }
        productDetailResponse.setProductInfo(product);
        productDetailResponse.setProductValue(skuMap);
        Merchant merchant = (Merchant)this.merchantService.getById(product.getMerId());
        ProductMerchantResponse merchantResponse = new ProductMerchantResponse();
        BeanUtils.copyProperties((Object)merchant, (Object)merchantResponse);
        merchantResponse.setCollectNum(this.userMerchantCollectService.getCountByMerId(merchant.getId()));
        List<ProMerchantProductResponse> merchantProductResponseList = this.productService.getRecommendedProductsByMerId(merchant.getId(), 6);
        merchantResponse.setProList(merchantProductResponseList);
        productDetailResponse.setUserCollect(Boolean.valueOf(false));
        if (userId > 0) {
            merchantResponse.setIsCollect(this.userMerchantCollectService.isCollect(userId, merchant.getId()));
            productDetailResponse.setUserCollect(this.productRelationService.existCollectByUser(userId, product.getId()));
        }
        productDetailResponse.setMerchantInfo(merchantResponse);
        this.asyncService.productDetailStatistics(product.getId(), userId);
        return productDetailResponse;
    }

    private List<GroupBuyActivitySku> getGroupBuySkusListForProductIdAndGroupActivityId(Integer productId, Integer groupActivityId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(GroupBuyActivitySku::getGroupActivityId, (Object)groupActivityId)).eq(GroupBuyActivitySku::getProductId, (Object)productId);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<GroupBuyActivityProductListForSale> getListByGroupProductIdByList(PageParamRequest paramRequest, Integer showgroup) {
        Integer offset = (paramRequest.getPage() - 1) * paramRequest.getLimit();
        List<GroupBuyActivityProductListForSale> listByGroupProductIdByList = this.dao.getListByGroupProductIdByList(offset, paramRequest.getLimit(), showgroup);
        for (GroupBuyActivityProductListForSale groupBuyActivityProductListForSale : listByGroupProductIdByList) {
            List<GroupBuyActivitySku> skus = this.getActivitySkusListByActivityIdAndProductId(groupBuyActivityProductListForSale.getGroupActivityId(), groupBuyActivityProductListForSale.getProductId());
            GroupBuyActivitySku currentActivitySku = skus.stream().min(Comparator.comparing(GroupBuyActivitySku::getActivePrice)).orElse(null);
            ProductAttrValue productAttrValue = (ProductAttrValue)this.productAttrValueService.getById(currentActivitySku.getSkuId());
            groupBuyActivityProductListForSale.setPrice(productAttrValue.getPrice());
            groupBuyActivityProductListForSale.setActivePrice(currentActivitySku.getActivePrice());
            groupBuyActivityProductListForSale.setLatestBuyCount(this.groupBuyUserService.getOrderDoneCountByProductIdAndActivityId(groupBuyActivityProductListForSale.getProductId(), groupBuyActivityProductListForSale.getGroupActivityId()));
        }
        return listByGroupProductIdByList;
    }

    public List<GroupBuyActivitySku> getActivitySkusListByActivityIdAndProductId(Integer groupActivityId, Integer productId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(GroupBuyActivitySku::getGroupActivityId, (Object)groupActivityId);
        lambdaQueryWrapper.eq(GroupBuyActivitySku::getProductId, (Object)productId);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public GroupBuyActivitySku getByAttrId(Integer activityId, Integer attrId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(GroupBuyActivitySku::getGroupActivityId, (Object)activityId)).eq(GroupBuyActivitySku::getSkuId, (Object)attrId);
        return (GroupBuyActivitySku)this.dao.selectOne((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean subSKUStock(Integer groupBuyActivityId, Integer attrValueId, Integer payNum) {
        UpdateWrapper skuUpdateWrapper = new UpdateWrapper();
        skuUpdateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota - {}", (Object[])new Object[]{payNum}));
        skuUpdateWrapper.eq((Object)"group_activity_id", (Object)groupBuyActivityId);
        skuUpdateWrapper.eq((Object)"sku_id", (Object)attrValueId);
        boolean update = this.update((Wrapper)skuUpdateWrapper);
        if (!update) {
            logger.error("\u51cf\u5c11\u62fc\u56e2\u5546\u54c1\u5e93\u5b58\u5931\u8d25\uff0cpayNum = {}, sku = {}, group_activity_id = {}", new Object[]{payNum, attrValueId, groupBuyActivityId});
        }
        return update;
    }

    @Override
    public Boolean rollBackSKUStock(Order order, Integer groupBuyActivityId, Integer skuId, Integer payNum) {
        UpdateWrapper skuUpdateWrapper = new UpdateWrapper();
        skuUpdateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota + {}", (Object[])new Object[]{payNum}));
        skuUpdateWrapper.eq((Object)"group_activity_id", (Object)groupBuyActivityId);
        skuUpdateWrapper.eq((Object)"sku_id", (Object)skuId);
        boolean update = this.update((Wrapper)skuUpdateWrapper);
        if (!update) {
            logger.error("\u62fc\u56e2\u9000\u6b3e\u56de\u6eda\u5e93\u5b58\u5931\u8d25\uff0corder_no = {}, sku = {}, group_activity_id = {}", new Object[]{order.getOrderNo(), skuId, groupBuyActivityId});
            return false;
        }
        LambdaUpdateWrapper userUpdateWrapper = Wrappers.lambdaUpdate();
        userUpdateWrapper.set(GroupBuyUser::getRecordStatus, (Object)OrderConstants.ORDER_REFUND_STATUS_ALL);
        userUpdateWrapper.eq(GroupBuyUser::getOrderId, (Object)order.getOrderNo());
        update = this.groupBuyUserService.update((Wrapper)userUpdateWrapper);
        if (!update) {
            logger.error("\u62fc\u56e2\u9000\u6b3e\u56de\u6eda\u5e93\u5b58\u64cd\u4f5c\u7528\u6237\u5931\u8d25\uff0corder_no = {}, sku = {}, group_activity_id = {}", new Object[]{order.getOrderNo(), skuId, groupBuyActivityId});
        }
        return update;
    }

    @Override
    public GroupBuyActivityFrontOrderViewResponse getGroupBuyActivityFrontForShare(String orderNo) {
        GroupBuyUser groupBuyUserTemp;
        int i;
        GroupBuyActivityFrontOrderViewResponse response = new GroupBuyActivityFrontOrderViewResponse();
        response.setOrderNo(orderNo);
        Order order = null;
        order = orderNo.startsWith("PT") ? this.orderService.getMerchantOrderNoByPtOrderNoForGroupBuy(orderNo) : this.orderService.getByOrderNo(orderNo);
        GroupBuyUser groupBuyUser = this.groupBuyUserService.getByOrderNo(order.getOrderNo());
        if (ObjectUtil.isNull((Object)groupBuyUser)) {
            throw new CrmebException("\u672a\u627e\u5230\u5f53\u524d\u62fc\u56e2\u8ba2\u5355:" + order.getOrderNo());
        }
        this.checkGroupActiviyStatusOn(groupBuyUser.getGroupActivityId());
        GroupBuyRecord currentRecord = (GroupBuyRecord)this.groupBuyRecordService.getById(groupBuyUser.getGroupRecordId());
        ProductDetailResponse groupBuyDetail = this.getGroupBuyDetail(currentRecord.getProductGroupId(), currentRecord.getGroupActivityId(), currentRecord.getGroupBuyingId());
        GroupBuyActivityRecordForFrontShareUse groupBuyActivityRecord = new GroupBuyActivityRecordForFrontShareUse();
        BeanUtils.copyProperties((Object)currentRecord, (Object)groupBuyActivityRecord);
        groupBuyActivityRecord.setGroupActivityId(groupBuyUser.getGroupActivityId());
        groupBuyActivityRecord.setProductId(groupBuyUser.getProductGroupId());
        groupBuyActivityRecord.setGroupRecordId(groupBuyUser.getGroupRecordId());
        groupBuyActivityRecord.setFictiStatus(currentRecord.getFictiStatus());
        groupBuyActivityRecord.setGroupLeaderNickname(currentRecord.getGroupLeaderNickname());
        groupBuyActivityRecord.setGroupLeaderAvatar(groupBuyUser.getGroupAvatar());
        GroupBuyActivitySku currentGroupBuyActivitySku = this.getByAttrId(currentRecord.getGroupActivityId(), currentRecord.getSkuid());
        groupBuyActivityRecord.setLatestBuyCount(this.groupBuyUserService.getOrderDoneCountByProductIdAndActivityId(groupBuyUser.getProductGroupId(), groupBuyUser.getGroupActivityId()));
        if (ObjectUtil.isNotNull((Object)currentGroupBuyActivitySku)) {
            groupBuyActivityRecord.setActivePrice(currentGroupBuyActivitySku.getActivePrice());
        }
        ProductAttrValue currentAttrVale = (ProductAttrValue)this.productAttrValueService.getById(currentRecord.getSkuid());
        groupBuyDetail.getProductInfo().setPrice(currentAttrVale.getPrice());
        Integer limit = 30;
        if (currentRecord.getBuyingCountNum() <= limit) {
            limit = currentRecord.getBuyingCountNum();
        }
        List<Object> groupBuyUserDoneForRecordId = Collections.emptyList();
        if (currentRecord.getRecordStatus().equals(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode()) && (groupBuyUserDoneForRecordId = this.groupBuyUserService.getGroupBuyUserAfterPayForRecordId(groupBuyUser.getGroupRecordId(), limit)).size() < limit) {
            for (i = groupBuyUserDoneForRecordId.size(); i < limit; ++i) {
                groupBuyUserTemp = new GroupBuyUser();
                groupBuyUserTemp.setGroupNickname("\uff1f");
                groupBuyUserTemp.setGroupAvatar("\u9700\u8981\u62fc\u56e2\u8865\u4f4d");
                groupBuyUserDoneForRecordId.add(groupBuyUserTemp);
            }
        }
        if (currentRecord.getFictiStatus().equals(1) && currentRecord.getRecordStatus().equals(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode()) && (groupBuyUserDoneForRecordId = this.groupBuyUserService.getGroupBuyUserAfterOderDoneForRecordId(groupBuyUser.getGroupRecordId(), limit)).size() < limit) {
            limit = limit - groupBuyUserDoneForRecordId.size();
            for (i = 0; i < limit; ++i) {
                groupBuyUserTemp = new GroupBuyUser();
                groupBuyUserTemp.setGroupNickname("\uff1f");
                groupBuyUserTemp.setGroupAvatar("https");
                groupBuyUserDoneForRecordId.add(groupBuyUserTemp);
            }
        }
        if (currentRecord.getFictiStatus().equals(0) && currentRecord.getRecordStatus().equals(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode())) {
            groupBuyUserDoneForRecordId = this.groupBuyUserService.getGroupBuyUserAfterOderDoneForRecordId(groupBuyUser.getGroupRecordId(), limit);
        } else if (currentRecord.getFictiStatus().equals(0) && currentRecord.getRecordStatus().equals(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_FAIL.getCode())) {
            groupBuyUserDoneForRecordId = this.groupBuyUserService.getListByGroupRecordId(groupBuyUser.getGroupRecordId());
        }
        response.setGroupBuyUserList(groupBuyUserDoneForRecordId);
        Integer userId = this.userService.getUserId();
        List<GroupBuyRecord> groupBuyUserActivityDoneList = this.groupBuyRecordService.getGroupBuyUserActivityDoneList(currentRecord.getGroupActivityId(), userId, currentRecord.getProductGroupId(), 10);
        ArrayList<GroupBuyUserInfo> groupBuyUserInfos = new ArrayList<GroupBuyUserInfo>();
        for (GroupBuyRecord groupBuyRecord : groupBuyUserActivityDoneList) {
            GroupBuyUserInfo groupBuyUserInfo = new GroupBuyUserInfo();
            groupBuyUserInfo.setGroupNickname(groupBuyRecord.getGroupLeaderNickname());
            groupBuyUserInfo.setGroupAvatar(((User)this.userService.getById(groupBuyRecord.getGroupLeaderUid())).getAvatar());
            groupBuyUserInfo.setId(groupBuyRecord.getGroupLeaderUid());
            groupBuyUserInfos.add(groupBuyUserInfo);
        }
        response.setGroupBuyUserActivityDoneList(!groupBuyUserInfos.isEmpty() ? groupBuyUserInfos : null);
        response.setProductDetailResponse(groupBuyDetail);
        response.setRecordForShare(groupBuyActivityRecord);
        return response;
    }

    @Override
    public GroupBuyActivityFrontOrderViewResponse getGroupBuyActivityFrontForReadShare(Integer groupActivityId, Integer productId, Integer recordId) {
        Integer currentUserId;
        GroupBuyActivityFrontOrderViewResponse response = new GroupBuyActivityFrontOrderViewResponse();
        GroupBuyRecord currentRecord = (GroupBuyRecord)this.groupBuyRecordService.getById(recordId);
        this.checkGroupActiviyStatusOn(currentRecord.getGroupActivityId());
        ProductDetailResponse groupBuyDetail = this.getGroupBuyDetail(currentRecord.getProductGroupId(), currentRecord.getGroupActivityId(), currentRecord.getGroupBuyingId());
        GroupBuyActivityRecordForFrontShareUse groupBuyActivityRecord = new GroupBuyActivityRecordForFrontShareUse();
        GroupBuyRecord currentGroupBuyRecord = (GroupBuyRecord)this.groupBuyRecordService.getById(recordId);
        BeanUtils.copyProperties((Object)currentGroupBuyRecord, (Object)groupBuyActivityRecord);
        if (currentRecord.getEndTime().getTime() <= System.currentTimeMillis()) {
            groupBuyActivityRecord.setRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_FAIL.getCode());
        }
        groupBuyActivityRecord.setGroupActivityId(groupActivityId);
        groupBuyActivityRecord.setProductId(productId);
        groupBuyActivityRecord.setGroupRecordId(recordId);
        GroupBuyActivitySku currentGroupBuyActivitySku = this.getByAttrId(currentGroupBuyRecord.getGroupActivityId(), currentGroupBuyRecord.getSkuid());
        if (ObjectUtil.isNotNull((Object)currentGroupBuyActivitySku)) {
            groupBuyActivityRecord.setActivePrice(currentGroupBuyActivitySku.getActivePrice());
        }
        if ((currentUserId = this.userService.getUserId()) > 0) {
            List<GroupBuyUser> groupBuyUsers = this.groupBuyUserService.getCurrentGroupBuyActivityRecordListByUserId(currentUserId, groupActivityId, recordId, GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
            groupBuyActivityRecord.setCanBuyFlag(Integer.valueOf(groupBuyUsers.isEmpty() ? 0 : 1));
            if (!groupBuyUsers.isEmpty()) {
                response.setOrderNo(groupBuyUsers.get(0).getOrderId());
            }
        }
        groupBuyActivityRecord.setLatestBuyCount(this.groupBuyUserService.getOrderDoneCountByProductIdAndActivityId(productId, groupActivityId));
        Integer limit = 30;
        if (currentRecord.getBuyingCountNum() <= limit) {
            limit = currentRecord.getBuyingCountNum();
        }
        List<Object> groupBuyUserDoneForRecordId = Collections.emptyList();
        if (currentRecord.getRecordStatus().equals(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode()) && (groupBuyUserDoneForRecordId = this.groupBuyUserService.getGroupBuyUserAfterPayForRecordId(recordId, limit)).size() < limit) {
            for (int i = groupBuyUserDoneForRecordId.size(); i < limit; ++i) {
                GroupBuyUser groupBuyUserTemp = new GroupBuyUser();
                groupBuyUserTemp.setGroupNickname("\uff1f");
                groupBuyUserTemp.setGroupAvatar("\u9700\u8981\u62fc\u56e2\u8865\u4f4d");
                groupBuyUserDoneForRecordId.add(groupBuyUserTemp);
            }
        }
        if (currentRecord.getRecordStatus().equals(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_SUCCESS.getCode())) {
            groupBuyUserDoneForRecordId = this.groupBuyUserService.getGroupBuyUserAfterOderDoneForRecordId(recordId, limit);
        }
        response.setGroupBuyUserList(groupBuyUserDoneForRecordId);
        response.setProductDetailResponse(groupBuyDetail);
        response.setRecordForShare(groupBuyActivityRecord);
        return response;
    }

    @Override
    public void deleteSkusIdsForProductTurnOff(List<Integer> finalSkuIdList) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.in(GroupBuyActivitySku::getSkuId, finalSkuIdList);
        List skus = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        if (CollUtil.isEmpty((Collection)skus)) {
            return;
        }
        List ids = skus.stream().map(GroupBuyActivitySku::getId).collect(Collectors.toList());
        this.dao.deleteBatchIds(ids);
        logger.info("\u6709\u5546\u54c1\u64cd\u4f5c\u4e0b\u67b6\uff0c\u5220\u9664\u5173\u8054\u62fc\u56e2\u5546\u54c1\u5c5e\u6027: {}", (Object)JSONObject.toJSONString(finalSkuIdList));
    }

    @Override
    public GroupBuyActivitySku getFrontMinActivePriceByGroupActivityId(Integer groupActivityId) {
        return this.dao.getFrontMinActivePriceByGroupActivityId(groupActivityId);
    }

    @Override
    public PageInfo<GroupBuyActivityProductListForSale> findMerchantProductPageByFront(MerchantGroupPageRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<GroupBuyActivityProductListForSale> productList = this.dao.findGroupMerchantProductListByFront(request.getMerId());
        for (GroupBuyActivityProductListForSale groupBuyActivityProductListForSale : productList) {
            List<GroupBuyActivitySku> skus = this.getActivitySkusListByActivityIdAndProductId(groupBuyActivityProductListForSale.getGroupActivityId(), groupBuyActivityProductListForSale.getProductId());
            GroupBuyActivitySku currentActivitySku = skus.stream().min(Comparator.comparing(GroupBuyActivitySku::getActivePrice)).orElse(null);
            ProductAttrValue productAttrValue = (ProductAttrValue)this.productAttrValueService.getById(currentActivitySku.getSkuId());
            groupBuyActivityProductListForSale.setPrice(productAttrValue.getPrice());
            groupBuyActivityProductListForSale.setActivePrice(currentActivitySku.getActivePrice());
            groupBuyActivityProductListForSale.setLatestBuyCount(this.groupBuyUserService.getOrderDoneCountByProductIdAndActivityId(groupBuyActivityProductListForSale.getProductId(), groupBuyActivityProductListForSale.getGroupActivityId()));
        }
        return CommonPage.copyPageInfo((Page)page, productList);
    }

    private void checkGroupActiviyStatusOn(Integer activityId) {
        GroupBuyActivity currentActivity = (GroupBuyActivity)this.groupBuyActivityService.getById(activityId);
        if (currentActivity.getIsDel().equals(1) || currentActivity.getActivityStatus().equals(0) || currentActivity.getGroupStatus().equals(GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_AUDIT.getCode()) || currentActivity.getGroupStatus().equals(GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_REFUSE.getCode())) {
            throw new CrmebException("\u5f53\u524d\u6d3b\u52a8\u5df2\u5931\u6548");
        }
    }
}

