/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.product.ProductAttribute;
import com.zbkj.common.model.product.ProductAttributeOption;
import com.zbkj.common.response.AttrValueResponse;
import com.zbkj.common.response.ProductResponseForCopyProduct;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.UrlUtil;
import com.zbkj.service.service.SystemConfigService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductUtils {
    private static final Logger log = LoggerFactory.getLogger(ProductUtils.class);
    private String baseUrl;
    String rightUrl;
    @Autowired
    private SystemConfigService systemConfigService;

    public ProductResponseForCopyProduct getTaobaoProductInfo99Api(String url, int tag) throws JSONException, IOException {
        this.setConfig(url, tag);
        org.json.JSONObject tbJsonData = ProductUtils.getRequestFromUrl(this.baseUrl + this.rightUrl);
        org.json.JSONObject data = tbJsonData.getJSONObject("data");
        if (null == data) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230data");
        }
        org.json.JSONObject item = data.getJSONObject("item");
        if (null == item) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230item");
        }
        ProductResponseForCopyProduct copyProduct = new ProductResponseForCopyProduct();
        copyProduct.setName(item.getString("title"));
        copyProduct.setIntro(item.getString("title"));
        copyProduct.setSliderImage(item.getString("images"));
        copyProduct.setImage(item.getString("images").split(",")[0].replace("[", "").replace("\"", ""));
        copyProduct.setKeyword(item.getString("title"));
        copyProduct.setContent(item.getString("desc"));
        copyProduct.setSpecType(Boolean.valueOf(true));
        JSONArray props = item.getJSONArray("props");
        if (null == props || props.length() < 1) {
            copyProduct.setSpecType(Boolean.valueOf(false));
            return copyProduct;
        }
        ArrayList<ProductAttribute> spaAttes = new ArrayList<ProductAttribute>();
        for (int i = 0; i < props.length(); ++i) {
            org.json.JSONObject pItem = props.getJSONObject(i);
            ProductAttribute spattr = new ProductAttribute();
            spattr.setAttributeName(pItem.getString("name"));
            JSONArray values = pItem.getJSONArray("values");
            ArrayList<ProductAttributeOption> optionList = new ArrayList<ProductAttributeOption>();
            for (int j = 0; j < values.length(); ++j) {
                org.json.JSONObject value = values.getJSONObject(j);
                ProductAttributeOption option = new ProductAttributeOption();
                option.setOptionName(value.getString("name"));
                optionList.add(option);
            }
            spattr.setOptionList(optionList);
            spaAttes.add(spattr);
        }
        copyProduct.setAttrList(spaAttes);
        return copyProduct;
    }

    public ProductResponseForCopyProduct getJDProductInfo99Api(String url, int tag) throws IOException, JSONException {
        this.setConfig(url, tag);
        org.json.JSONObject tbJsonData = ProductUtils.getRequestFromUrl(this.baseUrl + this.rightUrl);
        org.json.JSONObject data = tbJsonData.getJSONObject("data");
        if (null == data) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230data");
        }
        org.json.JSONObject item = data.getJSONObject("item");
        if (null == item) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230item");
        }
        ProductResponseForCopyProduct copyProduct = new ProductResponseForCopyProduct();
        copyProduct.setName(item.getString("name"));
        copyProduct.setIntro(item.getString("name"));
        copyProduct.setSliderImage(item.getString("images"));
        copyProduct.setImage(item.getString("images").split(",")[0].replace("[", "").replace("\"", ""));
        copyProduct.setPrice(new BigDecimal(item.getString("price")));
        copyProduct.setContent(item.getString("desc"));
        org.json.JSONObject props = item.getJSONObject("skuProps");
        if (null == props) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230props");
        }
        ArrayList<ProductAttribute> spaAttes = new ArrayList<ProductAttribute>();
        org.json.JSONObject saleJson = item.getJSONObject("saleProp");
        int attrValueIsNullCount = 0;
        Iterator saleProps = saleJson.keys();
        while (saleProps.hasNext()) {
            ProductAttribute spattr = new ProductAttribute();
            String stepkey = (String)saleProps.next();
            String stepValue = props.getString(stepkey);
            String stepValueValidLength = stepValue.replace("[", "").replace("]", "").replace("\"", "");
            if (stepValueValidLength.length() > 0) {
                com.alibaba.fastjson.JSONArray stepValues = JSON.parseArray((String)stepValue);
                int c = stepValues.get(0).toString().length();
                attrValueIsNullCount += c == 0 ? 1 : 0;
                spattr.setAttributeName(saleJson.getString(stepkey));
                ArrayList<ProductAttributeOption> optionList = new ArrayList<ProductAttributeOption>();
                String stepKeyStr = props.getString(stepkey);
                List stepKeyList = CrmebUtil.stringToArrayStr((String)stepKeyStr);
                for (String value : stepKeyList) {
                    ProductAttributeOption option = new ProductAttributeOption();
                    option.setOptionName(value);
                    optionList.add(option);
                }
                spattr.setOptionList(optionList);
                spaAttes.add(spattr);
                copyProduct.setAttrList(spaAttes);
                continue;
            }
            ++attrValueIsNullCount;
        }
        copyProduct.setSpecType(Boolean.valueOf(spaAttes.size() != attrValueIsNullCount));
        return copyProduct;
    }

    public ProductResponseForCopyProduct getTmallProductInfo99Api(String url, int tag) throws JSONException, IOException {
        this.setConfig(url, tag);
        org.json.JSONObject tbJsonData = ProductUtils.getRequestFromUrl(this.baseUrl + this.rightUrl);
        org.json.JSONObject data = tbJsonData.getJSONObject("data");
        if (null == data) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230data");
        }
        org.json.JSONObject item = data.getJSONObject("item");
        if (null == item) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230item");
        }
        ProductResponseForCopyProduct copyProduct = new ProductResponseForCopyProduct();
        copyProduct.setName(item.getString("title"));
        copyProduct.setIntro(item.getString("subTitle"));
        copyProduct.setSliderImage(item.getString("images"));
        copyProduct.setImage(item.getString("images").split(",")[0].replace("[", "").replace("\"", ""));
        copyProduct.setKeyword(item.getString("title"));
        copyProduct.setContent(item.getString("desc"));
        copyProduct.setSpecType(Boolean.valueOf(true));
        JSONArray props = item.getJSONArray("props");
        if (null == props || props.length() < 1) {
            copyProduct.setSpecType(Boolean.valueOf(false));
            return copyProduct;
        }
        ArrayList<ProductAttribute> spaAttes = new ArrayList<ProductAttribute>();
        for (int i = 0; i < props.length(); ++i) {
            org.json.JSONObject pItem = props.getJSONObject(i);
            ProductAttribute spattr = new ProductAttribute();
            spattr.setAttributeName(pItem.getString("name"));
            JSONArray values = pItem.getJSONArray("values");
            ArrayList<ProductAttributeOption> optionList = new ArrayList<ProductAttributeOption>();
            for (int j = 0; j < values.length(); ++j) {
                org.json.JSONObject value = values.getJSONObject(j);
                ProductAttributeOption option = new ProductAttributeOption();
                option.setOptionName(value.getString("name"));
                optionList.add(option);
            }
            spattr.setOptionList(optionList);
            spaAttes.add(spattr);
        }
        copyProduct.setAttrList(spaAttes);
        return copyProduct;
    }

    public ProductResponseForCopyProduct getPddProductInfo99Api(String url, int tag) throws JSONException, IOException {
        this.setConfig(url, tag);
        org.json.JSONObject tbJsonData = ProductUtils.getRequestFromUrl(this.baseUrl + this.rightUrl);
        org.json.JSONObject data = tbJsonData.getJSONObject("data");
        if (null == data) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230data");
        }
        org.json.JSONObject item = data.getJSONObject("item");
        if (null == item) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230item");
        }
        ProductResponseForCopyProduct copyProduct = new ProductResponseForCopyProduct();
        copyProduct.setName(item.getString("goodsName"));
        copyProduct.setIntro(item.getString("goodsDesc"));
        copyProduct.setSliderImage(item.getString("thumbUrl"));
        copyProduct.setImage(item.getString("banner"));
        copyProduct.setVideoLink(item.getJSONArray("video").getJSONObject(0).getString("videoUrl"));
        copyProduct.setPrice(BigDecimal.valueOf(item.getDouble("maxNormalPrice")));
        copyProduct.setOtPrice(BigDecimal.valueOf(item.getDouble("marketPrice")));
        JSONArray props = item.getJSONArray("skus");
        if (null == props) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230props");
        }
        if (props.length() > 0) {
            ArrayList<ProductAttribute> spaAttes = new ArrayList<ProductAttribute>();
            HashMap tempAttr = new HashMap();
            for (int i = 0; i < props.length(); ++i) {
                org.json.JSONObject pItem = props.getJSONObject(i);
                JSONArray specArray = pItem.getJSONArray("specs");
                for (int j = 0; j < specArray.length(); ++j) {
                    org.json.JSONObject specItem = specArray.getJSONObject(j);
                    String keyTemp = specItem.getString("spec_key");
                    String valueTemp = specItem.getString("spec_value");
                    if (tempAttr.containsKey(keyTemp)) {
                        if (((List)tempAttr.get(keyTemp)).contains(valueTemp)) continue;
                        ((List)tempAttr.get(keyTemp)).add(valueTemp);
                        continue;
                    }
                    ArrayList<String> tempList = new ArrayList<String>();
                    tempList.add(valueTemp);
                    tempAttr.put(keyTemp, tempList);
                }
            }
            for (String key : tempAttr.keySet()) {
                ProductAttribute spattr = new ProductAttribute();
                spattr.setAttributeName(key);
                String string = ((List)tempAttr.get(key)).toString();
                List opList = CrmebUtil.stringToArrayStr((String)string);
                ArrayList<ProductAttributeOption> optionList = new ArrayList<ProductAttributeOption>();
                for (String optionValue : opList) {
                    ProductAttributeOption option = new ProductAttributeOption();
                    option.setOptionName(optionValue);
                    optionList.add(option);
                }
                spattr.setOptionList(optionList);
                spaAttes.add(spattr);
            }
            copyProduct.setAttrList(spaAttes);
        }
        return copyProduct;
    }

    public ProductResponseForCopyProduct getSuningProductInfo99Api(String url, int tag) throws JSONException, IOException {
        this.setConfig(url, tag);
        org.json.JSONObject tbJsonData = ProductUtils.getRequestFromUrl(this.baseUrl + this.rightUrl);
        System.out.println("tbJsonData:" + tbJsonData);
        org.json.JSONObject data = tbJsonData.getJSONObject("data");
        if (null == data) {
            throw new CrmebException("\u590d\u5236\u5546\u54c1\u5931\u8d25--\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef--\u672a\u627e\u5230data");
        }
        ProductResponseForCopyProduct copyProduct = new ProductResponseForCopyProduct();
        copyProduct.setName(data.getString("title"));
        copyProduct.setIntro(data.getString("title"));
        copyProduct.setSliderImage(data.getString("images"));
        copyProduct.setImage(data.getString("images").split(",")[0].replace("[", "").replace("\"", ""));
        Long priceS = data.getLong("price");
        copyProduct.setPrice(BigDecimal.valueOf(priceS));
        copyProduct.setContent(data.getString("desc"));
        ArrayList spaAttes = new ArrayList();
        ProductAttribute spattr = new ProductAttribute();
        spattr.setAttributeName("\u9ed8\u8ba4");
        ArrayList<ProductAttributeOption> optionList = new ArrayList<ProductAttributeOption>();
        ProductAttributeOption option = new ProductAttributeOption();
        option.setOptionName("\u9ed8\u8ba4");
        optionList.add(option);
        spattr.setOptionList(optionList);
        copyProduct.setSpecType(Boolean.valueOf(false));
        copyProduct.setAttrList(spaAttes);
        return copyProduct;
    }

    public static void main(String[] args) {
        String rightEndUrl = "&itemid=";
        String url = "https://detail.tmall.hk/hk/item.htm?id=619049590004&spm=a1z10.1-b.w4004-21302253139.41.23962b1brA9Glm";
        rightEndUrl = rightEndUrl + UrlUtil.getParamsByKey((String)url, (String)"id");
        System.out.println(rightEndUrl);
    }

    public void setConfig(String url, int tag) {
        String rightEndUrl = "&itemid=";
        switch (tag) {
            case 1: {
                this.baseUrl = this.systemConfigService.getValueByKey("importProductTB");
                rightEndUrl = rightEndUrl + UrlUtil.getParamsByKey((String)url, (String)"id");
                break;
            }
            case 2: {
                this.baseUrl = this.systemConfigService.getValueByKey("importProductJD");
                String replace = url.substring(url.lastIndexOf("/") + 1);
                String substring = replace.substring(0, replace.indexOf("."));
                rightEndUrl = rightEndUrl + substring;
                break;
            }
            case 3: {
                this.baseUrl = this.systemConfigService.getValueByKey("importProductSN");
                int start = url.indexOf(".com/") + 5;
                int end = url.indexOf(".html");
                String sp = url.substring(start, end);
                String[] shopProduct = sp.split("/");
                rightEndUrl = rightEndUrl + shopProduct[1] + "&shopid=" + shopProduct[0];
                break;
            }
            case 4: {
                rightEndUrl = rightEndUrl + UrlUtil.getParamsByKey((String)url, (String)"goods_id");
                this.baseUrl = this.systemConfigService.getValueByKey("importProductPDD");
                break;
            }
            case 5: {
                rightEndUrl = rightEndUrl + UrlUtil.getParamsByKey((String)url, (String)"id");
                this.baseUrl = this.systemConfigService.getValueByKey("importProductTM");
            }
        }
        String token = this.systemConfigService.getValueByKey("copy_product_apikey");
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new CrmebException("\u8bf7\u914d\u7f6e\u590d\u5236\u4ea7\u54c1\u5e73\u53f0\u7684Token -- www.99api.com");
        }
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            throw new CrmebException("\u8bf7\u914d\u7f6e\u590d\u5236\u4ea7\u54c1\u5e73\u53f0\u7684Url-- www.99api.com");
        }
        this.rightUrl = "?apikey=" + token + rightEndUrl;
    }

    public static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static org.json.JSONObject getRequestFromUrl(String url) throws IOException, JSONException {
        URL realUrl = new URL(url);
        URLConnection conn = realUrl.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        try (InputStream instream = conn.getInputStream();){
            org.json.JSONObject json;
            BufferedReader rd = new BufferedReader(new InputStreamReader(instream, StandardCharsets.UTF_8));
            String jsonText = ProductUtils.readAll(rd);
            org.json.JSONObject jSONObject = json = new org.json.JSONObject(jsonText);
            return jSONObject;
        }
    }

    public static ProductResponseForCopyProduct onePassCopyTransition(JSONObject jsonObject) {
        log.error("\u4e00\u53f7\u901a\u590d\u5236\u5546\u54c1\u8fd4\u56dejson\uff1a");
        log.error(jsonObject.toJSONString());
        if (ObjectUtil.isNull((Object)jsonObject)) {
            throw new CrmebException((IResultEnum)CommonResultCode.NOT_FOUND, "\u5546\u54c1\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        ProductResponseForCopyProduct productRequestForCC = new ProductResponseForCopyProduct();
        productRequestForCC.setName(jsonObject.getString("store_name"));
        productRequestForCC.setIntro(jsonObject.getString("store_info"));
        productRequestForCC.setSliderImage(jsonObject.getString("slider_image"));
        productRequestForCC.setImage(jsonObject.getString("image").replace("[", "").replace("\"", ""));
        productRequestForCC.setKeyword(jsonObject.getString("store_name"));
        productRequestForCC.setCost(jsonObject.getBigDecimal("cost"));
        productRequestForCC.setPrice(jsonObject.getBigDecimal("price"));
        productRequestForCC.setOtPrice(jsonObject.getBigDecimal("ot_price"));
        productRequestForCC.setUnitName(jsonObject.getString("unit_name"));
        productRequestForCC.setContent(jsonObject.getString("description"));
        productRequestForCC.setSpecType(Boolean.valueOf(true));
        com.alibaba.fastjson.JSONArray props = jsonObject.getJSONArray("items");
        if (null == props || props.size() < 1) {
            productRequestForCC.setSpecType(Boolean.valueOf(false));
            return productRequestForCC;
        }
        productRequestForCC.setAttrList(ProductUtils.getAttrListByJsonArray(props));
        com.alibaba.fastjson.JSONArray attrValueJsonArray = jsonObject.getJSONObject("info").getJSONArray("value");
        List<AttrValueResponse> attrValueList = ProductUtils.getAttrValueListByOnePassData(attrValueJsonArray);
        productRequestForCC.setAttrValueList(attrValueList);
        return productRequestForCC;
    }

    private static List<ProductAttribute> getAttrListByJsonArray(com.alibaba.fastjson.JSONArray items) {
        ArrayList<ProductAttribute> spaAttes = new ArrayList<ProductAttribute>();
        for (int i = 0; i < items.size(); ++i) {
            JSONObject pItem = items.getJSONObject(i);
            ProductAttribute spattr = new ProductAttribute();
            spattr.setAttributeName(pItem.getString("value"));
            com.alibaba.fastjson.JSONArray values = pItem.getJSONArray("detail");
            ArrayList<ProductAttributeOption> optionList = new ArrayList<ProductAttributeOption>();
            for (int j = 0; j < values.size(); ++j) {
                String value = values.getString(j);
                ProductAttributeOption option = new ProductAttributeOption();
                option.setOptionName(value);
                optionList.add(option);
            }
            spattr.setOptionList(optionList);
            spaAttes.add(spattr);
        }
        return spaAttes;
    }

    private static List<AttrValueResponse> getAttrValueListByOnePassData(com.alibaba.fastjson.JSONArray attrValueJsonArray) {
        ArrayList<AttrValueResponse> attrValueList = new ArrayList<AttrValueResponse>();
        for (int i = 0; i < attrValueJsonArray.size(); ++i) {
            JSONObject attrValueJSONObject = attrValueJsonArray.getJSONObject(i);
            AttrValueResponse productAttrValue = new AttrValueResponse();
            JSONObject detailJsonObject = attrValueJSONObject.getJSONObject("detail");
            ArrayList<String> keyList = new ArrayList<String>();
            for (String key : detailJsonObject.keySet()) {
                keyList.add(key);
            }
            int attrSize = keyList.size();
            ArrayList<String> valueStrList = new ArrayList<String>();
            StringBuilder sku = new StringBuilder();
            for (int j = 0; j < attrSize; ++j) {
                if (j == 0) {
                    sku = new StringBuilder(attrValueJSONObject.getString("value" + (j + 1)));
                } else {
                    sku.append(",").append(attrValueJSONObject.getString("value" + (j + 1)));
                }
                valueStrList.add(attrValueJSONObject.getString("value" + (j + 1)));
            }
            LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
            for (String valueStr : valueStrList) {
                for (String key : detailJsonObject.keySet()) {
                    String value = detailJsonObject.getString(key);
                    if (!value.equals(valueStr)) continue;
                    valueMap.put(key, value);
                }
            }
            productAttrValue.setSku(sku.toString());
            productAttrValue.setImage(attrValueJSONObject.getString("pic"));
            productAttrValue.setAttrValue(JSONObject.toJSONString(valueMap));
            productAttrValue.setIsShow(Boolean.valueOf(true));
            attrValueList.add(productAttrValue);
        }
        return attrValueList;
    }
}

