/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantPrint;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.response.YlyAccessTokenResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.vo.PrintContentVo;
import com.zbkj.service.service.MerchantPrintService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.util.feiEYun;
import com.zbkj.service.util.yly.RequestMethod;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrintUtil {
    private static final Logger logger = LoggerFactory.getLogger(PrintUtil.class);
    @Autowired
    private MerchantPrintService merchantPrintService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private feiEYun feiEYun;
    @Autowired
    private OrderService orderService;
    @Autowired
    private SystemConfigService systemConfigService;

    public YlyAccessTokenResponse instantYly(MerchantPrint print) {
        YlyAccessTokenResponse ylyAccessTokenResponse = null;
        try {
            RequestMethod.init(print.getPrintYlyAppid(), print.getPrintYlySec());
            ylyAccessTokenResponse = (YlyAccessTokenResponse)JSON.parseObject((String)RequestMethod.getAccessToken(), YlyAccessTokenResponse.class);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u6613\u8054\u4e91\u6253\u5370\u673a\u5931\u8d25" + e.getMessage());
            logger.error("\u6613\u8054\u4e91 \u914d\u7f6e\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)print));
        }
        return ylyAccessTokenResponse;
    }

    public void printTicket(MerchantOrder merchantOrder) {
        Merchant merchant = this.merchantService.getByIdException(merchantOrder.getMerId());
        List<MerchantPrint> byMerIdAndStatusOn = this.merchantPrintService.getByMerIdAndStatusOn(merchant.getId());
        for (MerchantPrint merchantPrint : byMerIdAndStatusOn) {
            if (!merchantOrder.getMerId().equals(merchantPrint.getMerId())) continue;
            if (merchantPrint.getPrintType() == 0) {
                this.ylyPrint(merchantOrder, merchantPrint, merchant);
                continue;
            }
            if (merchantPrint.getPrintType() != 1) continue;
            this.feiEYun.print(merchantOrder, merchantPrint, merchant);
        }
    }

    public void batchPrintTicket(List<MerchantOrder> merchantOrderList) {
        for (MerchantOrder order : merchantOrderList) {
            Merchant merchant = this.merchantService.getByIdException(order.getMerId());
            List<MerchantPrint> byMerIdAndStatusOn = this.merchantPrintService.getByMerIdAndStatusOn(merchant.getId());
            for (MerchantPrint merchantPrint : byMerIdAndStatusOn) {
                if (!order.getMerId().equals(merchantPrint.getMerId())) continue;
                if (merchantPrint.getPrintType() == 0) {
                    this.ylyPrint(order, merchantPrint, merchant);
                    continue;
                }
                if (merchantPrint.getPrintType() != 1) continue;
                this.feiEYun.print(order, merchantPrint, merchant);
            }
        }
    }

    public void ylyPrint(MerchantOrder order, MerchantPrint merchantPrint, Merchant merchant) {
        YlyAccessTokenResponse tokenResponse = this.instantYly(merchantPrint);
        try {
            StringBuilder printSb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)merchantPrint.getContent())) {
                printSb.append("<FH><FB><center>" + merchant.getName() + "</center></FB></FH>");
                printSb.append("<FH>\u8ba2\u5355\u7f16\u53f7:" + order.getOrderNo() + "\n");
                printSb.append("\u65e5   \u671f:" + CrmebDateUtil.dateToStr((Date)order.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss") + "\n");
                printSb.append("\u7535   \u8bdd:" + (ObjectUtil.isEmpty((Object)order.getUserPhone()) ? "-" : order.getUserPhone()) + "\n");
                printSb.append("\u59d3   \u540d:" + (ObjectUtil.isEmpty((Object)order.getRealName()) ? "-" : order.getRealName()) + "\n");
                if (order.getShippingType().equals(1)) {
                    printSb.append("\u5730   \u5740:" + order.getUserAddress() + "\n");
                }
                printSb.append("\u8ba2\u5355\u5907\u6ce8:" + order.getUserRemark() + "</FH>\n");
                printSb.append("********************************");
                printSb.append("<FH>\u5546\u54c1\u540d\u79f0 \u5355\u4ef7 \u6570\u91cf \u91d1\u989d\n");
                printSb.append("********************************");
                printSb.append("<FH>" + this.printFormatGoodsList(this.orderDetailService.getShipmentByOrderNo(order.getOrderNo())) + "</FH>");
                printSb.append("********************************\n");
                printSb.append("<FH>");
                printSb.append("<LR>\u8d60\u9001\u79ef\u5206:" + order.getGainIntegral() + "</LR>");
                printSb.append("<LR>\u5408\u8ba1:" + order.getProTotalPrice() + "\u5143\uff0c\u4f18\u60e0:" + order.getCouponPrice() + "\u5143</LR>");
                printSb.append("<LR>\u90ae\u8d39:" + order.getTotalPostage() + "\u5143\uff0c\u62b5\u6263:" + order.getIntegralPrice() + "\u5143</LR>");
                printSb.append("</FH>");
                printSb.append("<FH><right>\u5b9e\u9645\u652f\u4ed8:" + order.getPayPrice() + "\u5143</right></FH>");
                printSb.append("<FB><FB><center>\u5b8c</center></FB></FB>");
            } else {
                Order merchatOrder;
                PrintContentVo printContentVo = (PrintContentVo)JSON.parseObject((String)merchantPrint.getContent(), PrintContentVo.class);
                if (printContentVo.getSmallTickerHeader().equals(1)) {
                    printSb.append("<FH><FB><center>" + merchant.getName() + "</center></FB></FH>");
                    printSb.append("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
                }
                if (printContentVo.getDeliveryInfo().equals(1)) {
                    if (order.getShippingType().equals(1)) {
                        printSb.append("\u914d\u9001\u65b9\u5f0f:\u5546\u5bb6\u914d\u9001\n");
                    } else if (order.getShippingType().equals(2)) {
                        printSb.append("\u914d\u9001\u65b9\u5f0f:\u95e8\u5e97\u81ea\u63d0\n");
                    } else {
                        printSb.append("\u914d\u9001\u65b9\u5f0f:\u865a\u62df\u53d1\u8d27\n");
                    }
                    printSb.append("\u5ba2\u6237\u59d3\u540d:" + (ObjectUtil.isEmpty((Object)order.getRealName()) ? "-" : order.getRealName()) + "\n");
                    printSb.append("\u5ba2\u6237\u7535\u8bdd:" + (ObjectUtil.isEmpty((Object)order.getUserPhone()) ? "-" : order.getUserPhone()) + "\n");
                    if (order.getShippingType().equals(1)) {
                        printSb.append("\u6536\u8d27\u5730\u5740:" + order.getUserAddress() + "\n");
                    }
                    printSb.append("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
                }
                if (printContentVo.getBuyerRemark().equals(1)) {
                    printSb.append("\u4e70\u5bb6\u5907\u6ce8:" + order.getUserRemark() + "\n");
                    printSb.append("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
                }
                if (printContentVo.getProductInfo().equals(1)) {
                    printSb.append("********************************");
                    printSb.append("<FH>\u5546\u54c1\u540d\u79f0 \u5355\u4ef7 \u6570\u91cf \u91d1\u989d\n");
                    printSb.append("********************************");
                    printSb.append("<FH>" + this.printFormatGoodsList(this.orderDetailService.getShipmentByOrderNo(order.getOrderNo())) + "</FH>");
                    printSb.append("********************************\n");
                }
                if (printContentVo.getFreightInfo().equals(1)) {
                    printSb.append("<right>\u8fd0\u8d39:" + order.getPayPostage().toString() + "\u5143\n</right>");
                }
                if (printContentVo.getDiscountInfo().equals(1)) {
                    printSb.append("<right>\u4f18\u60e0:-" + order.getCouponPrice().add(order.getSvipDiscountPrice()) + "\u5143\n</right>");
                    printSb.append("<right>\u62b5\u6263:-" + order.getIntegralPrice().toString() + "\u5143\n</right>");
                    if (order.getIsSvip().booleanValue() && order.getSvipDiscountPrice().compareTo(BigDecimal.ZERO) > 0) {
                        printSb.append("<right>\u4f1a\u5458\u4f18\u60e0:-" + order.getSvipDiscountPrice() + "\u5143\n</right>");
                    }
                    printSb.append("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
                }
                if (CollUtil.isNotEmpty((Collection)printContentVo.getPayInfo())) {
                    if (printContentVo.getPayInfo().contains(1)) {
                        merchatOrder = this.orderService.getByOrderNo(order.getOrderNo());
                        String payType = "";
                        switch (merchatOrder.getPayType()) {
                            case "weixin": {
                                payType = "\u5fae\u4fe1\u652f\u4ed8";
                                break;
                            }
                            case "alipay": {
                                payType = "\u652f\u4ed8\u5b9d\u652f\u4ed8";
                                break;
                            }
                            case "yue": {
                                payType = "\u4f59\u989d\u652f\u4ed8";
                            }
                        }
                        printSb.append("<right>\u652f\u4ed8\u65b9\u5f0f:" + payType + "\n</right>");
                    }
                    if (printContentVo.getPayInfo().contains(2)) {
                        printSb.append("<right>\u5b9e\u6536\u91d1\u989d:" + order.getPayPrice().toString() + "\u5143\n</right>");
                    }
                    printSb.append("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
                }
                if (CollUtil.isNotEmpty((Collection)printContentVo.getOrderInfo())) {
                    if (printContentVo.getOrderInfo().contains(1)) {
                        printSb.append("\u8ba2\u5355\u7f16\u53f7:" + order.getOrderNo() + "\n");
                    }
                    if (printContentVo.getOrderInfo().contains(2)) {
                        printSb.append("\u4e0b\u5355\u65f6\u95f4:" + DateUtil.format((Date)order.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss") + "\n");
                    }
                    if (printContentVo.getOrderInfo().contains(3)) {
                        merchatOrder = this.orderService.getByOrderNo(order.getOrderNo());
                        printSb.append("\u652f\u4ed8\u65f6\u95f4:" + DateUtil.format((Date)merchatOrder.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss") + "\n");
                    }
                    if (printContentVo.getOrderInfo().contains(4)) {
                        printSb.append("\u6253\u5370\u65f6\u95f4:" + DateUtil.date().toString("yyyy-MM-dd HH:mm:ss") + "\n");
                    }
                    printSb.append("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n");
                }
                if (printContentVo.getCodeUrlSwitch().equals(1) && StrUtil.isNotBlank((CharSequence)printContentVo.getCodeUrl())) {
                    String substring;
                    String codeUrl = printContentVo.getCodeUrl();
                    if (codeUrl.length() > 5 && (substring = codeUrl.substring(0, 5)).contains("page")) {
                        codeUrl = "http://" + this.systemConfigService.getValueByKey("site_url") + codeUrl;
                    }
                    printSb.append("<QR>" + codeUrl + "</QR>");
                }
                if (printContentVo.getBottomNoticeSwitch().equals(1) && StrUtil.isNotBlank((CharSequence)printContentVo.getBottomNotice())) {
                    printSb.append("<CA>" + printContentVo.getBottomNotice() + "</CA>");
                }
            }
            RequestMethod.getInstance().printIndex(tokenResponse.getBody().getAccess_token(), merchantPrint.getPrintYlyMerchineNo(), URLEncoder.encode(printSb.toString(), "utf-8"), "order111");
        }
        catch (Exception e) {
            logger.error("\u6613\u8054\u4e91\u6253\u5370\u5c0f\u7968\u5931\u8d25:" + e);
        }
    }

    public String printFormatGoodsList(List<OrderDetail> detailList) {
        StringBuilder printGoodsString = new StringBuilder();
        for (OrderDetail orderDetail : detailList) {
            String LastGoodsName = orderDetail.getProductName();
            if (StringUtils.isNotBlank((CharSequence)LastGoodsName) && LastGoodsName.length() > 10) {
                LastGoodsName = LastGoodsName.substring(0, 8);
            }
            printGoodsString.append(LastGoodsName);
            printGoodsString.append(" ").append(orderDetail.getPrice());
            printGoodsString.append(" ").append(orderDetail.getPayNum());
            printGoodsString.append(" ").append(orderDetail.getPrice().multiply(new BigDecimal(orderDetail.getPayNum()))).append("\n");
        }
        return printGoodsString.toString();
    }
}

