/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.WechatUrlLinkRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.CommonSearchRequest;
import com.zbkj.common.request.WechatGenerateUrlLinkRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.WechatUrlLinkRecordDao;
import com.zbkj.service.service.WechatService;
import com.zbkj.service.service.WechatUrlLinkRecordService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatUrlLinkRecordServiceImpl
extends ServiceImpl<WechatUrlLinkRecordDao, WechatUrlLinkRecord>
implements WechatUrlLinkRecordService {
    private static final Logger logger = LoggerFactory.getLogger(WechatUrlLinkRecordServiceImpl.class);
    @Resource
    private WechatUrlLinkRecordDao dao;
    @Autowired
    private WechatService wechatService;

    @Override
    public String miniGenerateUrlLink(WechatGenerateUrlLinkRequest request) {
        String path;
        String name = request.getName();
        if (this.isExistName(request.getName()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u94fe\u63a5\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        String originalPath = request.getOriginalPath();
        Integer expireInterval = request.getExpireInterval();
        String query = "";
        if (originalPath.contains("?")) {
            String[] split = originalPath.split("\\?", 2);
            path = split[0];
            query = split[1];
        } else {
            path = originalPath;
        }
        String urlLink = this.wechatService.generateMiniUrlLink(path, query, expireInterval, "release");
        WechatUrlLinkRecord urlLinkRecord = new WechatUrlLinkRecord();
        urlLinkRecord.setName(name);
        urlLinkRecord.setOriginalPath(request.getOriginalPath());
        urlLinkRecord.setPath(path);
        urlLinkRecord.setQuery(query);
        urlLinkRecord.setExpireInterval(expireInterval);
        urlLinkRecord.setUrlLink(urlLink);
        urlLinkRecord.setCreateId(SecurityUtil.getLoginUserVo().getUser().getId());
        boolean save = this.save(urlLinkRecord);
        if (!save) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u751f\u6210\u52a0\u5bc6URLLink\uff0c\u4fdd\u5b58\u8bb0\u5f55\u5f02\u5e38");
        }
        return urlLink;
    }

    private Boolean isExistName(String name) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(WechatUrlLinkRecord::getName, (Object)name);
        Integer count = this.dao.selectCount((Wrapper)lqw);
        return count >= 1;
    }

    @Override
    public PageInfo<WechatUrlLinkRecord> findMiniRecordPageList(CommonSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{WechatUrlLinkRecord::getId, WechatUrlLinkRecord::getName, WechatUrlLinkRecord::getOriginalPath, WechatUrlLinkRecord::getUrlLink, WechatUrlLinkRecord::getExpireInterval, WechatUrlLinkRecord::getCreateTime});
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            lqw.like(WechatUrlLinkRecord::getName, (Object)URLUtil.decode((String)request.getKeywords()));
        }
        lqw.eq(WechatUrlLinkRecord::getIsDel, (Object)0);
        lqw.orderByDesc(WechatUrlLinkRecord::getId);
        List recordList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)recordList);
    }

    @Override
    public Boolean deleteMiniUrlLinkRecord(Integer id) {
        WechatUrlLinkRecord record = (WechatUrlLinkRecord)this.getById(id);
        if (record.getIsDel().booleanValue()) {
            return Boolean.TRUE;
        }
        record.setIsDel(Boolean.valueOf(true));
        record.setUpdateTime((Date)DateUtil.date());
        return this.updateById(record);
    }
}

