/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.delivery.GetDeliveryListResponse;
import cn.binarywang.wx.miniapp.bean.shop.request.shipping.ContactBean;
import cn.binarywang.wx.miniapp.bean.shop.request.shipping.OrderKeyBean;
import cn.binarywang.wx.miniapp.bean.shop.request.shipping.PayerBean;
import cn.binarywang.wx.miniapp.bean.shop.request.shipping.ShippingListBean;
import cn.binarywang.wx.miniapp.bean.shop.request.shipping.WxMaOrderShippingInfoUploadRequest;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.member.PaidMemberOrder;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.model.wechat.WechatPayInfo;
import com.zbkj.common.response.OrderInvoiceResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderInvoiceService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.PaidMemberOrderService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.WechatOrderShippingService;
import com.zbkj.service.service.WechatPayInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatOrderShippingServiceImpl
implements WechatOrderShippingService {
    private static final Logger logger = LoggerFactory.getLogger(WechatOrderShippingServiceImpl.class);
    @Autowired
    private WechatPayInfoService wechatPayInfoService;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private OrderInvoiceService orderInvoiceService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RechargeOrderService rechargeOrderService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private PaidMemberOrderService paidMemberOrderService;
    @Autowired
    private WxMaService wxMaService;

    @Override
    public void uploadShippingInfo(String orderNo) {
        this.uploadShippingInfo(orderNo, "normal");
    }

    @Override
    public void uploadShippingInfo(String orderNo, String type) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CLOUD) || order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CDKEY)) {
            type = "fictitious";
        }
        int logisticsType = 0;
        int deliveryMode = 1;
        boolean isAllDelivered = true;
        switch (type) {
            case "fictitious": {
                logisticsType = 3;
                break;
            }
            case "verify": {
                logisticsType = 4;
                break;
            }
            case "normal": {
                logisticsType = 1;
                deliveryMode = 2;
                isAllDelivered = false;
            }
        }
        OrderKeyBean orderKeyBean = this.getOrderKeyBean(order.getOutTradeNo());
        PayerBean payerBean = this.getPayerBean(order.getUid());
        List<ShippingListBean> shippingListBeanList = this.getShippingListBeanList(orderNo, type);
        WxMaOrderShippingInfoUploadRequest uploadRequest = new WxMaOrderShippingInfoUploadRequest();
        uploadRequest.setOrderKey(orderKeyBean);
        uploadRequest.setLogisticsType(logisticsType);
        uploadRequest.setDeliveryMode(deliveryMode);
        uploadRequest.setIsAllDelivered(Boolean.valueOf(isAllDelivered));
        uploadRequest.setUploadTime(CrmebDateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX"));
        uploadRequest.setPayer(payerBean);
        uploadRequest.setShippingList(shippingListBeanList);
        if (type.equals("normal") && this.orderService.isAllSendGoods(order.getPlatOrderNo()).booleanValue()) {
            uploadRequest.setIsAllDelivered(Boolean.valueOf(true));
        }
        this.uploadShippingInfo(uploadRequest);
    }

    private void uploadShippingInfo(WxMaOrderShippingInfoUploadRequest uploadRequest) {
        try {
            this.wxMaService.getWxMaOrderShippingService().upload(uploadRequest);
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u4e0a\u4f20\u53d1\u8d27\u7ba1\u7406\uff0c\u5931\u8d25", (Throwable)e);
        }
    }

    private List<ShippingListBean> getShippingListBeanList(String orderNo, String type) {
        List<Object> shippingListBeanList = new ArrayList<ShippingListBean>();
        if (type.equals("fictitious") || type.equals("verify")) {
            ShippingListBean shippingListBean = new ShippingListBean();
            List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(orderNo);
            String collect = orderDetailList.stream().map(d -> StrUtil.format((CharSequence)"{}*{}\u4ef6", (Object[])new Object[]{d.getProductName(), d.getPayNum()})).collect(Collectors.joining(","));
            if (collect.length() > 120) {
                collect = collect.substring(0, 119);
            }
            shippingListBean.setItemDesc(collect);
            shippingListBeanList.add(shippingListBean);
        }
        if (type.equals("normal")) {
            List<OrderInvoiceResponse> invoiceResponseList = this.orderInvoiceService.findByOrderNo(orderNo);
            if (CollUtil.isEmpty(invoiceResponseList)) {
                throw new CrmebException("\u672a\u627e\u5230\u53d1\u8d27\u5355");
            }
            shippingListBeanList = invoiceResponseList.stream().map(e -> {
                ShippingListBean shippingListBean = new ShippingListBean();
                shippingListBean.setTrackingNo(e.getTrackingNumber());
                String expressCompany = this.getWechatDeliveryIdByOrderExpressName(e.getExpressName());
                shippingListBean.setExpressCompany(expressCompany);
                String collect = e.getDetailList().stream().map(d -> StrUtil.format((CharSequence)"{}*{}\u4ef6", (Object[])new Object[]{d.getProductName(), d.getNum()})).collect(Collectors.joining(","));
                if (collect.length() > 120) {
                    collect = collect.substring(0, 119);
                }
                shippingListBean.setItemDesc(collect);
                if (expressCompany.equals("SF")) {
                    MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
                    ContactBean contactDto = new ContactBean();
                    contactDto.setReceiverContact(CrmebUtil.maskMobile((String)merchantOrder.getUserPhone()));
                    shippingListBean.setContact(contactDto);
                }
                return shippingListBean;
            }).collect(Collectors.toList());
        }
        return shippingListBeanList;
    }

    private List<ShippingListBean> getShippingListBeanList(BigDecimal price, BigDecimal givePrice, String type) {
        ArrayList<ShippingListBean> shippingListBeanList = new ArrayList<ShippingListBean>();
        ShippingListBean shippingListBean = new ShippingListBean();
        if (type.equals("recharge")) {
            shippingListBean.setItemDesc(StrUtil.format((CharSequence)"\u7528\u6237\u5145\u503c{}\u4f59\u989d,\u8d60\u9001{}", (Object[])new Object[]{price, givePrice}));
            shippingListBeanList.add(shippingListBean);
        }
        if (type.equals("svip")) {
            shippingListBean.setItemDesc(StrUtil.format((CharSequence)"\u7528\u6237\u82b1\u8d39{}\u8d2d\u4e70SVIP\u4f1a\u5458,\u8d60\u9001{}\u4f59\u989d", (Object[])new Object[]{price, givePrice}));
            shippingListBeanList.add(shippingListBean);
        }
        return shippingListBeanList;
    }

    private PayerBean getPayerBean(Integer uid) {
        UserToken userToken = this.userTokenService.getTokenByUserId(uid, UserConstants.USER_TOKEN_TYPE_ROUTINE);
        if (ObjectUtil.isNull((Object)userToken)) {
            throw new CrmebException("\u672a\u627e\u5230\u7528\u6237\u5bf9\u5e94\u7684\u5c0f\u7a0b\u5e8fopenID");
        }
        PayerBean payerDto = new PayerBean();
        payerDto.setOpenid(userToken.getToken());
        return payerDto;
    }

    private OrderKeyBean getOrderKeyBean(String outTradeNo) {
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(outTradeNo);
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            throw new CrmebException("\u672a\u627e\u5230\u5bf9\u5e94\u5fae\u4fe1\u8ba2\u5355");
        }
        OrderKeyBean orderKeyBean = new OrderKeyBean();
        orderKeyBean.setOrderNumberType(2);
        orderKeyBean.setMchId(wechatPayInfo.getMchId());
        orderKeyBean.setTransactionId(wechatPayInfo.getTransactionId());
        orderKeyBean.setOutTradeNo(outTradeNo);
        return orderKeyBean;
    }

    @Override
    public void batchUploadRechargeOrderShipping() {
        String shippingSwitch = this.systemConfigService.getValueByKey("wechat_routine_shipping_switch");
        if (StrUtil.isBlank((CharSequence)shippingSwitch) || shippingSwitch.equals("0")) {
            return;
        }
        List<RechargeOrder> rechargeOrderList = this.rechargeOrderService.findAwaitUploadWechatList();
        if (CollUtil.isEmpty(rechargeOrderList)) {
            return;
        }
        for (RechargeOrder rechargeOrder : rechargeOrderList) {
            PayerBean payerBean;
            OrderKeyBean orderKeyBean;
            try {
                orderKeyBean = this.getOrderKeyBean(rechargeOrder.getOutTradeNo());
                payerBean = this.getPayerBean(rechargeOrder.getUid());
            }
            catch (Exception e) {
                logger.error("\u5145\u503c\u8ba2\u5355\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u8d27\uff0c\u83b7\u53d6\u5bf9\u5e94\u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u9519\u8bef\uff0c\u5145\u503c\u5355\u53f7={}", (Object)rechargeOrder.getOrderNo());
                logger.error("\u5145\u503c\u8ba2\u5355\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u8d27\uff0c\u83b7\u53d6\u5bf9\u5e94\u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u9519\u8bef\uff0c\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                continue;
            }
            List<ShippingListBean> shippingListBeanList = this.getShippingListBeanList(rechargeOrder.getPrice(), rechargeOrder.getGivePrice(), "recharge");
            WxMaOrderShippingInfoUploadRequest uploadRequest = new WxMaOrderShippingInfoUploadRequest();
            uploadRequest.setOrderKey(orderKeyBean);
            uploadRequest.setLogisticsType(3);
            uploadRequest.setDeliveryMode(1);
            uploadRequest.setIsAllDelivered(Boolean.valueOf(true));
            uploadRequest.setUploadTime(CrmebDateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX"));
            uploadRequest.setPayer(payerBean);
            uploadRequest.setShippingList(shippingListBeanList);
            this.uploadShippingInfo(uploadRequest);
        }
    }

    @Override
    public void batchUploadSvipOrderShipping() {
        String shippingSwitch = this.systemConfigService.getValueByKey("wechat_routine_shipping_switch");
        if (StrUtil.isBlank((CharSequence)shippingSwitch) || shippingSwitch.equals("0")) {
            return;
        }
        List<PaidMemberOrder> orderList = this.paidMemberOrderService.findAwaitUploadWechatList();
        if (CollUtil.isEmpty(orderList)) {
            return;
        }
        for (PaidMemberOrder order : orderList) {
            PayerBean payerBean;
            OrderKeyBean orderKeyBean;
            try {
                orderKeyBean = this.getOrderKeyBean(order.getOutTradeNo());
                payerBean = this.getPayerBean(order.getUid());
            }
            catch (Exception e) {
                logger.error("SVIP\u8ba2\u5355\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u8d27\uff0c\u83b7\u53d6\u5bf9\u5e94\u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u9519\u8bef\uff0c\u5145\u503c\u5355\u53f7={}", (Object)order.getOrderNo());
                logger.error("SVIP\u8ba2\u5355\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u8d27\uff0c\u83b7\u53d6\u5bf9\u5e94\u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u9519\u8bef\uff0c\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                continue;
            }
            List<ShippingListBean> shippingListBeanList = this.getShippingListBeanList(order.getPrice(), order.getGiftBalance(), "svip");
            WxMaOrderShippingInfoUploadRequest uploadRequest = new WxMaOrderShippingInfoUploadRequest();
            uploadRequest.setOrderKey(orderKeyBean);
            uploadRequest.setLogisticsType(3);
            uploadRequest.setDeliveryMode(1);
            uploadRequest.setIsAllDelivered(Boolean.valueOf(true));
            uploadRequest.setUploadTime(CrmebDateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX"));
            uploadRequest.setPayer(payerBean);
            uploadRequest.setShippingList(shippingListBeanList);
            this.uploadShippingInfo(uploadRequest);
        }
    }

    private String getWechatDeliveryIdByOrderExpressName(String expressName) {
        if (!this.redisUtil.exists("wechat_delivery").booleanValue()) {
            this.wechatGetDeliveryList();
        } else {
            Long hashSize = this.redisUtil.getHashSize("wechat_delivery");
            if (hashSize > 0L) {
                this.wechatGetDeliveryList();
            }
        }
        if (!this.redisUtil.hHasKey("wechat_delivery", expressName)) {
            return "YD";
        }
        Object object = this.redisUtil.hget("wechat_delivery", expressName);
        return object.toString();
    }

    private void wechatGetDeliveryList() {
        try {
            GetDeliveryListResponse deliveryListResponse = this.wxMaService.getWxMaImmediateDeliveryService().getDeliveryList();
            List deliveryList = deliveryListResponse.getDeliveryList();
            for (int i = 0; i < deliveryList.size(); ++i) {
                GetDeliveryListResponse.DeliveryList delivery = (GetDeliveryListResponse.DeliveryList)deliveryList.get(i);
                this.redisUtil.hset("wechat_delivery", delivery.getDeliveryName(), (Object)delivery.getDeliveryId());
            }
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u8fd0\u529b\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u8fd0\u529b\u5217\u8868\u5931\u8d25");
        }
    }
}

