/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.live.WxMaCreateRoomResult;
import cn.binarywang.wx.miniapp.bean.live.WxMaLiveAssistantInfo;
import cn.binarywang.wx.miniapp.bean.live.WxMaLiveResult;
import cn.binarywang.wx.miniapp.bean.live.WxMaLiveRoomInfo;
import cn.binarywang.wx.miniapp.bean.live.WxMaLiveSharedCode;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.zbkj.common.enums.WechatMPLiveRoomReviewStatusEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.exception.weixin.CRMEBWxError;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.wechat.live.WechatLiveAssistant;
import com.zbkj.common.model.wechat.live.WechatLiveGoods;
import com.zbkj.common.model.wechat.live.WechatLiveRoom;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.wxmplive.goods.WechatGoodsJSON;
import com.zbkj.common.request.wxmplive.goods.WechatLiveGoodsInRoomResponse;
import com.zbkj.common.request.wxmplive.goods.WechatLiveRoomSearchRequest;
import com.zbkj.common.request.wxmplive.room.WechatLiveRoomSharCode;
import com.zbkj.common.request.wxmplive.room.WechatMpLiveRoomInfoRequest;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.service.dao.wechat.live.WechatLiveRoomDao;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.WechatLiveAssistantService;
import com.zbkj.service.service.WechatLiveGoodsService;
import com.zbkj.service.service.WechatLiveRoomService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatLiveRoomServiceImpl
extends ServiceImpl<WechatLiveRoomDao, WechatLiveRoom>
implements WechatLiveRoomService {
    private static final Logger logger = LoggerFactory.getLogger(WechatLiveRoomServiceImpl.class);
    @Autowired
    private WxMaService wxMaService;
    @Autowired
    private WechatLiveAssistantService wechatLiveAssistantService;
    @Resource
    private WechatLiveRoomDao wechatLiveRoomDao;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private WechatLiveGoodsService weChatLiveGoodsService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;

    @Override
    public Boolean creteRoom(WechatMpLiveRoomInfoRequest roomInfo) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        Merchant currentMerchantInfo = this.merchantService.getByIdException(currentUser.getMerId());
        WechatLiveRoom wechatLiveRoom = new WechatLiveRoom();
        BeanUtils.copyProperties((Object)roomInfo, (Object)wechatLiveRoom);
        wechatLiveRoom.setMerName(currentMerchantInfo.getName());
        wechatLiveRoom.setMerType(currentMerchantInfo.getTypeId());
        wechatLiveRoom.setMerId(currentMerchantInfo.getId());
        wechatLiveRoom.setCoverImgLocal(this.systemAttachmentService.clearPrefix(wechatLiveRoom.getCoverImgLocal()));
        wechatLiveRoom.setShareImgLocal(this.systemAttachmentService.clearPrefix(wechatLiveRoom.getShareImgLocal()));
        wechatLiveRoom.setFeedsImgLocal(this.systemAttachmentService.clearPrefix(wechatLiveRoom.getFeedsImgLocal()));
        wechatLiveRoom.setStartTime(CrmebDateUtil.strToDate((String)roomInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        wechatLiveRoom.setEndTime(CrmebDateUtil.strToDate((String)roomInfo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        wechatLiveRoom.setReviewStatus(WechatMPLiveRoomReviewStatusEnum.BEFORE_REVIEW.getCode());
        return this.wechatLiveRoomDao.insert(wechatLiveRoom) > 0;
    }

    @Override
    public Boolean reviewRoom(Integer id, Integer reviewStatus, String reviewReason) {
        if (reviewStatus.equals(WechatMPLiveRoomReviewStatusEnum.PLAT_REVIEW_ERROR.getCode()) && ObjectUtil.isEmpty((Object)reviewReason)) {
            throw new CrmebException("\u5e73\u53f0\u5ba1\u6838\u5931\u8d25\u65f6\uff0c\u5ba1\u6838\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        WechatLiveRoom wechatLiveRoom = (WechatLiveRoom)this.wechatLiveRoomDao.selectById(id);
        if (reviewStatus.equals(WechatMPLiveRoomReviewStatusEnum.PLAT_REVIEW_ERROR.getCode())) {
            wechatLiveRoom.setReviewStatus(WechatMPLiveRoomReviewStatusEnum.PLAT_REVIEW_ERROR.getCode());
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        try {
            wechatLiveRoom.setReviewStatus(reviewStatus);
            wechatLiveRoom.setReviewReason(reviewReason);
            if (wechatLiveRoom.getReviewStatus().equals(WechatMPLiveRoomReviewStatusEnum.WECHAT_REVIEW_SUCCESS.getCode())) {
                WxMaLiveRoomInfo wxMaLiveRoomInfo = new WxMaLiveRoomInfo();
                BeanUtils.copyProperties((Object)wechatLiveRoom, (Object)wxMaLiveRoomInfo);
                wxMaLiveRoomInfo.setStartTime(Long.valueOf(wechatLiveRoom.getStartTime().getTime() / 1000L));
                wxMaLiveRoomInfo.setEndTime(Long.valueOf(wechatLiveRoom.getEndTime().getTime() / 1000L));
                wxMaLiveRoomInfo.setName(wechatLiveRoom.getRoomName());
                WxMaCreateRoomResult roomResult = this.wxMaService.getLiveService().createRoom(wxMaLiveRoomInfo);
                if (ObjectUtil.isNotNull((Object)roomResult.getRoomId())) {
                    wechatLiveRoom.setRoomId(roomResult.getRoomId()).setQrcodeUrl(roomResult.getQrcodeUrl()).setReviewStatus(WechatMPLiveRoomReviewStatusEnum.WECHAT_REVIEW_SUCCESS.getCode());
                } else {
                    wechatLiveRoom.setReviewStatus(WechatMPLiveRoomReviewStatusEnum.WECHAT_REVIEW_ERROR.getCode()).setReviewReason("\u5fae\u4fe1\u5ba1\u6838\u76f4\u64ad\u95f4 \u5931\u8d25:" + JSON.toJSONString((Object)roomResult));
                }
            } else {
                throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad \u5ba1\u6838\u6709\u6f0f\u7f51\u53c2\u6570:id:" + id + "|reviewStatus:" + reviewStatus + "|reviewReason:" + reviewReason + "!{}" + JSON.toJSONString((Object)wechatLiveRoom));
            }
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        catch (WxErrorException e) {
            wechatLiveRoom.setReviewStatus(WechatMPLiveRoomReviewStatusEnum.WECHAT_REVIEW_ERROR.getCode()).setReviewReason(e.getMessage());
            this.wechatLiveRoomDao.updateById(wechatLiveRoom);
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u521b\u5efa\u76f4\u64ad\u5ba4\u5931\u8d25 {}", (Object)e.getMessage());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u521b\u5efa\u76f4\u64ad\u5ba4\u5931\u8d25\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean editRoom(WechatMpLiveRoomInfoRequest roomInfo) {
        WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(roomInfo.getId());
        try {
            if (wechatLiveRoom.getReviewStatus().equals(WechatMPLiveRoomReviewStatusEnum.WECHAT_REVIEW_SUCCESS.getCode())) {
                WxMaLiveRoomInfo wxMaLiveRoomInfo = new WxMaLiveRoomInfo();
                BeanUtils.copyProperties((Object)roomInfo, (Object)wxMaLiveRoomInfo);
                wxMaLiveRoomInfo.setId(wechatLiveRoom.getRoomId());
                wxMaLiveRoomInfo.setStartTime(Long.valueOf(wechatLiveRoom.getStartTime().getTime() / 1000L));
                wxMaLiveRoomInfo.setEndTime(Long.valueOf(wechatLiveRoom.getEndTime().getTime() / 1000L));
                wxMaLiveRoomInfo.setName(wechatLiveRoom.getRoomName());
                this.wxMaService.getLiveService().editRoom(wxMaLiveRoomInfo);
            } else {
                wechatLiveRoom.setReviewStatus(WechatMPLiveRoomReviewStatusEnum.BEFORE_REVIEW.getCode());
            }
            BeanUtils.copyProperties((Object)roomInfo, (Object)wechatLiveRoom);
            if (ObjectUtil.isNotEmpty((Object)wechatLiveRoom.getCoverImgLocal())) {
                wechatLiveRoom.setCoverImgLocal(this.systemAttachmentService.clearPrefix(wechatLiveRoom.getCoverImgLocal()));
            }
            if (ObjectUtil.isNotEmpty((Object)wechatLiveRoom.getShareImgLocal())) {
                wechatLiveRoom.setShareImgLocal(this.systemAttachmentService.clearPrefix(wechatLiveRoom.getShareImgLocal()));
            }
            if (ObjectUtil.isNotEmpty((Object)wechatLiveRoom.getFeedsImgLocal())) {
                wechatLiveRoom.setFeedsImgLocal(this.systemAttachmentService.clearPrefix(wechatLiveRoom.getFeedsImgLocal()));
            }
            if (ObjectUtil.isNotEmpty((Object)roomInfo.getStartTime())) {
                wechatLiveRoom.setStartTime(CrmebDateUtil.strToDate((String)roomInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (ObjectUtil.isNotEmpty((Object)roomInfo.getEndTime())) {
                wechatLiveRoom.setEndTime(CrmebDateUtil.strToDate((String)roomInfo.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        catch (WxErrorException e) {
            this.wechatLiveRoomDao.updateById(wechatLiveRoom);
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u7f16\u8f91\u76f4\u64ad\u5ba4\u5931\u8d25 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u7f16\u8f91\u76f4\u64ad\u5ba4\u5931\u8d25\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean deleteRoom(Integer id) {
        WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
        try {
            if (wechatLiveRoom.getReviewStatus().equals(WechatMPLiveRoomReviewStatusEnum.WECHAT_REVIEW_SUCCESS.getCode())) {
                this.wxMaService.getLiveService().deleteRoom(wechatLiveRoom.getRoomId());
            }
            return this.wechatLiveRoomDao.deleteById(id) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u76f4\u64ad\u95f4\u5931\u8d25 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u76f4\u64ad\u95f4\u5931\u8d25\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public WechatLiveRoom getRoomInfoById(Integer id) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        WechatLiveRoom liveRoom = (WechatLiveRoom)this.getById(id);
        if (ObjectUtil.isNull((Object)liveRoom)) {
            throw new CrmebException("\u76f4\u64ad\u95f4\u4e0d\u5b58\u5728");
        }
        if (admin.getMerId() > 0 && !admin.getMerId().equals(liveRoom.getMerId())) {
            throw new CrmebException("\u76f4\u64ad\u95f4\u4e0d\u5b58\u5728");
        }
        return liveRoom;
    }

    @Override
    public List<WechatLiveRoom> getLiveList(WechatLiveRoomSearchRequest searchRequest, PageParamRequest pageParamRequest, Boolean isMer) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LoginUserVo currentUser = SecurityUtil.getLoginUserVo();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotEmpty((Object)searchRequest.getKeywords())) {
            String decodeKeyWords = URLUtil.decode((String)searchRequest.getKeywords());
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(WechatLiveRoom::getId, (Object)decodeKeyWords)).or()).eq(WechatLiveRoom::getRoomId, (Object)decodeKeyWords)).or()).like(WechatLiveRoom::getRoomName, (Object)decodeKeyWords)).or()).like(WechatLiveRoom::getAnchorName, (Object)decodeKeyWords)).or()).like(WechatLiveRoom::getAnchorWechat, (Object)decodeKeyWords)).or()).like(WechatLiveRoom::getSubAnchorWechat, (Object)decodeKeyWords);
        }
        if (ObjectUtil.isNotEmpty((Object)searchRequest.getLiveStatus())) {
            lambdaQueryWrapper.eq(WechatLiveRoom::getLiveStatus, (Object)searchRequest.getLiveStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)searchRequest.getStoreShow())) {
            lambdaQueryWrapper.eq(WechatLiveRoom::getStoreShow, (Object)searchRequest.getStoreShow());
        }
        if (ObjectUtil.isNotEmpty((Object)searchRequest.getReviewStatus())) {
            lambdaQueryWrapper.eq(WechatLiveRoom::getReviewStatus, (Object)searchRequest.getReviewStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)searchRequest.getMerName())) {
            lambdaQueryWrapper.like(WechatLiveRoom::getMerName, (Object)searchRequest.getMerName());
        }
        if (ObjectUtil.isNotEmpty((Object)searchRequest.getMerType())) {
            lambdaQueryWrapper.like(WechatLiveRoom::getMerType, (Object)searchRequest.getMerType());
        }
        if (ObjectUtil.isNotEmpty((Object)searchRequest.getStar())) {
            lambdaQueryWrapper.like(WechatLiveRoom::getStar, (Object)searchRequest.getStar());
        }
        if (ObjectUtil.isNotEmpty((Object)searchRequest.getSort())) {
            lambdaQueryWrapper.like(WechatLiveRoom::getSort, (Object)searchRequest.getSort());
        }
        if (isMer.booleanValue()) {
            lambdaQueryWrapper.eq(WechatLiveRoom::getMerId, (Object)currentUser.getUser().getMerId());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.orderByDesc(WechatLiveRoom::getStar)).orderByDesc(WechatLiveRoom::getSort)).orderByDesc(WechatLiveRoom::getId);
        return this.wechatLiveRoomDao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<WechatLiveRoom> getLiveListForFront(PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.le(WechatLiveRoom::getLiveStatus, (Object)103)).eq(WechatLiveRoom::getStoreShow, (Object)1)).orderByDesc(WechatLiveRoom::getSort)).orderByDesc(WechatLiveRoom::getStartTime);
        return this.wechatLiveRoomDao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public WechatLiveRoomSharCode getShareQRCodeByRoomId(Integer id, String params) {
        WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
        WechatLiveRoomSharCode sharCode = new WechatLiveRoomSharCode();
        try {
            WxMaLiveSharedCode sharedCode = this.wxMaService.getLiveService().getSharedCode(wechatLiveRoom.getRoomId(), params);
            String json = new Gson().toJson((Object)sharedCode);
            sharCode = (WechatLiveRoomSharCode)JSON.parseObject((String)json, WechatLiveRoomSharCode.class);
            wechatLiveRoom.setQrcodeUrl(json);
            this.wechatLiveRoomDao.updateById(wechatLiveRoom);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u83b7\u53d6\u76f4\u64ad\u95f4\u5206\u4eab\u4e8c\u7ef4\u7801\u5931\u8d25 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u83b7\u53d6\u76f4\u64ad\u95f4\u5206\u4eab\u4e8c\u7ef4\u7801\u5931\u8d25\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
        return sharCode;
    }

    @Override
    public Boolean addGoodsToRoom(Integer id, List<Integer> ids) {
        WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
        try {
            boolean addGoodsToRoomResult = this.wxMaService.getLiveService().addGoodsToRoom(wechatLiveRoom.getRoomId(), ids);
            wechatLiveRoom.setGoods(Joiner.on((String)",").join(ids));
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u6dfb\u52a0\u5546\u54c1\u5230\u76f4\u64ad\u95f4 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u6dfb\u52a0\u5546\u54c1\u5230\u76f4\u64ad\u95f4\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public List<WechatLiveGoodsInRoomResponse> getRoomGoodsList(Integer id) {
        ArrayList<WechatLiveGoodsInRoomResponse> responseList = new ArrayList<WechatLiveGoodsInRoomResponse>();
        WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
        if (ObjectUtil.isEmpty((Object)wechatLiveRoom.getGoods()) || wechatLiveRoom.getGoods().length() == 0) {
            return new ArrayList<WechatLiveGoodsInRoomResponse>();
        }
        List<Integer> goodsIdList = Stream.of(wechatLiveRoom.getGoods().split(",")).map(Integer::valueOf).collect(Collectors.toList());
        List wechatGoodsJSONS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)wechatLiveRoom.getGoodsJson())) {
            wechatGoodsJSONS = JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)wechatLiveRoom.getGoodsJson(), (boolean)Boolean.FALSE), WechatGoodsJSON.class);
        }
        List<WechatLiveGoods> currentRoomGoods = this.weChatLiveGoodsService.getByGoodsId(goodsIdList);
        for (WechatLiveGoods currentRoomGood : currentRoomGoods) {
            WechatLiveGoodsInRoomResponse roomResponse = new WechatLiveGoodsInRoomResponse();
            BeanUtils.copyProperties((Object)currentRoomGood, (Object)roomResponse);
            boolean isExit = false;
            if (ObjectUtil.isNotEmpty(wechatGoodsJSONS)) {
                isExit = wechatGoodsJSONS.stream().filter(good -> good.getGoodsId().equals(currentRoomGood.getGoodsId())).collect(Collectors.toList()).size() > 0;
            }
            roomResponse.setOnSale(Integer.valueOf(isExit ? 1 : 0));
            responseList.add(roomResponse);
        }
        return responseList;
    }

    @Override
    public Boolean deleteGoodsInRoom(Integer id, Integer goodsId) {
        try {
            WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
            boolean deleteInRoomResult = this.wxMaService.getLiveService().deleteInRoom(wechatLiveRoom.getRoomId(), goodsId);
            List beforeDeleteRoomGoodsList = Stream.of(wechatLiveRoom.getGoods().split(",")).map(Integer::valueOf).collect(Collectors.toList());
            List afterDeleteRoomGoodsList = beforeDeleteRoomGoodsList.stream().filter(i -> !i.equals(goodsId)).collect(Collectors.toList());
            wechatLiveRoom.setGoods(Joiner.on((String)",").join(afterDeleteRoomGoodsList));
            int deleteRows = this.wechatLiveRoomDao.updateById(wechatLiveRoom);
            this.syncLiveRoom();
            return deleteRows > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u76f4\u64ad\u95f4\u5546\u54c1 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u76f4\u64ad\u95f4\u5546\u54c1\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public String getSubanchorByRoomId(Integer roomId) {
        try {
            String subanchor = this.wxMaService.getLiveService().getSubanchor(roomId);
            return subanchor;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u83b7\u53d6\u4e3b\u64ad\u526f\u53f7 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u83b7\u53d6\u4e3b\u64ad\u526f\u53f7\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean addSubanchorNameByRoomId(Integer roomId, String userName) {
        try {
            return this.wxMaService.getLiveService().addSubanchor(roomId, userName);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u6dfb\u52a0\u4e3b\u64ad\u526f\u53f7 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u6dfb\u52a0\u4e3b\u64ad\u526f\u53f7\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean modifySubanchorNameByRoomId(Integer roomId, String userName) {
        try {
            return this.wxMaService.getLiveService().modifySubanchor(roomId, userName);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u4fee\u6539\u4e3b\u64ad\u526f\u53f7 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u4fee\u6539\u4e3b\u64ad\u526f\u53f7\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean deleteSubanchorNameByRoomId(Integer roomId) {
        try {
            return this.wxMaService.getLiveService().deleteSubanchor(roomId);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u4e3b\u64ad\u526f\u53f7 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u4e3b\u64ad\u526f\u53f7\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean goodsPush(Integer roomId, Integer goodsId) {
        try {
            return this.wxMaService.getLiveService().push(roomId, goodsId);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u63a8\u9001\u5546\u54c1\u5931\u8d25 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u63a8\u9001\u5546\u54c1\u5931\u8d25\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean goodsOnSale(Integer roomId, Integer goodsId, Integer onSale) {
        this.getRoomInfoById(roomId);
        try {
            boolean onsaleResult = this.wxMaService.getLiveService().onsale(roomId, goodsId, onSale);
            this.syncLiveRoom();
            return onsaleResult;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u63a8\u9001\u5546\u54c1\u5931\u8d25 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u63a8\u9001\u5546\u54c1\u5931\u8d25\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean goodsSort(Integer roomId, List<Map<String, String>> goods) {
        this.getRoomInfoById(roomId);
        try {
            return this.wxMaService.getLiveService().sort(roomId, goods);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5546\u54c1\u6392\u5e8f {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5546\u54c1\u6392\u5e8f\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean mangerAssistant(Integer id, List<Integer> assids) {
        WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
        List<Object> existAss = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)wechatLiveRoom.getAssistant())) {
            existAss = Stream.of(wechatLiveRoom.getAssistant().split(",")).map(Integer::valueOf).collect(Collectors.toList());
        }
        List assidss = assids.stream().sorted().collect(Collectors.toList());
        List existAsss = existAss.stream().sorted().collect(Collectors.toList());
        ArrayList<Integer> forAddAss = new ArrayList<Integer>();
        ArrayList<Object> forDelAss = new ArrayList<Object>();
        if (assids.equals(existAss)) {
            return true;
        }
        if (existAss.size() == 0) {
            forAddAss.addAll(assids);
        } else if (existAss.size() > 0 && assids.size() == 0) {
            forDelAss.addAll(existAss);
        } else {
            List localNotExist = existAss.stream().filter(item -> !assidss.contains(item)).collect(Collectors.toList());
            forDelAss.addAll(localNotExist);
            List pramNotExist = assidss.stream().filter(item -> !existAsss.contains(item)).collect(Collectors.toList());
            forAddAss.addAll(pramNotExist);
        }
        try {
            WxMaLiveAssistantInfo wxMaLiveAssistantInfo;
            List wechatLiveAssistants_forAdd = new ArrayList();
            if (forAddAss.size() > 0) {
                wechatLiveAssistants_forAdd = this.wechatLiveAssistantService.listByIds(forAddAss);
            }
            List wechatLiveAssistants_forDel = new ArrayList();
            if (forDelAss.size() > 0) {
                wechatLiveAssistants_forDel = this.wechatLiveAssistantService.listByIds(forDelAss);
            }
            ArrayList<WxMaLiveAssistantInfo> wxMaLiveAssistantInfosAdd = new ArrayList<WxMaLiveAssistantInfo>();
            ArrayList<WxMaLiveAssistantInfo> wxMaLiveAssistantInfosDel = new ArrayList<WxMaLiveAssistantInfo>();
            for (WechatLiveAssistant user : wechatLiveAssistants_forAdd) {
                wxMaLiveAssistantInfo = new WxMaLiveAssistantInfo();
                wxMaLiveAssistantInfo.setAlias(user.getAssDesc());
                wxMaLiveAssistantInfo.setNickname(user.getWechatNickname());
                wxMaLiveAssistantInfo.setUsername(user.getWechat());
                wxMaLiveAssistantInfosAdd.add(wxMaLiveAssistantInfo);
            }
            for (WechatLiveAssistant user : wechatLiveAssistants_forDel) {
                wxMaLiveAssistantInfo = new WxMaLiveAssistantInfo();
                wxMaLiveAssistantInfo.setAlias(user.getAssDesc());
                wxMaLiveAssistantInfo.setNickname(user.getWechatNickname());
                wxMaLiveAssistantInfo.setUsername(user.getWechat());
                wxMaLiveAssistantInfosDel.add(wxMaLiveAssistantInfo);
            }
            if (wxMaLiveAssistantInfosAdd.size() > 0) {
                boolean addOnRoomResult = this.wxMaService.getLiveService().addAssistant(wechatLiveRoom.getRoomId(), wxMaLiveAssistantInfosAdd);
                if (!addOnRoomResult) {
                    throw new CrmebException("\u65b0\u589e\u5c0f\u52a9\u624b\u5230\u76f4\u64ad\u95f4\u5931\u8d25");
                }
                wechatLiveRoom.setAssistant(Joiner.on((String)",").join(assids));
                return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
            }
            wxMaLiveAssistantInfosDel.forEach(item -> {
                try {
                    this.wxMaService.getLiveService().removeAssistant(wechatLiveRoom.getRoomId(), item.getUsername());
                }
                catch (WxErrorException e) {
                    logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u52a9\u624b\u51fa\u9519:{}", (Throwable)e);
                }
            });
            wechatLiveRoom.setAssistant(Joiner.on((String)",").join(assids));
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u65b0\u589e\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u65b0\u589e\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean modifyAssistant(Integer id, Integer assid) {
        try {
            WechatLiveRoom wechatLiveRoom = (WechatLiveRoom)this.wechatLiveRoomDao.selectById(id);
            if (ObjectUtil.isNull((Object)wechatLiveRoom)) {
                throw new CrmebException("\u5f53\u524d\u76f4\u64ad\u95f4\u4e0d\u5b58\u5728");
            }
            WechatLiveAssistant currentAss = (WechatLiveAssistant)this.wechatLiveAssistantService.getById(assid);
            boolean resultAssistant = this.wxMaService.getLiveService().modifyAssistant(wechatLiveRoom.getRoomId(), currentAss.getWechat(), currentAss.getWechatNickname());
            if (!resultAssistant) {
                throw new CrmebException("\u4fee\u6539\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b \u64cd\u4f5c\u5931\u8d25:" + JSON.toJSONString((Object)wechatLiveRoom));
            }
            List<Object> assisList = new ArrayList();
            if (ObjectUtil.isNotNull((Object)wechatLiveRoom.getAssistant()) && wechatLiveRoom.getAssistant().length() > 0) {
                assisList = Stream.of(wechatLiveRoom.getAssistant().split(",")).map(Integer::valueOf).collect(Collectors.toList());
                assisList.add(assid);
            }
            wechatLiveRoom.setAssistant(Joiner.on((String)",").join(assisList));
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u4fee\u6539\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u4fee\u6539\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean removeAssistant(Integer id, Integer assid) {
        try {
            WechatLiveRoom wechatLiveRoom = (WechatLiveRoom)this.wechatLiveRoomDao.selectById(id);
            WechatLiveAssistant assistant = (WechatLiveAssistant)this.wechatLiveAssistantService.getById(assid);
            boolean removeAssistant = this.wxMaService.getLiveService().removeAssistant(wechatLiveRoom.getRoomId(), assistant.getWechat());
            if (!removeAssistant) {
                throw new CrmebException("\u5220\u9664\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b \u5fae\u4fe1\u7aef\u5f02\u5e38");
            }
            List<Object> assisList = new ArrayList();
            if (ObjectUtil.isNotEmpty((Object)wechatLiveRoom.getAssistant())) {
                assisList = Stream.of(wechatLiveRoom.getAssistant().split(",")).map(Integer::valueOf).collect(Collectors.toList());
                assisList.remove(assid);
            }
            wechatLiveRoom.setAssistant(Joiner.on((String)",").join(assisList));
            return this.wechatLiveAssistantService.removeById(assid);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u76f4\u64ad\u95f4\u5c0f\u52a9\u624b\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public List<WechatLiveAssistant> getAssistantByRoom(Integer id) {
        WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
        List<Object> wechatLiveAssistantList = new ArrayList<WechatLiveAssistant>();
        if (ObjectUtil.isNotEmpty((Object)wechatLiveRoom.getAssistant())) {
            List assIds = Stream.of(wechatLiveRoom.getAssistant().split(",")).map(Integer::valueOf).collect(Collectors.toList());
            wechatLiveAssistantList = this.wechatLiveAssistantService.listByIds(assIds);
        }
        return wechatLiveAssistantList;
    }

    @Override
    public Boolean updateComment(Integer id, Integer banComment) {
        try {
            WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
            boolean updateComment = this.wxMaService.getLiveService().updatecomment(wechatLiveRoom.getRoomId(), banComment);
            if (!updateComment) {
                throw new CrmebException("\u7981\u8a00\u64cd\u4f5c\u5931\u8d25:" + JSON.toJSONString((Object)wechatLiveRoom));
            }
            wechatLiveRoom.setCloseComment(banComment);
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u7981\u8a00\u529f\u80fd {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u7981\u8a00\u529f\u80fd\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean updateFeedPublic(Integer id, Integer isFeedsPublic) {
        try {
            WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
            boolean updateFeedPublic = this.wxMaService.getLiveService().updatefeedpublic(wechatLiveRoom.getRoomId(), isFeedsPublic);
            if (!updateFeedPublic) {
                throw new CrmebException("\u5b98\u65b9\u6536\u5f55\u64cd\u4f5c\u5931\u8d25:" + JSON.toJSONString((Object)wechatLiveRoom));
            }
            wechatLiveRoom.setIsFeedsPublic(isFeedsPublic);
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5b98\u65b9\u6536\u5f55\u7ba1\u7406 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5b98\u65b9\u6536\u5f55\u7ba1\u7406\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean updateKF(Integer id, Integer closeKf) {
        try {
            boolean updateKf;
            WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
            if (wechatLiveRoom.getReviewStatus().equals(WechatMPLiveRoomReviewStatusEnum.WECHAT_REVIEW_SUCCESS.getCode()) && !(updateKf = this.wxMaService.getLiveService().updatekf(wechatLiveRoom.getRoomId(), closeKf))) {
                throw new CrmebException("\u5ba2\u6237\u5f00\u5173\u64cd\u4f5c\u5931\u8d25:" + JSON.toJSONString((Object)wechatLiveRoom));
            }
            wechatLiveRoom.setCloseKf(closeKf);
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5ba2\u670d\u529f\u80fd\u7ba1\u7406 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5ba2\u670d\u529f\u80fd\u7ba1\u7406\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean updateReplay(Integer id, Integer closeReplay) {
        try {
            WechatLiveRoom wechatLiveRoom = this.getRoomInfoById(id);
            boolean updateReplay = this.wxMaService.getLiveService().updatereplay(wechatLiveRoom.getRoomId(), closeReplay);
            if (!updateReplay) {
                throw new CrmebException("\u56de\u653e\u529f\u80fd\u64cd\u4f5c\u5931\u8d25:" + JSON.toJSONString((Object)wechatLiveRoom));
            }
            wechatLiveRoom.setLiveReplay(closeReplay + "");
            return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5ba2\u670d\u529f\u80fd\u7ba1\u7406 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5ba2\u670d\u529f\u80fd\u7ba1\u7406\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public String getVideo(Integer id, Integer goodsId) {
        try {
            WechatLiveRoom wechatLiveRoom = (WechatLiveRoom)this.wechatLiveRoomDao.selectById(id);
            return this.wxMaService.getLiveService().getVideo(wechatLiveRoom.getRoomId(), goodsId);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5ba2\u670d\u529f\u80fd\u7ba1\u7406 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5ba2\u670d\u529f\u80fd\u7ba1\u7406\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public List<WxMaLiveResult.RoomInfo> syncLiveRoom() {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ArrayList<WechatLiveRoom> wechatLiveRoomsList = new ArrayList<WechatLiveRoom>();
        ArrayList<WxMaLiveResult.RoomInfo> liveInfos = new ArrayList();
        try {
            liveInfos = this.wxMaService.getLiveService().getLiveInfos();
            for (WxMaLiveResult.RoomInfo liveInfo : liveInfos) {
                WxMaLiveResult liveReplay;
                WechatLiveRoom wechatLiveRoom = new WechatLiveRoom();
                wechatLiveRoom.setRoomName(liveInfo.getName());
                wechatLiveRoom.setCoverImgWx(liveInfo.getCoverImg());
                wechatLiveRoom.setStartTime(new Date(Long.parseLong(liveInfo.getStartTime() + "000")));
                wechatLiveRoom.setEndTime(new Date(Long.parseLong(liveInfo.getEndTime() + "000")));
                wechatLiveRoom.setAnchorName(liveInfo.getAnchorName());
                wechatLiveRoom.setRoomId(liveInfo.getRoomId());
                wechatLiveRoom.setLiveStatus(liveInfo.getLiveStatus());
                wechatLiveRoom.setType(liveInfo.getType());
                wechatLiveRoom.setCloseLike(liveInfo.getCloseLike());
                wechatLiveRoom.setCloseGoods(liveInfo.getCloseGoods());
                wechatLiveRoom.setCloseComment(liveInfo.getCloseComment());
                wechatLiveRoom.setCloseKf(liveInfo.getCloseKf());
                wechatLiveRoom.setCloseReplay(liveInfo.getCloseReplay());
                wechatLiveRoom.setIsFeedsPublic(liveInfo.getIsFeedsPublic());
                wechatLiveRoom.setCreaterOpenid(liveInfo.getCreaterOpenid());
                wechatLiveRoom.setFeedsImgWx(liveInfo.getFeedsImg());
                wechatLiveRoom.setShareImgWx(liveInfo.getShareImg());
                if (liveInfo.getGoods().size() > 0) {
                    wechatLiveRoom.setGoodsJson(JSON.toJSONString((Object)liveInfo.getGoods()));
                }
                if (wechatLiveRoom.getLiveStatus().equals(103) && (liveReplay = this.wxMaService.getLiveService().getLiveReplay(wechatLiveRoom.getRoomId(), Integer.valueOf(1), Integer.valueOf(99))).getLiveReplay().size() > 0) {
                    wechatLiveRoom.setLiveReplay(JSON.toJSONString((Object)liveReplay.getLiveReplay()));
                }
                wechatLiveRoomsList.add(wechatLiveRoom);
            }
            List idsForgetLocalLiveRoom = wechatLiveRoomsList.stream().map(WechatLiveRoom::getRoomId).collect(Collectors.toList());
            lambdaQueryWrapper.in(WechatLiveRoom::getRoomId, idsForgetLocalLiveRoom);
            List currentWechatLiveRoomsForUpdate = this.wechatLiveRoomDao.selectList((Wrapper)lambdaQueryWrapper);
            if (currentWechatLiveRoomsForUpdate.size() == 0) {
                throw new CrmebException("\u76f4\u64ad\u95f4 - \u672c\u5730\u5f85\u66f4\u65b0\u6570\u636e \u4e3a\u7a7a");
            }
            for (WechatLiveRoom wechatLiveRoom : wechatLiveRoomsList) {
                List currentLiveRoom = currentWechatLiveRoomsForUpdate.stream().filter(liveRoom -> liveRoom.getRoomId().equals(wechatLiveRoom.getRoomId())).collect(Collectors.toList());
                if (currentLiveRoom.size() > 0) {
                    WechatLiveRoom cuRoom = (WechatLiveRoom)currentLiveRoom.get(0);
                    wechatLiveRoom.setId(cuRoom.getId());
                    wechatLiveRoom.setGoods(cuRoom.getGoods());
                    continue;
                }
                logger.error("\u76f4\u64ad\u95f4 - \u672c\u5730\u672a\u627e\u5230roomId\u4e3a:{}\u7684\u6570\u636e", (Object)wechatLiveRoom.getRoomId());
            }
            boolean bl = this.updateBatchById(wechatLiveRoomsList);
        }
        catch (WxErrorException e) {
            e.printStackTrace();
        }
        return liveInfos;
    }

    @Override
    public Boolean showStore(Integer id, Integer show) {
        WechatLiveRoom wechatLiveRoom = new WechatLiveRoom();
        wechatLiveRoom.setId(id).setStoreShow(show);
        return this.wechatLiveRoomDao.updateById(wechatLiveRoom) > 0;
    }
}

