/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.constants.BillConstants;
import com.zbkj.common.constants.IntegralRecordConstants;
import com.zbkj.common.dto.IpLocation;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.bill.Bill;
import com.zbkj.common.model.bill.UserBill;
import com.zbkj.common.model.member.PaidMemberCard;
import com.zbkj.common.model.member.PaidMemberOrder;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.system.SystemUserLevel;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.model.user.UserIntegralRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.GiftPaidMemberRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.PasswordRequest;
import com.zbkj.common.request.RetailStorePeopleSearchRequest;
import com.zbkj.common.request.RetailStoreSubUserSearchRequest;
import com.zbkj.common.request.UserAssignTagRequest;
import com.zbkj.common.request.UserBindingPhoneUpdateRequest;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.request.UserEditInfoRequest;
import com.zbkj.common.request.UserOperateBalanceRequest;
import com.zbkj.common.request.UserOperateIntegralRequest;
import com.zbkj.common.request.UserSearchRequest;
import com.zbkj.common.request.UserUpdateRequest;
import com.zbkj.common.request.merchant.MerchantUserSearchRequest;
import com.zbkj.common.response.UserAdminDetailResponse;
import com.zbkj.common.response.UserInfoResponse;
import com.zbkj.common.response.UserLogoffBeforeResponse;
import com.zbkj.common.response.UserResponse;
import com.zbkj.common.response.UserSpreadPeopleItemResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.LoginResultCode;
import com.zbkj.common.result.MemberResultCode;
import com.zbkj.common.result.UserResultCode;
import com.zbkj.common.token.FrontTokenComponent;
import com.zbkj.common.utils.CommonUtil;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.IPUtil;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.LoginFrontUserVo;
import com.zbkj.service.dao.UserDao;
import com.zbkj.service.service.BillService;
import com.zbkj.service.service.CartService;
import com.zbkj.service.service.CommunityNotesRelationService;
import com.zbkj.service.service.CommunityNotesService;
import com.zbkj.service.service.MerchantEmployeeService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.PaidMemberCardService;
import com.zbkj.service.service.PaidMemberOrderService;
import com.zbkj.service.service.ProductRelationService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.SmsService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemUserLevelService;
import com.zbkj.service.service.UserBalanceRecordService;
import com.zbkj.service.service.UserBillService;
import com.zbkj.service.service.UserIntegralRecordService;
import com.zbkj.service.service.UserMerchantCollectService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class UserServiceImpl
extends ServiceImpl<UserDao, User>
implements UserService {
    private final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    @Resource
    private UserDao dao;
    @Autowired
    private FrontTokenComponent tokenComponent;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private UserIntegralRecordService userIntegralRecordService;
    @Autowired
    private UserBillService userBillService;
    @Autowired
    private BillService billService;
    @Autowired
    private UserBalanceRecordService userBalanceRecordService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private CartService cartService;
    @Autowired
    private ProductRelationService productRelationService;
    @Autowired
    private UserMerchantCollectService userMerchantCollectService;
    @Autowired
    private CommunityNotesService communityNotesService;
    @Autowired
    private CommunityNotesRelationService communityNotesRelationService;
    @Autowired
    private SystemUserLevelService systemUserLevelService;
    @Autowired
    private PaidMemberCardService paidMemberCardService;
    @Autowired
    private PaidMemberOrderService paidMemberOrderService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private MerchantEmployeeService merchantEmployeeService;
    @Autowired
    private CrmebConfig crmebConfig;

    @Override
    public User registerPhone(String phone, Integer spreadUid) {
        Boolean check;
        User user = new User();
        user.setAccount(phone);
        user.setPwd(CommonUtil.createPwd((String)phone));
        user.setPhone(phone);
        user.setRegisterType("h5");
        user.setNickname(CommonUtil.createNickName((String)phone));
        user.setAvatar(this.systemConfigService.getValueByKey("h5_avatar"));
        Date nowDate = CrmebDateUtil.nowDateTime();
        user.setCreateTime(nowDate);
        user.setLastLoginTime(nowDate);
        user.setLevel(Integer.valueOf(1));
        user.setSpreadUid(Integer.valueOf(0));
        if (spreadUid > 0 && (check = this.checkBingSpread(user, spreadUid, "new")).booleanValue()) {
            user.setSpreadUid(spreadUid);
            user.setSpreadTime(nowDate);
        }
        try {
            HttpServletRequest request = RequestUtil.getRequest();
            String clientIP = ServletUtil.getClientIP((HttpServletRequest)request, null);
            if (StrUtil.isBlank((CharSequence)clientIP)) {
                this.logger.error("\u83b7\u53d6\u7528\u6237ip\u5931\u8d25\uff0c\u7528\u6237phone = " + user.getPhone());
            } else {
                IpLocation ipLocation = IPUtil.getLocation((String)clientIP);
                if (ObjectUtil.isNotNull((Object)ipLocation.getCountry())) {
                    user.setCountry(ipLocation.getCountry().equals("\u4e2d\u56fd") ? "CN" : "OTHER");
                    user.setProvince(ipLocation.getProvince());
                    user.setCity(ipLocation.getCity());
                }
            }
        }
        catch (Exception e2) {
            this.logger.error("\u901a\u8fc7ip\u83b7\u53d6\u7528\u6237\u4f4d\u7f6e\u5931\u8d25\uff0c\u7528\u6237phone = {}", (Object)user.getPhone());
            this.logger.error("\u901a\u8fc7ip\u83b7\u53d6\u7528\u6237\u4f4d\u7f6e\u5931\u8d25", (Throwable)e2);
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.save(user);
            if (user.getSpreadUid() > 0) {
                this.updateSpreadCountByUid(spreadUid, "add");
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_REGISTER_FAILED);
        }
        return user;
    }

    @Override
    public User getByPhone(String phone) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(User::getPhone, (Object)phone);
        lqw.eq(User::getIsLogoff, (Object)0);
        lqw.last(" limit 1");
        return (User)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean checkBingSpread(User user, Integer spreadUid, String type) {
        String bindType;
        if (ObjectUtil.isNull((Object)spreadUid) || spreadUid <= 0) {
            return false;
        }
        if (ObjectUtil.isNull((Object)user)) {
            return false;
        }
        if (user.getSpreadUid() > 0) {
            return false;
        }
        if (ObjectUtil.isNotNull((Object)user.getId()) && user.getId().equals(spreadUid)) {
            return false;
        }
        String isOpen = this.systemConfigService.getValueByKey("retail_store_switch");
        if (StrUtil.isBlank((CharSequence)isOpen) || isOpen.equals("0")) {
            return false;
        }
        if (type.equals("old") && (StrUtil.isBlank((CharSequence)(bindType = this.systemConfigService.getValueByKey("retail_store_binding_type"))) || bindType.equals("1"))) {
            return false;
        }
        User spreadUser = (User)this.getById(spreadUid);
        if (ObjectUtil.isNull((Object)spreadUser) || !spreadUser.getStatus().booleanValue()) {
            return false;
        }
        if (!spreadUser.getIsPromoter().booleanValue()) {
            return false;
        }
        return !ObjectUtil.isNotNull((Object)user.getId()) || !user.getId().equals(spreadUser.getSpreadUid());
    }

    @Override
    public Boolean updateSpreadCountByUid(Integer uid, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("add")) {
            updateWrapper.setSql("spread_count = spread_count + 1");
        } else {
            updateWrapper.setSql("spread_count = spread_count - 1");
        }
        updateWrapper.eq((Object)"id", (Object)uid);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Boolean password(PasswordRequest request) {
        User user = this.getInfo();
        this.smsService.checkValidateCode("update:password", user.getPhone(), request.getValidateCode());
        user.setPwd(CrmebUtil.encryptPassword((String)request.getPassword(), (String)user.getPhone()));
        user.setUpdateTime((Date)DateUtil.date());
        return this.updateById(user);
    }

    @Override
    public Integer getUserIdException() {
        Integer id = this.tokenComponent.getUserId();
        if (null == id) {
            throw new CrmebException((IResultEnum)LoginResultCode.LOGIN_EXPIRE);
        }
        return id;
    }

    @Override
    public Integer getUserId() {
        Integer id = this.tokenComponent.getUserId();
        if (null == id) {
            return 0;
        }
        return id;
    }

    @Override
    public User getInfo() {
        Integer userId = this.getUserIdException();
        User user = (User)this.getById(userId);
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException((IResultEnum)LoginResultCode.LOGIN_EXPIRE);
        }
        if (user.getIsLogoff().booleanValue()) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_LOGOFF);
        }
        return user;
    }

    @Override
    public UserInfoResponse getUserInfo() {
        User currentUser = this.getInfo();
        UserInfoResponse userInfoResponse = new UserInfoResponse();
        BeanUtils.copyProperties((Object)currentUser, (Object)userInfoResponse);
        userInfoResponse.setPhone(CrmebUtil.maskMobile((String)userInfoResponse.getPhone()));
        return userInfoResponse;
    }

    @Override
    public LoginFrontUserVo getEmployeeInfo() {
        LoginFrontUserVo userForMerchantEmployee = this.tokenComponent.getUserForMerchantEmployee();
        Integer activeMerchantId = userForMerchantEmployee.getActiveMerchant();
        List currentMerchantConfig = userForMerchantEmployee.getMerchantEmployeeList().stream().filter(p -> Objects.equals(p.getMerId(), activeMerchantId)).collect(Collectors.toList());
        if (currentMerchantConfig.size() > 1) {
            throw new CrmebException("\u79fb\u52a8\u7aef\u7ba1\u7406\u5458\u5546\u6237\u914d\u7f6e\u6570\u636e\u4e0d\u6b63\u786e");
        }
        return userForMerchantEmployee;
    }

    @Override
    public Boolean editUser(UserEditInfoRequest request) {
        User user = this.getInfo();
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(User::getNickname, (Object)request.getNickname());
        wrapper.set(User::getAvatar, (Object)this.systemAttachmentService.clearPrefix(request.getAvatar()));
        wrapper.set(User::getProvince, (Object)request.getProvince());
        wrapper.set(User::getCity, (Object)request.getCity());
        wrapper.set(User::getSex, (Object)request.getSex());
        wrapper.set(User::getBirthday, (Object)request.getBirthday());
        wrapper.eq(User::getId, (Object)user.getId());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean getCurrentPhoneCode() {
        User user = this.getInfo();
        return this.smsService.sendCommonCode(user.getPhone(), "update:binding:current");
    }

    @Override
    public Boolean updatePhoneCode(UserBindingPhoneUpdateRequest request) {
        User user = this.getInfo();
        this.smsService.checkValidateCode("update:binding:current", user.getPhone(), request.getCaptcha());
        User tempUser = this.getByPhone(request.getPhone());
        if (ObjectUtil.isNotNull((Object)tempUser)) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_PHONE_EXIST);
        }
        return this.smsService.sendCommonCode(request.getPhone(), "update:binding:new");
    }

    @Override
    public Boolean updatePhone(UserBindingPhoneUpdateRequest request) {
        this.smsService.checkValidateCode("update:binding:new", request.getPhone(), request.getCaptcha());
        User tempUser = this.getByPhone(request.getPhone());
        if (ObjectUtil.isNotNull((Object)tempUser)) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_PHONE_EXIST);
        }
        User user = this.getInfo();
        String password = "";
        try {
            password = CrmebUtil.decryptPassowrd((String)user.getPwd(), (String)user.getPhone());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(User::getPhone, (Object)request.getPhone());
        wrapper.set(User::getAccount, (Object)request.getPhone());
        wrapper.set(User::getPwd, (Object)CrmebUtil.encryptPassword((String)password, (String)request.getPhone()));
        wrapper.eq(User::getId, (Object)user.getId());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<UserResponse> getPlatformPage(UserSearchRequest request) {
        DateLimitUtilVo dateLimit;
        Page pageUser = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getTagIds())) {
            String tagIdSql = CrmebUtil.getFindInSetSql((String)"u.tag_id", (String)request.getTagIds());
            map.put("tagIdSql", tagIdSql);
        }
        if (ObjectUtil.isNotNull((Object)request.getSex())) {
            map.put("sex", request.getSex());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRegisterType())) {
            map.put("registerType", request.getRegisterType());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getPayCount())) {
            map.put("payCount", Integer.valueOf(request.getPayCount()));
        }
        if (ObjectUtil.isNotNull((Object)request.getIdentity())) {
            if (request.getIdentity().equals(1)) {
                map.put("isPromoter", 1);
            }
            if (request.getIdentity().equals(3)) {
                map.put("isPaidMember", 1);
            }
        }
        if (ObjectUtil.isNotNull((Object)request.getIsLogoff())) {
            map.put("isLogoff", request.getIsLogoff());
        }
        if (StrUtil.isNotBlank((CharSequence)(dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit())).getStartTime())) {
            map.put("startTime", dateLimit.getStartTime());
            map.put("endTime", dateLimit.getEndTime());
            map.put("accessType", request.getAccessType());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        List<User> userList = this.dao.findAdminList(map);
        ArrayList<UserResponse> userResponses = new ArrayList<UserResponse>();
        if (CollUtil.isEmpty(userList)) {
            return CommonPage.copyPageInfo((Page)pageUser, userResponses);
        }
        List<Integer> spreadUidList = userList.stream().filter(e -> e.getSpreadUid() > 0).map(User::getSpreadUid).distinct().collect(Collectors.toList());
        Map<Object, Object> userMap = CollUtil.newHashMap();
        if (CollUtil.isNotEmpty(spreadUidList)) {
            userMap = this.getUidMapList(spreadUidList);
        }
        for (User user : userList) {
            UserResponse userResponse = new UserResponse();
            BeanUtils.copyProperties((Object)user, (Object)userResponse);
            if (StrUtil.isNotEmpty((CharSequence)userResponse.getPhone()) && this.crmebConfig.getPhoneMaskSwitch().booleanValue()) {
                userResponse.setPhone(CrmebUtil.maskMobile((String)userResponse.getPhone()));
            }
            if (user.getSpreadUid() > 0) {
                userResponse.setSpreadName(((User)userMap.get(user.getSpreadUid())).getNickname());
            }
            userResponses.add(userResponse);
        }
        return CommonPage.copyPageInfo((Page)pageUser, userResponses);
    }

    @Override
    public PageInfo<UserResponse> getMerchantPage(MerchantUserSearchRequest request) {
        DateLimitUtilVo dateLimit;
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        Page pageUser = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        map.put("merId", systemAdmin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRegisterType())) {
            map.put("registerType", request.getRegisterType());
        }
        if (ObjectUtil.isNotNull((Object)request.getSex())) {
            map.put("sex", request.getSex());
        }
        if (StrUtil.isNotBlank((CharSequence)(dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit())).getStartTime())) {
            map.put("startTime", dateLimit.getStartTime());
            map.put("endTime", dateLimit.getEndTime());
        }
        List<Object> userList = new ArrayList();
        userList = StrUtil.isNotBlank((CharSequence)request.getUserType()) && request.getUserType().equals("all") ? this.dao.findUserAllList(map) : this.dao.findMerchantList(map);
        ArrayList<UserResponse> userResponses = new ArrayList<UserResponse>();
        for (User user : userList) {
            UserResponse userResponse = new UserResponse();
            BeanUtils.copyProperties((Object)user, (Object)userResponse);
            if (this.crmebConfig.getPhoneMaskSwitch().booleanValue()) {
                userResponse.setPhone(CrmebUtil.maskMobile((String)userResponse.getPhone()));
            }
            userResponses.add(userResponse);
        }
        return CommonPage.copyPageInfo((Page)pageUser, userResponses);
    }

    @Override
    public Boolean updateUser(UserUpdateRequest userRequest) {
        User tempUser = (User)this.getById(userRequest.getId());
        if (ObjectUtil.isNull((Object)tempUser)) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_NOT_EXIST);
        }
        if (tempUser.getIsLogoff().booleanValue()) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_LOGOFF);
        }
        Boolean userStatus = tempUser.getStatus();
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        if (StrUtil.isNotBlank((CharSequence)userRequest.getTagId())) {
            wrapper.set(User::getTagId, (Object)userRequest.getTagId());
        } else {
            wrapper.set(User::getTagId, (Object)"");
        }
        if (StrUtil.isNotBlank((CharSequence)userRequest.getBirthday())) {
            wrapper.set(User::getBirthday, (Object)userRequest.getBirthday());
        }
        if (StrUtil.isNotBlank((CharSequence)userRequest.getProvince())) {
            wrapper.set(User::getProvince, (Object)userRequest.getProvince());
        }
        if (StrUtil.isNotBlank((CharSequence)userRequest.getCity())) {
            wrapper.set(User::getCity, (Object)userRequest.getCity());
        }
        if (StrUtil.isNotBlank((CharSequence)userRequest.getMark())) {
            wrapper.set(User::getMark, (Object)userRequest.getMark());
        }
        if (ObjectUtil.isNotNull((Object)userRequest.getStatus())) {
            wrapper.set(User::getStatus, (Object)userRequest.getStatus());
        }
        if (ObjectUtil.isNotNull((Object)userRequest.getIsPromoter())) {
            wrapper.set(User::getIsPromoter, (Object)userRequest.getIsPromoter());
            if (userRequest.getIsPromoter().booleanValue() && !tempUser.getIsPromoter().booleanValue()) {
                wrapper.set(User::getPromoterTime, (Object)DateUtil.date());
            }
        }
        wrapper.eq(User::getId, (Object)tempUser.getId());
        boolean update = this.update((Wrapper)wrapper);
        if (update && userStatus.booleanValue() && !userRequest.getStatus().booleanValue()) {
            this.cleanUserAllToken(tempUser.getId());
        }
        return update;
    }

    @Override
    public Boolean isUsedTag(Integer tagId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{User::getId});
        lqw.apply("find_in_set({0}, tag_id)", new Object[]{tagId});
        lqw.last(" limit 1");
        User user = (User)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)user);
    }

    @Override
    public Boolean tag(UserAssignTagRequest request) {
        List<Integer> idList = CrmebUtil.stringToArray((String)request.getIds());
        idList = idList.stream().distinct().collect(Collectors.toList());
        List<User> userList = this.findByIdList(idList);
        List tagIdList = CrmebUtil.stringToArray((String)request.getTagIds());
        return (Boolean)this.transactionTemplate.execute(e -> {
            for (User user : userList) {
                if (StrUtil.isBlank((CharSequence)user.getTagId())) {
                    user.setTagId(request.getTagIds());
                } else {
                    List userTagList = CrmebUtil.stringToArray((String)user.getTagId());
                    userTagList.addAll(tagIdList);
                    String tagStr = userTagList.stream().distinct().map(String::valueOf).collect(Collectors.joining(","));
                    user.setTagId(tagStr);
                }
                LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
                wrapper.set(User::getTagId, (Object)user.getTagId());
                wrapper.eq(User::getId, (Object)user.getId());
                this.update((Wrapper)wrapper);
            }
            return Boolean.TRUE;
        });
    }

    private List<User> findByIdList(List<Integer> idList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(User::getId, idList);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean removeLevelByLevelId(Integer levelId) {
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(User::getLevel, (Object)1);
        luw.eq(User::getLevel, (Object)levelId);
        return this.update((Wrapper)luw);
    }

    @Override
    public Map<Integer, User> getUidMapList(List<Integer> uidList) {
        HashMap<Integer, User> userMap = new HashMap<Integer, User>();
        if (CollUtil.isEmpty(uidList)) {
            return userMap;
        }
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{User::getId, User::getNickname, User::getPhone, User::getAvatar, User::getIsLogoff, User::getLevel});
        lqw.in(User::getId, uidList);
        List userList = this.dao.selectList((Wrapper)lqw);
        userList.forEach(user -> userMap.put(user.getId(), (User)user));
        return userMap;
    }

    @Override
    public Boolean updateNowMoney(Integer uid, BigDecimal price, String type) {
        UpdateWrapper wrapper = Wrappers.update();
        if (type.equals("add")) {
            wrapper.setSql(StrUtil.format((CharSequence)"now_money = now_money + {}", (Object[])new Object[]{price}));
        } else {
            wrapper.setSql(StrUtil.format((CharSequence)"now_money = now_money - {}", (Object[])new Object[]{price}));
        }
        wrapper.eq((Object)"id", (Object)uid);
        if (type.equals("sub")) {
            wrapper.apply(StrUtil.format((CharSequence)" now_money - {} >= 0", (Object[])new Object[]{price}), new Object[0]);
        }
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean updateIntegral(Integer uid, Integer integral, String type) {
        UpdateWrapper wrapper = Wrappers.update();
        if (type.equals("add")) {
            wrapper.setSql(StrUtil.format((CharSequence)"integral = integral + {}", (Object[])new Object[]{integral}));
        } else {
            wrapper.setSql(StrUtil.format((CharSequence)"integral = integral - {}", (Object[])new Object[]{integral}));
        }
        wrapper.eq((Object)"id", (Object)uid);
        if (type.equals("sub")) {
            wrapper.apply(StrUtil.format((CharSequence)" integral - {} >= 0", (Object[])new Object[]{integral}), new Object[0]);
        }
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean updateBrokerage(Integer uid, BigDecimal price, String type) {
        UpdateWrapper wrapper = Wrappers.update();
        if (type.equals("add")) {
            wrapper.setSql(StrUtil.format((CharSequence)"brokerage_price = brokerage_price + {}", (Object[])new Object[]{price}));
        } else {
            wrapper.setSql(StrUtil.format((CharSequence)"brokerage_price = brokerage_price - {}", (Object[])new Object[]{price}));
        }
        wrapper.eq((Object)"id", (Object)uid);
        if (type.equals("sub")) {
            wrapper.apply(StrUtil.format((CharSequence)" brokerage_price - {} >= 0", (Object[])new Object[]{price}), new Object[0]);
        }
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean updateExperience(Integer uid, Integer experience, String type) {
        UpdateWrapper wrapper = Wrappers.update();
        if (type.equals("add")) {
            wrapper.setSql(StrUtil.format((CharSequence)"experience = experience + {}", (Object[])new Object[]{experience}));
        } else {
            wrapper.setSql(StrUtil.format((CharSequence)"experience = experience - {}", (Object[])new Object[]{experience}));
        }
        wrapper.eq((Object)"id", (Object)uid);
        if (type.equals("sub")) {
            wrapper.apply(StrUtil.format((CharSequence)" experience - {} >= 0", (Object[])new Object[]{experience}), new Object[0]);
        }
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean brokerageToYue(Integer uid, BigDecimal price) {
        UpdateWrapper wrapper = Wrappers.update();
        wrapper.setSql(StrUtil.format((CharSequence)"now_money = now_money + {}", (Object[])new Object[]{price}));
        wrapper.setSql(StrUtil.format((CharSequence)"brokerage_price = brokerage_price - {}", (Object[])new Object[]{price}));
        wrapper.eq((Object)"id", (Object)uid);
        wrapper.apply(StrUtil.format((CharSequence)" brokerage_price - {} >= 0", (Object[])new Object[]{price}), new Object[0]);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean operateUserInteger(UserOperateIntegralRequest request) {
        User user = (User)this.getById(request.getUid());
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_NOT_EXIST);
        }
        if (user.getIsLogoff().booleanValue()) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_LOGOFF);
        }
        if (request.getOperateType().equals("sub") && user.getIntegral() - request.getIntegral() < 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u79ef\u5206\u6263\u51cf\u540e\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (request.getOperateType().equals("add") && user.getIntegral() + request.getIntegral() > 99999999) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u79ef\u5206\u6dfb\u52a0\u540e\u4e0d\u80fd\u5927\u4e8e99999999");
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            UserIntegralRecord integralRecord = new UserIntegralRecord();
            integralRecord.setUid(user.getId());
            integralRecord.setLinkType("system");
            integralRecord.setTitle("\u540e\u53f0\u79ef\u5206\u64cd\u4f5c");
            integralRecord.setIntegral(request.getIntegral());
            integralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
            if (request.getOperateType().equals("add")) {
                integralRecord.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
                integralRecord.setBalance(Integer.valueOf(user.getIntegral() + request.getIntegral()));
                integralRecord.setMark(StrUtil.format((CharSequence)"\u540e\u53f0\u64cd\u4f5c\u589e\u52a0\u4e86{}\u79ef\u5206", (Object[])new Object[]{request.getIntegral()}));
                this.updateIntegral(user.getId(), request.getIntegral(), "add");
            } else {
                integralRecord.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_SUB);
                integralRecord.setBalance(Integer.valueOf(user.getIntegral() - request.getIntegral()));
                integralRecord.setMark(StrUtil.format((CharSequence)"\u540e\u53f0\u64cd\u4f5c\u51cf\u5c11\u4e86{}\u79ef\u5206", (Object[])new Object[]{request.getIntegral()}));
                this.updateIntegral(user.getId(), request.getIntegral(), "sub");
            }
            this.userIntegralRecordService.save(integralRecord);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean operateUserBalance(UserOperateBalanceRequest request) {
        User user = (User)this.getById(request.getUid());
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_NOT_EXIST);
        }
        if (user.getIsLogoff().booleanValue()) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_LOGOFF);
        }
        if (request.getOperateType().equals("sub") && user.getNowMoney().subtract(request.getMoney()).compareTo(BigDecimal.ZERO) < 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4f59\u989d\u6263\u51cf\u540e\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (request.getOperateType().equals("add") && user.getNowMoney().add(request.getMoney()).compareTo(new BigDecimal("99999999.99")) > 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4f59\u989d\u6dfb\u52a0\u540e\u540e\u4e0d\u80fd\u5927\u4e8e99999999.99");
        }
        UserBill userBill = new UserBill();
        userBill.setUid(user.getId());
        userBill.setLinkId("0");
        userBill.setTitle("\u540e\u53f0\u64cd\u4f5c");
        userBill.setCategory("system");
        userBill.setNumber(request.getMoney());
        userBill.setStatus(Integer.valueOf(1));
        userBill.setCreateTime(CrmebDateUtil.nowDateTime());
        Bill bill = new Bill();
        bill.setUid(user.getId());
        bill.setAmount(request.getMoney());
        bill.setType("system");
        UserBalanceRecord balanceRecord = new UserBalanceRecord();
        balanceRecord.setUid(user.getId());
        balanceRecord.setAmount(request.getMoney());
        balanceRecord.setLinkId("0");
        balanceRecord.setLinkType("system");
        return (Boolean)this.transactionTemplate.execute(e -> {
            if (request.getOperateType().equals("add")) {
                userBill.setPm(Integer.valueOf(1));
                userBill.setType("system_add");
                userBill.setBalance(user.getNowMoney().add(request.getMoney()));
                userBill.setMark(StrUtil.format((CharSequence)"\u540e\u53f0\u64cd\u4f5c\u589e\u52a0\u4e86{}\u4f59\u989d", (Object[])new Object[]{request.getMoney()}));
                bill.setPm(BillConstants.BILL_PM_SUB);
                bill.setMark(StrUtil.format((CharSequence)"\u540e\u53f0\u64cd\u4f5c\u7ed9\u7528\u6237\u589e\u52a0\u4f59\u989d{}\u5143", (Object[])new Object[]{request.getMoney()}));
                balanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
                balanceRecord.setBalance(user.getNowMoney().add(request.getMoney()));
                balanceRecord.setRemark(StrUtil.format((CharSequence)"\u540e\u53f0\u64cd\u4f5c,\u6dfb\u52a0\u4f59\u989d{}\u5143", (Object[])new Object[]{request.getMoney().setScale(2).toString()}));
                this.updateNowMoney(user.getId(), request.getMoney(), "add");
            } else {
                userBill.setPm(Integer.valueOf(0));
                userBill.setType("system_sub");
                userBill.setBalance(user.getNowMoney().subtract(request.getMoney()));
                userBill.setMark(StrUtil.format((CharSequence)"\u540e\u53f0\u64cd\u4f5c\u51cf\u5c11\u4e86{}\u4f59\u989d", (Object[])new Object[]{request.getMoney()}));
                bill.setPm(BillConstants.BILL_PM_ADD);
                bill.setMark(StrUtil.format((CharSequence)"\u540e\u53f0\u64cd\u4f5c\u7ed9\u7528\u6237\u6263\u51cf\u4f59\u989d{}\u5143", (Object[])new Object[]{request.getMoney()}));
                balanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
                balanceRecord.setBalance(user.getNowMoney().subtract(request.getMoney()));
                balanceRecord.setRemark(StrUtil.format((CharSequence)"\u540e\u53f0\u64cd\u4f5c,\u51cf\u5c11\u4f59\u989d{}\u5143", (Object[])new Object[]{request.getMoney().setScale(2).toString()}));
                this.updateNowMoney(user.getId(), request.getMoney(), "sub");
            }
            this.billService.save(bill);
            this.userBillService.save(userBill);
            this.userBalanceRecordService.save(balanceRecord);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean paySuccessChange(Integer id, Boolean isPromoter) {
        UpdateWrapper wrapper = Wrappers.update();
        wrapper.setSql("pay_count = pay_count + 1");
        if (isPromoter.booleanValue()) {
            wrapper.set((Object)"is_promoter", (Object)1);
            wrapper.set((Object)"promoter_time", (Object)DateUtil.date());
        }
        wrapper.eq((Object)"id", (Object)id);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<Integer> getSpreadPeopleIdList(List<Integer> userIdList) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.select(new SFunction[]{User::getId});
        lambdaQueryWrapper.in(User::getSpreadUid, userIdList);
        List list = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        if (null == list || list.size() < 1) {
            return new ArrayList<Integer>();
        }
        return list.stream().map(User::getId).distinct().collect(Collectors.toList());
    }

    @Override
    public List<UserSpreadPeopleItemResponse> getSpreadPeopleList(Integer userId, List<Integer> spreadUserIdList, String keywords, String sortKey, String isAsc, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uid", userId);
        map.put("userIdList", spreadUserIdList.stream().distinct().map(String::valueOf).collect(Collectors.joining(",")));
        if (StrUtil.isNotBlank((CharSequence)keywords)) {
            keywords = URLUtil.decode((String)keywords);
            map.put("keywords", "%" + keywords + "%");
        }
        map.put("sortKey", "create_time");
        if (StrUtil.isNotBlank((CharSequence)sortKey)) {
            map.put("sortKey", sortKey);
        }
        map.put("sortValue", "desc");
        if (isAsc.equalsIgnoreCase("asc")) {
            map.put("sortValue", "asc");
        }
        return this.dao.getSpreadPeopleList(map);
    }

    @Override
    public List<User> getSpreadPeopleTopByDate(String type) {
        QueryWrapper queryWrapper = Wrappers.query();
        ((QueryWrapper)queryWrapper.select(new String[]{"count(id) as spread_count, spread_uid"}).gt((Object)"spread_uid", (Object)0)).eq((Object)"status", (Object)true);
        if (StrUtil.isNotBlank((CharSequence)type)) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)type);
            queryWrapper.between((Object)"spread_time", (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        ((QueryWrapper)queryWrapper.groupBy((Object)"spread_uid")).orderByDesc((Object)"spread_count");
        queryWrapper.last(" limit 50");
        List spreadVoList = this.dao.selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)spreadVoList)) {
            return spreadVoList;
        }
        List<Integer> spreadIdList = spreadVoList.stream().map(User::getSpreadUid).collect(Collectors.toList());
        Map<Integer, User> userMap = this.getUidMapList(spreadIdList);
        for (User spreadVo : spreadVoList) {
            User user = userMap.get(spreadVo.getSpreadUid());
            spreadVo.setId(spreadVo.getSpreadUid());
            spreadVo.setAvatar(user.getAvatar());
            spreadVo.setNickname(user.getNickname());
        }
        return spreadVoList;
    }

    @Override
    public void bindSpread(Integer spreadUid) {
        if (ObjectUtil.isNull((Object)spreadUid) || spreadUid <= 0) {
            return;
        }
        User user = this.getInfo();
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException((IResultEnum)LoginResultCode.LOGIN_EXPIRE);
        }
        Boolean checkBingSpread = this.checkBingSpread(user, spreadUid, "old");
        if (!checkBingSpread.booleanValue()) {
            return;
        }
        user.setSpreadUid(spreadUid);
        user.setSpreadTime(CrmebDateUtil.nowDateTime());
        user.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(user);
            this.updateSpreadCountByUid(spreadUid, "add");
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            this.logger.error(StrUtil.format((CharSequence)"\u7ed1\u5b9a\u63a8\u5e7f\u4eba\u65f6\u51fa\u9519\uff0cuserUid = {}, spreadUid = {}", (Object[])new Object[]{user.getId(), spreadUid}));
        }
    }

    @Override
    public Integer getTotalNum() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{User::getId});
        lqw.eq(User::getIsLogoff, (Object)false);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getRegisterNumByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public List<User> getChannelData() {
        QueryWrapper wrapper = Wrappers.query();
        wrapper.select(new String[]{"register_type", "count(id) as pay_count"});
        wrapper.eq((Object)"is_logoff", (Object)0);
        wrapper.groupBy((Object)"register_type");
        return this.dao.selectList((Wrapper)wrapper);
    }

    @Override
    public Boolean updateSpreadByUid(Integer userId, Integer spreadUid) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(User::getSpreadUid, (Object)spreadUid);
        wrapper.set(User::getSpreadTime, (Object)DateUtil.date());
        wrapper.eq(User::getId, (Object)userId);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<User> getRetailStorePeoplePage(RetailStorePeopleSearchRequest request) {
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        Page pageUser = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<User> userList = this.dao.findRetailStorePeopleList(map);
        return CommonPage.copyPageInfo((Page)pageUser, userList);
    }

    @Override
    public PageInfo<User> getRetailStoreSubUserList(RetailStoreSubUserSearchRequest request, PageParamRequest pageRequest) {
        if (request.getType().equals(1)) {
            return this.getFirstSpreadUserListPage(request, pageRequest);
        }
        if (request.getType().equals(2)) {
            return this.getSecondSpreadUserListPage(request, pageRequest);
        }
        return this.getAllSpreadUserListPage(request, pageRequest);
    }

    @Override
    public Boolean updateSignNumByUid(Integer day, Integer id) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(User::getSignNum, (Object)day);
        wrapper.eq(User::getId, (Object)id);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public UserLogoffBeforeResponse logoffBefore() {
        User user = this.getInfo();
        if (user.getIsLogoff().booleanValue()) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_LOGOFF);
        }
        UserLogoffBeforeResponse response = new UserLogoffBeforeResponse();
        response.setIsTip(Boolean.valueOf(true));
        if (user.getIntegral() > 0 || user.getNowMoney().compareTo(BigDecimal.ZERO) > 0 || user.getBrokeragePrice().compareTo(BigDecimal.ZERO) > 0) {
            return response;
        }
        if (this.orderService.isExistPendingOrderByUid(user.getId()).booleanValue()) {
            return response;
        }
        if (this.refundOrderService.getRefundingCount(user.getId()) > 0) {
            return response;
        }
        response.setIsTip(Boolean.valueOf(false));
        return response;
    }

    @Override
    public Boolean logoff() {
        Integer userId = this.getUserIdException();
        User user = (User)this.getById(userId);
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException((IResultEnum)LoginResultCode.LOGIN_EXPIRE);
        }
        if (user.getIsLogoff().booleanValue()) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_LOGOFF);
        }
        user.setIsLogoff(Boolean.valueOf(true));
        user.setLogoffTime((Date)DateUtil.date());
        user.setTagId("");
        user.setIsPromoter(Boolean.valueOf(false));
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.userTokenService.deleteByUid(user.getId());
            this.cartService.deleteByUid(user.getId());
            this.productRelationService.deleteByUid(user.getId());
            this.userMerchantCollectService.deleteByUid(user.getId());
            if (user.getSpreadUid() > 0) {
                this.updateSpreadCountByUid(user.getSpreadUid(), "sub");
                user.setSpreadUid(Integer.valueOf(0));
            }
            if (user.getSpreadCount() > 0) {
                this.batchRemoveSpreadUid(user.getId());
                user.setSpreadCount(Integer.valueOf(0));
            }
            this.communityNotesService.deleteByUid(user.getId());
            this.communityNotesRelationService.deleteByAuthorId(user.getId());
            user.setUpdateTime((Date)DateUtil.date());
            boolean update = this.updateById(user);
            if (!update) {
                this.logger.error("\u66f4\u65b0\u7528\u6237\u6ce8\u9500\u72b6\u6001\u5931\u8d25\uff0c\u7528\u6237id\uff1a {}", (Object)user.getId());
                e.setRollbackOnly();
                return update;
            }
            this.merchantEmployeeService.deleteByUserId(user.getId());
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_LOGOFF_FAILED);
        }
        this.cleanUserAllToken(user.getId());
        return execute;
    }

    private void cleanUserAllToken(Integer userId) {
        this.tokenComponent.cleanUserToken(userId);
        this.tokenComponent.cleanMerchantUserToken(userId);
    }

    @Override
    public UserAdminDetailResponse getAdminDetail(Integer id) {
        SystemUserLevel systemUserLevel;
        User user = (User)this.getById(id);
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_NOT_EXIST);
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (admin.getMerId() > 0 && !this.userMerchantCollectService.isCollect(user.getId(), admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_NOT_COLLECT_MERCHANT);
        }
        UserAdminDetailResponse response = new UserAdminDetailResponse();
        BeanUtils.copyProperties((Object)user, (Object)response);
        if (user.getSpreadUid() > 0) {
            User spreadUser = (User)this.getById(user.getSpreadUid());
            response.setSpreadName(spreadUser.getNickname());
        }
        if (this.crmebConfig.getPhoneMaskSwitch().booleanValue()) {
            if (StrUtil.isNotBlank((CharSequence)user.getPhone())) {
                response.setPhone(CrmebUtil.maskMobile((String)user.getPhone()));
            }
            if (StrUtil.isNotBlank((CharSequence)user.getAccount())) {
                response.setAccount(CrmebUtil.maskMobile((String)user.getAccount()));
            }
        }
        response.setGrade(Integer.valueOf(ObjectUtil.isNotNull((Object)(systemUserLevel = this.systemUserLevelService.getByLevelId(user.getLevel()))) ? systemUserLevel.getGrade() : 0));
        return response;
    }

    @Override
    public Boolean updateUserLevel(Integer userId, Integer level) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(User::getLevel, (Object)level);
        wrapper.eq(User::getId, (Object)userId);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<User> findByBirthday(String birthday) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{User::getId, User::getPhone});
        lqw.eq(User::getIsLogoff, (Object)0);
        lqw.eq(User::getStatus, (Object)1);
        lqw.apply("date_format(birthday, '%m-%d') = {0}", new Object[]{birthday});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean getUpdatePasswordPhoneCode() {
        User user = this.getInfo();
        return this.smsService.sendCommonCode(user.getPhone(), "update:password");
    }

    @Override
    public SystemAdmin getSystemAdminByMerchantEmployee() {
        SystemAdmin systemAdmin = new SystemAdmin();
        LoginFrontUserVo employeeInfo = this.getEmployeeInfo();
        Merchant merchant = this.merchantService.getByIdException(employeeInfo.getActiveMerchant());
        systemAdmin.setId(employeeInfo.getUserId());
        systemAdmin.setMerId(merchant.getId());
        systemAdmin.setType(Integer.valueOf(-4));
        return systemAdmin;
    }

    private Boolean batchRemoveSpreadUid(Integer spreadUid) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(User::getSpreadUid, (Object)0);
        wrapper.eq(User::getSpreadUid, (Object)spreadUid);
        return this.update((Wrapper)wrapper);
    }

    private PageInfo<User> getAllSpreadUserListPage(RetailStoreSubUserSearchRequest request, PageParamRequest pageRequest) {
        List<User> firstUserList = this.getSpreadListBySpreadIdAndType(request.getUid(), 0);
        if (CollUtil.isEmpty(firstUserList)) {
            return new PageInfo((List)CollUtil.newArrayList((Object[])new User[0]));
        }
        List userIds = firstUserList.stream().map(User::getId).distinct().collect(Collectors.toList());
        Page userPage = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{User::getId, User::getAvatar, User::getNickname, User::getIsPromoter, User::getSpreadCount, User::getPayCount});
        queryWrapper.in(User::getId, userIds);
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String decode = URLUtil.decode((String)request.getKeywords());
            queryWrapper.and(e -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.like(User::getNickname, (Object)decode)).or()).eq(User::getId, (Object)decode)).or()).eq(User::getPhone, (Object)decode);
            });
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            queryWrapper.between(User::getSpreadTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        List userList = this.dao.selectList((Wrapper)queryWrapper);
        return CommonPage.copyPageInfo((Page)userPage, (List)userList);
    }

    private PageInfo<User> getSecondSpreadUserListPage(RetailStoreSubUserSearchRequest request, PageParamRequest pageRequest) {
        List<User> firstUserList = this.getSpreadListBySpreadIdAndType(request.getUid(), 1);
        if (CollUtil.isEmpty(firstUserList)) {
            return new PageInfo((List)CollUtil.newArrayList((Object[])new User[0]));
        }
        List userIds = firstUserList.stream().map(User::getId).distinct().collect(Collectors.toList());
        Page userPage = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{User::getId, User::getAvatar, User::getNickname, User::getIsPromoter, User::getSpreadCount, User::getPayCount});
        queryWrapper.in(User::getSpreadUid, userIds);
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String decode = URLUtil.decode((String)request.getKeywords());
            queryWrapper.and(e -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.like(User::getNickname, (Object)decode)).or()).eq(User::getId, (Object)decode)).or()).eq(User::getPhone, (Object)decode);
            });
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            queryWrapper.between(User::getSpreadTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        List userList = this.dao.selectList((Wrapper)queryWrapper);
        return CommonPage.copyPageInfo((Page)userPage, (List)userList);
    }

    private List<User> getSpreadListBySpreadIdAndType(Integer spreadUid, Integer type) {
        List<User> userList = this.getSpreadListBySpreadId(spreadUid);
        if (CollUtil.isEmpty(userList)) {
            return userList;
        }
        if (type.equals(1)) {
            return userList;
        }
        ArrayList userSecondList = CollUtil.newArrayList((Object[])new User[0]);
        userList.forEach(user -> {
            List<User> childUserList = this.getSpreadListBySpreadId(user.getId());
            if (CollUtil.isNotEmpty(childUserList)) {
                userSecondList.addAll(childUserList);
            }
        });
        if (type.equals(2)) {
            return userSecondList;
        }
        userList.addAll(userSecondList);
        return userList;
    }

    private List<User> getSpreadListBySpreadId(Integer spreadUid) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(User::getSpreadUid, (Object)spreadUid);
        return this.dao.selectList((Wrapper)queryWrapper);
    }

    private PageInfo<User> getFirstSpreadUserListPage(RetailStoreSubUserSearchRequest request, PageParamRequest pageRequest) {
        Page userPage = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{User::getId, User::getAvatar, User::getNickname, User::getIsPromoter, User::getSpreadCount, User::getPayCount});
        lqw.eq(User::getSpreadUid, (Object)request.getUid());
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String decode = URLUtil.decode((String)request.getKeywords());
            lqw.and(e -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.like(User::getNickname, (Object)decode)).or()).eq(User::getId, (Object)decode)).or()).eq(User::getPhone, (Object)decode);
            });
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            lqw.between(User::getSpreadTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        List userList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)userPage, (List)userList);
    }

    @Override
    public Boolean giftPaidMember(GiftPaidMemberRequest request) {
        List uidList = CrmebUtil.stringToArray((String)request.getIds());
        PaidMemberCard paidMemberCard = this.paidMemberCardService.getByIdException(request.getCardId());
        if (!paidMemberCard.getStatus().booleanValue()) {
            throw new CrmebException((IResultEnum)MemberResultCode.PAID_MEMBER_CARD_CLOSE);
        }
        if (!paidMemberCard.getType().equals(1)) {
            throw new CrmebException((IResultEnum)MemberResultCode.PAID_MEMBER_CARD_RESELECT);
        }
        List<User> userList = this.findByIdList(uidList);
        int i = 0;
        while (i < userList.size()) {
            User user = userList.get(i);
            if (user.getIsLogoff().booleanValue() || user.getIsPermanentPaidMember().booleanValue()) {
                userList.remove(i);
                continue;
            }
            ++i;
        }
        if (CollUtil.isEmpty(userList)) {
            return Boolean.TRUE;
        }
        return this.generatePaidMemberOrder(userList, paidMemberCard);
    }

    private Boolean generatePaidMemberOrder(List<User> userList, PaidMemberCard paidMemberCard) {
        DateTime dateTime = DateUtil.date();
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = false;
            for (User user : userList) {
                DateTime offsetDay;
                PaidMemberOrder order = new PaidMemberOrder();
                order.setUid(user.getId());
                order.setOrderNo(CrmebUtil.getOrderNo((String)"FF"));
                order.setCardId(paidMemberCard.getId());
                order.setCardName(paidMemberCard.getName());
                order.setType(paidMemberCard.getType());
                order.setDeadlineDay(paidMemberCard.getDeadlineDay());
                order.setOriginalPrice(paidMemberCard.getOriginalPrice());
                order.setPrice(BigDecimal.ZERO);
                order.setGiftBalance(BigDecimal.ZERO);
                order.setPayType("give");
                order.setPayChannel("give");
                order.setPaid(Boolean.valueOf(true));
                order.setPayTime((Date)dateTime);
                if (user.getIsPaidMember().booleanValue()) {
                    offsetDay = DateUtil.offsetDay((Date)DateTime.of((Date)user.getPaidMemberExpirationTime()), (int)paidMemberCard.getDeadlineDay());
                    order.setCardExpirationTime((Date)offsetDay);
                    update = this.updateUserPaidMember(user.getId(), true, false, offsetDay, user.getPaidMemberExpirationTime());
                } else {
                    offsetDay = DateUtil.offsetDay((Date)dateTime, (int)paidMemberCard.getDeadlineDay());
                    order.setCardExpirationTime((Date)offsetDay);
                    update = this.updateUserPaidMember(user.getId(), true, false, offsetDay, null);
                }
                if (!update) {
                    this.logger.error("\u8d60\u9001\u4f1a\u5458\u5361\uff0c\u66f4\u65b0\u7528\u6237\u6570\u636e\u5931\u8d25,userID={},cardId={}", (Object)user.getId(), (Object)paidMemberCard.getId());
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
                this.paidMemberOrderService.save(order);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean updateUserPaidMember(Integer uid, boolean isPaidMember, boolean isPermanentPaidMember, DateTime expirationTime, Date oldTime) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(User::getIsPaidMember, (Object)isPaidMember);
        if (isPermanentPaidMember) {
            wrapper.set(User::getIsPermanentPaidMember, (Object)true);
        }
        wrapper.set(User::getPaidMemberExpirationTime, (Object)expirationTime);
        wrapper.eq(User::getId, (Object)uid);
        if (ObjectUtil.isNotNull((Object)oldTime)) {
            wrapper.eq(User::getPaidMemberExpirationTime, (Object)oldTime);
        }
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<User> findMemberExpirationList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(User::getIsLogoff, (Object)0);
        lqw.eq(User::getIsPaidMember, (Object)1);
        lqw.eq(User::getIsPermanentPaidMember, (Object)0);
        String format = DateUtil.format((Date)DateUtil.date(), (String)"yyyy-MM-dd HH:mm");
        lqw.apply("DATE_FORMAT(paid_member_expiration_time, '%Y-%m-%d %H:%i') < {0}", new Object[]{format});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean memberExpirationProcessing() {
        List<User> userList = this.findMemberExpirationList();
        return (Boolean)this.transactionTemplate.execute(e -> {
            for (User user : userList) {
                LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
                wrapper.set(User::getIsPaidMember, (Object)0);
                wrapper.eq(User::getId, (Object)user.getId());
                wrapper.eq(User::getPaidMemberExpirationTime, (Object)user.getPaidMemberExpirationTime());
                this.update((Wrapper)wrapper);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public List<User> findExportList(UserSearchRequest request) {
        DateLimitUtilVo dateLimit;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getTagIds())) {
            String tagIdSql = CrmebUtil.getFindInSetSql((String)"u.tag_id", (String)request.getTagIds());
            map.put("tagIdSql", tagIdSql);
        }
        if (ObjectUtil.isNotNull((Object)request.getSex())) {
            map.put("sex", request.getSex());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRegisterType())) {
            map.put("registerType", request.getRegisterType());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getPayCount())) {
            map.put("payCount", Integer.valueOf(request.getPayCount()));
        }
        if (ObjectUtil.isNotNull((Object)request.getIdentity())) {
            if (request.getIdentity().equals(1)) {
                map.put("isPromoter", 1);
            }
            if (request.getIdentity().equals(3)) {
                map.put("isPaidMember", 1);
            }
        }
        if (ObjectUtil.isNotNull((Object)request.getIsLogoff())) {
            map.put("isLogoff", request.getIsLogoff());
        }
        if (StrUtil.isNotBlank((CharSequence)(dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit())).getStartTime())) {
            map.put("startTime", dateLimit.getStartTime());
            map.put("endTime", dateLimit.getEndTime());
            map.put("accessType", request.getAccessType());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        return this.dao.findExportList(map);
    }

    @Override
    public List<User> findRetailStorePeopleList(RetailStorePeopleSearchRequest request) {
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        return this.dao.findRetailStorePeopleList(map);
    }

    @Override
    public List<User> getChannelDataByIds(List<Integer> userIds) {
        QueryWrapper wrapper = Wrappers.query();
        wrapper.select(new String[]{"register_type", "count(id) as pay_count"});
        wrapper.eq((Object)"is_logoff", (Object)0);
        wrapper.in((Object)"id", userIds);
        wrapper.groupBy((Object)"register_type");
        return this.dao.selectList((Wrapper)wrapper);
    }
}

