/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.admin.SystemMenu;
import com.zbkj.common.model.admin.SystemPermissions;
import com.zbkj.common.model.circle.CircleAdmin;
import com.zbkj.common.model.circle.CircleMenu;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.service.service.CircleAdminService;
import com.zbkj.service.service.CircleMenuService;
import com.zbkj.service.service.SystemAdminService;
import com.zbkj.service.service.SystemMenuService;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserDetailServiceImpl
implements UserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(UserDetailServiceImpl.class);
    @Autowired
    private SystemAdminService systemAdminService;
    @Autowired
    private CircleAdminService circleAdminService;
    @Autowired
    private SystemMenuService systemMenuService;
    @Autowired
    private CircleMenuService circleMenuService;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        String name = username.substring(0, username.length() - 1);
        Integer type = Integer.valueOf(username.substring(username.length() - 1));
        SystemAdmin user = null;
        CircleAdmin circleUser = null;
        if (!type.equals(RoleEnum.ULTRA_VIRES_ADMIN.getValue())) {
            if (type.equals(RoleEnum.CIRCLE_ADMIN.getValue()) || type.equals(RoleEnum.CIRCLE_SUPER.getValue())) {
                circleUser = this.circleAdminService.selectUserByAccountAndType(name, type);
                if (ObjectUtil.isNull((Object)circleUser)) {
                    log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u4e0d\u5b58\u5728.", (Object)name);
                    throw new UsernameNotFoundException("\u767b\u5f55\u7528\u6237\uff1a" + name + " \u4e0d\u5b58\u5728");
                }
                if (!circleUser.getStatus().booleanValue()) {
                    log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u5df2\u88ab\u505c\u7528.", (Object)name);
                    throw new UsernameNotFoundException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + name + " \u5df2\u505c\u7528");
                }
            } else {
                user = this.systemAdminService.selectUserByUserNameAndType(name, type);
                if (ObjectUtil.isNull((Object)user)) {
                    log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u4e0d\u5b58\u5728.", (Object)name);
                    throw new UsernameNotFoundException("\u767b\u5f55\u7528\u6237\uff1a" + name + " \u4e0d\u5b58\u5728");
                }
                if (!user.getStatus().booleanValue()) {
                    log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u5df2\u88ab\u505c\u7528.", (Object)name);
                    throw new UsernameNotFoundException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d26\u53f7\uff1a" + name + " \u5df2\u505c\u7528");
                }
            }
        } else {
            user = this.systemAdminService.getSuperAdminByPlat(Integer.valueOf(name));
            if (ObjectUtil.isNull((Object)user)) {
                log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u4e0d\u5b58\u5728.", (Object)name);
                throw new UsernameNotFoundException("\u767b\u5f55\u7528\u6237\uff1a" + name + " \u4e0d\u5b58\u5728");
            }
        }
        if (type.equals(RoleEnum.CIRCLE_ADMIN.getValue()) || type.equals(RoleEnum.CIRCLE_SUPER.getValue())) {
            return this.createLoginUser(circleUser);
        }
        return this.createLoginUser(user);
    }

    public UserDetails createLoginUser(SystemAdmin user) {
        List roles = Stream.of(user.getRoles().split(",")).map(Integer::valueOf).collect(Collectors.toList());
        List<Object> menuList = roles.contains(1) ? this.systemMenuService.getAllPermissions(RoleEnum.PLATFORM_ADMIN.getValue()) : (roles.contains(2) ? this.systemMenuService.getAllPermissions(RoleEnum.MERCHANT_ADMIN.getValue()) : this.systemMenuService.findPermissionByUserId(user.getId()));
        menuList = menuList.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getPerms())).filter(SystemMenu::getIsShow).collect(Collectors.toList());
        List permissionsList = menuList.stream().map(e -> {
            SystemPermissions permissions = new SystemPermissions();
            permissions.setId(e.getId());
            permissions.setPid(e.getPid());
            permissions.setName(e.getName());
            permissions.setPath(e.getPerms());
            permissions.setSort(e.getSort());
            return permissions;
        }).collect(Collectors.toList());
        return new LoginUserVo(user, permissionsList);
    }

    public UserDetails createLoginUser(CircleAdmin user) {
        List<Object> menuList = this.circleMenuService.findPermissionByUserId(user.getId());
        menuList = menuList.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getPerms())).filter(CircleMenu::getIsShow).collect(Collectors.toList());
        List permissionsList = menuList.stream().map(e -> {
            SystemPermissions permissions = new SystemPermissions();
            permissions.setId(e.getId());
            permissions.setPid(e.getPid());
            permissions.setName(e.getName());
            permissions.setPath(e.getPerms());
            permissions.setSort(e.getSort());
            return permissions;
        }).collect(Collectors.toList());
        SystemAdmin admin = new SystemAdmin();
        BeanUtils.copyProperties((Object)user, (Object)admin);
        return new LoginUserVo(admin, permissionsList);
    }
}

