/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.dto.Location;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.city.CityRegion;
import com.zbkj.common.model.user.UserAddress;
import com.zbkj.common.request.UserAddressRequest;
import com.zbkj.common.request.WechatAddressImportRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.UserResultCode;
import com.zbkj.common.utils.AddressUtil;
import com.zbkj.service.dao.UserAddressDao;
import com.zbkj.service.service.CityRegionService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserAddressService;
import com.zbkj.service.service.UserService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserAddressServiceImpl
extends ServiceImpl<UserAddressDao, UserAddress>
implements UserAddressService {
    @Resource
    private UserAddressDao dao;
    @Autowired
    private UserService userService;
    @Autowired
    private CityRegionService cityRegionService;
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public Integer create(UserAddressRequest request) {
        boolean save;
        UserAddress userAddress = new UserAddress();
        BeanUtils.copyProperties((Object)request, (Object)userAddress);
        userAddress.setUid(this.userService.getUserIdException());
        userAddress.setId(null);
        if (userAddress.getIsDefault().booleanValue()) {
            this.cancelDefault(userAddress.getUid());
        }
        if (!(save = this.save(userAddress))) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_ADDRESS_CREATE_FAILED);
        }
        return userAddress.getId();
    }

    @Override
    public Boolean edit(UserAddressRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5730\u5740ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer userId = this.userService.getUserIdException();
        UserAddress userAddress = this.getById(request.getId());
        if (ObjectUtil.isNull((Object)userAddress) || !userId.equals(userAddress.getUid())) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_ADDRESS_NOT_EXIST);
        }
        UserAddress address = new UserAddress();
        BeanUtils.copyProperties((Object)request, (Object)address);
        if (StrUtil.isBlank((CharSequence)request.getStreet())) {
            address.setStreet("");
        }
        if (address.getIsDefault().booleanValue()) {
            this.cancelDefault(userId);
        }
        address.setUpdateTime((Date)DateUtil.date());
        return this.updateById(address);
    }

    @Override
    public Boolean delete(Integer id) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(UserAddress::getId, (Object)id);
        wrapper.eq(UserAddress::getUid, (Object)this.userService.getUserIdException());
        return this.dao.delete((Wrapper)wrapper) > 0;
    }

    @Override
    public UserAddress getDefault() {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(UserAddress::getIsDefault, (Object)true);
        lqw.eq(UserAddress::getUid, (Object)this.userService.getUserIdException());
        lqw.eq(UserAddress::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (UserAddress)this.dao.selectOne((Wrapper)lqw);
    }

    private UserAddress getById(Integer addressId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(UserAddress::getId, (Object)addressId);
        lqw.eq(UserAddress::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (UserAddress)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public UserAddress getDetail(Integer id) {
        Integer UserId = this.userService.getUserIdException();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{UserAddress::getId, UserAddress::getRealName, UserAddress::getPhone, UserAddress::getProvince, UserAddress::getProvinceId, UserAddress::getCity, UserAddress::getDistrict, UserAddress::getStreet, UserAddress::getDetail, UserAddress::getPostCode, UserAddress::getIsDefault, UserAddress::getCityId, UserAddress::getDistrictId});
        lqw.eq(UserAddress::getId, (Object)id);
        lqw.eq(UserAddress::getUid, (Object)UserId);
        lqw.eq(UserAddress::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (UserAddress)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public UserAddress getDefaultByUid(Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserAddress::getIsDefault, (Object)true);
        lqw.eq(UserAddress::getUid, (Object)uid);
        lqw.last(" limit 1");
        return (UserAddress)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<UserAddress> getAllList() {
        Integer UserId = this.userService.getUserIdException();
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{UserAddress::getId, UserAddress::getRealName, UserAddress::getPhone, UserAddress::getProvince, UserAddress::getProvinceId, UserAddress::getCity, UserAddress::getDistrict, UserAddress::getDetail, UserAddress::getPostCode, UserAddress::getIsDefault, UserAddress::getCityId, UserAddress::getDistrictId, UserAddress::getStreet});
        lqw.eq(UserAddress::getUid, (Object)UserId);
        lqw.eq(UserAddress::getIsDel, (Object)false);
        lqw.orderByDesc(UserAddress::getIsDefault);
        lqw.orderByDesc(UserAddress::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean setDefault(Integer id) {
        UserAddress userAddress = this.getDefault();
        if (ObjectUtil.isNotNull((Object)userAddress)) {
            this.cancelDefault(userAddress.getUid());
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(UserAddress::getIsDefault, (Object)true);
        wrapper.eq(UserAddress::getId, (Object)id);
        wrapper.eq(UserAddress::getUid, (Object)this.userService.getUserIdException());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public UserAddress getWechatInfo(WechatAddressImportRequest request) {
        CityRegion provinceRegion;
        CityRegion cityRegion;
        CityRegion countyRegion = this.cityRegionService.getByRegionId(Integer.parseInt(request.getNationalCode()));
        if (ObjectUtil.isNotNull((Object)countyRegion) && countyRegion.getRegionType().equals(3)) {
            cityRegion = this.cityRegionService.getByRegionId(countyRegion.getParentId());
            provinceRegion = this.cityRegionService.getByRegionId(cityRegion.getParentId());
        } else {
            provinceRegion = this.cityRegionService.getByRegionName(request.getProvinceName(), 1, 1);
            if (ObjectUtil.isNull((Object)provinceRegion)) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u5bf9\u5e94\u7701\u7ea7\u533a\u57df\u672a\u627e\u5230\uff0c\u5fae\u4fe1\u53c2\u6570provinceName = {}", (Object[])new Object[]{request.getProvinceName()}));
            }
            cityRegion = this.cityRegionService.getByRegionName(request.getCityName(), provinceRegion.getRegionId(), 2);
            if (ObjectUtil.isNull((Object)cityRegion)) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u5bf9\u5e94\u5e02\u7ea7\u533a\u57df\u672a\u627e\u5230\uff0c\u5fae\u4fe1\u53c2\u6570cityName = {}", (Object[])new Object[]{request.getCityName()}));
            }
            countyRegion = this.cityRegionService.getByRegionName(request.getCountryName(), cityRegion.getRegionId(), 3);
            if (ObjectUtil.isNull((Object)countyRegion)) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u5bf9\u5e94\u533a\u7ea7\u533a\u57df\u672a\u627e\u5230\uff0c\u5fae\u4fe1\u53c2\u6570countyName = {}", (Object[])new Object[]{request.getCountryName()}));
            }
        }
        UserAddress userAddress = new UserAddress();
        userAddress.setProvince(provinceRegion.getRegionName());
        userAddress.setProvinceId(provinceRegion.getRegionId());
        userAddress.setCity(cityRegion.getRegionName());
        userAddress.setCityId(cityRegion.getRegionId());
        userAddress.setDistrict(countyRegion.getRegionName());
        userAddress.setDistrictId(countyRegion.getRegionId());
        userAddress.setStreet(StrUtil.isNotBlank((CharSequence)request.getStreetName()) ? request.getStreetName() : "");
        userAddress.setDetail(request.getDetail());
        return userAddress;
    }

    @Override
    public Location getLonLatById(Integer id) {
        UserAddress userAddress = this.getById(id);
        String address = userAddress.getProvince() + userAddress.getCity() + userAddress.getDistrict();
        if (StrUtil.isNotBlank((CharSequence)userAddress.getStreet())) {
            address = address + userAddress.getStreet();
        }
        if (StrUtil.isNotBlank((CharSequence)userAddress.getDetail())) {
            address = address + userAddress.getDetail();
        }
        String txKey = this.systemConfigService.getValueByKey("tengxun_map_key");
        return AddressUtil.getLocationByTx((String)txKey, (String)address);
    }

    @Override
    public UserAddress mapInfo(Location location) {
        if (StrUtil.isBlank((CharSequence)location.getLongitude()) || StrUtil.isBlank((CharSequence)location.getLatitude())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String txKey = this.systemConfigService.getValueByKey("tengxun_map_key");
        String addressJson = AddressUtil.addressAntiResolutionByTx((String)txKey, (String)location.getLongitude(), (String)location.getLatitude());
        JSONObject jsonObject = JSONObject.parseObject((String)addressJson);
        JSONObject resultJsonObject = jsonObject.getJSONObject("result");
        JSONObject componentJsonObject = resultJsonObject.getJSONObject("address_component");
        String province = componentJsonObject.getString("province");
        String city = componentJsonObject.getString("city");
        String district = componentJsonObject.getString("district");
        String street = componentJsonObject.getString("street");
        JSONObject formattedJsonObject = resultJsonObject.getJSONObject("formatted_addresses");
        String recommendAddress = formattedJsonObject.getString("recommend");
        CityRegion provinceRegion = this.cityRegionService.getByRegionName(province, 1, 1);
        if (ObjectUtil.isNull((Object)provinceRegion)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u5bf9\u5e94\u7701\u7ea7\u533a\u57df\u672a\u627e\u5230\uff0cprovinceName = {}", (Object[])new Object[]{province}));
        }
        CityRegion cityRegion = this.cityRegionService.getByRegionName(city, provinceRegion.getRegionId(), 2);
        if (ObjectUtil.isNull((Object)cityRegion)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u5bf9\u5e94\u5e02\u7ea7\u533a\u57df\u672a\u627e\u5230\uff0ccityName = {}", (Object[])new Object[]{city}));
        }
        CityRegion districtRegion = this.cityRegionService.getByRegionName(district, cityRegion.getRegionId(), 3);
        if (ObjectUtil.isNull((Object)districtRegion)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u5bf9\u5e94\u533a\u7ea7\u533a\u57df\u672a\u627e\u5230\uff0cdistrictName = {}", (Object[])new Object[]{district}));
        }
        UserAddress userAddress = new UserAddress();
        userAddress.setProvince(provinceRegion.getRegionName());
        userAddress.setProvinceId(provinceRegion.getRegionId());
        userAddress.setCity(cityRegion.getRegionName());
        userAddress.setCityId(cityRegion.getRegionId());
        userAddress.setDistrict(districtRegion.getRegionName());
        userAddress.setDistrictId(districtRegion.getRegionId());
        userAddress.setStreet(StrUtil.isNotBlank((CharSequence)street) ? street : "");
        userAddress.setDetail(recommendAddress);
        return userAddress;
    }

    private void cancelDefault(Integer userId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(UserAddress::getIsDefault, (Object)false);
        wrapper.eq(UserAddress::getUid, (Object)userId);
        this.update((Wrapper)wrapper);
    }
}

