/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.SystemAttachment;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.UploadUtil;
import com.zbkj.common.vo.FileResultVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.service.service.CosService;
import com.zbkj.service.service.HuaWeiObsService;
import com.zbkj.service.service.JdCloudService;
import com.zbkj.service.service.OssService;
import com.zbkj.service.service.QiNiuService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemRoleService;
import com.zbkj.service.service.UploadService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

@Service
public class UploadServiceImpl
implements UploadService {
    private static final Logger logger = LoggerFactory.getLogger(UploadServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private QiNiuService qiNiuService;
    @Autowired
    private OssService ossService;
    @Autowired
    private CosService cosService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private SystemRoleService systemRoleService;
    @Autowired
    private JdCloudService jdCloudService;
    @Autowired
    private HuaWeiObsService huaWeiObsService;

    @Override
    public FileResultVo imageUploadV2(MultipartFile multipartFile, Integer pid) {
        Integer ownerId = this.systemRoleService.getOwnerByCurrentAdmin();
        return this.imageUploadV2(multipartFile, pid, ownerId);
    }

    @Override
    public FileResultVo fileUploadV2(MultipartFile multipartFile, Integer pid) {
        Integer ownerId = this.systemRoleService.getOwnerByCurrentAdmin();
        return this.fileUploadV2(multipartFile, pid, ownerId);
    }

    @Override
    public FileResultVo imageUploadV2(MultipartFile multipartFile, Integer pid, Integer ownerId) {
        FileResultVo fileResultVo = new FileResultVo();
        try {
            fileResultVo = this.commonUploadV2(multipartFile, pid, "image", ownerId);
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u4e0a\u4f20IO\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            throw new CrmebException("\u56fe\u7247\u4e0a\u4f20 IO\u5f02\u5e38");
        }
        return fileResultVo;
    }

    @Override
    public FileResultVo fileUploadV2(MultipartFile multipartFile, Integer pid, Integer ownerId) {
        FileResultVo fileResultVo = new FileResultVo();
        try {
            fileResultVo = this.commonUploadV2(multipartFile, pid, "file", ownerId);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20IO\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            throw new CrmebException("\u6587\u4ef6\u4e0a\u4f20 IO\u5f02\u5e38");
        }
        return fileResultVo;
    }

    @Override
    public FileResultVo base64UploadV2(String base64) {
        MyRecord fileRecord = this.createFileRecord("image", "jpg");
        String filePath = fileRecord.getStr("filePath");
        String localFile = fileRecord.getStr("localFile");
        String destPath = fileRecord.getStr("destPath");
        String newFileName = fileRecord.getStr("newFileName");
        File file = this.base64ToFile(base64, destPath);
        FileResultVo resultFile = new FileResultVo();
        resultFile.setFileSize(Long.valueOf(file.length()));
        resultFile.setFileName(newFileName);
        resultFile.setExtName("jpg");
        resultFile.setUrl(filePath);
        resultFile.setType("jpg");
        SystemAttachment systemAttachment = new SystemAttachment();
        systemAttachment.setName(resultFile.getFileName());
        systemAttachment.setSattDir(resultFile.getUrl());
        systemAttachment.setAttSize(resultFile.getFileSize().toString());
        systemAttachment.setAttType(resultFile.getType());
        systemAttachment.setImageType(Integer.valueOf(1));
        systemAttachment.setPid(Integer.valueOf(0));
        systemAttachment.setOwner(Integer.valueOf(-2));
        String uploadType = this.systemConfigService.getValueByKeyException("uploadType");
        Integer uploadTypeInt = Integer.parseInt(uploadType);
        if (uploadTypeInt > 1) {
            systemAttachment.setImageType(uploadTypeInt);
            this.thirdPartyUpload(uploadTypeInt, filePath, localFile, file);
            String fileIsSave = this.systemConfigService.getValueByKeyException("file_is_save");
            if (!fileIsSave.equals("1")) {
                file.delete();
            }
        }
        this.systemAttachmentService.save(systemAttachment);
        return resultFile;
    }

    private MyRecord createFileRecord(String fileType, String extName) {
        String rootPath = this.crmebConfig.getImagePath().trim();
        String fileTypePath = "crmebimage/" + fileType + "/";
        String newFileName = UploadUtil.fileName((String)extName);
        String datePath = CrmebDateUtil.nowDate((String)"yyyy/MM/dd") + "/";
        String webPath = fileTypePath + datePath;
        String path = rootPath + webPath;
        String destPath = FilenameUtils.separatorsToSystem((String)path) + newFileName;
        MyRecord record = new MyRecord();
        String filePath = webPath + newFileName;
        record.set("filePath", (Object)filePath);
        record.set("localFile", (Object)(rootPath + "/" + filePath));
        record.set("destPath", (Object)destPath);
        record.set("newFileName", (Object)newFileName);
        return record;
    }

    private File base64ToFile(String base64, String destPath) {
        File file = null;
        OutputStream out = null;
        try {
            file = UploadUtil.createFile((String)destPath);
            base64 = base64.substring(base64.indexOf(",", 1) + 1);
            BASE64Decoder d = new BASE64Decoder();
            byte[] imgbytes = d.decodeBuffer(base64);
            for (int i = 0; i < imgbytes.length; ++i) {
                if (imgbytes[i] >= 0) continue;
                int n = i;
                imgbytes[n] = (byte)(imgbytes[n] + 256);
            }
            logger.info("base64\u56fe\u7247\u5730\u5740\uff1a=========================================================================" + destPath);
            out = new FileOutputStream(file);
            out.write(imgbytes);
            out.flush();
        }
        catch (IOException e) {
            logger.error("base64\u4e0a\u4f20\u2014\u2014\u8f6c\u56fe\u7247\u5f02\u5e38", (Throwable)e);
            throw new CrmebException("base64\u4e0a\u4f20\u2014\u2014\u8f6c\u56fe\u7247\u5f02\u5e38:" + e.getMessage());
        }
        finally {
            try {
                assert (out != null);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("base64\u4e0a\u4f20\u2014\u2014\u5173\u95edOutputStream\u6d41\u5f02\u5e38");
            }
        }
        return file;
    }

    private String uploadValidate(String fileName, float fileSize, String fileType, String contentType) {
        String extStr;
        String extName = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (StrUtil.isNotBlank((CharSequence)extName)) {
            if (StrUtil.isNotBlank((CharSequence)contentType)) {
                extName = contentType.split("/")[1];
            } else {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6587\u4ef6\u7c7b\u578b\u672a\u5b9a\u4e49\uff0c\u65e0\u6cd5\u4e0a\u4f20...");
            }
        }
        if (StrUtil.isNotBlank((CharSequence)(extStr = this.systemConfigService.getValueByKey(fileType.equals("uploadf") ? "file_ext_str" : "image_ext_str")))) {
            List extensionList = CrmebUtil.stringToArrayStr((String)extStr);
            if (CollUtil.isNotEmpty((Collection)extensionList)) {
                if (!extensionList.contains(extName)) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0a\u8f7d\u6587\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3a\uff1a" + extStr);
                }
            } else {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0a\u8f7d\u6587\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3a\uff1a" + extStr);
            }
        }
        int size = Integer.parseInt(this.systemConfigService.getValueByKey(fileType.equals("uploadf") ? "file_max_size" : "image_max_size"));
        String fs = String.format("%.2f", Float.valueOf(fileSize));
        if (fileSize > (float)size) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u6700\u5927\u5141\u8bb8\u4e0a\u4f20 {} MB\u6587\u4ef6\uff0c\u5f53\u524d\u6587\u4ef6\u5927\u5c0f\u4e3a {} MB", (Object[])new Object[]{size, fs}));
        }
        return extName;
    }

    private FileResultVo commonUploadV2(MultipartFile multipartFile, Integer pid, String fileType, Integer owner) throws IOException {
        if (ObjectUtil.isNull((Object)multipartFile) || multipartFile.isEmpty()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0a\u8f7d\u7684\u6587\u4ef6\u5bf9\u8c61\u4e0d\u5b58\u5728...");
        }
        String fileName = multipartFile.getOriginalFilename();
        float fileSize = (float)multipartFile.getSize() / 1024.0f / 1024.0f;
        String contentType = multipartFile.getContentType();
        String extName = this.uploadValidateV2(fileName, fileSize, fileType, contentType);
        if (fileName.length() > 99) {
            fileName = StrUtil.subPre((CharSequence)fileName, (int)90).concat(".").concat(extName);
        }
        MyRecord fileRecord = this.createFileRecord(fileType, extName);
        String filePath = fileRecord.getStr("filePath");
        String localFile = fileRecord.getStr("localFile");
        String destPath = fileRecord.getStr("destPath");
        File file = UploadUtil.createFile((String)destPath);
        FileResultVo resultFile = new FileResultVo();
        resultFile.setFileSize(Long.valueOf(multipartFile.getSize()));
        resultFile.setFileName(fileName);
        resultFile.setExtName(extName);
        resultFile.setUrl(filePath);
        resultFile.setType(multipartFile.getContentType());
        if (fileType.equals("image")) {
            resultFile.setType(resultFile.getType().replace("image/", ""));
        } else {
            resultFile.setType(resultFile.getType().replace("file/", ""));
        }
        SystemAttachment systemAttachment = new SystemAttachment();
        systemAttachment.setName(resultFile.getFileName());
        systemAttachment.setAlias(resultFile.getFileName());
        systemAttachment.setSattDir(resultFile.getUrl());
        systemAttachment.setAttSize(resultFile.getFileSize().toString());
        systemAttachment.setAttType(resultFile.getType());
        systemAttachment.setImageType(Integer.valueOf(1));
        systemAttachment.setPid(pid);
        systemAttachment.setOwner(owner);
        String uploadType = this.systemConfigService.getValueByKeyException("uploadType");
        Integer uploadTypeInt = Integer.parseInt(uploadType);
        multipartFile.transferTo(file);
        if (uploadTypeInt > 1) {
            systemAttachment.setImageType(uploadTypeInt);
            this.thirdPartyUpload(uploadTypeInt, filePath, localFile, file);
            String fileIsSave = this.systemConfigService.getValueByKeyException("file_is_save");
            if (!fileIsSave.equals("1")) {
                file.delete();
            }
        }
        this.systemAttachmentService.save(systemAttachment);
        return resultFile;
    }

    private void thirdPartyUpload(Integer uploadType, String filePth, String localFile, File file) {
        switch (uploadType) {
            case 2: {
                try {
                    this.qiNiuService.uploadFile(filePth, localFile, file);
                }
                catch (Exception e) {
                    logger.error("upload qiniu kodo fail " + e.getMessage());
                }
                break;
            }
            case 3: {
                try {
                    this.ossService.upload(filePth, localFile, file);
                }
                catch (Exception e) {
                    logger.error("upload ali oss fail " + e.getMessage());
                }
                break;
            }
            case 4: {
                try {
                    this.cosService.uploadFile(filePth, localFile, file);
                }
                catch (Exception e) {
                    logger.error("upload tx cos fail " + e.getMessage());
                }
                break;
            }
            case 5: {
                try {
                    this.jdCloudService.uploadFile(filePth, localFile, file);
                }
                catch (Exception e) {
                    logger.error("AsyncServiceImpl.cos.fail " + e.getMessage());
                }
                break;
            }
            case 6: {
                try {
                    this.huaWeiObsService.uploadFile(filePth, localFile, file);
                    break;
                }
                catch (Exception e) {
                    logger.error("upload huawei obs fail " + e.getMessage());
                }
            }
        }
    }

    private String uploadValidateV2(String fileName, float fileSize, String fileType, String contentType) {
        String extStr;
        String extName = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (StrUtil.isNotBlank((CharSequence)extName)) {
            if (StrUtil.isNotBlank((CharSequence)contentType)) {
                extName = contentType.split("/")[1];
            } else {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6587\u4ef6\u7c7b\u578b\u672a\u5b9a\u4e49\uff0c\u65e0\u6cd5\u4e0a\u4f20...");
            }
        }
        if (StrUtil.isNotBlank((CharSequence)(extStr = this.systemConfigService.getValueByKey(fileType.equals("file") ? "file_ext_str" : "image_ext_str")))) {
            List extensionList = CrmebUtil.stringToArrayStr((String)extStr);
            if (CollUtil.isNotEmpty((Collection)extensionList)) {
                if (!extensionList.contains(extName)) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0a\u8f7d\u6587\u4ef6\u7c7b\u578b\u53ea\u80fd\u4e3a\uff1a" + extStr);
                }
            } else {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u5148\u914d\u7f6e\u4e0a\u8f7d\u6587\u4ef6\u7c7b\u578b");
            }
        }
        int size = Integer.parseInt(this.systemConfigService.getValueByKey(fileType.equals("file") ? "file_max_size" : "image_max_size"));
        String fs = String.format("%.2f", Float.valueOf(fileSize));
        if (fileSize > (float)size) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u6700\u5927\u5141\u8bb8\u4e0a\u4f20 {} MB\u6587\u4ef6\uff0c\u5f53\u524d\u6587\u4ef6\u5927\u5c0f\u4e3a {} MB", (Object[])new Object[]{size, fs}));
        }
        return extName;
    }
}

