/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.template.TemplateMessage;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.service.dao.TemplateMessageDao;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.TemplateMessageService;
import com.zbkj.service.service.WechatService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateMessageServiceImpl
extends ServiceImpl<TemplateMessageDao, TemplateMessage>
implements TemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(TemplateMessageServiceImpl.class);
    @Resource
    private TemplateMessageDao dao;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private SystemNotificationService systemNotificationService;

    @Override
    public void pushTemplateMessage(Integer templateId, HashMap<String, String> temMap, String openId) {
        TemplateMessage templateMessage = (TemplateMessage)this.getById(templateId);
        if (ObjectUtil.isNull((Object)templateMessage) || StrUtil.isBlank((CharSequence)templateMessage.getContent())) {
            return;
        }
        this.wechatService.sendPublicTemplateMessage(templateMessage.getTempId(), openId, temMap);
    }

    @Override
    public void pushMiniTemplateMessage(Integer templateId, HashMap<String, String> temMap, String openId) {
        TemplateMessage templateMessage = (TemplateMessage)this.getById(templateId);
        if (ObjectUtil.isNull((Object)templateMessage) || StrUtil.isBlank((CharSequence)templateMessage.getContent())) {
            return;
        }
        this.wechatService.sendMiniSubscribeMessage(templateMessage.getTempId(), openId, temMap);
    }

    @Override
    public Boolean whcbqhnSync() {
        List<SystemNotification> notificationList = this.systemNotificationService.getListByWechat("public");
        List<Integer> wechatIdList = notificationList.stream().map(SystemNotification::getWechatId).collect(Collectors.toList());
        List<TemplateMessage> templateMessageList = this.getListByIdList(wechatIdList);
        if (CollUtil.isEmpty(templateMessageList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u5148\u6dfb\u52a0\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f");
        }
        return true;
    }

    @Override
    public Boolean routineSync() {
        List<SystemNotification> notificationList = this.systemNotificationService.getListByWechat("routine_appid");
        List<Integer> routineIdList = notificationList.stream().map(SystemNotification::getRoutineId).collect(Collectors.toList());
        List<TemplateMessage> templateMessageList = this.getListByIdList(routineIdList);
        if (CollUtil.isEmpty(templateMessageList)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u5148\u914d\u7f6e\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f");
        }
        return true;
    }

    private List<TemplateMessage> getListByIdList(List<Integer> idList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(TemplateMessage::getId, idList);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public TemplateMessage infoException(Integer id) {
        TemplateMessage message = (TemplateMessage)this.getById(id);
        if (ObjectUtil.isNull((Object)message)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        return message;
    }

    @Override
    public List<TemplateMessage> getByIdList(List<Integer> tidList) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(TemplateMessage::getId, tidList);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }
}

