/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.SystemUserLevel;
import com.zbkj.common.request.SystemUserLevelRequest;
import com.zbkj.common.request.SystemUserLevelRuleRequest;
import com.zbkj.common.request.SystemUserLevelUpdateShowRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.SystemConfigResultCode;
import com.zbkj.common.vo.SystemUserLevelConfigVo;
import com.zbkj.service.dao.SystemUserLevelDao;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemUserLevelService;
import com.zbkj.service.service.UserLevelService;
import com.zbkj.service.service.UserService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class SystemUserLevelServiceImpl
extends ServiceImpl<SystemUserLevelDao, SystemUserLevel>
implements SystemUserLevelService {
    @Resource
    private SystemUserLevelDao dao;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private UserLevelService userLevelService;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public List<SystemUserLevel> getList() {
        LambdaQueryWrapper levelLambdaQueryWrapper = new LambdaQueryWrapper();
        levelLambdaQueryWrapper.eq(SystemUserLevel::getIsDel, (Object)false);
        levelLambdaQueryWrapper.orderByAsc(SystemUserLevel::getGrade);
        return this.dao.selectList((Wrapper)levelLambdaQueryWrapper);
    }

    @Override
    public Boolean create(SystemUserLevelRequest request) {
        if (request.getGrade().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7528\u6237\u7b49\u7ea7\u4e0d\u80fd\u8bbe\u7f6e0");
        }
        request.setId(null);
        this.checkLevel(request);
        SystemUserLevel systemUserLevel = new SystemUserLevel();
        BeanUtils.copyProperties((Object)request, (Object)systemUserLevel);
        systemUserLevel.setDiscount(Integer.valueOf(0));
        systemUserLevel.setIsShow(Boolean.valueOf(true));
        systemUserLevel.setIcon(this.systemAttachmentService.clearPrefix(request.getIcon()));
        systemUserLevel.setBackImage(this.systemAttachmentService.clearPrefix(request.getBackImage()));
        return this.save(systemUserLevel);
    }

    private void checkLevel(SystemUserLevelRequest request) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemUserLevel::getName, (Object)request.getName());
        if (ObjectUtil.isNotNull((Object)request.getId())) {
            lqw.ne(SystemUserLevel::getId, (Object)request.getId());
        }
        lqw.eq(SystemUserLevel::getIsDel, (Object)false);
        SystemUserLevel temp = (SystemUserLevel)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)temp)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7528\u6237\u7b49\u7ea7\u540d\u79f0\u91cd\u590d");
        }
        lqw.clear();
        lqw.eq(SystemUserLevel::getGrade, (Object)request.getGrade());
        if (ObjectUtil.isNotNull((Object)request.getId())) {
            lqw.ne(SystemUserLevel::getId, (Object)request.getId());
        }
        lqw.eq(SystemUserLevel::getIsDel, (Object)false);
        temp = (SystemUserLevel)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)temp)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7528\u6237\u7b49\u7ea7\u7ea7\u522b\u91cd\u590d");
        }
        if (request.getGrade() > 1) {
            lqw.clear();
            lqw.lt(SystemUserLevel::getGrade, (Object)request.getGrade());
            if (ObjectUtil.isNotNull((Object)request.getId())) {
                lqw.ne(SystemUserLevel::getId, (Object)request.getId());
            }
            lqw.eq(SystemUserLevel::getIsDel, (Object)false);
            lqw.orderByDesc(SystemUserLevel::getGrade);
            lqw.last(" limit 1");
            temp = (SystemUserLevel)this.dao.selectOne((Wrapper)lqw);
            if (ObjectUtil.isNotNull((Object)temp) && temp.getExperience() >= request.getExperience()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524d\u7b49\u7ea7\u7684\u7ecf\u9a8c\u4e0d\u80fd\u6bd4\u4e0a\u4e00\u7ea7\u522b\u7684\u7ecf\u9a8c\u4f4e");
            }
        }
        lqw.clear();
        lqw.gt(SystemUserLevel::getGrade, (Object)request.getGrade());
        if (ObjectUtil.isNotNull((Object)request.getId())) {
            lqw.ne(SystemUserLevel::getId, (Object)request.getId());
        }
        lqw.eq(SystemUserLevel::getIsDel, (Object)false);
        lqw.orderByAsc(SystemUserLevel::getGrade);
        lqw.last(" limit 1");
        temp = (SystemUserLevel)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)temp) && temp.getExperience() <= request.getExperience()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524d\u7b49\u7ea7\u7684\u7ecf\u9a8c\u4e0d\u80fd\u6bd4\u4e0b\u4e00\u7ea7\u522b\u7684\u7ecf\u9a8c\u9ad8");
        }
    }

    @Override
    public Boolean edit(SystemUserLevelRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7b49\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SystemUserLevel level = (SystemUserLevel)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)level) || level.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7b49\u7ea7\u4e0d\u5b58\u5728");
        }
        if (level.getGrade().equals(0) && !request.getGrade().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0d\u80fd\u4fee\u6539\u7ea7\u522b\u4e3a0\u7684\u7ea7\u522b");
        }
        if (level.getGrade().equals(0) && !request.getExperience().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0d\u80fd\u4fee\u6539\u7ea7\u522b\u4e3a0\u7684\u7b49\u7ea7\u7ecf\u9a8c");
        }
        this.checkLevel(request);
        SystemUserLevel systemUserLevel = new SystemUserLevel();
        BeanUtils.copyProperties((Object)request, (Object)systemUserLevel);
        systemUserLevel.setIcon(this.systemAttachmentService.clearPrefix(request.getIcon()));
        systemUserLevel.setBackImage(this.systemAttachmentService.clearPrefix(request.getBackImage()));
        systemUserLevel.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.updateById(systemUserLevel);
            if (!level.getGrade().equals(systemUserLevel.getGrade()) || !level.getExperience().equals(systemUserLevel.getExperience())) {
                this.userLevelService.deleteByLevelId(request.getId());
                this.userService.removeLevelByLevelId(request.getId());
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public SystemUserLevel getByLevelId(Integer levelId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SystemUserLevel::getIsShow, (Object)1);
        lambdaQueryWrapper.eq(SystemUserLevel::getIsDel, (Object)0);
        lambdaQueryWrapper.eq(SystemUserLevel::getId, (Object)levelId);
        return (SystemUserLevel)this.dao.selectOne((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<SystemUserLevel> getH5LevelList() {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{SystemUserLevel::getId, SystemUserLevel::getName, SystemUserLevel::getIcon, SystemUserLevel::getExperience});
        lqw.eq(SystemUserLevel::getIsShow, (Object)true);
        lqw.eq(SystemUserLevel::getIsDel, (Object)false);
        lqw.orderByAsc(SystemUserLevel::getGrade);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean delete(Integer id) {
        SystemUserLevel level = (SystemUserLevel)this.getById(id);
        if (ObjectUtil.isNull((Object)level) || level.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.USER_LEVEL_NOT_EXIST);
        }
        if (level.getGrade().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7ea7\u522b\u4e3a0\u7684\u7528\u6237\u7b49\u7ea7\u4e0d\u652f\u6301\u5220\u9664\u64cd\u4f5c");
        }
        level.setIsDel(Boolean.valueOf(true));
        level.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.updateById(level);
            this.userLevelService.deleteByLevelId(id);
            this.userService.removeLevelByLevelId(id);
            return Boolean.TRUE;
        });
    }

    @Override
    @Deprecated
    public Boolean updateShow(SystemUserLevelUpdateShowRequest request) {
        SystemUserLevel level = (SystemUserLevel)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)level) || level.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)SystemConfigResultCode.USER_LEVEL_NOT_EXIST);
        }
        if (level.getGrade().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7ea7\u522b\u4e3a0\u7684\u7528\u6237\u7b49\u7ea7\u65e0\u6cd5\u7981\u7528");
        }
        if (level.getIsShow().equals(request.getIsShow())) {
            return Boolean.TRUE;
        }
        level.setIsShow(request.getIsShow());
        level.setUpdateTime((Date)DateUtil.date());
        if (request.getIsShow().booleanValue()) {
            return this.dao.updateById(level) > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.updateById(level);
            this.userLevelService.deleteByLevelId(request.getId());
            this.userService.removeLevelByLevelId(request.getId());
            return Boolean.TRUE;
        });
    }

    @Override
    public String getRule() {
        return this.systemConfigService.getValueByKey("userLevelRule");
    }

    @Override
    public SystemUserLevelConfigVo getConfig() {
        String userLevelSwitch = this.systemConfigService.getValueByKey("userLevelSwitch");
        String exp = this.systemConfigService.getValueByKey("userLevelCommunityNotesExp");
        String num = this.systemConfigService.getValueByKey("userLevelCommunityNotesNum");
        SystemUserLevelConfigVo configVo = new SystemUserLevelConfigVo();
        configVo.setUserLevelSwitch(userLevelSwitch);
        configVo.setUserLevelCommunityNotesExp(Integer.valueOf(exp));
        configVo.setUserLevelCommunityNotesNum(Integer.valueOf(num));
        return configVo;
    }

    @Override
    public Boolean updateRule(SystemUserLevelRuleRequest request) {
        Boolean update;
        if (null == request.getRule()) {
            request.setRule("");
        }
        if (!(update = this.systemConfigService.updateOrSaveValueByName("userLevelRule", Optional.ofNullable(request.getRule()).orElse(""))).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u7f16\u8f91\u7528\u6237\u7b49\u7ea7\u89c4\u5219\u5931\u8d25"));
        }
        return true;
    }

    @Override
    public Boolean updateConfig(SystemUserLevelConfigVo request) {
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.systemConfigService.updateOrSaveValueByName("userLevelSwitch", request.getUserLevelSwitch());
            this.systemConfigService.updateOrSaveValueByName("userLevelCommunityNotesExp", request.getUserLevelCommunityNotesExp().toString());
            this.systemConfigService.updateOrSaveValueByName("userLevelCommunityNotesNum", request.getUserLevelCommunityNotesNum().toString());
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u7f16\u8f91\u7528\u6237\u7b49\u7ea7\u914d\u7f6e\u5931\u8d25"));
        }
        return true;
    }

    @Override
    public SystemUserLevel getNextLevel(Integer level) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.gt(SystemUserLevel::getGrade, (Object)level);
        lqw.eq(SystemUserLevel::getIsShow, (Object)true);
        lqw.eq(SystemUserLevel::getIsDel, (Object)false);
        lqw.orderByAsc(SystemUserLevel::getGrade);
        lqw.last(" limit 1");
        return (SystemUserLevel)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public SystemUserLevel getByExp(Integer exp) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.gt(SystemUserLevel::getExperience, (Object)exp);
        lqw.eq(SystemUserLevel::getIsShow, (Object)true);
        lqw.eq(SystemUserLevel::getIsDel, (Object)false);
        lqw.orderByAsc(SystemUserLevel::getGrade);
        lqw.last(" limit 1");
        SystemUserLevel systemUserLevel = (SystemUserLevel)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotNull((Object)systemUserLevel)) {
            return systemUserLevel;
        }
        lqw.clear();
        lqw.eq(SystemUserLevel::getIsShow, (Object)true);
        lqw.eq(SystemUserLevel::getIsDel, (Object)false);
        lqw.orderByDesc(SystemUserLevel::getGrade);
        lqw.last(" limit 1");
        systemUserLevel = (SystemUserLevel)this.dao.selectOne((Wrapper)lqw);
        return systemUserLevel;
    }

    @Override
    public SystemUserLevel getPreviousGrade(Integer grade) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.lt(SystemUserLevel::getGrade, (Object)grade);
        lqw.eq(SystemUserLevel::getIsShow, (Object)true);
        lqw.eq(SystemUserLevel::getIsDel, (Object)false);
        lqw.orderByDesc(SystemUserLevel::getGrade);
        lqw.last(" limit 1");
        return (SystemUserLevel)this.dao.selectOne((Wrapper)lqw);
    }
}

