/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.system.SystemAttachment;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemAttachmentMoveRequest;
import com.zbkj.common.request.SystemAttachmentSearchRequest;
import com.zbkj.common.request.SystemAttachmentUpdateNameRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.SystemAttachmentDao;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemAttachmentServiceImpl
extends ServiceImpl<SystemAttachmentDao, SystemAttachment>
implements SystemAttachmentService {
    @Resource
    private SystemAttachmentDao dao;
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public List<SystemAttachment> getList(Integer pid, String attType, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SystemAttachment::getOwner, (Object)this.getOwnerByCurrentAdmin());
        if (StrUtil.isNotBlank((CharSequence)attType)) {
            lambdaQueryWrapper.in(SystemAttachment::getAttType, (Collection)StrUtil.split((CharSequence)attType, (char)','));
        }
        if (ObjectUtil.isNotNull((Object)pid) && pid > 0) {
            lambdaQueryWrapper.eq(SystemAttachment::getPid, (Object)pid);
        }
        lambdaQueryWrapper.orderByDesc(SystemAttachment::getAttId);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public PageInfo<SystemAttachment> findPageList(SystemAttachmentSearchRequest request) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemAttachment::getOwner, (Object)this.getOwnerByCurrentAdmin());
        if (ObjectUtil.isNotNull((Object)request.getPid()) && request.getPid() > 0) {
            lqw.eq(SystemAttachment::getPid, (Object)request.getPid());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getType())) {
            switch (request.getType()) {
                case "image": {
                    lqw.in(SystemAttachment::getAttType, (Collection)StrUtil.split((CharSequence)"jpg,jpeg,gif,png,bmp,PNG,JPG,webp", (char)','));
                    break;
                }
                case "video": {
                    lqw.in(SystemAttachment::getAttType, (Collection)StrUtil.split((CharSequence)"video/mp4,avi,mov,wmv,mkv,flv,rmvb", (char)','));
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            lqw.like(SystemAttachment::getAlias, (Object)URLUtil.decode((String)request.getKeywords()).trim());
        }
        lqw.orderByDesc(SystemAttachment::getAttId);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List attachmentList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)attachmentList);
    }

    @Override
    public String prefixImage(String path) {
        if (path.contains("crmebimage/image")) {
            if (path.contains("crmebimage/public")) {
                path = path.replace("crmebimage/public", this.getCdnUrl() + "/" + "crmebimage" + "/public");
            }
            return path.replace("crmebimage/image", this.getCdnUrl() + "/" + "crmebimage" + "/" + "image");
        }
        return path.replace("crmebimage/", this.getCdnUrl() + "/" + "crmebimage" + "/");
    }

    @Override
    public String prefixUploadf(String path) {
        if (path.contains("crmebimage")) {
            return path.replace("crmebimage/uploadf/", this.getCdnUrl() + "/crmebimage/" + "uploadf" + "/");
        }
        return path.replace("uploadf/", this.getCdnUrl() + "/" + "uploadf" + "/");
    }

    @Override
    public String prefixFile(String path) {
        if (path.contains("downloadf/excel")) {
            String cdnUrl = this.systemConfigService.getValueByKey("localUploadUrl");
            return path.replace("crmebimage/downloadf/", cdnUrl + "/crmebimage/downloadf/");
        }
        return path.replace("crmebimage/file/", this.getCdnUrl() + "/crmebimage/file/");
    }

    @Override
    public String clearPrefix(String path) {
        if (StrUtil.isBlank((CharSequence)path)) {
            return path;
        }
        if (path.contains(this.getCdnUrl() + "/")) {
            if (path.contains("callback/alipay")) {
                return path;
            }
            return path.replace(this.getCdnUrl() + "/", "");
        }
        return path;
    }

    @Override
    public String clearPrefix(String path, String cdnUrl) {
        if (StrUtil.isBlank((CharSequence)path)) {
            return path;
        }
        if (path.contains(cdnUrl + "/")) {
            return path.replace(cdnUrl + "/", "");
        }
        return path;
    }

    @Override
    public Boolean updateAttrId(SystemAttachmentMoveRequest move) {
        LambdaUpdateWrapper lup = new LambdaUpdateWrapper();
        lup.set(SystemAttachment::getPid, (Object)move.getPid());
        lup.in(SystemAttachment::getAttId, (Collection)CrmebUtil.stringToArray((String)move.getAttrId()));
        lup.eq(SystemAttachment::getOwner, (Object)this.getOwnerByCurrentAdmin());
        return this.update((Wrapper)lup);
    }

    @Override
    public String getCdnUrl() {
        String uploadType = this.systemConfigService.getValueByKeyException("uploadType");
        int type = Integer.parseInt(uploadType);
        String uploadUrl = "localUploadUrl";
        switch (type) {
            case 2: {
                uploadUrl = "qnUploadUrl";
                break;
            }
            case 3: {
                uploadUrl = "alUploadUrl";
                break;
            }
            case 4: {
                uploadUrl = "txUploadUrl";
                break;
            }
            case 5: {
                uploadUrl = "jdUploadUrl";
                break;
            }
            case 6: {
                uploadUrl = "hwObsUploadUrl";
                break;
            }
        }
        return this.systemConfigService.getValueByKey(uploadUrl);
    }

    @Override
    public Boolean deleteByIds(List<Integer> idList) {
        Integer owner = this.getOwnerByCurrentAdmin();
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(SystemAttachment::getOwner, (Object)owner);
        wrapper.in(SystemAttachment::getAttId, idList);
        return this.remove((Wrapper)wrapper);
    }

    @Override
    public Boolean updateAlias(SystemAttachmentUpdateNameRequest request) {
        SystemAttachment systemAttachment = this.getByIdException(request.getAttId(), this.getOwnerByCurrentAdmin());
        String alias = URLUtil.decode((String)request.getAlias()).trim();
        if (systemAttachment.getAlias().equals(alias)) {
            return true;
        }
        int dotIndex = alias.lastIndexOf(".");
        String extension = alias.substring(dotIndex + 1);
        String oldExtension = systemAttachment.getName().substring(systemAttachment.getName().lastIndexOf(".") + 1);
        if (!oldExtension.equals(extension)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7d20\u6750\u6587\u4ef6\u62d3\u5c55\u540d\u4e0d\u80fd\u4fee\u6539");
        }
        return this.updateAttachmentAlias(request.getAttId(), alias);
    }

    private Boolean updateAttachmentAlias(Integer attId, String alias) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SystemAttachment::getAlias, (Object)alias);
        wrapper.eq(SystemAttachment::getAttId, (Object)attId);
        return this.update((Wrapper)wrapper);
    }

    private SystemAttachment getByIdException(Integer id, Integer owner) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemAttachment::getAttId, (Object)id);
        lqw.eq(SystemAttachment::getOwner, (Object)owner);
        lqw.last(" limit 1");
        SystemAttachment systemAttachment = (SystemAttachment)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)systemAttachment)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7d20\u6750\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return systemAttachment;
    }

    public Integer getOwnerByCurrentAdmin() {
        SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (currentAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue()) || currentAdmin.getType().equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
            return currentAdmin.getMerId();
        }
        return -1;
    }
}

