/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.seckill.SeckillActivity;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.SeckillActivitySearchRequest;
import com.zbkj.service.dao.SeckillActivityDao;
import com.zbkj.service.service.SeckillActivityService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SeckillActivityServiceImpl
extends ServiceImpl<SeckillActivityDao, SeckillActivity>
implements SeckillActivityService {
    @Resource
    private SeckillActivityDao dao;

    @Override
    public PageInfo<SeckillActivity> getActivityPage(SeckillActivitySearchRequest request, Boolean isMerchant) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            lqw.like(SeckillActivity::getName, (Object)URLUtil.decode((String)request.getName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDate())) {
            lqw.le(SeckillActivity::getStartDate, (Object)request.getDate());
            lqw.ge(SeckillActivity::getEndDate, (Object)request.getDate());
        }
        if (isMerchant.booleanValue()) {
            // empty if block
        }
        lqw.eq(SeckillActivity::getIsDel, (Object)0);
        lqw.orderByDesc(SeckillActivity::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public List<SeckillActivity> findByIdListAndOpen(List<Integer> acvitityIdList, Boolean isOpen) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(SeckillActivity::getId, acvitityIdList);
        if (ObjectUtil.isNotNull((Object)isOpen)) {
            lqw.eq(SeckillActivity::getIsOpen, (Object)isOpen);
        }
        return this.dao.selectList((Wrapper)lqw);
    }
}

