/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.product.ProductTag;
import com.zbkj.common.model.seckill.SeckillProduct;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.producttag.ProductTagSearchRequest;
import com.zbkj.common.response.ProductTagTaskItem;
import com.zbkj.common.response.ProductTagsFrontResponse;
import com.zbkj.common.response.productTag.ProductTagsForSearchResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.service.dao.OrderDao;
import com.zbkj.service.dao.OrderDetailDao;
import com.zbkj.service.dao.ProductTagDao;
import com.zbkj.service.dao.SeckillProductDao;
import com.zbkj.service.service.ProductTagService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductTagServiceImpl
extends ServiceImpl<ProductTagDao, ProductTag>
implements ProductTagService {
    private final Logger LOGGER = LoggerFactory.getLogger(ProductTagService.class);
    @Autowired
    CrmebConfig crmebConfig;
    @Resource
    private ProductTagDao dao;
    @Resource
    private OrderDao orderdao;
    @Resource
    private OrderDetailDao orderDetailDao;
    @Resource
    private SeckillProductDao seckillProductDao;

    @Override
    public List<ProductTag> getList(ProductTagSearchRequest request, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            lambdaQueryWrapper.like(ProductTag::getTagName, (Object)URLUtil.decode((String)request.getKeywords()));
        }
        lambdaQueryWrapper.orderByDesc(ProductTag::getSort);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean editProductTag(ProductTag productTag) {
        List otherNameSeam;
        List seamTagNameList;
        List<ProductTag> exitProductTags = this.checkTagNameOnlyOne(productTag);
        if (CollUtil.isNotEmpty(exitProductTags) && CollUtil.isNotEmpty(seamTagNameList = exitProductTags.stream().filter(tag -> tag.getTagName().equals(productTag.getTagName())).collect(Collectors.toList())) && CollUtil.isNotEmpty(otherNameSeam = seamTagNameList.stream().filter(tag -> !tag.getId().equals(productTag.getId())).collect(Collectors.toList()))) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6807\u7b7e\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        this.checkProductTagStatusOnLimit(productTag, productTag.getStatus(), Boolean.TRUE);
        ProductTag forProductTagUpdate = new ProductTag();
        forProductTagUpdate.setId(productTag.getId());
        forProductTagUpdate.setPosition(productTag.getPosition());
        forProductTagUpdate.setPlayProducts(productTag.getPlayProducts());
        forProductTagUpdate.setSort(productTag.getSort());
        forProductTagUpdate.setStatus(productTag.getStatus());
        forProductTagUpdate.setStartTime(productTag.getStartTime());
        forProductTagUpdate.setEndTime(productTag.getEndTime());
        if (productTag.getOwner() > 0) {
            forProductTagUpdate.setTagName(productTag.getTagName());
            forProductTagUpdate.setTagNote(productTag.getTagNote());
        }
        productTag.setUpdateTime((Date)DateUtil.date());
        return this.updateById(productTag);
    }

    @Override
    public Boolean saveProductTag(ProductTag productTag) {
        List<ProductTag> exitProductTags = this.checkTagNameOnlyOne(productTag);
        if (CollUtil.isNotEmpty(exitProductTags)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6807\u7b7e\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        this.checkProductTagStatusOnLimit(productTag, productTag.getStatus(), Boolean.FALSE);
        return this.dao.insert(productTag) > 0;
    }

    @Override
    public Boolean updateStatus(Integer id, Integer status) {
        this.checkProductTagStatusOnLimit((ProductTag)this.getById(id), status, Boolean.FALSE);
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(ProductTag::getId, (Object)id);
        updateWrapper.set(ProductTag::getStatus, (Object)status);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Boolean deleteProductTag(Integer id) {
        ProductTag productTagForDelete = (ProductTag)this.getById(id);
        if (null == productTagForDelete || ObjectUtil.isNull((Object)productTagForDelete.getId())) {
            return Boolean.TRUE;
        }
        if (productTagForDelete.getOwner().equals(0)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5e73\u53f0\u5185\u7f6e\u5546\u54c1\u6807\u7b7e\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        if (productTagForDelete.getStatus() == 1) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_TAG_STATUS_TRUE);
        }
        return this.removeById(id);
    }

    @Override
    public ProductTagsFrontResponse setProductTagByProductTagsRules(Integer productId, Integer brandId, Integer merId, Integer cateId, ProductTagsFrontResponse productTagsResponse) {
        String selfProductTagsString;
        List selfProductList;
        Map<Integer, String> productTags = this.getProductTags();
        ProductTagsFrontResponse tagsFront = new ProductTagsFrontResponse();
        if (productTags.containsKey(productId)) {
            List items = JSON.parseArray((String)productTags.get(productId), ProductTagTaskItem.class);
            for (ProductTagTaskItem item : items) {
                ProductTagServiceImpl.setProductTags(item, tagsFront);
            }
        }
        if (ObjectUtil.isNotNull((Object)(selfProductList = JSON.parseArray((String)(selfProductTagsString = productTags.get(0)), ProductTag.class))) && !selfProductList.isEmpty()) {
            for (ProductTag productTag : selfProductList) {
                ProductTagsFrontResponse selfTag = tagsFront;
                List leftItems = tagsFront.getLocationLeftTitle();
                List underItems = tagsFront.getLocationUnderTitle();
                if (!leftItems.isEmpty() && underItems.size() >= 3) {
                    return productTagsResponse;
                }
                switch (productTag.getPlayType()) {
                    case "product": {
                        ProductTagServiceImpl.setProductTagForSelfTagConfig(productTag, leftItems, underItems, selfTag, productId);
                        break;
                    }
                    case "brand": {
                        ProductTagServiceImpl.setProductTagForSelfTagConfig(productTag, leftItems, underItems, selfTag, brandId);
                        break;
                    }
                    case "merchant": {
                        ProductTagServiceImpl.setProductTagForSelfTagConfig(productTag, leftItems, underItems, selfTag, merId);
                        break;
                    }
                    case "category": {
                        ProductTagServiceImpl.setProductTagForSelfTagConfig(productTag, leftItems, underItems, selfTag, cateId);
                    }
                }
            }
        }
        return tagsFront;
    }

    @Override
    public List<ProductTag> getStatusOnProductTagList() {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(ProductTag::getStatus, (Object)1);
        List<ProductTag> productTags = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        productTags = productTags.stream().filter(item -> item.getStartTime().compareTo(CrmebDateUtil.nowDateTime()) <= 0 && item.getEndTime().compareTo(CrmebDateUtil.nowDateTime()) > 0).collect(Collectors.toList());
        return productTags;
    }

    @Override
    public ProductTagsForSearchResponse getProductIdListByProductTagId(Integer tagId) {
        ProductTag currentTag = (ProductTag)this.getById(tagId);
        ProductTagsForSearchResponse searchResponse = new ProductTagsForSearchResponse();
        if (currentTag.getOwner().equals(0)) {
            Map<Integer, String> productTags = this.getProductTags();
            for (Map.Entry<Integer, String> entry : productTags.entrySet()) {
                List productTagTaskItems = JSON.parseArray((String)entry.getValue(), ProductTagTaskItem.class);
                List isSeamTagList = productTagTaskItems.stream().filter(item -> item.getTagName().equals(currentTag.getTagName())).collect(Collectors.toList());
                List isConformProductIdList = isSeamTagList.stream().map(ProductTagTaskItem::getId).collect(Collectors.toList());
                searchResponse.getProductIds().addAll(isConformProductIdList);
            }
        }
        if (currentTag.getOwner().equals(1)) {
            switch (currentTag.getPlayType()) {
                case "product": {
                    searchResponse.getProductIds().addAll(Arrays.stream(currentTag.getPlayProducts().split(",")).map(Integer::parseInt).collect(Collectors.toList()));
                    break;
                }
                case "brand": {
                    searchResponse.setBrandId(Arrays.stream(currentTag.getPlayProducts().split(",")).map(Integer::valueOf).collect(Collectors.toList()));
                    break;
                }
                case "merchant": {
                    searchResponse.setMerId(Arrays.stream(currentTag.getPlayProducts().split(",")).map(Integer::valueOf).collect(Collectors.toList()));
                    break;
                }
                case "category": {
                    searchResponse.setCategoryId(Arrays.stream(currentTag.getPlayProducts().split(",")).map(Integer::valueOf).collect(Collectors.toList()));
                }
            }
        }
        return searchResponse;
    }

    private Map<Integer, String> getProductTags() {
        HashMap<Integer, String> cacheProductTags = new HashMap<Integer, String>();
        HashMap<Integer, List<ProductTagTaskItem>> cacheProduct = new HashMap<Integer, List<ProductTagTaskItem>>();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(ProductTag::getStatus, (Object)1);
        lambdaQueryWrapper.eq(ProductTag::getOwner, (Object)0);
        lambdaQueryWrapper.orderByDesc(ProductTag::getSort);
        List systemIsShowDefaultProductTags = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        systemIsShowDefaultProductTags = systemIsShowDefaultProductTags.stream().filter(item -> item.getStartTime().compareTo(CrmebDateUtil.nowDateTime()) <= 0 && item.getEndTime().compareTo(CrmebDateUtil.nowDateTime()) > 0).collect(Collectors.toList());
        for (ProductTag productTag : systemIsShowDefaultProductTags) {
            List<ProductTagTaskItem> boomGoods;
            if ("\u65b0\u54c1".equals(productTag.getTagName())) {
                boomGoods = this.calcProductTagForNewGoodsByOptionUnit(Integer.valueOf(productTag.getPlayProducts()));
                ProductTagServiceImpl.setProductTagsItemAndSored(productTag, boomGoods, cacheProduct);
            }
            if ("\u7206\u54c1".equals(productTag.getTagName())) {
                boomGoods = this.calcProductTagForLastThirtyDaysSalesByOptionUnitByJava(Integer.valueOf(productTag.getPlayProducts()));
                ProductTagServiceImpl.setProductTagsItemAndSored(productTag, boomGoods, cacheProduct);
            }
            if ("\u81ea\u8425".equals(productTag.getTagName())) {
                List<ProductTagTaskItem> selfOperated = this.calcProductTagForMerchantIsSelf();
                ProductTagServiceImpl.setProductTagsItemAndSored(productTag, selfOperated, cacheProduct);
            }
            if ("\u70ed\u5356".equals(productTag.getTagName())) {
                List<ProductTagTaskItem> hotSaleGoods = this.calcProductTagForLastThirtyDaysReplyCountByOptionUnit(Integer.valueOf(productTag.getPlayProducts()));
                ProductTagServiceImpl.setProductTagsItemAndSored(productTag, hotSaleGoods, cacheProduct);
            }
            if ("\u4f18\u9009".equals(productTag.getTagName())) {
                List<ProductTagTaskItem> preferredGoods = this.calcProductTagForLastThirtyDaysReplyFiveStartByOptionUnit(Integer.valueOf(productTag.getPlayProducts()));
                ProductTagServiceImpl.setProductTagsItemAndSored(productTag, preferredGoods, cacheProduct);
            }
            if (!"\u5305\u90ae".equals(productTag.getTagName())) continue;
            List<ProductTagTaskItem> freeShippingGoods = this.calcProductTagForFreeDelivery();
            ProductTagServiceImpl.setProductTagsItemAndSored(productTag, freeShippingGoods, cacheProduct);
        }
        LambdaQueryWrapper getTagForSelfConfig = Wrappers.lambdaQuery();
        getTagForSelfConfig.eq(ProductTag::getStatus, (Object)1);
        getTagForSelfConfig.eq(ProductTag::getOwner, (Object)1);
        List productTagsForSelf = this.dao.selectList((Wrapper)getTagForSelfConfig);
        if (!productTagsForSelf.isEmpty()) {
            List selfEffProductList = productTagsForSelf.stream().filter(item -> item.getStartTime().compareTo(CrmebDateUtil.nowDateTime()) <= 0 && item.getEndTime().compareTo(CrmebDateUtil.nowDateTime()) > 0).collect(Collectors.toList());
            cacheProductTags.put(0, JSON.toJSONString(selfEffProductList));
        }
        for (Map.Entry entry : cacheProduct.entrySet()) {
            cacheProductTags.put((Integer)entry.getKey(), JSON.toJSONString(entry.getValue()));
        }
        return cacheProductTags;
    }

    private static void setProductTagsItemAndSored(ProductTag productTag, List<ProductTagTaskItem> items, Map<Integer, List<ProductTagTaskItem>> cacheProduct) {
        for (ProductTagTaskItem item : items) {
            if (ObjectUtil.isNotNull(cacheProduct.get(item.getId())) && cacheProduct.get(item.getId()).size() >= 4) continue;
            item.setSort(productTag.getSort().intValue());
            item.setPosition(productTag.getPosition().intValue());
            item.setTagName(productTag.getTagName());
            if (cacheProduct.containsKey(item.getId())) {
                cacheProduct.get(item.getId()).add(item);
            } else {
                ArrayList<ProductTagTaskItem> tagResponse = new ArrayList<ProductTagTaskItem>();
                item.setPosition(productTag.getPosition().intValue());
                item.setTagName(productTag.getTagName());
                tagResponse.add(item);
                cacheProduct.put(item.getId(), tagResponse);
            }
            cacheProduct.get(item.getId()).sort(Comparator.comparingInt(ProductTagTaskItem::getSort).reversed());
        }
    }

    private static void setProductTagForSelfTagConfig(ProductTag productTag, List<ProductTagTaskItem> leftItems, List<ProductTagTaskItem> underItems, ProductTagsFrontResponse selfTag, Integer playTypeConfig) {
        for (String s : productTag.getPlayProducts().split(",")) {
            if (!Integer.valueOf(s).equals(playTypeConfig)) continue;
            ProductTagTaskItem tagTaskItem = new ProductTagTaskItem();
            tagTaskItem.setTagName(productTag.getTagName());
            tagTaskItem.setSort(productTag.getSort().intValue());
            tagTaskItem.setId(productTag.getId().intValue());
            tagTaskItem.setPosition(productTag.getPosition().intValue());
            if (productTag.getPosition().equals(1)) {
                leftItems.add(tagTaskItem);
                leftItems = leftItems.stream().sorted(Comparator.comparing(ProductTagTaskItem::getSort).reversed()).collect(Collectors.toList());
                selfTag.setLocationLeftTitle(leftItems);
                continue;
            }
            underItems.add(tagTaskItem);
            underItems = underItems.stream().sorted(Comparator.comparing(ProductTagTaskItem::getSort).reversed()).collect(Collectors.toList());
            selfTag.setLocationUnderTitle(underItems);
        }
    }

    private static ProductTagsFrontResponse setProductTags(ProductTagTaskItem item, ProductTagsFrontResponse tagsFront) {
        if (ObjectUtil.isNotNull((Object)item)) {
            List tags = null;
            if (item.getPosition() == 0) {
                tags = tagsFront.getLocationUnderTitle();
                tags.sort(Comparator.comparingInt(ProductTagTaskItem::getSort));
                tags.add(item);
                tagsFront.setLocationUnderTitle(tags);
            } else if (item.getPosition() == 1) {
                tags = tagsFront.getLocationLeftTitle();
                tags.add(item);
                tags.sort(Comparator.comparingInt(ProductTagTaskItem::getSort));
                tagsFront.setLocationLeftTitle(tags);
            }
            return tagsFront;
        }
        return tagsFront;
    }

    private void checkProductTagStatusOnLimit(ProductTag productTag, Integer status, Boolean isEdit) {
        if (1 == status) {
            List currentTags;
            if (productTag.getEndTime().compareTo(new Date()) < 0) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6807\u7b7e\u5f00\u542f\uff0c\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
            }
            List<ProductTag> effProductTags = this.getStatusOnProductTagList();
            if (isEdit != false ? (currentTags = effProductTags.stream().filter(tag -> tag.getId().equals(productTag.getId())).collect(Collectors.toList())).isEmpty() && effProductTags.size() >= 5 : effProductTags.size() >= 5) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6807\u7b7e\u540c\u65f6\u5f00\u542f\u7684\u4e0d\u5f97\u8d85\u8fc75\u6761");
            }
        }
    }

    private List<ProductTagTaskItem> calcProductTagForLastThirtyDaysSalesByOptionUnitByJava(Integer unit) {
        List secKillIds;
        List<Object> itemList = new ArrayList<ProductTagTaskItem>();
        LambdaQueryWrapper lqr_Order = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lqr_Order.ge(Order::getLevel, (Object)1)).eq(Order::getPaid, (Object)1)).gt(Order::getPayTime, (Object)LocalDate.now().minusDays(30L).toString());
        List orders = this.orderdao.selectList((Wrapper)lqr_Order);
        if (CollUtil.isEmpty((Collection)orders)) {
            return itemList;
        }
        LambdaQueryWrapper lqr_OrderDetail = Wrappers.lambdaQuery();
        lqr_OrderDetail.in(OrderDetail::getOrderNo, (Collection)orders.stream().map(Order::getOrderNo).collect(Collectors.toList()));
        List orderDetails = this.orderDetailDao.selectList((Wrapper)lqr_OrderDetail);
        if (CollUtil.isEmpty((Collection)orderDetails)) {
            return itemList;
        }
        List OrderDetailIsSkillProduct = orderDetails.stream().filter(orderDetail -> orderDetail.getProductMarketingType().equals(ProductConstants.PRODUCT_MARKETING_TYPE_SECKILL)).collect(Collectors.toList());
        if (!OrderDetailIsSkillProduct.isEmpty() && !(secKillIds = OrderDetailIsSkillProduct.stream().map(OrderDetail::getProductId).distinct().collect(Collectors.toList())).isEmpty()) {
            LambdaQueryWrapper lqr_secKill = Wrappers.lambdaQuery();
            lqr_secKill.in(SeckillProduct::getId, secKillIds);
            List seckillProducts = this.seckillProductDao.selectList((Wrapper)lqr_secKill);
            block0: for (OrderDetail orderDetail2 : orderDetails) {
                List seckillPs = seckillProducts.stream().filter(seckillProduct -> orderDetail2.getProductId().equals(seckillProduct.getId())).collect(Collectors.toList());
                for (SeckillProduct seckillP : seckillPs) {
                    if (!orderDetail2.getProductMarketingType().equals(ProductConstants.PRODUCT_MARKETING_TYPE_SECKILL) || !seckillP.getId().equals(orderDetail2.getProductId())) continue;
                    orderDetail2.setProductId(seckillP.getProductId());
                    continue block0;
                }
            }
        }
        HashMap<Integer, ProductTagTaskItem> itemList_temp = new HashMap<Integer, ProductTagTaskItem>();
        for (OrderDetail orderDetail3 : orderDetails) {
            ProductTagTaskItem item = (ProductTagTaskItem)itemList_temp.get(orderDetail3.getProductId());
            if (null != item && item.getId() > 0) {
                item.setFlag(item.getFlag() + orderDetail3.getPayNum());
                continue;
            }
            ProductTagTaskItem tagTaskItem = new ProductTagTaskItem();
            tagTaskItem.setFlag(orderDetail3.getPayNum().intValue());
            tagTaskItem.setTagName("\u7206\u54c1");
            tagTaskItem.setId(orderDetail3.getProductId().intValue());
            itemList_temp.put(tagTaskItem.getId(), tagTaskItem);
        }
        for (Integer id : itemList_temp.keySet()) {
            itemList.add((ProductTagTaskItem)itemList_temp.get(id));
        }
        itemList = itemList.stream().filter(tag -> tag.getFlag() > unit).collect(Collectors.toList());
        return itemList;
    }

    private List<ProductTagTaskItem> calcProductTagForMerchantIsSelf() {
        return this.dao.calcProductTagForIsSelf();
    }

    private List<ProductTagTaskItem> calcProductTagForLastThirtyDaysReplyCountByOptionUnit(Integer unit) {
        HashMap<String, Object> prams = new HashMap<String, Object>();
        prams.put("unit", unit);
        return this.dao.calcProductTagForReplayCount(prams);
    }

    private List<ProductTagTaskItem> calcProductTagForLastThirtyDaysReplyFiveStartByOptionUnit(Integer unit) {
        HashMap<String, Object> prams = new HashMap<String, Object>();
        prams.put("unit", unit);
        return this.dao.calcProductTagForFiveStart(prams);
    }

    private List<ProductTagTaskItem> calcProductTagForNewGoodsByOptionUnit(Integer unit) {
        HashMap<String, Object> prams = new HashMap<String, Object>();
        prams.put("unit", unit);
        return this.dao.calcProductTagForNewGoods(prams);
    }

    private List<ProductTagTaskItem> calcProductTagForFreeDelivery() {
        return this.dao.calcProductTagForFreeDelivery();
    }

    private List<ProductTag> checkTagNameOnlyOne(ProductTag productTag) {
        LambdaQueryWrapper queryForTagNameOnlyOne = Wrappers.lambdaQuery();
        queryForTagNameOnlyOne.eq(ProductTag::getTagName, (Object)productTag.getTagName());
        return this.dao.selectList((Wrapper)queryForTagNameOnlyOne);
    }
}

