/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderV3Request;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryV3Result;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.AlipayConfig;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.constants.BillConstants;
import com.zbkj.common.constants.BrokerageRecordConstants;
import com.zbkj.common.constants.IntegralRecordConstants;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.constants.WorkOrderConstants;
import com.zbkj.common.dto.Location;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.alipay.AliPayInfo;
import com.zbkj.common.model.bill.Bill;
import com.zbkj.common.model.bill.MerchantBill;
import com.zbkj.common.model.coupon.CouponUser;
import com.zbkj.common.model.member.PaidMemberOrder;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantBalanceRecord;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.OrderProfitSharing;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.product.ProductCoupon;
import com.zbkj.common.model.reservation.ReservationWorkOrder;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.model.user.UserBrokerageRecord;
import com.zbkj.common.model.user.UserIntegralRecord;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.model.wechat.WechatPayInfo;
import com.zbkj.common.request.OrderPayRequest;
import com.zbkj.common.request.WechatPaymentQueryRequest;
import com.zbkj.common.response.CashierInfoResponse;
import com.zbkj.common.response.OrderPayResultResponse;
import com.zbkj.common.response.PayConfigResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.MemberResultCode;
import com.zbkj.common.result.OrderResultCode;
import com.zbkj.common.result.UserResultCode;
import com.zbkj.common.utils.AddressUtil;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.common.vo.AttachVo;
import com.zbkj.common.vo.CreateOrderH5SceneInfoDetailVo;
import com.zbkj.common.vo.CreateOrderH5SceneInfoVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.WxPayJsResultVo;
import com.zbkj.service.service.AliPayInfoService;
import com.zbkj.service.service.AliPayService;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.BillService;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.MerchantBalanceRecordService;
import com.zbkj.service.service.MerchantBillService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantPrintService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderFlowRecordService;
import com.zbkj.service.service.OrderProfitSharingService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.PaidMemberOrderService;
import com.zbkj.service.service.PayService;
import com.zbkj.service.service.ProductCouponService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.ReservationWorkOrderService;
import com.zbkj.service.service.SmsService;
import com.zbkj.service.service.SystemAdminService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.TemplateMessageService;
import com.zbkj.service.service.UserBalanceRecordService;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserIntegralRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.WechatPayInfoService;
import com.zbkj.service.service.WechatPayService;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PayServiceImpl
implements PayService {
    private static final Logger logger = LoggerFactory.getLogger(PayServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private WechatPayInfoService wechatPayInfoService;
    @Autowired
    private AliPayService aliPayService;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private UserIntegralRecordService userIntegralRecordService;
    @Autowired
    private SystemNotificationService systemNotificationService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private TemplateMessageService templateMessageService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private ProductCouponService productCouponService;
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private UserBrokerageRecordService userBrokerageRecordService;
    @Autowired
    private UserBalanceRecordService userBalanceRecordService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private MerchantBillService merchantBillService;
    @Autowired
    private OrderProfitSharingService orderProfitSharingService;
    @Autowired
    private BillService billService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private AliPayInfoService aliPayInfoService;
    @Autowired
    private RechargeOrderService rechargeOrderService;
    @Autowired
    private MerchantBalanceRecordService merchantBalanceRecordService;
    @Autowired
    private MerchantPrintService merchantPrintService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private SystemAdminService systemAdminService;
    @Autowired
    private PaidMemberOrderService paidMemberOrderService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private WechatPayService wechatPayService;
    @Autowired
    private ReservationWorkOrderService reservationWorkOrderService;
    @Autowired
    private OrderFlowRecordService orderFlowRecordService;

    @Override
    public PayConfigResponse getPayConfig() {
        String payWxOpen = this.systemConfigService.getValueByKey("pay_weixin_open");
        String yuePayStatus = this.systemConfigService.getValueByKey("yue_pay_status");
        String aliPayStatus = this.systemConfigService.getValueByKey("ali_pay_status");
        PayConfigResponse response = new PayConfigResponse();
        response.setYuePayStatus(Boolean.valueOf("'1'".equals(yuePayStatus)));
        response.setPayWechatOpen(Boolean.valueOf("'1'".equals(payWxOpen)));
        response.setAliPayStatus(Boolean.valueOf("'1'".equals(aliPayStatus)));
        if ("'1'".equals(yuePayStatus)) {
            User user = this.userService.getInfo();
            response.setUserBalance(user.getNowMoney());
        }
        return response;
    }

    @Override
    public OrderPayResultResponse payment(OrderPayRequest orderPayRequest) {
        DateTime cancelTime;
        Order order = this.orderService.getByOrderNo(orderPayRequest.getOrderNo());
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_CANCEL);
        }
        if (order.getPaid().booleanValue()) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_PAID);
        }
        if (order.getStatus() > OrderConstants.ORDER_STATUS_WAIT_PAY) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_STATUS_ABNORMAL);
        }
        User user = this.userService.getInfo();
        order.setPayType(orderPayRequest.getPayType());
        order.setPayChannel(orderPayRequest.getPayChannel());
        if (this.redisUtil.exists((String)this.redisUtil.get(StrUtil.format((CharSequence)"ORDER-EXPIRATION-TIME:{}", (Object[])new Object[]{order.getOrderNo()}))).booleanValue()) {
            String expireTime = (String)this.redisUtil.get(StrUtil.format((CharSequence)"ORDER-EXPIRATION-TIME:{}", (Object[])new Object[]{order.getOrderNo()}));
            cancelTime = DateUtil.parseDateTime((String)expireTime);
        } else {
            cancelTime = DateUtil.offset((Date)order.getCreateTime(), (DateField)DateField.MINUTE, (int)this.crmebConfig.getOrderCancelTime());
        }
        long between = DateUtil.between((Date)cancelTime, (Date)DateUtil.date(), (DateUnit)DateUnit.SECOND, (boolean)false);
        if (between > 0L) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8ba2\u5355\u5df2\u8fc7\u671f");
        }
        if (orderPayRequest.getPayType().equals("yue") && user.getNowMoney().compareTo(order.getPayPrice()) < 0) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_BALANCE_INSUFFICIENT);
        }
        OrderPayResultResponse response = new OrderPayResultResponse();
        response.setOrderNo(order.getOrderNo());
        response.setPayType(order.getPayType());
        response.setPayChannel(order.getPayChannel());
        if (!order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_INTEGRAL) && order.getPayPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4f4e\u4e8e\u7b49\u4e8e0\u5143");
        }
        if (order.getPayType().equals("yue") || order.getPayPrice().compareTo(BigDecimal.ZERO) <= 0) {
            Boolean yueBoolean = this.yuePay(order, user);
            response.setStatus(yueBoolean);
            return response;
        }
        if (order.getPayChannel().equals("video")) {
            return response;
        }
        if (order.getPayType().equals("weixin")) {
            WxPayJsResultVo vo = this.wechatPayment(order);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
            response.setStatus(Boolean.valueOf(true));
            response.setJsConfig(vo);
            return response;
        }
        if (order.getPayType().equals("alipay")) {
            String result = this.aliPayment(order);
            order.setOutTradeNo(order.getOrderNo());
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
            response.setStatus(Boolean.valueOf(true));
            response.setAlipayRequest(result);
            return response;
        }
        response.setStatus(Boolean.valueOf(false));
        return response;
    }

    @Override
    public Boolean queryWechatPayResult(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_CANCEL);
        }
        if (!order.getPayType().equals("weixin")) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0d\u662f\u5fae\u4fe1\u652f\u4ed8\u7c7b\u578b\u8ba2\u5355");
        }
        if (order.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(order.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u672a\u627e\u5230\u5bf9\u5e94\u5fae\u4fe1\u8ba2\u5355");
        }
        String paySource = this.getWechatPaySource(order.getPayChannel());
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayOrderQueryResult queryResult = this.wechatPayService.queryOrder(order.getOutTradeNo(), paySource);
            if (!queryResult.getTradeState().equals("SUCCESS")) {
                return Boolean.FALSE;
            }
            wechatPayInfo.setIsSubscribe(queryResult.getIsSubscribe());
            wechatPayInfo.setTradeState(queryResult.getTradeState());
            wechatPayInfo.setBankType(queryResult.getBankType());
            wechatPayInfo.setCashFee(queryResult.getCashFee());
            wechatPayInfo.setCouponFee(queryResult.getCouponFee());
            wechatPayInfo.setTransactionId(queryResult.getTransactionId());
            wechatPayInfo.setTimeEnd(queryResult.getTimeEnd());
            wechatPayInfo.setTradeStateDesc(queryResult.getTradeStateDesc());
        } else {
            WxPayOrderQueryV3Result queryV3Result = this.wechatPayService.queryOrderV3(order.getOutTradeNo(), paySource);
            if (!queryV3Result.getTradeState().equals("SUCCESS")) {
                return Boolean.FALSE;
            }
            wechatPayInfo.setTradeState(queryV3Result.getTradeState());
            wechatPayInfo.setBankType(queryV3Result.getBankType());
            wechatPayInfo.setTransactionId(queryV3Result.getTransactionId());
            wechatPayInfo.setTimeEnd(queryV3Result.getSuccessTime());
            wechatPayInfo.setTradeStateDesc(queryV3Result.getTradeStateDesc());
        }
        Boolean updatePaid = (Boolean)this.transactionTemplate.execute(e -> {
            this.orderService.updatePaid(orderNo);
            this.wechatPayInfoService.updateById(wechatPayInfo);
            return Boolean.TRUE;
        });
        if (!updatePaid.booleanValue()) {
            throw new CrmebException("\u652f\u4ed8\u6210\u529f\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return Boolean.TRUE;
    }

    private String getWechatPaySource(String payChannel) {
        String source;
        String paySource = payChannel.equals("h5") || payChannel.equals("native") ? (StrUtil.isNotBlank((CharSequence)(source = this.systemConfigService.getValueByKey("wechat_pay_source"))) && source.equals("mini") ? "mini" : "public") : payChannel;
        return paySource;
    }

    @Override
    public Boolean queryAliPayResult(String orderNo) {
        String decode;
        AliPayInfo aliPayInfo = this.aliPayInfoService.getByOutTradeNo(orderNo);
        if (ObjectUtil.isNull((Object)aliPayInfo)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u652f\u4ed8\u5b9d\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String passbackParams = aliPayInfo.getPassbackParams();
        if (StrUtil.isBlank((CharSequence)passbackParams)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u672a\u77e5\u7684\u652f\u4ed8\u5b9d\u8ba2\u5355\u7c7b\u578b");
        }
        try {
            decode = URLDecoder.decode(passbackParams, "utf-8");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            throw new CrmebException("ali pay query error : \u8ba2\u5355\u652f\u4ed8\u7c7b\u578b\u89e3\u7801\u5931\u8d25==\u300b" + orderNo);
        }
        String[] split = decode.split("=");
        String orderType = split[1];
        if ("recharge".equals(orderType)) {
            RechargeOrder rechargeOrder = this.rechargeOrderService.getByOutTradeNo(orderNo);
            if (ObjectUtil.isNull((Object)rechargeOrder)) {
                throw new CrmebException(StrUtil.format((CharSequence)"ali pay query error : \u5145\u503c\u8ba2\u5355\u540e\u7f6e\u5904\u7406\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\uff0c\u652f\u4ed8\u670d\u52a1\u65b9\u8ba2\u5355\u53f7\uff1a{}", (Object[])new Object[]{orderNo}));
            }
            if (rechargeOrder.getPaid().booleanValue()) {
                return Boolean.TRUE;
            }
            this.aliPayQuery(orderNo);
            Boolean rechargePayAfter = this.rechargeOrderService.paySuccessAfter(rechargeOrder);
            if (!rechargePayAfter.booleanValue()) {
                throw new CrmebException(StrUtil.format((CharSequence)("ali pay recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + orderNo), (Object[])new Object[0]));
            }
            return Boolean.TRUE;
        }
        if ("svip".equals(orderType)) {
            PaidMemberOrder paidMemberOrder = this.paidMemberOrderService.getByOutTradeNo(orderNo);
            if (ObjectUtil.isNull((Object)paidMemberOrder)) {
                throw new CrmebException(StrUtil.format((CharSequence)"ali pay query error : SVIP\u8ba2\u5355\u540e\u7f6e\u5904\u7406\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\uff0c\u652f\u4ed8\u670d\u52a1\u65b9\u8ba2\u5355\u53f7\uff1a{}", (Object[])new Object[]{orderNo}));
            }
            if (paidMemberOrder.getPaid().booleanValue()) {
                return Boolean.TRUE;
            }
            this.aliPayQuery(orderNo);
            Boolean svipPayAfter = this.paidMemberOrderService.paySuccessAfter(paidMemberOrder);
            if (!svipPayAfter.booleanValue()) {
                logger.error("ali pay svip pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + paidMemberOrder);
                throw new CrmebException(StrUtil.format((CharSequence)("ali pay svip pay after error : \u6570\u636e\u5904\u7406\u5931\u8d25==\u300b" + orderNo), (Object[])new Object[0]));
            }
            return Boolean.TRUE;
        }
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_CANCEL);
        }
        if (!order.getPayType().equals("alipay")) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0d\u662f\u652f\u4ed8\u5b9d\u652f\u4ed8\u7c7b\u578b\u8ba2\u5355");
        }
        if (order.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        this.aliPayQuery(orderNo);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean updatePaid = this.orderService.updatePaid(orderNo);
            if (!updatePaid.booleanValue()) {
                logger.error("\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u72b6\u6001\uff0c\u5546\u54c1\u8ba2\u5355\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff0corderNo = {}", (Object)orderNo);
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u652f\u4ed8\u6210\u529f\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return Boolean.TRUE;
    }

    private AlipayTradeQueryResponse aliPayQuery(String orderNo) {
        String aliPayAppid = this.systemConfigService.getValueByKey(AlipayConfig.APPID);
        String aliPayPrivateKey = this.systemConfigService.getValueByKey(AlipayConfig.RSA_PRIVATE_KEY);
        String aliPayPublicKey = this.systemConfigService.getValueByKey(AlipayConfig.ALIPAY_PUBLIC_KEY);
        String aliPayPublicKey2 = this.systemConfigService.getValueByKey(AlipayConfig.ALIPAY_PUBLIC_KEY_2);
        DefaultAlipayClient client = new DefaultAlipayClient(AlipayConfig.URL, aliPayAppid, aliPayPrivateKey, AlipayConfig.FORMAT, AlipayConfig.CHARSET, aliPayPublicKey2, AlipayConfig.SIGNTYPE);
        AlipayTradeQueryRequest alipay_request = new AlipayTradeQueryRequest();
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(orderNo);
        alipay_request.setBizModel((AlipayObject)model);
        AlipayTradeQueryResponse alipay_response = null;
        try {
            alipay_response = (AlipayTradeQueryResponse)client.execute((AlipayRequest)alipay_request);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            logger.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u67e5\u8be2\u5f02\u5e38\uff0c" + e.getMessage());
            throw new CrmebException("\u652f\u4ed8\u5b9d\u652f\u4ed8\u67e5\u8be2\u5f02\u5e38");
        }
        if (ObjectUtil.isNull((Object)alipay_response)) {
            logger.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38,\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            throw new CrmebException("\u652f\u4ed8\u5b9d\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38,\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)alipay_response.getTradeStatus()) || !alipay_response.getTradeStatus().equals("TRADE_SUCCESS")) {
            logger.error("\u652f\u4ed8\u5b9d\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38\uff0ctradeStatus = " + alipay_response.getTradeStatus());
            throw new CrmebException("\u652f\u4ed8\u5b9d\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38");
        }
        return alipay_response;
    }

    @Override
    public Boolean payAfterProcessingTemp(String orderNo) {
        Order platOrder = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)platOrder)) {
            logger.error("OrderTaskServiceImpl.orderPaySuccessAfter | \u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderNo: {}", (Object)orderNo);
            throw new CrmebException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderNo: " + orderNo);
        }
        User user = (User)this.userService.getById(platOrder.getUid());
        List<Order> orderList = this.orderService.getByPlatOrderNo(platOrder.getOrderNo());
        if (CollUtil.isEmpty(orderList)) {
            logger.error("OrderTaskServiceImpl.orderPaySuccessAfter | \u5546\u6237\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728,orderNo: {}", (Object)orderNo);
            throw new CrmebException("\u5546\u6237\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff0corderNo: " + orderNo);
        }
        ArrayList integralList = CollUtil.newArrayList((Object[])new UserIntegralRecord[0]);
        ArrayList brokerageRecordList = CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        ArrayList profitSharingList = CollUtil.newArrayList((Object[])new OrderProfitSharing[0]);
        ArrayList merchantBillList = CollUtil.newArrayList((Object[])new MerchantBill[0]);
        ArrayList billList = CollUtil.newArrayList((Object[])new Bill[0]);
        ArrayList merchantOrderList = CollUtil.newArrayList((Object[])new MerchantOrder[0]);
        ArrayList merchantOrderListForPrint = CollUtil.newArrayList((Object[])new MerchantOrder[0]);
        ArrayList orderDetailList = CollUtil.newArrayList((Object[])new OrderDetail[0]);
        ArrayList<ReservationWorkOrder> workOrderList = new ArrayList<ReservationWorkOrder>();
        for (Order order2 : orderList) {
            List<OrderDetail> merOrderDetailList;
            List<UserBrokerageRecord> broRecordList;
            MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(order2.getOrderNo());
            if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_EXPRESS)) {
                merchantOrderListForPrint.add(merchantOrder);
            }
            if (order2.getGainIntegral() > 0) {
                UserIntegralRecord integralRecord = this.integralRecordGainInit(user.getId(), order2.getOrderNo(), order2.getGainIntegral());
                integralList.add(integralRecord);
            }
            if (CollUtil.isNotEmpty(broRecordList = this.assignCommission(merchantOrder, merOrderDetailList = this.orderDetailService.getByOrderNo(order2.getOrderNo())))) {
                brokerageRecordList.addAll(broRecordList);
                merchantOrder.setUpdateTime((Date)DateUtil.date());
                merchantOrderList.add(merchantOrder);
                merOrderDetailList.forEach(od -> od.setUpdateTime((Date)DateUtil.date()));
                orderDetailList.addAll(merOrderDetailList);
            }
            if (!order2.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_INTEGRAL)) {
                OrderProfitSharing orderProfitSharing = this.initOrderProfitSharing(merchantOrder);
                MerchantBill merchantBill = this.initPayMerchantBill(merchantOrder, orderProfitSharing.getProfitSharingMerPrice());
                List<Bill> platBillList = this.initPlatformBill(order2, merchantOrder, orderProfitSharing);
                profitSharingList.add(orderProfitSharing);
                merchantBillList.add(merchantBill);
                billList.addAll(platBillList);
            }
            if (!merchantOrder.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_RESERVATION) || !merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_HOME_SERVICE)) continue;
            OrderDetail orderDetail = merOrderDetailList.get(0);
            JSONArray dataArray = new JSONArray();
            if (order2.getSystemFormId() > 0) {
                String reservationFormData = orderDetail.getReservationFormData();
                dataArray = JSONArray.parseArray((String)reservationFormData);
            }
            for (int i = 0; i < orderDetail.getPayNum(); ++i) {
                ReservationWorkOrder workOrder = new ReservationWorkOrder();
                workOrder.setWorkOrderNo(CrmebUtil.getOrderNo((String)"GD"));
                workOrder.setMerId(orderDetail.getMerId());
                workOrder.setOrderNo(orderDetail.getOrderNo());
                workOrder.setOrderDetailId(orderDetail.getId());
                workOrder.setReservationDate(orderDetail.getReservationDate());
                workOrder.setReservationTimeSlot(orderDetail.getReservationTimeSlot());
                workOrder.setUserId(order2.getUid());
                workOrder.setUserName(merchantOrder.getRealName());
                workOrder.setUserPhone(merchantOrder.getUserPhone());
                workOrder.setUserAddress(merchantOrder.getUserAddress());
                workOrder.setServiceType(WorkOrderConstants.SERVICE_TYPE_HOME_SERVICE);
                try {
                    String txKey = this.systemConfigService.getValueByKey("tengxun_map_key");
                    Location location = AddressUtil.getLocationByTx((String)txKey, (String)merchantOrder.getUserAddress());
                    workOrder.setLongitude(location.getLongitude());
                    workOrder.setLatitude(location.getLatitude());
                }
                catch (Exception e2) {
                    logger.error("\u901a\u8fc7\u817e\u8baf\u5730\u56fe\uff0c\u89e3\u6790\u5730\u5740\u83b7\u53d6\u7ecf\u7eac\u5ea6\u5931\u8d25\uff01orderNo = {}", (Object)orderNo);
                    logger.error("\u901a\u8fc7\u817e\u8baf\u5730\u56fe\uff0c\u89e3\u6790\u5730\u5740\u83b7\u53d6\u7ecf\u7eac\u5ea6\u5931\u8d25\uff01", (Throwable)e2);
                }
                workOrder.setReservationFormId(order2.getSystemFormId());
                if (order2.getSystemFormId() > 0) {
                    JSONArray jsonArray = dataArray.size() > 1 ? dataArray.getJSONArray(i) : dataArray.getJSONArray(0);
                    workOrder.setReservationFormData(jsonArray.toJSONString());
                } else {
                    workOrder.setReservationFormData("");
                }
                workOrderList.add(workOrder);
            }
        }
        List merchantBalanceRecordList = profitSharingList.stream().map(sharing -> {
            MerchantBalanceRecord merchantBalanceRecord = new MerchantBalanceRecord();
            merchantBalanceRecord.setMerId(sharing.getMerId());
            merchantBalanceRecord.setLinkNo(sharing.getOrderNo());
            merchantBalanceRecord.setLinkType("order");
            merchantBalanceRecord.setType(Integer.valueOf(1));
            merchantBalanceRecord.setAmount(sharing.getProfitSharingMerPrice().add(sharing.getFreightFee()));
            merchantBalanceRecord.setTitle(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\uff0c\u5546\u6237\u9884\u8ba1\u5206\u8d26\u91d1\u989d{}\u5143", (Object[])new Object[]{merchantBalanceRecord.getAmount()}));
            merchantBalanceRecord.setBalance(BigDecimal.ZERO);
            merchantBalanceRecord.setStatus(Integer.valueOf(1));
            return merchantBalanceRecord;
        }).collect(Collectors.toList());
        if (!user.getIsPromoter().booleanValue()) {
            String broQuota;
            String funcStatus = this.systemConfigService.getValueByKey("retail_store_switch");
            if (funcStatus.equals("1") && !(broQuota = this.systemConfigService.getValueByKey("retail_store_line")).equals("-1") && platOrder.getPayPrice().compareTo(new BigDecimal(broQuota)) >= 0) {
                user.setIsPromoter(Boolean.valueOf(true));
            }
        } else {
            user.setIsPromoter(Boolean.valueOf(false));
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            if (CollUtil.isNotEmpty((Collection)brokerageRecordList)) {
                this.merchantOrderService.updateBatchById(merchantOrderList);
                this.orderDetailService.updateBatchById(orderDetailList);
                this.userBrokerageRecordService.saveBatch(brokerageRecordList);
            }
            this.userService.paySuccessChange(user.getId(), user.getIsPromoter());
            if (CollUtil.isNotEmpty((Collection)integralList)) {
                this.userIntegralRecordService.saveBatch(integralList);
            }
            if (CollUtil.isNotEmpty((Collection)billList)) {
                this.billService.saveBatch(billList);
            }
            if (CollUtil.isNotEmpty((Collection)merchantBillList)) {
                this.merchantBillService.saveBatch(merchantBillList);
            }
            if (CollUtil.isNotEmpty((Collection)profitSharingList)) {
                this.orderProfitSharingService.saveBatch(profitSharingList);
            }
            if (CollUtil.isNotEmpty((Collection)merchantBalanceRecordList)) {
                this.merchantBalanceRecordService.saveBatch(merchantBalanceRecordList);
            }
            if (CollUtil.isNotEmpty((Collection)workOrderList)) {
                this.reservationWorkOrderService.saveBatch(workOrderList);
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            SystemNotification payNotification = this.systemNotificationService.getByMark("paySuccess");
            if (StrUtil.isNotBlank((CharSequence)user.getPhone()) && payNotification.getIsSms().equals(1)) {
                try {
                    this.smsService.sendPaySuccess(user.getPhone(), platOrder.getOrderNo(), platOrder.getPayPrice());
                }
                catch (Exception e3) {
                    logger.error("\u652f\u4ed8\u6210\u529f\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38", (Throwable)e3);
                }
            }
            if (payNotification.getIsWechat().equals(1) || payNotification.getIsRoutine().equals(1)) {
                try {
                    this.pushMessageOrder(platOrder, user, payNotification);
                }
                catch (Exception e4) {
                    logger.error("\u652f\u4ed8\u6210\u529f\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u5931\u8d25", (Throwable)e4);
                }
            }
            this.autoSendCoupons(platOrder);
            List<String> orderNoList = orderList.stream().map(Order::getOrderNo).collect(Collectors.toList());
            this.asyncService.orderPayAfterFreezingOperation(orderNoList);
            SystemNotification merchantPayNotification = this.systemNotificationService.getByMark("merchantPaySuccess");
            if (merchantPayNotification.getIsSms().equals(1)) {
                try {
                    orderList.forEach(order -> {
                        List<SystemAdmin> smsAdminList = this.systemAdminService.findReceiveSmsAdminListByMerId(order.getMerId());
                        this.smsService.sendPaySuccessToMerchant(smsAdminList, order.getOrderNo());
                    });
                }
                catch (Exception e5) {
                    logger.error("\u652f\u4ed8\u6210\u529f\u5546\u6237\u7ba1\u7406\u5458\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38", (Throwable)e5);
                }
            }
            try {
                if (!platOrder.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_INTEGRAL)) {
                    int i = 0;
                    while (i < merchantOrderListForPrint.size()) {
                        MerchantOrder merchantOrder = (MerchantOrder)merchantOrderListForPrint.get(i);
                        Merchant merchant = this.merchantService.getByIdException(merchantOrder.getMerId());
                        if (merchant.getReceiptPrintingSwitch() == 0) {
                            merchantOrderListForPrint.remove(i);
                            continue;
                        }
                        if (merchant.getReceiptPrintingSwitch() < 2) {
                            merchantOrderListForPrint.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    if (CollUtil.isNotEmpty((Collection)merchantOrderListForPrint)) {
                        this.merchantPrintService.batchPrintTicket(merchantOrderListForPrint);
                    }
                }
            }
            catch (Exception e6) {
                logger.error(StrUtil.format((CharSequence)"\u5c0f\u7968\u6253\u5370\u5f02\u5e38\uff0cException\uff1a{}", (Object[])new Object[]{e6.getMessage()}), (Throwable)e6);
            }
            orderList.forEach(order -> {
                if (!order.getType().equals(OrderConstants.ORDER_TYPE_PITUAN) && (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CLOUD) || order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CDKEY))) {
                    this.orderService.virtualShipment((Order)order);
                }
            });
        }
        return execute;
    }

    @Override
    public CashierInfoResponse getCashierIno(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (order.getCancelStatus() > OrderConstants.ORDER_CANCEL_STATUS_NORMAL) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_CANCEL);
        }
        if (order.getPaid().booleanValue()) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_PAID);
        }
        if (order.getStatus() > OrderConstants.ORDER_STATUS_WAIT_PAY) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_STATUS_ABNORMAL);
        }
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
        CashierInfoResponse response = new CashierInfoResponse();
        response.setPayPrice(order.getPayPrice());
        response.setTotalNum(order.getTotalNum());
        response.setConsigneeName(merchantOrder.getRealName());
        response.setConsigneePhone(merchantOrder.getUserPhone());
        response.setConsigneeAddress(merchantOrder.getUserAddress());
        DateTime cancelDate = DateUtil.offsetMinute((Date)order.getCreateTime(), (int)this.crmebConfig.getOrderCancelTime());
        response.setCancelDateTime(Long.valueOf(cancelDate.getTime()));
        return response;
    }

    @Override
    public Boolean queryWechatPaymentResult(WechatPaymentQueryRequest request) {
        if (request.getOrderType().equals("order")) {
            return this.queryWechatPayResult(request.getOrderNo());
        }
        if (request.getOrderType().equals("svip")) {
            return this.querySvipWechatPayResult(request.getOrderNo());
        }
        return this.queryRechargeWechatPayResult(request.getOrderNo());
    }

    private Boolean queryRechargeWechatPayResult(String orderNo) {
        RechargeOrder rechargeOrder = this.rechargeOrderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)rechargeOrder)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST);
        }
        if (!rechargeOrder.getPayType().equals("weixin")) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0d\u662f\u5fae\u4fe1\u652f\u4ed8\u7c7b\u578b\u8ba2\u5355");
        }
        if (rechargeOrder.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(rechargeOrder.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u672a\u627e\u5230\u5bf9\u5e94\u5fae\u4fe1\u8ba2\u5355");
        }
        String paySource = this.getWechatPaySource(rechargeOrder.getPayChannel());
        WxPayOrderQueryResult queryResult = this.wechatPayService.queryOrder(rechargeOrder.getOutTradeNo(), paySource);
        if (!queryResult.getTradeState().equals("SUCCESS")) {
            return Boolean.FALSE;
        }
        wechatPayInfo.setIsSubscribe(queryResult.getIsSubscribe());
        wechatPayInfo.setTradeState(queryResult.getTradeState());
        wechatPayInfo.setBankType(queryResult.getBankType());
        wechatPayInfo.setCashFee(queryResult.getCashFee());
        wechatPayInfo.setCouponFee(queryResult.getCouponFee());
        wechatPayInfo.setTransactionId(queryResult.getTransactionId());
        wechatPayInfo.setTimeEnd(queryResult.getTimeEnd());
        wechatPayInfo.setTradeStateDesc(queryResult.getTradeStateDesc());
        Boolean updatePaid = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean update = this.rechargeOrderService.paySuccessAfter(rechargeOrder);
            if (!update.booleanValue()) {
                logger.error("\u5145\u503c\u8ba2\u5355\u652f\u4ed8\u5904\u7406\u7ed3\u679c\u5931\u8d25\uff0corderNo = {}", (Object)rechargeOrder.getOrderNo());
                e.setRollbackOnly();
                return false;
            }
            this.wechatPayInfoService.updateById(wechatPayInfo);
            return Boolean.TRUE;
        });
        if (!updatePaid.booleanValue()) {
            throw new CrmebException("\u5145\u503c\u652f\u4ed8\u6210\u529f\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
        }
        return Boolean.TRUE;
    }

    private Boolean querySvipWechatPayResult(String orderNo) {
        PaidMemberOrder order = this.paidMemberOrderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException((IResultEnum)MemberResultCode.PAID_MEMBER_ORDER_NOT_EXIST);
        }
        if (!order.getPayType().equals("weixin")) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u4e0d\u662f\u5fae\u4fe1\u652f\u4ed8\u7c7b\u578b\u8ba2\u5355");
        }
        if (order.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(order.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u672a\u627e\u5230\u5bf9\u5e94\u5fae\u4fe1\u8ba2\u5355");
        }
        String paySource = this.getWechatPaySource(order.getPayChannel());
        WxPayOrderQueryResult queryResult = this.wechatPayService.queryOrder(order.getOutTradeNo(), paySource);
        if (!queryResult.getTradeState().equals("SUCCESS")) {
            return Boolean.FALSE;
        }
        wechatPayInfo.setIsSubscribe(queryResult.getIsSubscribe());
        wechatPayInfo.setTradeState(queryResult.getTradeState());
        wechatPayInfo.setBankType(queryResult.getBankType());
        wechatPayInfo.setCashFee(queryResult.getCashFee());
        wechatPayInfo.setCouponFee(queryResult.getCouponFee());
        wechatPayInfo.setTransactionId(queryResult.getTransactionId());
        wechatPayInfo.setTimeEnd(queryResult.getTimeEnd());
        wechatPayInfo.setTradeStateDesc(queryResult.getTradeStateDesc());
        Boolean updatePaid = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean update = this.paidMemberOrderService.paySuccessAfter(order);
            if (!update.booleanValue()) {
                logger.error("svip\u8ba2\u5355\u652f\u4ed8\u5904\u7406\u7ed3\u679c\u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo());
                e.setRollbackOnly();
                return false;
            }
            this.wechatPayInfoService.updateById(wechatPayInfo);
            return Boolean.TRUE;
        });
        if (!updatePaid.booleanValue()) {
            throw new CrmebException("svip\u652f\u4ed8\u6210\u529f\u66f4\u65b0\u8ba2\u5355\u5931\u8d25");
        }
        return Boolean.TRUE;
    }

    private void pushMessageOrder(Order order, User user, SystemNotification payNotification) {
        if (order.getPayChannel().equals("h5")) {
            return;
        }
        HashMap<String, String> temMap = new HashMap<String, String>();
        if (!order.getPayType().equals("weixin")) {
            return;
        }
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        if (order.getPayChannel().equals("public") && payNotification.getIsWechat().equals(1) && user.getIsWechatPublic().booleanValue()) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_WECHAT);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("first", "\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u901a\u77e5\uff01");
            temMap.put("keyword1", order.getOrderNo());
            temMap.put("keyword2", orderDetailList.stream().map(OrderDetail::getProductName).collect(Collectors.joining(",")));
            temMap.put("keyword3", order.getPayPrice().toString());
            temMap.put("keyword4", user.getNickname());
            temMap.put("keyword5", order.getPayTime().toString());
            temMap.put("remark", "\u6b22\u8fce\u4e0b\u6b21\u518d\u6765\uff01");
            this.templateMessageService.pushTemplateMessage(payNotification.getWechatId(), temMap, userToken.getToken());
            return;
        }
        if (order.getPayChannel().equals("mini") && payNotification.getIsRoutine().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("character_string3", order.getOrderNo());
            temMap.put("amount9", order.getPayPrice().toString() + "\u5143");
            temMap.put("thing6", "\u60a8\u7684\u8ba2\u5355\u5df2\u652f\u4ed8\u6210\u529f");
            this.templateMessageService.pushMiniTemplateMessage(payNotification.getRoutineId(), temMap, userToken.getToken());
        }
    }

    private List<UserBrokerageRecord> assignCommission(MerchantOrder merchantOrder, List<OrderDetail> orderDetailList) {
        if (merchantOrder.getType().equals(OrderConstants.ORDER_TYPE_SECKILL)) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        if (merchantOrder.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_INTEGRAL)) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        if (merchantOrder.getType().equals(OrderConstants.ORDER_TYPE_PITUAN)) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        String isOpen = this.systemConfigService.getValueByKey("retail_store_switch");
        if (StrUtil.isBlank((CharSequence)isOpen) || isOpen.equals("0")) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        long count = orderDetailList.stream().filter(e -> e.getSubBrokerageType() > 0).count();
        if (count == 0L) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        User user = (User)this.userService.getById(merchantOrder.getUid());
        if (ObjectUtil.isNull((Object)user.getSpreadUid()) || user.getSpreadUid() < 1 || user.getSpreadUid().equals(merchantOrder.getUid())) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        List<MyRecord> spreadRecordList = this.getSpreadRecordList(user.getSpreadUid());
        if (CollUtil.isEmpty(spreadRecordList)) {
            return CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        }
        String freezingTime = this.systemConfigService.getValueByKey("retail_store_brokerage_freezing_time");
        ArrayList<UserBrokerageRecord> brokerageRecordList = new ArrayList();
        if (spreadRecordList.size() == 1) {
            BigDecimal firstBrokerage = BigDecimal.ZERO;
            for (OrderDetail orderDetail : orderDetailList) {
                if (orderDetail.getSubBrokerageType().equals(0)) continue;
                BigDecimal detailPrice = orderDetail.getIsSvip() != false && orderDetail.getIsPaidMemberProduct() != false ? orderDetail.getVipPrice() : orderDetail.getPrice();
                BigDecimal brokerage = detailPrice.multiply(new BigDecimal(orderDetail.getPayNum().toString())).subtract(orderDetail.getMerCouponPrice()).multiply(new BigDecimal(orderDetail.getBrokerage().toString())).divide(new BigDecimal("100"), 2, 1);
                orderDetail.setFirstBrokerageFee(brokerage);
                firstBrokerage = firstBrokerage.add(brokerage);
            }
            merchantOrder.setFirstBrokerage(firstBrokerage);
            UserBrokerageRecord brokerageRecord = new UserBrokerageRecord();
            brokerageRecord.setUid(spreadRecordList.get(0).getInt("spreadUid"));
            brokerageRecord.setSubUid(merchantOrder.getUid());
            brokerageRecord.setLinkNo(merchantOrder.getOrderNo());
            brokerageRecord.setLinkType("order");
            brokerageRecord.setType(BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_ADD);
            brokerageRecord.setTitle("\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1");
            brokerageRecord.setPrice(firstBrokerage);
            brokerageRecord.setMark(StrUtil.format((CharSequence)"\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1\uff0c\u5206\u4f63{}", (Object[])new Object[]{firstBrokerage}));
            brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE);
            brokerageRecord.setFrozenTime(Integer.valueOf(Optional.ofNullable(freezingTime).orElse("0")));
            brokerageRecord.setCreateTime(CrmebDateUtil.nowDateTime());
            brokerageRecord.setBrokerageLevel(spreadRecordList.get(0).getInt("index"));
            brokerageRecordList.add(brokerageRecord);
            return brokerageRecordList;
        }
        BigDecimal firstBrokerage = BigDecimal.ZERO;
        BigDecimal secondBrokerage = BigDecimal.ZERO;
        for (OrderDetail orderDetail : orderDetailList) {
            if (orderDetail.getSubBrokerageType().equals(0)) continue;
            BigDecimal detailPrice = orderDetail.getIsSvip() != false && orderDetail.getIsPaidMemberProduct() != false ? orderDetail.getVipPrice() : orderDetail.getPrice();
            BigDecimal brokerage = detailPrice.multiply(new BigDecimal(orderDetail.getPayNum().toString())).subtract(orderDetail.getMerCouponPrice()).multiply(new BigDecimal(orderDetail.getBrokerage().toString())).divide(new BigDecimal("100"), 2, 1);
            BigDecimal brokerageTwo = detailPrice.multiply(new BigDecimal(orderDetail.getPayNum().toString())).subtract(orderDetail.getMerCouponPrice()).multiply(new BigDecimal(orderDetail.getBrokerageTwo().toString())).divide(new BigDecimal("100"), 2, 1);
            orderDetail.setFirstBrokerageFee(brokerage);
            orderDetail.setSecondBrokerageFee(brokerageTwo);
            firstBrokerage = firstBrokerage.add(brokerage);
            secondBrokerage = secondBrokerage.add(brokerageTwo);
        }
        merchantOrder.setFirstBrokerage(firstBrokerage);
        merchantOrder.setSecondBrokerage(secondBrokerage);
        brokerageRecordList = spreadRecordList.stream().map(record -> {
            UserBrokerageRecord brokerageRecord = new UserBrokerageRecord();
            brokerageRecord.setUid(record.getInt("spreadUid"));
            brokerageRecord.setSubUid(merchantOrder.getUid());
            brokerageRecord.setLinkNo(merchantOrder.getOrderNo());
            brokerageRecord.setLinkType("order");
            brokerageRecord.setType(BrokerageRecordConstants.BROKERAGE_RECORD_TYPE_ADD);
            brokerageRecord.setTitle("\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1");
            BigDecimal price = record.getInt("index") == 1 ? merchantOrder.getFirstBrokerage() : merchantOrder.getSecondBrokerage();
            brokerageRecord.setPrice(price);
            brokerageRecord.setMark(StrUtil.format((CharSequence)"\u83b7\u5f97\u63a8\u5e7f\u4f63\u91d1\uff0c\u5206\u4f63{}", (Object[])new Object[]{price}));
            brokerageRecord.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE);
            brokerageRecord.setFrozenTime(Integer.valueOf(Optional.ofNullable(freezingTime).orElse("0")));
            brokerageRecord.setCreateTime(CrmebDateUtil.nowDateTime());
            brokerageRecord.setBrokerageLevel(record.getInt("index"));
            return brokerageRecord;
        }).collect(Collectors.toList());
        return brokerageRecordList;
    }

    private List<MyRecord> getSpreadRecordList(Integer spreadUid) {
        ArrayList recordList = CollUtil.newArrayList((Object[])new MyRecord[0]);
        User spreadUser = (User)this.userService.getById(spreadUid);
        if (ObjectUtil.isNull((Object)spreadUser) || !spreadUser.getIsPromoter().booleanValue()) {
            return recordList;
        }
        MyRecord firstRecord = new MyRecord();
        firstRecord.set("index", (Object)1);
        firstRecord.set("spreadUid", (Object)spreadUid);
        recordList.add(firstRecord);
        User spreadSpreadUser = (User)this.userService.getById(spreadUser.getSpreadUid());
        if (ObjectUtil.isNull((Object)spreadSpreadUser) || !spreadSpreadUser.getIsPromoter().booleanValue()) {
            return recordList;
        }
        MyRecord secondRecord = new MyRecord();
        secondRecord.set("index", (Object)2);
        secondRecord.set("spreadUid", (Object)spreadSpreadUser.getId());
        recordList.add(secondRecord);
        return recordList;
    }

    private OrderProfitSharing initOrderProfitSharing(MerchantOrder merchantOrder) {
        Merchant merchant = this.merchantService.getByIdException(merchantOrder.getMerId());
        BigDecimal orderPrice = merchantOrder.getPayPrice().add(merchantOrder.getIntegralPrice()).add(merchantOrder.getPlatCouponPrice()).subtract(merchantOrder.getPayPostage());
        BigDecimal platFee = orderPrice.multiply(new BigDecimal(merchant.getHandlingFee())).divide(new BigDecimal(100), 2, 0);
        BigDecimal merchantFee = orderPrice.subtract(platFee).subtract(merchantOrder.getFirstBrokerage()).subtract(merchantOrder.getSecondBrokerage());
        OrderProfitSharing orderProfitSharing = new OrderProfitSharing();
        orderProfitSharing.setOrderNo(merchantOrder.getOrderNo());
        orderProfitSharing.setMerId(merchantOrder.getMerId());
        orderProfitSharing.setOrderPrice(merchantOrder.getPayPrice());
        orderProfitSharing.setIntegralNum(merchantOrder.getUseIntegral());
        orderProfitSharing.setIntegralPrice(merchantOrder.getIntegralPrice());
        orderProfitSharing.setProfitSharingPlatPrice(platFee);
        orderProfitSharing.setProfitSharingMerPrice(merchantFee);
        orderProfitSharing.setFirstBrokerageFee(merchantOrder.getFirstBrokerage());
        orderProfitSharing.setSecondBrokerageFee(merchantOrder.getSecondBrokerage());
        orderProfitSharing.setPlatCouponPrice(merchantOrder.getPlatCouponPrice());
        orderProfitSharing.setFreightFee(merchantOrder.getPayPostage());
        return orderProfitSharing;
    }

    private MerchantBill initPayMerchantBill(MerchantOrder merchantOrder, BigDecimal merchantFee) {
        MerchantBill merchantBill = new MerchantBill();
        merchantBill.setMerId(merchantOrder.getMerId());
        merchantBill.setType("pay_order");
        merchantBill.setOrderNo(merchantOrder.getOrderNo());
        merchantBill.setUid(merchantOrder.getUid());
        merchantBill.setPm(BillConstants.BILL_PM_ADD);
        BigDecimal merFee = merchantOrder.getPayPostage().add(merchantFee);
        merchantBill.setAmount(merFee);
        merchantBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355{}\u652f\u4ed8{}\u5143\uff0c\u5546\u6237\u6536\u5165{}\u5143", (Object[])new Object[]{merchantOrder.getOrderNo(), merchantOrder.getPayPrice(), merFee}));
        return merchantBill;
    }

    private List<Bill> initPlatformBill(Order order, MerchantOrder merchantOrder, OrderProfitSharing orderProfitSharing) {
        ArrayList billList = CollUtil.newArrayList((Object[])new Bill[0]);
        Bill payBill = new Bill();
        payBill.setUid(order.getUid());
        payBill.setOrderNo(order.getOrderNo());
        payBill.setAmount(order.getPayPrice());
        if (order.getPayType().equals("yue")) {
            payBill.setPm(BillConstants.BILL_PM_SUB);
            payBill.setType("yue_pay");
            payBill.setMark(StrUtil.format((CharSequence)"\u4f59\u989d\u652f\u4ed8\u6210\u529f\uff0c\u6263\u9664\u7528\u6237\u4f59\u989d{}\u5143", (Object[])new Object[]{order.getPayPrice()}));
        } else {
            payBill.setPm(BillConstants.BILL_PM_ADD);
            payBill.setType("pay_order");
            payBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u652f\u4ed8\u91d1\u989d{}\u5143", (Object[])new Object[]{order.getPayPrice()}));
        }
        billList.add(payBill);
        Bill collectBill = new Bill();
        collectBill.setMerId(merchantOrder.getMerId());
        collectBill.setOrderNo(order.getOrderNo());
        collectBill.setAmount(orderProfitSharing.getProfitSharingMerPrice().add(merchantOrder.getPayPostage()));
        collectBill.setPm(BillConstants.BILL_PM_SUB);
        collectBill.setType("merchant_collect");
        collectBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u5546\u6237\u5206\u8d26{}\u5143", (Object[])new Object[]{orderProfitSharing.getProfitSharingMerPrice().add(merchantOrder.getPayPostage())}));
        billList.add(collectBill);
        Bill platBill = new Bill();
        platBill.setOrderNo(order.getOrderNo());
        platBill.setAmount(orderProfitSharing.getProfitSharingPlatPrice());
        platBill.setPm(BillConstants.BILL_PM_ADD);
        platBill.setType("pay_order");
        platBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u5e73\u53f0\u624b\u7eed\u8d39{}\u5143", (Object[])new Object[]{orderProfitSharing.getProfitSharingPlatPrice()}));
        billList.add(platBill);
        if (ObjectUtil.isNotNull((Object)orderProfitSharing.getFirstBrokerageFee()) && orderProfitSharing.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
            Bill firstBill = new Bill();
            firstBill.setOrderNo(order.getOrderNo());
            firstBill.setAmount(orderProfitSharing.getFirstBrokerageFee());
            firstBill.setPm(BillConstants.BILL_PM_SUB);
            firstBill.setType("brokerage");
            firstBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u5206\u914d\u4e00\u7ea7\u4f63\u91d1{}\u5143", (Object[])new Object[]{orderProfitSharing.getFirstBrokerageFee()}));
            billList.add(firstBill);
            if (orderProfitSharing.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                Bill secondBill = new Bill();
                secondBill.setOrderNo(order.getOrderNo());
                secondBill.setAmount(orderProfitSharing.getSecondBrokerageFee());
                secondBill.setPm(BillConstants.BILL_PM_SUB);
                secondBill.setType("brokerage");
                secondBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u5206\u914d\u4e8c\u7ea7\u4f63\u91d1{}\u5143", (Object[])new Object[]{orderProfitSharing.getSecondBrokerageFee()}));
                billList.add(secondBill);
            }
        }
        if (orderProfitSharing.getIntegralNum() > 0) {
            Bill integralBill = new Bill();
            integralBill.setOrderNo(order.getOrderNo());
            integralBill.setAmount(order.getIntegralPrice());
            integralBill.setPm(BillConstants.BILL_PM_SUB);
            integralBill.setType("pay_order");
            integralBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u7528\u6237\u4f7f\u7528{}\u79ef\u5206\u62b5\u6263{}\u5143\uff0c\u5e73\u53f0\u6263\u9664", (Object[])new Object[]{orderProfitSharing.getIntegralNum(), orderProfitSharing.getIntegralPrice()}));
            billList.add(integralBill);
        }
        return billList;
    }

    private UserIntegralRecord integralRecordGainInit(Integer uid, String orderNo, Integer gainIntegral) {
        UserIntegralRecord integralRecord = new UserIntegralRecord();
        integralRecord.setUid(uid);
        integralRecord.setLinkId(orderNo);
        integralRecord.setLinkType("order");
        integralRecord.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        integralRecord.setTitle("\u7528\u6237\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f");
        integralRecord.setIntegral(gainIntegral);
        integralRecord.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u5956\u52b1{}\u79ef\u5206", (Object[])new Object[]{gainIntegral}));
        integralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_CREATE);
        String freezeTime = this.systemConfigService.getValueByKey("freeze_integral_day");
        integralRecord.setFrozenTime(Integer.valueOf(Optional.ofNullable(freezeTime).orElse("0")));
        integralRecord.setCreateTime(CrmebDateUtil.nowDateTime());
        return integralRecord;
    }

    private String aliPayment(Order order) {
        DateTime cancelTime = DateUtil.offset((Date)order.getCreateTime(), (DateField)DateField.MINUTE, (int)this.crmebConfig.getOrderCancelTime());
        String cancelStr = cancelTime.toString("yyyy-MM-dd HH:mm:ss");
        return this.aliPayService.pay(order.getOrderNo(), order.getPayPrice(), "order", order.getPayChannel(), cancelStr);
    }

    private WxPayJsResultVo wechatPayment(Order order) {
        MyRecord myRecord;
        String outTradeNo;
        String paySource;
        UserToken userToken = new UserToken();
        userToken.setToken("");
        if (order.getPayChannel().equals("public")) {
            userToken = this.userTokenService.getTokenByUserId(order.getUid(), UserConstants.USER_TOKEN_TYPE_WECHAT);
        }
        if (order.getPayChannel().equals("mini") || order.getPayChannel().equals("video")) {
            userToken = this.userTokenService.getTokenByUserId(order.getUid(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
        }
        if ((paySource = order.getPayChannel()).equals("h5") || paySource.equals("native")) {
            String source = this.systemConfigService.getValueByKey("wechat_pay_source");
            paySource = StrUtil.isNotBlank((CharSequence)source) && source.equals("mini") ? "mini" : "public";
        }
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayUnifiedOrderRequest unifiedOrderRequest = this.buildWxPayUnifiedOrderRequest(order);
            outTradeNo = unifiedOrderRequest.getOutTradeNo();
            myRecord = this.wechatPayService.createOrder(unifiedOrderRequest, userToken.getToken(), order.getPayChannel(), paySource, apiDomain);
        } else {
            WxPayUnifiedOrderV3Request v3Request = this.buildWxPayUnifiedOrderV3Request(order);
            outTradeNo = v3Request.getOutTradeNo();
            myRecord = this.wechatPayService.createV3Order(v3Request, userToken.getToken(), order.getPayChannel(), paySource, apiDomain);
        }
        WxPayJsResultVo vo = new WxPayJsResultVo();
        switch (order.getPayChannel()) {
            case "mini": 
            case "video": 
            case "public": {
                vo.setAppId(myRecord.getStr("appId"));
                vo.setNonceStr(myRecord.getStr("nonceStr"));
                vo.setPackages(myRecord.getStr("package"));
                vo.setSignType(myRecord.getStr("signType"));
                vo.setPaySign(myRecord.getStr("paySign"));
                vo.setTimeStamp(myRecord.getStr("timeStamp"));
                break;
            }
            case "h5": {
                vo.setMwebUrl(myRecord.getStr("mwebUrl"));
                break;
            }
            case "native": {
                vo.setMwebUrl(myRecord.getStr("codeUrl"));
                break;
            }
            case "wechatIos": 
            case "wechatAndroid": {
                vo.setAppId(myRecord.getStr("appId"));
                vo.setPartnerid(myRecord.getStr("partnerId"));
                vo.setPrepayid(myRecord.getStr("prepayId"));
                vo.setPackages(myRecord.getStr("package"));
                vo.setNonceStr(myRecord.getStr("nonceStr"));
                vo.setTimeStamp(myRecord.getStr("timeStamp"));
                vo.setPaySign(myRecord.getStr("sign"));
            }
        }
        order.setOutTradeNo(outTradeNo);
        return vo;
    }

    private Boolean yuePay(Order order, User user) {
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean update = Boolean.TRUE;
            order.setPaid(Boolean.valueOf(true));
            order.setPayTime((Date)DateUtil.date());
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            order.setPayType("yue");
            order.setPayChannel("yue");
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
            if (order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
                update = this.userService.updateNowMoney(order.getUid(), order.getPayPrice(), "sub");
                if (!update.booleanValue()) {
                    logger.error("\u4f59\u989d\u652f\u4ed8\uff0c\u6263\u9664\u7528\u6237\u4f59\u989d\u5931\u8d25\uff0corderNo = {}", (Object)order.getOrderNo());
                    e.setRollbackOnly();
                    return update;
                }
                UserBalanceRecord userBalanceRecord = new UserBalanceRecord();
                userBalanceRecord.setUid(user.getId());
                userBalanceRecord.setLinkId(order.getOrderNo());
                userBalanceRecord.setLinkType("order");
                userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
                userBalanceRecord.setAmount(order.getPayPrice());
                userBalanceRecord.setBalance(user.getNowMoney().subtract(order.getPayPrice()));
                userBalanceRecord.setRemark(StrUtil.format((CharSequence)"\u7528\u6237\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f,\u6263\u4f59\u989d{}\u5143", (Object[])new Object[]{order.getPayPrice()}));
                this.userBalanceRecordService.save(userBalanceRecord);
            }
            this.orderFlowRecordService.orderPaid(order.getOrderNo(), order.getUid());
            return update;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u4f59\u989d\u652f\u4ed8\u8ba2\u5355\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return true;
    }

    private WxPayUnifiedOrderRequest buildWxPayUnifiedOrderRequest(Order order) {
        WxPayUnifiedOrderRequest orderRequest = new WxPayUnifiedOrderRequest();
        String siteName = this.systemConfigService.getValueByKeyException("site_name");
        orderRequest.setBody(siteName);
        AttachVo attachVo = new AttachVo("order", order.getUid());
        orderRequest.setAttach(JSONObject.toJSONString((Object)attachVo));
        orderRequest.setOutTradeNo(CrmebUtil.getOrderNo((String)"WX"));
        orderRequest.setTotalFee(Integer.valueOf(order.getPayPrice().multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue()));
        orderRequest.setSpbillCreateIp(RequestUtil.getClientIp());
        String domain = this.systemConfigService.getValueByKeyException("site_url");
        CreateOrderH5SceneInfoVo createOrderH5SceneInfoVo = new CreateOrderH5SceneInfoVo(new CreateOrderH5SceneInfoDetailVo(domain, this.systemConfigService.getValueByKeyException("site_name")));
        orderRequest.setSceneInfo(JSONObject.toJSONString((Object)createOrderH5SceneInfoVo));
        orderRequest.setTimeStart(DateUtil.date().toString("yyyyMMddHHmmss"));
        DateTime cancelTime = DateUtil.offset((Date)order.getCreateTime(), (DateField)DateField.MINUTE, (int)this.crmebConfig.getOrderCancelTime());
        String cancelStr = cancelTime.toString("yyyyMMddHHmmss");
        orderRequest.setTimeExpire(cancelStr);
        orderRequest.setProductId(order.getOrderNo());
        return orderRequest;
    }

    private WxPayUnifiedOrderV3Request buildWxPayUnifiedOrderV3Request(Order order) {
        WxPayUnifiedOrderV3Request orderRequest = new WxPayUnifiedOrderV3Request();
        String siteName = this.systemConfigService.getValueByKeyException("site_name");
        orderRequest.setDescription(siteName);
        orderRequest.setOutTradeNo(CrmebUtil.getOrderNo((String)"WX"));
        DateTime cancelTime = DateUtil.offset((Date)order.getCreateTime(), (DateField)DateField.MINUTE, (int)this.crmebConfig.getOrderCancelTime());
        String cancelStr = cancelTime.toString("yyyy-MM-dd'T'HH:mm:ssXXX");
        orderRequest.setTimeExpire(cancelStr);
        AttachVo attachVo = new AttachVo("order", order.getUid());
        orderRequest.setAttach(JSONObject.toJSONString((Object)attachVo));
        WxPayUnifiedOrderV3Request.Amount amount = new WxPayUnifiedOrderV3Request.Amount();
        amount.setTotal(Integer.valueOf(order.getPayPrice().multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue()));
        orderRequest.setAmount(amount);
        return orderRequest;
    }

    private void autoSendCoupons(Order order) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        if (CollUtil.isEmpty(orderDetailList)) {
            return;
        }
        ArrayList couponUserList = CollUtil.newArrayList((Object[])new CouponUser[0]);
        HashMap couponMap = CollUtil.newHashMap();
        List proIdList = orderDetailList.stream().map(OrderDetail::getProductId).distinct().collect(Collectors.toList());
        for (Integer proId : proIdList) {
            List<ProductCoupon> couponsForGiveUser = this.productCouponService.getListByProductId(proId);
            int i = 0;
            while (i < couponsForGiveUser.size()) {
                ProductCoupon productCoupon = couponsForGiveUser.get(i);
                MyRecord record = this.couponUserService.paySuccessGiveAway(productCoupon.getCouponId(), order.getUid());
                if (record.getStr("status").equals("fail")) {
                    logger.error(StrUtil.format((CharSequence)"\u652f\u4ed8\u6210\u529f\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object[])new Object[]{record.getStr("errMsg")}));
                    couponsForGiveUser.remove(i);
                    continue;
                }
                CouponUser couponUser = (CouponUser)record.get("couponUser");
                couponUserList.add(couponUser);
                couponMap.put(couponUser.getCouponId(), record.getBoolean("isLimited"));
                ++i;
            }
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            if (CollUtil.isNotEmpty((Collection)couponUserList)) {
                this.couponUserService.saveBatch(couponUserList);
                couponUserList.forEach(i -> this.couponService.deduction(i.getCouponId(), 1, (Boolean)couponMap.get(i.getCouponId())));
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error(StrUtil.format((CharSequence)"\u652f\u4ed8\u6210\u529f\u9886\u53d6\u4f18\u60e0\u5238\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25\uff0c\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object[])new Object[]{order.getOrderNo()}));
        }
    }
}

