/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.member.PaidMemberOrder;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PaidMemberOrderSearchRequest;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.response.PaidMemberOrderInfoResponse;
import com.zbkj.common.response.PaidMemberOrderResponse;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.MemberResultCode;
import com.zbkj.common.result.UserResultCode;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.PaidMemberOrderDao;
import com.zbkj.service.service.PaidMemberCardService;
import com.zbkj.service.service.PaidMemberOrderService;
import com.zbkj.service.service.UserBalanceRecordService;
import com.zbkj.service.service.UserService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PaidMemberOrderServiceImpl
extends ServiceImpl<PaidMemberOrderDao, PaidMemberOrder>
implements PaidMemberOrderService {
    private final Logger logger = LoggerFactory.getLogger(PaidMemberOrderServiceImpl.class);
    @Resource
    private PaidMemberOrderDao dao;
    @Autowired
    private UserService userService;
    @Autowired
    private PaidMemberCardService paidMemberCardService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private UserBalanceRecordService userBalanceRecordService;

    @Override
    public PageInfo<PaidMemberOrderResponse> findPlatformPage(PaidMemberOrderSearchRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", URLUtil.decode((String)request.getOrderNo()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getCardName())) {
            map.put("cardName", URLUtil.decode((String)request.getCardName()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimitVo = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            map.put("startTime", dateLimitVo.getStartTime());
            map.put("endTime", dateLimitVo.getEndTime());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getPayType())) {
            map.put("payType", request.getPayType());
        }
        if (ObjectUtil.isNotNull((Object)request.getPayStatus()) && (request.getPayStatus() == 1 || request.getPayStatus() == 0)) {
            map.put("payStatus", request.getPayStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<PaidMemberOrderResponse> list = this.dao.findPlatformPage(map);
        list.forEach(e -> e.setUserPhone(CrmebUtil.maskMobile((String)e.getUserPhone())));
        return CommonPage.copyPageInfo((Page)page, list);
    }

    @Override
    public PaidMemberOrderInfoResponse platformInfo(String orderNo) {
        PaidMemberOrder order = this.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException((IResultEnum)MemberResultCode.PAID_MEMBER_ORDER_NOT_EXIST);
        }
        if (!order.getPaid().booleanValue()) {
            throw new CrmebException((IResultEnum)MemberResultCode.PAID_MEMBER_ORDER_NOT_EXIST);
        }
        User user = (User)this.userService.getById(order.getUid());
        if (ObjectUtil.isNull((Object)user)) {
            throw new CrmebException((IResultEnum)UserResultCode.USER_NOT_EXIST);
        }
        PaidMemberOrderInfoResponse response = new PaidMemberOrderInfoResponse();
        BeanUtils.copyProperties((Object)order, (Object)response);
        response.setUserNickname(user.getNickname());
        response.setUserPhone(CrmebUtil.maskMobile((String)user.getPhone()));
        return response;
    }

    @Override
    public Boolean userIsPayTrial(Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PaidMemberOrder::getUid, (Object)userId);
        lqw.eq(PaidMemberOrder::getPaid, (Object)1);
        lqw.eq(PaidMemberOrder::getType, (Object)0);
        Integer count = this.dao.selectCount((Wrapper)lqw);
        return count > 0;
    }

    @Override
    public Boolean userIsFirstPay(Integer userId, Integer cardId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PaidMemberOrder::getUid, (Object)userId);
        lqw.eq(PaidMemberOrder::getCardId, (Object)cardId);
        lqw.eq(PaidMemberOrder::getPaid, (Object)1);
        Integer count = this.dao.selectCount((Wrapper)lqw);
        return count > 0;
    }

    @Override
    public PaidMemberOrder getByOutTradeNo(String outTradeNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PaidMemberOrder::getOutTradeNo, (Object)outTradeNo);
        lqw.last(" limit 1");
        return (PaidMemberOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean paySuccessAfter(PaidMemberOrder svipOrder) {
        User user = (User)this.userService.getById(svipOrder.getUid());
        this.paidMemberCardService.getByIdException(svipOrder.getCardId());
        Integer deadlineDay = svipOrder.getDeadlineDay();
        BigDecimal giftBalance = svipOrder.getGiftBalance();
        boolean isPermanentPaidMember = user.getIsPermanentPaidMember() != false ? true : svipOrder.getType().equals(2);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            DateTime offsetDay;
            boolean update = false;
            if (user.getIsPaidMember().booleanValue()) {
                offsetDay = DateUtil.offsetDay((Date)DateTime.of((Date)user.getPaidMemberExpirationTime()), (int)deadlineDay);
                svipOrder.setCardExpirationTime((Date)offsetDay);
                update = this.userService.updateUserPaidMember(user.getId(), true, isPermanentPaidMember, offsetDay, user.getPaidMemberExpirationTime());
            } else {
                offsetDay = DateUtil.offsetDay((Date)DateUtil.date(), (int)deadlineDay);
                svipOrder.setCardExpirationTime((Date)offsetDay);
                update = this.userService.updateUserPaidMember(user.getId(), true, isPermanentPaidMember, offsetDay, null);
            }
            if (!update) {
                this.logger.error("svip\u8ba2\u5355\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0corderNo = {}", (Object)svipOrder.getOrderNo());
                e.setRollbackOnly();
                return false;
            }
            Boolean updatePaid = this.updatePaid(svipOrder.getId(), svipOrder.getOrderNo(), (Date)offsetDay);
            if (!updatePaid.booleanValue()) {
                this.logger.error("\u5145\u503c\u8ba2\u5355\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25\uff0corderNo = {}", (Object)svipOrder.getOrderNo());
                e.setRollbackOnly();
                return false;
            }
            if (giftBalance.compareTo(BigDecimal.ZERO) > 0) {
                this.userService.updateNowMoney(user.getId(), giftBalance, "add");
                this.userBalanceRecordService.save(this.createBalanceRecord(svipOrder, user.getNowMoney()));
            }
            return Boolean.TRUE;
        });
        return execute;
    }

    @Override
    public List<PaidMemberOrder> findUserSvipOrderRecord(Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PaidMemberOrder::getUid, (Object)userId);
        lqw.eq(PaidMemberOrder::getPaid, (Object)1);
        lqw.orderByDesc((Object[])new SFunction[]{PaidMemberOrder::getPayTime, PaidMemberOrder::getId});
        return this.dao.selectList((Wrapper)lqw);
    }

    private UserBalanceRecord createBalanceRecord(PaidMemberOrder svipOrder, BigDecimal nowMoney) {
        UserBalanceRecord record = new UserBalanceRecord();
        record.setUid(svipOrder.getUid());
        record.setLinkId(svipOrder.getOrderNo());
        record.setLinkType("svip");
        record.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
        record.setAmount(svipOrder.getGiftBalance());
        record.setBalance(nowMoney.add(svipOrder.getGiftBalance()));
        record.setRemark(StrUtil.format((CharSequence)"\u8d2d\u4e70SVIP\u6210\u529f\uff0c\u4f59\u989d\u8d60\u9001{}\u5143", (Object[])new Object[]{svipOrder.getGiftBalance()}));
        return record;
    }

    private Boolean updatePaid(Integer id, String orderNo, Date cardExpirationTime) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(PaidMemberOrder::getPaid, (Object)1);
        wrapper.set(PaidMemberOrder::getPayTime, (Object)CrmebDateUtil.nowDateTime());
        wrapper.set(PaidMemberOrder::getCardExpirationTime, (Object)cardExpirationTime);
        wrapper.eq(PaidMemberOrder::getId, (Object)id);
        wrapper.eq(PaidMemberOrder::getOrderNo, (Object)orderNo);
        wrapper.eq(PaidMemberOrder::getPaid, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PaidMemberOrder getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PaidMemberOrder::getOrderNo, (Object)orderNo);
        return (PaidMemberOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<PaidMemberOrder> findAwaitUploadWechatList() {
        DateTime date = DateUtil.date();
        DateTime offsetMinute = DateUtil.offsetMinute((Date)date, (int)-10);
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PaidMemberOrder::getPaid, (Object)1);
        lqw.eq(PaidMemberOrder::getIsWechatShipping, (Object)0);
        lqw.eq(PaidMemberOrder::getPayType, (Object)"weixin");
        lqw.eq(PaidMemberOrder::getPayChannel, (Object)"mini");
        lqw.le(PaidMemberOrder::getPayTime, (Object)offsetMinute);
        return this.dao.selectList((Wrapper)lqw);
    }
}

