/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.service.service.OssService;
import com.zbkj.service.service.SystemConfigService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OssServiceImpl
implements OssService {
    private static final Logger logger = LoggerFactory.getLogger(OssServiceImpl.class);
    @Autowired
    private SystemConfigService systemConfigService;

    @Override
    public void upload(String webPth, String localFile, File file) {
        if (!file.exists()) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6" + localFile + "\u4e0d\u5b58\u5728\uff1a");
            throw new CrmebException("\u4e0a\u4f20\u6587\u4ef6" + localFile + "\u4e0d\u5b58\u5728\uff1a");
        }
        String bucketName = this.systemConfigService.getValueByKeyException("alStorageName");
        OSS ossClient = this.getOssClent();
        try {
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
            }
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, webPth, file);
            PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
        }
        catch (Exception e) {
            logger.error("\u963f\u91cc\u4e91\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            throw new CrmebException(e.getMessage());
        }
        finally {
            ossClient.shutdown();
        }
    }

    private OSS getOssClent() {
        this.systemConfigService.getValueByKeyException("alUploadUrl");
        String accessKey = this.systemConfigService.getValueByKeyException("alAccessKey");
        String secretKey = this.systemConfigService.getValueByKeyException("alSecretKey");
        this.systemConfigService.getValueByKeyException("alStorageName");
        String region = this.systemConfigService.getValueByKeyException("alStorageRegion");
        return new OSSClientBuilder().build(region, accessKey, secretKey);
    }
}

