/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.BillConstants;
import com.zbkj.common.constants.BrokerageRecordConstants;
import com.zbkj.common.constants.IntegralRecordConstants;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bill.Bill;
import com.zbkj.common.model.bill.MerchantBill;
import com.zbkj.common.model.cdkey.CardSecret;
import com.zbkj.common.model.groupbuy.GroupBuyActivitySku;
import com.zbkj.common.model.groupbuy.GroupBuyUser;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantBalanceRecord;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.OrderProfitSharing;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.model.order.RefundOrderInfo;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.seckill.SeckillProduct;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBrokerageRecord;
import com.zbkj.common.model.user.UserIntegralRecord;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.BillService;
import com.zbkj.service.service.CardSecretService;
import com.zbkj.service.service.CdkeyLibraryService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.MerchantBalanceRecordService;
import com.zbkj.service.service.MerchantBillService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderFlowRecordService;
import com.zbkj.service.service.OrderProfitSharingService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.OrderTaskService;
import com.zbkj.service.service.PayService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.RefundOrderInfoService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.RefundOrderStatusService;
import com.zbkj.service.service.SeckillProductService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.TemplateMessageService;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserIntegralRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.groupbuy.GroupBuyActivitySkuService;
import com.zbkj.service.service.groupbuy.GroupBuyUserService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class OrderTaskServiceImpl
implements OrderTaskService {
    private static final Logger logger = LoggerFactory.getLogger(OrderTaskServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OrderService orderService;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private PayService payService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private RefundOrderInfoService refundOrderInfoService;
    @Autowired
    private UserIntegralRecordService userIntegralRecordService;
    @Autowired
    private UserBrokerageRecordService userBrokerageRecordService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private OrderProfitSharingService orderProfitSharingService;
    @Autowired
    private MerchantBillService merchantBillService;
    @Autowired
    private BillService billService;
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private SystemNotificationService systemNotificationService;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private TemplateMessageService templateMessageService;
    @Autowired
    private SeckillProductService seckillProductService;
    @Autowired
    private MerchantBalanceRecordService merchantBalanceRecordService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private RefundOrderStatusService refundOrderStatusService;
    @Autowired
    private CardSecretService cardSecretService;
    @Autowired
    private CdkeyLibraryService cdkeyLibraryService;
    @Autowired
    private GroupBuyActivitySkuService groupBuyActivitySkuService;
    @Autowired
    private GroupBuyUserService groupBuyUserService;
    @Autowired
    private OrderFlowRecordService orderFlowRecordService;

    @Override
    public void cancelByUser() {
        String redisKey = "alterOrderCancelByUser";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.cancelByUser | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object data = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)data)) {
                try {
                    boolean result = this.userCancelOrder(String.valueOf(data));
                    if (!result) {
                        this.redisUtil.lPush(redisKey, data);
                    }
                }
                catch (Exception e) {
                    this.redisUtil.lPush(redisKey, data);
                }
            }
            ++i;
        }
    }

    private Boolean userCancelOrder(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("\u7528\u6237\u53d6\u6d88\u652f\u4ed8\u8ba2\u5355\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderNo);
            return Boolean.TRUE;
        }
        if (order.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        if (!order.getStatus().equals(OrderConstants.ORDER_STATUS_CANCEL)) {
            logger.error("\u7528\u6237\u53d6\u6d88\u652f\u4ed8\u8ba2\u5355\uff0c\u8ba2\u5355\u72b6\u6001\u8be5\u5f02\u5e38\uff0c\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderNo);
            return Boolean.TRUE;
        }
        if (order.getCancelStatus().equals(OrderConstants.ORDER_CANCEL_STATUS_NORMAL)) {
            logger.error("\u7528\u6237\u53d6\u6d88\u652f\u4ed8\u8ba2\u5355\uff0c\u8ba2\u5355\u72b6\u6001\u53d6\u6d88\u5f02\u5e38\uff0c\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderNo);
            return Boolean.FALSE;
        }
        if (order.getCancelStatus().equals(OrderConstants.ORDER_CANCEL_STATUS_SYSTEM)) {
            return Boolean.TRUE;
        }
        return this.commonOrderCancel(order, "user");
    }

    private UserIntegralRecord initOrderCancelIntegralRecord(Integer uid, Integer useIntegral, Integer integral, String orderNo) {
        UserIntegralRecord integralRecord = new UserIntegralRecord();
        integralRecord.setUid(uid);
        integralRecord.setLinkId(orderNo);
        integralRecord.setLinkType("order");
        integralRecord.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        integralRecord.setTitle(StrUtil.format((CharSequence)"\u8ba2\u5355\u53d6\u6d88\uff0c\u9000\u56de\u91d1\u989d\u62b5\u6263\u79ef\u5206\uff1a{}", (Object[])new Object[]{useIntegral}));
        integralRecord.setIntegral(useIntegral);
        integralRecord.setBalance(Integer.valueOf(integral + useIntegral));
        integralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        return integralRecord;
    }

    private UserIntegralRecord initIntegralOrderCancelIntegralRecord(Integer uid, Integer useIntegral, Integer integral, String orderNo) {
        UserIntegralRecord integralRecord = new UserIntegralRecord();
        integralRecord.setUid(uid);
        integralRecord.setLinkId(orderNo);
        integralRecord.setLinkType("order");
        integralRecord.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        integralRecord.setTitle(StrUtil.format((CharSequence)"\u79ef\u5206\u8ba2\u5355\u53d6\u6d88\uff0c\u9000\u56de\u5151\u6362\u79ef\u5206\uff1a{}", (Object[])new Object[]{useIntegral}));
        integralRecord.setIntegral(useIntegral);
        integralRecord.setBalance(Integer.valueOf(integral + useIntegral));
        integralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        return integralRecord;
    }

    @Override
    public void orderRefund() {
        String redisKey = "alterOrderRefundByUser";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.orderRefund | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object orderNoData = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)orderNoData)) {
                try {
                    Boolean result = this.refundAfterProcessing(orderNoData.toString());
                    if (!result.booleanValue()) {
                        this.redisUtil.lPush(redisKey, orderNoData);
                    }
                }
                catch (Exception e) {
                    logger.error("\u8ba2\u5355\u9000\u6b3e\u9519\u8bef\uff1a" + e.getMessage());
                    this.redisUtil.lPush(redisKey, orderNoData);
                }
            }
            ++i;
        }
    }

    private Boolean refundAfterProcessing(String refundOrderNo) {
        boolean isMerchantRecordUpdate;
        BigDecimal platRefundPayPrice;
        BigDecimal merRefundPayPrice;
        OrderProfitSharing orderProfitSharing;
        UserIntegralRecord gainIntegralRecord;
        RefundOrder refundOrder = this.refundOrderService.getInfoException(refundOrderNo);
        if (!refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND)) {
            throw new CrmebException("\u9000\u6b3e\u5355\u72b6\u6001\u5f02\u5e38");
        }
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        String orderNo = order.getOrderNo();
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrderNo);
        ArrayList integralRecordAddList = CollUtil.newArrayList((Object[])new UserIntegralRecord[0]);
        ArrayList integralRecordUpdateList = CollUtil.newArrayList((Object[])new UserIntegralRecord[0]);
        if (refundOrder.getRefundUseIntegral() > 0) {
            UserIntegralRecord userIntegralRecord = this.refundUseIntegralRecordInit(refundOrder, refundOrderInfo);
            integralRecordAddList.add(userIntegralRecord);
        }
        if (refundOrder.getRefundGainIntegral() > 0 && (gainIntegralRecord = this.userIntegralRecordService.getByOrderNoAndType(orderNo, IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD)).getStatus() < IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE) {
            if (gainIntegralRecord.getIntegral().equals(refundOrder.getRefundGainIntegral())) {
                gainIntegralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_INVALIDATION);
                gainIntegralRecord.setUpdateTime((Date)DateUtil.date());
            } else {
                gainIntegralRecord.setIntegral(Integer.valueOf(gainIntegralRecord.getIntegral() - refundOrder.getRefundGainIntegral()));
                gainIntegralRecord.setUpdateTime((Date)DateUtil.date());
            }
            integralRecordUpdateList.add(gainIntegralRecord);
        }
        ArrayList brokerageRecordList = CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        List<UserBrokerageRecord> userBrokerageRecordList = this.userBrokerageRecordService.getByOrderNo(orderNo);
        if (CollUtil.isNotEmpty(userBrokerageRecordList) && userBrokerageRecordList.get(0).getStatus() < BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE) {
            userBrokerageRecordList.forEach(r -> {
                if (r.getBrokerageLevel().equals(1)) {
                    if (r.getPrice().compareTo(refundOrderInfo.getRefundFirstBrokerageFee()) == 0) {
                        r.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_INVALIDATION);
                    } else {
                        r.setPrice(r.getPrice().subtract(refundOrderInfo.getRefundFirstBrokerageFee()));
                    }
                }
                if (r.getBrokerageLevel().equals(2)) {
                    if (r.getPrice().compareTo(refundOrderInfo.getRefundSecondBrokerageFee()) == 0) {
                        r.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_INVALIDATION);
                    } else {
                        r.setPrice(r.getPrice().subtract(refundOrderInfo.getRefundSecondBrokerageFee()));
                    }
                }
                r.setUpdateTime((Date)DateUtil.date());
                brokerageRecordList.add(r);
            });
        }
        if ((orderProfitSharing = this.orderProfitSharingService.getByOrderNo(orderNo)).getOrderPrice().compareTo(refundOrder.getRefundPrice()) == 0) {
            merRefundPayPrice = orderProfitSharing.getProfitSharingMerPrice();
            platRefundPayPrice = orderProfitSharing.getProfitSharingPlatPrice();
        } else if (orderProfitSharing.getOrderPrice().subtract(orderProfitSharing.getProfitSharingRefund()).compareTo(refundOrder.getRefundPrice()) == 0) {
            merRefundPayPrice = orderProfitSharing.getProfitSharingMerPrice().subtract(orderProfitSharing.getRefundProfitSharingMerPrice());
            platRefundPayPrice = orderProfitSharing.getProfitSharingPlatPrice().subtract(orderProfitSharing.getRefundProfitSharingPlatPrice());
        } else {
            BigDecimal payReRatio = refundOrder.getRefundPrice().divide(orderProfitSharing.getOrderPrice(), 10, RoundingMode.HALF_UP);
            merRefundPayPrice = orderProfitSharing.getProfitSharingMerPrice().multiply(payReRatio).setScale(2, RoundingMode.HALF_UP);
            if (merRefundPayPrice.add(orderProfitSharing.getRefundProfitSharingMerPrice()).compareTo(orderProfitSharing.getProfitSharingMerPrice()) > 0) {
                merRefundPayPrice = orderProfitSharing.getProfitSharingMerPrice().subtract(orderProfitSharing.getRefundProfitSharingMerPrice());
            }
            if ((platRefundPayPrice = orderProfitSharing.getProfitSharingPlatPrice().multiply(payReRatio).setScale(2, RoundingMode.HALF_UP)).add(orderProfitSharing.getRefundProfitSharingPlatPrice()).compareTo(orderProfitSharing.getProfitSharingPlatPrice()) > 0) {
                platRefundPayPrice = orderProfitSharing.getProfitSharingPlatPrice().subtract(orderProfitSharing.getRefundProfitSharingPlatPrice());
            }
        }
        orderProfitSharing.setRefundProfitSharingMerPrice(orderProfitSharing.getRefundProfitSharingMerPrice().add(merRefundPayPrice));
        orderProfitSharing.setRefundProfitSharingPlatPrice(orderProfitSharing.getRefundProfitSharingPlatPrice().add(platRefundPayPrice));
        if (refundOrder.getRefundPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
            orderProfitSharing.setRefundPlatCouponPrice(orderProfitSharing.getRefundPlatCouponPrice().add(refundOrder.getRefundPlatCouponPrice()));
        }
        if (refundOrder.getRefundFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
            orderProfitSharing.setRefundFirstBrokerageFee(orderProfitSharing.getRefundFirstBrokerageFee().add(refundOrder.getRefundFirstBrokerageFee()));
        }
        if (refundOrder.getRefundSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
            orderProfitSharing.setRefundSecondBrokerageFee(orderProfitSharing.getRefundSecondBrokerageFee().add(refundOrder.getRefundSecondBrokerageFee()));
        }
        if (refundOrderInfo.getRefundUseIntegral() > 0) {
            orderProfitSharing.setRefundUseIntegral(Integer.valueOf(orderProfitSharing.getRefundUseIntegral() + refundOrderInfo.getRefundUseIntegral()));
            orderProfitSharing.setRefundIntegralPrice(orderProfitSharing.getRefundIntegralPrice().add(refundOrderInfo.getRefundIntegralPrice()));
        }
        refundOrder.setMerchantRefundPrice(merRefundPayPrice);
        refundOrder.setPlatformRefundPrice(platRefundPayPrice);
        if (CollUtil.isEmpty((Collection)brokerageRecordList)) {
            refundOrder.setIsReplace(Boolean.valueOf(true));
        }
        MerchantBill merchantBill = this.initMerchantBillRefund(refundOrder);
        Bill platBill = new Bill();
        platBill.setOrderNo(refundOrder.getRefundOrderNo());
        platBill.setMerId(refundOrder.getMerId());
        platBill.setPm(BillConstants.BILL_PM_SUB);
        platBill.setAmount(platRefundPayPrice);
        platBill.setType("refund_order");
        platBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u9000\u6b3e\uff0c\u5e73\u53f0\u8fd4\u8fd8\u5206\u8d26\u91d1\u989d{}\u5143", (Object[])new Object[]{platRefundPayPrice}));
        orderProfitSharing.setProfitSharingRefund(orderProfitSharing.getProfitSharingRefund().add(refundOrder.getRefundPrice()));
        orderProfitSharing.setRefundFreightFee(orderProfitSharing.getRefundFreightFee().add(refundOrder.getRefundFreightFee()));
        merRefundPayPrice = merRefundPayPrice.add(refundOrder.getRefundFreightFee());
        MerchantBalanceRecord merchantBalanceRecord = this.merchantBalanceRecordService.getByLinkNo(refundOrder.getOrderNo());
        if (merchantBalanceRecord.getStatus().equals(1) || merchantBalanceRecord.getStatus().equals(2)) {
            BigDecimal subtract = merchantBalanceRecord.getAmount().subtract(merRefundPayPrice);
            if (subtract.compareTo(BigDecimal.ZERO) <= 0) {
                merchantBalanceRecord.setAmount(BigDecimal.ZERO);
                merchantBalanceRecord.setStatus(Integer.valueOf(4));
            } else {
                merchantBalanceRecord.setAmount(merchantBalanceRecord.getAmount().subtract(merRefundPayPrice));
            }
            isMerchantRecordUpdate = true;
        } else {
            isMerchantRecordUpdate = false;
        }
        merchantBalanceRecord.setUpdateTime((Date)DateUtil.date());
        Integer platCouponId = 0;
        Integer merCouponId = 0;
        OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(refundOrderInfo.getOrderDetailId());
        if (orderDetail.getMerCouponPrice().compareTo(BigDecimal.ZERO) > 0 && orderDetail.getPayNum().equals(orderDetail.getRefundNum())) {
            merCouponId = this.getRefundMerCouponId(refundOrder.getOrderNo());
        }
        if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0 && orderDetail.getPayNum().equals(orderDetail.getRefundNum())) {
            platCouponId = this.getRefundPlatCouponId(order.getPlatOrderNo());
        }
        ArrayList<Integer> couponIdList = new ArrayList<Integer>();
        if (merCouponId > 0) {
            couponIdList.add(merCouponId);
        }
        if (platCouponId > 0) {
            couponIdList.add(platCouponId);
        }
        logger.error(StrUtil.format((CharSequence)"\u552e\u540e\u5355\u540e\u7f6e\u4efb\u52a1\u4e2d\uff0c\u5546\u6237\u4f18\u60e0\u5238ID={}\uff0c\u5e73\u53f0\u4f18\u60e0\u5238ID={}", (Object[])new Object[]{merCouponId, platCouponId}));
        refundOrder.setUpdateTime((Date)DateUtil.date());
        orderProfitSharing.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.refundRollbackStock(refundOrderInfo, order.getType(), order.getSecondType());
            if (isMerchantRecordUpdate) {
                this.merchantBalanceRecordService.updateById(merchantBalanceRecord);
            } else {
                this.merchantService.operationBalance(refundOrder.getMerId(), refundOrder.getMerchantRefundPrice().add(refundOrder.getRefundFreightFee()), "sub");
            }
            this.merchantBillService.save(merchantBill);
            this.refundOrderService.updateById(refundOrder);
            if (CollUtil.isNotEmpty((Collection)integralRecordAddList)) {
                this.userIntegralRecordService.saveBatch(integralRecordAddList);
            }
            if (CollUtil.isNotEmpty((Collection)integralRecordUpdateList)) {
                this.userIntegralRecordService.updateBatchById(integralRecordUpdateList);
            }
            if (CollUtil.isNotEmpty((Collection)brokerageRecordList)) {
                this.userBrokerageRecordService.updateBatchById(brokerageRecordList);
            } else {
                BigDecimal platReplacePrice = refundOrderInfo.getRefundFirstBrokerageFee().add(refundOrderInfo.getRefundSecondBrokerageFee());
                Bill bill = new Bill();
                bill.setOrderNo(refundOrder.getRefundOrderNo());
                bill.setMerId(refundOrder.getMerId());
                bill.setPm(BillConstants.BILL_PM_SUB);
                bill.setAmount(platReplacePrice);
                bill.setType("refund_order");
                bill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u9000\u6b3e\uff0c\u5e73\u53f0\u4ee3\u6263\u4f63\u91d1\u5e94\u9000\u91d1\u989d{}\u5143", (Object[])new Object[]{platReplacePrice}));
                this.billService.save(bill);
            }
            if (refundOrderInfo.getRefundUseIntegral() > 0) {
                this.userService.updateIntegral(refundOrder.getUid(), refundOrderInfo.getRefundUseIntegral(), "add");
                Bill bill = new Bill();
                bill.setOrderNo(refundOrder.getRefundOrderNo());
                bill.setMerId(refundOrder.getMerId());
                bill.setPm(BillConstants.BILL_PM_ADD);
                bill.setAmount(refundOrderInfo.getRefundIntegralPrice());
                bill.setType("refund_order");
                bill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u9000\u6b3e\uff0c\u5e73\u53f0\u4ee3\u6263\u79ef\u5206\u62b5\u6263\u91d1\u989d\u8fd4\u8fd8{}\u5143", (Object[])new Object[]{refundOrderInfo.getRefundIntegralPrice()}));
                this.billService.save(bill);
            }
            this.billService.save(platBill);
            this.orderProfitSharingService.updateById(orderProfitSharing);
            if (CollUtil.isNotEmpty((Collection)couponIdList)) {
                this.couponUserService.rollbackByIds(couponIdList);
            }
            this.refundOrderStatusService.add(refundOrder.getRefundOrderNo(), "refund", "\u552e\u540e\u5355\u9000\u6b3e\u6210\u529f");
            return Boolean.TRUE;
        });
    }

    private Integer getRefundPlatCouponId(String platOrderNo) {
        List<Order> orderList = this.orderService.getByPlatOrderNo(platOrderNo);
        ArrayList orderDetailList = new ArrayList();
        orderList.forEach(o -> orderDetailList.addAll(this.orderDetailService.getByOrderNo(o.getOrderNo())));
        boolean isRefundCoupon = true;
        for (OrderDetail od : orderDetailList) {
            if (od.getPlatCouponPrice().compareTo(BigDecimal.ZERO) <= 0 || od.getPayNum().equals(od.getRefundNum())) continue;
            isRefundCoupon = false;
            break;
        }
        return isRefundCoupon ? orderList.get(0).getPlatCouponId() : 0;
    }

    private Integer getRefundMerCouponId(String orderNo) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(orderNo);
        boolean isRefund = true;
        for (OrderDetail orderDetail : orderDetailList) {
            if (orderDetail.getMerCouponPrice().compareTo(BigDecimal.ZERO) <= 0 || orderDetail.getPayNum() <= orderDetail.getRefundNum()) continue;
            isRefund = false;
            break;
        }
        if (!isRefund) {
            return 0;
        }
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
        return merchantOrder.getCouponId();
    }

    private MerchantBill initMerchantBillRefund(RefundOrder refundOrder) {
        MerchantBill merchantBill = new MerchantBill();
        merchantBill.setMerId(refundOrder.getMerId());
        merchantBill.setType("refund_order");
        merchantBill.setOrderNo(refundOrder.getRefundOrderNo());
        merchantBill.setUid(refundOrder.getUid());
        merchantBill.setPm(BillConstants.BILL_PM_SUB);
        merchantBill.setAmount(refundOrder.getMerchantRefundPrice().add(refundOrder.getRefundFreightFee()));
        merchantBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355{}\u9000\u6b3e{}\u5143\uff0c\u5546\u6237\u652f\u51fa{}\u5143,\u9000\u8fd0\u8d39{}\u5143", (Object[])new Object[]{refundOrder.getOrderNo(), refundOrder.getRefundPrice(), refundOrder.getMerchantRefundPrice(), refundOrder.getRefundFreightFee()}));
        return merchantBill;
    }

    private void refundRollbackStock(RefundOrderInfo refundOrderInfo, Integer orderType, Integer orderSecondType) {
        if (orderType.equals(OrderConstants.ORDER_TYPE_SECKILL)) {
            SeckillProduct seckillProduct = (SeckillProduct)this.seckillProductService.getById(refundOrderInfo.getProductId());
            this.seckillProductService.operationStock(seckillProduct.getId(), refundOrderInfo.getApplyRefundNum(), "add");
            ProductAttrValue seckillAttrValue = (ProductAttrValue)this.productAttrValueService.getById(refundOrderInfo.getAttrValueId());
            this.productAttrValueService.operationStock(seckillAttrValue.getId(), refundOrderInfo.getApplyRefundNum(), "add", seckillAttrValue.getType(), seckillAttrValue.getMarketingType(), seckillAttrValue.getVersion());
            Product product = (Product)this.productService.getById(seckillProduct.getProductId());
            this.productService.operationStock(product.getId(), refundOrderInfo.getApplyRefundNum(), "add");
            ProductAttrValue productAttrValue = (ProductAttrValue)this.productAttrValueService.getById(seckillAttrValue.getMasterId());
            this.productAttrValueService.operationStock(productAttrValue.getId(), refundOrderInfo.getApplyRefundNum(), "add", productAttrValue.getType(), productAttrValue.getMarketingType(), productAttrValue.getVersion());
            return;
        }
        if (orderSecondType.equals(OrderConstants.ORDER_SECOND_TYPE_RESERVATION)) {
            Product product = (Product)this.productService.getById(refundOrderInfo.getProductId());
            this.productService.operationSales(product.getId(), refundOrderInfo.getApplyRefundNum(), "sub");
            ProductAttrValue productAttrValue = (ProductAttrValue)this.productAttrValueService.getById(refundOrderInfo.getAttrValueId());
            this.productAttrValueService.operationSales(productAttrValue.getId(), refundOrderInfo.getApplyRefundNum(), "sub");
            return;
        }
        if (orderType.equals(OrderConstants.ORDER_TYPE_PITUAN)) {
            RefundOrder byRefundOrderNo = this.refundOrderService.getByRefundOrderNo(refundOrderInfo.getRefundOrderNo());
            Order order = this.orderService.getByOrderNo(byRefundOrderNo.getOrderNo());
            GroupBuyUser currentBuyUser = this.groupBuyUserService.getByOrderNo(order.getOrderNo());
            GroupBuyActivitySku groupBuyActivitySku = this.groupBuyActivitySkuService.getByAttrId(currentBuyUser.getGroupActivityId(), refundOrderInfo.getAttrValueId());
            this.groupBuyActivitySkuService.rollBackSKUStock(order, groupBuyActivitySku.getGroupActivityId(), refundOrderInfo.getAttrValueId(), refundOrderInfo.getApplyRefundNum());
        }
        if (orderSecondType.equals(OrderConstants.ORDER_SECOND_TYPE_CDKEY)) {
            OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(refundOrderInfo.getOrderDetailId());
            List csIdList = CrmebUtil.stringToArray((String)orderDetail.getCardSecretIds());
            ArrayList<CardSecret> cardSecretList = new ArrayList<CardSecret>();
            int i = 0;
            while (i < refundOrderInfo.getApplyRefundNum() && !CollUtil.isEmpty((Collection)csIdList)) {
                Integer cdId = (Integer)csIdList.get(i);
                CardSecret cardSecret = (CardSecret)this.cardSecretService.getById(cdId);
                cardSecret.setIsUse(Boolean.valueOf(false));
                cardSecretList.add(cardSecret);
                csIdList.remove(i);
            }
            if (CollUtil.isNotEmpty((Collection)csIdList)) {
                orderDetail.setCardSecretIds(StrUtil.join((CharSequence)",", (Object[])new Object[]{csIdList}));
                orderDetail.setUpdateTime((Date)DateUtil.date());
                this.orderDetailService.updateById(orderDetail);
            }
            Integer libraryId = ((CardSecret)cardSecretList.get(0)).getLibraryId();
            this.cardSecretService.updateBatchById(cardSecretList);
            this.cdkeyLibraryService.operationUseNum(libraryId, cardSecretList.size(), "sub");
            this.productService.operationStock(refundOrderInfo.getProductId(), refundOrderInfo.getApplyRefundNum(), "add");
        } else {
            this.productService.operationStock(refundOrderInfo.getProductId(), refundOrderInfo.getApplyRefundNum(), "add");
        }
        ProductAttrValue attrValue = (ProductAttrValue)this.productAttrValueService.getById(refundOrderInfo.getAttrValueId());
        this.productAttrValueService.operationStock(attrValue.getId(), refundOrderInfo.getApplyRefundNum(), "add", attrValue.getType(), attrValue.getMarketingType(), attrValue.getVersion());
    }

    private UserIntegralRecord refundUseIntegralRecordInit(RefundOrder refundOrder, RefundOrderInfo refundOrderInfo) {
        UserIntegralRecord record = new UserIntegralRecord();
        record.setUid(refundOrder.getUid());
        record.setLinkId(refundOrder.getRefundOrderNo());
        record.setLinkType("refund");
        record.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        record.setTitle("\u8ba2\u5355\u9000\u6b3e");
        record.setIntegral(refundOrderInfo.getRefundUseIntegral());
        record.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u9000\u6b3e\uff0c\u8fd4\u8fd8\u652f\u4ed8\u4f7f\u7528\u7684{}\u79ef\u5206", (Object[])new Object[]{record.getIntegral()}));
        record.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        return record;
    }

    @Override
    public void orderPaySuccessAfter() {
        String redisKey = "orderPaySuccessTask";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.orderPaySuccessAfter | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object data = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)data)) {
                try {
                    Boolean result = this.payService.payAfterProcessingTemp(String.valueOf(data));
                    if (!result.booleanValue()) {
                        logger.error("\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u540e\u7f6e\u5904\u7406\u5931\u8d25\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)String.valueOf(data));
                        this.redisUtil.lPush(redisKey, data);
                    }
                }
                catch (Exception e) {
                    logger.error("order pay task error exception : {}", (Object)e.getMessage());
                    this.redisUtil.lPush(redisKey, data);
                }
            }
            ++i;
        }
    }

    @Override
    public void autoCancel() {
        String redisKey = "order_auto_cancel_key";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.autoCancel | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object data = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)data)) {
                try {
                    boolean result = this.orderAutoCancel(String.valueOf(data));
                    if (!result) {
                        this.redisUtil.lPush(redisKey, data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.redisUtil.lPush(redisKey, data);
                }
            }
            ++i;
        }
    }

    private Boolean orderAutoCancel(String orderNo) {
        DateTime cancelTime;
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("\u81ea\u52a8\u53d6\u6d88\u652f\u4ed8\u8ba2\u5355\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderNo);
            return Boolean.TRUE;
        }
        if (order.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        if (order.getStatus().equals(OrderConstants.ORDER_STATUS_CANCEL)) {
            return Boolean.TRUE;
        }
        if (!order.getCancelStatus().equals(OrderConstants.ORDER_CANCEL_STATUS_NORMAL)) {
            return Boolean.TRUE;
        }
        boolean isRedis = true;
        if (this.redisUtil.exists(StrUtil.format((CharSequence)"ORDER-EXPIRATION-TIME:{}", (Object[])new Object[]{order.getOrderNo()})).booleanValue()) {
            String expireTime = (String)this.redisUtil.get(StrUtil.format((CharSequence)"ORDER-EXPIRATION-TIME:{}", (Object[])new Object[]{order.getOrderNo()}));
            cancelTime = DateUtil.parseDateTime((String)expireTime);
        } else {
            cancelTime = DateUtil.offset((Date)order.getCreateTime(), (DateField)DateField.MINUTE, (int)this.crmebConfig.getOrderCancelTime());
            isRedis = false;
        }
        long between = DateUtil.between((Date)cancelTime, (Date)DateUtil.date(), (DateUnit)DateUnit.SECOND, (boolean)false);
        if (between < 0L) {
            if (!isRedis) {
                DateTime expirationTime = DateUtil.offset((Date)order.getCreateTime(), (DateField)DateField.MINUTE, (int)this.crmebConfig.getOrderCancelTime());
                long expireTime = DateUtil.between((Date)DateUtil.date(), (Date)expirationTime, (DateUnit)DateUnit.SECOND, (boolean)true);
                this.redisUtil.set(StrUtil.format((CharSequence)"ORDER-EXPIRATION-TIME:{}", (Object[])new Object[]{order.getOrderNo()}), (Object)expirationTime.toString(), Long.valueOf(expireTime));
            }
            return Boolean.FALSE;
        }
        return this.commonOrderCancel(order, "auto");
    }

    private Boolean commonOrderCancel(Order order, String cancelMethod) {
        User user = (User)this.userService.getById(order.getUid());
        List<MerchantOrder> merchantOrderList = this.merchantOrderService.getByOrderNo(order.getOrderNo());
        ArrayList<Integer> couponIdList = new ArrayList<Integer>();
        merchantOrderList.forEach(merchantOrder -> {
            if (merchantOrder.getCouponId() > 0) {
                couponIdList.add(merchantOrder.getCouponId());
            }
        });
        if (order.getPlatCouponId() > 0) {
            couponIdList.add(order.getPlatCouponId());
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean rollbackStock;
            UserIntegralRecord userIntegralRecord;
            if (cancelMethod.equals("auto")) {
                Boolean cancel = this.orderService.cancel(order.getOrderNo(), false);
                if (!cancel.booleanValue()) {
                    logger.error("\u81ea\u52a8\u53d6\u6d88\u8ba2\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)order.getOrderNo());
                    e.setRollbackOnly();
                    return Boolean.FALSE;
                }
                this.orderFlowRecordService.orderCancel(order.getOrderNo(), 0, cancelMethod);
            }
            if (CollUtil.isNotEmpty((Collection)couponIdList)) {
                this.couponUserService.rollbackByIds(couponIdList);
            }
            if (order.getUseIntegral() > 0) {
                this.userService.updateIntegral(order.getUid(), order.getUseIntegral(), "add");
                userIntegralRecord = this.initOrderCancelIntegralRecord(user.getId(), order.getUseIntegral(), user.getIntegral(), order.getOrderNo());
                this.userIntegralRecordService.save(userIntegralRecord);
            }
            if (order.getRedeemIntegral() > 0) {
                this.userService.updateIntegral(order.getUid(), order.getRedeemIntegral(), "add");
                userIntegralRecord = this.initIntegralOrderCancelIntegralRecord(user.getId(), order.getRedeemIntegral(), user.getIntegral(), order.getOrderNo());
                this.userIntegralRecordService.save(userIntegralRecord);
            }
            if (!(rollbackStock = this.rollbackStock(order)).booleanValue()) {
                e.setRollbackOnly();
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    private Boolean rollbackStock(Order order) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        if (CollUtil.isEmpty(orderDetailList)) {
            logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u672a\u627e\u5230\u5546\u54c1\u8be6\u60c5,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
            return false;
        }
        Boolean result = false;
        if (order.getType().equals(OrderConstants.ORDER_TYPE_SECKILL)) {
            String cardSecretIds;
            OrderDetail seckillOrderDetail = orderDetailList.get(0);
            SeckillProduct seckillProduct = (SeckillProduct)this.seckillProductService.getById(seckillOrderDetail.getProductId());
            result = this.seckillProductService.operationStock(seckillProduct.getId(), seckillOrderDetail.getPayNum(), "add");
            if (!result.booleanValue()) {
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u2014\u2014\u79d2\u6740\u5546\u54c1\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return result;
            }
            ProductAttrValue seckillAttrValue = (ProductAttrValue)this.productAttrValueService.getById(seckillOrderDetail.getAttrValueId());
            result = this.productAttrValueService.operationStock(seckillAttrValue.getId(), seckillOrderDetail.getPayNum(), "add", seckillAttrValue.getType(), seckillAttrValue.getMarketingType(), seckillAttrValue.getVersion());
            if (!result.booleanValue()) {
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u2014\u2014\u79d2\u6740\u5546\u54c1sku\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return result;
            }
            Product product = (Product)this.productService.getById(seckillProduct.getProductId());
            result = this.productService.operationStock(product.getId(), seckillOrderDetail.getPayNum(), "add");
            if (!result.booleanValue()) {
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u2014\u2014\u79d2\u6740\u8ba2\u5355\u57fa\u7840\u5546\u54c1\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return result;
            }
            ProductAttrValue productAttrValue = (ProductAttrValue)this.productAttrValueService.getById(seckillAttrValue.getMasterId());
            result = this.productAttrValueService.operationStock(productAttrValue.getId(), seckillOrderDetail.getPayNum(), "add", productAttrValue.getType(), productAttrValue.getMarketingType(), productAttrValue.getVersion());
            if (!result.booleanValue()) {
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u2014\u2014\u79d2\u6740\u8ba2\u5355\u57fa\u7840\u5546\u54c1sku\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return result;
            }
            if (productAttrValue.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY) && !(result = this.cardSecretService.cancelConsume(CrmebUtil.stringToArray((String)(cardSecretIds = seckillOrderDetail.getCardSecretIds())))).booleanValue()) {
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u2014\u2014\u79d2\u6740\u8ba2\u5355\u5361\u5bc6\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return result;
            }
            return Boolean.TRUE;
        }
        if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_RESERVATION)) {
            OrderDetail orderDetail = orderDetailList.get(0);
            Product product = (Product)this.productService.getById(orderDetail.getProductId());
            if (ObjectUtil.isNotNull((Object)product) && !(result = this.productService.operationSales(product.getId(), orderDetail.getPayNum(), "sub")).booleanValue()) {
                logger.error("\u8ba2\u5355\u56de\u6eda\u9500\u91cf\u2014\u2014\u5546\u54c1\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return result;
            }
            ProductAttrValue productAttrValue = (ProductAttrValue)this.productAttrValueService.getById(orderDetail.getAttrValueId());
            if (ObjectUtil.isNotNull((Object)productAttrValue) && !(result = this.productAttrValueService.operationSales(productAttrValue.getId(), orderDetail.getPayNum(), "sub")).booleanValue()) {
                logger.error("\u8ba2\u5355\u56de\u6eda\u9500\u91cf\u2014\u2014\u5546\u54c1sku\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return result;
            }
            return Boolean.TRUE;
        }
        for (OrderDetail orderDetail : orderDetailList) {
            String cardSecretIds;
            Boolean rollBackSKUStock;
            GroupBuyActivitySku groupBuyActivitySku;
            if (order.getType().equals(OrderConstants.ORDER_TYPE_PITUAN) && ObjectUtil.isNotNull((Object)(groupBuyActivitySku = this.groupBuyActivitySkuService.getByAttrId(orderDetail.getGroupBuyActivityId(), orderDetail.getAttrValueId()))) && !(rollBackSKUStock = this.groupBuyActivitySkuService.rollBackSKUStock(order, groupBuyActivitySku.getGroupActivityId(), groupBuyActivitySku.getSkuId(), orderDetail.getPayNum())).booleanValue()) {
                logger.error("\u62fc\u56e2\u56de\u6eda\u5e93\u5b58\u5931\u8d25\uff0corder_no = {}, groupBuyActivityId = {}, skuId = {}", new Object[]{order.getOrderNo(), groupBuyActivitySku.getGroupActivityId(), groupBuyActivitySku.getId()});
                break;
            }
            Product product = (Product)this.productService.getById(orderDetail.getProductId());
            if (ObjectUtil.isNotNull((Object)product) && !(result = this.productService.operationStock(product.getId(), orderDetail.getPayNum(), "add")).booleanValue()) {
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u2014\u2014\u5546\u54c1\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                break;
            }
            ProductAttrValue productAttrValue = (ProductAttrValue)this.productAttrValueService.getById(orderDetail.getAttrValueId());
            if (ObjectUtil.isNotNull((Object)productAttrValue) && !(result = this.productAttrValueService.operationStock(productAttrValue.getId(), orderDetail.getPayNum(), "add", productAttrValue.getType(), productAttrValue.getMarketingType(), productAttrValue.getVersion())).booleanValue()) {
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u2014\u2014\u5546\u54c1sku\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                break;
            }
            if (!order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_CDKEY) || (result = this.cardSecretService.cancelConsume(CrmebUtil.stringToArray((String)(cardSecretIds = orderDetail.getCardSecretIds())))).booleanValue()) continue;
            logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u2014\u2014\u5546\u54c1\u5361\u5bc6\u5904\u7406\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
            break;
        }
        return result;
    }

    @Override
    public void orderReceiving() {
        String redisKey = "alterOrderTakeByUser";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.orderReceiving | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object data = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)data)) {
                try {
                    Boolean result = this.takeDeliveryAfter(String.valueOf(data));
                    if (!result.booleanValue()) {
                        this.redisUtil.lPush(redisKey, data);
                    }
                }
                catch (Exception e) {
                    this.redisUtil.lPush(redisKey, data);
                }
            }
            ++i;
        }
    }

    private Boolean takeDeliveryAfter(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("\u8ba2\u5355\u6536\u8d27task\u5904\u7406\uff0c\u672a\u627e\u5230\u8ba2\u5355\uff0corderNo={}", (Object)orderNo);
            return Boolean.FALSE;
        }
        User user = (User)this.userService.getById(order.getUid());
        ArrayList<String> nodeKeyList = new ArrayList<String>();
        nodeKeyList.add("merchant_share_node");
        nodeKeyList.add("retail_store_brokerage_share_node");
        nodeKeyList.add("integral_freeze_node");
        MyRecord nodeRecord = this.systemConfigService.getValuesByKeyList(nodeKeyList);
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            String integralDayStr;
            String integralFreezeNode;
            String retailStoreBrokerageShareFreezeDayStr;
            String retailStoreBrokerageShareNode;
            String merchantShareNodeFreezeDayStr;
            String merchantShareNode = nodeRecord.getStr("merchant_share_node");
            if (StrUtil.isNotBlank((CharSequence)merchantShareNode) && "receipt".equals(merchantShareNode) && StrUtil.isNotBlank((CharSequence)(merchantShareNodeFreezeDayStr = this.systemConfigService.getValueByKey("merchant_share_freeze_time")))) {
                this.orderMerchantShareFreezingOperation(orderNo, Integer.parseInt(merchantShareNodeFreezeDayStr));
            }
            if (StrUtil.isNotBlank((CharSequence)(retailStoreBrokerageShareNode = nodeRecord.getStr("retail_store_brokerage_share_node"))) && "receipt".equals(retailStoreBrokerageShareNode) && StrUtil.isNotBlank((CharSequence)(retailStoreBrokerageShareFreezeDayStr = this.systemConfigService.getValueByKey("retail_store_brokerage_freezing_time")))) {
                this.orderBrokerageShareFreezingOperation(orderNo, Integer.parseInt(retailStoreBrokerageShareFreezeDayStr));
            }
            if (StrUtil.isNotBlank((CharSequence)(integralFreezeNode = nodeRecord.getStr("integral_freeze_node"))) && "receipt".equals(integralFreezeNode) && StrUtil.isNotBlank((CharSequence)(integralDayStr = this.systemConfigService.getValueByKey("freeze_integral_day")))) {
                this.orderIntegralFreezingOperation(orderNo, Integer.parseInt(integralDayStr));
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.pushMessageOrder(order, user);
        }
        return execute;
    }

    @Override
    public void autoComplete() {
        Integer autoCompleteDay = Integer.parseInt(this.systemConfigService.getValueByKey("auto_complete_day"));
        List<Order> orderList = this.orderService.findCanCompleteOrder(autoCompleteDay);
        if (CollUtil.isEmpty(orderList)) {
            logger.info("OrderTaskServiceImpl.autoComplete | size:0");
            return;
        }
        List<String> orderNoList = orderList.stream().map(Order::getOrderNo).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.orderService.batchCompleteByOrderNo(orderNoList);
            orderNoList.forEach(orderNo -> this.orderFlowRecordService.orderComplete((String)orderNo));
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            logger.error("\u8ba2\u5355\u81ea\u52a8\u5b8c\u6210\uff1a\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25\uff0corderNoList = {}", (Object)JSON.toJSONString(orderNoList));
        }
        this.asyncService.orderCompleteAfterFreezingOperation(orderNoList);
    }

    private void orderIntegralFreezingOperation(String orderNo, Integer freezeDay) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (freezeDay > 0) {
            UserIntegralRecord record = this.userIntegralRecordService.getByOrderNoAndType(orderNo, IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
            if (ObjectUtil.isNull((Object)record)) {
                return;
            }
            if (!record.getStatus().equals(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_CREATE)) {
                return;
            }
            record.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_FROZEN);
            record.setFrozenTime(freezeDay);
            DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)freezeDay);
            long thawTime = dateTime.getTime();
            record.setThawTime(Long.valueOf(thawTime));
            record.setUpdateTime((Date)DateUtil.date());
            boolean batch = this.userIntegralRecordService.updateById(record);
            if (!batch) {
                logger.error("\u8ba2\u5355\u79ef\u5206\u51bb\u7ed3\u5904\u7406\u5931\u8d25\uff0c\u8ba2\u5355\u53f7={}", (Object)order.getOrderNo());
            }
            return;
        }
        User user = (User)this.userService.getById(order.getUid());
        if (ObjectUtil.isNull((Object)user)) {
            logger.error("\u8ba2\u5355\u79ef\u5206\u51bb\u7ed3\u5904\u7406\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8ba2\u5355\u7f16\u53f7={}", (Object)order.getOrderNo());
            return;
        }
        Integer balance = user.getIntegral();
        UserIntegralRecord record = this.userIntegralRecordService.getByOrderNoAndType(orderNo, IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        if (ObjectUtil.isNull((Object)record)) {
            return;
        }
        if (record.getStatus().equals(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE)) {
            return;
        }
        record.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        long thawTime = DateUtil.current((boolean)false);
        record.setFrozenTime(freezeDay);
        record.setThawTime(Long.valueOf(thawTime));
        balance = balance + record.getIntegral();
        record.setBalance(balance);
        record.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.userIntegralRecordService.updateById(record);
            this.userService.updateIntegral(user.getId(), record.getIntegral(), "add");
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error("\u8ba2\u5355\u79ef\u5206\u51bb\u7ed3\u5904\u7406\uff1a\u76f4\u63a5\u89e3\u51bb\u5931\u8d25\uff0c\u8ba2\u5355\u7f16\u53f7={}", (Object)order.getOrderNo());
        }
    }

    private void orderBrokerageShareFreezingOperation(String orderNo, Integer freezeDay) {
        Order order = this.orderService.getByOrderNo(orderNo);
        ArrayList<UserBrokerageRecord> recordList = new ArrayList<UserBrokerageRecord>();
        if (freezeDay > 0) {
            List<UserBrokerageRecord> brokerageRecordList = this.userBrokerageRecordService.findListByLinkNoAndLinkType(orderNo, "order");
            if (CollUtil.isEmpty(brokerageRecordList)) {
                return;
            }
            for (UserBrokerageRecord record : brokerageRecordList) {
                if (!record.getStatus().equals(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE)) continue;
                record.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_FROZEN);
                record.setFrozenTime(freezeDay);
                DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)record.getFrozenTime());
                long thawTime = dateTime.getTime();
                record.setThawTime(Long.valueOf(thawTime));
                record.setUpdateTime((Date)DateUtil.date());
                recordList.add(record);
            }
            if (CollUtil.isEmpty(recordList)) {
                return;
            }
            this.userBrokerageRecordService.updateBatchById(recordList);
            return;
        }
        List<UserBrokerageRecord> brokerageRecordList = this.userBrokerageRecordService.findListByLinkNoAndLinkType(orderNo, "order");
        if (CollUtil.isEmpty(brokerageRecordList)) {
            return;
        }
        for (UserBrokerageRecord record : brokerageRecordList) {
            User user;
            if (!record.getStatus().equals(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE) || ObjectUtil.isNull((Object)(user = (User)this.userService.getById(record.getUid())))) continue;
            record.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
            BigDecimal balance = user.getBrokeragePrice().add(record.getPrice());
            record.setBalance(balance);
            record.setUpdateTime((Date)DateUtil.date());
            recordList.add(record);
        }
        if (CollUtil.isEmpty(recordList)) {
            return;
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.userBrokerageRecordService.updateBatchById(recordList);
            recordList.forEach(record -> this.userService.updateBrokerage(record.getUid(), record.getPrice(), "add"));
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error(StrUtil.format((CharSequence)"\u4f63\u91d1\u89e3\u51bb\u5904\u7406\u2014\u6570\u636e\u5e93\u51fa\u9519\uff0c\u8ba2\u5355\u7f16\u53f7 = {}", (Object[])new Object[]{order.getOrderNo()}));
        }
    }

    private void orderMerchantShareFreezingOperation(String orderNo, Integer freezeDay) {
        Order order = this.orderService.getByOrderNo(orderNo);
        MerchantBalanceRecord record = this.merchantBalanceRecordService.getByLinkNo(orderNo);
        if (ObjectUtil.isNull((Object)record)) {
            return;
        }
        if (!record.getStatus().equals(1)) {
            return;
        }
        if (freezeDay > 0) {
            record.setStatus(Integer.valueOf(2));
            record.setFrozenTime(freezeDay);
            DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)record.getFrozenTime());
            long thawTime = dateTime.getTime();
            record.setThawTime(Long.valueOf(thawTime));
            record.setUpdateTime((Date)DateUtil.date());
            this.merchantBalanceRecordService.updateById(record);
            return;
        }
        record.setStatus(Integer.valueOf(3));
        Merchant merchant = (Merchant)this.merchantService.getById(record.getMerId());
        record.setBalance(merchant.getBalance().add(record.getAmount()));
        record.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.merchantBalanceRecordService.updateById(record);
            this.merchantService.operationBalance(record.getMerId(), record.getAmount(), "add");
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error(StrUtil.format((CharSequence)"\u5546\u6237\u4f59\u989d\u89e3\u51bb\u5904\u7406\u2014\u6570\u636e\u5e93\u51fa\u9519\uff0c\u8ba2\u5355\u7f16\u53f7 = {}", (Object[])new Object[]{order.getOrderNo()}));
        }
    }

    private void pushMessageOrder(Order order, User user) {
        SystemNotification notification = this.systemNotificationService.getByMark("receiptGoods");
        if (order.getPayChannel().equals("h5")) {
            return;
        }
        if (!order.getPayType().equals("weixin")) {
            return;
        }
        HashMap<String, String> temMap = new HashMap<String, String>();
        if (order.getPayChannel().equals("public") && notification.getIsWechat().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_WECHAT);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("first", "\u60a8\u8d2d\u4e70\u7684\u5546\u54c1\u5df2\u786e\u8ba4\u6536\u8d27\uff01");
            temMap.put("keyword1", order.getOrderNo());
            temMap.put("keyword2", "\u5df2\u6536\u8d27");
            temMap.put("keyword3", CrmebDateUtil.nowDateTimeStr());
            temMap.put("keyword4", "\u8be6\u60c5\u8bf7\u8fdb\u5165\u8ba2\u5355\u67e5\u770b");
            temMap.put("remark", "\u611f\u8c22\u4f60\u7684\u4f7f\u7528\u3002");
            this.templateMessageService.pushTemplateMessage(notification.getWechatId(), temMap, userToken.getToken());
        } else if (notification.getIsRoutine().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            List<OrderDetail> orderInvoiceDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
            List productNameList = orderInvoiceDetailList.stream().map(OrderDetail::getProductName).collect(Collectors.toList());
            String storeNameAndCarNumString = String.join((CharSequence)",", productNameList);
            if (StrUtil.isBlank((CharSequence)storeNameAndCarNumString)) {
                return;
            }
            if (storeNameAndCarNumString.length() > 20) {
                storeNameAndCarNumString = storeNameAndCarNumString.substring(0, 15) + "***";
            }
            temMap.put("character_string6", order.getOrderNo());
            temMap.put("date5", CrmebDateUtil.nowDateTimeStr());
            temMap.put("thing2", storeNameAndCarNumString);
            this.templateMessageService.pushMiniTemplateMessage(notification.getRoutineId(), temMap, userToken.getToken());
        }
    }

    @Override
    public void autoTakeDelivery() {
        DateTime nowDate;
        DateTime dateTime;
        List<Object> orderList;
        int day = 14;
        String autoDay = this.systemConfigService.getValueByKey("auto_take_delivery_day");
        if (StrUtil.isNotBlank((CharSequence)autoDay) && Integer.parseInt(autoDay) >= 1) {
            day = Integer.parseInt(autoDay);
        }
        if (CollUtil.isEmpty(orderList = this.orderService.findAwaitTakeDeliveryOrderList((dateTime = DateUtil.offsetDay((Date)(nowDate = DateUtil.date()), (int)(-day))).toString()))) {
            return;
        }
        if (CollUtil.isEmpty(orderList = orderList.stream().filter(order -> !order.getType().equals(1)).collect(Collectors.toList()))) {
            return;
        }
        List<String> orderNoList = orderList.stream().map(Order::getOrderNo).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            orderNoList.forEach(orderNo -> {
                this.orderService.takeDelivery((String)orderNo);
                this.orderDetailService.takeDelivery((String)orderNo);
                this.orderFlowRecordService.orderReceipt((String)orderNo, 0, "auto", null);
            });
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error("\u81ea\u52a8\u6536\u8d27\u64cd\u4f5c\u6570\u636e\u6570\u5931\u8d25\uff1a\u8ba2\u5355\u53f7:{}", (Object)StringUtils.join(orderNoList, (String)","));
            return;
        }
        orderNoList.forEach(orderNo -> this.redisUtil.lPush("alterOrderTakeByUser", orderNo));
    }

    @Override
    public void queryRefundOrderAliPayRefund() {
        String redisKey = "refundOrderAliPayTask";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.queryRefundOrderAliPayRefund | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object data = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)data)) {
                try {
                    boolean result = this.refundOrderService.queryAliPayRefund(String.valueOf(data));
                    if (!result) {
                        this.redisUtil.lPush(redisKey, data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.redisUtil.lPush(redisKey, data);
                }
            }
            ++i;
        }
    }
}

