/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.order.OrderFlowRecord;
import com.zbkj.service.dao.OrderFlowRecordDao;
import com.zbkj.service.service.OrderFlowRecordService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class OrderFlowRecordServiceImpl
extends ServiceImpl<OrderFlowRecordDao, OrderFlowRecord>
implements OrderFlowRecordService {
    @Resource
    private OrderFlowRecordDao dao;

    @Override
    public Boolean createRecord(String orderNo, String flowType, String flowMessage, Integer operatorId, Integer operatorType) {
        OrderFlowRecord record = new OrderFlowRecord();
        record.setOrderNo(orderNo);
        record.setFlowType(flowType);
        record.setFlowMessage(flowMessage);
        record.setOperatorId(operatorId);
        record.setOperatorType(operatorType);
        record.setOperatorTime(new Date());
        return this.save(record);
    }

    @Override
    public Boolean orderCreate(String orderNo, Integer operatorId) {
        return this.createRecord(orderNo, "create", "\u8ba2\u5355\u751f\u6210", operatorId, 1);
    }

    @Override
    public Boolean orderPaid(String orderNo, Integer operatorId) {
        return this.createRecord(orderNo, "paid", "\u7528\u6237\u4ed8\u6b3e\u6210\u529f", operatorId, 1);
    }

    @Override
    public Boolean orderCancel(String orderNo, Integer operatorId, String cancelMethod) {
        int operatorType;
        String cancelMessage;
        if ("auto".equals(cancelMethod)) {
            cancelMessage = "\u8ba2\u5355\u8d85\u65f6,\u7cfb\u7edf\u81ea\u52a8\u53d6\u6d88\u8ba2\u5355";
            operatorType = 0;
        } else {
            cancelMessage = "\u7528\u6237\u53d6\u6d88\u8ba2\u5355";
            operatorType = 1;
        }
        return this.createRecord(orderNo, "cancel", cancelMessage, operatorId, operatorType);
    }

    @Override
    public Boolean orderSplit(String orderNo, String newOrderNo) {
        List<OrderFlowRecord> recordList = this.findRecordListByOrderNo(orderNo);
        recordList.forEach(record -> {
            record.setId(null);
            record.setOrderNo(newOrderNo);
        });
        return this.saveBatch(recordList);
    }

    @Override
    public Boolean orderSplit(String orderNo, List<String> newOrderNoList) {
        ArrayList flowRecordList = new ArrayList();
        List<OrderFlowRecord> recordList = this.findRecordListByOrderNo(orderNo);
        for (String newOrderNo : newOrderNoList) {
            List orderFlowRecordList = recordList.stream().map(e -> {
                OrderFlowRecord flowRecord = new OrderFlowRecord();
                BeanUtils.copyProperties((Object)e, (Object)flowRecord);
                flowRecord.setId(null);
                flowRecord.setOrderNo(newOrderNo);
                return flowRecord;
            }).collect(Collectors.toList());
            flowRecordList.addAll(orderFlowRecordList);
        }
        return this.saveBatch(flowRecordList);
    }

    @Override
    public Boolean orderDelivery(String orderNo, String flowMessage, Integer operatorId, Integer operatorType) {
        return this.createRecord(orderNo, "delivery", flowMessage, operatorId, operatorType);
    }

    @Override
    public Boolean orderReceipt(String orderNo, Integer operatorId, String method, Integer operatorType) {
        int operatorTy;
        String cancelMessage;
        if ("auto".equals(method)) {
            cancelMessage = "\u7cfb\u7edf\u81ea\u52a8\u6536\u8d27";
            operatorTy = 0;
        } else if ("user".equals(method)) {
            cancelMessage = "\u7528\u6237\u5df2\u6536\u8d27";
            operatorTy = 1;
        } else {
            cancelMessage = "\u5546\u5bb6\u5df2\u6838\u9500";
            operatorTy = operatorType;
        }
        return this.createRecord(orderNo, "receipt", cancelMessage, operatorId, operatorTy);
    }

    @Override
    public Boolean orderComplete(String orderNo) {
        return this.createRecord(orderNo, "complete", "\u8ba2\u5355\u5df2\u5b8c\u6210", 0, 0);
    }

    @Override
    public Boolean orderRefund(String orderNo) {
        return this.createRecord(orderNo, "refund", "\u8ba2\u5355\u5df2\u9000\u6b3e", 0, 0);
    }

    @Override
    public List<OrderFlowRecord> findRecordListByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(OrderFlowRecord::getOrderNo, (Object)orderNo);
        lqw.orderByDesc((Object[])new SFunction[]{OrderFlowRecord::getOperatorTime, OrderFlowRecord::getId});
        return this.dao.selectList((Wrapper)lqw);
    }
}

