/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.service.dao.MerchantOrderDao;
import com.zbkj.service.service.MerchantOrderService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MerchantOrderServiceImpl
extends ServiceImpl<MerchantOrderDao, MerchantOrder>
implements MerchantOrderService {
    @Resource
    private MerchantOrderDao dao;

    @Override
    public List<MerchantOrder> getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantOrder::getOrderNo, (Object)orderNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public MerchantOrder getOneByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantOrder::getOrderNo, (Object)orderNo);
        lqw.last(" limit 1");
        return (MerchantOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public MerchantOrder getOneByVerifyCode(String verifyCode) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantOrder::getVerifyCode, (Object)verifyCode);
        lqw.orderByDesc(MerchantOrder::getId);
        lqw.last("limit 1");
        return (MerchantOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public MerchantOrder getByVerifyCodeForMerchant(String verifyCode, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantOrder::getVerifyCode, (Object)verifyCode);
        lqw.eq(MerchantOrder::getMerId, (Object)merId);
        lqw.orderByDesc(MerchantOrder::getId);
        lqw.last("limit 1");
        return (MerchantOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Map<String, List<MerchantOrder>> getMapByOrderNoList(List<String> orderNoList) {
        if (CollUtil.isEmpty(orderNoList)) {
            return new HashMap<String, List<MerchantOrder>>();
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(MerchantOrder::getOrderNo, orderNoList);
        List merchantOrderList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)merchantOrderList)) {
            return new HashMap<String, List<MerchantOrder>>();
        }
        return merchantOrderList.stream().collect(Collectors.groupingBy(MerchantOrder::getOrderNo));
    }
}

