/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.constants.IntegralRecordConstants;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantBalanceRecord;
import com.zbkj.service.dao.MerchantBrokerageRecordDao;
import com.zbkj.service.service.MerchantBalanceRecordService;
import com.zbkj.service.service.MerchantService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class MerchantBalanceRecordServiceImpl
extends ServiceImpl<MerchantBrokerageRecordDao, MerchantBalanceRecord>
implements MerchantBalanceRecordService {
    private static final Logger log = LoggerFactory.getLogger(MerchantBalanceRecordServiceImpl.class);
    @Resource
    private MerchantBrokerageRecordDao dao;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public MerchantBalanceRecord getByLinkNo(String linkNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantBalanceRecord::getLinkNo, (Object)linkNo);
        lqw.last("limit 1");
        return (MerchantBalanceRecord)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public BigDecimal getFreezeAmountByMerId(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{MerchantBalanceRecord::getAmount});
        lqw.eq(MerchantBalanceRecord::getMerId, (Object)merId);
        lqw.eq(MerchantBalanceRecord::getType, (Object)1);
        lqw.eq(MerchantBalanceRecord::getStatus, (Object)2);
        lqw.eq(MerchantBalanceRecord::getMerId, (Object)merId);
        List recordList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)recordList)) {
            return BigDecimal.ZERO;
        }
        return recordList.stream().map(MerchantBalanceRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public void balanceThaw() {
        List<MerchantBalanceRecord> thawList = this.findThawList();
        if (CollUtil.isEmpty(thawList)) {
            return;
        }
        for (MerchantBalanceRecord record : thawList) {
            Merchant merchant = (Merchant)this.merchantService.getById(record.getMerId());
            if (ObjectUtil.isNull((Object)merchant)) continue;
            record.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
            BigDecimal balance = merchant.getBalance().add(record.getAmount());
            record.setBalance(balance);
            record.setUpdateTime((Date)DateUtil.date());
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(record);
                this.merchantService.operationBalance(merchant.getId(), record.getAmount(), "add");
                return Boolean.TRUE;
            });
            if (execute.booleanValue()) continue;
            log.error(StrUtil.format((CharSequence)"\u5546\u6237\u4f59\u989d\u89e3\u51bb\u5904\u7406\u2014\u89e3\u51bb\u51fa\u9519\uff0c\u8bb0\u5f55id = {}", (Object[])new Object[]{record.getId()}));
        }
    }

    private List<MerchantBalanceRecord> findThawList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.le(MerchantBalanceRecord::getThawTime, (Object)System.currentTimeMillis());
        lqw.eq(MerchantBalanceRecord::getLinkType, (Object)"order");
        lqw.eq(MerchantBalanceRecord::getType, (Object)IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        lqw.eq(MerchantBalanceRecord::getStatus, (Object)IntegralRecordConstants.INTEGRAL_RECORD_STATUS_FROZEN);
        return this.dao.selectList((Wrapper)lqw);
    }
}

