/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.MerchantConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.MerchantApply;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.merchant.MerchantAddRequest;
import com.zbkj.common.request.merchant.MerchantApplyAuditRequest;
import com.zbkj.common.request.merchant.MerchantApplyRemarkRequest;
import com.zbkj.common.request.merchant.MerchantApplySearchRequest;
import com.zbkj.common.request.merchant.MerchantSettledApplyRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.MerchantResultCode;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.service.dao.MerchantApplyDao;
import com.zbkj.service.service.MerchantApplyService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.SmsService;
import com.zbkj.service.service.SystemAdminService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.UserService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class MerchantApplyServiceImpl
extends ServiceImpl<MerchantApplyDao, MerchantApply>
implements MerchantApplyService {
    @Resource
    private MerchantApplyDao dao;
    private final Logger logger = LoggerFactory.getLogger(MerchantApplyServiceImpl.class);
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemAdminService adminService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private SystemNotificationService systemNotificationService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SystemAdminService systemAdminService;
    @Autowired
    private CrmebConfig crmebConfig;

    @Override
    public PageInfo<MerchantApply> getAdminPage(MerchantApplySearchRequest searchRequest, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)searchRequest.getCategoryId())) {
            lqw.eq(MerchantApply::getCategoryId, (Object)searchRequest.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)searchRequest.getTypeId())) {
            lqw.eq(MerchantApply::getTypeId, (Object)searchRequest.getTypeId());
        }
        if (ObjectUtil.isNotNull((Object)searchRequest.getAuditStatus())) {
            lqw.eq(MerchantApply::getAuditStatus, (Object)searchRequest.getAuditStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)searchRequest.getKeywords())) {
            String keywords = URLUtil.decode((String)searchRequest.getKeywords());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(MerchantApply::getName, (Object)keywords)).or()).like(MerchantApply::getKeywords, (Object)keywords);
            });
        }
        if (StrUtil.isNotBlank((CharSequence)searchRequest.getDateLimit())) {
            DateLimitUtilVo dateLimitUtilVo = CrmebDateUtil.getDateLimit((String)searchRequest.getDateLimit());
            lqw.between(MerchantApply::getCreateTime, (Object)dateLimitUtilVo.getStartTime(), (Object)dateLimitUtilVo.getEndTime());
        }
        lqw.orderByDesc(MerchantApply::getId);
        List applyList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)applyList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new MerchantApply[0]));
        }
        if (this.crmebConfig.getPhoneMaskSwitch().booleanValue()) {
            applyList.forEach(apply -> {
                apply.setAccount(CrmebUtil.maskMobile((String)apply.getAccount()));
                apply.setPhone(CrmebUtil.maskMobile((String)apply.getPhone()));
            });
        }
        return CommonPage.copyPageInfo((Page)page, (List)applyList);
    }

    @Override
    public Boolean audit(MerchantApplyAuditRequest request) {
        if (request.getAuditStatus().equals(MerchantConstants.AUDIT_STATUS_FAIL) && StrUtil.isEmpty((CharSequence)request.getDenialReason())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5ba1\u6838\u62d2\u7edd\uff0c\u62d2\u7edd\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MerchantApply merchantApply = this.getByIdException(request.getId());
        if (!merchantApply.getAuditStatus().equals(MerchantConstants.AUDIT_STATUS_WAIT)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7533\u8bf7\u5df2\u5ba1\u6838");
        }
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        CrmebUtil.setBusinessDataForFT((int)this.orderService.getAMC(), (int)this.orderService.getAPC(), (int)this.orderService.getAOC());
        if (request.getAuditStatus().equals(MerchantConstants.AUDIT_STATUS_FAIL)) {
            merchantApply.setAuditStatus(MerchantConstants.AUDIT_STATUS_FAIL);
            merchantApply.setDenialReason(request.getDenialReason());
            merchantApply.setAuditorId(loginUserVo.getUser().getId());
            merchantApply.setUpdateTime((Date)DateUtil.date());
            Boolean update = this.dao.updateById(merchantApply) > 0;
            if (update.booleanValue()) {
                SystemNotification payNotification = this.systemNotificationService.getByMark("auditFail");
                if (StrUtil.isNotBlank((CharSequence)merchantApply.getPhone()) && payNotification.getIsSms().equals(1)) {
                    try {
                        this.smsService.sendMerchantFileSuccessNotice(merchantApply.getPhone(), DateUtil.date().toString(), merchantApply.getName(), "");
                    }
                    catch (Exception e2) {
                        this.logger.error("\u5546\u6237\u5165\u9a7b\u5ba1\u6838\u5931\u8d25\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff0c{}", (Object)e2.getMessage());
                    }
                }
            }
            return update;
        }
        merchantApply.setAuditStatus(MerchantConstants.AUDIT_STATUS_SUCCESS);
        merchantApply.setAuditorId(loginUserVo.getUser().getId());
        merchantApply.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            MerchantAddRequest merchantAddRequest;
            Boolean auditSuccess;
            int update = this.dao.updateById(merchantApply);
            if (update <= 0) {
                this.logger.error("\u5546\u6237\u5165\u9a7b\u5ba1\u6838\u6210\u529f\u4e8b\u52a1\u5931\u8d25\uff01\u51c6\u5907\u56de\u6eda");
                e.setRollbackOnly();
            }
            if (!(auditSuccess = this.merchantService.auditSuccess(merchantAddRequest = this.merchantInit(merchantApply), merchantApply.getAuditorId())).booleanValue()) {
                this.logger.error("\u5546\u6237\u5165\u9a7b\u5ba1\u6838\u6210\u529f\u4e8b\u52a1\u5931\u8d25\uff01\u51c6\u5907\u56de\u6eda");
                e.setRollbackOnly();
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            SystemNotification payNotification = this.systemNotificationService.getByMark("auditSuccess");
            if (StrUtil.isNotBlank((CharSequence)merchantApply.getPhone()) && payNotification.getIsSms().equals(1)) {
                String merSiteUrl = this.systemConfigService.getValueByKey("mer_site_url");
                if (StrUtil.isBlank((CharSequence)merSiteUrl)) {
                    merSiteUrl = "";
                }
                try {
                    this.smsService.sendMerchantAuditSuccessNotice(merchantApply.getPhone(), DateUtil.date().toString(), merchantApply.getName(), merchantApply.getPhone(), "000000", merSiteUrl);
                }
                catch (Exception e3) {
                    this.logger.error("\u5546\u6237\u5165\u9a7b\u5ba1\u6838\u6210\u529f\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff0c{}", (Object)e3.getMessage());
                }
            }
        }
        return execute;
    }

    @Override
    public Boolean remark(MerchantApplyRemarkRequest request) {
        MerchantApply merchantApply = this.getByIdException(request.getId());
        merchantApply.setRemark(request.getRemark());
        merchantApply.setUpdateTime((Date)DateUtil.date());
        return this.dao.updateById(merchantApply) > 0;
    }

    @Override
    public Boolean settledApply(MerchantSettledApplyRequest request) {
        Integer uid = this.userService.getUserIdException();
        if (this.checkMerchantName(request.getName()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u6237\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.checkMerchantPhone(request.getPhone()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u6237\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        if (this.adminService.checkAccount(request.getPhone()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u6237\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        MerchantApply merchantApply = new MerchantApply();
        BeanUtils.copyProperties((Object)request, (Object)merchantApply);
        merchantApply.setQualificationPicture(this.systemAttachmentService.clearPrefix(request.getQualificationPicture()));
        merchantApply.setUid(uid);
        boolean save = this.save(merchantApply);
        if (save) {
            List<SystemAdmin> smsAdminList = this.systemAdminService.findReceiveSmsAdminListByMerId(0);
            this.smsService.sendMerchantSettledApply(smsAdminList, merchantApply.getName());
        }
        return save;
    }

    @Override
    public PageInfo<MerchantApply> findSettledRecord(Integer uid, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantApply::getUid, (Object)uid);
        lqw.orderByDesc(MerchantApply::getId);
        List applyList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)applyList);
    }

    @Override
    public Boolean checkMerchantName(String name) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantApply::getName, (Object)name);
        lqw.eq(MerchantApply::getAuditStatus, (Object)MerchantConstants.AUDIT_STATUS_WAIT);
        lqw.last(" limit 1");
        MerchantApply merchantApply = (MerchantApply)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchantApply);
    }

    @Override
    public Boolean checkMerchantPhone(String phone) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantApply::getPhone, (Object)phone);
        lqw.eq(MerchantApply::getAuditStatus, (Object)MerchantConstants.AUDIT_STATUS_WAIT);
        lqw.last(" limit 1");
        MerchantApply merchantApply = (MerchantApply)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)merchantApply);
    }

    private MerchantAddRequest merchantInit(MerchantApply merchantApply) {
        MerchantAddRequest merchant = new MerchantAddRequest();
        BeanUtils.copyProperties((Object)merchantApply, (Object)merchant);
        return merchant;
    }

    private MerchantApply getByIdException(Integer id) {
        MerchantApply merchantApply = (MerchantApply)this.getById(id);
        if (ObjectUtil.isNull((Object)merchantApply)) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_APPLY_NOT_EXIST);
        }
        return merchantApply;
    }
}

