/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.record.ProductDayRecord;
import com.zbkj.common.model.user.User;
import com.zbkj.common.request.ProductRankingRequest;
import com.zbkj.common.response.HomeOperatingDataResponse;
import com.zbkj.common.response.HomeOperatingMerDataResponse;
import com.zbkj.common.response.HomeRateResponse;
import com.zbkj.common.response.PlatformHomeRateResponse;
import com.zbkj.common.response.ProductRankingResponse;
import com.zbkj.common.response.UserChannelDataResponse;
import com.zbkj.service.service.CircleMerchantService;
import com.zbkj.service.service.CircleService;
import com.zbkj.service.service.HomeService;
import com.zbkj.service.service.MerchantDayRecordService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ProductDayRecordService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.UserMerchantCollectService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserVisitRecordService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HomeServiceImpl
implements HomeService {
    @Autowired
    private OrderService orderService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserVisitRecordService userVisitRecordService;
    @Autowired
    private ProductService productService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private UserMerchantCollectService userMerchantCollectService;
    @Autowired
    private ProductDayRecordService productDayRecordService;
    @Autowired
    private MerchantDayRecordService merchantDayRecordService;
    @Autowired
    private CircleService circleService;
    @Autowired
    private CircleMerchantService circleMerchantService;

    @Override
    public HomeRateResponse indexMerchantDate(SystemAdmin systemAdmin) {
        String today = DateUtil.date().toString("yyyy-MM-dd");
        String yesterday = DateUtil.yesterday().toString("yyyy-MM-dd");
        HomeRateResponse response = new HomeRateResponse();
        response.setSales(this.orderService.getPayOrderAmountByDate(systemAdmin.getMerId(), today));
        response.setYesterdaySales(this.orderService.getPayOrderAmountByDate(systemAdmin.getMerId(), yesterday));
        response.setOrderNum(this.orderService.getOrderNumByDate(systemAdmin.getMerId(), today));
        response.setYesterdayOrderNum(this.orderService.getOrderNumByDate(systemAdmin.getMerId(), yesterday));
        response.setFollowNum(this.userMerchantCollectService.getCountByMerId(systemAdmin.getMerId()));
        response.setVisitorsNum(this.merchantDayRecordService.getVisitorsByDate(systemAdmin.getMerId(), today));
        response.setYesterdayVisitorsNum(this.merchantDayRecordService.getVisitorsByDate(systemAdmin.getMerId(), yesterday));
        return response;
    }

    @Override
    public HomeOperatingMerDataResponse operatingMerchantData(SystemAdmin systemAdmin) {
        HomeOperatingMerDataResponse response = new HomeOperatingMerDataResponse();
        response.setNotShippingOrderNum(this.orderService.getNotShippingNum(systemAdmin.getMerId()));
        response.setAwaitVerificationOrderNum(this.orderService.getAwaitVerificationNum(systemAdmin.getMerId()));
        response.setRefundingOrderNum(this.refundOrderService.getAwaitAuditNum(systemAdmin.getMerId()));
        response.setOnSaleProductNum(this.productService.getOnSaleNum(systemAdmin.getMerId()));
        response.setAwaitAuditProductNum(this.productService.getAwaitAuditNum(systemAdmin.getMerId()));
        return response;
    }

    @Override
    public PlatformHomeRateResponse indexPlatformDate() {
        String today = DateUtil.date().toString("yyyy-MM-dd");
        String yesterday = DateUtil.yesterday().toString("yyyy-MM-dd");
        PlatformHomeRateResponse response = new PlatformHomeRateResponse();
        response.setTodayNewUserNum(this.userService.getRegisterNumByDate(today));
        response.setYesterdayNewUserNum(this.userService.getRegisterNumByDate(yesterday));
        response.setPageviews(this.userVisitRecordService.getPageviewsByDate(today));
        response.setYesterdayPageviews(this.userVisitRecordService.getPageviewsByDate(yesterday));
        response.setTodayNewMerchantNum(this.merchantService.getNewNumByDate(today));
        response.setYesterdayNewMerchantNum(this.merchantService.getNewNumByDate(yesterday));
        response.setOrderNum(this.orderService.getOrderNumByDate(0, today));
        response.setYesterdayOrderNum(this.orderService.getOrderNumByDate(0, yesterday));
        response.setSales(this.orderService.getPayOrderAmountByDate(0, today));
        response.setYesterdaySales(this.orderService.getPayOrderAmountByDate(0, yesterday));
        response.setUserNum(this.userService.getTotalNum());
        response.setMerchantNum(this.merchantService.getAllCount());
        return response;
    }

    @Override
    public HomeOperatingDataResponse operatingPlatformData() {
        HomeOperatingDataResponse response = new HomeOperatingDataResponse();
        response.setNotShippingOrderNum(this.orderService.getNotShippingNum(0));
        response.setAwaitVerificationOrderNum(this.orderService.getAwaitVerificationNum(0));
        response.setRefundingOrderNum(this.refundOrderService.getAwaitAuditNum(0));
        response.setOnSaleProductNum(this.productService.getOnSaleNum(0));
        response.setAwaitAuditProductNum(this.productService.getAwaitAuditNum(0));
        return response;
    }

    @Override
    public List<UserChannelDataResponse> getUserChannelData() {
        List<UserChannelDataResponse> response = Arrays.asList(new UserChannelDataResponse("wechat", 0), new UserChannelDataResponse("routine", 0), new UserChannelDataResponse("h5", 0), new UserChannelDataResponse("iosWx", 0), new UserChannelDataResponse("androidWx", 0), new UserChannelDataResponse("ios", 0));
        List<User> userList = this.userService.getChannelData();
        if (CollUtil.isNotEmpty(userList)) {
            Map<String, Integer> channelCountMap = userList.stream().collect(Collectors.groupingBy(User::getRegisterType, Collectors.summingInt(User::getPayCount)));
            for (UserChannelDataResponse item : response) {
                String channel = item.getRegisterType();
                if (!channelCountMap.containsKey(channel)) continue;
                item.setNum(channelCountMap.get(channel));
            }
        }
        return response;
    }

    @Override
    public List<ProductRankingResponse> merchantProductPayRanking(SystemAdmin systemAdmin) {
        Integer merId = systemAdmin.getMerId();
        ProductRankingRequest request = new ProductRankingRequest();
        request.setMerId(merId);
        request.setDateLimit("lately7");
        request.setSortKey("salesAmount");
        PageInfo<ProductDayRecord> pageInfo = this.productDayRecordService.getRanking(request);
        List recordList = pageInfo.getList();
        ArrayList list = CollUtil.newArrayList((Object[])new ProductRankingResponse[0]);
        if (CollUtil.isNotEmpty((Collection)recordList)) {
            for (ProductDayRecord record : recordList) {
                Product product = (Product)this.productService.getById(record.getProductId());
                ProductRankingResponse response = new ProductRankingResponse();
                BeanUtils.copyProperties((Object)record, (Object)response);
                response.setSalesAmount(record.getOrderSuccessProductFee());
                response.setProductId(product.getId());
                response.setProName(product.getName());
                response.setImage(product.getImage());
                list.add(response);
            }
        }
        return list;
    }

    @Override
    public List<ProductRankingResponse> merchantProductPageviewRanking(SystemAdmin systemAdmin) {
        Integer merId = systemAdmin.getMerId();
        ProductRankingRequest request = new ProductRankingRequest();
        request.setMerId(merId);
        request.setDateLimit("lately7");
        request.setSortKey("pageviews");
        PageInfo<ProductDayRecord> pageInfo = this.productDayRecordService.getRanking(request);
        List recordList = pageInfo.getList();
        ArrayList list = CollUtil.newArrayList((Object[])new ProductRankingResponse[0]);
        if (CollUtil.isNotEmpty((Collection)recordList)) {
            for (ProductDayRecord record : recordList) {
                Product product = (Product)this.productService.getById(record.getProductId());
                ProductRankingResponse response = new ProductRankingResponse();
                BeanUtils.copyProperties((Object)record, (Object)response);
                response.setPageView(record.getPageView());
                response.setProductId(product.getId());
                response.setProName(product.getName());
                response.setImage(product.getImage());
                list.add(response);
            }
        }
        return list;
    }

    @Override
    public PlatformHomeRateResponse indexCircleData(List<Integer> merIds) {
        String today = DateUtil.date().toString("yyyy-MM-dd");
        String yesterday = DateUtil.yesterday().toString("yyyy-MM-dd");
        if (CollUtil.isEmpty(merIds)) {
            return new PlatformHomeRateResponse();
        }
        PlatformHomeRateResponse response = new PlatformHomeRateResponse();
        response.setSales(this.orderService.getPayOrderAmountByMerIdsAnDate(merIds, today));
        response.setYesterdaySales(this.orderService.getPayOrderAmountByMerIdsAnDate(merIds, yesterday));
        response.setPageviews(this.merchantDayRecordService.getVisitorsByMerIdsAndDate(merIds, today));
        response.setYesterdayPageviews(this.merchantDayRecordService.getVisitorsByMerIdsAndDate(merIds, yesterday));
        response.setOrderNum(this.orderService.getOrderNumByMerIdsAndDate(merIds, today));
        response.setYesterdayOrderNum(this.orderService.getOrderNumByMerIdsAndDate(merIds, yesterday));
        response.setUserNum(this.userMerchantCollectService.getCollectNumByMerIds(merIds));
        response.setTodayNewUserNum(this.userMerchantCollectService.getCollectNumByMerIdsAndDate(merIds, today));
        response.setYesterdayNewUserNum(this.userMerchantCollectService.getCollectNumByMerIdsAndDate(merIds, yesterday));
        response.setMerchantNum(Integer.valueOf(merIds.size()));
        response.setTodayNewMerchantNum(this.circleMerchantService.getMerchantNumByMerIdsAndDate(merIds, today));
        response.setYesterdayNewMerchantNum(this.circleMerchantService.getMerchantNumByMerIdsAndDate(merIds, yesterday));
        return response;
    }

    @Override
    public HomeOperatingDataResponse operatingCircleData(List<Integer> merIds) {
        if (CollUtil.isEmpty(merIds)) {
            return new HomeOperatingDataResponse();
        }
        HomeOperatingDataResponse response = new HomeOperatingDataResponse();
        response.setNotShippingOrderNum(this.orderService.getNotShippingNumByMerIds(merIds));
        response.setAwaitVerificationOrderNum(this.orderService.getAwaitVerificationNumByMerIds(merIds));
        response.setRefundingOrderNum(this.refundOrderService.getAwaitAuditNumByMerIds(merIds));
        response.setOnSaleProductNum(this.productService.getOnSaleNumByMerIds(merIds));
        response.setAwaitAuditProductNum(this.productService.getAwaitAuditNumByMerIds(merIds));
        return response;
    }

    @Override
    public List<UserChannelDataResponse> getCircleUserChannelData(List<Integer> merIds) {
        List<User> userList;
        List<Integer> userIds;
        List<UserChannelDataResponse> response = Arrays.asList(new UserChannelDataResponse("wechat", 0), new UserChannelDataResponse("routine", 0), new UserChannelDataResponse("h5", 0), new UserChannelDataResponse("iosWx", 0), new UserChannelDataResponse("androidWx", 0), new UserChannelDataResponse("ios", 0));
        if (CollUtil.isNotEmpty(merIds) && CollUtil.isNotEmpty(userIds = this.userMerchantCollectService.getUserIdsByMerIds(merIds)) && CollUtil.isNotEmpty(userList = this.userService.getChannelDataByIds(userIds))) {
            Map<String, Integer> channelCountMap = userList.stream().collect(Collectors.groupingBy(User::getRegisterType, Collectors.summingInt(User::getPayCount)));
            for (UserChannelDataResponse item : response) {
                String channel = item.getRegisterType();
                if (!channelCountMap.containsKey(channel)) continue;
                item.setNum(channelCountMap.get(channel));
            }
        }
        return response;
    }
}

