/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.GroupConfigConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.system.GroupConfig;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.IntegralIntervalAddRequest;
import com.zbkj.common.request.IntegralIntervalPageSearchRequest;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.GroupConfigDao;
import com.zbkj.service.service.GroupConfigService;
import com.zbkj.service.service.SystemAttachmentService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class GroupConfigServiceImpl
extends ServiceImpl<GroupConfigDao, GroupConfig>
implements GroupConfigService {
    @Resource
    private GroupConfigDao dao;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public List<GroupConfig> findByTag(Integer tag, String sortRule, Boolean status) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(GroupConfig::getTag, (Object)tag);
        lqw.eq(GroupConfig::getIsDel, (Object)0);
        if (ObjectUtil.isNotNull((Object)status)) {
            lqw.eq(GroupConfig::getStatus, (Object)(status != false ? 1 : 0));
        }
        if (StrUtil.isBlank((CharSequence)sortRule) || sortRule.equals("asc")) {
            lqw.orderByAsc(GroupConfig::getSort);
        } else {
            lqw.orderByDesc(GroupConfig::getSort);
        }
        lqw.orderByDesc(GroupConfig::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<GroupConfig> findByTag(Integer tag, Integer merId, String sortRule, Boolean status) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(GroupConfig::getTag, (Object)tag);
        lqw.eq(GroupConfig::getMerId, (Object)merId);
        lqw.eq(GroupConfig::getIsDel, (Object)0);
        if (ObjectUtil.isNotNull((Object)status)) {
            lqw.eq(GroupConfig::getStatus, (Object)(status != false ? 1 : 0));
        }
        if (StrUtil.isBlank((CharSequence)sortRule) || sortRule.equals("asc")) {
            lqw.orderByAsc(GroupConfig::getSort);
        } else {
            lqw.orderByDesc(GroupConfig::getSort);
        }
        lqw.orderByDesc(GroupConfig::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean saveList(List<GroupConfig> configList) {
        Integer tag = configList.get(0).getTag();
        configList.forEach(groupConfig -> {
            if (StrUtil.isNotBlank((CharSequence)groupConfig.getImageUrl())) {
                groupConfig.setImageUrl(this.systemAttachmentService.clearPrefix(groupConfig.getImageUrl()));
            }
        });
        Integer merId = Optional.ofNullable(configList.get(0).getMerId()).orElse(0);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.deleteByTag(tag, merId);
            this.saveBatch(configList);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean deleteByTag(Integer tag, Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(GroupConfig::getIsDel, (Object)1);
        wrapper.eq(GroupConfig::getTag, (Object)tag);
        wrapper.eq(GroupConfig::getIsDel, (Object)0);
        if (ObjectUtil.isNotNull((Object)merId) && merId > 0) {
            wrapper.eq(GroupConfig::getMerId, (Object)merId);
        }
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<GroupConfig> getIntegralIntervalPage(IntegralIntervalPageSearchRequest request) {
        DateLimitUtilVo dateLimit;
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(GroupConfig::getTag, (Object)GroupConfigConstants.TAG_INTEGRAL_INTERVAL);
        lqw.eq(GroupConfig::getIsDel, (Object)0);
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            String name = URLUtil.decode((String)request.getName());
            lqw.like(GroupConfig::getName, (Object)name);
        }
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(GroupConfig::getStatus, (Object)request.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit()) && StrUtil.isNotBlank((CharSequence)(dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit())).getStartTime()) && StrUtil.isNotBlank((CharSequence)dateLimit.getEndTime())) {
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            lqw.between(GroupConfig::getCreateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        lqw.orderByDesc((Object[])new SFunction[]{GroupConfig::getSort, GroupConfig::getId});
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public Boolean saveIntegralInterval(IntegralIntervalAddRequest request) {
        if (this.isExistName(request.getName(), GroupConfigConstants.TAG_INTEGRAL_INTERVAL).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u533a\u95f4\u540d\u79f0\u5df2\u5b58\u5728");
        }
        String value = request.getValue();
        String[] split = value.split("-");
        int startValue = Integer.parseInt(split[0]);
        int endValue = Integer.parseInt(split[1]);
        if (endValue < startValue) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u79ef\u5206\u533a\u95f4\u503c\u5b58\u5728\u9519\u8bef");
        }
        GroupConfig groupConfig = new GroupConfig();
        groupConfig.setName(request.getName());
        groupConfig.setValue(request.getValue());
        groupConfig.setStatus(request.getStatus());
        groupConfig.setSort(request.getSort());
        groupConfig.setTag(GroupConfigConstants.TAG_INTEGRAL_INTERVAL);
        groupConfig.setMerId(Integer.valueOf(0));
        return this.save(groupConfig);
    }

    @Override
    public Boolean updateIntegralInterval(IntegralIntervalAddRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u533a\u95f4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GroupConfig groupConfig = this.getByIdException(request.getId());
        if (!groupConfig.getTag().equals(GroupConfigConstants.TAG_INTEGRAL_INTERVAL)) {
            throw new CrmebException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!request.getName().equals(groupConfig.getName()) && this.isExistName(request.getName(), GroupConfigConstants.TAG_INTEGRAL_INTERVAL).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u533a\u95f4\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!request.getValue().equals(groupConfig.getValue())) {
            String value = request.getValue();
            String[] split = value.split("-");
            int startValue = Integer.parseInt(split[0]);
            int endValue = Integer.parseInt(split[1]);
            if (endValue < startValue) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u79ef\u5206\u533a\u95f4\u503c\u5b58\u5728\u9519\u8bef");
            }
        }
        groupConfig.setName(request.getName());
        groupConfig.setValue(request.getValue());
        groupConfig.setStatus(request.getStatus());
        groupConfig.setSort(request.getSort());
        groupConfig.setUpdateTime((Date)DateUtil.date());
        return this.updateById(groupConfig);
    }

    @Override
    public Boolean deleteIntegralInterval(Integer id) {
        GroupConfig groupConfig = this.getByIdException(id);
        if (!groupConfig.getTag().equals(GroupConfigConstants.TAG_INTEGRAL_INTERVAL)) {
            throw new CrmebException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        groupConfig.setIsDel(Boolean.valueOf(true));
        groupConfig.setUpdateTime((Date)DateUtil.date());
        return this.updateById(groupConfig);
    }

    @Override
    public Boolean updateIntegralIntervalStatus(Integer id) {
        GroupConfig groupConfig = this.getByIdException(id);
        if (!groupConfig.getTag().equals(GroupConfigConstants.TAG_INTEGRAL_INTERVAL)) {
            throw new CrmebException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        groupConfig.setStatus(Boolean.valueOf(groupConfig.getStatus() == false));
        groupConfig.setUpdateTime((Date)DateUtil.date());
        return this.updateById(groupConfig);
    }

    @Override
    public Integer getCountByTag(Integer tag) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(GroupConfig::getTag, (Object)tag);
        lqw.eq(GroupConfig::getIsDel, (Object)0);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public GroupConfig getByIdException(Integer id) {
        GroupConfig groupConfig = (GroupConfig)this.getById(id);
        if (ObjectUtil.isNull((Object)groupConfig) || groupConfig.getIsDel().booleanValue()) {
            throw new CrmebException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return groupConfig;
    }

    @Override
    public GroupConfig getOneByTagAndMerId(Integer tag, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(GroupConfig::getTag, (Object)tag);
        lqw.eq(GroupConfig::getMerId, (Object)merId);
        lqw.eq(GroupConfig::getIsDel, (Object)0);
        lqw.last(" limit 1");
        return (GroupConfig)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean deleteByTagAndMerId(Integer tag, Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(GroupConfig::getIsDel, (Object)1);
        wrapper.eq(GroupConfig::getTag, (Object)tag);
        wrapper.eq(GroupConfig::getMerId, (Object)merId);
        wrapper.eq(GroupConfig::getIsDel, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean saveOne(GroupConfig groupConfig) {
        Integer tag = groupConfig.getTag();
        if (StrUtil.isNotBlank((CharSequence)groupConfig.getImageUrl())) {
            groupConfig.setImageUrl(this.systemAttachmentService.clearPrefix(groupConfig.getImageUrl()));
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.deleteByTagAndMerId(tag, groupConfig.getMerId());
            this.save(groupConfig);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean isExistName(String name, Integer tag) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(GroupConfig::getTag, (Object)tag);
        lqw.eq(GroupConfig::getName, (Object)name);
        lqw.eq(GroupConfig::getIsDel, (Object)0);
        lqw.last(" limit 1");
        GroupConfig groupConfig = (GroupConfig)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)groupConfig);
    }
}

