/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.BrokerageRecordConstants;
import com.zbkj.common.constants.ExperienceRecordConstants;
import com.zbkj.common.constants.IntegralRecordConstants;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.constants.VisitRecordConstants;
import com.zbkj.common.enums.GroupBuyRecordEnum;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantBalanceRecord;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.record.BrowseRecord;
import com.zbkj.common.model.record.UserVisitRecord;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.system.SystemUserLevel;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBrokerageRecord;
import com.zbkj.common.model.user.UserExperienceRecord;
import com.zbkj.common.model.user.UserIntegralRecord;
import com.zbkj.common.model.user.UserLevel;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.PaidMemberBenefitsVo;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.BrowseRecordService;
import com.zbkj.service.service.CommunityNotesService;
import com.zbkj.service.service.CommunityReplyService;
import com.zbkj.service.service.MerchantBalanceRecordService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderFlowRecordService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.PaidMemberService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.ReservationWorkOrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.SystemUserLevelService;
import com.zbkj.service.service.TemplateMessageService;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserExperienceRecordService;
import com.zbkj.service.service.UserIntegralRecordService;
import com.zbkj.service.service.UserLevelService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.UserVisitRecordService;
import com.zbkj.service.service.WechatOrderShippingService;
import com.zbkj.service.service.groupbuy.GroupBuyUserService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class AsyncServiceImpl
implements AsyncService {
    private final Logger logger = LoggerFactory.getLogger(AsyncServiceImpl.class);
    @Lazy
    @Autowired
    private ProductService storeProductService;
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Autowired
    private UserVisitRecordService userVisitRecordService;
    @Lazy
    @Autowired
    private BrowseRecordService browseRecordService;
    @Lazy
    @Autowired
    private OrderService orderService;
    @Lazy
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Lazy
    @Autowired
    private OrderDetailService orderDetailService;
    @Lazy
    @Autowired
    private UserService userService;
    @Lazy
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CrmebConfig crmebConfig;
    @Lazy
    @Autowired
    private SystemNotificationService systemNotificationService;
    @Lazy
    @Autowired
    private UserTokenService userTokenService;
    @Lazy
    @Autowired
    private TemplateMessageService templateMessageService;
    @Lazy
    @Autowired
    private UserExperienceRecordService userExperienceRecordService;
    @Lazy
    @Autowired
    private SystemUserLevelService systemUserLevelService;
    @Lazy
    @Autowired
    private UserLevelService userLevelService;
    @Lazy
    @Autowired
    private CommunityNotesService communityNotesService;
    @Lazy
    @Autowired
    private CommunityReplyService communityReplyService;
    @Lazy
    @Autowired
    private UserIntegralRecordService userIntegralRecordService;
    @Lazy
    @Autowired
    private UserBrokerageRecordService userBrokerageRecordService;
    @Lazy
    @Autowired
    private MerchantBalanceRecordService merchantBalanceRecordService;
    @Lazy
    @Autowired
    private MerchantService merchantService;
    @Lazy
    @Autowired
    private WechatOrderShippingService wechatOrderShippingService;
    @Lazy
    @Autowired
    private PaidMemberService paidMemberService;
    @Lazy
    @Autowired
    private GroupBuyUserService groupBuyUserService;
    @Lazy
    @Autowired
    private ReservationWorkOrderService workOrderService;
    @Lazy
    @Autowired
    private OrderFlowRecordService orderFlowRecordService;

    @Override
    @Async
    public void productDetailStatistics(Integer proId, Integer uid) {
        this.storeProductService.addBrowse(proId);
        String dateStr = DateUtil.date().toString("yyyy-MM-dd");
        this.redisUtil.incrAndCreate("statistics:product:page_view:" + dateStr);
        this.redisUtil.incrAndCreate(StrUtil.format((CharSequence)"statistics:product:pro_page_view:{}:{}", (Object[])new Object[]{dateStr, proId}));
        if (uid.equals(0)) {
            return;
        }
        if (uid > 0) {
            UserVisitRecord visitRecord = new UserVisitRecord();
            visitRecord.setDate(DateUtil.date().toString("yyyy-MM-dd"));
            visitRecord.setUid(uid);
            visitRecord.setVisitType(VisitRecordConstants.VISIT_TYPE_DETAIL);
            this.userVisitRecordService.save(visitRecord);
            BrowseRecord browseRecord = this.browseRecordService.getByUidAndProId(uid, proId);
            if (ObjectUtil.isNull((Object)browseRecord)) {
                browseRecord = new BrowseRecord();
                browseRecord.setUid(uid);
                browseRecord.setProductId(proId);
                browseRecord.setDate(DateUtil.date().toString("yyyy-MM-dd"));
                browseRecord.setCreateTime((Date)DateUtil.date());
                this.browseRecordService.save(browseRecord);
            } else {
                browseRecord.setDate(DateUtil.date().toString("yyyy-MM-dd"));
                this.browseRecordService.myUpdate(browseRecord);
            }
        }
    }

    @Override
    @Async
    public void saveUserVisit(Integer userId, Integer visitType) {
        UserVisitRecord visitRecord = new UserVisitRecord();
        visitRecord.setDate(DateUtil.date().toDateStr());
        visitRecord.setUid(userId);
        visitRecord.setVisitType(visitType);
        this.userVisitRecordService.save(visitRecord);
    }

    @Override
    @Async
    public void orderPaySuccessSplit(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            this.logger.error("\u5f02\u6b65\u2014\u2014\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u62c6\u5355\u5904\u7406 | \u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderNo: {}", (Object)orderNo);
            return;
        }
        List<MerchantOrder> merchantOrderList = this.merchantOrderService.getByOrderNo(orderNo);
        if (CollUtil.isEmpty(merchantOrderList)) {
            this.logger.error("\u5f02\u6b65\u2014\u2014\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u62c6\u5355\u5904\u7406 | \u5546\u6237\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728,orderNo: {}", (Object)orderNo);
            return;
        }
        Boolean execute = merchantOrderList.size() == 1 ? this.oneMerchantOrderProcessing(order, merchantOrderList.get(0)) : this.manyMerchantOrderProcessing(order, merchantOrderList);
        if (!execute.booleanValue()) {
            this.logger.error("\u5f02\u6b65\u2014\u2014\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u62c6\u5355\u5904\u7406 | \u62c6\u5355\u5904\u7406\u5931\u8d25\uff0corderNo: {}", (Object)orderNo);
            return;
        }
        this.redisUtil.lPush("orderPaySuccessTask", (Object)order.getOrderNo());
    }

    @Override
    @Async
    public void visitUserCenter(Integer uid) {
        UserVisitRecord visitRecord = new UserVisitRecord();
        visitRecord.setDate(DateUtil.date().toString("yyyy-MM-dd"));
        visitRecord.setUid(uid);
        visitRecord.setVisitType(VisitRecordConstants.VISIT_TYPE_CENTER);
        this.userVisitRecordService.save(visitRecord);
    }

    @Override
    @Async
    public void installStatistics() {
        String version = this.crmebConfig.getVersion();
        String apiUrl = this.systemConfigService.getValueByKey("api_url");
        String siteUrl = this.systemConfigService.getValueByKey("site_url");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", apiUrl);
        map.put("version", version);
        map.put("front_host", siteUrl);
        map.put("admin_host", apiUrl);
        map.put("https", "https");
        String result = "";
        try {
            result = HttpUtil.post((String)"https://shop.crmeb.net/index.php/admin/server.upgrade_api/updatewebinfo", (String)JSONObject.toJSONString(map));
        }
        catch (Exception e) {
            this.logger.error(result);
        }
    }

    @Override
    @Async
    public void sendRechargeSuccessNotification(RechargeOrder rechargeOrder, User user) {
        if (!rechargeOrder.getPayType().equals("weixin")) {
            return;
        }
        SystemNotification payNotification = this.systemNotificationService.getByMark("rechargeSuccess");
        HashMap<String, String> temMap = new HashMap<String, String>();
        if (rechargeOrder.getPayChannel().equals("public") && user.getIsWechatPublic().booleanValue() && payNotification.getIsWechat().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_WECHAT);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("first", "\u5145\u503c\u6210\u529f\u901a\u77e5\uff01");
            temMap.put("keyword1", user.getNickname());
            temMap.put("keyword2", rechargeOrder.getOrderNo());
            temMap.put("keyword3", rechargeOrder.getPrice().toString());
            temMap.put("remark", "\u6b22\u8fce\u4e0b\u6b21\u518d\u6765\uff01");
            this.templateMessageService.pushTemplateMessage(payNotification.getWechatId(), temMap, userToken.getToken());
            return;
        }
        if (rechargeOrder.getPayChannel().equals("mini") && user.getIsWechatPublic().booleanValue() && payNotification.getIsRoutine().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("character_string1", rechargeOrder.getOrderNo());
            temMap.put("amount3", rechargeOrder.getPrice().toString());
            temMap.put("date5", rechargeOrder.getPayTime().toString());
            temMap.put("amount6", rechargeOrder.getGivePrice().toString());
            temMap.put("thing7", "\u60a8\u7684\u5145\u503c\u5df2\u6210\u529f\uff01");
            this.templateMessageService.pushTemplateMessage(payNotification.getRoutineId(), temMap, userToken.getToken());
            return;
        }
    }

    @Override
    @Async
    public void noteUpExp(Integer userId, Integer noteId) {
        String levelSwitch = this.systemConfigService.getValueByKey("userLevelSwitch");
        if (!"1".equals(levelSwitch)) {
            return;
        }
        String noteExpStr = this.systemConfigService.getValueByKeyException("userLevelCommunityNotesExp");
        if (noteExpStr.equals("0")) {
            return;
        }
        String noteNum = this.systemConfigService.getValueByKeyException("userLevelCommunityNotesNum");
        if (noteNum.equals("0")) {
            return;
        }
        if (this.userExperienceRecordService.isExistNote(userId, noteId).booleanValue()) {
            return;
        }
        Integer noteCountToday = this.userExperienceRecordService.getCountByNoteToday(userId);
        if (noteCountToday >= Integer.parseInt(noteNum)) {
            return;
        }
        User user = (User)this.userService.getById(userId);
        int noteExp = Integer.parseInt(noteExpStr);
        if (user.getIsPaidMember().booleanValue()) {
            List<PaidMemberBenefitsVo> benefitsList = this.paidMemberService.getBenefitsList();
            for (PaidMemberBenefitsVo b : benefitsList) {
                if (!b.getStatus().booleanValue() || !b.getName().equals("experienceDoubling") || b.getMultiple() <= 1 || !b.getChannelStr().contains("2")) continue;
                noteExp *= b.getMultiple().intValue();
            }
        }
        UserExperienceRecord record = new UserExperienceRecord();
        record.setUid(userId);
        record.setLinkId(noteId.toString());
        record.setLinkType("note");
        record.setType(ExperienceRecordConstants.EXPERIENCE_RECORD_TYPE_ADD);
        record.setTitle("\u793e\u533a\u53d1\u5e03\u7b14\u8bb0\u5956\u52b1");
        record.setExperience(Integer.valueOf(noteExp));
        record.setBalance(Integer.valueOf(user.getExperience() + noteExp));
        record.setMark(StrUtil.format((CharSequence)"\u793e\u533a\u53d1\u5e03\u79cd\u8349\u5956\u52b1{}\u7ecf\u9a8c", (Object[])new Object[]{noteExp}));
        record.setCreateTime((Date)DateUtil.date());
        int finalNoteExp = noteExp;
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.userService.updateExperience(userId, finalNoteExp, "add");
            this.userExperienceRecordService.save(record);
            this.userLevelUp(userId, user.getLevel(), user.getExperience() + finalNoteExp);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            this.logger.error("\u7528\u6237\u793e\u533a\u53d1\u5e03\u7b14\u8bb0\u6dfb\u52a0\u7ecf\u9a8c\u5931\u8d25\uff0cuserId={},noteId={}", (Object)userId, (Object)noteId);
        }
    }

    @Override
    @Async
    public void communityNoteLikeOrClean(Integer noteId, String operationType) {
        this.communityNotesService.operationLike(noteId, operationType);
    }

    @Override
    @Async
    public void communityReplyLikeOrClean(Integer replyId, String operationType) {
        this.communityReplyService.operationLike(replyId, operationType);
    }

    @Override
    @Async
    public void noteAddReplyAfter(Integer noteId, Integer parentId, Integer replyId) {
        this.communityNotesService.operationReplyNum(noteId, 1, "add");
        if (parentId > 0) {
            this.communityReplyService.operationReplyNum(parentId, 1, "add");
        }
    }

    @Override
    @Async
    public void communityReplyDeleteAfter(Integer noteId, Integer firstReplyId, Integer replyId, Integer countReply) {
        if (firstReplyId > 0) {
            this.communityNotesService.operationReplyNum(noteId, 1, "sub");
            this.communityReplyService.operationReplyNum(firstReplyId, 1, "sub");
        } else {
            this.communityNotesService.operationReplyNum(noteId, 1 + countReply, "sub");
        }
    }

    @Override
    @Async
    public void userLevelUp(Integer userId, Integer userLevelId, Integer exp) {
        String levelSwitch = this.systemConfigService.getValueByKey("userLevelSwitch");
        if (levelSwitch.equals("0")) {
            return;
        }
        SystemUserLevel userLevel = this.systemUserLevelService.getByLevelId(userLevelId);
        SystemUserLevel systemLevel = this.systemUserLevelService.getByExp(exp);
        if (userLevel.getGrade() >= systemLevel.getGrade()) {
            return;
        }
        if (systemLevel.getExperience() > exp) {
            systemLevel = this.systemUserLevelService.getPreviousGrade(systemLevel.getGrade());
        }
        UserLevel level = new UserLevel();
        level.setUid(userId);
        level.setLevelId(systemLevel.getId());
        level.setGrade(systemLevel.getGrade());
        this.userService.updateUserLevel(userId, level.getLevelId());
        this.userLevelService.deleteByUserId(userId);
        this.userLevelService.save(level);
    }

    @Override
    @Async
    public void orderPayAfterFreezingOperation(List<String> orderNoList) {
        String integralDayStr;
        String integralFreezeNode;
        String retailStoreBrokerageShareFreezeDayStr;
        String retailStoreBrokerageShareNode;
        String merchantShareNodeFreezeDayStr;
        String merchantShareNode = this.systemConfigService.getValueByKey("merchant_share_node");
        if (StrUtil.isNotBlank((CharSequence)merchantShareNode) && "pay".equals(merchantShareNode) && StrUtil.isNotBlank((CharSequence)(merchantShareNodeFreezeDayStr = this.systemConfigService.getValueByKey("merchant_share_freeze_time")))) {
            this.orderMerchantShareFreezingOperation(orderNoList, Integer.parseInt(merchantShareNodeFreezeDayStr));
        }
        if (StrUtil.isNotBlank((CharSequence)(retailStoreBrokerageShareNode = this.systemConfigService.getValueByKey("retail_store_brokerage_share_node"))) && "pay".equals(retailStoreBrokerageShareNode) && StrUtil.isNotBlank((CharSequence)(retailStoreBrokerageShareFreezeDayStr = this.systemConfigService.getValueByKey("retail_store_brokerage_freezing_time")))) {
            this.orderBrokerageShareFreezingOperation(orderNoList, Integer.parseInt(retailStoreBrokerageShareFreezeDayStr));
        }
        if (StrUtil.isNotBlank((CharSequence)(integralFreezeNode = this.systemConfigService.getValueByKey("integral_freeze_node"))) && "pay".equals(integralFreezeNode) && StrUtil.isNotBlank((CharSequence)(integralDayStr = this.systemConfigService.getValueByKey("freeze_integral_day")))) {
            this.orderIntegralFreezingOperation(orderNoList, Integer.parseInt(integralDayStr));
        }
    }

    @Override
    @Async
    public void orderCompleteAfterFreezingOperation(List<String> orderNoList) {
        String merchantShareNode = this.systemConfigService.getValueByKey("merchant_share_node");
        String merchantShareNodeFreezeDayStr = this.systemConfigService.getValueByKey("merchant_share_freeze_time");
        int merchantFreezeDay = 7;
        if (StrUtil.isNotBlank((CharSequence)merchantShareNode) && "complete".equals(merchantShareNode) && StrUtil.isNotBlank((CharSequence)merchantShareNodeFreezeDayStr)) {
            merchantFreezeDay = Integer.parseInt(merchantShareNodeFreezeDayStr);
        }
        this.orderMerchantShareFreezingOperation(orderNoList, merchantFreezeDay);
        String retailStoreBrokerageShareNode = this.systemConfigService.getValueByKey("retail_store_brokerage_share_node");
        String retailStoreBrokerageShareFreezeDayStr = this.systemConfigService.getValueByKey("retail_store_brokerage_freezing_time");
        int brokerageFreezeDay = 7;
        if (StrUtil.isNotBlank((CharSequence)retailStoreBrokerageShareNode) && "complete".equals(retailStoreBrokerageShareNode) && StrUtil.isNotBlank((CharSequence)retailStoreBrokerageShareFreezeDayStr)) {
            brokerageFreezeDay = Integer.parseInt(retailStoreBrokerageShareFreezeDayStr);
        }
        this.orderBrokerageShareFreezingOperation(orderNoList, brokerageFreezeDay);
        String integralFreezeNode = this.systemConfigService.getValueByKey("integral_freeze_node");
        String integralDayStr = this.systemConfigService.getValueByKey("freeze_integral_day");
        int integralFreezeDay = 7;
        if (StrUtil.isNotBlank((CharSequence)integralFreezeNode) && "complete".equals(integralFreezeNode) && StrUtil.isNotBlank((CharSequence)integralDayStr)) {
            integralFreezeDay = Integer.parseInt(integralDayStr);
        }
        this.orderIntegralFreezingOperation(orderNoList, integralFreezeDay);
    }

    @Override
    @Async
    public void wechatSendUploadShipping(String orderNo) {
        try {
            this.wechatOrderShippingService.uploadShippingInfo(orderNo);
        }
        catch (Exception e) {
            this.logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u8d27\u4e0a\u4f20\u53d1\u8d27\u7ba1\u7406\u5f02\u5e38\uff0ce=", (Throwable)e);
        }
    }

    @Override
    @Async
    public void verifyOrderWechatSendUploadShipping(String orderNo) {
        try {
            this.wechatOrderShippingService.uploadShippingInfo(orderNo, "verify");
        }
        catch (Exception e) {
            this.logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u8d27\u4e0a\u4f20\u53d1\u8d27\u7ba1\u7406\u5f02\u5e38\uff0ce=", (Throwable)e);
        }
    }

    @Override
    @Async
    public void workOrderAutoClockIn(String workOrderNo) {
        this.workOrderService.autoClockIn(workOrderNo);
    }

    private void orderIntegralFreezingOperation(List<String> orderNoList, Integer freezeDay) {
        Order order = this.orderService.getByOrderNo(orderNoList.get(0));
        ArrayList<UserIntegralRecord> recordList = new ArrayList<UserIntegralRecord>();
        if (freezeDay > 0) {
            for (String orderNo : orderNoList) {
                UserIntegralRecord record = this.userIntegralRecordService.getByOrderNoAndType(orderNo, IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
                if (ObjectUtil.isNull((Object)record) || !record.getStatus().equals(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_CREATE)) continue;
                record.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_FROZEN);
                record.setFrozenTime(freezeDay);
                DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)freezeDay);
                long thawTime = dateTime.getTime();
                record.setThawTime(Long.valueOf(thawTime));
                record.setUpdateTime((Date)DateUtil.date());
                recordList.add(record);
            }
            if (CollUtil.isEmpty(recordList)) {
                return;
            }
            boolean batch = this.userIntegralRecordService.updateBatchById(recordList);
            if (!batch) {
                this.logger.error("\u8ba2\u5355\u79ef\u5206\u51bb\u7ed3\u5904\u7406\u5931\u8d25\uff0c\u8ba2\u5355\u53f7={}", (Object)order.getOrderNo());
            }
            return;
        }
        User user = (User)this.userService.getById(order.getUid());
        if (ObjectUtil.isNull((Object)user)) {
            this.logger.error("\u8ba2\u5355\u79ef\u5206\u51bb\u7ed3\u5904\u7406\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8ba2\u5355\u7f16\u53f7={}", (Object)order.getOrderNo());
            return;
        }
        Integer balance = user.getIntegral();
        for (String orderNo : orderNoList) {
            UserIntegralRecord record = this.userIntegralRecordService.getByOrderNoAndType(orderNo, IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
            if (ObjectUtil.isNull((Object)record) || record.getStatus().equals(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE)) continue;
            record.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
            long thawTime = DateUtil.current((boolean)false);
            record.setFrozenTime(freezeDay);
            record.setThawTime(Long.valueOf(thawTime));
            balance = balance + record.getIntegral();
            record.setBalance(balance);
            record.setUpdateTime((Date)DateUtil.date());
            recordList.add(record);
        }
        if (CollUtil.isEmpty(recordList)) {
            return;
        }
        int integral = recordList.stream().mapToInt(UserIntegralRecord::getIntegral).sum();
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.userIntegralRecordService.updateBatchById(recordList);
            this.userService.updateIntegral(user.getId(), integral, "add");
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            this.logger.error("\u8ba2\u5355\u79ef\u5206\u51bb\u7ed3\u5904\u7406\uff1a\u76f4\u63a5\u89e3\u51bb\u5931\u8d25\uff0c\u8ba2\u5355\u7f16\u53f7={}", (Object)order.getOrderNo());
        }
    }

    private void orderBrokerageShareFreezingOperation(List<String> orderNoList, Integer freezeDay) {
        Order order = this.orderService.getByOrderNo(orderNoList.get(0));
        ArrayList<UserBrokerageRecord> recordList = new ArrayList<UserBrokerageRecord>();
        if (freezeDay > 0) {
            for (String orderNo : orderNoList) {
                List<UserBrokerageRecord> brokerageRecordList = this.userBrokerageRecordService.findListByLinkNoAndLinkType(orderNo, "order");
                if (CollUtil.isEmpty(brokerageRecordList)) continue;
                for (UserBrokerageRecord record : brokerageRecordList) {
                    if (!record.getStatus().equals(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE)) continue;
                    record.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_FROZEN);
                    record.setFrozenTime(freezeDay);
                    DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)record.getFrozenTime());
                    long thawTime = dateTime.getTime();
                    record.setThawTime(Long.valueOf(thawTime));
                    record.setUpdateTime((Date)DateUtil.date());
                    recordList.add(record);
                }
            }
            if (CollUtil.isEmpty(recordList)) {
                return;
            }
            this.userBrokerageRecordService.updateBatchById(recordList);
            return;
        }
        for (String orderNo : orderNoList) {
            List<UserBrokerageRecord> brokerageRecordList = this.userBrokerageRecordService.findListByLinkNoAndLinkType(orderNo, "order");
            if (CollUtil.isEmpty(brokerageRecordList)) continue;
            for (UserBrokerageRecord record : brokerageRecordList) {
                User user;
                if (!record.getStatus().equals(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE) || ObjectUtil.isNull((Object)(user = (User)this.userService.getById(record.getUid())))) continue;
                record.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE);
                BigDecimal balance = user.getBrokeragePrice().add(record.getPrice());
                record.setBalance(balance);
                record.setUpdateTime((Date)DateUtil.date());
                recordList.add(record);
            }
        }
        if (CollUtil.isEmpty(recordList)) {
            return;
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.userBrokerageRecordService.updateBatchById(recordList);
            recordList.forEach(record -> this.userService.updateBrokerage(record.getUid(), record.getPrice(), "add"));
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            this.logger.error(StrUtil.format((CharSequence)"\u4f63\u91d1\u89e3\u51bb\u5904\u7406\u2014\u6570\u636e\u5e93\u51fa\u9519\uff0c\u8ba2\u5355\u7f16\u53f7 = {}", (Object[])new Object[]{order.getOrderNo()}));
        }
    }

    private void orderMerchantShareFreezingOperation(List<String> orderNoList, Integer freezeDay) {
        Order order = this.orderService.getByOrderNo(orderNoList.get(0));
        ArrayList<MerchantBalanceRecord> recordList = new ArrayList<MerchantBalanceRecord>();
        if (freezeDay > 0) {
            for (String orderNo : orderNoList) {
                MerchantBalanceRecord record = this.merchantBalanceRecordService.getByLinkNo(orderNo);
                if (ObjectUtil.isNull((Object)record) || !record.getStatus().equals(1)) continue;
                record.setStatus(Integer.valueOf(2));
                record.setFrozenTime(freezeDay);
                DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)record.getFrozenTime());
                long thawTime = dateTime.getTime();
                record.setThawTime(Long.valueOf(thawTime));
                record.setUpdateTime((Date)DateUtil.date());
                recordList.add(record);
            }
            if (CollUtil.isEmpty(recordList)) {
                return;
            }
            this.merchantBalanceRecordService.updateBatchById(recordList);
            return;
        }
        for (String orderNo : orderNoList) {
            MerchantBalanceRecord record = this.merchantBalanceRecordService.getByLinkNo(orderNo);
            if (ObjectUtil.isNull((Object)record) || !record.getStatus().equals(1)) continue;
            record.setStatus(Integer.valueOf(3));
            Merchant merchant = (Merchant)this.merchantService.getById(record.getMerId());
            record.setBalance(merchant.getBalance().add(record.getAmount()));
            record.setUpdateTime((Date)DateUtil.date());
            recordList.add(record);
        }
        if (CollUtil.isEmpty(recordList)) {
            return;
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.merchantBalanceRecordService.updateBatchById(recordList);
            recordList.forEach(record -> this.merchantService.operationBalance(record.getMerId(), record.getAmount(), "add"));
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            this.logger.error(StrUtil.format((CharSequence)"\u5546\u6237\u4f59\u989d\u89e3\u51bb\u5904\u7406\u2014\u6570\u636e\u5e93\u51fa\u9519\uff0c\u8ba2\u5355\u7f16\u53f7 = {}", (Object[])new Object[]{order.getOrderNo()}));
        }
    }

    private Boolean oneMerchantOrderProcessing(Order order, MerchantOrder merchantOrder) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        User user = (User)this.userService.getById(order.getUid());
        this.presentIntegral(merchantOrder, orderDetailList, order, user.getIsPaidMember());
        Order newOrder = new Order();
        BeanUtils.copyProperties((Object)order, (Object)newOrder);
        MerchantOrder newMerOrder = new MerchantOrder();
        BeanUtils.copyProperties((Object)merchantOrder, (Object)newMerOrder);
        newOrder.setId(null);
        newOrder.setOrderNo(CrmebUtil.getOrderNo((String)"SH"));
        newOrder.setMerId(merchantOrder.getMerId());
        newOrder.setLevel(OrderConstants.ORDER_LEVEL_MERCHANT);
        newOrder.setPlatOrderNo(order.getOrderNo());
        newOrder.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
        newOrder.setPlatCouponPrice(merchantOrder.getPlatCouponPrice());
        newOrder.setMerCouponPrice(merchantOrder.getMerCouponPrice());
        if (order.getType().equals(OrderConstants.ORDER_TYPE_PITUAN)) {
            newOrder.setGroupBuyRecordStatus(GroupBuyRecordEnum.GROUP_BUY_RECORD_ENUM_STATUS_INIT.getCode());
        } else if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP) || merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_TO_STORE) || merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_HOME_SERVICE)) {
            newOrder.setStatus(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
        }
        newMerOrder.setId(null);
        newMerOrder.setOrderNo(newOrder.getOrderNo());
        List newOrderDetailList = orderDetailList.stream().map(e -> {
            OrderDetail orderDetail = new OrderDetail();
            BeanUtils.copyProperties((Object)e, (Object)orderDetail);
            orderDetail.setId(null);
            orderDetail.setOrderNo(newOrder.getOrderNo());
            orderDetail.setUpdateTime((Date)DateUtil.date());
            return orderDetail;
        }).collect(Collectors.toList());
        order.setIsDel(Boolean.valueOf(true));
        merchantOrder.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean delete = this.orderService.paySplitDelete(order.getOrderNo());
            if (!delete.booleanValue()) {
                this.logger.error("\u652f\u4ed8\u62c6\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            this.merchantOrderService.updateById(merchantOrder);
            if (order.getGainIntegral() > 0) {
                orderDetailList.forEach(o -> o.setUpdateTime((Date)DateUtil.date()));
                this.orderDetailService.updateBatchById(orderDetailList);
            }
            this.orderService.save(newOrder);
            this.merchantOrderService.save(newMerOrder);
            this.orderDetailService.saveBatch(newOrderDetailList);
            if (order.getType().equals(OrderConstants.ORDER_TYPE_PITUAN)) {
                this.logger.info("\u62fc\u56e2\u6b63\u5728\u5904\u7406\u7684\u8ba2\u5355\u53f7\uff1a${}:", (Object)order.getOrderNo());
                this.groupBuyUserService.afterPay(order.getOrderNo());
            }
            this.orderFlowRecordService.orderSplit(order.getOrderNo(), newOrder.getOrderNo());
            return Boolean.TRUE;
        });
    }

    private Boolean manyMerchantOrderProcessing(Order order, List<MerchantOrder> merchantOrderList) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        User user = (User)this.userService.getById(order.getUid());
        this.presentIntegral(merchantOrderList, orderDetailList, order, user.getIsPaidMember());
        ArrayList newOrderList = CollUtil.newArrayList((Object[])new Order[0]);
        ArrayList newMerchantOrderList = CollUtil.newArrayList((Object[])new MerchantOrder[0]);
        ArrayList newOrderDetailList = CollUtil.newArrayList((Object[])new OrderDetail[0]);
        order.setIsDel(Boolean.valueOf(true));
        for (MerchantOrder merchantOrder : merchantOrderList) {
            Order newOrder = new Order();
            BeanUtils.copyProperties((Object)order, (Object)newOrder);
            newOrder.setId(null);
            newOrder.setOrderNo(CrmebUtil.getOrderNo((String)"SH"));
            newOrder.setMerId(merchantOrder.getMerId());
            newOrder.setTotalNum(merchantOrder.getTotalNum());
            newOrder.setProTotalPrice(merchantOrder.getProTotalPrice());
            newOrder.setTotalPostage(merchantOrder.getTotalPostage());
            newOrder.setTotalPrice(merchantOrder.getTotalPrice());
            newOrder.setCouponPrice(merchantOrder.getCouponPrice());
            newOrder.setMerCouponPrice(merchantOrder.getMerCouponPrice());
            newOrder.setPlatCouponPrice(merchantOrder.getPlatCouponPrice());
            newOrder.setUseIntegral(merchantOrder.getUseIntegral());
            newOrder.setIntegralPrice(merchantOrder.getIntegralPrice());
            newOrder.setPayPrice(merchantOrder.getPayPrice());
            newOrder.setPayPostage(merchantOrder.getPayPostage());
            newOrder.setGainIntegral(merchantOrder.getGainIntegral());
            newOrder.setLevel(OrderConstants.ORDER_LEVEL_MERCHANT);
            newOrder.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            newOrder.setPlatOrderNo(order.getOrderNo());
            newOrder.setIsDel(Boolean.valueOf(false));
            newOrder.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP)) {
                newOrder.setStatus(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
            }
            newOrder.setSvipDiscountPrice(merchantOrder.getSvipDiscountPrice());
            MerchantOrder newMerchantOrder = new MerchantOrder();
            BeanUtils.copyProperties((Object)merchantOrder, (Object)newMerchantOrder);
            newMerchantOrder.setId(null);
            newMerchantOrder.setOrderNo(newOrder.getOrderNo());
            List<OrderDetail> tempDetailList = orderDetailList.stream().filter(e -> e.getMerId().equals(merchantOrder.getMerId())).collect(Collectors.toList());
            tempDetailList.forEach(d -> {
                d.setId(null);
                d.setOrderNo(newOrder.getOrderNo());
            });
            newOrderList.add(newOrder);
            newMerchantOrderList.add(newMerchantOrder);
            newOrderDetailList.addAll(tempDetailList);
        }
        merchantOrderList.forEach(o -> o.setUpdateTime((Date)DateUtil.date()));
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean delete = this.orderService.paySplitDelete(order.getOrderNo());
            if (!delete.booleanValue()) {
                this.logger.error("\u652f\u4ed8\u62c6\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            this.merchantOrderService.updateBatchById(merchantOrderList);
            this.orderService.saveBatch(newOrderList);
            this.merchantOrderService.saveBatch(newMerchantOrderList);
            this.orderDetailService.saveBatch(newOrderDetailList);
            this.orderFlowRecordService.orderSplit(order.getOrderNo(), merchantOrderList.stream().map(MerchantOrder::getOrderNo).collect(Collectors.toList()));
            return Boolean.TRUE;
        });
    }

    private void presentIntegral(MerchantOrder merchantOrder, List<OrderDetail> orderDetailList, Order order, Boolean isPaidMember) {
        String integralRatioStr = this.systemConfigService.getValueByKey("order_give_integral");
        if (StrUtil.isNotBlank((CharSequence)integralRatioStr) && order.getPayPrice().compareTo(BigDecimal.ZERO) > 0 && new BigDecimal(integralRatioStr).compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal integralBig = new BigDecimal(integralRatioStr);
            int giveIntegral = merchantOrder.getPayPrice().divide(integralBig, 0, 1).intValue();
            if (isPaidMember.booleanValue()) {
                List<PaidMemberBenefitsVo> benefitsList = this.paidMemberService.getBenefitsList();
                for (PaidMemberBenefitsVo b : benefitsList) {
                    if (!b.getStatus().booleanValue() || !b.getName().equals("integralDoubling") || b.getMultiple() <= 1 || !b.getChannelStr().contains("2")) continue;
                    giveIntegral *= b.getMultiple().intValue();
                }
            }
            merchantOrder.setGainIntegral(Integer.valueOf(giveIntegral));
            order.setGainIntegral(Integer.valueOf(giveIntegral));
            if (giveIntegral > 0) {
                for (int i = 0; i < orderDetailList.size(); ++i) {
                    OrderDetail orderDetail = orderDetailList.get(i);
                    if (orderDetailList.size() == i + 1) {
                        orderDetail.setGainIntegral(Integer.valueOf(giveIntegral));
                        break;
                    }
                    BigDecimal ratio = orderDetail.getPayPrice().divide(merchantOrder.getPayPrice(), 10, 4);
                    int integral = new BigDecimal(Integer.toString(merchantOrder.getGainIntegral())).multiply(ratio).setScale(0, 1).intValue();
                    orderDetail.setGainIntegral(Integer.valueOf(integral));
                    giveIntegral -= integral;
                }
            }
        }
    }

    private void presentIntegral(List<MerchantOrder> merchantOrderList, List<OrderDetail> orderDetailList, Order order, Boolean isPaidMember) {
        int integral = 0;
        String integralRatioStr = this.systemConfigService.getValueByKey("order_give_integral");
        if (StrUtil.isNotBlank((CharSequence)integralRatioStr) && order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
            for (MerchantOrder merOrder : merchantOrderList) {
                int giveIntegral;
                BigDecimal integralBig = new BigDecimal(integralRatioStr);
                if (integralBig.compareTo(BigDecimal.ZERO) <= 0) {
                    giveIntegral = 0;
                } else {
                    giveIntegral = merOrder.getPayPrice().divide(integralBig, 0, 1).intValue();
                    if (isPaidMember.booleanValue()) {
                        List<PaidMemberBenefitsVo> benefitsList = this.paidMemberService.getBenefitsList();
                        for (PaidMemberBenefitsVo b : benefitsList) {
                            if (!b.getStatus().booleanValue() || !b.getName().equals("integralDoubling") || b.getMultiple() <= 1 || !b.getChannelStr().contains("2")) continue;
                            giveIntegral *= b.getMultiple().intValue();
                        }
                    }
                }
                integral += giveIntegral;
                merOrder.setGainIntegral(Integer.valueOf(giveIntegral));
                if (giveIntegral <= 0) continue;
                List detailList = orderDetailList.stream().filter(e -> e.getMerId().equals(merOrder.getMerId())).collect(Collectors.toList());
                for (int i = 0; i < detailList.size(); ++i) {
                    OrderDetail orderDetail = (OrderDetail)detailList.get(i);
                    if (detailList.size() == i + 1) {
                        orderDetail.setGainIntegral(Integer.valueOf(giveIntegral));
                    }
                    BigDecimal ratio = orderDetail.getPayPrice().divide(merOrder.getPayPrice(), 10, 4);
                    int detailIntegral = new BigDecimal(Integer.toString(merOrder.getGainIntegral())).multiply(ratio).setScale(0, 1).intValue();
                    orderDetail.setGainIntegral(Integer.valueOf(detailIntegral));
                    giveIntegral -= detailIntegral;
                }
            }
            if (integral > 0) {
                order.setGainIntegral(Integer.valueOf(integral));
            }
        }
    }
}

