/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.model.acticitystyle.ActivityStyle;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.ActivityStyleSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.ActivityStyleResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.dao.ActivityStyleDao;
import com.zbkj.service.service.ActivityStyleService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityStyleServiceImpl
extends ServiceImpl<ActivityStyleDao, ActivityStyle>
implements ActivityStyleService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityStyleService.class);
    @Resource
    private ActivityStyleDao dao;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CrmebConfig crmebConfig;

    @Override
    public PageInfo<ActivityStyleResponse> getList(ActivityStyleSearchRequest request, PageParamRequest pageParamRequest) {
        Page stylePage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        Date currentDate = CrmebDateUtil.nowDateTime();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(ActivityStyle::getType, (Object)request.getType());
        if (ObjectUtil.isNotEmpty((Object)request.getId()) && request.getId() > 0) {
            lambdaQueryWrapper.eq(ActivityStyle::getId, (Object)request.getId());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getName())) {
            lambdaQueryWrapper.like(ActivityStyle::getName, (Object)URLUtil.decode((String)request.getName()));
        }
        if (ObjectUtil.isNotEmpty((Object)request.getStatus())) {
            lambdaQueryWrapper.eq(ActivityStyle::getStatus, (Object)request.getStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getMethod())) {
            lambdaQueryWrapper.eq(ActivityStyle::getMethod, (Object)request.getMethod());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getStarttime()) && ObjectUtil.isNotEmpty((Object)request.getEndtime())) {
            lambdaQueryWrapper.between(ActivityStyle::getCreatetime, (Object)request.getStarttime(), (Object)request.getEndtime());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getRunningStatus())) {
            switch (request.getRunningStatus()) {
                case -1: {
                    lambdaQueryWrapper.lt(ActivityStyle::getEndtime, (Object)currentDate);
                    break;
                }
                case 0: {
                    lambdaQueryWrapper.gt(ActivityStyle::getStarttime, (Object)currentDate);
                    break;
                }
                case 1: {
                    ((LambdaQueryWrapper)lambdaQueryWrapper.ge(ActivityStyle::getEndtime, (Object)currentDate)).le(ActivityStyle::getStarttime, (Object)currentDate);
                }
            }
        }
        lambdaQueryWrapper.orderByDesc(ActivityStyle::getCreatetime);
        List activityStyles = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        ArrayList<ActivityStyleResponse> activityStyleResponses = new ArrayList<ActivityStyleResponse>();
        for (ActivityStyle activityStyle : activityStyles) {
            ActivityStyleResponse activityStyleResponse = new ActivityStyleResponse();
            BeanUtils.copyProperties((Object)activityStyle, (Object)activityStyleResponse);
            activityStyleResponse.setRunningStatus(activityStyle.getStarttime(), activityStyle.getEndtime(), currentDate);
            activityStyleResponses.add(activityStyleResponse);
        }
        return CommonPage.copyPageInfo((Page)stylePage, activityStyleResponses);
    }

    @Override
    public boolean updateStatus(Integer id, boolean status) {
        ActivityStyle activityStyle = new ActivityStyle();
        activityStyle.setId(id);
        activityStyle.setStatus(Boolean.valueOf(status));
        activityStyle.setUpdatetime((Date)DateUtil.date());
        return this.updateById(activityStyle);
    }

    private List<ActivityStyle> getListBeforeBeginTime(boolean type) {
        if (!type && this.redisUtil.exists("activity_style_border").booleanValue()) {
            Object o = this.redisUtil.get("activity_style_border");
            String s = JSON.toJSONString((Object)o);
            return JSON.parseArray((String)s, ActivityStyle.class);
        }
        if (type && this.redisUtil.exists("activity_style_background").booleanValue()) {
            Object o = this.redisUtil.get("activity_style_background");
            String s = JSON.toJSONString((Object)o);
            return JSON.parseArray((String)s, ActivityStyle.class);
        }
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(ActivityStyle::getType, (Object)type);
        lambdaQueryWrapper.eq(ActivityStyle::getStatus, (Object)Boolean.TRUE);
        lambdaQueryWrapper.le(ActivityStyle::getStarttime, (Object)CrmebDateUtil.nowDateTime((String)"yyyy-MM-dd HH:mm:ss"));
        lambdaQueryWrapper.ge(ActivityStyle::getEndtime, (Object)CrmebDateUtil.nowDateTime((String)"yyyy-MM-dd HH:mm:ss"));
        List activityStyles = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        if (activityStyles.size() == 0) {
            return new ArrayList<ActivityStyle>();
        }
        if (!type) {
            this.redisUtil.set("activity_style_border", (Object)activityStyles, Long.valueOf(Long.parseLong(this.crmebConfig.getActivityStyleCachedTime().toString())), TimeUnit.SECONDS);
        } else {
            this.redisUtil.set("activity_style_background", (Object)activityStyles, Long.valueOf(Long.parseLong(this.crmebConfig.getActivityStyleCachedTime().toString())), TimeUnit.SECONDS);
        }
        return activityStyles;
    }

    @Override
    public List<Product> makeActivityBorderStyle(List<Product> productList) {
        List<ActivityStyle> listBeforeBeginTime = this.getListBeforeBeginTime(Boolean.FALSE);
        if (ObjectUtil.isNotNull(listBeforeBeginTime) && listBeforeBeginTime.size() > 0) {
            List<ActivityStyle> activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 0).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(activityStyleAllBeforeCompare)) {
                this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
                ActivityStyle activityStyleCurrentAll = activityStyleAllBeforeCompare.get(0);
                productList.forEach(product -> product.setActivityStyle(activityStyleCurrentAll.getStyle()));
            } else {
                this.makeActivityBorderStyleNonGlobal(productList, listBeforeBeginTime);
            }
        }
        return productList;
    }

    private void makeActivityBorderStyleNonGlobal(List<Product> productList, List<ActivityStyle> listBeforeBeginTime) {
        ActivityStyle activityStyle2;
        Iterator<Object> iterator;
        long productSurplusNum;
        List<Object> activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 1).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(activityStyleAllBeforeCompare)) {
            this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
            for (ActivityStyle activityStyle3 : activityStyleAllBeforeCompare) {
                if (activityStyle3.getProducts().length() == 0) break;
                String[] activityBorderStyleProducts = StrUtil.split((CharSequence)activityStyle3.getProducts(), (CharSequence)",");
                productList.forEach(product -> {
                    for (String activityBorderStyleProduct : activityBorderStyleProducts) {
                        if (!activityBorderStyleProduct.equals(product.getId().toString())) continue;
                        product.setActivityStyle(activityStyle3.getStyle());
                    }
                });
            }
        }
        if ((productSurplusNum = productList.stream().filter(e -> StrUtil.isBlank((CharSequence)e.getActivityStyle())).count()) <= 0L) {
            return;
        }
        activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 2).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(activityStyleAllBeforeCompare)) {
            this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
            iterator = activityStyleAllBeforeCompare.iterator();
            while (iterator.hasNext() && (activityStyle2 = (ActivityStyle)iterator.next()).getProducts().length() != 0) {
                String[] activityBorderStyleBands = StrUtil.split((CharSequence)activityStyle2.getProducts(), (CharSequence)",");
                productList.forEach(product -> {
                    if (StrUtil.isBlank((CharSequence)product.getActivityStyle())) {
                        for (String activityBorderStyleBand : activityBorderStyleBands) {
                            if (!ObjectUtil.isNotEmpty((Object)product.getBrandId()) || product.getBrandId() <= 0 || !activityBorderStyleBand.equals(product.getBrandId().toString())) continue;
                            product.setActivityStyle(activityStyle2.getStyle());
                        }
                    }
                });
            }
        }
        if ((productSurplusNum = productList.stream().filter(e -> StrUtil.isBlank((CharSequence)e.getActivityStyle())).count()) <= 0L) {
            return;
        }
        activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 3).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(activityStyleAllBeforeCompare)) {
            this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
            iterator = activityStyleAllBeforeCompare.iterator();
            while (iterator.hasNext() && (activityStyle2 = (ActivityStyle)iterator.next()).getProducts().length() != 0) {
                String[] platCategoryIds = StrUtil.split((CharSequence)activityStyle2.getProducts(), (CharSequence)",");
                productList.forEach(product -> {
                    if (StrUtil.isBlank((CharSequence)product.getActivityStyle())) {
                        for (String pcid : platCategoryIds) {
                            if (!ObjectUtil.isNotEmpty((Object)product.getCategoryId()) || product.getCategoryId() <= 0 || !pcid.equals(product.getCategoryId().toString())) continue;
                            product.setActivityStyle(activityStyle2.getStyle());
                        }
                    }
                });
            }
        }
        if ((productSurplusNum = productList.stream().filter(e -> StrUtil.isBlank((CharSequence)e.getActivityStyle())).count()) <= 0L) {
            return;
        }
        activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 4).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(activityStyleAllBeforeCompare)) {
            this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
            iterator = activityStyleAllBeforeCompare.iterator();
            while (iterator.hasNext() && (activityStyle2 = (ActivityStyle)iterator.next()).getProducts().length() != 0) {
                String[] merIds = StrUtil.split((CharSequence)activityStyle2.getProducts(), (CharSequence)",");
                productList.forEach(product -> {
                    if (StrUtil.isBlank((CharSequence)product.getActivityStyle())) {
                        for (String merid : merIds) {
                            if (!merid.equals(product.getMerId().toString())) continue;
                            product.setActivityStyle(activityStyle2.getStyle());
                        }
                    }
                });
            }
        }
    }

    @Override
    public String makeActivityBackgroundStyle(Product product) {
        ActivityStyle activityStyle2;
        List<ActivityStyle> listBeforeBeginTime = this.getListBeforeBeginTime(Boolean.TRUE);
        List<Object> activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 0).collect(Collectors.toList());
        this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
        if (activityStyleAllBeforeCompare.size() > 0) {
            ActivityStyle activityStyleCurrentAll = activityStyleAllBeforeCompare.get(0);
            return activityStyleCurrentAll.getStyle();
        }
        activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 1).collect(Collectors.toList());
        this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
        Iterator<Object> iterator = activityStyleAllBeforeCompare.iterator();
        while (iterator.hasNext() && (activityStyle2 = (ActivityStyle)iterator.next()).getProducts().length() != 0) {
            String[] activityBorderStyleProducts;
            for (String activityBorderStyleProduct : activityBorderStyleProducts = StrUtil.split((CharSequence)activityStyle2.getProducts(), (CharSequence)",")) {
                if (!activityBorderStyleProduct.equals(product.getId().toString())) continue;
                return activityStyle2.getStyle();
            }
        }
        activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 2).collect(Collectors.toList());
        this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
        iterator = activityStyleAllBeforeCompare.iterator();
        while (iterator.hasNext() && (activityStyle2 = (ActivityStyle)iterator.next()).getProducts().length() != 0) {
            String[] activityBorderStyleBands;
            for (String activityBorderStyleBand : activityBorderStyleBands = StrUtil.split((CharSequence)activityStyle2.getProducts(), (CharSequence)",")) {
                if (!ObjectUtil.isNotEmpty((Object)product.getBrandId()) || !activityBorderStyleBand.equals(product.getBrandId().toString())) continue;
                return activityStyle2.getStyle();
            }
        }
        activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 3).collect(Collectors.toList());
        this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
        iterator = activityStyleAllBeforeCompare.iterator();
        while (iterator.hasNext() && (activityStyle2 = (ActivityStyle)iterator.next()).getProducts().length() != 0) {
            String[] platCategoryIds;
            for (String pcid : platCategoryIds = StrUtil.split((CharSequence)activityStyle2.getProducts(), (CharSequence)",")) {
                if (!pcid.equals(product.getCategoryId().toString())) continue;
                return activityStyle2.getStyle();
            }
        }
        activityStyleAllBeforeCompare = listBeforeBeginTime.stream().filter(activityStyle -> activityStyle.getMethod() == 4).collect(Collectors.toList());
        this.sortByActivityStyleByUpdateTime(activityStyleAllBeforeCompare);
        iterator = activityStyleAllBeforeCompare.iterator();
        while (iterator.hasNext() && (activityStyle2 = (ActivityStyle)iterator.next()).getProducts().length() != 0) {
            String[] merIds;
            for (String merid : merIds = StrUtil.split((CharSequence)activityStyle2.getProducts(), (CharSequence)",")) {
                if (!merid.equals(product.getMerId().toString())) continue;
                return activityStyle2.getStyle();
            }
        }
        return null;
    }

    private void sortByActivityStyleByUpdateTime(List<ActivityStyle> toSortActivityStyleByUpdateTime) {
        Collections.sort(toSortActivityStyleByUpdateTime, new Comparator<ActivityStyle>(){

            @Override
            public int compare(ActivityStyle o1, ActivityStyle o2) {
                return CrmebDateUtil.compareDate((String)CrmebDateUtil.dateToStr((Date)o2.getUpdatetime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)CrmebDateUtil.dateToStr((Date)o1.getUpdatetime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
            }
        });
    }
}

