/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.groupbuy.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.enums.GroupBuyGroupStatusEnum;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.groupbuy.GroupBuyActivity;
import com.zbkj.common.model.groupbuy.GroupBuyActivitySku;
import com.zbkj.common.model.groupbuy.GroupBuyUser;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.groupbuy.GroupBuyActivityRequest;
import com.zbkj.common.request.groupbuy.GroupBuyActivitySearchRequest;
import com.zbkj.common.request.groupbuy.GroupBuyActivitySkuRequest;
import com.zbkj.common.request.groupbuy.PatGroupBuyActivitySearchRequest;
import com.zbkj.common.response.AttrValueResponse;
import com.zbkj.common.response.ProductInfoResponse;
import com.zbkj.common.response.groupbuy.GroupBuyActivityFrontItemResponse;
import com.zbkj.common.response.groupbuy.GroupBuyActivityFrontResponse;
import com.zbkj.common.response.groupbuy.GroupBuyActivityListHeaderCount;
import com.zbkj.common.response.groupbuy.GroupBuyActivityProductResponse;
import com.zbkj.common.response.groupbuy.GroupBuyActivityResponse;
import com.zbkj.common.response.groupbuy.GroupBuyActivitySkuResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.groupby.GroupBuyActivityDao;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.groupbuy.GroupBuyActivityService;
import com.zbkj.service.service.groupbuy.GroupBuyActivitySkuService;
import com.zbkj.service.service.groupbuy.GroupBuyUserService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GroupBuyActivityServiceImpl
extends ServiceImpl<GroupBuyActivityDao, GroupBuyActivity>
implements GroupBuyActivityService {
    @Resource
    private GroupBuyActivityDao dao;
    @Resource
    private GroupBuyActivitySkuService groupBuyActivitySkuService;
    @Resource
    private ProductService productService;
    @Resource
    private ProductAttrValueService productAttrValueService;
    @Resource
    private MerchantService merchantService;
    @Resource
    private GroupBuyUserService groupBuyUserService;

    @Override
    public PageInfo<GroupBuyActivityResponse> getList(PatGroupBuyActivitySearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(GroupBuyActivity::getIsDel, (Object)0);
        if (admin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue()) || admin.getType().equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
            lambdaQueryWrapper.eq(GroupBuyActivity::getMerId, (Object)admin.getMerId());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getGroupName().trim())) {
            lambdaQueryWrapper.like(GroupBuyActivity::getGroupName, (Object)URLUtil.decode((String)request.getGroupName().trim()));
        }
        if (ObjectUtil.isNotEmpty((Object)request.getGroupProcess())) {
            switch (request.getGroupProcess()) {
                case 0: {
                    lambdaQueryWrapper.ge(GroupBuyActivity::getStartTime, (Object)CrmebDateUtil.nowDateTime());
                    break;
                }
                case 1: {
                    ((LambdaQueryWrapper)lambdaQueryWrapper.le(GroupBuyActivity::getStartTime, (Object)CrmebDateUtil.nowDateTime())).gt(GroupBuyActivity::getEndTime, (Object)CrmebDateUtil.nowDateTime());
                    break;
                }
                case 2: {
                    lambdaQueryWrapper.lt(GroupBuyActivity::getEndTime, (Object)CrmebDateUtil.nowDateTime());
                }
            }
        }
        if (ObjectUtil.isNotEmpty((Object)request.getStartTime())) {
            Date date = CrmebDateUtil.strToDate((String)request.getStartTime(), (String)"yyyy-MM-dd");
            String startTime = CrmebDateUtil.dateToStr((Date)date, (String)"yyyy-MM-dd 00:00:00");
            String endTime = CrmebDateUtil.dateToStr((Date)date, (String)"yyyy-MM-dd 23:59:59");
            ((LambdaQueryWrapper)lambdaQueryWrapper.le(GroupBuyActivity::getStartTime, (Object)startTime)).ge(GroupBuyActivity::getEndTime, (Object)endTime);
        }
        if (ObjectUtil.isNotEmpty((Object)request.getGroupStatus())) {
            lambdaQueryWrapper.eq(GroupBuyActivity::getGroupStatus, (Object)request.getGroupStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getCategoryId())) {
            List<Merchant> merchantList = this.merchantService.getMerchantListByType(request.getCategoryId());
            List<Integer> merIds = new ArrayList<Integer>();
            if (merchantList.isEmpty()) {
                merIds.add(0);
            } else {
                merIds = merchantList.stream().map(Merchant::getId).collect(Collectors.toList());
            }
            lambdaQueryWrapper.in(GroupBuyActivity::getMerId, merIds);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getMerName())) {
            lambdaQueryWrapper.like(GroupBuyActivity::getMerName, (Object)URLUtil.decode((String)request.getMerName()));
        }
        if (ObjectUtil.isNotEmpty((Object)request.getActivityStatus())) {
            lambdaQueryWrapper.eq(GroupBuyActivity::getActivityStatus, (Object)request.getActivityStatus());
        }
        lambdaQueryWrapper.orderByDesc(GroupBuyActivity::getCreateTime);
        Page activityGroupPage = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List groupBuyActivities = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        ArrayList groupBuyActivityResponses = new ArrayList();
        groupBuyActivities.stream().map(groupBuyActivity -> {
            GroupBuyActivityResponse groupBuyActivityResponse = new GroupBuyActivityResponse();
            BeanUtils.copyProperties((Object)groupBuyActivity, (Object)groupBuyActivityResponse);
            groupBuyActivityResponses.add(groupBuyActivityResponse);
            return null;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)activityGroupPage, groupBuyActivityResponses);
    }

    @Override
    public List<GroupBuyActivityListHeaderCount> getListHeaderCount(GroupBuyActivitySearchRequest request, SystemAdmin systemAdmin) {
        GroupBuyActivityListHeaderCount headerCount1;
        ArrayList<GroupBuyActivityListHeaderCount> headerCountList = new ArrayList<GroupBuyActivityListHeaderCount>();
        if (systemAdmin.getMerId() == 0) {
            headerCount1 = new GroupBuyActivityListHeaderCount(Integer.valueOf(1), Integer.valueOf(0));
            GroupBuyActivityListHeaderCount headerCount3 = new GroupBuyActivityListHeaderCount(Integer.valueOf(3), Integer.valueOf(0));
            GroupBuyActivityListHeaderCount headerCount4 = new GroupBuyActivityListHeaderCount(Integer.valueOf(4), Integer.valueOf(0));
            headerCountList.add(headerCount1);
            headerCountList.add(headerCount3);
            headerCountList.add(headerCount4);
        } else {
            headerCount1 = new GroupBuyActivityListHeaderCount(Integer.valueOf(1), Integer.valueOf(0));
            GroupBuyActivityListHeaderCount headerCount2 = new GroupBuyActivityListHeaderCount(Integer.valueOf(2), Integer.valueOf(0));
            GroupBuyActivityListHeaderCount headerCount3 = new GroupBuyActivityListHeaderCount(Integer.valueOf(3), Integer.valueOf(0));
            GroupBuyActivityListHeaderCount headerCount4 = new GroupBuyActivityListHeaderCount(Integer.valueOf(4), Integer.valueOf(0));
            headerCountList.add(headerCount1);
            headerCountList.add(headerCount2);
            headerCountList.add(headerCount3);
            headerCountList.add(headerCount4);
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        for (GroupBuyActivityListHeaderCount headerCount : headerCountList) {
            queryWrapper.clear();
            queryWrapper.eq(GroupBuyActivity::getIsDel, (Object)0);
            if (StrUtil.isNotBlank((CharSequence)request.getMerName())) {
                queryWrapper.like(GroupBuyActivity::getMerName, (Object)URLUtil.decode((String)request.getMerName()));
            }
            if (StrUtil.isNotBlank((CharSequence)request.getGroupName().trim())) {
                String groupNameDecode = URLUtil.decode((String)request.getGroupName().trim());
                queryWrapper.like(GroupBuyActivity::getGroupName, (Object)groupNameDecode);
            }
            if (ObjectUtil.isNotEmpty((Object)request.getGroupProcess())) {
                switch (request.getGroupProcess()) {
                    case 0: {
                        queryWrapper.ge(GroupBuyActivity::getStartTime, (Object)CrmebDateUtil.nowDateTime());
                        break;
                    }
                    case 1: {
                        ((LambdaQueryWrapper)queryWrapper.le(GroupBuyActivity::getStartTime, (Object)CrmebDateUtil.nowDateTime())).gt(GroupBuyActivity::getEndTime, (Object)CrmebDateUtil.nowDateTime());
                        break;
                    }
                    case 2: {
                        queryWrapper.lt(GroupBuyActivity::getEndTime, (Object)CrmebDateUtil.nowDateTime());
                    }
                }
            }
            if (ObjectUtil.isNotEmpty((Object)request.getStartTime())) {
                Date date = CrmebDateUtil.strToDate((String)request.getStartTime(), (String)"yyyy-MM-dd");
                String startTime = CrmebDateUtil.dateToStr((Date)date, (String)"yyyy-MM-dd 00:00:00");
                String endTime = CrmebDateUtil.dateToStr((Date)date, (String)"yyyy-MM-dd 23:59:59");
                ((LambdaQueryWrapper)queryWrapper.le(GroupBuyActivity::getStartTime, (Object)startTime)).ge(GroupBuyActivity::getEndTime, (Object)endTime);
            }
            if (ObjectUtil.isNotEmpty((Object)request.getCategoryId())) {
                List<Merchant> merchantList = this.merchantService.getMerchantListByType(request.getCategoryId());
                List<Integer> merIdList = new ArrayList<Integer>();
                if (merchantList.isEmpty()) {
                    merIdList.add(0);
                } else {
                    merIdList = merchantList.stream().map(Merchant::getId).collect(Collectors.toList());
                }
                queryWrapper.in(GroupBuyActivity::getMerId, merIdList);
            }
            if (ObjectUtil.isNotEmpty((Object)request.getActivityStatus())) {
                queryWrapper.eq(GroupBuyActivity::getActivityStatus, (Object)request.getActivityStatus());
            }
            if (systemAdmin.getType().equals(RoleEnum.MERCHANT_ADMIN.getValue()) || systemAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
                queryWrapper.eq(GroupBuyActivity::getMerId, (Object)systemAdmin.getMerId());
            }
            queryWrapper.eq(GroupBuyActivity::getGroupStatus, (Object)headerCount.getGroupStatus());
            headerCount.setCount(this.dao.selectCount((Wrapper)queryWrapper));
        }
        return headerCountList;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Boolean addGroupBuyActivity(GroupBuyActivityRequest request) {
        GroupBuyActivity groupBuyActivity = new GroupBuyActivity();
        BeanUtils.copyProperties((Object)request, (Object)groupBuyActivity);
        List<Object> groupBuySkuList = new ArrayList<GroupBuyActivitySku>();
        List groupBuySkuRequestList = request.getGroupBuySkuRequest();
        for (GroupBuyActivitySkuRequest groupSkuRequest : groupBuySkuRequestList) {
            GroupBuyActivitySku groupSku = new GroupBuyActivitySku();
            BeanUtils.copyProperties((Object)groupSkuRequest, (Object)groupSku);
            groupSku.setQuota(groupSkuRequest.getQuotaShow());
            groupBuySkuList.add(groupSku);
        }
        this.validGroupProduct(groupBuySkuList);
        groupBuyActivity.setGroupStatus(GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_AUDIT.getCode());
        SystemAdmin currentMerchantAdmin = SecurityUtil.getLoginUserVo().getUser();
        Merchant currentMerchant = this.merchantService.getByIdException(currentMerchantAdmin.getMerId());
        groupBuyActivity.setMerId(currentMerchantAdmin.getMerId());
        groupBuyActivity.setMerName(currentMerchant.getName());
        this.dao.insert(groupBuyActivity);
        groupBuySkuList = groupBuySkuList.stream().map(sku -> sku.setGroupActivityId(groupBuyActivity.getId())).collect(Collectors.toList());
        this.groupBuyActivitySkuService.saveBatch(groupBuySkuList);
        return Boolean.TRUE;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Boolean updateGroupBuyActivity(GroupBuyActivityRequest request) {
        GroupBuyActivity groupBuyActivity = new GroupBuyActivity();
        BeanUtils.copyProperties((Object)request, (Object)groupBuyActivity);
        groupBuyActivity.setGroupName(request.getGroupName());
        ArrayList<GroupBuyActivitySku> groupBuySkuList = new ArrayList<GroupBuyActivitySku>();
        List groupBuySkuRequestList = request.getGroupBuySkuRequest();
        for (GroupBuyActivitySkuRequest groupSkuRequest : groupBuySkuRequestList) {
            GroupBuyActivitySku groupSku = new GroupBuyActivitySku();
            BeanUtils.copyProperties((Object)groupSkuRequest, (Object)groupSku);
            groupSku.setQuota(groupSkuRequest.getQuotaShow());
            groupBuySkuList.add(groupSku);
        }
        this.validGroupProduct(groupBuySkuList);
        groupBuyActivity.setGroupStatus(GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_AUDIT.getCode());
        groupBuyActivity.setUpdateTime((Date)DateUtil.date());
        this.dao.updateById(groupBuyActivity);
        List<GroupBuyActivitySku> listByGroupActivityId = this.groupBuyActivitySkuService.getListByGroupActivityId(request.getId());
        if (ObjectUtil.isNotEmpty(listByGroupActivityId)) {
            List skuIds = listByGroupActivityId.stream().map(GroupBuyActivitySku::getId).collect(Collectors.toList());
            this.groupBuyActivitySkuService.removeByIds(skuIds);
        }
        this.groupBuyActivitySkuService.saveBatch(groupBuySkuList);
        return Boolean.TRUE;
    }

    @Override
    public GroupBuyActivityResponse getGroupBuyActivity(Integer id) {
        GroupBuyActivity groupBuyActivity = (GroupBuyActivity)this.dao.selectById(id);
        if (ObjectUtil.isEmpty((Object)groupBuyActivity)) {
            return null;
        }
        ArrayList<GroupBuyActivityProductResponse> groupBuyActivityProductResponseList = new ArrayList<GroupBuyActivityProductResponse>();
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        GroupBuyActivityResponse groupBuyActivityResponse = new GroupBuyActivityResponse();
        BeanUtils.copyProperties((Object)groupBuyActivity, (Object)groupBuyActivityResponse);
        List<GroupBuyActivitySku> groupBuyActivitySkuList = this.groupBuyActivitySkuService.getListByGroupActivityId(id);
        Map<Integer, List<GroupBuyActivitySku>> skuListGroupByProductIdMap = groupBuyActivitySkuList.stream().collect(Collectors.groupingBy(GroupBuyActivitySku::getProductId));
        for (Map.Entry<Integer, List<GroupBuyActivitySku>> productIdEntry : skuListGroupByProductIdMap.entrySet()) {
            Integer productId = productIdEntry.getKey();
            List<GroupBuyActivitySku> groupBuyActivitySkuListByProductId = productIdEntry.getValue();
            ProductInfoResponse productInfoResponse = this.productService.getInfo(productId, systemAdmin);
            if (productInfoResponse.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) || productInfoResponse.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) continue;
            ArrayList<GroupBuyActivitySkuResponse> groupBuyActivitySkuResponseList = new ArrayList<GroupBuyActivitySkuResponse>();
            for (GroupBuyActivitySku groupBuyActivitySku : groupBuyActivitySkuListByProductId) {
                GroupBuyActivitySkuResponse skuResponse = new GroupBuyActivitySkuResponse();
                skuResponse.setId(groupBuyActivitySku.getId());
                skuResponse.setGroupActivityId(groupBuyActivitySku.getGroupActivityId());
                skuResponse.setProductId(productId);
                skuResponse.setActivePrice(groupBuyActivitySku.getActivePrice());
                skuResponse.setQuotaShow(groupBuyActivitySku.getQuotaShow());
                skuResponse.setQuota(groupBuyActivitySku.getQuota());
                skuResponse.setProductName(productInfoResponse.getName());
                skuResponse.setSkuId(groupBuyActivitySku.getSkuId());
                List seamSkuList = productInfoResponse.getAttrValueList().stream().filter(attrValue -> attrValue.getId().equals(groupBuyActivitySku.getSkuId())).collect(Collectors.toList());
                if (seamSkuList.isEmpty()) continue;
                skuResponse.setAttrValue(seamSkuList);
                groupBuyActivitySkuResponseList.add(skuResponse);
            }
            GroupBuyActivityProductResponse groupBuyActivityProductResponse = new GroupBuyActivityProductResponse();
            groupBuyActivityProductResponse.setProductId(productId);
            groupBuyActivityProductResponse.setProductName(productInfoResponse.getName());
            groupBuyActivityProductResponse.setImage(productInfoResponse.getImage());
            groupBuyActivityProductResponse.setGroupBuyActivitySkuResponses(groupBuyActivitySkuResponseList);
            groupBuyActivityProductResponseList.add(groupBuyActivityProductResponse);
        }
        groupBuyActivityResponse.setGroupBuyActivityProductResponseList(groupBuyActivityProductResponseList);
        return groupBuyActivityResponse;
    }

    @Override
    public GroupBuyActivityResponse getGroupBuyActivityForFront(Integer id) {
        GroupBuyActivity groupBuyActivity = (GroupBuyActivity)this.dao.selectById(id);
        if (ObjectUtil.isEmpty((Object)groupBuyActivity)) {
            return null;
        }
        ArrayList<GroupBuyActivityProductResponse> groupBuyActivityProductResponseList = new ArrayList<GroupBuyActivityProductResponse>();
        GroupBuyActivityResponse groupBuyActivityResponse = new GroupBuyActivityResponse();
        BeanUtils.copyProperties((Object)groupBuyActivity, (Object)groupBuyActivityResponse);
        List<GroupBuyActivitySku> groupBuyActivitySkuList = this.groupBuyActivitySkuService.getListByGroupActivityId(id);
        Map<Integer, List<GroupBuyActivitySku>> skuListGroupByProductIdMap = groupBuyActivitySkuList.stream().collect(Collectors.groupingBy(GroupBuyActivitySku::getProductId));
        for (Map.Entry<Integer, List<GroupBuyActivitySku>> productIdEntry : skuListGroupByProductIdMap.entrySet()) {
            Integer productId = productIdEntry.getKey();
            List<GroupBuyActivitySku> groupBuyActivitySkuListByProductId = productIdEntry.getValue();
            ArrayList<GroupBuyActivitySkuResponse> groupBuyActivitySkuResponseList = new ArrayList<GroupBuyActivitySkuResponse>();
            for (GroupBuyActivitySku groupBuyActivitySku : groupBuyActivitySkuListByProductId) {
                GroupBuyActivitySkuResponse skuResponse = new GroupBuyActivitySkuResponse();
                skuResponse.setId(groupBuyActivitySku.getId());
                skuResponse.setGroupActivityId(groupBuyActivitySku.getGroupActivityId());
                skuResponse.setProductId(productId);
                skuResponse.setActivePrice(groupBuyActivitySku.getActivePrice());
                skuResponse.setQuotaShow(groupBuyActivitySku.getQuotaShow());
                skuResponse.setQuota(groupBuyActivitySku.getQuota());
                skuResponse.setSkuId(groupBuyActivitySku.getSkuId());
                groupBuyActivitySkuResponseList.add(skuResponse);
            }
            GroupBuyActivityProductResponse groupBuyActivityProductResponse = new GroupBuyActivityProductResponse();
            groupBuyActivityProductResponse.setProductId(productId);
            groupBuyActivityProductResponse.setGroupBuyActivitySkuResponses(groupBuyActivitySkuResponseList);
            groupBuyActivityProductResponseList.add(groupBuyActivityProductResponse);
        }
        groupBuyActivityResponse.setGroupBuyActivityProductResponseList(groupBuyActivityProductResponseList);
        return groupBuyActivityResponse;
    }

    @Override
    public Boolean groupBuyActivityStatusOnOrOff(Integer groupBuyActivityId, Integer status) {
        GroupBuyActivity groupBuyActivity = (GroupBuyActivity)this.dao.selectById(groupBuyActivityId);
        if (ObjectUtil.isNull((Object)groupBuyActivity)) {
            throw new CrmebException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        groupBuyActivity.setActivityStatus(status);
        groupBuyActivity.setUpdateTime((Date)DateUtil.date());
        return this.dao.updateById(groupBuyActivity) > 0;
    }

    @Override
    public Boolean groupBuyGroupStatusProgress(Integer groupBuyActivityId, Integer groupStatus, String reason) {
        if (ObjectUtil.isNotNull((Object)groupBuyActivityId) && ObjectUtil.isNotNull((Object)groupStatus)) {
            GroupBuyActivity groupBuyActivity = (GroupBuyActivity)this.dao.selectById(groupBuyActivityId);
            if (ObjectUtil.isNull((Object)groupBuyActivity)) {
                throw new CrmebException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            if (groupStatus.equals(GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_REFUSE.getCode()) && ObjectUtil.isEmpty((Object)reason)) {
                throw new CrmebException("\u8bf7\u586b\u5199\u62d2\u7edd\u7406\u7531");
            }
            groupBuyActivity.setRefusal(reason);
            groupBuyActivity.setGroupStatus(groupStatus);
            boolean status = groupStatus.equals(GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_PASS.getCode());
            this.groupBuyActivitySkuService.reviewGroupBuySkuStatus(groupBuyActivityId, status);
            groupBuyActivity.setUpdateTime((Date)DateUtil.date());
            return this.dao.updateById(groupBuyActivity) > 0;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean groupBuyGroupStatusProgressClose(Integer groupBuyActivityId, String reason) {
        if (ObjectUtil.isNotNull((Object)groupBuyActivityId)) {
            GroupBuyActivity groupBuyActivity = (GroupBuyActivity)this.dao.selectById(groupBuyActivityId);
            if (ObjectUtil.isNull((Object)groupBuyActivity)) {
                throw new CrmebException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            }
            groupBuyActivity.setGroupStatus(GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_REFUSE.getCode());
            if (ObjectUtil.isNotEmpty((Object)reason)) {
                groupBuyActivity.setRefusal(reason);
            }
            groupBuyActivity.setUpdateTime((Date)DateUtil.date());
            return this.dao.updateById(groupBuyActivity) > 0;
        }
        return null;
    }

    @Override
    public Boolean deleteGroupBuyActivity(Integer id) {
        GroupBuyActivity activity = (GroupBuyActivity)this.getById(id);
        GroupBuyActivityResponse groupBuyActivityResponse = new GroupBuyActivityResponse();
        BeanUtils.copyProperties((Object)activity, (Object)groupBuyActivityResponse);
        if (groupBuyActivityResponse.getGroupProcess().equals(1)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8fdb\u884c\u4e2d\u7684\u62fc\u56e2\u6d3b\u52a8\u4e0d\u80fd\u5220\u9664");
        }
        GroupBuyActivity groupBuyActivity = new GroupBuyActivity();
        groupBuyActivity.setId(id);
        groupBuyActivity.setIsDel(Integer.valueOf(1));
        groupBuyActivity.setUpdateTime((Date)DateUtil.date());
        return this.dao.updateById(groupBuyActivity) > 0;
    }

    private List<GroupBuyActivity> getListForShopActive(Integer limit) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        Date date = CrmebDateUtil.nowDateTime();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.le(GroupBuyActivity::getStartTime, (Object)date)).gt(GroupBuyActivity::getEndTime, (Object)date)).eq(GroupBuyActivity::getIsDel, (Object)Boolean.FALSE)).eq(GroupBuyActivity::getGroupStatus, (Object)GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_PASS.getCode())).eq(GroupBuyActivity::getActivityStatus, (Object)Boolean.TRUE)).orderByDesc(GroupBuyActivity::getId)).last("limit " + limit);
        return this.dao.selectList((Wrapper)queryWrapper);
    }

    private List<GroupBuyActivity> getListForShopActive(Integer merId, Integer limit) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        Date date = CrmebDateUtil.nowDateTime();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.le(GroupBuyActivity::getStartTime, (Object)date)).gt(GroupBuyActivity::getEndTime, (Object)date)).eq(GroupBuyActivity::getIsDel, (Object)Boolean.FALSE)).eq(GroupBuyActivity::getGroupStatus, (Object)GroupBuyGroupStatusEnum.GROUP_BUY_ENUM_ACTIVITY_STATUS_PASS.getCode())).eq(GroupBuyActivity::getActivityStatus, (Object)Boolean.TRUE)).eq(GroupBuyActivity::getMerId, (Object)merId)).orderByDesc(GroupBuyActivity::getId)).last("limit " + limit);
        return this.dao.selectList((Wrapper)queryWrapper);
    }

    @Override
    public GroupBuyActivityFrontResponse getGroupBuyActivityFrontIndex(Integer limit) {
        GroupBuyActivityFrontResponse response = new GroupBuyActivityFrontResponse();
        List<GroupBuyActivity> groupBuyActivityList = this.getListForShopActive(limit);
        ArrayList<GroupBuyActivityFrontItemResponse> itemResponse = new ArrayList<GroupBuyActivityFrontItemResponse>();
        for (GroupBuyActivity groupBuyActivity : groupBuyActivityList) {
            GroupBuyActivityFrontItemResponse item = new GroupBuyActivityFrontItemResponse();
            BeanUtils.copyProperties((Object)groupBuyActivity, (Object)item);
            GroupBuyActivitySku groupBuyActivitySku = this.groupBuyActivitySkuService.getFrontMinActivePriceByGroupActivityId(groupBuyActivity.getId());
            GroupBuyActivityProductResponse productResponse = new GroupBuyActivityProductResponse();
            if (ObjectUtil.isNotNull((Object)groupBuyActivitySku)) {
                GroupBuyActivitySkuResponse skuResponse = new GroupBuyActivitySkuResponse();
                ArrayList<GroupBuyActivitySkuResponse> skuResponses = new ArrayList<GroupBuyActivitySkuResponse>();
                BeanUtils.copyProperties((Object)groupBuyActivitySku, (Object)skuResponse);
                Product product = (Product)this.productService.getById(groupBuyActivitySku.getProductId());
                ProductAttrValue attrValue = (ProductAttrValue)this.productAttrValueService.getById(groupBuyActivitySku.getSkuId());
                AttrValueResponse attrValueResponse = new AttrValueResponse();
                BeanUtils.copyProperties((Object)attrValue, (Object)attrValueResponse);
                skuResponse.setProductName(product.getName());
                ArrayList<AttrValueResponse> attrValueResponseList = new ArrayList<AttrValueResponse>();
                attrValueResponse.setPrice(attrValue.getPrice());
                attrValueResponseList.add(attrValueResponse);
                skuResponse.setAttrValue(attrValueResponseList);
                skuResponse.setLatestBuyCount(this.groupBuyUserService.getOrderDoneCountByProductIdAndActivityId(groupBuyActivitySku.getProductId(), groupBuyActivity.getId()));
                productResponse.setProductId(groupBuyActivitySku.getProductId());
                productResponse.setProductName(product.getName());
                productResponse.setImage(product.getImage());
                skuResponses.add(skuResponse);
                productResponse.setGroupBuyActivitySkuResponses(skuResponses);
                item.setGroupBuyActivityProductResponse(productResponse);
            }
            item.setGroupBuyActivityProductResponse(productResponse);
            itemResponse.add(item);
        }
        response.setItems(itemResponse);
        response.setTotalAllOrderDone(this.groupBuyUserService.getGroupBuyUserDoneTotalCount());
        List<GroupBuyUser> lastGroupBuyUserList = this.groupBuyUserService.getLastGroupBuyUserList(null, 5);
        List groupDoneUserImages = Collections.emptyList();
        if (!lastGroupBuyUserList.isEmpty()) {
            groupDoneUserImages = lastGroupBuyUserList.stream().map(GroupBuyUser::getGroupAvatar).collect(Collectors.toList());
        }
        response.setOrderDoneUserImages(groupDoneUserImages);
        return response;
    }

    @Override
    public GroupBuyActivityFrontResponse getGroupBuyActivityMerchantFrontIndex(Integer merId, Integer limit) {
        GroupBuyActivityFrontResponse response = new GroupBuyActivityFrontResponse();
        List<GroupBuyActivity> groupBuyActivityList = this.getListForShopActive(merId, limit);
        ArrayList<GroupBuyActivityFrontItemResponse> itemResponse = new ArrayList<GroupBuyActivityFrontItemResponse>();
        for (GroupBuyActivity groupBuyActivity : groupBuyActivityList) {
            GroupBuyActivityFrontItemResponse item = new GroupBuyActivityFrontItemResponse();
            BeanUtils.copyProperties((Object)groupBuyActivity, (Object)item);
            GroupBuyActivitySku groupBuyActivitySku = this.groupBuyActivitySkuService.getFrontMinActivePriceByGroupActivityId(groupBuyActivity.getId());
            GroupBuyActivityProductResponse productResponse = new GroupBuyActivityProductResponse();
            if (ObjectUtil.isNotNull((Object)groupBuyActivitySku)) {
                GroupBuyActivitySkuResponse skuResponse = new GroupBuyActivitySkuResponse();
                ArrayList<GroupBuyActivitySkuResponse> skuResponses = new ArrayList<GroupBuyActivitySkuResponse>();
                BeanUtils.copyProperties((Object)groupBuyActivitySku, (Object)skuResponse);
                Product product = (Product)this.productService.getById(groupBuyActivitySku.getProductId());
                ProductAttrValue attrValue = (ProductAttrValue)this.productAttrValueService.getById(groupBuyActivitySku.getSkuId());
                AttrValueResponse attrValueResponse = new AttrValueResponse();
                BeanUtils.copyProperties((Object)attrValue, (Object)attrValueResponse);
                skuResponse.setProductName(product.getName());
                ArrayList<AttrValueResponse> attrValueResponseList = new ArrayList<AttrValueResponse>();
                attrValueResponse.setPrice(attrValue.getPrice());
                attrValueResponseList.add(attrValueResponse);
                skuResponse.setAttrValue(attrValueResponseList);
                skuResponse.setLatestBuyCount(this.groupBuyUserService.getOrderDoneCountByProductIdAndActivityId(groupBuyActivitySku.getProductId(), groupBuyActivity.getId()));
                productResponse.setProductId(groupBuyActivitySku.getProductId());
                productResponse.setProductName(product.getName());
                productResponse.setImage(product.getImage());
                skuResponses.add(skuResponse);
                productResponse.setGroupBuyActivitySkuResponses(skuResponses);
                item.setGroupBuyActivityProductResponse(productResponse);
            }
            item.setGroupBuyActivityProductResponse(productResponse);
            itemResponse.add(item);
        }
        response.setItems(itemResponse);
        response.setTotalAllOrderDone(this.groupBuyUserService.getGroupBuyUserDoneTotalCount(merId));
        List<GroupBuyUser> lastGroupBuyUserList = this.groupBuyUserService.getLastGroupBuyUserList(null, merId, 5);
        List groupDoneUserImages = Collections.emptyList();
        if (!lastGroupBuyUserList.isEmpty()) {
            groupDoneUserImages = lastGroupBuyUserList.stream().map(GroupBuyUser::getGroupAvatar).collect(Collectors.toList());
        }
        response.setOrderDoneUserImages(groupDoneUserImages);
        return response;
    }

    private void validGroupProduct(List<GroupBuyActivitySku> groupBuySkuList) {
        if (ObjectUtil.isNotEmpty(groupBuySkuList)) {
            for (GroupBuyActivitySku groupBuySku : groupBuySkuList) {
                ProductAttrValue sku = (ProductAttrValue)this.productAttrValueService.getById(groupBuySku.getSkuId());
                if (ObjectUtil.isNull((Object)sku)) {
                    throw new CrmebException("\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (sku.getStock() >= groupBuySku.getQuotaShow()) continue;
                throw new CrmebException("\u5546\u54c1\u5e93\u5b58\u4e0d\u5f97\u5927\u4e8e\u539f\u59cb\u5546\u54c1\u5e93\u5b58");
            }
        }
    }
}

