/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import cn.binarywang.wx.miniapp.bean.urllink.GenerateUrlLinkRequest;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.constants.WeChatConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.WechatExceptions;
import com.zbkj.common.request.SaveConfigRequest;
import com.zbkj.common.response.WeChatJsSdkConfigResponse;
import com.zbkj.common.response.WechatOpenUploadResponse;
import com.zbkj.common.response.WechatPublicShareResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.WechatResultCode;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.common.vo.CommonSeparateConfigVo;
import com.zbkj.common.vo.WeChatMiniAuthorizeVo;
import com.zbkj.common.vo.WeChatOauthToken;
import com.zbkj.common.wxjava.properties.WxOpenProperties;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.WechatExceptionsService;
import com.zbkj.service.service.WechatService;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;
import me.chanjar.weixin.common.enums.TicketType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.material.WxMpMaterial;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.bean.menu.WxMpMenu;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import me.chanjar.weixin.open.api.WxOpenService;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger logger = LoggerFactory.getLogger(WechatServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RestTemplateUtil restTemplateUtil;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private WechatExceptionsService wechatExceptionsService;
    @Autowired
    private WxMaService wxMaService;
    @Autowired
    private WxMpService wxMpService;
    @Autowired
    private WxOpenService wxOpenService;
    @Autowired
    private WxOpenProperties wxOpenProperties;

    @Override
    public WeChatOauthToken getOauth2AccessToken(String code) {
        WxOAuth2AccessToken accessToken;
        try {
            accessToken = this.wxMpService.getOAuth2Service().getAccessToken(code);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01\u5fae\u4fe1\u83b7\u53d6\u5f00\u653e\u5e73\u53f0access_token\u5f02\u5e38!");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01");
        }
        WeChatOauthToken weChatOauthToken = new WeChatOauthToken();
        weChatOauthToken.setAccessToken(accessToken.getAccessToken());
        weChatOauthToken.setExpiresIn(String.valueOf(accessToken.getExpiresIn()));
        weChatOauthToken.setRefreshToken(accessToken.getRefreshToken());
        weChatOauthToken.setOpenId(accessToken.getOpenId());
        weChatOauthToken.setScope(accessToken.getScope());
        return weChatOauthToken;
    }

    @Override
    public WeChatMiniAuthorizeVo miniAuthCode(String code) {
        WxMaJscode2SessionResult jscode2SessionResult;
        try {
            jscode2SessionResult = this.wxMaService.getUserService().getSessionInfo(code);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01");
        }
        WeChatMiniAuthorizeVo miniAuthorizeVo = new WeChatMiniAuthorizeVo();
        miniAuthorizeVo.setOpenId(jscode2SessionResult.getOpenid());
        miniAuthorizeVo.setUnionId(jscode2SessionResult.getUnionid());
        miniAuthorizeVo.setSessionKey(jscode2SessionResult.getSessionKey());
        return miniAuthorizeVo;
    }

    @Override
    public WeChatJsSdkConfigResponse getPublicJsConfig(String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CrmebException("url\u65e0\u6cd5\u89e3\u6790\uff01");
        }
        String appId = this.wxMpService.getWxMpConfigStorage().getAppId();
        if (StrUtil.isBlank((CharSequence)appId)) {
            throw new CrmebException((IResultEnum)WechatResultCode.PUBLIC_APPID_NOT_CONFIG);
        }
        String ticket = this.getJsApiTicket();
        String nonceStr = CrmebUtil.getUuid();
        Long timestamp = DateUtil.currentSeconds();
        String signature = this.getJsSDKSignature(nonceStr, ticket, timestamp, url);
        WeChatJsSdkConfigResponse response = new WeChatJsSdkConfigResponse();
        response.setUrl(url);
        response.setAppId(appId);
        response.setNonceStr(nonceStr);
        response.setTimestamp(timestamp);
        response.setSignature(signature);
        response.setJsApiList(CrmebUtil.stringToArrayStr((String)"editAddress,openAddress,updateTimelineShareData,updateAppMessageShareData,onMenuShareTimeline,onMenuShareAppMessage,onMenuShareQQ,onMenuShareWeibo,onMenuShareQZone,startRecord,stopRecord,onVoiceRecordEnd,playVoice,pauseVoice,stopVoice,onVoicePlayEnd,uploadVoice,downloadVoice,chooseImage,previewImage,uploadImage,downloadImage,translateVoice,getNetworkType,openLocation,getLocation,hideOptionMenu,showOptionMenu,hideMenuItems,showMenuItems,hideAllNonBaseMenuItem,showAllNonBaseMenuItem,closeWindow,scanQRCode,chooseWXPay,openProductSpecificView,addCard,chooseCard,openCard"));
        return response;
    }

    @Override
    public String createQrCode(JSONObject jsonObject) {
        String miniAccessToken = this.getWxMiniAccessToken();
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={}", (Object[])new Object[]{miniAccessToken});
        logger.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7801\u751f\u6210\u53c2\u6570:{}", (Object)jsonObject);
        byte[] bytes = this.restTemplateUtil.postJsonDataAndReturnBuffer(url, jsonObject);
        String response = new String(bytes);
        if (StringUtils.contains((CharSequence)response, (CharSequence)"errcode")) {
            logger.error("\u5fae\u4fe1\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5f02\u5e38" + response);
            JSONObject data = JSONObject.parseObject((String)response);
            this.wxExceptionDispose(data, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5f02\u5e38");
            if (data.getString("errcode").equals("40001")) {
                miniAccessToken = this.getWxMiniAccessToken(true);
                url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={}", (Object[])new Object[]{miniAccessToken});
                bytes = this.restTemplateUtil.postJsonDataAndReturnBuffer(url, jsonObject);
                response = new String(bytes);
                if (StringUtils.contains((CharSequence)response, (CharSequence)"errcode")) {
                    logger.error("\u5fae\u4fe1\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u91cd\u8bd5\u5f02\u5e38" + response);
                    JSONObject data2 = JSONObject.parseObject((String)response);
                    this.wxExceptionDispose(data2, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u91cd\u8bd5\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5f02\u5e38");
                } else {
                    try {
                        return CrmebUtil.getBase64Image((String)Base64.encodeBase64String((byte[])bytes));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7801\u8f6c\u6362Base64\u5f02\u5e38");
                    }
                }
            }
            throw new CrmebException((IResultEnum)WechatResultCode.ROUTINE_CREATE_QRCODE_EXCEPTION, "\u5fae\u4fe1\u751f\u6210\u4e8c\u7ef4\u7801\u5f02\u5e38");
        }
        try {
            return CrmebUtil.getBase64Image((String)Base64.encodeBase64String((byte[])bytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7801\u8f6c\u6362Base64\u5f02\u5e38");
        }
    }

    @Override
    public Boolean sendPublicTemplateMessage(String templateId, String openId, HashMap<String, String> dataMap) {
        WxMpTemplateMessage mpTemplateMessage = WxMpTemplateMessage.builder().toUser(openId).templateId(templateId).build();
        dataMap.forEach((key, value) -> mpTemplateMessage.addData(new WxMpTemplateData(key, value)));
        try {
            this.wxMpService.getTemplateMsgService().sendTemplateMsg(mpTemplateMessage);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5f02\u5e38,templateId={},openId={}", (Object)templateId, (Object)openId);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean sendMiniSubscribeMessage(String templateId, String openId, HashMap<String, String> dataMap) {
        WxMaSubscribeMessage message = new WxMaSubscribeMessage();
        message.setTemplateId(templateId);
        message.setToUser(openId);
        message.setLang("zh_CN");
        message.setMiniprogramState("formal");
        dataMap.forEach((key, value) -> message.addData(new WxMaSubscribeMessage.MsgData(key, value)));
        try {
            this.wxMaService.getMsgService().sendSubscribeMsg(message);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u9001\u8ba2\u9605\u6d88\u606f\u5f02\u5e38,templateId={},openId={}", (Object)templateId, (Object)openId);
        }
        return Boolean.TRUE;
    }

    @Override
    public JSONObject getPublicCustomMenu() {
        JSONObject jsonObject = (JSONObject)this.redisUtil.get("wechat_public_menu_key");
        if (ObjectUtil.isNotNull((Object)jsonObject) && StrUtil.isNotBlank((CharSequence)jsonObject.toString())) {
            return jsonObject;
        }
        try {
            WxMpMenu menu = this.wxMpService.getMenuService().menuGet();
            if (ObjectUtil.isNull((Object)menu)) {
                throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
            }
            String menuJson = menu.toJson();
            jsonObject = JSONObject.parseObject((String)menuJson);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u81ea\u5b9a\u4e49\u83dc\u5355\u914d\u7f6e,\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u81ea\u5b9a\u4e49\u83dc\u5355\u914d\u7f6e,\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        this.redisUtil.set("wechat_public_menu_key", (Object)jsonObject);
        return jsonObject;
    }

    @Override
    public Boolean createPublicCustomMenu(String data) {
        String menuId;
        try {
            menuId = this.wxMpService.getMenuService().menuCreate(data);
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7\u521b\u5efa\u81ea\u5b9a\u4e49\u83dc\u5355\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7\u521b\u5efa\u81ea\u5b9a\u4e49\u83dc\u5355\u5f02\u5e38\uff01");
        }
        if (StrUtil.isNotBlank((CharSequence)menuId)) {
            throw new CrmebException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (this.redisUtil.exists("wechat_public_menu_key").booleanValue()) {
            this.redisUtil.delete(new String[]{"wechat_public_menu_key"});
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean deletePublicCustomMenu() {
        try {
            this.wxMpService.getMenuService().menuDelete();
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u516c\u4f17\u53f7\u5220\u9664\u81ea\u5b9a\u4e49\u83dc\u5355\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u53f7\u5220\u9664\u81ea\u5b9a\u4e49\u83dc\u5355\u5f02\u5e38\uff01");
        }
        if (this.redisUtil.exists("wechat_public_menu_key").booleanValue()) {
            this.redisUtil.delete(new String[]{"wechat_public_menu_key"});
        }
        return Boolean.TRUE;
    }

    @Override
    public WechatOpenUploadResponse openMediaUpload(MultipartFile file, String type) {
        WxMpMaterialUploadResult res;
        File tempFile;
        if (StrUtil.isBlank((CharSequence)type)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u7d20\u6750\u7c7b\u578b");
        }
        if (!"image".equals(type) && !"voice".equals(type)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u672a\u77e5\u7684\u7d20\u6750\u7c7b\u578b");
        }
        String[] split = Objects.requireNonNull(file.getOriginalFilename()).split("\\.");
        String suffixName = split[split.length - 1];
        this.isValidPic(file.getSize(), suffixName, type);
        try {
            InputStream inputStream = file.getResource().getInputStream();
            tempFile = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)suffixName);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u8f93\u5165\u6d41\u5931\u8d25");
            throw new CrmebException(e.getMessage());
        }
        WxMpMaterial wxMaterial = new WxMpMaterial();
        wxMaterial.setFile(tempFile);
        wxMaterial.setName(file.getOriginalFilename());
        try {
            res = this.wxMpService.getMaterialService().materialFileUpload(type, wxMaterial);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u516c\u4f17\u5e73\u53f0\u4e0a\u4f20\u7d20\u6750\u5931\u8d25");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u5e73\u53f0\u4e0a\u4f20\u7d20\u6750\u5931\u8d25");
        }
        if (StrUtil.isBlank((CharSequence)res.getMediaId())) {
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u5e73\u53f0\u4e0a\u4f20\u7d20\u6750\u5931\u8d25");
        }
        if (("image".equals(type) || "thumb".equals(type)) && StrUtil.isBlank((CharSequence)res.getUrl())) {
            throw new CrmebException("\u5fae\u4fe1\u516c\u4f17\u5e73\u53f0\u4e0a\u4f20\u7d20\u6750\u5931\u8d25");
        }
        WechatOpenUploadResponse response = new WechatOpenUploadResponse();
        response.setMediaId(res.getMediaId());
        response.setUrl(res.getUrl());
        response.setName(file.getOriginalFilename().replace(suffixName, ""));
        return response;
    }

    @Override
    public WechatPublicShareResponse getPublicShare() {
        WechatPublicShareResponse response = new WechatPublicShareResponse();
        response.setImage(this.systemConfigService.getValueByKey("wechat_share_img"));
        response.setTitle(this.systemConfigService.getValueByKey("wechat_share_title"));
        response.setSynopsis(this.systemConfigService.getValueByKey("wechat_share_synopsis"));
        return response;
    }

    @Override
    public CommonSeparateConfigVo getShippingSwitch() {
        String value = this.systemConfigService.getValueByKey("wechat_routine_shipping_switch");
        CommonSeparateConfigVo vo = new CommonSeparateConfigVo();
        vo.setKey("wechat_routine_shipping_switch");
        vo.setValue(StrUtil.isNotBlank((CharSequence)value) ? value : "0");
        return vo;
    }

    @Override
    public Boolean updateShippingSwitch(SaveConfigRequest request) {
        String value = StrUtil.isNotBlank((CharSequence)request.getValue()) ? request.getValue() : "0";
        return this.systemConfigService.updateOrSaveValueByName("wechat_routine_shipping_switch", value);
    }

    @Override
    public String generateMiniUrlLink(String path, String query, Integer expireInterval, String envVersion) {
        String urlLink;
        GenerateUrlLinkRequest urlLinkRequest = new GenerateUrlLinkRequest();
        urlLinkRequest.setPath(path);
        if (StrUtil.isNotBlank((CharSequence)query)) {
            urlLinkRequest.setQuery(query);
        }
        urlLinkRequest.setExpireType(Integer.valueOf(1));
        urlLinkRequest.setExpireInterval(expireInterval);
        try {
            urlLink = this.wxMaService.getLinkService().generateUrlLink(urlLinkRequest);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u751f\u6210\u52a0\u5bc6URLLink\u5f02\u5e38\uff01");
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u751f\u6210\u52a0\u5bc6URLLink\u5f02\u5e38\uff01");
        }
        return urlLink;
    }

    @Override
    public WxMaPhoneNumberInfo getMiniUserPhoneNumber(String code) {
        WxMaPhoneNumberInfo phoneNumber;
        try {
            phoneNumber = this.wxMaService.getUserService().getPhoneNumber(code);
        }
        catch (WxErrorException e) {
            logger.error("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237\u624b\u673a\u53f7\u5931\u8d25\uff01");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237\u624b\u673a\u53f7\u5931\u8d25\uff01");
        }
        return phoneNumber;
    }

    @Override
    public WeChatOauthToken getOpenOauth2AccessToken(String code) {
        String url = StrUtil.format((CharSequence)"https://api.weixin.qq.com/sns/oauth2/access_token?appid={}&secret={}&code={}&grant_type=authorization_code", (Object[])new Object[]{this.wxOpenProperties.getComponentAppId(), this.wxOpenProperties.getComponentSecret(), code});
        JSONObject data = this.restTemplateUtil.getData(url);
        if (ObjectUtil.isNull((Object)data)) {
            throw new CrmebException("\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        if (data.containsKey((Object)"errcode") && !data.getString("errcode").equals("0") && data.containsKey((Object)"errmsg")) {
            this.wxExceptionDispose(data, "\u5fae\u4fe1\u5f00\u653e\u5e73\u53f0\u83b7\u53d6accessToken\u5f02\u5e38");
            throw new CrmebException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + data.getString("errcode") + data.getString("errmsg"));
        }
        WeChatOauthToken weChatOauthToken = new WeChatOauthToken();
        weChatOauthToken.setAccessToken(data.getString("access_token"));
        weChatOauthToken.setExpiresIn(String.valueOf(data.getInteger("expires_in")));
        weChatOauthToken.setRefreshToken(data.getString("refresh_token"));
        weChatOauthToken.setOpenId(data.getString("openid"));
        weChatOauthToken.setScope(data.getString("scope"));
        return weChatOauthToken;
    }

    @Override
    public String getOpenAppid() {
        return Optional.ofNullable(this.wxOpenService.getWxOpenConfigStorage().getComponentAppId()).orElse("");
    }

    @Override
    public WxMpQrCodeTicket createPublicQrcodeTmpTicket(Integer sceneId, Integer expireSeconds) {
        WxMpQrCodeTicket wxMpQrCodeTicket;
        try {
            wxMpQrCodeTicket = this.wxMpService.getQrcodeService().qrCodeCreateTmpTicket(sceneId.intValue(), expireSeconds);
        }
        catch (WxErrorException e) {
            logger.error("\u751f\u6210\u516c\u4f17\u53f7\u5e26\u53c2\u6570\u4e34\u65f6\u4e8c\u7ef4\u7801\u5931\u8d25\uff01sceneId={}", (Object)sceneId);
            throw new RuntimeException(e);
        }
        return wxMpQrCodeTicket;
    }

    @Override
    public WxMpQrCodeTicket createPublicQrcodeTmpTicket(String sceneStr, Integer expireSeconds) {
        WxMpQrCodeTicket wxMpQrCodeTicket;
        try {
            wxMpQrCodeTicket = this.wxMpService.getQrcodeService().qrCodeCreateTmpTicket(sceneStr, expireSeconds);
        }
        catch (WxErrorException e) {
            logger.error("\u751f\u6210\u516c\u4f17\u53f7\u5e26\u53c2\u6570\u4e34\u65f6\u4e8c\u7ef4\u7801\u5931\u8d25\uff01sceneStr={}", (Object)sceneStr);
            throw new RuntimeException(e);
        }
        return wxMpQrCodeTicket;
    }

    private String getJsSDKSignature(String nonceStr, String ticket, Long timestamp, String url) {
        String paramString = StrUtil.format((CharSequence)"jsapi_ticket={}&noncestr={}&timestamp={}&url={}", (Object[])new Object[]{ticket, nonceStr, timestamp, url});
        return SecureUtil.sha1((String)paramString);
    }

    private String getJsApiTicket() {
        String ticket;
        boolean exists = this.redisUtil.exists("wechat_js_api_ticket");
        if (exists) {
            Object ticket2 = this.redisUtil.get("wechat_js_api_ticket");
            return ticket2.toString();
        }
        try {
            ticket = this.wxMpService.getTicket(TicketType.JSAPI);
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u83b7\u53d6JS-SDK\u7684ticket\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u5fae\u4fe1\u83b7\u53d6JS-SDK\u7684ticket\u5931\u8d25");
        }
        this.redisUtil.set("wechat_js_api_ticket", (Object)ticket, WeChatConstants.REDIS_PUBLIC_JS_API_TICKET_EXPRESS, TimeUnit.SECONDS);
        return ticket;
    }

    private void wxExceptionDispose(JSONObject jsonObject, String remark) {
        WechatExceptions wechatExceptions = new WechatExceptions();
        wechatExceptions.setErrcode(jsonObject.getString("errcode"));
        wechatExceptions.setErrmsg(StrUtil.isNotBlank((CharSequence)jsonObject.getString("errmsg")) ? jsonObject.getString("errmsg") : "");
        wechatExceptions.setData(jsonObject.toJSONString());
        wechatExceptions.setRemark(remark);
        wechatExceptions.setCreateTime((Date)DateUtil.date());
        wechatExceptions.setUpdateTime((Date)DateUtil.date());
        this.wechatExceptionsService.save(wechatExceptions);
    }

    private void isValidPic(long size, String suffixName, String type) {
        JSONObject config = this.getMediaUploadConfig();
        long supportSize = config.getJSONObject(type).getLong("size");
        if (supportSize < size) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7" + supportSize);
        }
        String supportNameSuffix = config.getJSONObject(type).getString("suffix");
        List suffixNameList = CrmebUtil.stringToArrayStr((String)supportNameSuffix);
        if (!suffixNameList.contains(suffixName)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6587\u4ef6\u683c\u5f0f\u5fc5\u987b\u662f" + supportSize);
        }
    }

    private JSONObject getMediaUploadConfig() {
        String data = StrUtil.format((CharSequence)"{image:{size:\"{}\", suffix: \"{}\"}, voice:{size:\"{}\", suffix: \"{}\"}}", (Object[])new Object[]{WeChatConstants.OPEN_MEDIA_UPLOAD_IMAGE_MAX_SIZE, "bmp,png,jpeg,jpg,gif", WeChatConstants.OPEN_MEDIA_UPLOAD_VOICE_MAX_SIZE, "mp3,wma,wav,amr"});
        return JSONObject.parseObject((String)data);
    }

    private String getWxMiniAccessToken() {
        String accessToken;
        try {
            accessToken = this.wxMaService.getAccessToken();
        }
        catch (WxErrorException e) {
            logger.error("\u83b7\u53d6\u5fae\u4fe1accessToken\u5931\u8d25\uff01");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u83b7\u53d6\u5fae\u4fe1accessToken\u5931\u8d25\uff01");
        }
        return accessToken;
    }

    private String getWxMiniAccessToken(Boolean forceRefresh) {
        String accessToken;
        try {
            accessToken = this.wxMaService.getAccessToken(forceRefresh.booleanValue());
        }
        catch (WxErrorException e) {
            logger.error("\u83b7\u53d6\u5fae\u4fe1accessToken\u5931\u8d25\uff01");
            logger.error(e.getMessage(), (Throwable)e);
            throw new CrmebException("\u83b7\u53d6\u5fae\u4fe1accessToken\u5931\u8d25\uff01");
        }
        return accessToken;
    }
}

