/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.service.dao.UserTokenDao;
import com.zbkj.service.service.UserTokenService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserTokenServiceImpl
extends ServiceImpl<UserTokenDao, UserToken>
implements UserTokenService {
    @Resource
    private UserTokenDao dao;

    @Override
    public UserToken getByOpenidAndType(String token, Integer type) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lqw.eq(UserToken::getType, (Object)type)).eq(UserToken::getToken, (Object)token);
        lqw.eq(UserToken::getIsDel, (Object)0);
        lqw.last(" limit 1");
        return (UserToken)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public void bind(String token, Integer type, Integer userId) {
        UserToken userToken = new UserToken();
        userToken.setToken(token);
        userToken.setType(type);
        userToken.setUid(userId);
        this.save(userToken);
    }

    @Override
    public UserToken getTokenByUserId(Integer userId, Integer type) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lqw.eq(UserToken::getUid, (Object)userId)).eq(UserToken::getType, (Object)type);
        lqw.eq(UserToken::getIsDel, (Object)0);
        lqw.last(" limit 1");
        return (UserToken)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Boolean deleteByUid(Integer uid) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(UserToken::getIsDel, (Object)1);
        wrapper.set(UserToken::getExpiresTime, (Object)DateUtil.date());
        wrapper.eq(UserToken::getUid, (Object)uid);
        wrapper.eq(UserToken::getIsDel, (Object)0);
        return this.update((Wrapper)wrapper);
    }
}

