/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.sgin.UserSignRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SignRecordSearchRequest;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.request.UserRecordSearchRequest;
import com.zbkj.common.response.UserSignRecordResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.UserSignRecordDao;
import com.zbkj.service.service.UserSignRecordService;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserSignRecordServiceImpl
extends ServiceImpl<UserSignRecordDao, UserSignRecord>
implements UserSignRecordService {
    @Resource
    private UserSignRecordDao dao;
    @Autowired
    private CrmebConfig crmebConfig;

    @Override
    public PageInfo<UserSignRecordResponse> pageRecordList(SignRecordSearchRequest request) {
        List<UserSignRecordResponse> responseList;
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (CollUtil.isNotEmpty(responseList = this.dao.pageRecordList(map)) && this.crmebConfig.getPhoneMaskSwitch().booleanValue()) {
            responseList.forEach(e -> e.setPhone(CrmebUtil.maskMobile((String)e.getPhone())));
        }
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public UserSignRecord getLastByUid(Integer uid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserSignRecord::getUid, (Object)uid);
        lqw.orderByDesc(UserSignRecord::getCreateTime);
        lqw.last(" limit 1");
        return (UserSignRecord)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<UserSignRecord> findByMonth(Integer uid, String month) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"uid", (Object)uid);
        query.apply("date_format(create_time, '%Y-%m') = {0}", new Object[]{month});
        return this.dao.selectList((Wrapper)query);
    }

    @Override
    public PageInfo<UserSignRecord> findPageByUid(Integer uid, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserSignRecord::getUid, (Object)uid);
        lqw.orderByDesc(UserSignRecord::getId);
        List recordList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)recordList);
    }

    @Override
    public PageInfo<UserSignRecord> getAdminUserSignRecord(UserRecordSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserSignRecord::getUid, (Object)request.getUserId());
        lqw.orderByDesc(UserSignRecord::getId);
        List recordList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)recordList);
    }
}

