/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.user.UserExperienceRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserRecordSearchRequest;
import com.zbkj.service.dao.UserExperienceRecordDao;
import com.zbkj.service.service.UserExperienceRecordService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserExperienceRecordServiceImpl
extends ServiceImpl<UserExperienceRecordDao, UserExperienceRecord>
implements UserExperienceRecordService {
    @Resource
    private UserExperienceRecordDao dao;

    @Override
    @Deprecated
    public List<UserExperienceRecord> getH5List(Integer userId, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{UserExperienceRecord::getId, UserExperienceRecord::getTitle, UserExperienceRecord::getType, UserExperienceRecord::getExperience, UserExperienceRecord::getCreateTime});
        lqw.eq(UserExperienceRecord::getUid, (Object)userId);
        lqw.orderByDesc(UserExperienceRecord::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getCountByNoteToday(Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{UserExperienceRecord::getId});
        lqw.eq(UserExperienceRecord::getUid, (Object)userId);
        lqw.eq(UserExperienceRecord::getLinkType, (Object)"note");
        lqw.apply(" date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{DateUtil.date().toDateStr()});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean isExistNote(Integer userId, Integer noteId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{UserExperienceRecord::getId});
        lqw.eq(UserExperienceRecord::getLinkId, (Object)noteId.toString());
        lqw.eq(UserExperienceRecord::getUid, (Object)userId);
        lqw.eq(UserExperienceRecord::getLinkType, (Object)"note");
        UserExperienceRecord record = (UserExperienceRecord)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)record) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public PageInfo<UserExperienceRecord> getH5List_V1_2(Integer userId, String linkType, PageParamRequest pageRequest) {
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{UserExperienceRecord::getId, UserExperienceRecord::getTitle, UserExperienceRecord::getType, UserExperienceRecord::getExperience, UserExperienceRecord::getCreateTime});
        lqw.eq(UserExperienceRecord::getUid, (Object)userId);
        if (StrUtil.isNotBlank((CharSequence)linkType)) {
            lqw.eq(UserExperienceRecord::getLinkType, (Object)linkType);
        }
        lqw.orderByDesc(UserExperienceRecord::getId);
        List list = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)list);
    }

    @Override
    public Integer getCountByDate(Integer userId, String date) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(sum(experience),0) as experience"});
        queryWrapper.eq((Object)"uid", (Object)userId);
        queryWrapper.apply(" date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        UserExperienceRecord record = (UserExperienceRecord)this.dao.selectOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNull((Object)record)) {
            return 0;
        }
        return record.getExperience();
    }

    @Override
    public Integer getNoteNumRecordByDate(Integer userId, String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{UserExperienceRecord::getId});
        lqw.eq(UserExperienceRecord::getUid, (Object)userId);
        lqw.eq(UserExperienceRecord::getLinkType, (Object)"note");
        lqw.last(StrUtil.format((CharSequence)" and date_format(create_time, '%Y-%m-%d') = '{}'", (Object[])new Object[]{date}));
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public PageInfo<UserExperienceRecord> getAdminUserBrokerageRecord(UserRecordSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(UserExperienceRecord::getUid, (Object)request.getUserId());
        lqw.orderByDesc(UserExperienceRecord::getId);
        List recordList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)recordList);
    }
}

