/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bill.MerchantDailyStatement;
import com.zbkj.common.model.bill.MerchantMonthStatement;
import com.zbkj.common.model.bill.PlatformDailyStatement;
import com.zbkj.common.model.bill.PlatformMonthStatement;
import com.zbkj.common.model.bill.SummaryFinancialStatements;
import com.zbkj.common.model.closing.MerchantClosingRecord;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderProfitSharing;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.record.MerchantDayRecord;
import com.zbkj.common.model.record.ProductDayRecord;
import com.zbkj.common.model.record.ShoppingProductDayRecord;
import com.zbkj.common.model.record.TradingDayRecord;
import com.zbkj.common.model.user.UserClosing;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.service.service.MerchantClosingRecordService;
import com.zbkj.service.service.MerchantDailyStatementService;
import com.zbkj.service.service.MerchantDayRecordService;
import com.zbkj.service.service.MerchantMonthStatementService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderProfitSharingService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.PlatformDailyStatementService;
import com.zbkj.service.service.PlatformMonthStatementService;
import com.zbkj.service.service.ProductDayRecordService;
import com.zbkj.service.service.ProductRelationService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.ShoppingProductDayRecordService;
import com.zbkj.service.service.StatisticsTaskService;
import com.zbkj.service.service.SummaryFinancialStatementsService;
import com.zbkj.service.service.TradingDayRecordService;
import com.zbkj.service.service.UserClosingService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class StatisticsTaskServiceImpl
implements StatisticsTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsTaskServiceImpl.class);
    @Autowired
    private ShoppingProductDayRecordService shoppingProductDayRecordService;
    @Autowired
    private ProductDayRecordService productDayRecordService;
    @Autowired
    private TradingDayRecordService tradingDayRecordService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductRelationService productRelationService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private PlatformDailyStatementService platformDailyStatementService;
    @Autowired
    private PlatformMonthStatementService platformMonthStatementService;
    @Autowired
    private MerchantDailyStatementService merchantDailyStatementService;
    @Autowired
    private MerchantMonthStatementService merchantMonthStatementService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderProfitSharingService orderProfitSharingService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private RechargeOrderService rechargeOrderService;
    @Autowired
    private MerchantDayRecordService merchantDayRecordService;
    @Autowired
    private SummaryFinancialStatementsService summaryFinancialStatementsService;
    @Autowired
    private MerchantClosingRecordService merchantClosingRecordService;
    @Autowired
    private UserClosingService userClosingService;

    @Override
    public void autoStatistics() {
        Boolean execute;
        String yesterdayStr = DateUtil.yesterday().toString("yyyy-MM-dd");
        Integer newProductNum = this.productService.getNewProductByDate(yesterdayStr);
        int pageViewNum = 0;
        Object pageViewObject = this.redisUtil.get("statistics:product:page_view:" + yesterdayStr);
        if (ObjectUtil.isNotNull((Object)pageViewObject)) {
            pageViewNum = (Integer)pageViewObject;
        }
        Integer collectNum = this.productRelationService.getCountByDate(yesterdayStr);
        int addCartNum = 0;
        Object addCartObject = this.redisUtil.get("statistics:product:add_cart:" + yesterdayStr);
        if (ObjectUtil.isNotNull((Object)addCartObject)) {
            addCartNum = (Integer)addCartObject;
        }
        Integer orderProductNum = this.orderService.getOrderProductNumByDate(yesterdayStr);
        Integer orderSuccessProductNum = this.orderService.getOrderSuccessProductNumByDate(yesterdayStr);
        ShoppingProductDayRecord shoppingProductDayRecord = new ShoppingProductDayRecord();
        shoppingProductDayRecord.setDate(yesterdayStr);
        shoppingProductDayRecord.setAddProductNum(newProductNum);
        shoppingProductDayRecord.setPageView(Integer.valueOf(pageViewNum));
        shoppingProductDayRecord.setCollectNum(collectNum);
        shoppingProductDayRecord.setAddCartNum(Integer.valueOf(addCartNum));
        shoppingProductDayRecord.setOrderProductNum(orderProductNum);
        shoppingProductDayRecord.setOrderSuccessProductNum(orderSuccessProductNum);
        List<Product> allProduct = this.productService.findAllProductByNotDelete();
        List<ProductDayRecord> productDayRecordList = allProduct.stream().map(e -> {
            ProductDayRecord productDayRecord = new ProductDayRecord();
            productDayRecord.setProductId(e.getId());
            productDayRecord.setMerId(e.getMerId());
            productDayRecord.setDate(yesterdayStr);
            return productDayRecord;
        }).collect(Collectors.toList());
        ArrayList<String> redisKeyList = new ArrayList<String>();
        productDayRecordList.forEach(e -> {
            int pageViewDetailNum = 0;
            Object pageViewObject1 = this.redisUtil.get(StrUtil.format((CharSequence)"statistics:product:pro_page_view:{}:{}", (Object[])new Object[]{yesterdayStr, e.getProductId()}));
            if (ObjectUtil.isNotNull((Object)pageViewObject1)) {
                pageViewDetailNum = (Integer)pageViewObject1;
                redisKeyList.add(StrUtil.format((CharSequence)"statistics:product:pro_page_view:{}:{}", (Object[])new Object[]{yesterdayStr, e.getProductId()}));
            }
            e.setPageView(Integer.valueOf(pageViewDetailNum));
            Integer collectDetailNum = this.productRelationService.getCountByDateAndProId(yesterdayStr, e.getProductId());
            e.setCollectNum(collectDetailNum);
            int addCartDetailNum = 0;
            Object addCartObject1 = this.redisUtil.get(StrUtil.format((CharSequence)"statistics:product:pro_add_cart:{}:{}", (Object[])new Object[]{yesterdayStr, e.getProductId()}));
            if (ObjectUtil.isNotNull((Object)addCartObject1)) {
                addCartDetailNum = (Integer)addCartObject1;
                redisKeyList.add(StrUtil.format((CharSequence)"statistics:product:pro_add_cart:{}:{}", (Object[])new Object[]{yesterdayStr, e.getProductId()}));
            }
            e.setAddCartNum(Integer.valueOf(addCartDetailNum));
            e.setOrderProductNum(this.orderDetailService.getSalesNumByDateAndProductId(yesterdayStr, e.getProductId()));
            e.setOrderSuccessProductFee(this.orderDetailService.getSalesByDateAndProductId(yesterdayStr, e.getProductId()));
        });
        Integer orderNum = this.orderService.getOrderNumByDate(0, yesterdayStr);
        Integer payOrderNum = this.orderService.getPayOrderNumByDate(yesterdayStr);
        BigDecimal payOrderAmount = this.orderService.getPayOrderAmountByDate(0, yesterdayStr);
        Integer refundOrderNum = this.refundOrderService.getRefundOrderNumByDate(yesterdayStr);
        BigDecimal refundOrderAmount = this.refundOrderService.getRefundOrderAmountByDate(yesterdayStr);
        TradingDayRecord tradingDayRecord = new TradingDayRecord();
        tradingDayRecord.setDate(yesterdayStr);
        tradingDayRecord.setProductOrderNum(orderNum);
        tradingDayRecord.setProductOrderPayNum(payOrderNum);
        tradingDayRecord.setProductOrderPayFee(payOrderAmount);
        tradingDayRecord.setProductOrderRefundNum(refundOrderNum);
        tradingDayRecord.setProductOrderRefundFee(refundOrderAmount);
        List<Merchant> merchantList = this.merchantService.all();
        ArrayList merchantDayRecordList = CollUtil.newArrayList((Object[])new MerchantDayRecord[0]);
        if (CollUtil.isNotEmpty(merchantList)) {
            for (Merchant merchant : merchantList) {
                MerchantDayRecord merchantDayRecord = new MerchantDayRecord();
                merchantDayRecord.setMerId(merchant.getId());
                merchantDayRecord.setDate(yesterdayStr);
                int merchantVisitors = 0;
                Object visitorsObject = this.redisUtil.get(StrUtil.format((CharSequence)"statistics:merchant:visitors:{}:{}", (Object[])new Object[]{yesterdayStr, merchant.getId()}));
                if (ObjectUtil.isNotNull((Object)visitorsObject)) {
                    merchantVisitors = (Integer)visitorsObject;
                    redisKeyList.add(StrUtil.format((CharSequence)"statistics:merchant:visitors:{}:{}", (Object[])new Object[]{yesterdayStr, merchant.getId()}));
                }
                merchantDayRecord.setVisitors(Integer.valueOf(merchantVisitors));
                merchantDayRecordList.add(merchantDayRecord);
            }
        }
        if (!(execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.shoppingProductDayRecordService.save(shoppingProductDayRecord);
            this.tradingDayRecordService.save(tradingDayRecord);
            if (CollUtil.isNotEmpty((Collection)productDayRecordList)) {
                this.productDayRecordService.saveBatch(productDayRecordList, 100);
            }
            if (CollUtil.isNotEmpty((Collection)merchantDayRecordList)) {
                this.merchantDayRecordService.saveBatch(merchantDayRecordList, 100);
            }
            return Boolean.TRUE;
        })).booleanValue()) {
            LOGGER.error("\u6bcf\u65e5\u7edf\u8ba1\u4efb\u52a1\u4fdd\u5b58\u6570\u636e\u5e93\u5931\u8d25");
            throw new CrmebException("\u6bcf\u65e5\u7edf\u8ba1\u4efb\u52a1\u4fdd\u5b58\u6570\u636e\u5e93\u5931\u8d25");
        }
        this.redisUtil.delete(new String[]{"statistics:product:page_view:" + yesterdayStr});
        this.redisUtil.delete(new String[]{"statistics:product:add_cart:" + yesterdayStr});
        if (CollUtil.isNotEmpty(redisKeyList)) {
            redisKeyList.forEach(redisKey -> this.redisUtil.delete(new String[]{redisKey}));
        }
    }

    @Override
    public void dailyStatement() {
        List<Integer> merIdList = this.merchantService.getAllId();
        MyRecord record = this.writeDailyStatement();
        Integer status = record.getInt("status");
        if (status.equals(0)) {
            Boolean init = this.initDailyStatement(merIdList);
            if (!init.booleanValue()) {
                LOGGER.error("\u6bcf\u65e5\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u521d\u59cb\u5316\u5f53\u5929\u6570\u636e,\u89e6\u53d1\u56de\u6eda");
            }
            return;
        }
        PlatformDailyStatement platformDailyStatement = (PlatformDailyStatement)record.get("platformDailyStatement");
        Integer listSize = record.getInt("listSize");
        this.transactionTemplate.execute(e -> {
            List merchantDailyStatementList;
            boolean update = this.platformDailyStatementService.updateById(platformDailyStatement);
            if (!update) {
                LOGGER.error("\u6bcf\u65e5\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u66f4\u65b0\u5e73\u53f0\u65e5\u5e10\u5355\u5931\u8d25,\u89e6\u53d1\u56de\u6eda");
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (listSize > 0 && !(update = this.merchantDailyStatementService.updateBatchById(merchantDailyStatementList = (List)record.get("merchantDailyStatementList"), 100))) {
                LOGGER.error("\u6bcf\u65e5\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u6279\u91cf\u66f4\u65b0\u5546\u6237\u65e5\u5e10\u5355\u5931\u8d25,\u89e6\u53d1\u56de\u6eda");
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            update = this.initDailyStatement(merIdList);
            if (!update) {
                LOGGER.error("\u6bcf\u65e5\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u521d\u59cb\u5316\u5f53\u5929\u6570\u636e,\u89e6\u53d1\u56de\u6eda");
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public void monthStatement() {
        String lastMonth = DateUtil.lastMonth().toString("yyyy-MM");
        PlatformMonthStatement platformMonthStatement = this.platformMonthStatementService.getByMonth(lastMonth);
        List<Object> merchantMonthStatementList = CollUtil.newArrayList((Object[])new MerchantMonthStatement[0]);
        List<Integer> merIdList = this.merchantService.getAllId();
        if (ObjectUtil.isNull((Object)platformMonthStatement)) {
            PlatformMonthStatement finalPlatformMonthStatement;
            Boolean execute;
            LOGGER.error("\u6bcf\u6708\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1\uff0c\u672a\u67e5\u8be2\u5230\u4e0a\u4e00\u4e2a\u6708\u7684\u6570\u636e,\u73b0\u5728\u5f00\u59cb\u521d\u59cb\u5316\u4e0a\u4e2a\u6708\u6570\u636e");
            platformMonthStatement = new PlatformMonthStatement();
            platformMonthStatement.setDataDate(lastMonth);
            merchantMonthStatementList = this.merchantMonthStatementService.findByMonth(lastMonth);
            ArrayList tempMerchantMonthStatementList = CollUtil.newArrayList((Object[])new MerchantMonthStatement[0]);
            if (CollUtil.isNotEmpty((Collection)merchantMonthStatementList)) {
                if (merIdList.size() != merchantMonthStatementList.size()) {
                    List staMerIdList = merchantMonthStatementList.stream().map(MerchantMonthStatement::getMerId).collect(Collectors.toList());
                    for (Integer merId2 : merIdList) {
                        if (staMerIdList.contains(merId2)) continue;
                        MerchantMonthStatement merchantMonthStatement = new MerchantMonthStatement();
                        merchantMonthStatement.setMerId(merId2);
                        merchantMonthStatement.setDataDate(lastMonth);
                        tempMerchantMonthStatementList.add(merchantMonthStatement);
                    }
                }
            } else {
                merIdList.forEach(merId -> {
                    MerchantMonthStatement merchantMonthStatement = new MerchantMonthStatement();
                    merchantMonthStatement.setMerId(merId);
                    merchantMonthStatement.setDataDate(lastMonth);
                    tempMerchantMonthStatementList.add(merchantMonthStatement);
                });
            }
            if (!(execute = (Boolean)this.transactionTemplate.execute(arg_0 -> this.lambda$monthStatement$6(finalPlatformMonthStatement = platformMonthStatement, tempMerchantMonthStatementList, arg_0))).booleanValue()) {
                LOGGER.error("\u6bcf\u6708\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u56e0\u6ca1\u6709\u4e0a\u4e2a\u6708\u6570\u636e\uff0c\u521d\u59cb\u5316\u4e0a\u4e2a\u6708\u6570\u636e\u65f6\u5931\u8d25");
                return;
            }
            platformMonthStatement.setId(finalPlatformMonthStatement.getId());
            if (CollUtil.isNotEmpty((Collection)tempMerchantMonthStatementList)) {
                merchantMonthStatementList.addAll(tempMerchantMonthStatementList);
            }
        } else {
            merchantMonthStatementList = this.merchantMonthStatementService.findByMonth(lastMonth);
        }
        this.writePlatformMonthStatement(platformMonthStatement);
        this.writeMerchantMonthStatement((List<MerchantMonthStatement>)merchantMonthStatementList, lastMonth);
        PlatformMonthStatement finalTempPlatformMonthStatement = platformMonthStatement;
        List<Object> finalMerchantMonthStatementList = merchantMonthStatementList;
        this.transactionTemplate.execute(e -> {
            boolean save = this.platformMonthStatementService.updateById(finalTempPlatformMonthStatement);
            if (!save) {
                LOGGER.error("\u6bcf\u6708\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u66f4\u65b0\u5e73\u53f0\u6708\u5e10\u5355\u5931\u8d25,\u89e6\u53d1\u56de\u6eda");
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            save = this.merchantMonthStatementService.updateBatchById(finalMerchantMonthStatementList, 100);
            if (!save) {
                LOGGER.error("\u6bcf\u6708\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u66f4\u65b0\u5546\u6237\u6708\u5e10\u5355\u5931\u8d25,\u89e6\u53d1\u56de\u6eda");
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            save = this.initMonthStatement(merIdList);
            if (!save) {
                LOGGER.error("\u6bcf\u6708\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u521d\u59cb\u5316\u5e73\u53f0\u5f53\u6708\u5e10\u5355\u5931\u8d25,\u89e6\u53d1\u56de\u6eda");
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public void dailySummaryFinancialStatement() {
        String yesterday = DateUtil.yesterday().toDateStr();
        SummaryFinancialStatements summaryFinancialStatements = this.summaryFinancialStatementsService.getByDate(yesterday);
        if (ObjectUtil.isNull((Object)summaryFinancialStatements)) {
            summaryFinancialStatements = new SummaryFinancialStatements();
            summaryFinancialStatements.setDataDate(DateUtil.date().toDateStr());
            boolean save = this.summaryFinancialStatementsService.save(summaryFinancialStatements);
            if (!save) {
                LOGGER.error("\u6bcf\u65e5\u8d22\u52a1\u6d41\u6c34\u5b9a\u65f6\u4efb\u52a1,\u521d\u59cb\u5316\u5f53\u5929\u6570\u636e\u5931\u8d25");
            }
            return;
        }
        List<Order> orderList = this.orderService.findPayByDate(0, yesterday);
        List<RefundOrder> refundOrderList = this.refundOrderService.findByDate(0, yesterday);
        List<RechargeOrder> rechargeOrderList = this.rechargeOrderService.findByDate(yesterday);
        List<MerchantClosingRecord> merchantClosingRecordList = this.merchantClosingRecordService.findByDate(0, yesterday);
        List<UserClosing> userClosingList = this.userClosingService.findByDate(yesterday);
        if (CollUtil.isNotEmpty(rechargeOrderList)) {
            summaryFinancialStatements.setRechargeAmount(rechargeOrderList.stream().map(RechargeOrder::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            summaryFinancialStatements.setRechargeNum(Integer.valueOf(rechargeOrderList.size()));
        }
        if (CollUtil.isNotEmpty(orderList)) {
            summaryFinancialStatements.setWechatPayAmount(orderList.stream().filter(e -> e.getPayType().equals("weixin")).map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            summaryFinancialStatements.setWechatPayNum(Integer.valueOf((int)orderList.stream().filter(e -> e.getPayType().equals("weixin")).count()));
            summaryFinancialStatements.setAliPayAmount(orderList.stream().filter(e -> e.getPayType().equals("alipay")).map(Order::getPayPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            summaryFinancialStatements.setAliPayNum(Integer.valueOf((int)orderList.stream().filter(e -> e.getPayType().equals("alipay")).count()));
        }
        summaryFinancialStatements.setIncomeAmount(summaryFinancialStatements.getRechargeAmount().add(summaryFinancialStatements.getWechatPayAmount()).add(summaryFinancialStatements.getAliPayAmount()));
        if (CollUtil.isNotEmpty(merchantClosingRecordList)) {
            summaryFinancialStatements.setMerchantSplitSettlement(merchantClosingRecordList.stream().map(MerchantClosingRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            summaryFinancialStatements.setMerchantSplitSettlementNum(Integer.valueOf(merchantClosingRecordList.size()));
        }
        if (CollUtil.isNotEmpty(userClosingList)) {
            summaryFinancialStatements.setBrokerageSettlement(userClosingList.stream().map(UserClosing::getClosingPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            summaryFinancialStatements.setBrokerageSettlementNum(Integer.valueOf(userClosingList.size()));
        }
        if (CollUtil.isNotEmpty(rechargeOrderList)) {
            summaryFinancialStatements.setOrderRefundAmount(refundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add));
            summaryFinancialStatements.setOrderRefundNum(Integer.valueOf(refundOrderList.size()));
        }
        summaryFinancialStatements.setPayoutAmount(summaryFinancialStatements.getMerchantSplitSettlement().add(summaryFinancialStatements.getBrokerageSettlement()).add(summaryFinancialStatements.getOrderRefundAmount()));
        summaryFinancialStatements.setIncomeExpenditure(summaryFinancialStatements.getIncomeAmount().subtract(summaryFinancialStatements.getPayoutAmount()));
        boolean update = this.summaryFinancialStatementsService.updateById(summaryFinancialStatements);
        if (!update) {
            LOGGER.error("\u6bcf\u65e5\u8d22\u52a1\u6d41\u6c34\u5b9a\u65f6\u4efb\u52a1,\u66f4\u65b0\u8d22\u52a1\u6d41\u6c34\u5931\u8d25");
            return;
        }
        SummaryFinancialStatements todayStatements = new SummaryFinancialStatements();
        todayStatements.setDataDate(DateUtil.date().toDateStr());
        boolean save = this.summaryFinancialStatementsService.save(todayStatements);
        if (!save) {
            LOGGER.error("\u6bcf\u65e5\u8d22\u52a1\u6d41\u6c34\u5b9a\u65f6\u4efb\u52a1,\u521d\u59cb\u5316\u5f53\u5929\u6570\u636e\u5931\u8d25");
        }
    }

    private Boolean initMonthStatement(List<Integer> merIdList) {
        boolean save;
        String nowMonth = DateUtil.date().toString("yyyy-MM");
        PlatformMonthStatement platformMonthStatement = new PlatformMonthStatement();
        platformMonthStatement.setDataDate(nowMonth);
        if (CollUtil.isEmpty(merIdList)) {
            return this.platformMonthStatementService.save(platformMonthStatement);
        }
        ArrayList merchantMonthStatementList = CollUtil.newArrayList((Object[])new MerchantMonthStatement[0]);
        if (CollUtil.isNotEmpty(merIdList)) {
            merIdList.forEach(merId -> {
                MerchantMonthStatement merchantMonthStatement = new MerchantMonthStatement();
                merchantMonthStatement.setMerId(merId);
                merchantMonthStatement.setDataDate(nowMonth);
                merchantMonthStatementList.add(merchantMonthStatement);
            });
        }
        if (!(save = this.platformMonthStatementService.save(platformMonthStatement))) {
            return save;
        }
        return this.merchantMonthStatementService.saveBatch(merchantMonthStatementList, 100);
    }

    private void writeMerchantMonthStatement(List<MerchantMonthStatement> merchantMonthStatementList, String lastMonth) {
        List<MerchantDailyStatement> merchantDailyStatementList = this.merchantDailyStatementService.findByMonth(lastMonth);
        if (CollUtil.isEmpty(merchantDailyStatementList)) {
            return;
        }
        merchantMonthStatementList.forEach(monthStatement -> {
            List dailyStatementList = merchantDailyStatementList.stream().filter(e -> e.getMerId().equals(monthStatement.getMerId())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(dailyStatementList)) {
                BigDecimal orderIncomeAmount = dailyStatementList.stream().map(MerchantDailyStatement::getOrderIncomeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal orderPayAmount = dailyStatementList.stream().map(MerchantDailyStatement::getOrderPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                int orderNum = dailyStatementList.stream().mapToInt(MerchantDailyStatement::getOrderNum).sum();
                BigDecimal handlingFee = dailyStatementList.stream().map(MerchantDailyStatement::getHandlingFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal payoutAmount = dailyStatementList.stream().map(MerchantDailyStatement::getPayoutAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                int payoutNum = dailyStatementList.stream().mapToInt(MerchantDailyStatement::getPayoutNum).sum();
                BigDecimal refundAmount = dailyStatementList.stream().map(MerchantDailyStatement::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                int refundNum = dailyStatementList.stream().mapToInt(MerchantDailyStatement::getRefundNum).sum();
                BigDecimal incomeExpenditure = dailyStatementList.stream().map(MerchantDailyStatement::getIncomeExpenditure).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal firstBrokerage = dailyStatementList.stream().map(MerchantDailyStatement::getFirstBrokerage).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal secondBrokerage = dailyStatementList.stream().map(MerchantDailyStatement::getSecondBrokerage).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal platCouponPrice = dailyStatementList.stream().map(MerchantDailyStatement::getPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal integralPrice = dailyStatementList.stream().map(MerchantDailyStatement::getIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal brokeragePrice = dailyStatementList.stream().map(MerchantDailyStatement::getBrokeragePrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal orderRefundPrice = dailyStatementList.stream().map(MerchantDailyStatement::getOrderRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundPlatCouponPrice = dailyStatementList.stream().map(MerchantDailyStatement::getRefundPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundIntegralPrice = dailyStatementList.stream().map(MerchantDailyStatement::getRefundIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundHandlingFee = dailyStatementList.stream().map(MerchantDailyStatement::getRefundHandlingFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundBrokeragePrice = dailyStatementList.stream().map(MerchantDailyStatement::getRefundBrokeragePrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundMerchantTransferAmount = dailyStatementList.stream().map(MerchantDailyStatement::getRefundMerchantTransferAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal freightFee = dailyStatementList.stream().map(MerchantDailyStatement::getFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundFreightFee = dailyStatementList.stream().map(MerchantDailyStatement::getRefundFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                monthStatement.setOrderPayAmount(orderPayAmount);
                monthStatement.setOrderNum(Integer.valueOf(orderNum));
                monthStatement.setOrderIncomeAmount(orderIncomeAmount);
                monthStatement.setHandlingFee(handlingFee);
                monthStatement.setFirstBrokerage(firstBrokerage);
                monthStatement.setSecondBrokerage(secondBrokerage);
                monthStatement.setPayoutAmount(payoutAmount);
                monthStatement.setPayoutNum(Integer.valueOf(payoutNum));
                monthStatement.setRefundAmount(refundAmount);
                monthStatement.setRefundNum(Integer.valueOf(refundNum));
                monthStatement.setIncomeExpenditure(incomeExpenditure);
                monthStatement.setPlatCouponPrice(platCouponPrice);
                monthStatement.setIntegralPrice(integralPrice);
                monthStatement.setBrokeragePrice(brokeragePrice);
                monthStatement.setOrderRefundPrice(orderRefundPrice);
                monthStatement.setRefundPlatCouponPrice(refundPlatCouponPrice);
                monthStatement.setRefundIntegralPrice(refundIntegralPrice);
                monthStatement.setRefundHandlingFee(refundHandlingFee);
                monthStatement.setRefundBrokeragePrice(refundBrokeragePrice);
                monthStatement.setRefundMerchantTransferAmount(refundMerchantTransferAmount);
                monthStatement.setFreightFee(freightFee);
                monthStatement.setRefundFreightFee(refundFreightFee);
            }
        });
    }

    private void writePlatformMonthStatement(PlatformMonthStatement platformMonthStatement) {
        List<PlatformDailyStatement> dailyStatementList = this.platformDailyStatementService.findByMonth(platformMonthStatement.getDataDate());
        if (CollUtil.isEmpty(dailyStatementList)) {
            return;
        }
        BigDecimal orderPayAmount = dailyStatementList.stream().map(PlatformDailyStatement::getOrderPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        int totalOrderNum = dailyStatementList.stream().mapToInt(PlatformDailyStatement::getTotalOrderNum).sum();
        BigDecimal handlingFee = dailyStatementList.stream().map(PlatformDailyStatement::getHandlingFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payoutAmount = dailyStatementList.stream().map(PlatformDailyStatement::getPayoutAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        int payoutNum = dailyStatementList.stream().mapToInt(PlatformDailyStatement::getPayoutNum).sum();
        BigDecimal merchantTransferAmount = dailyStatementList.stream().map(PlatformDailyStatement::getMerchantTransferAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        int merchantTransferNum = dailyStatementList.stream().mapToInt(PlatformDailyStatement::getMerchantTransferNum).sum();
        BigDecimal refundAmount = dailyStatementList.stream().map(PlatformDailyStatement::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        int refundNum = dailyStatementList.stream().mapToInt(PlatformDailyStatement::getRefundNum).sum();
        BigDecimal incomeExpenditure = dailyStatementList.stream().map(PlatformDailyStatement::getIncomeExpenditure).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal firstBrokerage = dailyStatementList.stream().map(PlatformDailyStatement::getFirstBrokerage).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal secondBrokerage = dailyStatementList.stream().map(PlatformDailyStatement::getSecondBrokerage).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal integralPrice = dailyStatementList.stream().map(PlatformDailyStatement::getIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundReplaceBrokerage = dailyStatementList.stream().map(PlatformDailyStatement::getRefundReplaceBrokerage).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundReplaceIntegralPrice = dailyStatementList.stream().map(PlatformDailyStatement::getRefundReplaceIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal rechargeAmount = dailyStatementList.stream().map(PlatformDailyStatement::getRechargeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        int rechargeNum = dailyStatementList.stream().mapToInt(PlatformDailyStatement::getRechargeNum).sum();
        BigDecimal platCouponPrice = dailyStatementList.stream().map(PlatformDailyStatement::getPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal brokeragePrice = dailyStatementList.stream().map(PlatformDailyStatement::getBrokeragePrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal orderRefundPrice = dailyStatementList.stream().map(PlatformDailyStatement::getOrderRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundPlatCouponPrice = dailyStatementList.stream().map(PlatformDailyStatement::getRefundPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundHandlingFee = dailyStatementList.stream().map(PlatformDailyStatement::getRefundHandlingFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundBrokeragePrice = dailyStatementList.stream().map(PlatformDailyStatement::getRefundBrokeragePrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundMerchantTransferAmount = dailyStatementList.stream().map(PlatformDailyStatement::getRefundMerchantTransferAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal freightFee = dailyStatementList.stream().map(PlatformDailyStatement::getFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundFreightFee = dailyStatementList.stream().map(PlatformDailyStatement::getRefundFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        platformMonthStatement.setOrderPayAmount(orderPayAmount);
        platformMonthStatement.setTotalOrderNum(Integer.valueOf(totalOrderNum));
        platformMonthStatement.setHandlingFee(handlingFee);
        platformMonthStatement.setMerchantTransferAmount(merchantTransferAmount);
        platformMonthStatement.setMerchantTransferNum(Integer.valueOf(merchantTransferNum));
        platformMonthStatement.setFirstBrokerage(firstBrokerage);
        platformMonthStatement.setSecondBrokerage(secondBrokerage);
        platformMonthStatement.setIntegralPrice(integralPrice);
        platformMonthStatement.setPayoutAmount(payoutAmount);
        platformMonthStatement.setPayoutNum(Integer.valueOf(payoutNum));
        platformMonthStatement.setRefundAmount(refundAmount);
        platformMonthStatement.setRefundReplaceBrokerage(refundReplaceBrokerage);
        platformMonthStatement.setRefundReplaceIntegralPrice(refundReplaceIntegralPrice);
        platformMonthStatement.setRefundNum(Integer.valueOf(refundNum));
        platformMonthStatement.setRechargeAmount(rechargeAmount);
        platformMonthStatement.setRechargeNum(Integer.valueOf(rechargeNum));
        platformMonthStatement.setIncomeExpenditure(incomeExpenditure);
        platformMonthStatement.setPlatCouponPrice(platCouponPrice);
        platformMonthStatement.setBrokeragePrice(brokeragePrice);
        platformMonthStatement.setOrderRefundPrice(orderRefundPrice);
        platformMonthStatement.setRefundPlatCouponPrice(refundPlatCouponPrice);
        platformMonthStatement.setRefundHandlingFee(refundHandlingFee);
        platformMonthStatement.setRefundBrokeragePrice(refundBrokeragePrice);
        platformMonthStatement.setRefundMerchantTransferAmount(refundMerchantTransferAmount);
        platformMonthStatement.setFreightFee(freightFee);
        platformMonthStatement.setRefundFreightFee(refundFreightFee);
    }

    private MyRecord writeDailyStatement() {
        MyRecord myRecord = new MyRecord();
        String yesterday = DateUtil.yesterday().toDateStr();
        PlatformDailyStatement platformDailyStatement = this.platformDailyStatementService.getByDate(yesterday);
        if (ObjectUtil.isNull((Object)platformDailyStatement)) {
            myRecord.set("status", (Object)0);
            return myRecord;
        }
        List<OrderProfitSharing> sharingList = this.orderProfitSharingService.findByDate(0, yesterday);
        List<RefundOrder> refundOrderList = this.refundOrderService.findByDate(0, yesterday);
        List<RechargeOrder> rechargeOrderList = this.rechargeOrderService.findByDate(yesterday);
        this.platformDataWrite(platformDailyStatement, sharingList, refundOrderList, rechargeOrderList);
        myRecord.set("status", (Object)1);
        myRecord.set("platformDailyStatement", (Object)platformDailyStatement);
        List<MerchantDailyStatement> merchantDailyStatementList = this.merchantDailyStatementService.findByDate(yesterday);
        if (CollUtil.isEmpty(merchantDailyStatementList)) {
            myRecord.set("listSize", (Object)0);
            return myRecord;
        }
        this.merchantDataWrite(merchantDailyStatementList, sharingList, refundOrderList);
        myRecord.set("listSize", (Object)merchantDailyStatementList.size());
        myRecord.set("merchantDailyStatementList", merchantDailyStatementList);
        return myRecord;
    }

    private void merchantDataWrite(List<MerchantDailyStatement> merchantDailyStatementList, List<OrderProfitSharing> sharingList, List<RefundOrder> refundOrderList) {
        if (CollUtil.isEmpty(merchantDailyStatementList)) {
            return;
        }
        merchantDailyStatementList.forEach(statement -> {
            List merRefundOrderList;
            List merchantSharingList;
            BigDecimal orderPayAmount = BigDecimal.ZERO;
            int orderNum = 0;
            BigDecimal orderIncomeAmount = BigDecimal.ZERO;
            BigDecimal handlingFee = BigDecimal.ZERO;
            BigDecimal firstBrokerage = BigDecimal.ZERO;
            BigDecimal secondBrokerage = BigDecimal.ZERO;
            BigDecimal refundAmount = BigDecimal.ZERO;
            int refundNum = 0;
            BigDecimal platCouponPrice = BigDecimal.ZERO;
            BigDecimal integralPrice = BigDecimal.ZERO;
            BigDecimal brokeragePrice = BigDecimal.ZERO;
            BigDecimal orderRefundPrice = BigDecimal.ZERO;
            BigDecimal refundPlatCouponPrice = BigDecimal.ZERO;
            BigDecimal refundIntegralPrice = BigDecimal.ZERO;
            BigDecimal refundHandlingFee = BigDecimal.ZERO;
            BigDecimal refundBrokeragePrice = BigDecimal.ZERO;
            BigDecimal refundMerchantTransferAmount = BigDecimal.ZERO;
            BigDecimal freightFee = BigDecimal.ZERO;
            BigDecimal refundFreightFee = BigDecimal.ZERO;
            if (CollUtil.isNotEmpty((Collection)sharingList) && CollUtil.isNotEmpty(merchantSharingList = sharingList.stream().filter(e -> e.getMerId().equals(statement.getMerId())).collect(Collectors.toList()))) {
                orderPayAmount = merchantSharingList.stream().map(OrderProfitSharing::getOrderPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                orderNum = merchantSharingList.size();
                orderIncomeAmount = merchantSharingList.stream().map(OrderProfitSharing::getProfitSharingMerPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                handlingFee = merchantSharingList.stream().map(OrderProfitSharing::getProfitSharingPlatPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                firstBrokerage = merchantSharingList.stream().map(OrderProfitSharing::getFirstBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                secondBrokerage = merchantSharingList.stream().map(OrderProfitSharing::getSecondBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
                platCouponPrice = merchantSharingList.stream().map(OrderProfitSharing::getPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                integralPrice = merchantSharingList.stream().map(OrderProfitSharing::getIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                brokeragePrice = firstBrokerage.add(secondBrokerage);
                freightFee = sharingList.stream().map(OrderProfitSharing::getFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (CollUtil.isNotEmpty((Collection)refundOrderList) && CollUtil.isNotEmpty(merRefundOrderList = refundOrderList.stream().filter(e -> e.getMerId().equals(statement.getMerId())).collect(Collectors.toList()))) {
                refundAmount = merRefundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundNum = merRefundOrderList.size();
                refundMerchantTransferAmount = merRefundOrderList.stream().map(RefundOrder::getMerchantRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundHandlingFee = merRefundOrderList.stream().map(RefundOrder::getPlatformRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundPlatCouponPrice = merRefundOrderList.stream().map(RefundOrder::getRefundPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundBrokeragePrice = merRefundOrderList.stream().map(e -> e.getRefundFirstBrokerageFee().add(e.getRefundSecondBrokerageFee())).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundIntegralPrice = merRefundOrderList.stream().map(RefundOrder::getRefundIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                orderRefundPrice = merRefundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundFreightFee = refundOrderList.stream().map(RefundOrder::getRefundFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            BigDecimal orderReceivable = orderPayAmount.add(platCouponPrice).add(integralPrice);
            BigDecimal orderRefundable = BigDecimal.ZERO.subtract(refundMerchantTransferAmount).subtract(refundHandlingFee).subtract(refundBrokeragePrice);
            BigDecimal orderRefund = orderRefundable.subtract(refundPlatCouponPrice).subtract(refundIntegralPrice);
            BigDecimal platformHandling = handlingFee.subtract(refundHandlingFee);
            BigDecimal brokerage = brokeragePrice.subtract(refundBrokeragePrice);
            BigDecimal income = orderReceivable.add(orderRefundable);
            BigDecimal payout = platformHandling.add(brokerage);
            BigDecimal incomeExpenditure = income.subtract(payout);
            statement.setOrderPayAmount(orderPayAmount);
            statement.setOrderNum(Integer.valueOf(orderNum));
            statement.setOrderIncomeAmount(orderIncomeAmount);
            statement.setHandlingFee(handlingFee);
            statement.setFirstBrokerage(firstBrokerage);
            statement.setSecondBrokerage(secondBrokerage);
            statement.setRefundAmount(refundAmount);
            statement.setRefundNum(Integer.valueOf(refundNum));
            statement.setIncomeExpenditure(incomeExpenditure.abs());
            statement.setPlatCouponPrice(platCouponPrice);
            statement.setIntegralPrice(integralPrice);
            statement.setBrokeragePrice(brokeragePrice);
            statement.setOrderRefundPrice(orderRefundPrice);
            statement.setRefundPlatCouponPrice(refundPlatCouponPrice);
            statement.setRefundIntegralPrice(refundIntegralPrice);
            statement.setRefundHandlingFee(refundHandlingFee);
            statement.setRefundBrokeragePrice(refundBrokeragePrice);
            statement.setRefundMerchantTransferAmount(refundMerchantTransferAmount);
            statement.setFreightFee(freightFee);
            statement.setRefundFreightFee(refundFreightFee);
        });
    }

    private void platformDataWrite(PlatformDailyStatement platformDailyStatement, List<OrderProfitSharing> sharingList, List<RefundOrder> refundOrderList, List<RechargeOrder> rechargeOrderList) {
        BigDecimal orderPayAmount = BigDecimal.ZERO;
        int orderPayNum = 0;
        BigDecimal handlingFee = BigDecimal.ZERO;
        BigDecimal merchantTransferAmount = BigDecimal.ZERO;
        int merchantTransferNum = 0;
        BigDecimal refundAmount = BigDecimal.ZERO;
        BigDecimal refundReplaceBrokerage = BigDecimal.ZERO;
        BigDecimal refundReplaceIntegralPrice = BigDecimal.ZERO;
        int refundOrderNum = 0;
        BigDecimal firstBrokerage = BigDecimal.ZERO;
        BigDecimal secondBrokerage = BigDecimal.ZERO;
        BigDecimal rechargeAmount = BigDecimal.ZERO;
        int rechargeNum = 0;
        BigDecimal integralPrice = BigDecimal.ZERO;
        BigDecimal platCouponPrice = BigDecimal.ZERO;
        BigDecimal brokeragePrice = BigDecimal.ZERO;
        BigDecimal refundPlatCouponPrice = BigDecimal.ZERO;
        BigDecimal refundHandlingFee = BigDecimal.ZERO;
        BigDecimal refundBrokeragePrice = BigDecimal.ZERO;
        BigDecimal refundMerchantTransferAmount = BigDecimal.ZERO;
        BigDecimal freightFee = BigDecimal.ZERO;
        BigDecimal refundFreightFee = BigDecimal.ZERO;
        if (CollUtil.isNotEmpty(sharingList)) {
            orderPayAmount = sharingList.stream().map(OrderProfitSharing::getOrderPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderPayNum = sharingList.size();
            handlingFee = sharingList.stream().map(OrderProfitSharing::getProfitSharingPlatPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            merchantTransferAmount = sharingList.stream().map(OrderProfitSharing::getProfitSharingMerPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            firstBrokerage = sharingList.stream().map(OrderProfitSharing::getFirstBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            secondBrokerage = sharingList.stream().map(OrderProfitSharing::getSecondBrokerageFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            merchantTransferNum = sharingList.size();
            integralPrice = sharingList.stream().map(OrderProfitSharing::getIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            platCouponPrice = sharingList.stream().map(OrderProfitSharing::getPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            brokeragePrice = firstBrokerage.add(secondBrokerage);
            freightFee = sharingList.stream().map(OrderProfitSharing::getFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollUtil.isNotEmpty(refundOrderList)) {
            refundAmount = refundOrderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundReplaceBrokerage = refundOrderList.stream().filter(RefundOrder::getIsReplace).map(e -> e.getRefundFirstBrokerageFee().add(e.getRefundSecondBrokerageFee())).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundReplaceIntegralPrice = refundOrderList.stream().map(RefundOrder::getRefundIntegralPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundOrderNum = refundOrderList.size();
            refundPlatCouponPrice = refundOrderList.stream().map(RefundOrder::getRefundPlatCouponPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundHandlingFee = refundOrderList.stream().map(RefundOrder::getPlatformRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundMerchantTransferAmount = refundOrderList.stream().map(RefundOrder::getMerchantRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundBrokeragePrice = refundOrderList.stream().map(e -> e.getRefundFirstBrokerageFee().add(e.getRefundSecondBrokerageFee())).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundFreightFee = refundOrderList.stream().map(RefundOrder::getRefundFreightFee).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (CollUtil.isNotEmpty(rechargeOrderList)) {
            rechargeNum = rechargeOrderList.size();
            rechargeAmount = rechargeOrderList.stream().map(RechargeOrder::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal orderIncome = orderPayAmount;
        BigDecimal orderReceivable = orderIncome.add(platCouponPrice).add(integralPrice);
        BigDecimal orderRefundable = refundMerchantTransferAmount.add(refundHandlingFee).add(refundBrokeragePrice);
        BigDecimal orderRefund = refundPlatCouponPrice.add(refundReplaceIntegralPrice).subtract(orderRefundable);
        BigDecimal merchantProfitSharing = merchantTransferAmount.subtract(refundMerchantTransferAmount);
        BigDecimal brokerage = brokeragePrice.subtract(refundBrokeragePrice).add(refundReplaceBrokerage);
        BigDecimal income = orderIncome.add(orderRefund);
        BigDecimal payout = merchantProfitSharing.add(brokerage);
        BigDecimal incomeExpenditure = income.subtract(payout);
        platformDailyStatement.setOrderPayAmount(orderPayAmount);
        platformDailyStatement.setTotalOrderNum(Integer.valueOf(orderPayNum));
        platformDailyStatement.setHandlingFee(handlingFee);
        platformDailyStatement.setMerchantTransferAmount(merchantTransferAmount);
        platformDailyStatement.setMerchantTransferNum(Integer.valueOf(merchantTransferNum));
        platformDailyStatement.setFirstBrokerage(firstBrokerage);
        platformDailyStatement.setSecondBrokerage(secondBrokerage);
        platformDailyStatement.setIntegralPrice(integralPrice);
        platformDailyStatement.setRefundAmount(refundAmount);
        platformDailyStatement.setRefundReplaceBrokerage(refundReplaceBrokerage);
        platformDailyStatement.setRefundReplaceIntegralPrice(refundReplaceIntegralPrice);
        platformDailyStatement.setRefundNum(Integer.valueOf(refundOrderNum));
        platformDailyStatement.setRechargeAmount(rechargeAmount);
        platformDailyStatement.setRechargeNum(Integer.valueOf(rechargeNum));
        platformDailyStatement.setIncomeExpenditure(incomeExpenditure.abs());
        platformDailyStatement.setPlatCouponPrice(platCouponPrice);
        platformDailyStatement.setBrokeragePrice(brokeragePrice);
        platformDailyStatement.setOrderRefundPrice(refundAmount);
        platformDailyStatement.setRefundPlatCouponPrice(refundPlatCouponPrice);
        platformDailyStatement.setRefundHandlingFee(refundHandlingFee);
        platformDailyStatement.setRefundBrokeragePrice(refundBrokeragePrice);
        platformDailyStatement.setRefundMerchantTransferAmount(refundMerchantTransferAmount);
        platformDailyStatement.setFreightFee(freightFee);
        platformDailyStatement.setRefundFreightFee(refundFreightFee);
    }

    private Boolean initDailyStatement(List<Integer> merIdList) {
        String today = DateUtil.date().toDateStr();
        PlatformDailyStatement platformDailyStatement = new PlatformDailyStatement();
        platformDailyStatement.setDataDate(today);
        if (CollUtil.isEmpty(merIdList)) {
            return this.platformDailyStatementService.save(platformDailyStatement);
        }
        List merchantDailyStatementList = merIdList.stream().map(merId -> {
            MerchantDailyStatement statement = new MerchantDailyStatement();
            statement.setMerId(merId);
            statement.setDataDate(today);
            return statement;
        }).collect(Collectors.toList());
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean save = this.platformDailyStatementService.save(platformDailyStatement);
            if (!save) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            save = this.merchantDailyStatementService.saveBatch(merchantDailyStatementList, 100);
            if (!save) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    private /* synthetic */ Boolean lambda$monthStatement$6(PlatformMonthStatement finalPlatformMonthStatement, List tempMerchantMonthStatementList, TransactionStatus e) {
        boolean save = this.platformMonthStatementService.save(finalPlatformMonthStatement);
        if (!save) {
            LOGGER.error("\u6bcf\u6708\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u521d\u59cb\u5316\u4e0a\u4e2a\u6708\u5e73\u53f0\u6708\u5e10\u5355\u5931\u8d25,\u89e6\u53d1\u56de\u6eda");
            e.setRollbackOnly();
            return Boolean.FALSE;
        }
        save = this.merchantMonthStatementService.saveBatch(tempMerchantMonthStatementList, 100);
        if (!save) {
            LOGGER.error("\u6bcf\u6708\u5e10\u5355\u5b9a\u65f6\u4efb\u52a1,\u521d\u59cb\u5316\u4e0a\u4e2a\u6708\u5546\u6237\u6708\u5e10\u5355\u5931\u8d25,\u89e6\u53d1\u56de\u6eda");
            e.setRollbackOnly();
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

