/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.product.ProductDescription;
import com.zbkj.common.model.seckill.SeckillActivityTime;
import com.zbkj.common.model.seckill.SeckillProduct;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.SeckillProductSearchRequest;
import com.zbkj.common.response.SeckillProductPageResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.SeckillProductDao;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductDescriptionService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SeckillActivityTimeService;
import com.zbkj.service.service.SeckillProductService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SeckillProductServiceImpl
extends ServiceImpl<SeckillProductDao, SeckillProduct>
implements SeckillProductService {
    @Resource
    private SeckillProductDao dao;
    @Autowired
    private SeckillActivityTimeService seckillActivityTimeService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private ProductDescriptionService productDescriptionService;
    @Autowired
    private ProductService productService;

    @Override
    public Integer getCountByActivityId(Integer activityId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SeckillProduct::getId});
        lqw.eq(SeckillProduct::getActivityId, (Object)activityId);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public List<SeckillProduct> findByActivityId(Integer activityId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SeckillProduct::getActivityId, (Object)activityId);
        lqw.eq(SeckillProduct::getAuditStatus, (Object)2);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        lqw.orderByDesc(SeckillProduct::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<SeckillProductPageResponse> getSeckillProductPage(SeckillProductSearchRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getProName())) {
            map.put("proName", URLUtil.decode((String)request.getProName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getProStatus())) {
            map.put("proStatus", request.getProStatus());
        }
        if (ObjectUtil.isNotNull((Object)request.getActivityStatus())) {
            String activityIdStr;
            List<SeckillActivityTime> activityTimeList;
            String hmStr;
            String dateStr;
            DateTime dateTime;
            if (request.getActivityStatus().equals(1)) {
                dateTime = DateUtil.date();
                dateStr = dateTime.toString("yyyyMMdd");
                hmStr = dateTime.toString("HHmm");
                activityTimeList = this.seckillActivityTimeService.findByActivityStatus(request.getActivityStatus(), Integer.valueOf(dateStr), Integer.valueOf(hmStr));
                if (CollUtil.isEmpty(activityTimeList)) {
                    return null;
                }
                activityIdStr = activityTimeList.stream().map(e -> String.valueOf(e.getSeckillId())).distinct().collect(Collectors.joining(","));
                map.put("activityIdStr", activityIdStr);
            }
            if (request.getActivityStatus().equals(2)) {
                dateTime = DateUtil.date();
                dateStr = dateTime.toString("yyyyMMdd");
                hmStr = dateTime.toString("HHmm");
                activityTimeList = this.seckillActivityTimeService.findByActivityStatus(request.getActivityStatus(), Integer.valueOf(dateStr), Integer.valueOf(hmStr));
                if (CollUtil.isEmpty(activityTimeList)) {
                    return null;
                }
                activityIdStr = activityTimeList.stream().map(e -> String.valueOf(e.getSeckillId())).distinct().collect(Collectors.joining(","));
                map.put("activityIdStr", activityIdStr);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getActivityName())) {
            map.put("activityName", URLUtil.decode((String)request.getActivityName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getMerStars()) && request.getMerStars() > 0) {
            map.put("merStars", request.getMerStars());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getMerIds())) {
            map.put("merIds", request.getMerIds());
        }
        if (ObjectUtil.isNotNull((Object)request.getAuditStatus())) {
            map.put("auditStatus", request.getAuditStatus());
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<SeckillProductPageResponse> productList = this.dao.getSeckillProductPage(map);
        if (CollUtil.isNotEmpty(productList)) {
            this.setActivityStatus(productList);
            productList.forEach(p -> {
                List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(p.getId(), p.getType(), ProductConstants.PRODUCT_MARKETING_TYPE_SECKILL, false);
                this.setShowStatus(attrValueList, p.getProductId(), p.getType());
                p.setAttrValue(attrValueList);
            });
        }
        return CommonPage.copyPageInfo((Page)page, productList);
    }

    private void setShowStatus(List<ProductAttrValue> seckillAttrValueList, Integer masterProductId, Integer type) {
        List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(masterProductId, type, ProductConstants.PRODUCT_MARKETING_TYPE_BASE, false);
        for (ProductAttrValue attrValue : attrValueList) {
            for (ProductAttrValue seckillAttrValue : seckillAttrValueList) {
                if (!seckillAttrValue.getMasterId().equals(attrValue.getId())) continue;
                seckillAttrValue.setIsShow(attrValue.getIsShow());
            }
        }
    }

    @Override
    public Boolean forceDown(String ids) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsShow, (Object)0);
        wrapper.set(SeckillProduct::getAuditStatus, (Object)3);
        wrapper.set(SeckillProduct::getReason, (Object)"\u5e73\u53f0\u5f3a\u5236\u4e0b\u67b6");
        wrapper.in(SeckillProduct::getId, (Collection)CrmebUtil.stringToArray((String)ids));
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean delete(String ids) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsDel, (Object)1);
        wrapper.in(SeckillProduct::getId, (Collection)CrmebUtil.stringToArray((String)ids));
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean up(String ids, Integer merId) {
        List idList = CrmebUtil.stringToArray((String)ids);
        if (CollUtil.isEmpty((Collection)idList)) {
            return Boolean.TRUE;
        }
        List<SeckillProduct> seckillProductList = this.findByIdList(idList);
        if (seckillProductList.size() != idList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u79d2\u6740\u5546\u54c1\u6570\u91cf\u4e0d\u5339\u914d");
        }
        for (SeckillProduct seckillProduct : seckillProductList) {
            if (!seckillProduct.getMerId().equals(merId)) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5305\u542b\u4e0d\u5c5e\u4e8e\u672c\u5e97\u94fa\u7684\u6570\u636e");
            }
            Product product = (Product)this.productService.getById(seckillProduct.getProductId());
            if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) || product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION, "\u57fa\u7840\u5546\u54c1\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u4e0a\u67b6");
            }
            if (!product.getIsAudit().booleanValue()) continue;
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION, "\u57fa\u7840\u5546\u54c1\u5ba1\u6838\u72b6\u6001\u5f02\u5e38\uff0c\u65e0\u6cd5\u4e0a\u67b6");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsShow, (Object)1);
        wrapper.in(SeckillProduct::getId, (Collection)CrmebUtil.stringToArray((String)ids));
        wrapper.eq(SeckillProduct::getMerId, (Object)merId);
        return this.update((Wrapper)wrapper);
    }

    private List<SeckillProduct> findByIdList(List<Integer> idList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(SeckillProduct::getId, idList);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean down(String ids, Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsShow, (Object)0);
        wrapper.in(SeckillProduct::getId, (Collection)CrmebUtil.stringToArray((String)ids));
        wrapper.eq(SeckillProduct::getMerId, (Object)merId);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<SeckillProduct> getIndexList(List<Integer> aidList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SeckillProduct::getId, SeckillProduct::getProductId, SeckillProduct::getName, SeckillProduct::getSeckillPrice, SeckillProduct::getImage, SeckillProduct::getPrice});
        lqw.in(SeckillProduct::getActivityId, aidList);
        lqw.eq(SeckillProduct::getIsShow, (Object)1);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        lqw.eq(SeckillProduct::getAuditStatus, (Object)2);
        lqw.orderByDesc(SeckillProduct::getSort);
        lqw.last(" limit 8");
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<SeckillProduct> getFrontPage(List<Integer> seckillIdList, Integer merId, Integer pageNum, Integer limit) {
        Page page = PageHelper.startPage((int)pageNum, (int)limit);
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SeckillProduct::getId, SeckillProduct::getProductId, SeckillProduct::getName, SeckillProduct::getPrice, SeckillProduct::getImage, SeckillProduct::getSeckillPrice, SeckillProduct::getQuota, SeckillProduct::getQuotaShow, SeckillProduct::getMerId, SeckillProduct::getType});
        lqw.in(SeckillProduct::getActivityId, seckillIdList);
        lqw.eq(SeckillProduct::getIsShow, (Object)1);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        lqw.eq(SeckillProduct::getAuditStatus, (Object)2);
        if (merId > 0) {
            lqw.eq(SeckillProduct::getMerId, (Object)merId);
        }
        lqw.last(" order by sort desc, (quota_show - quota) desc");
        List productList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public SeckillProduct getFrontDetail(Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SeckillProduct::getId, (Object)id);
        lqw.eq(SeckillProduct::getIsShow, (Object)1);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        lqw.eq(SeckillProduct::getAuditStatus, (Object)2);
        lqw.last(" limit 1");
        SeckillProduct seckillProduct = (SeckillProduct)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)seckillProduct)) {
            throw new CrmebException(StrUtil.format((CharSequence)"\u6ca1\u6709\u627e\u5230ID\uff1a {} \u7684\u79d2\u6740\u5546\u54c1", (Object[])new Object[]{id}));
        }
        ProductDescription sd = this.productDescriptionService.getByProductIdAndType(seckillProduct.getProductId(), seckillProduct.getType());
        if (ObjectUtil.isNotNull((Object)sd)) {
            seckillProduct.setContent(StrUtil.isBlank((CharSequence)sd.getDescription()) ? "" : sd.getDescription());
        }
        return seckillProduct;
    }

    @Override
    public Boolean operationStock(Integer id, Integer num, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota + {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales - {}", (Object[])new Object[]{num}));
        }
        if (type.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota - {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)" and (quota - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u79d2\u6740\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u5546\u54c1id = " + id);
        }
        return update;
    }

    @Override
    public Boolean deleteByProductId(Integer masterId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsDel, (Object)1);
        wrapper.eq(SeckillProduct::getProductId, (Object)masterId);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean downByMerId(Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsShow, (Object)0);
        wrapper.eq(SeckillProduct::getMerId, (Object)merId);
        wrapper.eq(SeckillProduct::getIsDel, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean downByProductId(Integer productId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsShow, (Object)0);
        wrapper.eq(SeckillProduct::getProductId, (Object)productId);
        wrapper.eq(SeckillProduct::getIsDel, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean downByProductIdList(List<Integer> productIdList) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsShow, (Object)0);
        wrapper.in(SeckillProduct::getProductId, productIdList);
        wrapper.eq(SeckillProduct::getIsDel, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<SeckillProduct> findRegionHomeProductList(List<Integer> aidList, List<Integer> merIdList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SeckillProduct::getId, SeckillProduct::getProductId, SeckillProduct::getName, SeckillProduct::getSeckillPrice, SeckillProduct::getImage, SeckillProduct::getPrice});
        lqw.in(SeckillProduct::getActivityId, aidList);
        if (CollUtil.isNotEmpty(merIdList)) {
            lqw.in(SeckillProduct::getMerId, merIdList);
        }
        lqw.eq(SeckillProduct::getIsShow, (Object)1);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        lqw.eq(SeckillProduct::getAuditStatus, (Object)2);
        lqw.orderByDesc(SeckillProduct::getSort);
        lqw.last(" limit 8");
        return this.dao.selectList((Wrapper)lqw);
    }

    private void setActivityStatus(List<SeckillProductPageResponse> productList) {
        DateTime dateTime = DateUtil.date();
        String dateStr = dateTime.toString("yyyyMMdd");
        String hmStr = dateTime.toString("HHmm");
        for (SeckillProductPageResponse product : productList) {
            if (product.getActivityStatus().equals(2)) continue;
            Integer activityStatus = this.seckillActivityTimeService.getActivityStatus(product.getActivityId(), Integer.valueOf(dateStr), Integer.valueOf(hmStr));
            product.setActivityStatus(activityStatus);
        }
    }
}

