/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundV3Request;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.BalanceRecordConstants;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.RefundOrderConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.MerchantAddress;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.model.order.RefundOrderInfo;
import com.zbkj.common.model.reservation.ReservationWorkOrder;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBalanceRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.OrderAfterSalesSearchRequest;
import com.zbkj.common.request.OrderRefundAuditRequest;
import com.zbkj.common.request.RefundOrderRemarkRequest;
import com.zbkj.common.request.RefundOrderSearchRequest;
import com.zbkj.common.request.RejectReceivingRequest;
import com.zbkj.common.request.UserCommonSearchRequest;
import com.zbkj.common.response.MerchantRefundOrderPageResponse;
import com.zbkj.common.response.PlatformRefundOrderPageResponse;
import com.zbkj.common.response.RefundOrderAdminDetailResponse;
import com.zbkj.common.response.RefundOrderCountItemResponse;
import com.zbkj.common.response.RefundOrderInfoResponse;
import com.zbkj.common.response.RefundOrderResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.OrderResultCode;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.utils.ValidateFormUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.RefundOrderDetailOrderInfoVo;
import com.zbkj.service.dao.RefundOrderDao;
import com.zbkj.service.service.AliPayService;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.MerchantAddressService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderFlowRecordService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.RefundOrderInfoService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.RefundOrderStatusService;
import com.zbkj.service.service.ReservationWorkOrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserBalanceRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.WechatPayService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class RefundOrderServiceImpl
extends ServiceImpl<RefundOrderDao, RefundOrder>
implements RefundOrderService {
    private static final Logger logger = LoggerFactory.getLogger(RefundOrderServiceImpl.class);
    @Resource
    private RefundOrderDao dao;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private RefundOrderInfoService refundOrderInfoService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private AliPayService aliPayService;
    @Autowired
    private UserService userService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserBalanceRecordService userBalanceRecordService;
    @Autowired
    private MerchantAddressService merchantAddressService;
    @Autowired
    private RefundOrderStatusService refundOrderStatusService;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private WechatPayService wechatPayService;
    @Autowired
    private ReservationWorkOrderService reservationWorkOrderService;
    @Autowired
    private OrderFlowRecordService orderFlowRecordService;

    @Override
    public PageInfo<MerchantRefundOrderPageResponse> getMerchantAdminPage(RefundOrderSearchRequest request, SystemAdmin systemAdmin) {
        List<MerchantRefundOrderPageResponse> responseList;
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        map.put("merId", systemAdmin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getRefundOrderNo())) {
            map.put("refundOrderNo", request.getRefundOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", request.getOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getTrackingNumber())) {
            map.put("trackingNumber", request.getTrackingNumber());
        }
        if (ObjectUtil.isNotNull((Object)request.getRefundStatus()) && request.getRefundStatus() != 9) {
            map.put("refundStatus", request.getRefundStatus());
        }
        if (CollUtil.isEmpty(responseList = this.dao.getMerchantAdminPage(map))) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new MerchantRefundOrderPageResponse[0]));
        }
        responseList.forEach(response -> {
            RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(response.getRefundOrderNo());
            response.setRefundOrderInfo(refundOrderInfo);
        });
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public RefundOrderCountItemResponse getMerchantOrderStatusNum(RefundOrderSearchRequest request, SystemAdmin systemAdmin) {
        return this.getOrderStatusNum(request, systemAdmin.getMerId());
    }

    @Override
    public Boolean mark(RefundOrderRemarkRequest request, SystemAdmin systemAdmin) {
        RefundOrder refundOrder = this.getInfoException(request.getRefundOrderNo());
        if (!refundOrder.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_NOT_EXIST);
        }
        refundOrder.setMerRemark(request.getRemark());
        refundOrder.setUpdateTime((Date)DateUtil.date());
        return this.updateById(refundOrder);
    }

    private void wxRefund(Order order, String refundOrderNo, BigDecimal refundPrice, BigDecimal totalPrice) {
        String paySource = order.getPayChannel();
        if (paySource.equals("h5") || paySource.equals("native")) {
            String source = this.systemConfigService.getValueByKey("wechat_pay_source");
            paySource = StrUtil.isNotBlank((CharSequence)source) && source.equals("mini") ? "mini" : "public";
        }
        String apiDomain = this.systemConfigService.getValueByKeyException("api_url");
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayRefundRequest wxPayRefundRequest = new WxPayRefundRequest();
            wxPayRefundRequest.setOutTradeNo(order.getOutTradeNo());
            wxPayRefundRequest.setOutRefundNo(refundOrderNo);
            wxPayRefundRequest.setTotalFee(Integer.valueOf(totalPrice.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue()));
            wxPayRefundRequest.setRefundFee(Integer.valueOf(refundPrice.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue()));
            this.wechatPayService.refund(wxPayRefundRequest, paySource, apiDomain);
        } else {
            WxPayRefundV3Request wxPayRefundV3Request = new WxPayRefundV3Request();
            wxPayRefundV3Request.setOutTradeNo(order.getOutTradeNo());
            wxPayRefundV3Request.setOutRefundNo(refundOrderNo);
            WxPayRefundV3Request.Amount amount = new WxPayRefundV3Request.Amount();
            amount.setTotal(Integer.valueOf(totalPrice.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue()));
            amount.setCurrency("CNY");
            amount.setRefund(Integer.valueOf(refundPrice.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).intValue()));
            wxPayRefundV3Request.setAmount(amount);
            this.wechatPayService.refundV3(wxPayRefundV3Request, paySource, apiDomain);
        }
    }

    private void settingOrderStatus(Order order) {
        long count;
        long counted;
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        if (order.getStatus().equals(OrderConstants.ORDER_STATUS_PART_SHIPPING) && (counted = orderDetailList.stream().filter(e -> e.getPayNum() > e.getDeliveryNum() + e.getRefundNum()).count()) <= 0L) {
            String shippingSwitch;
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
            if (order.getPayType().equals("weixin") && order.getPayChannel().equals("mini") && StrUtil.isNotBlank((CharSequence)(shippingSwitch = this.systemConfigService.getValueByKey("wechat_routine_shipping_switch"))) && shippingSwitch.equals("1")) {
                this.asyncService.wechatSendUploadShipping(order.getOrderNo());
            }
        }
        if ((count = orderDetailList.stream().filter(e -> e.getRefundNum().equals(0)).count()) == (long)orderDetailList.size()) {
            order.setRefundStatus(OrderConstants.ORDER_REFUND_STATUS_NORMAL);
            return;
        }
        OrderDetail orderDetail = orderDetailList.stream().filter(e -> e.getApplyRefundNum() > 0).findAny().orElse(null);
        if (ObjectUtil.isNotNull((Object)orderDetail)) {
            order.setRefundStatus(OrderConstants.ORDER_REFUND_STATUS_APPLY);
            return;
        }
        long refundCount = orderDetailList.stream().filter(e -> e.getRefundNum().equals(e.getPayNum())).count();
        if (refundCount == (long)orderDetailList.size()) {
            order.setRefundStatus(OrderConstants.ORDER_REFUND_STATUS_ALL);
            this.orderFlowRecordService.orderRefund(order.getOrderNo());
            return;
        }
        order.setRefundStatus(OrderConstants.ORDER_REFUND_STATUS_PORTION);
    }

    @Override
    public RefundOrder getInfoException(String refundOrderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RefundOrder::getRefundOrderNo, (Object)refundOrderNo);
        lqw.last(" limit 1");
        RefundOrder refundOrder = (RefundOrder)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)refundOrder)) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_NOT_EXIST);
        }
        return refundOrder;
    }

    @Override
    public PageInfo<RefundOrderResponse> getH5List(OrderAfterSalesSearchRequest request) {
        Integer userId = this.userService.getUserId();
        HashMap map = CollUtil.newHashMap();
        map.put("userId", userId);
        if (request.getType().equals(0)) {
            map.put("refundStatusStr", "0,2,4,5");
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            map.put("keywords", URLUtil.decode((String)request.getKeywords()));
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<RefundOrderResponse> list = this.dao.findSearchList(map);
        return CommonPage.copyPageInfo((Page)page, list);
    }

    @Override
    public RefundOrderInfoResponse getRefundOrderDetailByRefundOrderNo(String refundOrderNo) {
        RefundOrderInfoResponse response = this.dao.getRefundOrderDetailByRefundOrderNo(refundOrderNo);
        response.setStatusList(this.refundOrderStatusService.findListByRefundOrderNo(refundOrderNo));
        return response;
    }

    @Override
    public RefundOrderAdminDetailResponse getMerchantDetail(String refundOrderNo, SystemAdmin systemAdmin) {
        RefundOrder refundOrder = this.getInfoException(refundOrderNo);
        if (!systemAdmin.getMerId().equals(refundOrder.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_NOT_EXIST);
        }
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrderNo);
        RefundOrderAdminDetailResponse response = new RefundOrderAdminDetailResponse();
        response.setRefundOrderNo(refundOrder.getRefundOrderNo());
        response.setAfterSalesType(refundOrder.getAfterSalesType());
        response.setRefundStatus(refundOrder.getRefundStatus());
        response.setRefundPrice(refundOrder.getRefundPrice());
        response.setPayPrice(refundOrderInfo.getPayPrice());
        response.setPromoterType(refundOrder.getPromoterType());
        response.setProductName(refundOrderInfo.getProductName());
        response.setImage(refundOrderInfo.getImage());
        response.setSku(refundOrderInfo.getSku());
        response.setPrice(refundOrderInfo.getPrice());
        response.setRefundTime(refundOrder.getRefundTime());
        response.setPayNum(refundOrderInfo.getPayNum());
        response.setRefundUseIntegral(refundOrder.getRefundUseIntegral());
        response.setRefundGainIntegral(refundOrder.getRefundGainIntegral());
        response.setRefundFirstBrokerageFee(refundOrder.getRefundFirstBrokerageFee());
        response.setRefundSecondBrokerageFee(refundOrder.getRefundSecondBrokerageFee());
        response.setRefundFreightFee(refundOrder.getRefundFreightFee());
        response.setApplyRefundNum(refundOrder.getTotalNum());
        response.setReturnGoodsType(refundOrder.getReturnGoodsType());
        response.setRefundReasonWap(refundOrder.getRefundReasonWap());
        response.setRefundReasonWapImg(refundOrder.getRefundReasonWapImg());
        response.setRefundReasonWapExplain(refundOrder.getRefundReasonWapExplain());
        response.setReceiver(refundOrder.getReceiver());
        response.setReceiverPhone(refundOrder.getReceiverPhone());
        response.setReceiverAddressDetail(refundOrder.getReceiverAddressDetail());
        response.setExpressName(refundOrder.getExpressName());
        response.setTrackingNumber(refundOrder.getTrackingNumber());
        response.setTelephone(refundOrder.getTelephone());
        response.setIsUserRevoke(refundOrder.getIsUserRevoke());
        response.setRefundReason(refundOrder.getRefundReason());
        response.setMerRemark(refundOrder.getMerRemark());
        response.setStatusList(this.refundOrderStatusService.findListByRefundOrderNo(refundOrderNo));
        RefundOrderDetailOrderInfoVo orderInfoVo = this.getRefundOrderDetailOrderInfo(refundOrder.getOrderNo());
        response.setOrderInfoVo(orderInfoVo);
        return response;
    }

    private RefundOrderDetailOrderInfoVo getRefundOrderDetailOrderInfo(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(orderNo);
        RefundOrderDetailOrderInfoVo orderInfoVo = new RefundOrderDetailOrderInfoVo();
        orderInfoVo.setOrderNo(orderNo);
        orderInfoVo.setUid(order.getUid());
        User user = (User)this.userService.getById(order.getUid());
        orderInfoVo.setNickname(user.getNickname());
        orderInfoVo.setPhone(user.getPhone());
        orderInfoVo.setStatus(order.getStatus());
        orderInfoVo.setTotalNum(order.getTotalNum());
        orderInfoVo.setPaid(order.getPaid());
        orderInfoVo.setPayType(order.getPayType());
        orderInfoVo.setPayTime(order.getPayTime());
        orderInfoVo.setCreateTime(order.getCreateTime());
        if (order.getStatus() <= OrderConstants.ORDER_STATUS_WAIT_SHIPPING || order.getStatus().equals(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION)) {
            orderInfoVo.setDeliveryNum(Integer.valueOf(0));
        } else if (!merchantOrder.getIsSplitDelivery().booleanValue()) {
            orderInfoVo.setDeliveryNum(merchantOrder.getTotalNum());
        } else {
            List<OrderDetail> orderDetailList = this.orderDetailService.getShipmentByOrderNo(orderNo);
            int deliveryNum = orderDetailList.stream().mapToInt(OrderDetail::getDeliveryNum).sum();
            orderInfoVo.setDeliveryNum(Integer.valueOf(deliveryNum));
        }
        orderInfoVo.setProTotalPrice(order.getProTotalPrice());
        orderInfoVo.setPayPrice(order.getPayPrice());
        orderInfoVo.setMerCouponPrice(order.getMerCouponPrice());
        orderInfoVo.setPlatCouponPrice(order.getPlatCouponPrice());
        orderInfoVo.setIntegralPrice(order.getIntegralPrice());
        orderInfoVo.setPayPostage(order.getPayPostage());
        orderInfoVo.setUseIntegral(order.getUseIntegral());
        orderInfoVo.setGainIntegral(order.getGainIntegral());
        orderInfoVo.setUserRemark(merchantOrder.getUserRemark());
        orderInfoVo.setMerchantRemark(merchantOrder.getMerchantRemark());
        orderInfoVo.setShippingType(merchantOrder.getShippingType());
        orderInfoVo.setRealName(merchantOrder.getRealName());
        orderInfoVo.setUserPhone(merchantOrder.getUserPhone());
        orderInfoVo.setUserAddress(merchantOrder.getUserAddress());
        orderInfoVo.setRefundStatus(order.getRefundStatus());
        orderInfoVo.setType(order.getType());
        orderInfoVo.setSecondType(order.getSecondType());
        orderInfoVo.setSvipDiscountPrice(order.getSvipDiscountPrice());
        if (this.crmebConfig.getPhoneMaskSwitch().booleanValue()) {
            orderInfoVo.setPhone(CrmebUtil.maskMobile((String)user.getPhone()));
            orderInfoVo.setPhone(CrmebUtil.maskMobile((String)merchantOrder.getUserPhone()));
        }
        return orderInfoVo;
    }

    @Override
    public PageInfo<PlatformRefundOrderPageResponse> getPlatformAdminPage(RefundOrderSearchRequest request) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            map.put("merId", request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRefundOrderNo())) {
            map.put("refundOrderNo", request.getRefundOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", request.getOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getTrackingNumber())) {
            map.put("trackingNumber", request.getTrackingNumber());
        }
        if (ObjectUtil.isNotNull((Object)request.getRefundStatus()) && request.getRefundStatus() != 9) {
            map.put("refundStatus", request.getRefundStatus());
        }
        List<PlatformRefundOrderPageResponse> responseList = this.dao.getPlatformAdminPage(map);
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public RefundOrderCountItemResponse getPlatformOrderStatusNum(RefundOrderSearchRequest request) {
        return this.getOrderStatusNum(request, ObjectUtil.isNull((Object)request.getMerId()) ? 0 : request.getMerId());
    }

    @Override
    public Boolean platformMark(RefundOrderRemarkRequest request) {
        RefundOrder refundOrder = this.getInfoException(request.getRefundOrderNo());
        refundOrder.setPlatformRemark(request.getRemark());
        refundOrder.setUpdateTime((Date)DateUtil.date());
        return this.updateById(refundOrder);
    }

    @Override
    public RefundOrderAdminDetailResponse getPlatformDetail(String refundOrderNo) {
        RefundOrder refundOrder = this.getInfoException(refundOrderNo);
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrderNo);
        RefundOrderAdminDetailResponse response = new RefundOrderAdminDetailResponse();
        response.setRefundOrderNo(refundOrder.getRefundOrderNo());
        response.setAfterSalesType(refundOrder.getAfterSalesType());
        response.setRefundStatus(refundOrder.getRefundStatus());
        response.setRefundPrice(refundOrder.getRefundPrice());
        response.setPayPrice(refundOrderInfo.getPayPrice());
        response.setPromoterType(refundOrder.getPromoterType());
        response.setProductName(refundOrderInfo.getProductName());
        response.setImage(refundOrderInfo.getImage());
        response.setSku(refundOrderInfo.getSku());
        response.setPrice(refundOrderInfo.getPrice());
        response.setRefundTime(refundOrder.getRefundTime());
        response.setPayNum(refundOrderInfo.getPayNum());
        response.setRefundUseIntegral(refundOrder.getRefundUseIntegral());
        response.setRefundGainIntegral(refundOrder.getRefundGainIntegral());
        response.setRefundFirstBrokerageFee(refundOrder.getRefundFirstBrokerageFee());
        response.setRefundSecondBrokerageFee(refundOrder.getRefundSecondBrokerageFee());
        response.setRefundFreightFee(refundOrder.getRefundFreightFee());
        response.setApplyRefundNum(refundOrder.getTotalNum());
        response.setReturnGoodsType(refundOrder.getReturnGoodsType());
        response.setRefundReasonWap(refundOrder.getRefundReasonWap());
        response.setRefundReasonWapImg(refundOrder.getRefundReasonWapImg());
        response.setRefundReasonWapExplain(refundOrder.getRefundReasonWapExplain());
        response.setReceiver(refundOrder.getReceiver());
        response.setReceiverPhone(refundOrder.getReceiverPhone());
        response.setReceiverAddressDetail(refundOrder.getReceiverAddressDetail());
        response.setExpressName(refundOrder.getExpressName());
        response.setTrackingNumber(refundOrder.getTrackingNumber());
        response.setTelephone(refundOrder.getTelephone());
        response.setIsUserRevoke(refundOrder.getIsUserRevoke());
        response.setRefundReason(refundOrder.getRefundReason());
        response.setMerRemark(refundOrder.getMerRemark());
        response.setPlatformRemark(refundOrder.getPlatformRemark());
        response.setStatusList(this.refundOrderStatusService.findListByRefundOrderNo(refundOrderNo));
        RefundOrderDetailOrderInfoVo orderInfoVo = this.getRefundOrderDetailOrderInfo(refundOrder.getOrderNo());
        response.setOrderInfoVo(orderInfoVo);
        return response;
    }

    @Override
    public List<RefundOrder> findByDate(Integer merId, String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(RefundOrder::getMerId, (Object)merId);
        }
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        lqw.apply("date_format(refund_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<RefundOrder> findByMonth(Integer merId, String month) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(RefundOrder::getMerId, (Object)merId);
        }
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        lqw.apply("date_format(refund_time, '%Y-%m') = {0}", new Object[]{month});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getRefundOrderNumByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{RefundOrder::getId});
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        lqw.apply("date_format(update_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public BigDecimal getRefundOrderAmountByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{RefundOrder::getRefundPrice});
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        lqw.apply("date_format(update_time, '%Y-%m-%d') = {0}", new Object[]{date});
        List orderList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)orderList)) {
            return BigDecimal.ZERO;
        }
        return orderList.stream().map(RefundOrder::getRefundPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public Integer getRefundingCount(Integer userId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RefundOrder::getUid, (Object)userId);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY);
        statusList.add(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUNDING);
        statusList.add(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_RETURN_GOODS);
        statusList.add(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_AWAIT_RECEIVING);
        lqw.in(RefundOrder::getRefundStatus, statusList);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public RefundOrder getByRefundOrderNo(String refundOrderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RefundOrder::getRefundOrderNo, (Object)refundOrderNo);
        lqw.last(" limit 1");
        return (RefundOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Integer getAwaitAuditNum(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{RefundOrder::getId});
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY);
        if (merId > 0) {
            lqw.eq(RefundOrder::getMerId, (Object)merId);
        }
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean revoke(String refundOrderNo) {
        RefundOrder refundOrder = this.getByRefundOrderNo(refundOrderNo);
        if (ObjectUtil.isNull((Object)refundOrder)) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_NOT_EXIST);
        }
        if (refundOrder.getRefundStatus() != 0 && refundOrder.getRefundStatus() != 4 && refundOrder.getRefundStatus() != 5) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_STATUS_ABNORMAL);
        }
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST.setMessage("\u9000\u6b3e\u5355\u5173\u8054\u7684\u8ba2\u5355\u4e0d\u5b58\u5728"));
        }
        refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REVOKE);
        refundOrder.setIsUserRevoke(Boolean.valueOf(true));
        refundOrder.setUpdateTime((Date)DateUtil.date());
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrder.getRefundOrderNo());
        OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(refundOrderInfo.getOrderDetailId());
        orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getApplyRefundNum() - refundOrderInfo.getApplyRefundNum()));
        orderDetail.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(refundOrder);
            this.orderDetailService.updateById(orderDetail);
            this.refundOrderStatusService.add(refundOrderNo, "revoke", "\u7528\u6237\u64a4\u9500\u9000\u6b3e");
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.settingOrderStatus(order);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
        }
        return execute;
    }

    @Override
    public Boolean audit(OrderRefundAuditRequest request, SystemAdmin systemAdmin) {
        this.validatedAuditRequest(request);
        RefundOrder refundOrder = this.getInfoException(request.getRefundOrderNo());
        if (!refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY)) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_STATUS_ABNORMAL);
        }
        if (!refundOrder.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_NOT_EXIST);
        }
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        if (ObjectUtil.isNull((Object)order)) {
            throw new CrmebException((IResultEnum)OrderResultCode.ORDER_NOT_EXIST.setMessage("\u9000\u6b3e\u5355\u5173\u8054\u7684\u8ba2\u5355\u4e0d\u5b58\u5728"));
        }
        if (request.getAuditType().equals("refuse")) {
            return this.auditRefuseProcess(order, refundOrder, request.getReason());
        }
        if (refundOrder.getAfterSalesType().equals(RefundOrderConstants.REFUND_ORDER_AFTER_SALES_TYPE_PRICE_PRODUCT)) {
            if (refundOrder.getReturnGoodsType().equals(1)) {
                if (ObjectUtil.isNull((Object)request.getMerAddressId())) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u5546\u5bb6\u9000\u8d27\u5730\u5740");
                }
                MerchantAddress merchantAddress = this.merchantAddressService.getByIdException(request.getMerAddressId());
                refundOrder.setReceiver(merchantAddress.getReceiverName());
                refundOrder.setReceiverPhone(merchantAddress.getReceiverPhone());
                refundOrder.setReceiverAddressDetail(merchantAddress.getDetail());
            }
            refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_RETURN_GOODS);
            refundOrder.setUpdateTime((Date)DateUtil.date());
            return (Boolean)this.transactionTemplate.execute(e -> {
                this.updateById(refundOrder);
                this.refundOrderStatusService.add(refundOrder.getRefundOrderNo(), "audit", "\u552e\u540e\u5355\u5546\u5bb6\u5ba1\u6838\u901a\u8fc7");
                return Boolean.TRUE;
            });
        }
        Boolean refundResult = this.refundPrice(refundOrder, order);
        if (refundResult.booleanValue()) {
            this.refundOrderStatusService.add(refundOrder.getRefundOrderNo(), "audit", "\u552e\u540e\u5355\u5546\u5bb6\u5ba1\u6838\u901a\u8fc7");
        }
        return refundResult;
    }

    private Boolean auditRefuseProcess(Order order, RefundOrder refundOrder, String reason) {
        refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REJECT);
        refundOrder.setRefundReason(reason);
        refundOrder.setUpdateTime((Date)DateUtil.date());
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrder.getRefundOrderNo());
        OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(refundOrderInfo.getOrderDetailId());
        orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getApplyRefundNum() - refundOrderInfo.getApplyRefundNum()));
        orderDetail.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(refundOrder);
            this.orderDetailService.updateById(orderDetail);
            this.refundOrderStatusService.add(refundOrder.getRefundOrderNo(), "audit", "\u552e\u540e\u5355\u5546\u5bb6\u5ba1\u6838\u62d2\u7edd");
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.settingOrderStatus(order);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
        }
        return execute;
    }

    @Override
    public Boolean receiving(String refundOrderNo, SystemAdmin systemAdmin) {
        RefundOrder refundOrder = this.getInfoException(refundOrderNo);
        if (refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REJECT) || refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUNDING) || refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND) || refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REVOKE)) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_STATUS_ABNORMAL);
        }
        if (!refundOrder.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_NOT_EXIST);
        }
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        Boolean refundResult = this.refundPrice(refundOrder, order);
        if (refundResult.booleanValue()) {
            this.refundOrderStatusService.add(refundOrder.getRefundOrderNo(), "receiving", "\u552e\u540e\u5355\u5546\u5bb6\u786e\u8ba4\u6536\u8d27");
        }
        return refundResult;
    }

    @Override
    public Boolean compulsoryRefund(String refundOrderNo, SystemAdmin systemAdmin) {
        RefundOrder refundOrder = this.getInfoException(refundOrderNo);
        if (!refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY) && !refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_AWAIT_RECEIVING)) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_STATUS_ABNORMAL);
        }
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        refundOrder.setIsCompulsoryRefund(Boolean.valueOf(true));
        refundOrder.setCompulsoryAdminId(systemAdmin.getId());
        Boolean refundResult = this.refundPrice(refundOrder, order);
        if (refundResult.booleanValue()) {
            this.refundOrderStatusService.add(refundOrder.getRefundOrderNo(), "compulsory", "\u5e73\u53f0\u5f3a\u5236\u9000\u6b3e");
        }
        return refundResult;
    }

    @Override
    public Boolean receivingReject(RejectReceivingRequest request, SystemAdmin systemAdmin) {
        RefundOrder refundOrder = this.getInfoException(request.getRefundOrderNo());
        if (!refundOrder.getMerId().equals(systemAdmin.getMerId())) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_NOT_EXIST);
        }
        if (!refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_AWAIT_RECEIVING)) {
            throw new CrmebException((IResultEnum)OrderResultCode.REFUND_ORDER_STATUS_ABNORMAL);
        }
        refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REJECT);
        refundOrder.setRefundReason(request.getReason());
        refundOrder.setUpdateTime((Date)DateUtil.date());
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrder.getRefundOrderNo());
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(refundOrderInfo.getOrderDetailId());
        orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getApplyRefundNum() - refundOrderInfo.getApplyRefundNum()));
        orderDetail.setUpdateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(refundOrder);
            this.orderDetailService.updateById(orderDetail);
            this.refundOrderStatusService.add(refundOrder.getRefundOrderNo(), "rejectionGoods", "\u552e\u540e\u5355\u5546\u5bb6\u62d2\u7edd\u6536\u8d27");
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.settingOrderStatus(order);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
        }
        return execute;
    }

    @Override
    public void autoRevoke() {
        List<RefundOrder> refundOrderList = this.findCanAutoRevokeOrderList();
        if (CollUtil.isEmpty(refundOrderList)) {
            return;
        }
        for (RefundOrder refundOrder : refundOrderList) {
            Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
            if (ObjectUtil.isNull((Object)order)) continue;
            refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REVOKE);
            refundOrder.setIsUserRevoke(Boolean.valueOf(false));
            refundOrder.setUpdateTime((Date)DateUtil.date());
            RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrder.getRefundOrderNo());
            OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(refundOrderInfo.getOrderDetailId());
            orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getApplyRefundNum() - refundOrderInfo.getApplyRefundNum()));
            orderDetail.setUpdateTime((Date)DateUtil.date());
            this.updateById(refundOrder);
            this.orderDetailService.updateById(orderDetail);
            this.refundOrderStatusService.add(refundOrder.getRefundOrderNo(), "revoke", "\u7cfb\u7edf\u81ea\u52a8\u64a4\u9500\u9000\u6b3e\u5355");
            this.settingOrderStatus(order);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
        }
    }

    @Override
    public Boolean queryAliPayRefund(String refundOrderNo) {
        RefundOrder refundOrder = this.getByRefundOrderNo(refundOrderNo);
        if (ObjectUtil.isNull((Object)refundOrder)) {
            logger.error("\u67e5\u8be2\u652f\u4ed8\u5b9d\u9000\u6b3e : \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b{}", (Object)refundOrderNo);
            return false;
        }
        if (refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND)) {
            return true;
        }
        if (!refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUNDING)) {
            logger.error("\u67e5\u8be2\u652f\u4ed8\u5b9d\u9000\u6b3e : \u9000\u6b3e\u5355\u72b6\u6001\u5f02\u5e38==> {}", (Object)refundOrderNo);
            return false;
        }
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        Boolean queryResultBoolean = this.aliPayService.queryRefund(order.getPlatOrderNo(), refundOrder.getOutRefundNo());
        if (!queryResultBoolean.booleanValue()) {
            logger.error("\u67e5\u8be2\u652f\u4ed8\u5b9d\u9000\u6b3e : \u652f\u4ed8\u5b9d\u67e5\u8be2\u5931\u8d25==> {}", (Object)refundOrderNo);
            return false;
        }
        refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
        refundOrder.setUpdateTime((Date)DateUtil.date());
        boolean update = this.updateById(refundOrder);
        if (!update) {
            logger.error("\u67e5\u8be2\u652f\u4ed8\u5b9d\u9000\u6b3e : \u652f\u4ed8\u5b9d\u9000\u6b3e\u8ba2\u5355\u66f4\u65b0\u5931\u8d25==> {}", (Object)refundOrderNo);
            return false;
        }
        return this.redisUtil.lPush("alterOrderRefundByUser", (Object)refundOrderNo);
    }

    @Override
    public Boolean isOrderContainUserRefund(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RefundOrder::getOrderNo, (Object)orderNo);
        lqw.notIn(RefundOrder::getRefundStatus, new Object[]{OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REJECT, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REVOKE});
        lqw.eq(RefundOrder::getPromoterType, (Object)"user");
        Integer count = this.dao.selectCount((Wrapper)lqw);
        return count > 0;
    }

    @Override
    public Boolean merchantDirectRefund(Order order, List<OrderDetail> orderDetailList, List<Integer> workOrderIdList) {
        String outRefundNo = CrmebUtil.getOrderNo((String)"RE");
        MerchantOrder merchantOrder = this.merchantOrderService.getOneByOrderNo(order.getOrderNo());
        ArrayList<RefundOrder> refundOrderList = new ArrayList<RefundOrder>();
        ArrayList<RefundOrderInfo> refundOrderInfoList = new ArrayList<RefundOrderInfo>();
        BigDecimal totalRefundPrice = BigDecimal.ZERO;
        for (OrderDetail orderDetail : orderDetailList) {
            BigDecimal refundPrice;
            RefundOrder refundOrder2 = new RefundOrder();
            refundOrder2.setRefundOrderNo(CrmebUtil.getOrderNo((String)"RE"));
            refundOrder2.setOrderNo(order.getOrderNo());
            refundOrder2.setMerId(order.getMerId());
            refundOrder2.setUid(order.getUid());
            refundOrder2.setRealName(merchantOrder.getRealName());
            refundOrder2.setUserPhone(merchantOrder.getUserPhone());
            refundOrder2.setUserAddress(merchantOrder.getUserAddress());
            refundOrder2.setTotalNum(orderDetail.getApplyRefundNum());
            refundOrder2.setRefundReasonWap("");
            refundOrder2.setRefundReasonWapImg("");
            refundOrder2.setRefundReasonWapExplain("");
            refundOrder2.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY);
            refundOrder2.setAfterSalesType(Integer.valueOf(1));
            refundOrder2.setReturnGoodsType(Integer.valueOf(0));
            refundOrder2.setPromoterType("merchant");
            RefundOrderInfo refundOrderInfo = new RefundOrderInfo();
            refundOrderInfo.setRefundOrderNo(refundOrder2.getRefundOrderNo());
            refundOrderInfo.setMerId(orderDetail.getMerId());
            refundOrderInfo.setOrderDetailId(orderDetail.getId());
            refundOrderInfo.setProductId(orderDetail.getProductId());
            refundOrderInfo.setProductName(orderDetail.getProductName());
            refundOrderInfo.setImage(orderDetail.getImage());
            refundOrderInfo.setAttrValueId(orderDetail.getAttrValueId());
            refundOrderInfo.setSku(orderDetail.getSku());
            refundOrderInfo.setPrice(orderDetail.getPrice());
            refundOrderInfo.setPayNum(orderDetail.getPayNum());
            refundOrderInfo.setProductType(orderDetail.getProductType());
            refundOrderInfo.setPayPrice(orderDetail.getPayPrice());
            refundOrderInfo.setApplyRefundNum(orderDetail.getApplyRefundNum());
            if (orderDetail.getPayNum().equals(refundOrderInfo.getApplyRefundNum())) {
                refundPrice = orderDetail.getPayPrice();
                orderDetail.setRefundPrice(refundPrice);
                refundOrderInfo.setRefundPrice(refundPrice);
                if (orderDetail.getUseIntegral() > 0) {
                    orderDetail.setRefundUseIntegral(orderDetail.getUseIntegral());
                    orderDetail.setRefundIntegralPrice(orderDetail.getIntegralPrice());
                    refundOrderInfo.setRefundUseIntegral(orderDetail.getRefundUseIntegral());
                    refundOrderInfo.setRefundIntegralPrice(orderDetail.getRefundIntegralPrice());
                }
                if (orderDetail.getGainIntegral() > 0) {
                    orderDetail.setRefundGainIntegral(orderDetail.getGainIntegral());
                    refundOrderInfo.setRefundGainIntegral(orderDetail.getRefundGainIntegral());
                }
                if (orderDetail.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                    orderDetail.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee());
                    refundOrderInfo.setRefundFirstBrokerageFee(orderDetail.getRefundFirstBrokerageFee());
                }
                if (orderDetail.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                    orderDetail.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee());
                    refundOrderInfo.setRefundSecondBrokerageFee(orderDetail.getRefundSecondBrokerageFee());
                }
                if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
                    orderDetail.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice());
                    refundOrderInfo.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice());
                }
                if (orderDetail.getFreightFee().compareTo(BigDecimal.ZERO) > 0) {
                    refundOrderInfo.setRefundFreightFee(orderDetail.getFreightFee());
                    orderDetail.setRefundFreightFee(orderDetail.getFreightFee());
                }
                refundOrderInfo.setMerchantRefundPrice(refundPrice);
            } else if (orderDetail.getPayNum() == orderDetail.getRefundNum() + refundOrderInfo.getApplyRefundNum()) {
                refundPrice = orderDetail.getPayPrice().subtract(orderDetail.getRefundPrice());
                orderDetail.setRefundPrice(orderDetail.getPayPrice());
                refundOrderInfo.setRefundPrice(refundPrice);
                refundOrderInfo.setMerchantRefundPrice(refundPrice);
                if (orderDetail.getUseIntegral() > 0) {
                    refundOrderInfo.setRefundUseIntegral(Integer.valueOf(orderDetail.getUseIntegral() - orderDetail.getRefundUseIntegral()));
                    refundOrderInfo.setRefundIntegralPrice(orderDetail.getIntegralPrice().subtract(orderDetail.getRefundIntegralPrice()));
                    orderDetail.setRefundUseIntegral(orderDetail.getUseIntegral());
                    orderDetail.setRefundIntegralPrice(orderDetail.getIntegralPrice());
                }
                if (orderDetail.getGainIntegral() > 0) {
                    refundOrderInfo.setRefundGainIntegral(Integer.valueOf(orderDetail.getGainIntegral() - orderDetail.getRefundGainIntegral()));
                    orderDetail.setRefundGainIntegral(orderDetail.getGainIntegral());
                }
                if (orderDetail.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                    refundOrderInfo.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee().subtract(orderDetail.getRefundFirstBrokerageFee()));
                    orderDetail.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee());
                }
                if (orderDetail.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                    refundOrderInfo.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee().subtract(orderDetail.getRefundSecondBrokerageFee()));
                    orderDetail.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee());
                }
                if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
                    refundOrderInfo.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice().subtract(orderDetail.getRefundPlatCouponPrice()));
                    orderDetail.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice());
                }
                if (orderDetail.getFreightFee().compareTo(BigDecimal.ZERO) > 0) {
                    refundOrderInfo.setRefundFreightFee(orderDetail.getFreightFee().subtract(orderDetail.getRefundFreightFee()));
                    orderDetail.setRefundFreightFee(orderDetail.getFreightFee());
                }
            } else {
                BigDecimal ratio = new BigDecimal(refundOrderInfo.getApplyRefundNum()).divide(new BigDecimal(orderDetail.getPayNum()), 10, 4);
                refundPrice = orderDetail.getPayPrice().multiply(ratio).setScale(2, 4);
                orderDetail.setRefundPrice(orderDetail.getRefundPrice().add(refundPrice));
                refundOrderInfo.setRefundPrice(refundPrice);
                refundOrderInfo.setMerchantRefundPrice(refundPrice);
                if (orderDetail.getUseIntegral() > 0) {
                    refundOrderInfo.setRefundUseIntegral(Integer.valueOf(new BigDecimal(orderDetail.getUseIntegral().toString()).multiply(ratio).setScale(0, 4).intValue()));
                    refundOrderInfo.setRefundIntegralPrice(orderDetail.getIntegralPrice().multiply(ratio).setScale(2, 4));
                    orderDetail.setRefundUseIntegral(Integer.valueOf(orderDetail.getRefundUseIntegral() + refundOrderInfo.getRefundUseIntegral()));
                    orderDetail.setRefundIntegralPrice(orderDetail.getRefundIntegralPrice().add(refundOrderInfo.getRefundIntegralPrice()));
                }
                if (orderDetail.getGainIntegral() > 0) {
                    refundOrderInfo.setRefundGainIntegral(Integer.valueOf(new BigDecimal(orderDetail.getGainIntegral().toString()).multiply(ratio).setScale(0, 4).intValue()));
                    orderDetail.setRefundGainIntegral(Integer.valueOf(orderDetail.getRefundGainIntegral() + refundOrderInfo.getRefundGainIntegral()));
                }
                if (orderDetail.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                    refundOrderInfo.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee().multiply(ratio).setScale(2, 4));
                    orderDetail.setRefundFirstBrokerageFee(orderDetail.getRefundFirstBrokerageFee().add(refundOrderInfo.getRefundFirstBrokerageFee()));
                }
                if (orderDetail.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                    refundOrderInfo.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee().multiply(ratio).setScale(2, 4));
                    orderDetail.setRefundSecondBrokerageFee(orderDetail.getRefundSecondBrokerageFee().add(refundOrderInfo.getRefundSecondBrokerageFee()));
                }
                if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
                    refundOrderInfo.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice().multiply(ratio).setScale(2, 4));
                    orderDetail.setRefundPlatCouponPrice(orderDetail.getRefundPlatCouponPrice().add(refundOrderInfo.getRefundPlatCouponPrice()));
                }
                if (orderDetail.getFreightFee().compareTo(BigDecimal.ZERO) > 0) {
                    refundOrderInfo.setRefundFreightFee(orderDetail.getFreightFee().multiply(ratio).setScale(2, 4));
                    orderDetail.setRefundFreightFee(orderDetail.getRefundFreightFee().add(refundOrderInfo.getRefundFreightFee()));
                }
            }
            refundOrder2.setRefundPrice(refundPrice);
            refundOrder2.setMerchantRefundPrice(refundOrderInfo.getMerchantRefundPrice());
            refundOrder2.setRefundUseIntegral(refundOrderInfo.getRefundUseIntegral());
            refundOrder2.setRefundIntegralPrice(refundOrderInfo.getRefundIntegralPrice());
            refundOrder2.setRefundGainIntegral(refundOrderInfo.getRefundGainIntegral());
            refundOrder2.setRefundFirstBrokerageFee(refundOrderInfo.getRefundFirstBrokerageFee());
            refundOrder2.setRefundSecondBrokerageFee(refundOrderInfo.getRefundSecondBrokerageFee());
            refundOrder2.setRefundPayType(order.getPayType());
            refundOrder2.setRefundPlatCouponPrice(refundOrderInfo.getRefundPlatCouponPrice());
            refundOrder2.setRefundFreightFee(refundOrderInfo.getRefundFreightFee());
            orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getApplyRefundNum() - refundOrderInfo.getApplyRefundNum()));
            orderDetail.setRefundNum(Integer.valueOf(orderDetail.getRefundNum() + refundOrderInfo.getApplyRefundNum()));
            orderDetail.setUpdateTime((Date)DateUtil.date());
            refundOrder2.setOutRefundNo(outRefundNo);
            refundOrder2.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUNDING);
            refundOrderList.add(refundOrder2);
            refundOrderInfoList.add(refundOrderInfo);
            totalRefundPrice = totalRefundPrice.add(refundPrice);
        }
        if (order.getPayType().equals("weixin") && totalRefundPrice.compareTo(BigDecimal.ZERO) > 0) {
            try {
                Order platOrder = this.orderService.getByOrderNo(order.getPlatOrderNo());
                this.wxRefund(order, outRefundNo, totalRefundPrice, platOrder.getPayPrice());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new CrmebException("\u5546\u5bb6\u4e3b\u52a8\u9000\u6b3e\uff0c\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01" + e2.getMessage());
            }
        }
        Boolean aliPayIsRefund = false;
        if (order.getPayType().equals("alipay") && totalRefundPrice.compareTo(BigDecimal.ZERO) > 0) {
            try {
                aliPayIsRefund = this.aliPayService.refund(order.getPlatOrderNo(), outRefundNo, "\u5546\u5bb6\u4e3b\u52a8\u9000\u6b3e", totalRefundPrice);
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw new CrmebException("\u5546\u5bb6\u4e3b\u52a8\u9000\u6b3e\uff0c\u652f\u4ed8\u5b9d\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01" + e3.getMessage());
            }
        }
        User user = (User)this.userService.getById(order.getUid());
        refundOrderList.forEach(refundOrder -> refundOrder.setRefundTime((Date)DateUtil.date()));
        Boolean finalAliPayIsRefund = aliPayIsRefund;
        BigDecimal finalTotalRefundPrice = totalRefundPrice;
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.orderDetailService.updateBatchById(orderDetailList);
            if (order.getPayType().equals("yue")) {
                refundOrderList.forEach(refundOrder -> refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND));
                for (RefundOrder refundOrder2 : refundOrderList) {
                    if (refundOrder2.getRefundPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.userService.updateNowMoney(order.getUid(), refundOrder2.getRefundPrice(), "add");
                    UserBalanceRecord userBalanceRecord = new UserBalanceRecord();
                    userBalanceRecord.setUid(user.getId());
                    userBalanceRecord.setLinkId(refundOrder2.getRefundOrderNo());
                    userBalanceRecord.setLinkType("order");
                    userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
                    userBalanceRecord.setAmount(refundOrder2.getRefundPrice());
                    userBalanceRecord.setBalance(user.getNowMoney().add(refundOrder2.getRefundPrice()));
                    userBalanceRecord.setRemark(StrUtil.format((CharSequence)"\u7528\u6237\u8ba2\u5355\u9000\u6b3e\u6210\u529f,\u8fd4\u8fd8\u4f59\u989d{}\u5143", (Object[])new Object[]{refundOrder2.getRefundPrice()}));
                    this.userBalanceRecordService.save(userBalanceRecord);
                }
            }
            if (order.getPayType().equals("alipay") && finalTotalRefundPrice.compareTo(BigDecimal.ZERO) > 0 && finalAliPayIsRefund.booleanValue()) {
                refundOrderList.forEach(refundOrder -> refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND));
            }
            this.saveBatch(refundOrderList);
            this.refundOrderInfoService.saveBatch(refundOrderInfoList);
            if (CollUtil.isNotEmpty((Collection)workOrderIdList)) {
                this.reservationWorkOrderService.batchRefundByIdList(workOrderIdList);
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.settingOrderStatus(order);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
            if (order.getPayType().equals("yue")) {
                refundOrderList.forEach(refundOrder -> this.redisUtil.lPush("alterOrderRefundByUser", (Object)refundOrder.getRefundOrderNo()));
            }
            if (order.getPayType().equals("alipay") && totalRefundPrice.compareTo(BigDecimal.ZERO) > 0) {
                if (aliPayIsRefund.booleanValue()) {
                    refundOrderList.forEach(refundOrder -> this.redisUtil.lPush("alterOrderRefundByUser", (Object)refundOrder.getRefundOrderNo()));
                } else {
                    refundOrderList.forEach(refundOrder -> this.redisUtil.lPush("refundOrderAliPayTask", (Object)refundOrder.getRefundOrderNo()));
                }
            }
        }
        return execute;
    }

    @Override
    public List<RefundOrder> findByOutRefundNo(String outRefundNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(RefundOrder::getOutRefundNo, (Object)outRefundNo);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getAwaitAuditNumByMerIds(List<Integer> merIds) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{RefundOrder::getId});
        lqw.eq(RefundOrder::getRefundStatus, (Object)OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY);
        lqw.in(RefundOrder::getMerId, merIds);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public PageInfo<PlatformRefundOrderPageResponse> getCircleRefundOrderPage(RefundOrderSearchRequest request, List<Integer> merIdList) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        ArrayList<Integer> merIds = new ArrayList<Integer>();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            merIds.add(request.getMerId());
        } else {
            merIds.addAll(merIdList);
        }
        map.put("merIds", merIds);
        if (StrUtil.isNotBlank((CharSequence)request.getRefundOrderNo())) {
            map.put("refundOrderNo", request.getRefundOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", request.getOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getTrackingNumber())) {
            map.put("trackingNumber", request.getTrackingNumber());
        }
        if (ObjectUtil.isNotNull((Object)request.getRefundStatus()) && request.getRefundStatus() != 9) {
            map.put("refundStatus", request.getRefundStatus());
        }
        List<PlatformRefundOrderPageResponse> responseList = this.dao.getCircleRefundOrderPage(map);
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public RefundOrderCountItemResponse getCircleRefundOrderStatusNum(RefundOrderSearchRequest request, List<Integer> merIdList) {
        ArrayList<Integer> merIds = new ArrayList<Integer>();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            merIds.add(request.getMerId());
        } else {
            merIds.addAll(merIdList);
        }
        RefundOrderCountItemResponse response = new RefundOrderCountItemResponse();
        response.setAll(this.getCircleRefundOrderCount(request, 9, merIds));
        response.setAwait(this.getCircleRefundOrderCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY, merIds));
        response.setReject(this.getCircleRefundOrderCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REJECT, merIds));
        response.setRefunding(this.getCircleRefundOrderCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUNDING, merIds));
        response.setRefunded(this.getCircleRefundOrderCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND, merIds));
        response.setAwaitReturning(this.getCircleRefundOrderCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_RETURN_GOODS, merIds));
        response.setAwaitReceiving(this.getCircleRefundOrderCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_AWAIT_RECEIVING, merIds));
        response.setRevoke(this.getCircleRefundOrderCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REVOKE, merIds));
        return response;
    }

    private List<RefundOrder> findCanAutoRevokeOrderList() {
        DateTime date = DateUtil.date();
        DateTime dateTime = DateUtil.offsetDay((Date)date, (int)-7);
        return this.dao.findCanAutoRevokeOrderList(dateTime.toString());
    }

    private Boolean refundPrice(RefundOrder refundOrder, Order order) {
        Integer workOrderCount;
        BigDecimal refundPrice;
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrder.getRefundOrderNo());
        OrderDetail orderDetail = (OrderDetail)this.orderDetailService.getById(refundOrderInfo.getOrderDetailId());
        if (orderDetail.getPayNum().equals(refundOrderInfo.getApplyRefundNum())) {
            refundPrice = orderDetail.getPayPrice();
            orderDetail.setRefundPrice(refundPrice);
            refundOrderInfo.setRefundPrice(refundPrice);
            if (orderDetail.getUseIntegral() > 0) {
                orderDetail.setRefundUseIntegral(orderDetail.getUseIntegral());
                orderDetail.setRefundIntegralPrice(orderDetail.getIntegralPrice());
                refundOrderInfo.setRefundUseIntegral(orderDetail.getRefundUseIntegral());
                refundOrderInfo.setRefundIntegralPrice(orderDetail.getRefundIntegralPrice());
            }
            if (orderDetail.getGainIntegral() > 0) {
                orderDetail.setRefundGainIntegral(orderDetail.getGainIntegral());
                refundOrderInfo.setRefundGainIntegral(orderDetail.getRefundGainIntegral());
            }
            if (orderDetail.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                orderDetail.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee());
                refundOrderInfo.setRefundFirstBrokerageFee(orderDetail.getRefundFirstBrokerageFee());
            }
            if (orderDetail.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                orderDetail.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee());
                refundOrderInfo.setRefundSecondBrokerageFee(orderDetail.getRefundSecondBrokerageFee());
            }
            if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
                orderDetail.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice());
                refundOrderInfo.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice());
            }
            refundOrderInfo.setMerchantRefundPrice(refundPrice);
            if (orderDetail.getFreightFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFreightFee(orderDetail.getFreightFee());
                orderDetail.setRefundFreightFee(orderDetail.getFreightFee());
            }
        } else if (orderDetail.getPayNum() == orderDetail.getRefundNum() + refundOrderInfo.getApplyRefundNum()) {
            refundPrice = orderDetail.getPayPrice().subtract(orderDetail.getRefundPrice());
            orderDetail.setRefundPrice(orderDetail.getPayPrice());
            refundOrderInfo.setRefundPrice(refundPrice);
            refundOrderInfo.setMerchantRefundPrice(refundPrice);
            if (orderDetail.getUseIntegral() > 0) {
                refundOrderInfo.setRefundUseIntegral(Integer.valueOf(orderDetail.getUseIntegral() - orderDetail.getRefundUseIntegral()));
                refundOrderInfo.setRefundIntegralPrice(orderDetail.getIntegralPrice().subtract(orderDetail.getRefundIntegralPrice()));
                orderDetail.setRefundUseIntegral(orderDetail.getUseIntegral());
                orderDetail.setRefundIntegralPrice(orderDetail.getIntegralPrice());
            }
            if (orderDetail.getGainIntegral() > 0) {
                refundOrderInfo.setRefundGainIntegral(Integer.valueOf(orderDetail.getGainIntegral() - orderDetail.getRefundGainIntegral()));
                orderDetail.setRefundGainIntegral(orderDetail.getGainIntegral());
            }
            if (orderDetail.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee().subtract(orderDetail.getRefundFirstBrokerageFee()));
                orderDetail.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee());
            }
            if (orderDetail.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee().subtract(orderDetail.getRefundSecondBrokerageFee()));
                orderDetail.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee());
            }
            if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice().subtract(orderDetail.getRefundPlatCouponPrice()));
                orderDetail.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice());
            }
            if (orderDetail.getFreightFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFreightFee(orderDetail.getFreightFee().subtract(orderDetail.getRefundFreightFee()));
                orderDetail.setRefundFreightFee(orderDetail.getFreightFee());
            }
        } else {
            BigDecimal ratio = new BigDecimal(refundOrderInfo.getApplyRefundNum()).divide(new BigDecimal(orderDetail.getPayNum()), 10, 4);
            refundPrice = orderDetail.getPayPrice().multiply(ratio).setScale(2, 4);
            orderDetail.setRefundPrice(orderDetail.getRefundPrice().add(refundPrice));
            refundOrderInfo.setRefundPrice(refundPrice);
            refundOrderInfo.setMerchantRefundPrice(refundPrice);
            if (orderDetail.getUseIntegral() > 0) {
                refundOrderInfo.setRefundUseIntegral(Integer.valueOf(new BigDecimal(orderDetail.getUseIntegral().toString()).multiply(ratio).setScale(0, 4).intValue()));
                refundOrderInfo.setRefundIntegralPrice(orderDetail.getIntegralPrice().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundUseIntegral(Integer.valueOf(orderDetail.getRefundUseIntegral() + refundOrderInfo.getRefundUseIntegral()));
                orderDetail.setRefundIntegralPrice(orderDetail.getRefundIntegralPrice().add(refundOrderInfo.getRefundIntegralPrice()));
            }
            if (orderDetail.getGainIntegral() > 0) {
                refundOrderInfo.setRefundGainIntegral(Integer.valueOf(new BigDecimal(orderDetail.getGainIntegral().toString()).multiply(ratio).setScale(0, 4).intValue()));
                orderDetail.setRefundGainIntegral(Integer.valueOf(orderDetail.getRefundGainIntegral() + refundOrderInfo.getRefundGainIntegral()));
            }
            if (orderDetail.getFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFirstBrokerageFee(orderDetail.getFirstBrokerageFee().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundFirstBrokerageFee(orderDetail.getRefundFirstBrokerageFee().add(refundOrderInfo.getRefundFirstBrokerageFee()));
            }
            if (orderDetail.getSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundSecondBrokerageFee(orderDetail.getSecondBrokerageFee().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundSecondBrokerageFee(orderDetail.getRefundSecondBrokerageFee().add(refundOrderInfo.getRefundSecondBrokerageFee()));
            }
            if (orderDetail.getPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundPlatCouponPrice(orderDetail.getPlatCouponPrice().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundPlatCouponPrice(orderDetail.getRefundPlatCouponPrice().add(refundOrderInfo.getRefundPlatCouponPrice()));
            }
            if (orderDetail.getFreightFee().compareTo(BigDecimal.ZERO) > 0) {
                refundOrderInfo.setRefundFreightFee(orderDetail.getFreightFee().multiply(ratio).setScale(2, 4));
                orderDetail.setRefundFreightFee(orderDetail.getRefundFreightFee().add(refundOrderInfo.getRefundFreightFee()));
            }
        }
        refundOrder.setRefundPrice(refundPrice);
        refundOrder.setMerchantRefundPrice(refundOrderInfo.getMerchantRefundPrice());
        refundOrder.setRefundUseIntegral(refundOrderInfo.getRefundUseIntegral());
        refundOrder.setRefundIntegralPrice(refundOrderInfo.getRefundIntegralPrice());
        refundOrder.setRefundGainIntegral(refundOrderInfo.getRefundGainIntegral());
        refundOrder.setRefundFirstBrokerageFee(refundOrderInfo.getRefundFirstBrokerageFee());
        refundOrder.setRefundSecondBrokerageFee(refundOrderInfo.getRefundSecondBrokerageFee());
        refundOrder.setRefundPayType(order.getPayType());
        refundOrder.setRefundPlatCouponPrice(refundOrderInfo.getRefundPlatCouponPrice());
        refundOrder.setRefundFreightFee(refundOrderInfo.getRefundFreightFee());
        ArrayList workOrderIdList = new ArrayList();
        if (order.getSecondType().equals(OrderConstants.ORDER_SECOND_TYPE_RESERVATION) && (workOrderCount = this.reservationWorkOrderService.getCountByOrderNo(order.getOrderNo())) > 0) {
            List<ReservationWorkOrder> workOrderList = this.findAwaitRefundWorkOrderList(orderDetail.getPayNum(), orderDetail.getRefundNum(), refundOrderInfo.getApplyRefundNum(), order.getOrderNo());
            workOrderIdList.addAll(workOrderList.stream().map(ReservationWorkOrder::getId).collect(Collectors.toList()));
        }
        if (order.getPayType().equals("weixin") && refundPrice.compareTo(BigDecimal.ZERO) > 0) {
            try {
                Order platOrder = this.orderService.getByOrderNo(order.getPlatOrderNo());
                this.wxRefund(order, refundOrder.getOutRefundNo(), refundPrice, platOrder.getPayPrice());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new CrmebException("\u5fae\u4fe1\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01" + e2.getMessage());
            }
        }
        Boolean aliPayIsRefund = false;
        if (order.getPayType().equals("alipay") && refundPrice.compareTo(BigDecimal.ZERO) > 0) {
            try {
                aliPayIsRefund = this.aliPayService.refund(order.getPlatOrderNo(), refundOrder.getOutRefundNo(), refundOrder.getRefundReasonWapExplain(), refundPrice);
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw new CrmebException("\u652f\u4ed8\u5b9d\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01" + e3.getMessage());
            }
        }
        orderDetail.setApplyRefundNum(Integer.valueOf(orderDetail.getApplyRefundNum() - refundOrderInfo.getApplyRefundNum()));
        orderDetail.setRefundNum(Integer.valueOf(orderDetail.getRefundNum() + refundOrderInfo.getApplyRefundNum()));
        orderDetail.setUpdateTime((Date)DateUtil.date());
        refundOrderInfo.setUpdateTime((Date)DateUtil.date());
        User user = (User)this.userService.getById(order.getUid());
        refundOrder.setRefundTime((Date)DateUtil.date());
        refundOrder.setUpdateTime((Date)DateUtil.date());
        Boolean finalAliPayIsRefund = aliPayIsRefund;
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.orderDetailService.updateById(orderDetail);
            this.refundOrderInfoService.updateById(refundOrderInfo);
            refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUNDING);
            if (order.getPayType().equals("yue")) {
                refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
                if (refundOrder.getRefundPrice().compareTo(BigDecimal.ZERO) > 0) {
                    this.userService.updateNowMoney(order.getUid(), refundOrder.getRefundPrice(), "add");
                    UserBalanceRecord userBalanceRecord = new UserBalanceRecord();
                    userBalanceRecord.setUid(user.getId());
                    userBalanceRecord.setLinkId(refundOrder.getRefundOrderNo());
                    userBalanceRecord.setLinkType("order");
                    userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
                    userBalanceRecord.setAmount(refundOrder.getRefundPrice());
                    userBalanceRecord.setBalance(user.getNowMoney().add(refundOrder.getRefundPrice()));
                    userBalanceRecord.setRemark(StrUtil.format((CharSequence)"\u7528\u6237\u8ba2\u5355\u9000\u6b3e\u6210\u529f,\u8fd4\u8fd8\u4f59\u989d{}\u5143", (Object[])new Object[]{refundOrder.getRefundPrice()}));
                    this.userBalanceRecordService.save(userBalanceRecord);
                }
            }
            if (order.getPayType().equals("alipay") && refundPrice.compareTo(BigDecimal.ZERO) > 0 && finalAliPayIsRefund.booleanValue()) {
                refundOrder.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
            }
            this.updateById(refundOrder);
            if (CollUtil.isNotEmpty((Collection)workOrderIdList)) {
                this.reservationWorkOrderService.batchRefundByIdList(workOrderIdList);
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.settingOrderStatus(order);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
            if (order.getPayType().equals("yue")) {
                this.redisUtil.lPush("alterOrderRefundByUser", (Object)refundOrder.getRefundOrderNo());
            }
            if (order.getPayType().equals("alipay") && refundPrice.compareTo(BigDecimal.ZERO) > 0) {
                if (aliPayIsRefund.booleanValue()) {
                    this.redisUtil.lPush("alterOrderRefundByUser", (Object)refundOrder.getRefundOrderNo());
                } else {
                    this.redisUtil.lPush("refundOrderAliPayTask", (Object)refundOrder.getRefundOrderNo());
                }
            }
        }
        return execute;
    }

    private List<ReservationWorkOrder> findAwaitRefundWorkOrderList(Integer payNum, Integer refundNum, Integer applyRefundNum, String orderNo) {
        List<Object> workOrderList = new ArrayList();
        if (payNum.equals(applyRefundNum)) {
            workOrderList = this.reservationWorkOrderService.findByOrderNo(orderNo);
        } else if (payNum == refundNum + applyRefundNum) {
            workOrderList = this.reservationWorkOrderService.findNoRefundByOrderNo(orderNo);
        } else {
            List<ReservationWorkOrder> noRefundList = this.reservationWorkOrderService.findNoRefundByOrderNo(orderNo);
            List noStartList = noRefundList.stream().filter(e -> e.getServiceStatus() < 3).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(noStartList)) {
                if (applyRefundNum < noStartList.size()) {
                    for (int i = 0; i < applyRefundNum; ++i) {
                        workOrderList.add(noStartList.get(i));
                    }
                    return workOrderList;
                }
                workOrderList.addAll(noStartList);
            }
            List startList = noRefundList.stream().filter(e -> e.getServiceStatus() >= 3).collect(Collectors.toList());
            startList = startList.stream().sorted(Comparator.comparing(ReservationWorkOrder::getUpdateTime, Comparator.reverseOrder())).collect(Collectors.toList());
            int num = applyRefundNum - workOrderList.size();
            for (int i = 0; i < num; ++i) {
                workOrderList.add(startList.get(i));
            }
        }
        return workOrderList;
    }

    private void validatedAuditRequest(OrderRefundAuditRequest request) {
        if (request.getAuditType().equals("refuse") && StrUtil.isEmpty((CharSequence)request.getReason())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u62d2\u7edd\u9000\u6b3e\u539f\u56e0");
        }
    }

    private RefundOrderCountItemResponse getOrderStatusNum(RefundOrderSearchRequest request, Integer merId) {
        RefundOrderCountItemResponse response = new RefundOrderCountItemResponse();
        response.setAll(this.getCount(request, 9, merId));
        response.setAwait(this.getCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_APPLY, merId));
        response.setReject(this.getCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REJECT, merId));
        response.setRefunding(this.getCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUNDING, merId));
        response.setRefunded(this.getCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND, merId));
        response.setAwaitReturning(this.getCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_RETURN_GOODS, merId));
        response.setAwaitReceiving(this.getCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_AWAIT_RECEIVING, merId));
        response.setRevoke(this.getCount(request, OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REVOKE, merId));
        return response;
    }

    private Integer getCount(RefundOrderSearchRequest request, Integer status, Integer merId) {
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        if (merId > 0) {
            map.put("merId", merId);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRefundOrderNo())) {
            map.put("refundOrderNo", request.getRefundOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", request.getOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getTrackingNumber())) {
            map.put("trackingNumber", request.getTrackingNumber());
        }
        if (ObjectUtil.isNotNull((Object)status) && status != 9) {
            map.put("refundStatus", status);
        }
        return this.dao.getMerchantAdminPageCount(map);
    }

    private Integer getCircleRefundOrderCount(RefundOrderSearchRequest request, Integer status, List<Integer> merIds) {
        HashMap map = CollUtil.newHashMap();
        if (StrUtil.isNotBlank((CharSequence)request.getContent())) {
            ValidateFormUtil.validatorUserCommonSearch((UserCommonSearchRequest)request);
            String keywords = URLUtil.decode((String)request.getContent());
            switch (request.getSearchType()) {
                case "all": {
                    map.put("keywords", keywords);
                    break;
                }
                case "uid": {
                    map.put("uid", Integer.valueOf(request.getContent()));
                    break;
                }
                case "nickname": {
                    map.put("nickname", keywords);
                    break;
                }
                case "phone": {
                    map.put("phone", request.getContent());
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            if (StrUtil.isNotBlank((CharSequence)dateLimit.getStartTime())) {
                map.put("startTime", dateLimit.getStartTime());
                map.put("endTime", dateLimit.getEndTime());
            }
        }
        map.put("merIds", merIds);
        if (StrUtil.isNotBlank((CharSequence)request.getRefundOrderNo())) {
            map.put("refundOrderNo", request.getRefundOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getOrderNo())) {
            map.put("orderNo", request.getOrderNo());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getTrackingNumber())) {
            map.put("trackingNumber", request.getTrackingNumber());
        }
        if (ObjectUtil.isNotNull((Object)status) && status != 9) {
            map.put("refundStatus", status);
        }
        return this.dao.getCircleRefundOrderCount(map);
    }
}

