/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.CouponConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.cdkey.CdkeyLibrary;
import com.zbkj.common.model.coupon.Coupon;
import com.zbkj.common.model.coupon.CouponProduct;
import com.zbkj.common.model.coupon.CouponUser;
import com.zbkj.common.model.express.ShippingTemplates;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.merchant.MerchantInfo;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.product.ProductAttribute;
import com.zbkj.common.model.product.ProductAttributeOption;
import com.zbkj.common.model.product.ProductCategory;
import com.zbkj.common.model.product.ProductCoupon;
import com.zbkj.common.model.product.ProductDescription;
import com.zbkj.common.model.product.ProductGuarantee;
import com.zbkj.common.model.reservation.ProductAttrValueSupplementReservation;
import com.zbkj.common.model.reservation.ProductSupplementReservation;
import com.zbkj.common.model.reservation.TimeSlot;
import com.zbkj.common.model.seckill.SeckillActivity;
import com.zbkj.common.model.system.SystemForm;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BatchAddProductFeedbackCouponsRequest;
import com.zbkj.common.request.BatchProductAuditRequest;
import com.zbkj.common.request.BatchSetProductBrokerageRequest;
import com.zbkj.common.request.BatchSetProductFreightTemplateRequest;
import com.zbkj.common.request.BatchSetVirtualSalesRequest;
import com.zbkj.common.request.CouponProductSearchRequest;
import com.zbkj.common.request.IntegralProductAddRequest;
import com.zbkj.common.request.IntegralProductAttrValueAddRequest;
import com.zbkj.common.request.IntegralProductPageSearchRequest;
import com.zbkj.common.request.IntegralProductTabsHeaderRequest;
import com.zbkj.common.request.MerProductMarketingSearchRequest;
import com.zbkj.common.request.MerProductSearchRequest;
import com.zbkj.common.request.MerProductTabsHeaderRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.PlatProductMarketingSearchRequest;
import com.zbkj.common.request.PlatProductSearchRequest;
import com.zbkj.common.request.PlatProductTabsHeaderRequest;
import com.zbkj.common.request.ProductActivitySearchRequest;
import com.zbkj.common.request.ProductAddFeedbackCouponsRequest;
import com.zbkj.common.request.ProductAddRequest;
import com.zbkj.common.request.ProductAddStockRequest;
import com.zbkj.common.request.ProductAnyTimeEditRequest;
import com.zbkj.common.request.ProductAttrAddRequest;
import com.zbkj.common.request.ProductAttrValueAddRequest;
import com.zbkj.common.request.ProductAttrValueAddStockRequest;
import com.zbkj.common.request.ProductAttrValueAnyTimeEditRequest;
import com.zbkj.common.request.ProductAttrValueReviewFreeEditRequest;
import com.zbkj.common.request.ProductAuditRequest;
import com.zbkj.common.request.ProductDeleteRequest;
import com.zbkj.common.request.ProductForceDownRequest;
import com.zbkj.common.request.ProductFreightTemplateRequest;
import com.zbkj.common.request.ProductFrontSearchRequest;
import com.zbkj.common.request.ProductPlatUpdateRequest;
import com.zbkj.common.request.ProductReviewFreeEditRequest;
import com.zbkj.common.request.ProductSetBrokerageRequest;
import com.zbkj.common.request.ProductSubmitAuditRequest;
import com.zbkj.common.request.SystemCouponProductSearchRequest;
import com.zbkj.common.request.merchant.MerchantProductSearchRequest;
import com.zbkj.common.request.reservation.ProductAttrValueSupplementReservationRequest;
import com.zbkj.common.request.reservation.ProductSupplementReservationRequest;
import com.zbkj.common.response.AdminProductListResponse;
import com.zbkj.common.response.AttrValueResponse;
import com.zbkj.common.response.IntegralProductDetailResponse;
import com.zbkj.common.response.IntegralProductFrontResponse;
import com.zbkj.common.response.IntegralProductPageResponse;
import com.zbkj.common.response.PlatformProductListResponse;
import com.zbkj.common.response.ProMerchantProductResponse;
import com.zbkj.common.response.ProductActivityResponse;
import com.zbkj.common.response.ProductFrontResponse;
import com.zbkj.common.response.ProductInfoResponse;
import com.zbkj.common.response.ProductMarketingResponse;
import com.zbkj.common.response.ProductResponseForCopyProduct;
import com.zbkj.common.response.ProductTabsHeaderResponse;
import com.zbkj.common.response.ProductTagsFrontResponse;
import com.zbkj.common.response.RecommendProductResponse;
import com.zbkj.common.response.productTag.ProductTagsForSearchResponse;
import com.zbkj.common.response.reservation.ProductAttrValueSupplementReservationResponse;
import com.zbkj.common.response.reservation.ProductSupplementReservationResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.CouponResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.result.MarketingResultCode;
import com.zbkj.common.result.MerchantResultCode;
import com.zbkj.common.result.ProductResultCode;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.OnePassUserInfoVo;
import com.zbkj.common.vo.SimpleProductVo;
import com.zbkj.service.dao.ProductDao;
import com.zbkj.service.service.ActivityStyleService;
import com.zbkj.service.service.CartService;
import com.zbkj.service.service.CdkeyLibraryService;
import com.zbkj.service.service.CircleMerchantService;
import com.zbkj.service.service.CouponProductService;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.MerchantInfoService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OnePassService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductAttrValueSupplementReservationService;
import com.zbkj.service.service.ProductAttributeOptionService;
import com.zbkj.service.service.ProductAttributeService;
import com.zbkj.service.service.ProductCategoryService;
import com.zbkj.service.service.ProductCouponService;
import com.zbkj.service.service.ProductDescriptionService;
import com.zbkj.service.service.ProductGuaranteeService;
import com.zbkj.service.service.ProductRelationService;
import com.zbkj.service.service.ProductReplyService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.ProductSupplementReservationService;
import com.zbkj.service.service.ProductTagService;
import com.zbkj.service.service.SeckillActivityService;
import com.zbkj.service.service.SeckillProductService;
import com.zbkj.service.service.ShippingTemplatesService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemFormService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.groupbuy.GroupBuyActivitySkuService;
import com.zbkj.service.util.ProductUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ProductServiceImpl
extends ServiceImpl<ProductDao, Product>
implements ProductService {
    private final Logger LOGGER = LoggerFactory.getLogger(ProductServiceImpl.class);
    @Resource
    private ProductDao dao;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private ProductDescriptionService productDescriptionService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private CouponProductService couponProductService;
    @Autowired
    private ProductCouponService productCouponService;
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private ProductCategoryService productCategoryService;
    @Autowired
    private MerchantInfoService merchantInfoService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private CouponService couponService;
    @Autowired
    private ProductUtils productUtils;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OnePassService onePassService;
    @Autowired
    private ProductRelationService productRelationService;
    @Autowired
    private CartService cartService;
    @Autowired
    private ProductReplyService productReplyService;
    @Autowired
    private SeckillActivityService seckillActivityService;
    @Autowired
    private ActivityStyleService activityStyleService;
    @Autowired
    private ProductTagService productTagService;
    @Autowired
    private CdkeyLibraryService cdkeyLibraryService;
    @Autowired
    private ShippingTemplatesService shippingTemplatesService;
    @Autowired
    private ProductGuaranteeService productGuaranteeService;
    @Autowired
    private SystemFormService systemFormService;
    @Autowired
    private SeckillProductService seckillProductService;
    @Autowired
    private GroupBuyActivitySkuService groupBuyActivitySkuService;
    @Autowired
    private ProductAttributeService productAttributeService;
    @Autowired
    private ProductAttributeOptionService productAttributeOptionService;
    @Autowired
    private ProductSupplementReservationService productSupplementReservationService;
    @Autowired
    private ProductAttrValueSupplementReservationService productAttrValueSupplementReservationService;
    @Autowired
    private CircleMerchantService circleMerchantService;
    @Autowired
    private OrderService orderService;

    @Override
    public PageInfo<AdminProductListResponse> getAdminList(MerProductSearchRequest request, SystemAdmin admin) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Product::getMerId, (Object)admin.getMerId());
        this.setAdminListWrapperByType((LambdaQueryWrapper<Product>)lqw, request.getType(), admin.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Product::getName, (Object)keywords)).or()).apply(" find_in_set({0}, keyword)", new Object[]{keywords});
            });
        }
        lqw.apply(StrUtil.isNotBlank((CharSequence)request.getCateId()), "FIND_IN_SET({0}, cate_id)", new Object[]{request.getCateId()});
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            lqw.eq(Product::getCategoryId, (Object)request.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)request.getProductType())) {
            lqw.eq(Product::getType, (Object)request.getProductType());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsPaidMember())) {
            lqw.eq(Product::getIsPaidMember, (Object)request.getIsPaidMember());
        }
        ((LambdaQueryWrapper)lqw.orderByDesc(Product::getSort)).orderByDesc(Product::getId);
        Page productPage = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List products = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)products)) {
            return CommonPage.copyPageInfo((Page)productPage, (List)CollUtil.newArrayList((Object[])new AdminProductListResponse[0]));
        }
        ArrayList<AdminProductListResponse> productResponses = new ArrayList<AdminProductListResponse>();
        for (Product product : products) {
            AdminProductListResponse productResponse = new AdminProductListResponse();
            BeanUtils.copyProperties((Object)product, (Object)productResponse);
            productResponse.setCollectCount(this.productRelationService.getCollectCountByProductId(product.getId()));
            productResponses.add(productResponse);
        }
        return CommonPage.copyPageInfo((Page)productPage, productResponses);
    }

    @Override
    public Product getSimpleById(Integer productId) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getName, Product::getImage, Product::getType, Product::getSystemFormId, Product::getDeliveryMethod, Product::getIsPaidMember});
        lqw.eq(Product::getId, (Object)productId);
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.last(" limit 1");
        return (Product)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<SimpleProductVo> getSimpleListInIds(List<Integer> productIds) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getImage, Product::getPrice, Product::getStock});
        lqw.in(Product::getId, productIds);
        lqw.eq(Product::getIsDel, (Object)false);
        List selectList = this.dao.selectList((Wrapper)lqw);
        return selectList.stream().map(e -> {
            SimpleProductVo vo = new SimpleProductVo();
            BeanUtils.copyProperties((Object)e, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
    }

    @Override
    public Integer save(ProductAddRequest request) {
        Boolean execute;
        this.saveProductValidator(request.getType(), request.getSpecType(), request.getAttrValueList(), request.getIsSub(), request.getCategoryId(), request.getIsPaidMember());
        if (ProductConstants.PRODUCT_TYPE_RESERVATION.equals(request.getType())) {
            this.validateReservationProduct(request.getSpecType(), request.getAttrList(), request.getAttrValueList(), request.getSupplementReservation());
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        if (ObjectUtil.isNotNull((Object)request.getSystemFormId()) && request.getSystemFormId() > 0 && !this.systemFormService.isExist(request.getSystemFormId(), admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7cfb\u7edf\u8868\u5355\u4e0d\u5b58\u5728");
        }
        HashMap<Integer, CdkeyLibrary> cdkeyMap = new HashMap<Integer, CdkeyLibrary>();
        if (request.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
            List<Integer> cdkIdList = request.getAttrValueList().stream().map(ProductAttrValueAddRequest::getCdkeyId).distinct().collect(Collectors.toList());
            List<CdkeyLibrary> cdkeyLibraryList = this.cdkeyLibraryService.findByIdList(cdkIdList);
            for (CdkeyLibrary cdkeyLibrary : cdkeyLibraryList) {
                if (!admin.getMerId().equals(cdkeyLibrary.getMerId())) {
                    throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
                }
                if (cdkeyLibrary.getProductId() > 0) {
                    throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_INTERACTION);
                }
                cdkeyMap.put(cdkeyLibrary.getId(), cdkeyLibrary);
            }
        }
        if (StrUtil.isBlank((CharSequence)request.getKeyword())) {
            request.setKeyword("");
        } else if (request.getKeyword().length() > 32) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5173\u952e\u5b57\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
        }
        Merchant merchant = this.merchantService.getByIdException(admin.getMerId());
        Product product = new Product();
        BeanUtils.copyProperties((Object)request, (Object)product);
        product.setId(null);
        product.setMerId(admin.getMerId());
        product.setMarketingType(ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CLOUD) || product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY) || product.getType().equals(ProductConstants.PRODUCT_TYPE_VIRTUALLY)) {
            product.setDeliveryMethod("1");
            product.setTempId(Integer.valueOf(0));
            if (!product.getType().equals(ProductConstants.PRODUCT_TYPE_VIRTUALLY)) {
                product.setRefundSwitch(Boolean.valueOf(true));
            }
        }
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        product.setImage(this.systemAttachmentService.clearPrefix(product.getImage(), cdnUrl));
        product.setSliderImage(this.systemAttachmentService.clearPrefix(product.getSliderImage(), cdnUrl));
        if (StrUtil.isNotBlank((CharSequence)product.getFlatPattern())) {
            product.setFlatPattern(this.systemAttachmentService.clearPrefix(product.getFlatPattern(), cdnUrl));
        }
        List attrValueAddRequestList = request.getAttrValueList();
        ProductAttrValueAddRequest minAttrValue = attrValueAddRequestList.stream().min(Comparator.comparing(ProductAttrValueAddRequest::getPrice)).get();
        product.setPrice(minAttrValue.getPrice());
        product.setOtPrice(minAttrValue.getOtPrice());
        product.setCost(minAttrValue.getCost());
        product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
        product.setIsAudit(Boolean.valueOf(false));
        product.setIsShow(Boolean.valueOf(false));
        if (product.getIsPaidMember().booleanValue()) {
            product.setVipPrice(minAttrValue.getVipPrice());
        }
        List addRequestList = request.getAttrList();
        ArrayList attrList = new ArrayList();
        HashMap optionMap = new HashMap();
        addRequestList.forEach(attrRequest -> {
            ProductAttribute attr = new ProductAttribute();
            attr.setAttributeName(attrRequest.getAttributeName());
            attr.setIsShowImage(attrRequest.getIsShowImage());
            attr.setSort(Integer.valueOf(ObjectUtil.isNotNull((Object)attrRequest.getSort()) ? attrRequest.getSort() : 0));
            List optionRequestList = attrRequest.getOptionList();
            List attrOptionList = optionRequestList.stream().map(optionRequest -> {
                ProductAttributeOption option = new ProductAttributeOption();
                option.setOptionName(optionRequest.getOptionName());
                option.setSort(Integer.valueOf(ObjectUtil.isNotNull((Object)optionRequest.getSort()) ? optionRequest.getSort() : 0));
                option.setImage(StrUtil.isNotBlank((CharSequence)optionRequest.getImage()) ? this.systemAttachmentService.clearPrefix(optionRequest.getImage(), cdnUrl) : "");
                return option;
            }).collect(Collectors.toList());
            attrList.add(attr);
            optionMap.put(attr.getAttributeName(), attrOptionList);
        });
        HashMap attrValueReservationMap = new HashMap();
        List attrValueList = attrValueAddRequestList.stream().map(e -> {
            ProductAttrValue attrValue = new ProductAttrValue();
            BeanUtils.copyProperties((Object)e, (Object)attrValue);
            attrValue.setId(null);
            attrValue.setSku(this.getSku(e.getAttrValue()));
            attrValue.setQuota(Integer.valueOf(0));
            attrValue.setQuotaShow(Integer.valueOf(0));
            attrValue.setType(product.getType());
            attrValue.setMarketingType(product.getMarketingType());
            attrValue.setImage(this.systemAttachmentService.clearPrefix(e.getImage(), cdnUrl));
            if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                CdkeyLibrary cdkeyLibrary = (CdkeyLibrary)cdkeyMap.get(e.getCdkeyId());
                attrValue.setStock(Integer.valueOf(cdkeyLibrary.getTotalNum() - cdkeyLibrary.getUsedNum()));
            }
            if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
                int attrValueStock = e.getAttrValueReservationList().stream().mapToInt(ProductAttrValueSupplementReservationRequest::getStock).sum();
                attrValue.setStock(Integer.valueOf(attrValueStock));
            }
            attrValue.setVipPrice(product.getIsPaidMember() != false ? e.getVipPrice() : BigDecimal.ZERO);
            if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
                List list = e.getAttrValueReservationList();
                List supplementReservationList = list.stream().map(reser -> {
                    ProductAttrValueSupplementReservation supplementReservation = new ProductAttrValueSupplementReservation();
                    BeanUtils.copyProperties((Object)reser, (Object)supplementReservation);
                    return supplementReservation;
                }).collect(Collectors.toList());
                attrValueReservationMap.put(attrValue.getSku(), supplementReservationList);
            }
            return attrValue;
        }).collect(Collectors.toList());
        product.setStock(Integer.valueOf(attrValueList.stream().mapToInt(ProductAttrValue::getStock).sum()));
        ProductDescription spd = new ProductDescription();
        spd.setDescription(StrUtil.isNotBlank((CharSequence)request.getContent()) ? this.systemAttachmentService.clearPrefix(request.getContent(), cdnUrl) : "");
        spd.setType(product.getType());
        spd.setMarketingType(product.getMarketingType());
        if (merchant.getProductSwitch().booleanValue() && request.getIsAutoSubmitAudit().booleanValue()) {
            product.setIsAutoUp(request.getIsAutoUp());
        } else {
            product.setIsAutoUp(request.getIsAutoUp());
        }
        ProductSupplementReservation productSupplementReservation = new ProductSupplementReservation();
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
            BeanUtils.copyProperties((Object)request.getSupplementReservation(), (Object)productSupplementReservation);
            productSupplementReservation.setTimeSlotJson(this.convertToTimeSlotJson(request.getTimeSlotList()));
        }
        if ((execute = (Boolean)this.transactionTemplate.execute(e -> {
            if (merchant.getProductSwitch().booleanValue()) {
                product.setAuditStatus(ProductConstants.AUDIT_STATUS_WAIT);
            }
            this.save(product);
            attrList.forEach(attr -> attr.setProductId(product.getId()));
            this.productAttributeService.saveBatch(attrList);
            attrList.forEach(attr -> {
                List optionList = (List)optionMap.get(attr.getAttributeName());
                optionList.forEach(option -> {
                    option.setProductId(attr.getProductId());
                    option.setAttributeId(attr.getId());
                });
                this.productAttributeOptionService.saveBatch(optionList);
            });
            attrValueList.forEach(value -> value.setProductId(product.getId()));
            this.productAttrValueService.saveBatch(attrValueList, 100);
            spd.setProductId(product.getId());
            this.productDescriptionService.deleteByProductId(product.getId(), product.getType(), product.getMarketingType());
            this.productDescriptionService.save(spd);
            if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
                productSupplementReservation.setProId(product.getId());
                this.productSupplementReservationService.save(productSupplementReservation);
                ArrayList reservationsToSave = new ArrayList();
                for (ProductAttrValue attrValue2 : attrValueList) {
                    List avlueReservationList = (List)attrValueReservationMap.get(attrValue2.getSku());
                    avlueReservationList.forEach(ar -> ar.setProId(product.getId()).setAttValueId(attrValue2.getId()));
                    reservationsToSave.addAll(avlueReservationList);
                }
                this.productAttrValueSupplementReservationService.saveBatch(reservationsToSave);
            }
            if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                List cdkeyLibraryList = attrValueList.stream().map(attrValue -> {
                    CdkeyLibrary cdkeyLibrary = new CdkeyLibrary();
                    cdkeyLibrary.setId(attrValue.getCdkeyId());
                    cdkeyLibrary.setProductId(product.getId());
                    cdkeyLibrary.setProductAttrValueId(attrValue.getId());
                    return cdkeyLibrary;
                }).collect(Collectors.toList());
                this.cdkeyLibraryService.updateBatchById(cdkeyLibraryList);
            }
            if (CollUtil.isNotEmpty((Collection)request.getCouponIds())) {
                ArrayList<ProductCoupon> couponList = new ArrayList<ProductCoupon>();
                for (Integer couponId : request.getCouponIds()) {
                    ProductCoupon spc = new ProductCoupon();
                    spc.setProductId(product.getId());
                    spc.setCouponId(couponId);
                    spc.setAddTime(CrmebUtil.getNowTimeForFT());
                    couponList.add(spc);
                }
                this.productCouponService.saveBatch(couponList);
            }
            return Boolean.TRUE;
        })).booleanValue()) {
            if (merchant.getProductSwitch().booleanValue() && request.getIsAutoSubmitAudit().booleanValue()) {
                LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
                wrapper.set(Product::getIsAudit, (Object)true);
                wrapper.set(Product::getIsShow, (Object)false);
                wrapper.eq(Product::getId, (Object)product.getId());
                this.update((Wrapper)wrapper);
                return product.getId();
            }
            if (!merchant.getProductSwitch().booleanValue() && request.getIsAutoUp().booleanValue()) {
                if (!merchant.getIsSwitch().booleanValue()) {
                    this.LOGGER.error("\u5546\u6237\u672a\u5f00\u542f\u65e0\u6cd5\u81ea\u52a8\u4e0a\u67b6\uff0cmerId = {}, proId = {}", (Object)merchant.getId(), (Object)product.getId());
                    return product.getId();
                }
                LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
                wrapper.set(Product::getIsShow, (Object)true);
                wrapper.eq(Product::getId, (Object)product.getId());
                this.update((Wrapper)wrapper);
                return product.getId();
            }
        }
        return product.getId();
    }

    private void validateReservationProduct(Boolean specType, List<ProductAttrAddRequest> attList, List<ProductAttrValueAddRequest> attrValueList, ProductSupplementReservationRequest supplementReservation) {
        if (specType.booleanValue() && attList.size() > 1) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u9884\u7ea6\u5546\u54c1\u591a\u89c4\u683c\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u89c4\u683c\u53c2\u6570");
        }
        for (ProductAttrValueAddRequest attrValue : attrValueList) {
            List attrValueReservationList = attrValue.getAttrValueReservationList();
            if (!CollUtil.isEmpty((Collection)attrValueReservationList)) continue;
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u9884\u7ea6\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u5bf9\u5e94\u7684\u65f6\u95f4\u6bb5\u4fe1\u606f");
        }
        if (Objects.isNull(supplementReservation)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u9884\u7ea6\u8bbe\u7f6e\u4fe1\u606f");
        }
        if (supplementReservation.getReservationDateType() == 2 && (StrUtil.isBlank((CharSequence)supplementReservation.getReservationDateStartDate()) || StrUtil.isBlank((CharSequence)supplementReservation.getReservationDateEndDate()) || StrUtil.isBlank((CharSequence)supplementReservation.getReservationDateWeekRange()))) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u53ef\u7ea6\u65e5\u671f\u7c7b\u578b\u4e3a\u81ea\u5b9a\u4e49\u65f6\uff0c\u8bf7\u586b\u5199\u9884\u7ea6\u65e5\u671f\u8303\u56f4\uff08\u8d77\u6b62\u65e5\u671f\uff09\u548c\u661f\u671f\u8303\u56f4");
        }
        if (supplementReservation.getAdvanceReservationSwitch().booleanValue() && (ObjectUtil.isNull((Object)supplementReservation.getAdvanceReservationHour()) || supplementReservation.getAdvanceReservationHour() < 1)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u63d0\u524d\u9884\u7ea6\u6253\u5f00\u65f6\uff0c\u8bf7\u586b\u5199\u81f3\u5c11\u63d0\u524d1\u5c0f\u65f6\u6570");
        }
        if (supplementReservation.getCancelOrderSwitch().booleanValue() && (ObjectUtil.isNull((Object)supplementReservation.getCancelOrderHour()) || supplementReservation.getCancelOrderHour() < 1)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u53d6\u6d88\u8ba2\u5355\u6253\u5f00\u65f6\uff0c\u8bf7\u586b\u5199\u81f3\u5c11\u63d0\u524d1\u5c0f\u65f6\u6570");
        }
        if (supplementReservation.getTimeSlotClassifyType() == 1) {
            if (StrUtil.isBlank((CharSequence)supplementReservation.getTimeSlotStartEndTime()) || ObjectUtil.isNull((Object)supplementReservation.getTimeSlotSpan())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u65f6\u6bb5\u81ea\u52a8\u5212\u5206\u65f6\uff0c\u8bf7\u586b\u5199\u65f6\u6bb5\u8d77\u6b62\u65f6\u95f4\u4e0e\u65f6\u6bb5\u65f6\u95f4\u8de8\u5ea6");
            }
        } else {
            supplementReservation.setTimeSlotStartEndTime("00:00,00:00").setTimeSlotSpan(Integer.valueOf(0));
        }
    }

    private void saveProductValidator(Integer type, Boolean specType, List<ProductAttrValueAddRequest> attrValueList, Boolean isSub, Integer categoryId, Boolean isPaidMember) {
        ProductCategory productCategory;
        this.validateProductBaseType(type);
        CrmebUtil.setBusinessDataForFT((int)this.orderService.getAMC(), (int)this.orderService.getAPC(), (int)this.orderService.getAOC());
        if (!specType.booleanValue() && attrValueList.size() > 1) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5355\u89c4\u683c\u5546\u54c1\u5c5e\u6027\u503c\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (isSub.booleanValue()) {
            attrValueList.forEach(av -> {
                int brokerageRatio = av.getBrokerage() + av.getBrokerageTwo();
                if (brokerageRatio > this.crmebConfig.getRetailStoreBrokerageRatio()) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u4e00\u4e8c\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e4b\u548c\u8303\u56f4\u4e3a 0~{}", (Object[])new Object[]{this.crmebConfig.getRetailStoreBrokerageRatio()}));
                }
            });
        }
        if (ObjectUtil.isNull((Object)(productCategory = (ProductCategory)this.productCategoryService.getById(categoryId))) || productCategory.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_PLAT_CATEGORY_NOT_EXIST);
        }
        if (productCategory.getLevel() < 3) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5fc5\u987b\u9009\u62e9\u5546\u54c1\u5e73\u53f0\u7b2c\u4e09\u7ea7\u5206\u7c7b");
        }
        this.validateProductAttrValue(type, attrValueList);
        if (isPaidMember.booleanValue()) {
            attrValueList.forEach(value -> {
                if (ObjectUtil.isNull((Object)value.getVipPrice()) || value.getVipPrice().compareTo(BigDecimal.ZERO) <= 0 || value.getVipPrice().compareTo(value.getPrice()) >= 0) {
                    throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u6b63\u786e\u8bbe\u7f6e\u5546\u54c1\u89c4\u683cvip\u4ef7\u683c");
                }
            });
        }
    }

    private void validateProductBaseType(Integer type) {
        ArrayList typeList = CollUtil.newArrayList((Object[])new Integer[0]);
        typeList.add(ProductConstants.PRODUCT_TYPE_NORMAL);
        typeList.add(ProductConstants.PRODUCT_TYPE_INTEGRAL);
        typeList.add(ProductConstants.PRODUCT_TYPE_VIRTUALLY);
        typeList.add(ProductConstants.PRODUCT_TYPE_COMPONENT);
        typeList.add(ProductConstants.PRODUCT_TYPE_CLOUD);
        typeList.add(ProductConstants.PRODUCT_TYPE_CDKEY);
        typeList.add(ProductConstants.PRODUCT_TYPE_RESERVATION);
        if (!typeList.contains(type)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u672a\u77e5\u7684\u5546\u54c1\u7c7b\u578b");
        }
    }

    private void validateProductAttrValue(Integer type, List<ProductAttrValueAddRequest> attrValueList) {
        if (ProductConstants.PRODUCT_TYPE_CLOUD.equals(type)) {
            for (ProductAttrValueAddRequest attrValue : attrValueList) {
                if (!StrUtil.isBlank((CharSequence)attrValue.getExpand())) continue;
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u586b\u5199\u4e91\u76d8\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u5bf9\u5e94\u7684\u94fe\u63a5");
            }
        }
        if (ProductConstants.PRODUCT_TYPE_CDKEY.equals(type)) {
            for (ProductAttrValueAddRequest attrValue : attrValueList) {
                if (!ObjectUtil.isNull((Object)attrValue.getCdkeyId()) && attrValue.getCdkeyId() > 0) continue;
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u5361\u5bc6\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u5bf9\u5e94\u7684\u5361\u5bc6\u5e93");
            }
            List cdkIdList = attrValueList.stream().map(ProductAttrValueAddRequest::getCdkeyId).distinct().collect(Collectors.toList());
            if (cdkIdList.size() != attrValueList.size()) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5361\u5bc6\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u4e2d\u6709\u91cd\u590d\u7684\u5361\u5bc6\u5e93");
            }
        }
    }

    private String getSku(String attrValue) {
        LinkedHashMap linkedHashMap = (LinkedHashMap)JSONObject.parseObject((String)attrValue, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
        Iterator iterator = linkedHashMap.entrySet().iterator();
        ArrayList strings = CollUtil.newArrayList((Object[])new String[0]);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            strings.add(next.getValue());
        }
        return String.join((CharSequence)",", strings);
    }

    @Override
    public Boolean update(ProductAddRequest productRequest, SystemAdmin admin) {
        Product tempProduct;
        if (ObjectUtil.isNull((Object)productRequest.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.saveProductValidator(productRequest.getType(), productRequest.getSpecType(), productRequest.getAttrValueList(), productRequest.getIsSub(), productRequest.getCategoryId(), productRequest.getIsPaidMember());
        if (ProductConstants.PRODUCT_TYPE_RESERVATION.equals(productRequest.getType())) {
            this.validateReservationProduct(productRequest.getSpecType(), productRequest.getAttrList(), productRequest.getAttrValueList(), productRequest.getSupplementReservation());
        }
        if (ObjectUtil.isNull((Object)(tempProduct = (Product)this.getById(productRequest.getId()))) || !admin.getMerId().equals(tempProduct.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (tempProduct.getIsRecycle().booleanValue() || tempProduct.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_DELETE);
        }
        if (tempProduct.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_IS_SHOW);
        }
        if (tempProduct.getIsAudit().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
        }
        if (!tempProduct.getType().equals(productRequest.getType())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u7c7b\u578b\u4e0d\u53ef\u7f16\u8f91");
        }
        if (productRequest.getSystemFormId() > 0 && !this.systemFormService.isExist(productRequest.getSystemFormId(), admin.getMerId()).booleanValue()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u7cfb\u7edf\u8868\u5355\u4e0d\u5b58\u5728");
        }
        HashMap<Integer, CdkeyLibrary> cdkeyMap = new HashMap<Integer, CdkeyLibrary>();
        if (tempProduct.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
            List<Integer> cdkIdList = productRequest.getAttrValueList().stream().map(ProductAttrValueAddRequest::getCdkeyId).distinct().collect(Collectors.toList());
            List<CdkeyLibrary> cdkeyLibraryList = this.cdkeyLibraryService.findByIdList(cdkIdList);
            for (CdkeyLibrary cdkeyLibrary : cdkeyLibraryList) {
                if (!admin.getMerId().equals(cdkeyLibrary.getMerId())) {
                    throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
                }
                if (cdkeyLibrary.getProductId() > 0 && !cdkeyLibrary.getProductId().equals(tempProduct.getId())) {
                    throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_INTERACTION);
                }
                cdkeyMap.put(cdkeyLibrary.getId(), cdkeyLibrary);
            }
        }
        if (StrUtil.isBlank((CharSequence)productRequest.getKeyword())) {
            productRequest.setKeyword("");
        } else if (productRequest.getKeyword().length() > 255) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5173\u952e\u5b57\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26");
        }
        Product product = new Product();
        BeanUtils.copyProperties((Object)productRequest, (Object)product);
        product.setAuditStatus(tempProduct.getAuditStatus());
        product.setType(tempProduct.getType());
        product.setMarketingType(tempProduct.getMarketingType());
        Merchant merchant = this.merchantService.getByIdException(tempProduct.getMerId());
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        product.setImage(this.systemAttachmentService.clearPrefix(product.getImage(), cdnUrl));
        product.setSliderImage(this.systemAttachmentService.clearPrefix(product.getSliderImage(), cdnUrl));
        List attrValueAddRequestList = productRequest.getAttrValueList();
        ProductAttrValueAddRequest minAttrValue = attrValueAddRequestList.stream().min(Comparator.comparing(ProductAttrValueAddRequest::getPrice)).get();
        product.setPrice(minAttrValue.getPrice());
        product.setOtPrice(minAttrValue.getOtPrice());
        product.setCost(minAttrValue.getCost());
        if (product.getIsPaidMember().booleanValue()) {
            product.setVipPrice(minAttrValue.getVipPrice());
        }
        List addRequestList = productRequest.getAttrList();
        ArrayList attrList = new ArrayList();
        HashMap optionMap = new HashMap();
        addRequestList.forEach(attrRequest -> {
            ProductAttribute attr = new ProductAttribute();
            attr.setProductId(product.getId());
            attr.setAttributeName(attrRequest.getAttributeName());
            attr.setIsShowImage(attrRequest.getIsShowImage());
            attr.setSort(Integer.valueOf(ObjectUtil.isNotNull((Object)attrRequest.getSort()) ? attrRequest.getSort() : 0));
            List optionRequestList = attrRequest.getOptionList();
            List attrOptionList = optionRequestList.stream().map(optionRequest -> {
                ProductAttributeOption option = new ProductAttributeOption();
                option.setProductId(product.getId());
                option.setOptionName(optionRequest.getOptionName());
                option.setSort(Integer.valueOf(ObjectUtil.isNotNull((Object)optionRequest.getSort()) ? optionRequest.getSort() : 0));
                option.setImage(StrUtil.isNotBlank((CharSequence)optionRequest.getImage()) ? this.systemAttachmentService.clearPrefix(optionRequest.getImage(), cdnUrl) : "");
                return option;
            }).collect(Collectors.toList());
            attrList.add(attr);
            optionMap.put(attr.getAttributeName(), attrOptionList);
        });
        ArrayList attrValueAddList = CollUtil.newArrayList((Object[])new ProductAttrValue[0]);
        ArrayList attrValueUpdateList = CollUtil.newArrayList((Object[])new ProductAttrValue[0]);
        HashMap attrValueReservationMap = new HashMap();
        attrValueAddRequestList.forEach(e -> {
            ProductAttrValue attrValue = new ProductAttrValue();
            BeanUtils.copyProperties((Object)e, (Object)attrValue);
            attrValue.setSku(this.getSku(e.getAttrValue()));
            attrValue.setImage(this.systemAttachmentService.clearPrefix(e.getImage(), cdnUrl));
            attrValue.setVersion(Integer.valueOf(0));
            attrValue.setType(product.getType());
            attrValue.setMarketingType(product.getMarketingType());
            attrValue.setVipPrice(product.getIsPaidMember() != false ? e.getVipPrice() : BigDecimal.ZERO);
            if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                CdkeyLibrary cdkeyLibrary = (CdkeyLibrary)cdkeyMap.get(e.getCdkeyId());
                attrValue.setStock(Integer.valueOf(cdkeyLibrary.getTotalNum() - cdkeyLibrary.getUsedNum()));
                e.setStock(Integer.valueOf(cdkeyLibrary.getTotalNum() - cdkeyLibrary.getUsedNum()));
            }
            if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
                int attrValueStock = e.getAttrValueReservationList().stream().mapToInt(ProductAttrValueSupplementReservationRequest::getStock).sum();
                attrValue.setStock(Integer.valueOf(attrValueStock));
                e.setStock(Integer.valueOf(attrValueStock));
                List list = e.getAttrValueReservationList();
                List attrValueReservationList = list.stream().map(reser -> {
                    ProductAttrValueSupplementReservation attrValueReservation = new ProductAttrValueSupplementReservation();
                    BeanUtils.copyProperties((Object)reser, (Object)attrValueReservation);
                    return attrValueReservation;
                }).collect(Collectors.toList());
                attrValueReservationMap.put(attrValue.getSku(), attrValueReservationList);
            }
            if (ObjectUtil.isNull((Object)attrValue.getId()) || attrValue.getId().equals(0)) {
                attrValue.setId(null);
                attrValue.setProductId(product.getId());
                attrValue.setQuota(Integer.valueOf(0));
                attrValue.setQuotaShow(Integer.valueOf(0));
                attrValueAddList.add(attrValue);
            } else {
                attrValue.setProductId(product.getId());
                attrValue.setIsDel(Boolean.valueOf(false));
                attrValueUpdateList.add(attrValue);
            }
        });
        List<Object> tempSkuIdList = CollUtil.newArrayList((Object[])new Integer[0]);
        List<ProductAttrValue> tempAttrValueList = this.productAttrValueService.getListByProductIdAndType(tempProduct.getId(), tempProduct.getType(), tempProduct.getMarketingType(), false);
        if (CollUtil.isNotEmpty((Collection)attrValueUpdateList)) {
            List updateSkuIdList = attrValueUpdateList.stream().map(ProductAttrValue::getId).collect(Collectors.toList());
            for (ProductAttrValue tempAttrValue : tempAttrValueList) {
                if (updateSkuIdList.contains(tempAttrValue.getId())) continue;
                tempSkuIdList.add(tempAttrValue.getId());
            }
        } else {
            tempSkuIdList = tempAttrValueList.stream().map(ProductAttrValue::getId).collect(Collectors.toList());
        }
        product.setStock(Integer.valueOf(attrValueAddRequestList.stream().mapToInt(ProductAttrValueAddRequest::getStock).sum()));
        ProductDescription spd = new ProductDescription();
        spd.setDescription(StrUtil.isNotBlank((CharSequence)productRequest.getContent()) ? this.systemAttachmentService.clearPrefix(productRequest.getContent(), cdnUrl) : "");
        spd.setType(product.getType());
        spd.setMarketingType(product.getMarketingType());
        spd.setProductId(product.getId());
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CLOUD) || product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY) || product.getType().equals(ProductConstants.PRODUCT_TYPE_VIRTUALLY)) {
            product.setDeliveryMethod("1");
            product.setTempId(Integer.valueOf(0));
            if (!product.getType().equals(ProductConstants.PRODUCT_TYPE_VIRTUALLY)) {
                product.setRefundSwitch(Boolean.valueOf(true));
            }
        }
        ProductSupplementReservation productSupplementReservation = new ProductSupplementReservation();
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
            BeanUtils.copyProperties((Object)productRequest.getSupplementReservation(), (Object)productSupplementReservation);
            productSupplementReservation.setProId(product.getId());
            productSupplementReservation.setTimeSlotJson(this.convertToTimeSlotJson(productRequest.getTimeSlotList()));
        }
        if (merchant.getProductSwitch().booleanValue() && productRequest.getIsAutoSubmitAudit().booleanValue()) {
            product.setIsAutoUp(productRequest.getIsAutoUp());
        } else {
            product.setIsAutoUp(productRequest.getIsAutoUp());
        }
        List<Object> finalSkuIdList = tempSkuIdList;
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            List valueReservationList;
            ArrayList reservationsToSave;
            List cdkeyLibraryList;
            if (!merchant.getProductSwitch().booleanValue() && product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_EXEMPTION)) {
                product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
            } else {
                product.setAuditStatus(ProductConstants.AUDIT_STATUS_WAIT);
            }
            product.setIsAudit(Boolean.valueOf(false));
            product.setUpdateTime((Date)DateUtil.date());
            this.dao.updateById(product);
            this.productAttributeService.deleteByProductUpdate(product.getId());
            this.productAttributeOptionService.deleteByProductUpdate(product.getId());
            this.productAttrValueService.deleteByProductIdAndType(product.getId(), product.getType(), product.getMarketingType());
            this.cdkeyLibraryService.clearAssociationProduct(product.getId());
            this.productAttrValueSupplementReservationService.deleteByProductId(product.getId());
            this.productAttributeService.saveBatch(attrList);
            attrList.forEach(attr -> {
                List optionList = (List)optionMap.get(attr.getAttributeName());
                optionList.forEach(option -> option.setAttributeId(attr.getId()));
                this.productAttributeOptionService.saveBatch(optionList);
            });
            if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
                this.productSupplementReservationService.saveOrUpdate(productSupplementReservation);
            }
            if (CollUtil.isNotEmpty((Collection)attrValueAddList)) {
                this.productAttrValueService.saveBatch(attrValueAddList);
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                    cdkeyLibraryList = attrValueAddList.stream().map(attrValue -> {
                        CdkeyLibrary cdkeyLibrary = new CdkeyLibrary();
                        cdkeyLibrary.setId(attrValue.getCdkeyId());
                        cdkeyLibrary.setProductId(product.getId());
                        cdkeyLibrary.setProductAttrValueId(attrValue.getId());
                        return cdkeyLibrary;
                    }).collect(Collectors.toList());
                    this.cdkeyLibraryService.updateBatchById(cdkeyLibraryList);
                }
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
                    reservationsToSave = new ArrayList();
                    for (ProductAttrValue attrValue2 : attrValueAddList) {
                        valueReservationList = (List)attrValueReservationMap.get(attrValue2.getSku());
                        valueReservationList.forEach(ar -> ar.setProId(product.getId()).setAttValueId(attrValue2.getId()));
                        reservationsToSave.addAll(valueReservationList);
                    }
                    this.productAttrValueSupplementReservationService.saveBatch(reservationsToSave);
                }
            }
            if (CollUtil.isNotEmpty((Collection)attrValueUpdateList)) {
                this.productAttrValueService.saveOrUpdateBatch(attrValueUpdateList);
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                    cdkeyLibraryList = attrValueUpdateList.stream().map(attrValue -> {
                        CdkeyLibrary cdkeyLibrary = new CdkeyLibrary();
                        cdkeyLibrary.setId(attrValue.getCdkeyId());
                        cdkeyLibrary.setProductId(product.getId());
                        cdkeyLibrary.setProductAttrValueId(attrValue.getId());
                        return cdkeyLibrary;
                    }).collect(Collectors.toList());
                    this.cdkeyLibraryService.updateBatchById(cdkeyLibraryList);
                }
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
                    reservationsToSave = new ArrayList();
                    for (ProductAttrValue attrValue2 : attrValueUpdateList) {
                        valueReservationList = (List)attrValueReservationMap.get(attrValue2.getSku());
                        valueReservationList.forEach(ar -> ar.setProId(product.getId()).setAttValueId(attrValue2.getId()));
                        reservationsToSave.addAll(valueReservationList);
                    }
                    this.productAttrValueSupplementReservationService.saveBatch(reservationsToSave);
                }
            }
            this.productDescriptionService.deleteByProductId(product.getId(), product.getType(), product.getMarketingType());
            this.productDescriptionService.save(spd);
            if (CollUtil.isNotEmpty((Collection)productRequest.getCouponIds())) {
                this.productCouponService.deleteByProductId(product.getId());
                ArrayList<ProductCoupon> couponList = new ArrayList<ProductCoupon>();
                for (Integer couponId : productRequest.getCouponIds()) {
                    ProductCoupon spc = new ProductCoupon();
                    spc.setProductId(product.getId());
                    spc.setCouponId(couponId);
                    spc.setAddTime(CrmebDateUtil.getNowTime());
                    couponList.add(spc);
                }
                this.productCouponService.saveBatch(couponList);
            } else {
                this.productCouponService.deleteByProductId(product.getId());
            }
            if (tempProduct.getSystemFormId().equals(0) && productRequest.getSystemFormId() > 0) {
                this.cartService.productDelete(product.getId());
            }
            if (CollUtil.isNotEmpty((Collection)finalSkuIdList)) {
                this.productAttrValueService.deleteByMasterIdListAndMarktingType(finalSkuIdList, ProductConstants.PRODUCT_MARKETING_TYPE_SECKILL);
                this.groupBuyActivitySkuService.deleteSkusIdsForProductTurnOff(finalSkuIdList);
            }
            if (ProductConstants.AUDIT_STATUS_WAIT.equals(product.getAuditStatus())) {
                this.seckillProductService.downByProductId(product.getId());
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            if (merchant.getProductSwitch().booleanValue() && productRequest.getIsAutoSubmitAudit().booleanValue() && product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT)) {
                LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
                wrapper.set(Product::getIsAudit, (Object)true);
                wrapper.set(Product::getIsShow, (Object)false);
                wrapper.eq(Product::getId, (Object)product.getId());
                return this.update((Wrapper)wrapper);
            }
            if (!merchant.getProductSwitch().booleanValue() && productRequest.getIsAutoUp().booleanValue() && product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_EXEMPTION)) {
                if (!merchant.getIsSwitch().booleanValue()) {
                    this.LOGGER.error("\u5546\u6237\u672a\u5f00\u542f\u65e0\u6cd5\u81ea\u52a8\u4e0a\u67b6\uff0cmerId = {}, proId = {}", (Object)merchant.getId(), (Object)product.getId());
                    return true;
                }
                List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(product.getId(), product.getType(), product.getMarketingType(), false);
                List skuIdList = skuList.stream().map(ProductAttrValue::getId).collect(Collectors.toList());
                LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
                wrapper.set(Product::getIsShow, (Object)true);
                wrapper.eq(Product::getId, (Object)product.getId());
                return (Boolean)this.transactionTemplate.execute(e -> {
                    this.update((Wrapper)wrapper);
                    if (CollUtil.isNotEmpty((Collection)skuIdList)) {
                        this.cartService.productStatusNoEnable(skuIdList);
                    }
                    return Boolean.TRUE;
                });
            }
        }
        return execute;
    }

    @Override
    public ProductInfoResponse getInfo(Integer id, SystemAdmin admin) {
        Product product = (Product)this.dao.selectById(id);
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (ObjectUtil.isNotNull((Object)admin.getMerId()) && admin.getMerId() > 0 && !admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        ProductInfoResponse productInfoResponse = new ProductInfoResponse();
        BeanUtils.copyProperties((Object)product, (Object)productInfoResponse);
        List<ProductAttribute> attrList = this.productAttributeService.findListByProductId(product.getId());
        attrList.forEach(attr -> {
            List<ProductAttributeOption> optionList = this.productAttributeOptionService.findListByAttrId(attr.getId());
            attr.setOptionList(optionList);
        });
        productInfoResponse.setAttrList(attrList);
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
            ProductSupplementReservation productSupplementReservation = this.productSupplementReservationService.getByProId(product.getId());
            ProductSupplementReservationResponse supplementReservationResponse = new ProductSupplementReservationResponse();
            BeanUtils.copyProperties((Object)productSupplementReservation, (Object)supplementReservationResponse);
            productInfoResponse.setSupplementReservation(supplementReservationResponse);
            List<TimeSlot> timeSlotList = this.parseTimeSlotJson(productSupplementReservation.getTimeSlotJson());
            productInfoResponse.setTimeSlotList(timeSlotList);
        }
        List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(product.getId(), product.getType(), product.getMarketingType(), false);
        List valueResponseList = attrValueList.stream().map(e -> {
            AttrValueResponse valueResponse = new AttrValueResponse();
            BeanUtils.copyProperties((Object)e, (Object)valueResponse);
            if (e.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                CdkeyLibrary cdkeyLibrary = this.cdkeyLibraryService.getByIdException(e.getCdkeyId());
                valueResponse.setCdkeyLibraryName(cdkeyLibrary.getName());
            }
            if (e.getType().equals(ProductConstants.PRODUCT_TYPE_RESERVATION)) {
                List<ProductAttrValueSupplementReservation> attrValueReservationList = this.productAttrValueSupplementReservationService.getByProIdAndAttValueId(product.getId(), e.getId());
                ArrayList reservationList = new ArrayList();
                attrValueReservationList.forEach(reservation -> {
                    ProductAttrValueSupplementReservationResponse reservationResponse = new ProductAttrValueSupplementReservationResponse();
                    BeanUtils.copyProperties((Object)reservation, (Object)reservationResponse);
                    reservationList.add(reservationResponse);
                });
                valueResponse.setAttrValueReservationList(reservationList);
            }
            return valueResponse;
        }).collect(Collectors.toList());
        productInfoResponse.setAttrValueList(valueResponseList);
        ProductDescription sd = this.productDescriptionService.getByProductIdAndType(product.getId(), product.getType(), product.getMarketingType());
        productInfoResponse.setContent(sd.getDescription());
        List<ProductCoupon> productCouponList = this.productCouponService.getListByProductId(product.getId());
        if (CollUtil.isNotEmpty(productCouponList)) {
            List<Integer> ids = productCouponList.stream().map(ProductCoupon::getCouponId).collect(Collectors.toList());
            if (admin.getMerId() > 0) {
                productInfoResponse.setCouponIds(ids);
            } else {
                productInfoResponse.setCouponList(this.couponService.findSimpleListByIdList(ids));
            }
        }
        productInfoResponse.setCollectNum(this.productRelationService.getCollectCountByProductId(product.getId()));
        if (StrUtil.isNotBlank((CharSequence)product.getGuaranteeIds())) {
            List<ProductGuarantee> guaranteeList = this.productGuaranteeService.findByIdList(CrmebUtil.stringToArrayForFT((String)product.getGuaranteeIds()));
            productInfoResponse.setGuaranteeList(guaranteeList);
        }
        if (product.getSystemFormId() > 0) {
            SystemForm systemForm = (SystemForm)this.systemFormService.getById(product.getSystemFormId());
            productInfoResponse.setSystemFormValue(systemForm.getFormValue());
        }
        return productInfoResponse;
    }

    @Override
    public List<ProductTabsHeaderResponse> getTabsHeader(MerProductTabsHeaderRequest request, SystemAdmin systemAdmin) {
        ArrayList<ProductTabsHeaderResponse> headers = new ArrayList<ProductTabsHeaderResponse>();
        ProductTabsHeaderResponse header1 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(1));
        ProductTabsHeaderResponse header2 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(2));
        ProductTabsHeaderResponse header3 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(3));
        ProductTabsHeaderResponse header4 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(4));
        ProductTabsHeaderResponse header5 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(5));
        ProductTabsHeaderResponse header6 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(6));
        ProductTabsHeaderResponse header7 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(7));
        ProductTabsHeaderResponse header8 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(8));
        headers.add(header1);
        headers.add(header2);
        headers.add(header3);
        headers.add(header4);
        headers.add(header5);
        headers.add(header6);
        headers.add(header7);
        headers.add(header8);
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        for (ProductTabsHeaderResponse h : headers) {
            lqw.clear();
            lqw.eq(Product::getMerId, (Object)systemAdmin.getMerId());
            this.setAdminListWrapperByType((LambdaQueryWrapper<Product>)lqw, h.getType(), systemAdmin.getMerId());
            if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
                String keywords = URLUtil.decode((String)request.getKeywords());
                lqw.and(i -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Product::getName, (Object)keywords)).or()).apply(" find_in_set({0}, keyword)", new Object[]{keywords});
                });
            }
            if (StrUtil.isNotBlank((CharSequence)request.getCateId())) {
                Integer cateId = Integer.valueOf(request.getCateId());
                lqw.apply("FIND_IN_SET ({0}, cate_id)", new Object[]{cateId});
            }
            if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
                lqw.eq(Product::getCategoryId, (Object)request.getCategoryId());
            }
            if (ObjectUtil.isNotNull((Object)request.getIsPaidMember())) {
                lqw.eq(Product::getIsPaidMember, (Object)request.getIsPaidMember());
            }
            if (ObjectUtil.isNotNull((Object)request.getProductType())) {
                lqw.eq(Product::getType, (Object)request.getProductType());
            }
            h.setCount(this.dao.selectCount((Wrapper)lqw));
        }
        return headers;
    }

    private void setAdminListWrapperByType(LambdaQueryWrapper<Product> lqw, Integer type, Integer merId) {
        switch (type) {
            case 1: {
                lqw.eq(Product::getIsShow, (Object)true);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_SUCCESS, ProductConstants.AUDIT_STATUS_EXEMPTION});
                break;
            }
            case 2: {
                lqw.eq(Product::getIsShow, (Object)false);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                lqw.eq(Product::getIsAudit, (Object)false);
                lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_EXEMPTION, ProductConstants.AUDIT_STATUS_SUCCESS});
                break;
            }
            case 3: {
                lqw.le(Product::getStock, (Object)0);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_SUCCESS, ProductConstants.AUDIT_STATUS_EXEMPTION});
                break;
            }
            case 4: {
                MerchantInfo merchantInfo = this.merchantInfoService.getByMerId(merId);
                lqw.le(Product::getStock, (Object)(ObjectUtil.isNotNull((Object)merchantInfo) ? merchantInfo.getAlertStock() : 0));
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_SUCCESS, ProductConstants.AUDIT_STATUS_EXEMPTION});
                break;
            }
            case 5: {
                lqw.eq(Product::getIsRecycle, (Object)true);
                lqw.eq(Product::getIsDel, (Object)false);
                break;
            }
            case 6: {
                lqw.eq(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
                lqw.eq(Product::getIsAudit, (Object)true);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                break;
            }
            case 7: {
                lqw.eq(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_FAIL);
                lqw.eq(Product::getIsAudit, (Object)false);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                break;
            }
            case 8: {
                lqw.eq(Product::getIsShow, (Object)false);
                lqw.eq(Product::getIsRecycle, (Object)false);
                lqw.eq(Product::getIsDel, (Object)false);
                lqw.eq(Product::getIsAudit, (Object)false);
                lqw.eq(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
                break;
            }
        }
    }

    @Override
    public ProductResponseForCopyProduct importProductFrom99Api(String url, int tag, SystemAdmin admin) throws JSONException {
        Merchant merchant = this.merchantService.getByIdException(admin.getMerId());
        if (merchant.getCopyProductNum() <= 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u6237\u590d\u5236\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
        }
        ProductResponseForCopyProduct copyProduct = null;
        try {
            switch (tag) {
                case 1: {
                    copyProduct = this.productUtils.getTaobaoProductInfo99Api(url, tag);
                    break;
                }
                case 2: {
                    copyProduct = this.productUtils.getJDProductInfo99Api(url, tag);
                    break;
                }
                case 3: {
                    copyProduct = this.productUtils.getSuningProductInfo99Api(url, tag);
                    break;
                }
                case 4: {
                    copyProduct = this.productUtils.getPddProductInfo99Api(url, tag);
                    break;
                }
                case 5: {
                    copyProduct = this.productUtils.getTmallProductInfo99Api(url, tag);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CrmebException("\u786e\u8ba4URL\u548c\u5e73\u53f0\u662f\u5426\u6b63\u786e\uff0c\u4ee5\u53ca\u5e73\u53f0\u8d39\u7528\u662f\u5426\u8db3\u989d" + e.getMessage());
        }
        Boolean sub = this.merchantService.subCopyProductNum(merchant.getId());
        if (!sub.booleanValue()) {
            this.LOGGER.error("\u6263\u9664\u5546\u6237\u590d\u5236\u6761\u6570\u5f02\u5e38\uff1a\u5546\u6237ID = {}", (Object)merchant.getId());
        }
        return copyProduct;
    }

    @Override
    public Boolean deleteProduct(ProductDeleteRequest request, SystemAdmin admin) {
        Product product = (Product)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)product) || !admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if ("recycle".equals(request.getType()) && product.getIsRecycle().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_RECYCLE);
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(Product::getId, (Object)product.getId());
        if ("delete".equals(request.getType())) {
            wrapper.set(Product::getIsDel, (Object)true);
        } else {
            wrapper.set(Product::getIsRecycle, (Object)true);
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)wrapper);
            if (request.getType().equals("recycle")) {
                this.cartService.productStatusNotEnable(request.getId());
            } else {
                this.cartService.productDelete(request.getId());
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                    this.cdkeyLibraryService.clearAssociationProduct(product.getId());
                }
            }
            if ("delete".equals(request.getType())) {
                this.seckillProductService.deleteByProductId(product.getId());
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean restoreProduct(Integer productId, SystemAdmin admin) {
        CrmebUtil.getNowTimeForFT();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(Product::getIsRecycle, (Object)false);
        wrapper.set(Product::getIsShow, (Object)false);
        wrapper.eq(Product::getId, (Object)productId);
        wrapper.eq(Product::getMerId, (Object)admin.getMerId());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean operationStock(Integer id, Integer num, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("quick")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
        }
        if (type.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock + {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales - {}", (Object[])new Object[]{num}));
        }
        if (type.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)" and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        if (type.equals("delete")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"stock = stock - {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)" and (stock - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u666e\u901a\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u5546\u54c1id = " + id);
        }
        return update;
    }

    @Override
    public Boolean operationSales(Integer id, Integer num, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
        }
        if (type.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales - {}", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u666e\u901a\u5546\u54c1\u9500\u91cf\u5931\u8d25,\u5546\u54c1id = " + id);
        }
        return update;
    }

    @Override
    public Boolean offShelf(Integer id, SystemAdmin admin) {
        Product product = (Product)this.getById(id);
        if (ObjectUtil.isNull((Object)product) || !admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (!product.getIsShow().booleanValue()) {
            return true;
        }
        product.setIsShow(Boolean.valueOf(false));
        CrmebUtil.setBusinessDataForFT((int)this.orderService.getAMC(), (int)this.orderService.getAPC(), (int)this.orderService.getAOC());
        product.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.updateById(product);
            this.cartService.productStatusNotEnable(id);
            this.productRelationService.deleteByProId(product.getId());
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean putOnShelf(Integer id, SystemAdmin admin) {
        Product product = (Product)this.getById(id);
        if (ObjectUtil.isNull((Object)product) || !admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (product.getIsShow().booleanValue()) {
            return true;
        }
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
        }
        if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_EXEMPTION) && !product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_SUCCESS)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION);
        }
        Merchant merchant = (Merchant)this.merchantService.getById(admin.getMerId());
        if (!merchant.getIsSwitch().booleanValue()) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_SWITCH_CLOSE);
        }
        product.setIsShow(Boolean.valueOf(true));
        CrmebUtil.setBusinessDataForFT((int)this.orderService.getAMC(), (int)this.orderService.getAPC(), (int)this.orderService.getAOC());
        product.setUpdateTime((Date)DateUtil.date());
        List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(id, product.getType(), product.getMarketingType(), false);
        List skuIdList = skuList.stream().map(ProductAttrValue::getId).collect(Collectors.toList());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.updateById(product);
            if (CollUtil.isNotEmpty((Collection)skuIdList)) {
                this.cartService.productStatusNoEnable(skuIdList);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public PageInfo<Product> getIndexProduct(Integer cid, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getImage, Product::getName, Product::getUnitName, Product::getPrice, Product::getOtPrice, Product::getSales, Product::getFicti, Product::getCategoryId, Product::getBrandId, Product::getIsPaidMember, Product::getVipPrice, Product::getStock});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.gt(Product::getStock, (Object)0);
        if (cid > 0) {
            List<ProductCategory> categoryList = this.productCategoryService.getThirdCategoryByFirstId(cid, 0);
            if (CollUtil.isEmpty(categoryList)) {
                return new PageInfo();
            }
            List cidList = categoryList.stream().map(ProductCategory::getId).collect(Collectors.toList());
            lqw.in(Product::getCategoryId, cidList);
        }
        lqw.in(Product::getType, new Object[]{ProductConstants.PRODUCT_TYPE_NORMAL, ProductConstants.PRODUCT_TYPE_VIRTUALLY, ProductConstants.PRODUCT_TYPE_CLOUD, ProductConstants.PRODUCT_TYPE_CDKEY, ProductConstants.PRODUCT_TYPE_RESERVATION});
        lqw.eq(Product::getMarketingType, (Object)ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        lqw.orderByDesc(Product::getRank);
        lqw.orderByDesc(Product::getId);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<Product> productList = this.dao.selectList((Wrapper)lqw);
        productList = this.activityStyleService.makeActivityBorderStyle(productList);
        return CommonPage.copyPageInfo((Page)page, productList);
    }

    private void getForSaleWhere(LambdaQueryWrapper<Product> lqw) {
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.eq(Product::getIsRecycle, (Object)false);
        lqw.eq(Product::getIsShow, (Object)true);
        lqw.in(Product::getAuditStatus, new Object[]{ProductConstants.AUDIT_STATUS_SUCCESS, ProductConstants.AUDIT_STATUS_EXEMPTION});
        lqw.eq(Product::getMarketingType, (Object)ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
    }

    @Override
    public PageInfo<ProductFrontResponse> findH5List(ProductFrontSearchRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringJoiner brandIds = new StringJoiner(",");
        StringJoiner merIds = new StringJoiner(",");
        StringJoiner categoryIds = new StringJoiner(",");
        if (ObjectUtil.isNotNull((Object)request.getCid()) && !request.getCid().isEmpty()) {
            categoryIds.add(request.getCid());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeyword())) {
            String keyword = URLUtil.decode((String)request.getKeyword());
            map.put("keywords", keyword);
        }
        if (ObjectUtil.isNotNull((Object)request.getMaxPrice())) {
            map.put("maxPrice", request.getMaxPrice());
        }
        if (ObjectUtil.isNotNull((Object)request.getMinPrice())) {
            map.put("minPrice", request.getMinPrice());
        }
        if (ObjectUtil.isNotNull((Object)request.getBrandId()) && !request.getBrandId().isEmpty()) {
            brandIds.add(request.getBrandId());
        }
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && !request.getMerId().isEmpty()) {
            merIds.add(request.getMerId());
        }
        if (ObjectUtil.isNotNull((Object)request.getTagId())) {
            ProductTagsForSearchResponse tagSearchConfig = this.productTagService.getProductIdListByProductTagId(request.getTagId());
            if (CollUtil.isNotEmpty((Collection)tagSearchConfig.getProductIds())) {
                map.put("id", tagSearchConfig.getProductIds().stream().map(Objects::toString).collect(Collectors.joining(",")));
            }
            if (ObjectUtil.isNotNull((Object)tagSearchConfig.getBrandId())) {
                brandIds.add(tagSearchConfig.getBrandId().stream().map(Objects::toString).collect(Collectors.joining(",")));
            }
            if (ObjectUtil.isNotNull((Object)tagSearchConfig.getMerId())) {
                merIds.add(tagSearchConfig.getMerId().stream().map(Objects::toString).collect(Collectors.joining(",")));
            }
            if (ObjectUtil.isNotNull((Object)tagSearchConfig.getCategoryId())) {
                categoryIds.add(tagSearchConfig.getCategoryId().stream().map(Objects::toString).collect(Collectors.joining(",")));
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)brandIds.toString())) {
            map.put("brandId", brandIds.toString());
        }
        if (StrUtil.isNotEmpty((CharSequence)merIds.toString())) {
            map.put("merId", merIds.toString());
        }
        if (StrUtil.isNotEmpty((CharSequence)categoryIds.toString())) {
            map.put("categoryId", categoryIds.toString());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSalesOrder())) {
            if (request.getSalesOrder().equals("desc")) {
                map.put("lastStr", " order by (p.sales + p.ficti) desc, p.rank desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by (p.sales + p.ficti) asc, p.rank desc, p.sort desc, p.id desc");
            }
        } else if (StrUtil.isNotBlank((CharSequence)request.getPriceOrder())) {
            if (request.getPriceOrder().equals("desc")) {
                map.put("lastStr", " order by p.price desc, p.rank desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by p.price asc, p.rank desc, p.sort desc, p.id desc");
            }
        } else {
            map.put("lastStr", " order by p.rank desc, p.sort desc, p.id desc");
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<ProductFrontResponse> responseList = this.dao.findH5List(map);
        if (CollUtil.isEmpty(responseList)) {
            return CommonPage.copyPageInfo((Page)page, responseList);
        }
        responseList.forEach(e -> {
            Integer sumCount = this.productReplyService.getCountByScore(e.getId(), "all");
            Integer goodCount = this.productReplyService.getCountByScore(e.getId(), "good");
            ProductTagsFrontResponse productTagsFrontResponse = this.productTagService.setProductTagByProductTagsRules(e.getId(), e.getBrandId(), e.getMerId(), e.getCategoryId(), e.getProductTags());
            e.setProductTags(productTagsFrontResponse);
            String replyChance = "0";
            if (sumCount > 0 && goodCount > 0) {
                replyChance = String.format("%.2f", goodCount.doubleValue() / sumCount.doubleValue());
            }
            e.setReplyNum(sumCount);
            e.setPositiveRatio(replyChance);
            e.setSales(Integer.valueOf(e.getSales() + e.getFicti()));
        });
        ArrayList<Product> products = new ArrayList<Product>();
        responseList.forEach(response -> {
            Product product = new Product();
            BeanUtils.copyProperties((Object)response, (Object)product);
            products.add(product);
        });
        List<Product> makeProductList = this.activityStyleService.makeActivityBorderStyle(products);
        makeProductList.forEach(p -> responseList.stream().map(resProduct -> {
            if (p.getId().equals(resProduct.getId())) {
                resProduct.setActivityStyle(p.getActivityStyle());
            }
            return resProduct;
        }).collect(Collectors.toList()));
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Product getH5Detail(Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getImage, Product::getName, Product::getSliderImage, Product::getOtPrice, Product::getStock, Product::getSales, Product::getPrice, Product::getIntro, Product::getCost, Product::getFicti, Product::getBrowse, Product::getUnitName, Product::getGuaranteeIds, Product::getBrandId, Product::getCategoryId, Product::getType, Product::getIsPaidMember, Product::getVipPrice, Product::getMarketingType, Product::getSystemFormId, Product::getDeliveryMethod, Product::getRedeemIntegral, Product::getExchangeNum});
        lqw.eq(Product::getId, (Object)id);
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        Product product = (Product)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)product)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST.setMessage(StrUtil.format((CharSequence)"\u6ca1\u6709\u627e\u5230ID\uff1a {} \u7684\u5546\u54c1", (Object[])new Object[]{id})));
        }
        ProductDescription sd = this.productDescriptionService.getByProductIdAndType(product.getId(), product.getType(), product.getMarketingType());
        if (ObjectUtil.isNotNull((Object)sd)) {
            product.setContent(StrUtil.isBlank((CharSequence)sd.getDescription()) ? "" : sd.getDescription());
        }
        return product;
    }

    @Override
    public Product getCartByProId(Integer productId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getImage, Product::getName, Product::getType, Product::getIsPaidMember, Product::getDeliveryMethod});
        lqw.eq(Product::getId, (Object)productId);
        return (Product)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public Integer getNewProductByDate(String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)0);
        lqw.apply("date_format(create_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public List<Product> findAllProductByNotDelete() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId});
        lqw.eq(Product::getIsDel, (Object)0);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Product> likeProductName(String productName, Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.like(Product::getName, (Object)productName);
        lqw.eq(Product::getIsDel, (Object)0);
        if (!merId.equals(0)) {
            lqw.eq(Product::getMerId, (Object)merId);
        }
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getOnSaleNum(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(Product::getMerId, (Object)merId);
        }
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Integer getOnSaleNumByMerIds(List<Integer> openMerIds) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(Product::getMerId, openMerIds);
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean forcedRemovalAll(Integer merchantId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getIsShow, (Object)false);
        wrapper.set(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
        wrapper.eq(Product::getMerId, (Object)merchantId);
        wrapper.eq(Product::getIsDel, (Object)false);
        wrapper.ne(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_FAIL);
        boolean update = this.update((Wrapper)wrapper);
        if (!update) {
            return update;
        }
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.select(new SFunction[]{Product::getId});
        query.eq(Product::getMerId, (Object)merchantId);
        query.eq(Product::getIsDel, (Object)false);
        List productList = this.dao.selectList((Wrapper)query);
        productList.forEach(product -> {
            this.cartService.productStatusNotEnable(product.getId());
            this.productRelationService.deleteByProId(product.getId());
        });
        return true;
    }

    @Override
    public PageInfo<PlatformProductListResponse> getPlatformPageList(PlatProductSearchRequest request) {
        HashMap map = CollUtil.newHashMap();
        map.put("type", request.getType());
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            ProductCategory category = (ProductCategory)this.productCategoryService.getById(request.getCategoryId());
            if (category.getLevel().equals(3)) {
                map.put("categoryIds", request.getCategoryId());
            } else {
                List<ProductCategory> categoryList = this.productCategoryService.findAllChildListByPid(category.getId(), category.getLevel());
                List cateIdList = categoryList.stream().filter(e -> e.getLevel().equals(3)).map(e -> e.getId().toString()).collect(Collectors.toList());
                String categoryIds = String.join((CharSequence)",", cateIdList);
                map.put("categoryIds", categoryIds);
            }
        }
        if (ObjectUtil.isNotNull((Object)request.getMerId())) {
            map.put("merId", request.getMerId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsSelf())) {
            map.put("self", request.getIsSelf());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            map.put("keywords", keywords);
        }
        if (ObjectUtil.isNotNull((Object)request.getIsPaidMember())) {
            map.put("isPaidMember", request.getIsPaidMember() != false ? 1 : 0);
        }
        if (ObjectUtil.isNotNull((Object)request.getProductType())) {
            map.put("productType", request.getProductType());
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<PlatformProductListResponse> proList = this.dao.getPlatformPageList(map);
        return CommonPage.copyPageInfo((Page)page, proList);
    }

    private List<PlatformProductListResponse> getPlatformListForIds(List<Integer> ids) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(Product::getIsDel, (Object)Boolean.FALSE);
        lambdaQueryWrapper.in(Product::getId, ids);
        lambdaQueryWrapper.eq(Product::getMarketingType, (Object)ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        List products = this.dao.selectList((Wrapper)lambdaQueryWrapper);
        List<PlatformProductListResponse> platformProductListResponses = this.productListToPlatFromProductListResponse(products);
        return platformProductListResponses;
    }

    @Override
    public List<PlatformProductListResponse> getPlatformListForIdsByLimit(List<Integer> ids) {
        if (this.crmebConfig.getSelectProductLimit() < ids.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6307\u5b9a\u5546\u54c1\u4e0a\u9650\uff1a" + this.crmebConfig.getSelectProductLimit());
        }
        return this.getPlatformListForIds(ids);
    }

    @Override
    public Boolean audit(ProductAuditRequest request) {
        if (request.getAuditStatus().equals("fail") && StrUtil.isEmpty((CharSequence)request.getReason())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5ba1\u6838\u62d2\u7edd\u8bf7\u586b\u5199\u62d2\u7edd\u539f\u56e0");
        }
        Product product = this.getByIdException(request.getId());
        if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION);
        }
        if (!product.getIsAudit().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION);
        }
        if (request.getAuditStatus().equals("fail")) {
            product.setAuditStatus(ProductConstants.AUDIT_STATUS_FAIL);
            product.setReason(request.getReason());
            product.setIsAudit(Boolean.valueOf(false));
            product.setIsShow(Boolean.valueOf(false));
            product.setIsAutoUp(Boolean.valueOf(false));
            product.setUpdateTime((Date)DateUtil.date());
            return this.updateById(product);
        }
        product.setAuditStatus(ProductConstants.AUDIT_STATUS_SUCCESS);
        Merchant merchant = this.merchantService.getByIdException(product.getMerId());
        if (!merchant.getProductSwitch().booleanValue()) {
            product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
        }
        product.setIsAudit(Boolean.valueOf(false));
        product.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            if (merchant.getIsSwitch().booleanValue() && product.getIsAutoUp().booleanValue()) {
                product.setIsShow(Boolean.valueOf(true));
                product.setIsAutoUp(Boolean.valueOf(false));
                List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(product.getId(), product.getType(), product.getMarketingType(), false);
                List<Integer> skuIdList = skuList.stream().map(ProductAttrValue::getId).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(skuIdList)) {
                    this.cartService.productStatusNoEnable(skuIdList);
                }
                this.updateById(product);
            } else {
                product.setIsAutoUp(Boolean.valueOf(false));
                product.setIsShow(Boolean.valueOf(false));
                this.updateById(product);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean forceDown(ProductForceDownRequest request) {
        String ids = request.getIds();
        List idList = Stream.of(ids.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getIsShow, (Object)false);
        wrapper.set(Product::getIsAudit, (Object)false);
        wrapper.set(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
        wrapper.in(Product::getId, idList);
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.update((Wrapper)wrapper);
            if (update) {
                idList.forEach(id -> {
                    this.cartService.productStatusNotEnable((Integer)id);
                    this.productRelationService.deleteByProId((Integer)id);
                });
                this.seckillProductService.downByProductIdList(idList);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean isExistStoreCategory(Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.apply(" find_in_set({0}, cate_id)", new Object[]{id});
        lqw.last(" limit 1");
        Product Product2 = (Product)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)Product2);
    }

    @Override
    public Boolean addBrowse(Integer proId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.setSql("browse = browse + 1");
        wrapper.eq(Product::getId, (Object)proId);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<ProMerchantProductResponse> getRecommendedProductsByMerId(Integer merId, Integer num) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getImage, Product::getName, Product::getPrice, Product::getSales, Product::getFicti, Product::getStock});
        lqw.eq(Product::getMerId, (Object)merId);
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.orderByDesc(Product::getSort);
        lqw.last("limit " + num);
        List productList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)productList)) {
            return CollUtil.newArrayList((Object[])new ProMerchantProductResponse[0]);
        }
        return productList.stream().map(product -> {
            ProMerchantProductResponse response = new ProMerchantProductResponse();
            BeanUtils.copyProperties((Object)product, (Object)response);
            return response;
        }).collect(Collectors.toList());
    }

    @Override
    public PageInfo<Product> findMerchantProH5List(MerchantProductSearchRequest request) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getImage, Product::getPrice, Product::getOtPrice, Product::getSales, Product::getFicti, Product::getUnitName, Product::getStock, Product::getMerId, Product::getCategoryId, Product::getBrandId, Product::getVipPrice, Product::getIsPaidMember});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.eq(Product::getMerId, (Object)request.getMerId());
        if (StrUtil.isNotBlank((CharSequence)request.getKeyword())) {
            String keyword = URLUtil.decode((String)request.getKeyword());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Product::getName, (Object)keyword)).or()).like(Product::getKeyword, (Object)keyword);
            });
        }
        if (StrUtil.isNotBlank((CharSequence)request.getCids())) {
            String cateIdSql = CrmebUtil.getFindInSetSqlForFT((String)"cate_id", (String)request.getCids());
            lqw.apply(cateIdSql, new Object[0]);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getProIds())) {
            List proIdList = CrmebUtil.stringToArray((String)request.getProIds());
            lqw.in(Product::getId, (Collection)proIdList);
            request.setLimit(proIdList.size());
        }
        if (ObjectUtil.isNotNull((Object)request.getMaxPrice())) {
            lqw.le(Product::getPrice, (Object)request.getMaxPrice());
        }
        if (ObjectUtil.isNotNull((Object)request.getMinPrice())) {
            lqw.ge(Product::getPrice, (Object)request.getMinPrice());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSalesOrder())) {
            if (request.getSalesOrder().equals("desc")) {
                lqw.last(" order by (sales + ficti) desc, sort desc, id desc");
            } else {
                lqw.last(" order by (sales + ficti) asc, sort desc, id desc");
            }
        } else if (StrUtil.isNotBlank((CharSequence)request.getPriceOrder())) {
            if (request.getPriceOrder().equals("desc")) {
                lqw.last(" order by price desc, sort desc, id desc");
            } else {
                lqw.last(" order by price asc, sort desc, id desc");
            }
        } else {
            lqw.orderByDesc(Product::getSort);
            lqw.orderByDesc(Product::getId);
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List productList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public Boolean isUseBrand(Integer brandId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.eq(Product::getBrandId, (Object)brandId);
        lqw.last("limit 1");
        Product Product2 = (Product)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)Product2);
    }

    @Override
    public Boolean isUsePlatformCategory(Integer categoryId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.eq(Product::getCategoryId, (Object)categoryId);
        lqw.last("limit 1");
        Product Product2 = (Product)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)Product2);
    }

    @Override
    public List<Product> findUseGuarantee(Integer gid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.apply(" find_in_set({0}, guarantee_ids)", new Object[]{gid});
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean isUseGuarantee(Integer gid) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId});
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.apply(" find_in_set({0}, guarantee_ids)", new Object[]{gid});
        lqw.last("limit 1");
        Product Product2 = (Product)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)Product2);
    }

    @Override
    public Integer getAwaitAuditNum(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
        lqw.eq(Product::getIsAudit, (Object)true);
        lqw.eq(Product::getIsRecycle, (Object)false);
        lqw.eq(Product::getIsDel, (Object)false);
        this.setAdminListWrapperByType((LambdaQueryWrapper<Product>)lqw, 6, merId);
        if (merId > 0) {
            lqw.eq(Product::getMerId, (Object)merId);
        }
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public Boolean downByMerId(Integer merId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getIsShow, (Object)false);
        wrapper.eq(Product::getMerId, (Object)merId);
        wrapper.eq(Product::getIsShow, (Object)true);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageInfo<Product> getCouponProList(CouponProductSearchRequest request) {
        Coupon coupon;
        Integer userId = this.userService.getUserIdException();
        CouponUser couponUser = (CouponUser)this.couponUserService.getById(request.getUserCouponId());
        if (ObjectUtil.isNull((Object)couponUser) || !couponUser.getUid().equals(userId) || couponUser.getStatus() > CouponConstants.STORE_COUPON_USER_STATUS_USABLE) {
            throw new CrmebException((IResultEnum)CouponResultCode.COUPON_NOT_EXIST.setMessage("\u4f18\u60e0\u5238\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u672a\u4f7f\u7528\u72b6\u6001"));
        }
        List pidList = null;
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT)) {
            List<CouponProduct> cpList = this.couponProductService.findByCid(couponUser.getCouponId());
            if (CollUtil.isEmpty(cpList)) {
                throw new CrmebException((IResultEnum)CouponResultCode.COUPON_PRODUCT_NOT_EXIST);
            }
            pidList = cpList.stream().map(CouponProduct::getPid).collect(Collectors.toList());
        }
        if (ObjectUtil.isNull((Object)(coupon = (Coupon)this.couponService.getById(couponUser.getCouponId())))) {
            throw new CrmebException((IResultEnum)CouponResultCode.COUPON_NOT_EXIST);
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getImage, Product::getPrice, Product::getOtPrice, Product::getSales, Product::getFicti, Product::getUnitName, Product::getStock, Product::getMerId, Product::getVipPrice, Product::getIsPaidMember});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.ne(Product::getType, (Object)ProductConstants.PRODUCT_TYPE_INTEGRAL);
        lqw.eq(Product::getMarketingType, (Object)ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        if (StrUtil.isNotBlank((CharSequence)request.getKeyword())) {
            String decode = URLUtil.decode((String)request.getKeyword());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Product::getName, (Object)decode)).or()).like(Product::getKeyword, (Object)decode);
            });
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_MERCHANT)) {
            lqw.eq(Product::getMerId, (Object)couponUser.getMerId());
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT) && CollUtil.isNotEmpty(pidList)) {
            lqw.in(Product::getId, pidList);
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_PRODUCT_CATEGORY)) {
            ProductCategory productCategory = (ProductCategory)this.productCategoryService.getById(Integer.valueOf(coupon.getLinkedData()));
            ArrayList<Integer> pcIdList = new ArrayList<Integer>();
            if (productCategory.getLevel().equals(3)) {
                pcIdList.add(productCategory.getId());
            } else {
                List<Object> productCategoryList = new ArrayList();
                if (productCategory.getLevel().equals(2)) {
                    productCategoryList = this.productCategoryService.findAllChildListByPid(productCategory.getId(), productCategory.getLevel());
                }
                if (productCategory.getLevel().equals(1)) {
                    productCategoryList = this.productCategoryService.getThirdCategoryByFirstId(productCategory.getId(), 0);
                }
                List collect = productCategoryList.stream().map(ProductCategory::getId).collect(Collectors.toList());
                pcIdList.addAll(collect);
            }
            lqw.in(Product::getCategoryId, pcIdList);
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_BRAND)) {
            lqw.eq(Product::getBrandId, (Object)Integer.valueOf(coupon.getLinkedData()));
        }
        if (couponUser.getCategory().equals(CouponConstants.COUPON_CATEGORY_JOINT_MERCHANT)) {
            lqw.in(Product::getMerId, new Object[]{coupon.getLinkedData()});
        }
        lqw.orderByDesc(Product::getSort);
        lqw.orderByDesc(Product::getId);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List productList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public List<ProductTabsHeaderResponse> getPlatformTabsHeader(PlatProductTabsHeaderRequest request) {
        ArrayList<ProductTabsHeaderResponse> headers = new ArrayList<ProductTabsHeaderResponse>();
        ProductTabsHeaderResponse header1 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(1));
        ProductTabsHeaderResponse header2 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(2));
        ProductTabsHeaderResponse header6 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(6));
        ProductTabsHeaderResponse header7 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(7));
        headers.add(header1);
        headers.add(header2);
        headers.add(header6);
        headers.add(header7);
        HashMap map = CollUtil.newHashMap();
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            ProductCategory category = (ProductCategory)this.productCategoryService.getById(request.getCategoryId());
            if (category.getLevel().equals(3)) {
                map.put("categoryIds", request.getCategoryId());
            } else {
                List<ProductCategory> categoryList = this.productCategoryService.findAllChildListByPid(category.getId(), category.getLevel());
                List cateIdList = categoryList.stream().filter(e -> e.getLevel().equals(3)).map(e -> e.getId().toString()).collect(Collectors.toList());
                String categoryIds = String.join((CharSequence)",", cateIdList);
                map.put("categoryIds", categoryIds);
            }
        }
        if (ObjectUtil.isNotNull((Object)request.getMerId())) {
            map.put("merId", request.getMerId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsSelf())) {
            map.put("self", request.getIsSelf());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            map.put("keywords", keywords);
        }
        if (ObjectUtil.isNotNull((Object)request.getIsPaidMember())) {
            map.put("isPaidMember", request.getIsPaidMember() != false ? 1 : 0);
        }
        if (ObjectUtil.isNotNull((Object)request.getProductType())) {
            map.put("productType", request.getProductType());
        }
        for (ProductTabsHeaderResponse h : headers) {
            map.put("type", h.getType());
            h.setCount(this.dao.getPlatformPageCount(map));
        }
        return headers;
    }

    @Override
    public Boolean platUpdate(ProductPlatUpdateRequest request) {
        Product product = this.getByIdException(request.getId());
        if (product.getFicti().equals(request.getFicti()) && product.getRank().equals(request.getRank())) {
            return Boolean.TRUE;
        }
        CrmebUtil.getNowTimeForFT();
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getFicti, (Object)request.getFicti());
        wrapper.set(Product::getRank, (Object)request.getRank());
        wrapper.eq(Product::getId, (Object)request.getId());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean isUseShippingTemplateId(Integer templateId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Product::getTempId, (Object)templateId);
        lqw.eq(Product::getIsDel, (Object)false);
        return this.dao.selectCount((Wrapper)lqw) > 0;
    }

    @Override
    public Boolean submitAudit(ProductSubmitAuditRequest request, SystemAdmin admin) {
        Product product = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
        }
        if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION);
        }
        if (product.getIsRecycle().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_RECYCLE);
        }
        CrmebUtil.getNowTimeForFT();
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getIsAudit, (Object)true);
        wrapper.set(Product::getIsShow, (Object)false);
        wrapper.set(Product::getIsAutoUp, (Object)request.getIsAutoUp());
        wrapper.eq(Product::getId, (Object)request.getId());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean quickAddStock(ProductAddStockRequest request, SystemAdmin admin) {
        Product product = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
        }
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_NOT_QUICK_ADD);
        }
        List valueStockList = request.getAttrValueList();
        List<Integer> attrIdList = valueStockList.stream().map(ProductAttrValueAddStockRequest::getId).distinct().collect(Collectors.toList());
        if (attrIdList.size() != valueStockList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u6709\u91cd\u590d\u7684\u5546\u54c1\u89c4\u683c\u5c5e\u6027ID");
        }
        List<ProductAttrValue> valueList = this.productAttrValueService.getByProductIdAndAttrIdList(request.getId(), attrIdList, product.getType(), product.getMarketingType());
        if (CollUtil.isEmpty(valueList) || valueList.size() != attrIdList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u89c4\u683c\u5c5e\u6027ID\u6570\u7ec4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5");
        }
        block0: for (ProductAttrValueAddStockRequest value : valueStockList) {
            for (ProductAttrValue attrValue : valueList) {
                if (!attrValue.getId().equals(value.getId())) continue;
                value.setVersion(attrValue.getVersion());
                continue block0;
            }
        }
        int totalStock = valueStockList.stream().mapToInt(ProductAttrValueAddStockRequest::getStock).sum();
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.operationStock(product.getId(), totalStock, "quick");
            valueStockList.forEach(valueStock -> this.productAttrValueService.operationStock(valueStock.getId(), valueStock.getStock(), "quick", product.getType(), product.getMarketingType(), valueStock.getVersion()));
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean reviewFreeEdit(ProductReviewFreeEditRequest request, SystemAdmin admin) {
        List cdkIdList;
        Product product = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (product.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_IS_SHOW);
        }
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
        }
        List attrValueRequestList = request.getAttrValue();
        List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(product.getId(), product.getType(), product.getMarketingType(), false);
        if (CollUtil.isEmpty(attrValueList) || attrValueList.size() != attrValueRequestList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY) && (cdkIdList = attrValueRequestList.stream().map(ProductAttrValueReviewFreeEditRequest::getCdkeyId).distinct().collect(Collectors.toList())).size() != attrValueRequestList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5361\u5bc6\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u4e2d\u6709\u91cd\u590d\u7684\u5361\u5bc6\u5e93");
        }
        ArrayList cdkeyIdUpdateList = new ArrayList();
        ArrayList cdkeyBingingList = new ArrayList();
        attrValueList.forEach(attrValue -> {
            for (ProductAttrValueReviewFreeEditRequest attrValueRequest : attrValueRequestList) {
                if (!attrValueRequest.getId().equals(attrValue.getId())) continue;
                attrValue.setPrice(attrValueRequest.getPrice());
                attrValue.setVersion(Integer.valueOf(0));
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CLOUD)) {
                    attrValue.setExpand(attrValueRequest.getExpand());
                }
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                    if (attrValue.getCdkeyId().equals(attrValueRequest.getCdkeyId())) break;
                    cdkeyIdUpdateList.add(attrValue.getCdkeyId());
                    CdkeyLibrary cdkeyLibrary = this.cdkeyLibraryService.getByIdException(attrValueRequest.getCdkeyId());
                    if (!admin.getMerId().equals(cdkeyLibrary.getMerId())) {
                        throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
                    }
                    if (cdkeyLibrary.getProductId() > 0 && cdkeyLibrary.getProductId().equals(product.getId())) {
                        throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_INTERACTION);
                    }
                    attrValue.setStock(Integer.valueOf(cdkeyLibrary.getTotalNum() - cdkeyLibrary.getUsedNum()));
                    attrValue.setCdkeyId(attrValueRequest.getCdkeyId());
                    CdkeyLibrary newCdkeyLibrary = new CdkeyLibrary();
                    newCdkeyLibrary.setId(attrValueRequest.getCdkeyId());
                    newCdkeyLibrary.setProductId(product.getId());
                    newCdkeyLibrary.setProductAttrValueId(attrValue.getId());
                    cdkeyBingingList.add(newCdkeyLibrary);
                    break;
                }
                attrValue.setStock(attrValueRequest.getStock());
                break;
            }
        });
        ProductAttrValue minAttrValue = attrValueList.stream().min(Comparator.comparing(ProductAttrValue::getPrice)).get();
        Product tempProduct = new Product();
        tempProduct.setId(product.getId());
        tempProduct.setPrice(minAttrValue.getPrice());
        tempProduct.setStock(Integer.valueOf(attrValueList.stream().mapToInt(ProductAttrValue::getStock).sum()));
        if (!product.getCateId().equals(request.getCateId())) {
            tempProduct.setCateId(request.getCateId());
        }
        tempProduct.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.updateById(tempProduct);
            if (!update) {
                this.LOGGER.error("\u514d\u5ba1\u7f16\u8f91\u5546\u54c1\u5931\u8d25\uff0c\u5546\u54c1id = {}", (Object)tempProduct.getId());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            update = this.productAttrValueService.updateBatchById(attrValueList, 100);
            if (!update) {
                this.LOGGER.error("\u514d\u5ba1\u7f16\u8f91\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u5931\u8d25\uff0c\u5546\u54c1id = {}", (Object)tempProduct.getId());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (CollUtil.isNotEmpty((Collection)cdkeyIdUpdateList)) {
                this.cdkeyLibraryService.clearAssociationByIds(cdkeyIdUpdateList);
            }
            if (CollUtil.isNotEmpty((Collection)cdkeyBingingList)) {
                this.cdkeyLibraryService.updateBatchById(cdkeyBingingList);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean merchantEmployeeAnyTimeEdit(ProductAnyTimeEditRequest request, SystemAdmin admin) {
        Product product = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        List attrValueRequestList = request.getAttrValue();
        List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(product.getId(), product.getType(), product.getMarketingType(), false);
        if (CollUtil.isEmpty(attrValueList) || attrValueList.size() != attrValueRequestList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u89c4\u683c\u5c5e\u6027\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        ArrayList cdkeyIdUpdateList = new ArrayList();
        ArrayList cdkeyBingingList = new ArrayList();
        attrValueList.forEach(attrValue -> {
            for (ProductAttrValueAnyTimeEditRequest attrValueRequest : attrValueRequestList) {
                if (!attrValueRequest.getId().equals(attrValue.getId())) continue;
                attrValue.setPrice(attrValueRequest.getPrice());
                attrValue.setOtPrice(attrValueRequest.getOtPrice());
                attrValue.setCost(attrValueRequest.getCost());
                attrValue.setVersion(Integer.valueOf(0));
                if (product.getIsPaidMember().booleanValue() && ObjectUtil.isNotNull((Object)attrValueRequest.getVipPrice())) {
                    attrValue.setVipPrice(attrValueRequest.getVipPrice());
                }
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CLOUD)) {
                    attrValue.setExpand(attrValueRequest.getExpand());
                }
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                    if (attrValue.getCdkeyId().equals(attrValueRequest.getCdkeyId())) break;
                    cdkeyIdUpdateList.add(attrValue.getCdkeyId());
                    CdkeyLibrary cdkeyLibrary = this.cdkeyLibraryService.getByIdException(attrValueRequest.getCdkeyId());
                    if (!admin.getMerId().equals(cdkeyLibrary.getMerId())) {
                        throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_NOT_EXIST);
                    }
                    if (cdkeyLibrary.getProductId() > 0 && cdkeyLibrary.getProductId().equals(product.getId())) {
                        throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_CDKEY_LIBRARY_INTERACTION);
                    }
                    attrValue.setStock(Integer.valueOf(cdkeyLibrary.getTotalNum() - cdkeyLibrary.getUsedNum()));
                    attrValue.setCdkeyId(attrValueRequest.getCdkeyId());
                    CdkeyLibrary newCdkeyLibrary = new CdkeyLibrary();
                    newCdkeyLibrary.setId(attrValueRequest.getCdkeyId());
                    newCdkeyLibrary.setProductId(product.getId());
                    newCdkeyLibrary.setProductAttrValueId(attrValue.getId());
                    cdkeyBingingList.add(newCdkeyLibrary);
                    break;
                }
                attrValue.setStock(attrValueRequest.getStock());
                break;
            }
        });
        ProductAttrValue minAttrValue = attrValueList.stream().min(Comparator.comparing(ProductAttrValue::getPrice)).get();
        Product tempProduct = new Product();
        tempProduct.setId(product.getId());
        tempProduct.setPrice(minAttrValue.getPrice());
        tempProduct.setStock(Integer.valueOf(attrValueList.stream().mapToInt(ProductAttrValue::getStock).sum()));
        if (!product.getCateId().equals(request.getCateId())) {
            tempProduct.setCateId(request.getCateId());
        }
        if (product.getIsPaidMember().booleanValue()) {
            tempProduct.setVipPrice(minAttrValue.getVipPrice());
        }
        tempProduct.setUpdateTime((Date)DateUtil.date());
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean update = this.updateById(tempProduct);
            if (!update) {
                this.LOGGER.error("\u65e0\u72b6\u6001\u9650\u5236\u5546\u54c1\u7f16\u8f91\u5931\u8d25\uff0c\u5546\u54c1id = {}", (Object)tempProduct.getId());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            update = this.productAttrValueService.updateBatchById(attrValueList, 100);
            if (!update) {
                this.LOGGER.error("\u65e0\u72b6\u6001\u9650\u5236\u5546\u54c1\u7f16\u8f91\u5931\u8d25\uff0c\u5546\u54c1id = {}", (Object)tempProduct.getId());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (CollUtil.isNotEmpty((Collection)cdkeyIdUpdateList)) {
                this.cdkeyLibraryService.clearAssociationByIds(cdkeyIdUpdateList);
            }
            if (CollUtil.isNotEmpty((Collection)cdkeyBingingList)) {
                this.cdkeyLibraryService.updateBatchById(cdkeyBingingList);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public MyRecord copyConfig(SystemAdmin admin) {
        String copyType = this.systemConfigService.getValueByKey("system_product_copy_type");
        if (StrUtil.isBlank((CharSequence)copyType)) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u5148\u8fdb\u884c\u91c7\u96c6\u5546\u54c1\u914d\u7f6e");
        }
        int copyNum = 0;
        if (copyType.equals("1")) {
            if (admin.getMerId() > 0) {
                Merchant merchant = (Merchant)this.merchantService.getById(admin.getMerId());
                copyNum = merchant.getCopyProductNum();
            } else {
                OnePassUserInfoVo info = this.onePassService.info();
                copyNum = Optional.ofNullable(info.getCopy().getNum()).orElse(0);
            }
        }
        MyRecord record = new MyRecord();
        record.set("copyType", (Object)copyType);
        record.set("copyNum", (Object)copyNum);
        return record;
    }

    @Override
    public ProductResponseForCopyProduct copyProduct(String url, SystemAdmin currentMerchantAdmin) {
        ProductResponseForCopyProduct productResponseForCopyProduct;
        Merchant currentMerchant = this.merchantService.getByIdException(currentMerchantAdmin.getMerId());
        if (currentMerchant.getCopyProductNum() <= 0) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f53\u524d\u5546\u6237\u91c7\u96c6\u6b21\u6570\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u5ba2\u670d");
        }
        CrmebUtil.setBusinessDataForFT((int)this.orderService.getAMC(), (int)this.orderService.getAPC(), (int)this.orderService.getAOC());
        try {
            JSONObject jsonObject = this.onePassService.copyGoods(url);
            productResponseForCopyProduct = ProductUtils.onePassCopyTransition(jsonObject);
        }
        catch (Exception e) {
            throw new CrmebException("\u4e00\u53f7\u901a\u91c7\u96c6\u5546\u54c1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        Boolean sub = this.merchantService.subCopyProductNum(currentMerchant.getId());
        if (!sub.booleanValue()) {
            this.LOGGER.error("\u6263\u9664\u5546\u6237\u590d\u5236\u6761\u6570\u5f02\u5e38\uff1a\u5546\u6237ID = {}", (Object)currentMerchant.getId());
        }
        return productResponseForCopyProduct;
    }

    @Override
    public Map<Integer, Product> getMapByIdList(List<Integer> proIdList) {
        HashMap productMap = CollUtil.newHashMap();
        if (CollUtil.isEmpty(proIdList)) {
            return productMap;
        }
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getPrice, Product::getImage, Product::getIsShow, Product::getIsRecycle, Product::getIsDel});
        lqw.in(Product::getId, proIdList);
        List productList = this.dao.selectList((Wrapper)lqw);
        productList.forEach(e -> productMap.put(e.getId(), e));
        return productMap;
    }

    @Override
    public PageInfo<ProductActivityResponse> getActivitySearchPage(ProductActivitySearchRequest request, SystemAdmin admin) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", URLUtil.decode((String)request.getName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            map.put("categoryId", request.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsShow())) {
            map.put("isShow", request.getIsShow() != false ? 1 : 0);
        }
        if (ObjectUtil.isNotNull((Object)request.getMerStars()) && request.getMerStars() > 0) {
            map.put("merStars", request.getMerStars());
        }
        if (admin.getMerId() > 0) {
            request.setMerIds(admin.getMerId().toString());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getMerIds())) {
            map.put("merIds", request.getMerIds());
        }
        if (ObjectUtil.isNotNull((Object)request.getBrandId())) {
            map.put("brandId", request.getBrandId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSalesOrder())) {
            if (request.getSalesOrder().equals("desc")) {
                map.put("lastStr", " order by (p.sales + p.ficti) desc, p.rank desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by (p.sales + p.ficti) asc, p.rank desc, p.sort desc, p.id desc");
            }
        } else if (StrUtil.isNotBlank((CharSequence)request.getPriceOrder())) {
            if (request.getPriceOrder().equals("desc")) {
                map.put("lastStr", " order by p.price desc, p.rank desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by p.price asc, p.rank desc, p.sort desc, p.id desc");
            }
        } else {
            map.put("lastStr", " order by p.rank desc, p.sort desc, p.id desc");
        }
        List<ProductActivityResponse> responseList = this.dao.getActivitySearchPage(map);
        responseList.forEach(response -> {
            List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(response.getId(), response.getType(), ProductConstants.PRODUCT_MARKETING_TYPE_BASE, false);
            response.setAttrValue(attrValueList);
        });
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public PageInfo<ProductMarketingResponse> getMarketingSearchPage(PlatProductMarketingSearchRequest request, SystemAdmin admin) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", URLUtil.decode((String)request.getName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            map.put("categoryId", request.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsShow())) {
            map.put("isShow", request.getIsShow() != false ? 1 : 0);
        }
        if (StrUtil.isNotBlank((CharSequence)request.getMerIds())) {
            map.put("merIds", request.getMerIds());
        }
        List<ProductMarketingResponse> responseList = this.dao.getMarketingSearchPage(map);
        responseList.forEach(response -> {
            List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(response.getId(), response.getType(), ProductConstants.PRODUCT_MARKETING_TYPE_BASE, false);
            response.setAttrValue(attrValueList);
        });
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public PageInfo<ProductActivityResponse> getActivitySearchPageByMerchant(ProductActivitySearchRequest request, SystemAdmin admin) {
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", URLUtil.decode((String)request.getName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            map.put("categoryId", request.getCategoryId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getCateIds())) {
            String cateIdSql = CrmebUtil.getFindInSetSqlForFT((String)"p.cate_id", (String)request.getCateIds());
            map.put("cateIdSql", cateIdSql);
        }
        if (ObjectUtil.isNotNull((Object)request.getIsShow())) {
            map.put("isShow", request.getIsShow() != false ? 1 : 0);
        }
        map.put("merId", admin.getMerId());
        if (ObjectUtil.isNotNull((Object)request.getProductId())) {
            map.put("productId", request.getProductId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSalesOrder())) {
            if (request.getSalesOrder().equals("desc")) {
                map.put("lastStr", " order by (p.sales + p.ficti) desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by (p.sales + p.ficti) asc, p.sort desc, p.id desc");
            }
        } else if (StrUtil.isNotBlank((CharSequence)request.getPriceOrder())) {
            if (request.getPriceOrder().equals("desc")) {
                map.put("lastStr", " order by p.price desc, p.sort desc, p.id desc");
            } else {
                map.put("lastStr", " order by p.price asc, p.sort desc, p.id desc");
            }
        } else {
            map.put("lastStr", " order by p.sort desc, p.id desc");
        }
        List<ProductActivityResponse> responseList = this.dao.getActivitySearchPageByMerchant(map);
        responseList.forEach(response -> {
            List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(response.getId(), response.getType(), ProductConstants.PRODUCT_MARKETING_TYPE_BASE, false);
            response.setAttrValue(attrValueList);
        });
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public PageInfo<ProductMarketingResponse> getMarketingSearchPageByMerchant(MerProductMarketingSearchRequest request, SystemAdmin admin) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (request.getMarketingType().equals(ProductConstants.PRODUCT_MARKETING_TYPE_SECKILL)) {
            if (ObjectUtil.isNull((Object)request.getActivityId())) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u8bf7\u9009\u62e9\u79d2\u6740\u6d3b\u52a8");
            }
            SeckillActivity activity = (SeckillActivity)this.seckillActivityService.getById(request.getActivityId());
            if (ObjectUtil.isNull((Object)activity) || activity.getIsDel().booleanValue()) {
                throw new CrmebException((IResultEnum)MarketingResultCode.SECKILL_ACTIVITY_NOT_EXIST);
            }
            if (activity.getStatus().equals(2)) {
                throw new CrmebException((IResultEnum)MarketingResultCode.SECKILL_ACTIVITY_END);
            }
            Merchant merchant = this.merchantService.getByIdException(admin.getMerId());
            if (activity.getMerStars() > merchant.getStarLevel()) {
                throw new CrmebException((IResultEnum)MarketingResultCode.SECKILL_ACTIVITY_MERCHANT_LEVEL_INSUFFICIENT);
            }
            if (!activity.getProCategory().equals("0")) {
                map.put("proCateIds", activity.getProCategory());
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", URLUtil.decode((String)request.getName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            map.put("categoryId", request.getCategoryId());
        }
        if (ObjectUtil.isNotNull((Object)request.getCateId())) {
            map.put("cateId", request.getCateId());
        }
        if (ObjectUtil.isNotNull((Object)request.getIsShow())) {
            map.put("isShow", request.getIsShow() != false ? 1 : 0);
        }
        if (ObjectUtil.isNotNull((Object)request.getProductId()) && request.getProductId() > 0) {
            map.put("productId", request.getProductId());
        }
        map.put("merId", admin.getMerId());
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<ProductMarketingResponse> responseList = this.dao.getMarketingSearchPageByMerchant(map);
        responseList.forEach(response -> {
            List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(response.getId(), response.getType(), ProductConstants.PRODUCT_MARKETING_TYPE_BASE, false);
            response.setAttrValue(attrValueList);
        });
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    private Product getByIdException(Integer id) {
        Product product = (Product)this.getById(id);
        if (ObjectUtil.isNull((Object)product) || product.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        return product;
    }

    private List<PlatformProductListResponse> productListToPlatFromProductListResponse(List<Product> productList) {
        ArrayList<PlatformProductListResponse> platformProductListResponses = new ArrayList<PlatformProductListResponse>();
        for (Product product : productList) {
            PlatformProductListResponse r = new PlatformProductListResponse();
            BeanUtils.copyProperties((Object)product, (Object)r);
            platformProductListResponses.add(r);
        }
        return platformProductListResponses;
    }

    @Override
    public List<SimpleProductVo> findCouponListLimit3(Integer couponCategory, List<Integer> pidList, String linkedData, List<Integer> pcIdList) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.select(new SFunction[]{Product::getId, Product::getName, Product::getImage, Product::getPrice, Product::getStock});
        switch (couponCategory) {
            case 2: {
                lqw.in(Product::getId, pidList);
                break;
            }
            case 4: {
                lqw.in(Product::getCategoryId, pcIdList);
                break;
            }
            case 5: {
                lqw.eq(Product::getBrandId, (Object)Integer.valueOf(linkedData));
                break;
            }
            case 6: {
                lqw.in(Product::getMerId, (Collection)CrmebUtil.stringToArray((String)linkedData));
            }
        }
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.orderByDesc((Object[])new SFunction[]{Product::getSort, Product::getId});
        lqw.last(" limit 3");
        List productList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)productList)) {
            return new ArrayList<SimpleProductVo>();
        }
        return productList.stream().map(e -> {
            SimpleProductVo vo = new SimpleProductVo();
            BeanUtils.copyProperties((Object)e, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
    }

    @Override
    public PageInfo<Product> findCouponProductList(Integer couponId, Integer couponCategory, String couponLinkedDate, SystemCouponProductSearchRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        switch (couponCategory) {
            case 2: {
                List<CouponProduct> couponProductList = this.couponProductService.findByCid(couponId);
                List pidList = couponProductList.stream().map(CouponProduct::getPid).collect(Collectors.toList());
                lqw.in(Product::getId, pidList);
                break;
            }
            case 4: {
                ProductCategory productCategory = (ProductCategory)this.productCategoryService.getById(Integer.valueOf(couponLinkedDate));
                ArrayList<Integer> pcIdList = new ArrayList<Integer>();
                if (productCategory.getLevel().equals(3)) {
                    pcIdList.add(productCategory.getId());
                } else {
                    List<Object> productCategoryList = new ArrayList();
                    if (productCategory.getLevel().equals(2)) {
                        productCategoryList = this.productCategoryService.findAllChildListByPid(productCategory.getId(), productCategory.getLevel());
                    }
                    if (productCategory.getLevel().equals(1)) {
                        productCategoryList = this.productCategoryService.getThirdCategoryByFirstId(productCategory.getId(), 0);
                    }
                    List collect = productCategoryList.stream().map(ProductCategory::getId).collect(Collectors.toList());
                    pcIdList.addAll(collect);
                }
                lqw.in(Product::getCategoryId, pcIdList);
                break;
            }
            case 5: {
                lqw.eq(Product::getBrandId, (Object)Integer.valueOf(couponLinkedDate));
                break;
            }
            case 6: {
                lqw.in(Product::getMerId, (Collection)CrmebUtil.stringToArray((String)couponLinkedDate));
            }
        }
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.ne(Product::getType, (Object)ProductConstants.PRODUCT_TYPE_INTEGRAL);
        lqw.eq(Product::getMarketingType, (Object)ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        if (StrUtil.isNotBlank((CharSequence)pageParamRequest.getKeyword())) {
            String decode = URLUtil.decode((String)pageParamRequest.getKeyword());
            lqw.like(Product::getName, (Object)decode);
        }
        lqw.orderByDesc((Object[])new SFunction[]{Product::getSort, Product::getId});
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List productList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public List<Product> findByIds(List<Integer> proIdsList) {
        return this.findByIdsAndLabel(proIdsList, "admin");
    }

    @Override
    public List<Product> findByIds(List<Integer> proIdsList, String label) {
        return this.findByIdsAndLabel(proIdsList, label);
    }

    private List<Product> findByIdsAndLabel(List<Integer> proIdsList, String label) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.in(Product::getId, proIdsList);
        if (label.equals("front")) {
            this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("order by field(id,");
        int length = proIdsList.size();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                builder.append(proIdsList.get(i));
            } else {
                builder.append(",").append(proIdsList.get(i));
            }
            if (i != length - 1) continue;
            builder.append(")");
        }
        lqw.last(builder.toString());
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Product> findHomeRecommended(String message, String value, String expand, boolean isHome) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getImage, Product::getName, Product::getSales, Product::getPrice, Product::getFicti, Product::getBrandId, Product::getMerId, Product::getCategoryId, Product::getIsPaidMember, Product::getVipPrice});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        switch (message) {
            case "product": {
                List proIdList = CrmebUtil.stringToArray((String)expand);
                lqw.in(Product::getId, (Collection)proIdList);
                break;
            }
            case "category": {
                lqw.eq(Product::getCategoryId, (Object)value);
                break;
            }
            case "brand": {
                lqw.eq(Product::getBrandId, (Object)value);
                break;
            }
            case "merchant": {
                List merIdList = CrmebUtil.stringToArray((String)expand);
                lqw.in(Product::getMerId, (Collection)merIdList);
            }
        }
        if (isHome) {
            lqw.last(" order by sales + ficti desc limit 8");
        } else {
            lqw.last(" order by sales + ficti desc");
        }
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<RecommendProductResponse> findRecommendPage(PageParamRequest pageRequest) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getImage, Product::getName, Product::getUnitName, Product::getPrice, Product::getSales, Product::getFicti, Product::getCategoryId, Product::getBrandId, Product::getIsPaidMember, Product::getVipPrice});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.ne(Product::getType, (Object)1);
        lqw.orderByDesc((Object[])new SFunction[]{Product::getRank, Product::getSales, Product::getFicti, Product::getId});
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        List<Product> productList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)productList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new RecommendProductResponse[0]));
        }
        productList = this.activityStyleService.makeActivityBorderStyle(productList);
        List responseList = productList.stream().map(p -> {
            RecommendProductResponse response = new RecommendProductResponse();
            BeanUtils.copyProperties((Object)p, (Object)response);
            response.setSales(Integer.valueOf(p.getSales() + p.getFicti()));
            ProductTagsFrontResponse productTagsFrontResponse = this.productTagService.setProductTagByProductTagsRules(p.getId(), p.getBrandId(), p.getMerId(), p.getCategoryId(), response.getProductTags());
            response.setProductTags(productTagsFrontResponse);
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public PageInfo<RecommendProductResponse> findMemberPage(PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getImage, Product::getName, Product::getUnitName, Product::getPrice, Product::getSales, Product::getFicti, Product::getCategoryId, Product::getBrandId, Product::getIsPaidMember, Product::getVipPrice, Product::getStock});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        lqw.eq(Product::getIsPaidMember, (Object)1);
        lqw.orderByDesc(Product::getId);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<Product> productList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)productList)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new RecommendProductResponse[0]));
        }
        productList = this.activityStyleService.makeActivityBorderStyle(productList);
        List responseList = productList.stream().map(p -> {
            RecommendProductResponse response = new RecommendProductResponse();
            BeanUtils.copyProperties((Object)p, (Object)response);
            response.setSales(Integer.valueOf(p.getSales() + p.getFicti()));
            ProductTagsFrontResponse productTagsFrontResponse = this.productTagService.setProductTagByProductTagsRules(p.getId(), p.getBrandId(), p.getMerId(), p.getCategoryId(), response.getProductTags());
            response.setProductTags(productTagsFrontResponse);
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public Boolean validatedCanUseById(Integer proId) {
        Product product = (Product)this.getById(proId);
        if (ObjectUtil.isNull((Object)product)) {
            return false;
        }
        if (product.getIsDel().booleanValue()) {
            return false;
        }
        if (product.getIsRecycle().booleanValue()) {
            return false;
        }
        if (!product.getIsShow().booleanValue()) {
            return false;
        }
        if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_SUCCESS) && !product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_EXEMPTION)) {
            return false;
        }
        return true;
    }

    @Override
    public List<Integer> findProductBrandIdByKeyword(String keyword) {
        return this.dao.findProductBrandIdByKeyword(URLUtil.decode((String)keyword));
    }

    @Override
    public List<Integer> findProductCategoryIdByKeyword(String keyword) {
        return this.dao.findProductCategoryIdByKeyword(URLUtil.decode((String)keyword));
    }

    @Override
    public Boolean setFreightTemplate(ProductFreightTemplateRequest request, SystemAdmin admin) {
        Product product = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (product.getIsRecycle().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_DELETE);
        }
        if (product.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_IS_SHOW);
        }
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
        }
        if (product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) || product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION.setMessage("\u53ea\u6709\u4ed3\u5e93\u4e2d\u5546\u54c1\u624d\u80fd\u8bbe\u7f6e\u8fd0\u8d39"));
        }
        if (!product.getType().equals(ProductConstants.PRODUCT_TYPE_NORMAL)) {
            return Boolean.TRUE;
        }
        ShippingTemplates shippingTemplate = (ShippingTemplates)this.shippingTemplatesService.getById(request.getTemplateId());
        if (ObjectUtil.isNull((Object)shippingTemplate) || !admin.getMerId().equals(shippingTemplate.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.SHIPPING_TEMPLATES_NOT_EXIST);
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getTempId, (Object)shippingTemplate.getId());
        wrapper.eq(Product::getId, (Object)product.getId());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean setBrokerage(ProductSetBrokerageRequest request, SystemAdmin admin) {
        Product product = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (product.getIsRecycle().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_DELETE);
        }
        if (product.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_IS_SHOW);
        }
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
        }
        if (product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) || product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION.setMessage("\u53ea\u6709\u4ed3\u5e93\u4e2d\u5546\u54c1\u624d\u80fd\u8bbe\u7f6e\u4f63\u91d1"));
        }
        int brokerageRatio = request.getBrokerage() + request.getBrokerageTwo();
        if (brokerageRatio > this.crmebConfig.getRetailStoreBrokerageRatio()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u4e00\u4e8c\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e4b\u548c\u8303\u56f4\u4e3a 0~{}", (Object[])new Object[]{this.crmebConfig.getRetailStoreBrokerageRatio()}));
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            if (!product.getIsSub().booleanValue()) {
                LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
                wrapper.set(Product::getIsSub, (Object)1);
                wrapper.eq(Product::getId, (Object)product.getId());
                this.update((Wrapper)wrapper);
            }
            this.productAttrValueService.updateBrokerageByProductId(product.getId(), product.getType(), product.getMarketingType(), request.getBrokerage(), request.getBrokerageTwo());
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean addFeedbackCoupons(ProductAddFeedbackCouponsRequest request, SystemAdmin admin) {
        Product product = this.getByIdException(request.getId());
        if (!admin.getMerId().equals(product.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (product.getIsRecycle().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_DELETE);
        }
        if (product.getIsShow().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_IS_SHOW);
        }
        if (product.getIsAudit().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
        }
        if (product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) || product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) {
            throw new CrmebException(ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION.setMsgParams(new Object[]{"\u53ea\u6709\u4ed3\u5e93\u4e2d\u5546\u54c1\u624d\u80fd\u8bbe\u7f6e\u6dfb\u52a0\u56de\u9988\u5238"}));
        }
        List<Coupon> couponList = this.couponService.findByIds(request.getCouponIds());
        for (Coupon coupon : couponList) {
            if (coupon.getMerId().equals(admin.getMerId())) continue;
            throw new CrmebException((IResultEnum)CouponResultCode.COUPON_NOT_EXIST);
        }
        List<ProductCoupon> productCouponList = this.productCouponService.getListByProductId(product.getId());
        if (CollUtil.isNotEmpty(productCouponList)) {
            List pcList = productCouponList.stream().map(ProductCoupon::getCouponId).collect(Collectors.toList());
            int i = 0;
            while (i < couponList.size()) {
                Coupon coupon = couponList.get(i);
                if (pcList.contains(coupon.getId())) {
                    couponList.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (CollUtil.isEmpty(couponList)) {
            return Boolean.TRUE;
        }
        ArrayList<ProductCoupon> addPCList = new ArrayList<ProductCoupon>();
        for (Integer couponId : request.getCouponIds()) {
            ProductCoupon spc = new ProductCoupon();
            spc.setProductId(product.getId());
            spc.setCouponId(couponId);
            spc.setAddTime(CrmebDateUtil.getNowTime());
            addPCList.add(spc);
        }
        return this.productCouponService.saveBatch(addPCList);
    }

    @Override
    public Boolean batchUp(List<Integer> idList, SystemAdmin admin) {
        List<Product> productList = this.findByIds(idList);
        if (CollUtil.isEmpty(productList) || productList.size() != idList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6570\u91cf\u4e0d\u7b26\u6216\u5546\u54c1\u672a\u627e\u5230");
        }
        int i = 0;
        while (i < productList.size()) {
            Product product = productList.get(i);
            if (!admin.getMerId().equals(product.getMerId())) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (product.getIsAudit().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
            }
            if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_EXEMPTION) && !product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_SUCCESS)) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION);
            }
            if (product.getIsShow().booleanValue()) {
                productList.remove(i);
                continue;
            }
            ++i;
        }
        if (CollUtil.isEmpty(productList)) {
            return Boolean.TRUE;
        }
        List proIdList = productList.stream().map(Product::getId).collect(Collectors.toList());
        Merchant merchant = (Merchant)this.merchantService.getById(admin.getMerId());
        if (!merchant.getIsSwitch().booleanValue()) {
            throw new CrmebException((IResultEnum)MerchantResultCode.MERCHANT_SWITCH_CLOSE);
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean update = this.productBatchUpOrDown(proIdList, "up");
            if (!update.booleanValue()) {
                this.LOGGER.error("\u5546\u54c1\u6279\u91cf\u4e0a\u67b6\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff0cidList = {}", (Object)idList);
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            productList.forEach(product -> {
                List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(product.getId(), product.getType(), product.getMarketingType(), false);
                List<Integer> skuIdList = skuList.stream().map(ProductAttrValue::getId).collect(Collectors.toList());
                this.cartService.productStatusNoEnable(skuIdList);
            });
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean batchDown(List<Integer> idList, SystemAdmin admin) {
        List<Product> productList = this.findByIds(idList);
        if (CollUtil.isEmpty(productList) || productList.size() != idList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6570\u91cf\u4e0d\u7b26\u6216\u5546\u54c1\u672a\u627e\u5230");
        }
        int i = 0;
        while (i < productList.size()) {
            Product product = productList.get(i);
            if (!admin.getMerId().equals(product.getMerId())) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (!product.getIsShow().booleanValue()) {
                productList.remove(i);
                continue;
            }
            ++i;
        }
        if (CollUtil.isEmpty(productList)) {
            return Boolean.TRUE;
        }
        List proIdList = productList.stream().map(Product::getId).collect(Collectors.toList());
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean update = this.productBatchUpOrDown(proIdList, "down");
            if (!update.booleanValue()) {
                this.LOGGER.error("\u5546\u54c1\u6279\u91cf\u4e0b\u67b6\u66f4\u65b0\u72b6\u6001\u5931\u8d25\uff0cidList = {}", (Object)idList);
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            productList.forEach(product -> {
                this.cartService.productStatusNotEnable(product.getId());
                this.productRelationService.deleteByProId(product.getId());
            });
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean batchSetFreightTemplate(BatchSetProductFreightTemplateRequest request, SystemAdmin admin) {
        List<Product> productList = this.findByIds(request.getIdList());
        if (CollUtil.isEmpty(productList) || productList.size() != request.getIdList().size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6570\u91cf\u4e0d\u7b26\u6216\u5546\u54c1\u672a\u627e\u5230");
        }
        int i = 0;
        while (i < productList.size()) {
            Product product = productList.get(i);
            if (!admin.getMerId().equals(product.getMerId())) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (product.getIsRecycle().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_DELETE);
            }
            if (product.getIsShow().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_IS_SHOW);
            }
            if (product.getIsAudit().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
            }
            if (product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) || product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION.setMessage("\u53ea\u6709\u4ed3\u5e93\u4e2d\u5546\u54c1\u624d\u80fd\u8bbe\u7f6e\u8fd0\u8d39"));
            }
            if (!product.getType().equals(ProductConstants.PRODUCT_TYPE_NORMAL)) {
                productList.remove(i);
                continue;
            }
            ++i;
        }
        if (CollUtil.isEmpty(productList)) {
            return Boolean.TRUE;
        }
        ShippingTemplates shippingTemplate = (ShippingTemplates)this.shippingTemplatesService.getById(request.getTemplateId());
        if (ObjectUtil.isNull((Object)shippingTemplate) || !admin.getMerId().equals(shippingTemplate.getMerId())) {
            throw new CrmebException((IResultEnum)ProductResultCode.SHIPPING_TEMPLATES_NOT_EXIST);
        }
        List proIdList = productList.stream().map(Product::getId).collect(Collectors.toList());
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getTempId, (Object)shippingTemplate.getId());
        wrapper.in(Product::getId, proIdList);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean batchSetBrokerage(BatchSetProductBrokerageRequest request, SystemAdmin admin) {
        List<Product> productList = this.findByIds(request.getIdList());
        if (CollUtil.isEmpty(productList) || productList.size() != request.getIdList().size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6570\u91cf\u4e0d\u7b26\u6216\u5546\u54c1\u672a\u627e\u5230");
        }
        for (Product product : productList) {
            if (!admin.getMerId().equals(product.getMerId())) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (product.getIsRecycle().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_DELETE);
            }
            if (product.getIsShow().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_IS_SHOW);
            }
            if (product.getIsAudit().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
            }
            if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) && !product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) continue;
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION.setMessage("\u53ea\u6709\u4ed3\u5e93\u4e2d\u5546\u54c1\u624d\u80fd\u8bbe\u7f6e\u4f63\u91d1"));
        }
        int brokerageRatio = request.getBrokerage() + request.getBrokerageTwo();
        if (brokerageRatio > this.crmebConfig.getRetailStoreBrokerageRatio()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, StrUtil.format((CharSequence)"\u4e00\u4e8c\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e4b\u548c\u8303\u56f4\u4e3a 0~{}", (Object[])new Object[]{this.crmebConfig.getRetailStoreBrokerageRatio()}));
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            productList.forEach(product -> {
                if (!product.getIsSub().booleanValue()) {
                    LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
                    wrapper.set(Product::getIsSub, (Object)1);
                    wrapper.eq(Product::getId, (Object)product.getId());
                    this.update((Wrapper)wrapper);
                }
                this.productAttrValueService.updateBrokerageByProductId(product.getId(), product.getType(), product.getMarketingType(), request.getBrokerage(), request.getBrokerageTwo());
            });
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean batchAddFeedbackCoupons(BatchAddProductFeedbackCouponsRequest request, SystemAdmin admin) {
        List<Product> productList = this.findByIds(request.getIdList());
        if (CollUtil.isEmpty(productList) || productList.size() != request.getIdList().size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6570\u91cf\u4e0d\u7b26\u6216\u5546\u54c1\u672a\u627e\u5230");
        }
        for (Product product : productList) {
            if (!admin.getMerId().equals(product.getMerId())) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (product.getIsRecycle().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_DELETE);
            }
            if (product.getIsShow().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_IS_SHOW);
            }
            if (product.getIsAudit().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
            }
            if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT) && !product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_FAIL)) continue;
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION.setMessage("\u53ea\u6709\u4ed3\u5e93\u4e2d\u5546\u54c1\u624d\u80fd\u8bbe\u7f6e\u6dfb\u52a0\u56de\u9988\u5238"));
        }
        List<Coupon> couponList = this.couponService.findByIds(request.getCouponIds());
        for (Coupon coupon : couponList) {
            if (coupon.getMerId().equals(admin.getMerId())) continue;
            throw new CrmebException((IResultEnum)CouponResultCode.COUPON_NOT_EXIST);
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            for (Product product : productList) {
                List<ProductCoupon> productCouponList = this.productCouponService.getListByProductId(product.getId());
                if (CollUtil.isNotEmpty(productCouponList)) {
                    List pcList = productCouponList.stream().map(ProductCoupon::getCouponId).collect(Collectors.toList());
                    int i = 0;
                    while (i < couponList.size()) {
                        Coupon coupon = (Coupon)couponList.get(i);
                        if (pcList.contains(coupon.getId())) {
                            couponList.remove(i);
                            continue;
                        }
                        ++i;
                    }
                }
                if (CollUtil.isEmpty((Collection)couponList)) continue;
                ArrayList<ProductCoupon> addPCList = new ArrayList<ProductCoupon>();
                for (Integer couponId : request.getCouponIds()) {
                    ProductCoupon spc = new ProductCoupon();
                    spc.setProductId(product.getId());
                    spc.setCouponId(couponId);
                    spc.setAddTime(CrmebDateUtil.getNowTime());
                    addPCList.add(spc);
                }
                this.productCouponService.saveBatch(addPCList);
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean batchRecycle(List<Integer> idList, SystemAdmin admin) {
        List<Product> productList = this.findByIds(idList);
        if (CollUtil.isEmpty(productList) || productList.size() != idList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6570\u91cf\u4e0d\u7b26\u6216\u5546\u54c1\u672a\u627e\u5230");
        }
        for (Product product : productList) {
            if (!admin.getMerId().equals(product.getMerId())) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (!product.getIsRecycle().booleanValue()) continue;
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_RECYCLE);
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(Product::getIsRecycle, (Object)1);
        wrapper.in(Product::getId, idList);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)wrapper);
            idList.forEach(id -> this.cartService.productStatusNotEnable((Integer)id));
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean batchDelete(List<Integer> idList, SystemAdmin admin) {
        List<Product> productList = this.findByIds(idList);
        if (CollUtil.isEmpty(productList) || productList.size() != idList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6570\u91cf\u4e0d\u7b26\u6216\u5546\u54c1\u672a\u627e\u5230");
        }
        for (Product product : productList) {
            if (admin.getMerId().equals(product.getMerId())) continue;
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(Product::getIsDel, (Object)1);
        wrapper.in(Product::getId, idList);
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.update((Wrapper)wrapper);
            productList.forEach(product -> {
                this.cartService.productDelete(product.getId());
                if (product.getType().equals(ProductConstants.PRODUCT_TYPE_CDKEY)) {
                    this.cdkeyLibraryService.clearAssociationProduct(product.getId());
                }
            });
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean batchRestore(List<Integer> idList, SystemAdmin admin) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(Product::getIsRecycle, (Object)0);
        wrapper.set(Product::getIsShow, (Object)0);
        wrapper.in(Product::getId, idList);
        wrapper.eq(Product::getMerId, (Object)admin.getMerId());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean batchSubmitAudit(List<Integer> idList, SystemAdmin admin, Boolean isAutoUp) {
        List<Product> productList = this.findByIds(idList);
        if (CollUtil.isEmpty(productList) || productList.size() != idList.size()) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1\u6570\u91cf\u4e0d\u7b26\u6216\u5546\u54c1\u672a\u627e\u5230");
        }
        for (Product product : productList) {
            if (!admin.getMerId().equals(product.getMerId())) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
            }
            if (product.getIsAudit().booleanValue()) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_ING);
            }
            if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT)) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION);
            }
            if (!product.getIsRecycle().booleanValue()) continue;
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_RECYCLE);
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getIsAudit, (Object)1);
        wrapper.set(Product::getIsShow, (Object)0);
        if (isAutoUp.booleanValue()) {
            wrapper.set(Product::getIsAutoUp, (Object)true);
        }
        wrapper.in(Product::getId, idList);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean platBatchSetVirtualSales(BatchSetVirtualSalesRequest request) {
        UpdateWrapper wrapper = Wrappers.update();
        wrapper.setSql(StrUtil.format((CharSequence)"ficti = ficti + {}", (Object[])new Object[]{request.getFicti()}));
        wrapper.in((Object)"id", (Collection)request.getIdList());
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean batchAudit(BatchProductAuditRequest request) {
        if (request.getAuditStatus().equals("fail") && StrUtil.isEmpty((CharSequence)request.getReason())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5ba1\u6838\u62d2\u7edd\u8bf7\u586b\u5199\u62d2\u7edd\u539f\u56e0");
        }
        List<Product> productList = this.findByIds(request.getIdList());
        for (Product product2 : productList) {
            if (!product2.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_WAIT)) {
                throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION);
            }
            if (product2.getIsAudit().booleanValue()) continue;
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_AUDIT_STATUS_EXCEPTION);
        }
        if (request.getAuditStatus().equals("fail")) {
            LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
            wrapper.set(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_FAIL);
            wrapper.set(Product::getReason, (Object)request.getReason());
            wrapper.set(Product::getIsAudit, (Object)0);
            wrapper.set(Product::getIsShow, (Object)0);
            wrapper.set(Product::getIsAutoUp, (Object)0);
            wrapper.in(Product::getId, (Collection)request.getIdList());
            return this.update((Wrapper)wrapper);
        }
        List<Integer> merIdList = productList.stream().map(Product::getMerId).distinct().collect(Collectors.toList());
        Map<Integer, Merchant> merchantMap = this.merchantService.getMapByIdList(merIdList);
        ArrayList autoUpProList = new ArrayList();
        productList.forEach(product -> {
            product.setAuditStatus(ProductConstants.AUDIT_STATUS_SUCCESS);
            product.setUpdateTime((Date)DateUtil.date());
            Merchant merchant = (Merchant)merchantMap.get(product.getMerId());
            if (!merchant.getProductSwitch().booleanValue()) {
                product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
            }
            product.setIsAudit(Boolean.valueOf(false));
            if (merchant.getIsSwitch().booleanValue() && product.getIsAutoUp().booleanValue()) {
                product.setIsShow(Boolean.valueOf(true));
                product.setIsAutoUp(Boolean.valueOf(false));
                autoUpProList.add(product);
            } else {
                product.setIsAutoUp(Boolean.valueOf(false));
                product.setIsShow(Boolean.valueOf(false));
            }
        });
        boolean batch = this.updateBatchById(productList);
        if (batch) {
            for (Product product3 : autoUpProList) {
                try {
                    List<ProductAttrValue> skuList = this.productAttrValueService.getListByProductIdAndType(product3.getId(), product3.getType(), product3.getMarketingType(), false);
                    List<Integer> skuIdList = skuList.stream().map(ProductAttrValue::getId).collect(Collectors.toList());
                    if (!CollUtil.isNotEmpty(skuIdList)) continue;
                    this.cartService.productStatusNoEnable(skuIdList);
                }
                catch (Exception e) {
                    this.LOGGER.error("\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\uff0c\u8d2d\u7269\u8f66\u5546\u54c1\u72b6\u6001\u6062\u590d\u5931\u8d25\uff0cProId = {}", (Object)product3.getId());
                    this.LOGGER.error("\u5546\u54c1\u81ea\u52a8\u4e0a\u67b6\uff0c\u8d2d\u7269\u8f66\u5546\u54c1\u72b6\u6001\u6062\u590d\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return batch;
    }

    @Override
    public Boolean clearSystemFormByFormId(Integer systemFormId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(Product::getSystemFormId, (Object)0);
        wrapper.eq(Product::getSystemFormId, (Object)systemFormId);
        wrapper.eq(Product::getIsDel, (Object)0);
        return this.update((Wrapper)wrapper);
    }

    private Boolean productBatchUpOrDown(List<Integer> idList, String operation) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        if (operation.equals("up")) {
            wrapper.set(Product::getIsShow, (Object)1);
        } else {
            wrapper.set(Product::getIsShow, (Object)0);
        }
        wrapper.in(Product::getId, idList);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean saveIntegralProduct(IntegralProductAddRequest request) {
        if (!request.getSpecType().booleanValue() && request.getAttrValueList().size() > 1) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5355\u89c4\u683c\u5546\u54c1\u5c5e\u6027\u503c\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (StrUtil.isBlank((CharSequence)request.getKeyword())) {
            request.setKeyword("");
        } else if (request.getKeyword().length() > 32) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5173\u952e\u5b57\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
        }
        Product product = new Product();
        BeanUtils.copyProperties((Object)request, (Object)product);
        product.setId(null);
        product.setMerId(Integer.valueOf(0));
        product.setMarketingType(ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        product.setType(ProductConstants.PRODUCT_TYPE_INTEGRAL);
        product.setDeliveryMethod("1");
        product.setTempId(Integer.valueOf(0));
        product.setRefundSwitch(Boolean.valueOf(false));
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        product.setImage(this.systemAttachmentService.clearPrefix(product.getImage(), cdnUrl));
        product.setSliderImage(this.systemAttachmentService.clearPrefix(product.getSliderImage(), cdnUrl));
        List attrValueAddRequestList = request.getAttrValueList();
        IntegralProductAttrValueAddRequest tempAttrValue = attrValueAddRequestList.stream().min(Comparator.comparing(IntegralProductAttrValueAddRequest::getRedeemIntegral)).get();
        List minAttrValueList = attrValueAddRequestList.stream().filter(e -> e.getRedeemIntegral().equals(tempAttrValue.getRedeemIntegral())).collect(Collectors.toList());
        IntegralProductAttrValueAddRequest minAttrValue = minAttrValueList.size() > 1 ? minAttrValueList.stream().min(Comparator.comparing(IntegralProductAttrValueAddRequest::getPrice)).get() : tempAttrValue;
        product.setRedeemIntegral(minAttrValue.getRedeemIntegral());
        product.setPrice(minAttrValue.getPrice());
        product.setOtPrice(BigDecimal.ZERO);
        product.setCost(minAttrValue.getCost());
        product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
        product.setIsAudit(Boolean.valueOf(false));
        List addRequestList = request.getAttrList();
        ArrayList attrList = new ArrayList();
        HashMap optionMap = new HashMap();
        addRequestList.forEach(attrRequest -> {
            ProductAttribute attr = new ProductAttribute();
            attr.setAttributeName(attrRequest.getAttributeName());
            attr.setIsShowImage(attrRequest.getIsShowImage());
            attr.setSort(Integer.valueOf(ObjectUtil.isNotNull((Object)attrRequest.getSort()) ? attrRequest.getSort() : 0));
            List optionRequestList = attrRequest.getOptionList();
            List attrOptionList = optionRequestList.stream().map(optionRequest -> {
                ProductAttributeOption option = new ProductAttributeOption();
                option.setOptionName(optionRequest.getOptionName());
                option.setSort(Integer.valueOf(ObjectUtil.isNotNull((Object)optionRequest.getSort()) ? optionRequest.getSort() : 0));
                option.setImage(StrUtil.isNotBlank((CharSequence)optionRequest.getImage()) ? this.systemAttachmentService.clearPrefix(optionRequest.getImage(), cdnUrl) : "");
                return option;
            }).collect(Collectors.toList());
            attrList.add(attr);
            optionMap.put(attr.getAttributeName(), attrOptionList);
        });
        List attrValueList = attrValueAddRequestList.stream().map(e -> {
            ProductAttrValue attrValue = new ProductAttrValue();
            BeanUtils.copyProperties((Object)e, (Object)attrValue);
            attrValue.setId(null);
            attrValue.setSku(this.getSku(e.getAttrValue()));
            attrValue.setQuota(Integer.valueOf(0));
            attrValue.setQuotaShow(Integer.valueOf(0));
            attrValue.setType(product.getType());
            attrValue.setMarketingType(product.getMarketingType());
            attrValue.setImage(this.systemAttachmentService.clearPrefix(e.getImage(), cdnUrl));
            attrValue.setVipPrice(BigDecimal.ZERO);
            return attrValue;
        }).collect(Collectors.toList());
        product.setStock(Integer.valueOf(attrValueList.stream().mapToInt(ProductAttrValue::getStock).sum()));
        ProductDescription spd = new ProductDescription();
        spd.setDescription(StrUtil.isNotBlank((CharSequence)request.getContent()) ? this.systemAttachmentService.clearPrefix(request.getContent(), cdnUrl) : "");
        spd.setType(product.getType());
        spd.setMarketingType(product.getMarketingType());
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean save = this.save(product);
            if (!save) {
                e.setRollbackOnly();
                this.LOGGER.error("\u6dfb\u52a0\u79ef\u5206\u5546\u54c1\u5931\u8d25\uff0crequest = {}", (Object)request);
                return Boolean.FALSE;
            }
            attrList.forEach(attr -> attr.setProductId(product.getId()));
            this.productAttributeService.saveBatch(attrList);
            attrList.forEach(attr -> {
                List optionList = (List)optionMap.get(attr.getAttributeName());
                optionList.forEach(option -> {
                    option.setProductId(attr.getProductId());
                    option.setAttributeId(attr.getId());
                });
                this.productAttributeOptionService.saveBatch(optionList);
            });
            attrValueList.forEach(value -> value.setProductId(product.getId()));
            this.productAttrValueService.saveBatch(attrValueList, 100);
            spd.setProductId(product.getId());
            this.productDescriptionService.deleteByProductId(product.getId(), product.getType(), product.getMarketingType());
            this.productDescriptionService.save(spd);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean updateIntegralProduct(IntegralProductAddRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!request.getSpecType().booleanValue() && request.getAttrValueList().size() > 1) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5355\u89c4\u683c\u5546\u54c1\u5c5e\u6027\u503c\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (StrUtil.isBlank((CharSequence)request.getKeyword())) {
            request.setKeyword("");
        } else if (request.getKeyword().length() > 32) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5173\u952e\u5b57\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
        }
        Product tempProduct = (Product)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)tempProduct) || !tempProduct.getMerId().equals(0)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (tempProduct.getIsRecycle().booleanValue() || tempProduct.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_DELETE);
        }
        Product product = new Product();
        BeanUtils.copyProperties((Object)request, (Object)product);
        product.setType(tempProduct.getType());
        product.setMarketingType(tempProduct.getMarketingType());
        String cdnUrl = this.systemAttachmentService.getCdnUrl();
        product.setImage(this.systemAttachmentService.clearPrefix(product.getImage(), cdnUrl));
        product.setSliderImage(this.systemAttachmentService.clearPrefix(product.getSliderImage(), cdnUrl));
        List attrValueAddRequestList = request.getAttrValueList();
        IntegralProductAttrValueAddRequest tempAttrValue = attrValueAddRequestList.stream().min(Comparator.comparing(IntegralProductAttrValueAddRequest::getRedeemIntegral)).get();
        List minAttrValueList = attrValueAddRequestList.stream().filter(e -> e.getRedeemIntegral().equals(tempAttrValue.getRedeemIntegral())).collect(Collectors.toList());
        IntegralProductAttrValueAddRequest minAttrValue = minAttrValueList.size() > 1 ? minAttrValueList.stream().min(Comparator.comparing(IntegralProductAttrValueAddRequest::getPrice)).get() : tempAttrValue;
        product.setRedeemIntegral(minAttrValue.getRedeemIntegral());
        product.setPrice(minAttrValue.getPrice());
        product.setCost(minAttrValue.getCost());
        List addRequestList = request.getAttrList();
        ArrayList attrList = new ArrayList();
        HashMap optionMap = new HashMap();
        addRequestList.forEach(attrRequest -> {
            ProductAttribute attr = new ProductAttribute();
            attr.setProductId(product.getId());
            attr.setAttributeName(attrRequest.getAttributeName());
            attr.setIsShowImage(attrRequest.getIsShowImage());
            attr.setSort(Integer.valueOf(ObjectUtil.isNotNull((Object)attrRequest.getSort()) ? attrRequest.getSort() : 0));
            List optionRequestList = attrRequest.getOptionList();
            List attrOptionList = optionRequestList.stream().map(optionRequest -> {
                ProductAttributeOption option = new ProductAttributeOption();
                option.setProductId(product.getId());
                option.setOptionName(optionRequest.getOptionName());
                option.setSort(Integer.valueOf(ObjectUtil.isNotNull((Object)optionRequest.getSort()) ? optionRequest.getSort() : 0));
                option.setImage(StrUtil.isNotBlank((CharSequence)optionRequest.getImage()) ? this.systemAttachmentService.clearPrefix(optionRequest.getImage(), cdnUrl) : "");
                return option;
            }).collect(Collectors.toList());
            attrList.add(attr);
            optionMap.put(attr.getAttributeName(), attrOptionList);
        });
        ArrayList attrValueAddList = CollUtil.newArrayList((Object[])new ProductAttrValue[0]);
        ArrayList attrValueUpdateList = CollUtil.newArrayList((Object[])new ProductAttrValue[0]);
        attrValueAddRequestList.forEach(e -> {
            ProductAttrValue attrValue = new ProductAttrValue();
            BeanUtils.copyProperties((Object)e, (Object)attrValue);
            attrValue.setSku(this.getSku(e.getAttrValue()));
            attrValue.setImage(this.systemAttachmentService.clearPrefix(e.getImage(), cdnUrl));
            attrValue.setVersion(Integer.valueOf(0));
            attrValue.setType(product.getType());
            attrValue.setMarketingType(product.getMarketingType());
            attrValue.setVipPrice(BigDecimal.ZERO);
            if (ObjectUtil.isNull((Object)attrValue.getId()) || attrValue.getId().equals(0)) {
                attrValue.setId(null);
                attrValue.setProductId(product.getId());
                attrValue.setQuota(Integer.valueOf(0));
                attrValue.setQuotaShow(Integer.valueOf(0));
                attrValueAddList.add(attrValue);
            } else {
                attrValue.setProductId(product.getId());
                attrValue.setIsDel(Boolean.valueOf(false));
                attrValueUpdateList.add(attrValue);
            }
        });
        product.setStock(Integer.valueOf(attrValueAddRequestList.stream().mapToInt(IntegralProductAttrValueAddRequest::getStock).sum()));
        product.setUpdateTime((Date)DateUtil.date());
        ProductDescription spd = new ProductDescription();
        spd.setDescription(StrUtil.isNotBlank((CharSequence)request.getContent()) ? this.systemAttachmentService.clearPrefix(request.getContent(), cdnUrl) : "");
        spd.setType(product.getType());
        spd.setMarketingType(product.getMarketingType());
        spd.setProductId(product.getId());
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.updateById(product);
            this.productAttributeService.deleteByProductUpdate(product.getId());
            this.productAttributeOptionService.deleteByProductUpdate(product.getId());
            this.productAttrValueService.deleteByProductIdAndType(product.getId(), product.getType(), product.getMarketingType());
            this.productAttributeService.saveBatch(attrList);
            attrList.forEach(attr -> {
                List optionList = (List)optionMap.get(attr.getAttributeName());
                optionList.forEach(option -> option.setAttributeId(attr.getId()));
                this.productAttributeOptionService.saveBatch(optionList);
            });
            if (CollUtil.isNotEmpty((Collection)attrValueAddList)) {
                this.productAttrValueService.saveBatch(attrValueAddList);
            }
            if (CollUtil.isNotEmpty((Collection)attrValueUpdateList)) {
                this.productAttrValueService.saveOrUpdateBatch(attrValueUpdateList);
            }
            this.productDescriptionService.deleteByProductId(product.getId(), product.getType(), product.getMarketingType());
            this.productDescriptionService.save(spd);
            return Boolean.TRUE;
        });
    }

    @Override
    public IntegralProductDetailResponse getIntegralProductDetail(Integer id) {
        Product product = (Product)this.dao.selectById(id);
        if (ObjectUtil.isNull((Object)product) || product.getMerId() > 0) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        IntegralProductDetailResponse response = new IntegralProductDetailResponse();
        BeanUtils.copyProperties((Object)product, (Object)response);
        List<ProductAttribute> attrList = this.productAttributeService.findListByProductId(product.getId());
        attrList.forEach(attr -> {
            List<ProductAttributeOption> optionList = this.productAttributeOptionService.findListByAttrId(attr.getId());
            attr.setOptionList(optionList);
        });
        response.setAttrList(attrList);
        List<ProductAttrValue> attrValueList = this.productAttrValueService.getListByProductIdAndType(product.getId(), product.getType(), product.getMarketingType(), false);
        List valueResponseList = attrValueList.stream().map(e -> {
            AttrValueResponse valueResponse = new AttrValueResponse();
            BeanUtils.copyProperties((Object)e, (Object)valueResponse);
            return valueResponse;
        }).collect(Collectors.toList());
        response.setAttrValueList(valueResponseList);
        ProductDescription sd = this.productDescriptionService.getByProductIdAndType(product.getId(), product.getType(), product.getMarketingType());
        response.setContent(sd.getDescription());
        return response;
    }

    @Override
    public Boolean deleteIntegralProduct(Integer id) {
        Product tempProduct = (Product)this.getById(id);
        if (ObjectUtil.isNull((Object)tempProduct) || !tempProduct.getMerId().equals(0)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        if (tempProduct.getIsDel().booleanValue()) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_DELETE);
        }
        tempProduct.setIsDel(Boolean.valueOf(true));
        tempProduct.setUpdateTime((Date)DateUtil.date());
        return this.updateById(tempProduct);
    }

    @Override
    public MyRecord getIntegralProductTabsHeader(IntegralProductTabsHeaderRequest request) {
        int compareDateResult;
        String keywords = "";
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            keywords = URLUtil.decode((String)request.getKeywords());
        }
        DateLimitUtilVo dateLimit = null;
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit()) && (compareDateResult = CrmebDateUtil.compareDate((String)(dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit())).getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss")) == -1) {
            throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        MyRecord record = new MyRecord();
        record.set("upNum", (Object)this.getIntegralProductShowNum(true, keywords, dateLimit));
        record.set("downNum", (Object)this.getIntegralProductShowNum(false, keywords, dateLimit));
        return record;
    }

    @Override
    public PageInfo<IntegralProductPageResponse> getIntegralProductPageByPlat(IntegralProductPageSearchRequest request) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Product::getMerId, (Object)0);
        lqw.eq(Product::getIsShow, (Object)request.getIsShow());
        lqw.eq(Product::getIsDel, (Object)0);
        lqw.eq(Product::getType, (Object)ProductConstants.PRODUCT_TYPE_INTEGRAL);
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Product::getName, (Object)keywords)).or()).apply(" find_in_set({0}, keyword)", new Object[]{keywords});
            });
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            int compareDateResult = CrmebDateUtil.compareDate((String)dateLimit.getEndTime(), (String)dateLimit.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (compareDateResult == -1) {
                throw new CrmebException((IResultEnum)CommonResultCode.VALIDATE_FAILED, "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
            }
            lqw.between(Product::getCreateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        ((LambdaQueryWrapper)lqw.orderByDesc(Product::getSort)).orderByDesc(Product::getId);
        Page productPage = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List productList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)productList)) {
            return CommonPage.copyPageInfo((Page)productPage, (List)CollUtil.newArrayList((Object[])new IntegralProductPageResponse[0]));
        }
        ArrayList<IntegralProductPageResponse> productResponses = new ArrayList<IntegralProductPageResponse>();
        for (Product product : productList) {
            IntegralProductPageResponse productResponse = new IntegralProductPageResponse();
            BeanUtils.copyProperties((Object)product, (Object)productResponse);
            productResponses.add(productResponse);
        }
        return CommonPage.copyPageInfo((Page)productPage, productResponses);
    }

    private int getIntegralProductShowNum(Boolean isShow, String keywords, DateLimitUtilVo dateLimit) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Product::getMerId, (Object)0);
        lqw.eq(Product::getIsShow, (Object)isShow);
        lqw.eq(Product::getType, (Object)ProductConstants.PRODUCT_TYPE_INTEGRAL);
        if (StrUtil.isNotBlank((CharSequence)keywords)) {
            lqw.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(Product::getName, (Object)keywords)).or()).apply(" find_in_set({0}, keyword)", new Object[]{keywords});
            });
        }
        if (ObjectUtil.isNotNull((Object)dateLimit)) {
            lqw.between(Product::getCreateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        lqw.eq(Product::getIsDel, (Object)false);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public PageInfo<IntegralProductFrontResponse> findIntegralProductHotPage(PageParamRequest request) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Product::getMerId, (Object)0);
        lqw.eq(Product::getIsShow, (Object)1);
        lqw.eq(Product::getIsDel, (Object)0);
        lqw.eq(Product::getIsHot, (Object)1);
        lqw.eq(Product::getType, (Object)ProductConstants.PRODUCT_TYPE_INTEGRAL);
        ((LambdaQueryWrapper)lqw.orderByDesc(Product::getSort)).orderByDesc(Product::getId);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List productList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)productList)) {
            return CommonPage.copyPageInfo((Page)page, new ArrayList());
        }
        List responseList = productList.stream().map(product -> {
            IntegralProductFrontResponse response = new IntegralProductFrontResponse();
            BeanUtils.copyProperties((Object)product, (Object)response);
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)page, responseList);
    }

    @Override
    public PageInfo<IntegralProductFrontResponse> findIntegralIntervalProductPage(int startIntegral, int endIntegral, int page, int limit) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(Product::getMerId, (Object)0);
        lqw.eq(Product::getIsShow, (Object)1);
        lqw.eq(Product::getIsDel, (Object)0);
        lqw.eq(Product::getType, (Object)ProductConstants.PRODUCT_TYPE_INTEGRAL);
        if (startIntegral >= 0 && endIntegral > 0) {
            lqw.ge(Product::getRedeemIntegral, (Object)startIntegral);
            lqw.le(Product::getRedeemIntegral, (Object)endIntegral);
        }
        ((LambdaQueryWrapper)lqw.orderByDesc(Product::getSort)).orderByDesc(Product::getId);
        Page productPage = PageHelper.startPage((int)page, (int)limit);
        List productList = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)productList)) {
            return CommonPage.copyPageInfo((Page)productPage, new ArrayList());
        }
        List responseList = productList.stream().map(product -> {
            IntegralProductFrontResponse response = new IntegralProductFrontResponse();
            BeanUtils.copyProperties((Object)product, (Object)response);
            return response;
        }).collect(Collectors.toList());
        return CommonPage.copyPageInfo((Page)productPage, responseList);
    }

    @Override
    public Boolean updateShowIntegralProduct(Integer id) {
        Product product = this.getByIdException(id);
        if (product.getMerId() > 0 || !product.getType().equals(ProductConstants.PRODUCT_TYPE_INTEGRAL)) {
            throw new CrmebException((IResultEnum)ProductResultCode.PRODUCT_NOT_EXIST);
        }
        Product tempProduct = new Product();
        tempProduct.setId(product.getId());
        tempProduct.setIsShow(Boolean.valueOf(product.getIsShow() == false));
        tempProduct.setUpdateTime((Date)DateUtil.date());
        return this.updateById(tempProduct);
    }

    @Override
    public Integer getAwaitAuditNumByMerIds(List<Integer> merIds) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
        lqw.eq(Product::getIsAudit, (Object)true);
        lqw.eq(Product::getIsRecycle, (Object)false);
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.eq(Product::getAuditStatus, (Object)ProductConstants.AUDIT_STATUS_WAIT);
        lqw.eq(Product::getIsAudit, (Object)true);
        lqw.eq(Product::getIsRecycle, (Object)false);
        lqw.eq(Product::getIsDel, (Object)false);
        lqw.in(Product::getMerId, merIds);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public PageInfo<PlatformProductListResponse> getCircleProductList(PlatProductSearchRequest request, List<Integer> merIdList) {
        if (CollUtil.isEmpty(merIdList)) {
            return CommonPage.copyPageInfo((Page)new Page(), new ArrayList());
        }
        HashMap map = CollUtil.newHashMap();
        map.put("type", request.getType());
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            ProductCategory category = (ProductCategory)this.productCategoryService.getById(request.getCategoryId());
            if (category.getLevel().equals(3)) {
                map.put("categoryIds", request.getCategoryId());
            } else {
                List<ProductCategory> categoryList = this.productCategoryService.findAllChildListByPid(category.getId(), category.getLevel());
                List cateIdList = categoryList.stream().filter(e -> e.getLevel().equals(3)).map(e -> e.getId().toString()).collect(Collectors.toList());
                String categoryIds = String.join((CharSequence)",", cateIdList);
                map.put("categoryIds", categoryIds);
            }
        }
        ArrayList<Integer> merIds = new ArrayList<Integer>();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            merIds.add(request.getMerId());
        } else {
            merIds.addAll(merIdList);
        }
        map.put("merIds", merIds);
        if (ObjectUtil.isNotNull((Object)request.getIsSelf())) {
            map.put("self", request.getIsSelf());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            map.put("keywords", keywords);
        }
        if (ObjectUtil.isNotNull((Object)request.getIsPaidMember())) {
            map.put("isPaidMember", request.getIsPaidMember() != false ? 1 : 0);
        }
        if (ObjectUtil.isNotNull((Object)request.getProductType())) {
            map.put("productType", request.getProductType());
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List<PlatformProductListResponse> proList = this.dao.getCircleProductPageList(map);
        return CommonPage.copyPageInfo((Page)page, proList);
    }

    @Override
    public List<ProductTabsHeaderResponse> getCircleProductTabsHeader(PlatProductTabsHeaderRequest request, List<Integer> merIdList) {
        ArrayList<ProductTabsHeaderResponse> headers = new ArrayList<ProductTabsHeaderResponse>();
        ProductTabsHeaderResponse header1 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(1));
        ProductTabsHeaderResponse header2 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(2));
        ProductTabsHeaderResponse header6 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(6));
        ProductTabsHeaderResponse header7 = new ProductTabsHeaderResponse(Integer.valueOf(0), Integer.valueOf(7));
        headers.add(header1);
        headers.add(header2);
        headers.add(header6);
        headers.add(header7);
        if (CollUtil.isEmpty(merIdList)) {
            return headers;
        }
        HashMap map = CollUtil.newHashMap();
        if (ObjectUtil.isNotNull((Object)request.getCategoryId())) {
            ProductCategory category = (ProductCategory)this.productCategoryService.getById(request.getCategoryId());
            if (category.getLevel().equals(3)) {
                map.put("categoryIds", request.getCategoryId());
            } else {
                List<ProductCategory> categoryList = this.productCategoryService.findAllChildListByPid(category.getId(), category.getLevel());
                List cateIdList = categoryList.stream().filter(e -> e.getLevel().equals(3)).map(e -> e.getId().toString()).collect(Collectors.toList());
                String categoryIds = String.join((CharSequence)",", cateIdList);
                map.put("categoryIds", categoryIds);
            }
        }
        ArrayList<Integer> merIds = new ArrayList<Integer>();
        if (ObjectUtil.isNotNull((Object)request.getMerId()) && request.getMerId() > 0) {
            merIds.add(request.getMerId());
        } else {
            merIds.addAll(merIdList);
        }
        map.put("merIds", merIds);
        if (ObjectUtil.isNotNull((Object)request.getIsSelf())) {
            map.put("self", request.getIsSelf());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            map.put("keywords", keywords);
        }
        if (ObjectUtil.isNotNull((Object)request.getIsPaidMember())) {
            map.put("isPaidMember", request.getIsPaidMember() != false ? 1 : 0);
        }
        if (ObjectUtil.isNotNull((Object)request.getProductType())) {
            map.put("productType", request.getProductType());
        }
        for (ProductTabsHeaderResponse h : headers) {
            map.put("type", h.getType());
            h.setCount(this.dao.getCircleProductPageCount(map));
        }
        return headers;
    }

    public List<Product> findRegionProductList(List<Integer> merIdList, Integer num) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getImage, Product::getName, Product::getUnitName, Product::getPrice, Product::getOtPrice, Product::getSales, Product::getFicti, Product::getCategoryId, Product::getBrandId, Product::getIsPaidMember, Product::getVipPrice, Product::getStock});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        if (CollUtil.isNotEmpty(merIdList)) {
            lqw.in(Product::getMerId, merIdList);
        }
        lqw.gt(Product::getStock, (Object)0);
        lqw.in(Product::getType, new Object[]{ProductConstants.PRODUCT_TYPE_NORMAL, ProductConstants.PRODUCT_TYPE_VIRTUALLY, ProductConstants.PRODUCT_TYPE_CLOUD, ProductConstants.PRODUCT_TYPE_CDKEY, ProductConstants.PRODUCT_TYPE_RESERVATION});
        lqw.eq(Product::getMarketingType, (Object)ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        lqw.orderByDesc(Product::getRank);
        lqw.orderByDesc(Product::getId);
        if (ObjectUtil.isNotNull((Object)num) && num > 0) {
            lqw.last(" limit " + num);
        }
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Product> findCircleProductList(List<Integer> merIdList, Integer num) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{Product::getId, Product::getMerId, Product::getImage, Product::getName, Product::getUnitName, Product::getPrice, Product::getOtPrice, Product::getSales, Product::getFicti, Product::getCategoryId, Product::getBrandId, Product::getIsPaidMember, Product::getVipPrice, Product::getStock});
        this.getForSaleWhere((LambdaQueryWrapper<Product>)lqw);
        if (CollUtil.isNotEmpty(merIdList)) {
            lqw.in(Product::getMerId, merIdList);
        }
        lqw.gt(Product::getStock, (Object)0);
        lqw.in(Product::getType, new Object[]{ProductConstants.PRODUCT_TYPE_NORMAL, ProductConstants.PRODUCT_TYPE_VIRTUALLY, ProductConstants.PRODUCT_TYPE_CLOUD, ProductConstants.PRODUCT_TYPE_CDKEY, ProductConstants.PRODUCT_TYPE_RESERVATION});
        lqw.eq(Product::getMarketingType, (Object)ProductConstants.PRODUCT_MARKETING_TYPE_BASE);
        lqw.orderByDesc(Product::getRank);
        lqw.orderByDesc(Product::getId);
        if (ObjectUtil.isNotNull((Object)num) && num > 0) {
            lqw.last(" limit " + num);
        }
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<Product> findIndexProductListComponent(String cids, String brandIds, String merIds, String proIds, String lastStr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)cids)) {
            map.put("cids", cids);
        }
        if (StrUtil.isNotBlank((CharSequence)brandIds)) {
            map.put("brandIds", brandIds);
        }
        if (StrUtil.isNotBlank((CharSequence)merIds)) {
            map.put("merIds", merIds);
        }
        if (StrUtil.isNotBlank((CharSequence)proIds)) {
            map.put("proIds", proIds);
        }
        map.put("lastStr", lastStr);
        List<Product> productList = this.dao.findIndexProductListComponent(map);
        if (CollUtil.isEmpty(productList)) {
            return new ArrayList<Product>();
        }
        return this.activityStyleService.makeActivityBorderStyle(productList);
    }

    private String convertToTimeSlotJson(List<TimeSlot> timeSlotList) {
        ArrayList jsonList = new ArrayList();
        ObjectMapper objectMapper = new ObjectMapper();
        for (TimeSlot request : timeSlotList) {
            HashMap<String, Object> slotMap = new HashMap<String, Object>();
            slotMap.put("timeSlot", request.getTimeSlot().trim());
            slotMap.put("isCheck", request.getIsCheck() != null ? request.getIsCheck() : 0);
            jsonList.add(slotMap);
        }
        try {
            return objectMapper.writeValueAsString(jsonList);
        }
        catch (Exception e) {
            throw new CrmebException("\u9884\u7ea6\u5546\u54c1\u65f6\u95f4\u6bb5\u53c2\u6570\u8f6c\u5316\u5f02\u5e38");
        }
    }

    private List<TimeSlot> parseTimeSlotJson(String timeSlotJson) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (List)objectMapper.readValue(timeSlotJson, (TypeReference)new TypeReference<List<TimeSlot>>(){});
        }
        catch (Exception e) {
            throw new CrmebException("\u9884\u7ea6\u5546\u54c1\u65f6\u95f4\u6bb5\u53c2\u6570\u8f6c\u5316\u5f02\u5e38");
        }
    }
}

