/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.github.binarywang.wxpay.bean.notify.SignatureHeader;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyV3Response;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyV3Result;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyV3Result;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.AlipayConfig;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.alipay.AliPayCallback;
import com.zbkj.common.model.member.PaidMemberOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.wechat.WechatPayInfo;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.AttachVo;
import com.zbkj.service.service.AliPayCallbackService;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.OrderFlowRecordService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.PaidMemberOrderService;
import com.zbkj.service.service.PayCallbackService;
import com.zbkj.service.service.RechargeOrderService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.WechatPayInfoService;
import com.zbkj.service.service.WechatPayService;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PayCallbackServiceImpl
implements PayCallbackService {
    private static final Logger logger = LoggerFactory.getLogger(PayCallbackServiceImpl.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private UserService userService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private WechatPayInfoService wechatPayInfoService;
    @Autowired
    private RechargeOrderService rechargeOrderService;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private AliPayCallbackService aliPayCallbackService;
    @Autowired
    private PaidMemberOrderService paidMemberOrderService;
    @Autowired
    private WechatPayService wechatPayService;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private OrderFlowRecordService orderFlowRecordService;

    @Override
    public ResponseEntity<String> wechatMaPayCallback(String notifyData, HttpServletRequest servletRequest) {
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayOrderNotifyResult wxPayOrderNotifyResult = this.wechatPayService.parseOrderNotifyResult(notifyData, "ma");
            String callback = this.wechatCommonPayCallback(wxPayOrderNotifyResult);
            return ResponseEntity.status((int)200).body((Object)callback);
        }
        SignatureHeader header = this.getRequestHeader(servletRequest);
        try {
            WxPayNotifyV3Result wxPayNotifyV3Result = this.wechatPayService.parseOrderNotifyV3Result(notifyData, header, "ma");
            this.wechatCommonPayCallbackV3(wxPayNotifyV3Result);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)WxPayNotifyV3Response.fail((String)"\u9519\u8bef"));
        }
        return ResponseEntity.status((int)200).body((Object)"");
    }

    @Override
    public ResponseEntity<String> wechatMpPayCallback(String notifyData, HttpServletRequest servletRequest) {
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayOrderNotifyResult wxPayOrderNotifyResult = this.wechatPayService.parseOrderNotifyResult(notifyData, "mp");
            String callback = this.wechatCommonPayCallback(wxPayOrderNotifyResult);
            return ResponseEntity.status((int)200).body((Object)callback);
        }
        SignatureHeader header = this.getRequestHeader(servletRequest);
        try {
            WxPayNotifyV3Result wxPayNotifyV3Result = this.wechatPayService.parseOrderNotifyV3Result(notifyData, header, "mp");
            this.wechatCommonPayCallbackV3(wxPayNotifyV3Result);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)WxPayNotifyV3Response.fail((String)"\u9519\u8bef"));
        }
        return ResponseEntity.status((int)200).body((Object)"");
    }

    @Override
    public ResponseEntity<String> wechatAPPPayCallback(String notifyData, HttpServletRequest servletRequest) {
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayOrderNotifyResult wxPayOrderNotifyResult = this.wechatPayService.parseOrderNotifyResult(notifyData, "app");
            String callback = this.wechatCommonPayCallback(wxPayOrderNotifyResult);
            return ResponseEntity.status((int)200).body((Object)callback);
        }
        SignatureHeader header = this.getRequestHeader(servletRequest);
        try {
            WxPayNotifyV3Result wxPayNotifyV3Result = this.wechatPayService.parseOrderNotifyV3Result(notifyData, header, "app");
            this.wechatCommonPayCallbackV3(wxPayNotifyV3Result);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)WxPayNotifyV3Response.fail((String)"\u9519\u8bef"));
        }
        return ResponseEntity.status((int)200).body((Object)"");
    }

    private String wechatCommonPayCallback(WxPayOrderNotifyResult wxPayOrderNotifyResult) {
        String attach = wxPayOrderNotifyResult.getAttach();
        AttachVo attachVo = (AttachVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)attach), AttachVo.class);
        User user = (User)this.userService.getById(attachVo.getUserId());
        if (ObjectUtil.isNull((Object)user)) {
            logger.error("\u5fae\u4fe1\u56de\u8c03\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u7528\u6237\u4fe1\u606f");
            return WxPayNotifyResponse.fail((String)"\u4e3a\u67e5\u8be2\u5230\u652f\u4ed8\u7528\u6237");
        }
        switch (attachVo.getType()) {
            case "order": {
                return this.wechatPayOrderCallback(wxPayOrderNotifyResult);
            }
            case "recharge": {
                return this.wechatRechargeOrderCallback(wxPayOrderNotifyResult);
            }
            case "svip": {
                return this.wechatSvipOrderCallback(wxPayOrderNotifyResult);
            }
        }
        logger.error("wechat pay err : \u672a\u77e5\u7684\u8ba2\u5355\u7c7b\u578b==\u300b" + attachVo.getType());
        throw new CrmebException("\u672a\u77e5\u7684\u8ba2\u5355\u7c7b\u578b\uff01");
    }

    private ResponseEntity<String> wechatCommonPayCallbackV3(WxPayNotifyV3Result wxPayNotifyV3Result) {
        WxPayNotifyV3Result.DecryptNotifyResult decryptRes = wxPayNotifyV3Result.getResult();
        if (!"SUCCESS".equals(decryptRes.getTradeState())) {
            return ResponseEntity.status((int)500).body((Object)WxPayNotifyV3Response.fail((String)"\u652f\u4ed8\u672a\u6210\u529f"));
        }
        String attach = decryptRes.getAttach();
        AttachVo attachVo = (AttachVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)attach), AttachVo.class);
        User user = (User)this.userService.getById(attachVo.getUserId());
        if (ObjectUtil.isNull((Object)user)) {
            logger.error("\u5fae\u4fe1\u56de\u8c03\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u7528\u6237\u4fe1\u606f");
            return ResponseEntity.status((int)200).body((Object)"");
        }
        switch (attachVo.getType()) {
            case "order": {
                this.wechatPayOrderCallbackV3(wxPayNotifyV3Result);
                break;
            }
            case "recharge": {
                this.wechatRechargeOrderCallbackV3(wxPayNotifyV3Result);
                break;
            }
            case "svip": {
                this.wechatSvipOrderCallbackV3(wxPayNotifyV3Result);
                break;
            }
            default: {
                logger.error("wechat pay err : \u672a\u77e5\u7684\u8ba2\u5355\u7c7b\u578b==\u300b" + attachVo.getType());
            }
        }
        return ResponseEntity.status((int)200).body((Object)"");
    }

    private String wechatPayOrderCallback(WxPayOrderNotifyResult wxPayOrderNotifyResult, String xmlInfo, User user) {
        Order order = this.orderService.getByOutTradeNo(wxPayOrderNotifyResult.getOutTradeNo());
        if (ObjectUtil.isNull((Object)order) || !order.getUid().equals(user.getId())) {
            logger.error("wechat pay error : \u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        if (order.getPaid().booleanValue()) {
            return WxPayNotifyResponse.success((String)"\u6210\u529f");
        }
        String paySource = order.getPayChannel();
        if (paySource.equals("h5") || paySource.equals("native")) {
            String source = this.systemConfigService.getValueByKey("wechat_pay_source");
            paySource = StrUtil.isNotBlank((CharSequence)source) && source.equals("mini") ? "mini" : "public";
        }
        WxPayOrderNotifyResult notifyResult = this.wechatPayService.parseOrderNotifyResult(xmlInfo, paySource);
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(order.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            logger.error("wechat pay error : \u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + notifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + notifyResult.getOutTradeNo());
        }
        wechatPayInfo.setIsSubscribe(notifyResult.getIsSubscribe());
        wechatPayInfo.setBankType(notifyResult.getBankType());
        wechatPayInfo.setCashFee(notifyResult.getCashFee());
        wechatPayInfo.setCouponFee(notifyResult.getCouponFee());
        wechatPayInfo.setTransactionId(notifyResult.getTransactionId());
        wechatPayInfo.setTimeEnd(notifyResult.getTimeEnd());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            order.setPaid(Boolean.valueOf(true));
            order.setPayTime(CrmebDateUtil.nowDateTime());
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
            this.wechatPayInfoService.updateById(wechatPayInfo);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error("wechat pay error : \u8ba2\u5355\u66f4\u65b0\u5931\u8d25==\u300b" + notifyResult.getOutTradeNo());
            return WxPayNotifyResponse.fail((String)"\u8ba2\u5355\u66f4\u65b0\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }

    private String wechatRechargeOrderCallback(WxPayOrderNotifyResult wxPayOrderNotifyResult, String xmlInfo, User user) {
        RechargeOrder rechargeOrder = this.rechargeOrderService.getByOutTradeNo(wxPayOrderNotifyResult.getOutTradeNo());
        if (ObjectUtil.isNull((Object)rechargeOrder) || !rechargeOrder.getUid().equals(user.getId())) {
            logger.error("wechat pay error : \u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        if (rechargeOrder.getPaid().booleanValue()) {
            return WxPayNotifyResponse.success((String)"\u6210\u529f");
        }
        String paySource = rechargeOrder.getPayChannel();
        if (paySource.equals("h5") || paySource.equals("native")) {
            String source = this.systemConfigService.getValueByKey("wechat_pay_source");
            paySource = StrUtil.isNotBlank((CharSequence)source) && source.equals("mini") ? "mini" : "public";
        }
        WxPayOrderNotifyResult notifyResult = this.wechatPayService.parseOrderNotifyResult(xmlInfo, paySource);
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(rechargeOrder.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            logger.error("wechat pay error : \u5fae\u4fe1\u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + notifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5fae\u4fe1\u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + notifyResult.getOutTradeNo());
        }
        wechatPayInfo.setIsSubscribe(notifyResult.getIsSubscribe());
        wechatPayInfo.setBankType(notifyResult.getBankType());
        wechatPayInfo.setCashFee(notifyResult.getCashFee());
        wechatPayInfo.setCouponFee(notifyResult.getCouponFee());
        wechatPayInfo.setTransactionId(notifyResult.getTransactionId());
        wechatPayInfo.setTimeEnd(notifyResult.getTimeEnd());
        this.wechatPayInfoService.updateById(wechatPayInfo);
        Boolean rechargePayAfter = this.rechargeOrderService.paySuccessAfter(rechargeOrder);
        if (!rechargePayAfter.booleanValue()) {
            logger.error("wechat recharge pay after error : \u5145\u503c\u8ba2\u5355\u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + notifyResult.getOutTradeNo());
            throw new CrmebException("wechat recharge pay after error : \u5145\u503c\u8ba2\u5355\u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + notifyResult.getOutTradeNo());
        }
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }

    private String wechatSvipOrderCallback(WxPayOrderNotifyResult wxPayOrderNotifyResult, String xmlInfo, User user) {
        PaidMemberOrder svipOrder = this.paidMemberOrderService.getByOutTradeNo(wxPayOrderNotifyResult.getOutTradeNo());
        if (ObjectUtil.isNull((Object)svipOrder) || !svipOrder.getUid().equals(user.getId())) {
            logger.error("wechat pay error : SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        if (svipOrder.getPaid().booleanValue()) {
            return WxPayNotifyResponse.success((String)"\u6210\u529f");
        }
        String paySource = svipOrder.getPayChannel();
        if (paySource.equals("h5") || paySource.equals("native")) {
            String source = this.systemConfigService.getValueByKey("wechat_pay_source");
            paySource = StrUtil.isNotBlank((CharSequence)source) && source.equals("mini") ? "mini" : "public";
        }
        WxPayOrderNotifyResult notifyResult = this.wechatPayService.parseOrderNotifyResult(xmlInfo, paySource);
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(svipOrder.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            logger.error("wechat pay error : \u5fae\u4fe1SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + notifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5fae\u4fe1SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + notifyResult.getOutTradeNo());
        }
        wechatPayInfo.setIsSubscribe(notifyResult.getIsSubscribe());
        wechatPayInfo.setBankType(notifyResult.getBankType());
        wechatPayInfo.setCashFee(notifyResult.getCashFee());
        wechatPayInfo.setCouponFee(notifyResult.getCouponFee());
        wechatPayInfo.setTransactionId(notifyResult.getTransactionId());
        wechatPayInfo.setTimeEnd(notifyResult.getTimeEnd());
        this.wechatPayInfoService.updateById(wechatPayInfo);
        Boolean svipPayAfter = this.paidMemberOrderService.paySuccessAfter(svipOrder);
        if (!svipPayAfter.booleanValue()) {
            logger.error("wechat recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + notifyResult.getOutTradeNo());
            throw new CrmebException("wechat recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + notifyResult.getOutTradeNo());
        }
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }

    private String wechatPayOrderCallback(WxPayOrderNotifyResult wxPayOrderNotifyResult) {
        Order order = this.orderService.getByOutTradeNo(wxPayOrderNotifyResult.getOutTradeNo());
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("wechat pay error : \u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        if (order.getPaid().booleanValue()) {
            return WxPayNotifyResponse.success((String)"\u6210\u529f");
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(order.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            logger.error("wechat pay error : \u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        wechatPayInfo.setIsSubscribe(wxPayOrderNotifyResult.getIsSubscribe());
        wechatPayInfo.setBankType(wxPayOrderNotifyResult.getBankType());
        wechatPayInfo.setCashFee(wxPayOrderNotifyResult.getCashFee());
        wechatPayInfo.setCouponFee(wxPayOrderNotifyResult.getCouponFee());
        wechatPayInfo.setTransactionId(wxPayOrderNotifyResult.getTransactionId());
        wechatPayInfo.setTimeEnd(wxPayOrderNotifyResult.getTimeEnd());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            order.setPaid(Boolean.valueOf(true));
            order.setPayTime(CrmebDateUtil.nowDateTime());
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
            this.wechatPayInfoService.updateById(wechatPayInfo);
            this.orderFlowRecordService.orderPaid(order.getOrderNo(), order.getUid());
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error("wechat pay error : \u8ba2\u5355\u66f4\u65b0\u5931\u8d25==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            return WxPayNotifyResponse.fail((String)"\u8ba2\u5355\u66f4\u65b0\u5931\u8d25");
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }

    private String wechatRechargeOrderCallback(WxPayOrderNotifyResult wxPayOrderNotifyResult) {
        RechargeOrder rechargeOrder = this.rechargeOrderService.getByOutTradeNo(wxPayOrderNotifyResult.getOutTradeNo());
        if (ObjectUtil.isNull((Object)rechargeOrder)) {
            logger.error("wechat pay error : \u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        if (rechargeOrder.getPaid().booleanValue()) {
            return WxPayNotifyResponse.success((String)"\u6210\u529f");
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(rechargeOrder.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            logger.error("wechat pay error : \u5fae\u4fe1\u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5fae\u4fe1\u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        wechatPayInfo.setIsSubscribe(wxPayOrderNotifyResult.getIsSubscribe());
        wechatPayInfo.setBankType(wxPayOrderNotifyResult.getBankType());
        wechatPayInfo.setCashFee(wxPayOrderNotifyResult.getCashFee());
        wechatPayInfo.setCouponFee(wxPayOrderNotifyResult.getCouponFee());
        wechatPayInfo.setTransactionId(wxPayOrderNotifyResult.getTransactionId());
        wechatPayInfo.setTimeEnd(wxPayOrderNotifyResult.getTimeEnd());
        this.wechatPayInfoService.updateById(wechatPayInfo);
        Boolean rechargePayAfter = this.rechargeOrderService.paySuccessAfter(rechargeOrder);
        if (!rechargePayAfter.booleanValue()) {
            logger.error("wechat recharge pay after error : \u5145\u503c\u8ba2\u5355\u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat recharge pay after error : \u5145\u503c\u8ba2\u5355\u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }

    private String wechatSvipOrderCallback(WxPayOrderNotifyResult wxPayOrderNotifyResult) {
        PaidMemberOrder svipOrder = this.paidMemberOrderService.getByOutTradeNo(wxPayOrderNotifyResult.getOutTradeNo());
        if (ObjectUtil.isNull((Object)svipOrder)) {
            logger.error("wechat pay error : SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        if (svipOrder.getPaid().booleanValue()) {
            return WxPayNotifyResponse.success((String)"\u6210\u529f");
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(svipOrder.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            logger.error("wechat pay error : \u5fae\u4fe1SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat pay error : \u5fae\u4fe1SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        wechatPayInfo.setIsSubscribe(wxPayOrderNotifyResult.getIsSubscribe());
        wechatPayInfo.setBankType(wxPayOrderNotifyResult.getBankType());
        wechatPayInfo.setCashFee(wxPayOrderNotifyResult.getCashFee());
        wechatPayInfo.setCouponFee(wxPayOrderNotifyResult.getCouponFee());
        wechatPayInfo.setTransactionId(wxPayOrderNotifyResult.getTransactionId());
        wechatPayInfo.setTimeEnd(wxPayOrderNotifyResult.getTimeEnd());
        this.wechatPayInfoService.updateById(wechatPayInfo);
        Boolean svipPayAfter = this.paidMemberOrderService.paySuccessAfter(svipOrder);
        if (!svipPayAfter.booleanValue()) {
            logger.error("wechat recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
            throw new CrmebException("wechat recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + wxPayOrderNotifyResult.getOutTradeNo());
        }
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }

    private void wechatPayOrderCallbackV3(WxPayNotifyV3Result wxPayNotifyV3Result) {
        WxPayNotifyV3Result.DecryptNotifyResult decryptRes = wxPayNotifyV3Result.getResult();
        String outTradeNo = decryptRes.getOutTradeNo();
        Order order = this.orderService.getByOutTradeNo(outTradeNo);
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("wechat pay error : \u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + outTradeNo);
            return;
        }
        if (order.getPaid().booleanValue()) {
            logger.info("wechat pay info : \u5546\u57ce\u8ba2\u5355\u4fe1\u606f\u5df2\u652f\u4ed8==\u300b" + outTradeNo);
            return;
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(order.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            logger.error("wechat pay error : \u5fae\u4fe1\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + outTradeNo);
            return;
        }
        wechatPayInfo.setBankType(decryptRes.getBankType());
        wechatPayInfo.setTransactionId(decryptRes.getTransactionId());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            order.setPaid(Boolean.valueOf(true));
            order.setPayTime(CrmebDateUtil.nowDateTime());
            order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
            order.setUpdateTime((Date)DateUtil.date());
            this.orderService.updateById(order);
            this.wechatPayInfoService.updateById(wechatPayInfo);
            this.orderFlowRecordService.orderPaid(order.getOrderNo(), order.getUid());
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error("wechat pay error : \u8ba2\u5355\u66f4\u65b0\u5931\u8d25==\u300b" + outTradeNo);
            return;
        }
        this.asyncService.orderPaySuccessSplit(order.getOrderNo());
    }

    private void wechatRechargeOrderCallbackV3(WxPayNotifyV3Result wxPayNotifyV3Result) {
        WxPayNotifyV3Result.DecryptNotifyResult decryptRes = wxPayNotifyV3Result.getResult();
        String outTradeNo = decryptRes.getOutTradeNo();
        RechargeOrder rechargeOrder = this.rechargeOrderService.getByOutTradeNo(outTradeNo);
        if (ObjectUtil.isNull((Object)rechargeOrder)) {
            logger.error("wechat pay error : \u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + outTradeNo);
            return;
        }
        if (rechargeOrder.getPaid().booleanValue()) {
            logger.info("wechat pay info : \u5145\u503c\u8ba2\u5355\u4fe1\u606f\u5df2\u652f\u4ed8==\u300b" + outTradeNo);
            return;
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(rechargeOrder.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            logger.error("wechat pay error : \u5fae\u4fe1\u5145\u503c\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + outTradeNo);
            return;
        }
        wechatPayInfo.setBankType(decryptRes.getBankType());
        wechatPayInfo.setTransactionId(decryptRes.getTransactionId());
        this.wechatPayInfoService.updateById(wechatPayInfo);
        Boolean rechargePayAfter = this.rechargeOrderService.paySuccessAfter(rechargeOrder);
        if (!rechargePayAfter.booleanValue()) {
            logger.error("wechat recharge pay after error : \u5145\u503c\u8ba2\u5355\u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + outTradeNo);
            return;
        }
    }

    private void wechatSvipOrderCallbackV3(WxPayNotifyV3Result wxPayNotifyV3Result) {
        WxPayNotifyV3Result.DecryptNotifyResult decryptRes = wxPayNotifyV3Result.getResult();
        String outTradeNo = decryptRes.getOutTradeNo();
        PaidMemberOrder svipOrder = this.paidMemberOrderService.getByOutTradeNo(outTradeNo);
        if (ObjectUtil.isNull((Object)svipOrder)) {
            logger.error("wechat pay error : SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + outTradeNo);
            return;
        }
        if (svipOrder.getPaid().booleanValue()) {
            logger.info("wechat pay info : SVIP\u8ba2\u5355\u4fe1\u606f\u5df2\u652f\u4ed8==\u300b" + outTradeNo);
            return;
        }
        WechatPayInfo wechatPayInfo = this.wechatPayInfoService.getByNo(svipOrder.getOutTradeNo());
        if (ObjectUtil.isNull((Object)wechatPayInfo)) {
            logger.error("wechat pay error : \u5fae\u4fe1SVIP\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + outTradeNo);
            return;
        }
        wechatPayInfo.setBankType(decryptRes.getBankType());
        wechatPayInfo.setTransactionId(decryptRes.getTransactionId());
        this.wechatPayInfoService.updateById(wechatPayInfo);
        Boolean svipPayAfter = this.paidMemberOrderService.paySuccessAfter(svipOrder);
        if (!svipPayAfter.booleanValue()) {
            logger.error("wechat recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + outTradeNo);
            return;
        }
    }

    @Override
    public String aliPayCallback(HttpServletRequest request) {
        Map<String, String> params = this.convertRequestParamsToMap(request);
        String paramsJson = JSON.toJSONString(params);
        this.saveAliPayCallbackInfo(params);
        try {
            Order order;
            String outTradeNo = params.get("out_trade_no");
            String outRequestNo = params.get("out_request_no");
            String refundFee = params.get("refund_fee");
            if (StrUtil.isNotBlank((CharSequence)refundFee)) {
                return "success";
            }
            String passbackParams = params.get("passback_params");
            if (StrUtil.isNotBlank((CharSequence)passbackParams)) {
                String decode;
                try {
                    decode = URLDecoder.decode(passbackParams, "utf-8");
                }
                catch (UnsupportedEncodingException e2) {
                    e2.printStackTrace();
                    logger.error("ali pay error : \u8ba2\u5355\u652f\u4ed8\u7c7b\u578b\u89e3\u7801\u5931\u8d25==\u300b" + outTradeNo);
                    return "fail";
                }
                String[] split = decode.split("=");
                String orderType = split[1];
                if ("recharge".equals(orderType)) {
                    RechargeOrder rechargeOrder = this.rechargeOrderService.getByOutTradeNo(outTradeNo);
                    if (ObjectUtil.isNull((Object)rechargeOrder)) {
                        logger.error("ali pay error : \u5145\u503c\u8ba2\u5355\u540e\u7f6e\u5904\u7406\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\uff0c\u652f\u4ed8\u670d\u52a1\u65b9\u8ba2\u5355\u53f7\uff1a{}", (Object)outTradeNo);
                        return "fail";
                    }
                    if (rechargeOrder.getPaid().booleanValue()) {
                        return "success";
                    }
                    Boolean rechargePayAfter = this.rechargeOrderService.paySuccessAfter(rechargeOrder);
                    if (!rechargePayAfter.booleanValue()) {
                        logger.error("ali pay recharge pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + outTradeNo);
                        return "fail";
                    }
                    return "success";
                }
                if ("svip".equals(orderType)) {
                    PaidMemberOrder svipOrder = this.paidMemberOrderService.getByOutTradeNo(outTradeNo);
                    if (ObjectUtil.isNull((Object)svipOrder)) {
                        logger.error("ali pay error : SVIP\u8ba2\u5355\u540e\u7f6e\u5904\u7406\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\uff0c\u652f\u4ed8\u670d\u52a1\u65b9\u8ba2\u5355\u53f7\uff1a{}", (Object)outTradeNo);
                        return "fail";
                    }
                    if (svipOrder.getPaid().booleanValue()) {
                        return "success";
                    }
                    Boolean svipPayAfter = this.paidMemberOrderService.paySuccessAfter(svipOrder);
                    if (!svipPayAfter.booleanValue()) {
                        logger.error("ali pay svip pay after error : \u6570\u636e\u4fdd\u5b58\u5931\u8d25==\u300b" + outTradeNo);
                        return "fail";
                    }
                    return "success";
                }
            }
            if (ObjectUtil.isNull((Object)(order = this.orderService.getByOrderNo(outTradeNo)))) {
                logger.error("ali pay error : \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728==\u300b" + outTradeNo);
                return "fail";
            }
            if (order.getPaid().booleanValue()) {
                logger.error("ali pay error : \u8ba2\u5355\u5df2\u5904\u7406==\u300b" + outTradeNo);
                return "success";
            }
            User user = (User)this.userService.getById(order.getUid());
            if (ObjectUtil.isNull((Object)user)) {
                logger.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u7528\u6237\u4fe1\u606f\u9519\u8bef\uff0cparamsJson = " + paramsJson);
                return "fail";
            }
            String tradeNo = params.get("trade_no");
            String tradeStatus = params.get("trade_status");
            String publicKey = this.systemConfigService.getValueByKey(AlipayConfig.ALIPAY_PUBLIC_KEY);
            boolean signVerified = AlipaySignature.rsaCheckV1(params, (String)publicKey, (String)AlipayConfig.CHARSET, (String)"RSA2");
            if (signVerified) {
                if (tradeStatus.equals("TRADE_FINISHED") || tradeStatus.equals("TRADE_SUCCESS")) {
                    Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                        order.setPaid(Boolean.valueOf(true));
                        order.setPayTime(CrmebDateUtil.nowDateTime());
                        order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
                        order.setUpdateTime((Date)DateUtil.date());
                        this.orderService.updateById(order);
                        this.orderFlowRecordService.orderPaid(order.getOrderNo(), order.getUid());
                        return Boolean.TRUE;
                    });
                    if (!execute.booleanValue()) {
                        logger.error("ali pay error : \u8ba2\u5355\u66f4\u65b0\u5931\u8d25==\u300b" + outTradeNo);
                        return "fail";
                    }
                    this.asyncService.orderPaySuccessSplit(order.getOrderNo());
                }
                return "success";
            }
            logger.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25\uff0csignVerified=false, paramsJson:{}", (Object)paramsJson);
            return "fail";
        }
        catch (AlipayApiException e3) {
            logger.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25,paramsJson:{},errorMsg:{}", (Object)paramsJson, (Object)e3.getMessage());
            return "fail";
        }
    }

    private void saveAliPayCallbackInfo(Map<String, String> params) {
        AliPayCallback aliPayCallback = new AliPayCallback();
        aliPayCallback.setNotifyType(params.get("notify_type"));
        aliPayCallback.setNotifyId(params.get("notify_id"));
        aliPayCallback.setAppId(params.get("app_id"));
        aliPayCallback.setCharset(params.get("charset"));
        aliPayCallback.setVersion(params.get("version"));
        aliPayCallback.setSignType(params.get("sign_type"));
        aliPayCallback.setSign(params.get("sign"));
        aliPayCallback.setTradeNo(params.get("trade_no"));
        aliPayCallback.setOutTradeNo(params.get("out_trade_no"));
        aliPayCallback.setTradeStatus(params.get("trade_status"));
        aliPayCallback.setTotalAmount(new BigDecimal(params.get("total_amount")));
        aliPayCallback.setReceiptAmount(ObjectUtil.isNotNull((Object)params.get("receipt_amount")) ? new BigDecimal(params.get("receipt_amount")) : null);
        aliPayCallback.setRefundFee(ObjectUtil.isNotNull((Object)params.get("refund_fee")) ? new BigDecimal(params.get("refund_fee")) : null);
        aliPayCallback.setSubject(params.get("subject"));
        aliPayCallback.setBody(Optional.ofNullable(params.get("body")).orElse(""));
        aliPayCallback.setPassbackParams(params.get("passback_params"));
        aliPayCallback.setNotifyTime((Date)DateUtil.parse((String)params.get("notify_time")));
        aliPayCallback.setAddTime((Date)DateUtil.date());
        this.aliPayCallbackService.save(aliPayCallback);
    }

    private Map<String, String> convertRequestParamsToMap(HttpServletRequest request) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            retMap.put(name, valueStr);
        }
        return retMap;
    }

    @Override
    public ResponseEntity<String> wechatMaRefundCallback(String notifyData, HttpServletRequest servletRequest) {
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayRefundNotifyResult wxPayRefundNotifyResult = this.wechatPayService.parseRefundNotifyResult(notifyData, "ma");
            String callback = this.wechatCommonRefundCallback(wxPayRefundNotifyResult);
            return ResponseEntity.status((int)200).body((Object)callback);
        }
        SignatureHeader header = this.getRequestHeader(servletRequest);
        try {
            WxPayRefundNotifyV3Result wxPayRefundNotifyV3Result = this.wechatPayService.parseRefundNotifyV3Result(notifyData, header, "ma");
            this.wechatCommonRefundCallbackV3(wxPayRefundNotifyV3Result);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)WxPayNotifyV3Response.fail((String)"\u9519\u8bef"));
        }
        return ResponseEntity.status((int)200).body((Object)"");
    }

    @Override
    public ResponseEntity<String> wechatMpRefundCallback(String notifyData, HttpServletRequest servletRequest) {
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayRefundNotifyResult wxPayRefundNotifyResult = this.wechatPayService.parseRefundNotifyResult(notifyData, "mp");
            String callback = this.wechatCommonRefundCallback(wxPayRefundNotifyResult);
            return ResponseEntity.status((int)200).body((Object)callback);
        }
        SignatureHeader header = this.getRequestHeader(servletRequest);
        try {
            WxPayRefundNotifyV3Result wxPayRefundNotifyV3Result = this.wechatPayService.parseRefundNotifyV3Result(notifyData, header, "mp");
            this.wechatCommonRefundCallbackV3(wxPayRefundNotifyV3Result);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)WxPayNotifyV3Response.fail((String)"\u9519\u8bef"));
        }
        return ResponseEntity.status((int)200).body((Object)"");
    }

    @Override
    public ResponseEntity<String> wechatAPPRefundCallback(String notifyData, HttpServletRequest servletRequest) {
        if ("V2".equals(this.crmebConfig.getWxPayVersion())) {
            WxPayRefundNotifyResult wxPayRefundNotifyResult = this.wechatPayService.parseRefundNotifyResult(notifyData, "app");
            String callback = this.wechatCommonRefundCallback(wxPayRefundNotifyResult);
            return ResponseEntity.status((int)200).body((Object)callback);
        }
        SignatureHeader header = this.getRequestHeader(servletRequest);
        try {
            WxPayRefundNotifyV3Result wxPayRefundNotifyV3Result = this.wechatPayService.parseRefundNotifyV3Result(notifyData, header, "app");
            this.wechatCommonRefundCallbackV3(wxPayRefundNotifyV3Result);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)WxPayNotifyV3Response.fail((String)"\u9519\u8bef"));
        }
        return ResponseEntity.status((int)200).body((Object)"");
    }

    private String wechatCommonRefundCallback(WxPayRefundNotifyResult wxPayRefundNotifyResult) {
        if (!"SUCCESS".equals(wxPayRefundNotifyResult.getReqInfo().getRefundStatus())) {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u9000\u6b3e\u72b6\u6001\u672a\u6210\u529f==>notifyResult = {}", (Object)wxPayRefundNotifyResult);
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u9000\u6b3e\u72b6\u6001\u672a\u6210\u529f==>refund_status = {}", (Object)wxPayRefundNotifyResult.getReqInfo().getRefundStatus());
            return WxPayNotifyResponse.success((String)"\u6210\u529f");
        }
        return this.wechatRefundOrderCallback(wxPayRefundNotifyResult);
    }

    private String wechatRefundOrderCallback(WxPayRefundNotifyResult wxPayRefundNotifyResult) {
        String outRefundNo = wxPayRefundNotifyResult.getReqInfo().getOutRefundNo();
        List<RefundOrder> refundOrderList = this.refundOrderService.findByOutRefundNo(outRefundNo);
        if (CollUtil.isEmpty(refundOrderList)) {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u8ba2\u5355\u67e5\u8be2\u5931\u8d25==>outRefundNo = {}, notifyResult = {}", (Object)outRefundNo, (Object)wxPayRefundNotifyResult);
            return WxPayNotifyResponse.fail((String)"\u9000\u6b3e\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
        }
        RefundOrder refundOrder = refundOrderList.get(0);
        if (refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND)) {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u8ba2\u5355\u5df2\u786e\u8ba4\u6210\u529f==>outRefundNo = {}, notifyResult = {}", (Object)outRefundNo, (Object)wxPayRefundNotifyResult);
            return WxPayNotifyResponse.success((String)"\u6210\u529f");
        }
        refundOrderList.forEach(r -> {
            r.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
            r.setUpdateTime((Date)DateUtil.date());
        });
        boolean update = this.refundOrderService.updateBatchById(refundOrderList);
        if (update) {
            refundOrderList.forEach(ro -> this.redisUtil.lPush("alterOrderRefundByUser", (Object)ro.getRefundOrderNo()));
        } else {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u8ba2\u5355\u66f4\u65b0\u5931\u8d25==>outRefundNo = {}, notifyResult = {}", (Object)outRefundNo, (Object)wxPayRefundNotifyResult);
        }
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }

    private ResponseEntity<String> wechatCommonRefundCallbackV3(WxPayRefundNotifyV3Result wxPayRefundNotifyV3Result) {
        WxPayRefundNotifyV3Result.DecryptNotifyResult decryptRes = wxPayRefundNotifyV3Result.getResult();
        if (!"SUCCESS".equals(decryptRes.getRefundStatus())) {
            return ResponseEntity.status((int)500).body((Object)WxPayNotifyV3Response.fail((String)"\u9000\u6b3e\u672a\u6210\u529f"));
        }
        this.wechatRefundOrderCallbackV3(wxPayRefundNotifyV3Result);
        return ResponseEntity.status((int)200).body((Object)"");
    }

    private void wechatRefundOrderCallbackV3(WxPayRefundNotifyV3Result wxPayRefundNotifyV3Result) {
        WxPayRefundNotifyV3Result.DecryptNotifyResult decryptRes = wxPayRefundNotifyV3Result.getResult();
        String outRefundNo = decryptRes.getOutRefundNo();
        List<RefundOrder> refundOrderList = this.refundOrderService.findByOutRefundNo(outRefundNo);
        if (CollUtil.isEmpty(refundOrderList)) {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u8ba2\u5355\u67e5\u8be2\u5931\u8d25==>outRefundNo = {}, notifyResult = {}", (Object)outRefundNo, (Object)decryptRes);
            return;
        }
        RefundOrder refundOrder = refundOrderList.get(0);
        if (refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND)) {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u8ba2\u5355\u5df2\u786e\u8ba4\u6210\u529f==>outRefundNo = {}, notifyResult = {}", (Object)outRefundNo, (Object)decryptRes);
            return;
        }
        refundOrderList.forEach(r -> {
            r.setRefundStatus(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND);
            r.setUpdateTime((Date)DateUtil.date());
        });
        boolean update = this.refundOrderService.updateBatchById(refundOrderList);
        if (update) {
            refundOrderList.forEach(ro -> this.redisUtil.lPush("alterOrderRefundByUser", (Object)ro.getRefundOrderNo()));
        } else {
            logger.error("\u5fae\u4fe1\u9000\u6b3e\u8ba2\u5355\u66f4\u65b0\u5931\u8d25==>outRefundNo = {}, notifyResult = {}", (Object)outRefundNo, (Object)decryptRes);
        }
    }

    private SignatureHeader getRequestHeader(HttpServletRequest request) {
        String signature = request.getHeader("Wechatpay-Signature");
        String nonce = request.getHeader("Wechatpay-Nonce");
        String serial = request.getHeader("Wechatpay-Serial");
        String timestamp = request.getHeader("Wechatpay-Timestamp");
        SignatureHeader signatureHeader = new SignatureHeader();
        signatureHeader.setSignature(signature);
        signatureHeader.setNonce(nonce);
        signatureHeader.setSerial(serial);
        signatureHeader.setTimeStamp(timestamp);
        return signatureHeader;
    }
}

